## Let' s Create


<!-- image -->

2024 A n nual Report


<!-- image -->

Arvind Krishna Chairman, President and Chief Executive Officer
<!-- image -->

## Dear IBM Investor:

In 2024, IBM made significant progress in becoming a higher growth, higher margin business. We made this progress by combining technology innovation and consulting expertise to drive growth, improve productivity, and enhance operational efficiency -for our clients, and our own company.

Our strategy continues to build upon the two technological foundations of AI and hybrid cloud, which clients need to unlock the full value of their data. We have made a series of investments to accelerate the delivery of that value to our clients, from transforming the way we work to reorienting our portfolio around powerful, AI-based solutions.

As this report demonstrates, these investments are paying off, delivering meaningful returns for our shareholders, clients, and partners. Today, IBM is a software-led, fully integrated platform company, built to grow sustainably. This is the ROI of IBM.

## 2024 Performance

For the year, IBM generated $62.8 billion in revenue, up 3% at constant currency, and $12.7 billion in free cash flow - an increase of $1.5 billion year-over-year. Our generative AI book of business now stands at more than $5 billion since inception. This revenue growth and cash generation enabled us to make significant investments in the business and deliver value to our shareholders. In 2024, we allocated more than $7 billion to research and development, closed 11 acquisitions to enhance our capabilities, and returned more than $6 billion


<!-- image -->

to shareholders through dividends. IBM expanded operating gross profit margin by 130 basis points in 2024, driven by a focus on high-value offerings and productivity initiatives.

Software revenue grew 9% at constant currency, reflecting strong demand for our advanced capabilities in hybrid cloud, data and AI, automation, transaction processing, and security. Red Hat performed well as clients embraced its open hybrid cloud platform.

Consulting revenue increased 1% at constant currency, demonstrating our clients' continued need for expertise in AI deployment, digital transformation, and cloud modernization, despite a dynamic market environment.

Infrastructure revenue declined 3% at constant currency, in line with product cycle expectations. IBM z16 is now the most successful mainframe program in our history, highlighting its enduring value to clients.

## Technology innovation and consulting expertise

IBM's mission to help businesses leverage technology to scale and grow profitably is more critical than ever. Technology is now the key to sustainable growth and business transformation.

At the core of these transformations is artificial intelligence. Our clients have moved beyond experimentation and are now looking to scale AI in their businesses and generate return from their investments. To achieve that return, they need access to effective, affordable, and efficient enterprise AI.

IBM has established an early leadership position in this regard, building a portfolio of enterprise AI offerings focused on generating ROI through productivity improvements and automation. IBM watsonx provides a robust portfolio of AI products for developing AI apps, managing data, and governing the entire lifecycle of AI models. AI assistants manage key tasks, including customer service and writing code. We are developing pre-built AI agents that deliver multitask reasoning for specific business domains. And our Granite family of fit-for-purpose AI models, when tuned with proprietary data, can deliver enterprise-grade generative AI with up to 90% improved cost efficiency. Granite allows clients to bring their own data into the models, and can be trained on that data in weeks, not months.

Deploying AI at scale across an enterprise requires seamless access to the data that feeds it. In this way, hybrid cloud is an essential ingredient for maximizing the return of AI investments. That is why 75% of AI deployments are expected to use containers by 2027, and demand for our hybrid cloud solutions remains strong.

Already, more than 90% of Fortune 500 companies are using IBM's hybrid cloud products and solutions. And last year, we launched two new offerings to give clients a consistent, open-source foundation for AI: Red Hat Enterprise Linux AI and OpenShift AI. Together, our AI and hybrid cloud platforms bring together the data, models, governance and monitoring capabilities needed to automate workflows and drive productivity. And they create a flywheel of growth for IBM, with each offering pulling through demand for the others.

A driving force behind this flywheel of growth is IBM Consulting, which fuels approximately 80% of our AI bookings. IBM is the only technology company with a consulting business at scale, which is a unique differentiator, especially when it comes to helping clients deploy AI. Our 160,000 consultants apply their data, AI and hybrid cloud expertise to guide business transformation for our clients. In 2024, we augmented that expertise with a new platform called IBM Consulting Advantage. By equipping our consultants with role and domain-specific AI assistants, agents, and applications, IBM Consulting Advantage enables deeper insights, faster time-to-value, and improved efficiency compared to traditional consultancy approaches.

Supporting this work is a powerful combination of processing and storage infrastructure built to handle data-intensive workloads with security and reliability. In 2024, we announced architecture details for the Telum II processor and the Spyre AI Accelerator, designed for next-generation IBM Z mainframe systems that power generative AI at scale. And our storage business continued to grow as a premier data management platform for hybrid cloud and enterprise AI, while also helping to prevent cyber-attacks.

In addition to these offerings, we continue to remix our portfolio through strategic acquisitions - such as Neural Magic, StreamSets and webMethods - to bolster our softwarebased AI and hybrid cloud capabilities.

## Our go-to-market approach

Over the last five years, we have improved the way IBM goes to market, embracing a broad ecosystem of partners, developing experiential and technical sales methods, and adopting our own technology first, before we deploy it with clients.

We are also pioneering the model of a software-led, integrated enterprise that is driving value for our clients and growth for IBM. At the end of 2024, software represented approximately 45% of IBM's total revenue. These solutions, in turn, generated demand for our full suite of integrated offerings: approximately 80% of IBM's revenue is generated by clients that buy across all three of our business segments (Software, Consulting, and Infrastructure).

Increasingly, clients come to IBM through a thriving partner ecosystem, which has been essential in helping our clients capitalize on the massive growth and transformation

opportunities presented by hybrid cloud and AI. We recognize that no single company can provide all the technology and skill needed to drive digital transformation. So, we have strengthened our strategic partnerships with key industry leaders like AWS, Microsoft, Salesforce, SAP, Palo Alto Networks, and Oracle. These partnerships serve our clients better and create a multiplier effect for IBM.

Additionally, IBM has adopted a "client zero" philosophy, meaning we benefit from the same technology solutions we offer to our clients. In particular, we have aggressively adopted AI-powered automation to drive productivity. For example, 94% of IBM's basic HR queries are now answered by an AI assistant. Our contract drafting process is now 80% faster. Overall, we have delivered approximately $3.5 billion in productivity savings since the beginning of 2023. These efforts are not just about efficiency. They are the engine of innovation and growth that allows us to invest in our business and serve our clients better.

## A new era of innovation

The mission of IBM Research has always been to invent what's next in computing - creating solutions that meet the needs of our clients, thereby defining the future of information technology. Today, Research is driving powerful innovations across hardware, software, hybrid cloud, AI, and quantum computing, all of which creates value for our clients and growth opportunities for our company.

For example, to better serve clients who told us that the large, unwieldy generative AI models on the market were too unreliable and expensive, IBM Research developed the open and trusted Granite family of models, released under the permissive Apache 2.0 license. The models deliver strong performance across many academic and enterprise benchmarks at a fraction of the cost.

Quantum computing is another example of IBM Research's leadership. We have deployed more than 70 quantum systems, with more than 250 organizations joining our IBM Quantum Network. We have also scaled the industry's best-performing quantum software with Qiskit. In 2024, we introduced the IBM Quantum Heron processor, with reduced error rates, 16 times better performance, and a 25-fold increase in speed over previous systems. We expanded our IBM Quantum Data Center in Poughkeepsie, New York and opened the first IBM Quantum Data Center in Europe

(Ehningen, Germany). We also announced a partnership with the State of Illinois to build the National Quantum Algorithm Center in Chicago and deploy a next-generation IBM Quantum System Two, supporting the future of quantum-centric supercomputing.

Going forward, IBM Research will continue to build and optimize computing architectures that allow enterprises to move and process data seamlessly between GPUs, CPUs, and QPUs, solving previously unsolvable problems for businesses and the world.

## The ROI of IBM

At IBM, we expect all investments to yield a return. That is evident in the increasing value we are delivering for our shareholders, clients, and employees.

For shareholders, we have delivered 29 consecutive years of dividend increases. And from 2022 through the end of 2024, we created greater than $100 billion in shareholder value and outperformed the S&P 500 by 58 points.

For the IBMers around the world who invest their time and talent in serving our clients and partners, the return is evident in our culture. The vast majority of our workforce recommend IBM as a great place to work and say they are proud to be IBMers. That culture is fueled, in part, by IBM's commitment to develop the skills our workforce requires to lead the next eras of technology.

As we look ahead, we will continue to drive returns and deliver on our commitment to be the catalyst that makes the world work better. We extend this simple invitation for you to join us on this journey: Let's Create.

Arvind Krishna Chairman, President and Chief Executive Officer
<!-- image -->

The returns we generate for clients are based on the value we deliver to them, and the trust they place in IBM. For example, NatWest Bank used a virtual agent built with watsonx to improve satisfaction in key areas of customer service by 150%. With the help of IBM Consulting, Cathay Pacific migrated more than 90 critical applications to the cloud with zero downtime, achieving a 70% faster time-tomarket, all while improving scalability and security. And Water Corporation modernized its computing infrastructure with a hybrid cloud model built around Red Hat, reducing operation costs by 40% and saving 1,500 hours of manual labor per year.

In an effort to provide additional and useful information regarding the company's financial results and other financial information, as determined by generally accepted accounting principles (GAAP), this letter contains non-GAAP financial measures, including revenue growth rates adjusted for constant currency, free cash flow and operating gross profit margin. The rationale for management's use of this non-GAAP information is included on page 6, 7 and 35 of the company's 2024 Annual Report, which is Exhibit 13 to the Form 10-K submitted with the SEC on February 25, 2025. For reconciliation of these non-GAAP financial measures to GAAP and other information, please refer to pages 16, 28 and 35 of the company's 2024 Annual Report. For generative AI, book of business includes Software transactional revenue, SaaS Annual Contract Value and Consulting signings. For more information regarding generative AI book of business, refer to Exhibit 99.2 of the Form 8-K submitted with the SEC on January 29, 2025.

## Report of Financials

International Business Machines Corporation and Subsidiary Companies

## MANAGEMENT DISCUSSION

## NOTES TO CONSOLIDATED FINANCIAL STATEMENTS


| Overview                                  | 6 6   |
|-------------------------------------------|-------|
| Forward-Looking and Cautionary Statements | 7 7   |
| Management Discussion Snapshot            | 8 8   |
| Description of Business                   | 11 11 |
| Year in Review                            | 16 16 |
| Prior Year in Review                      | 29 29 |
| Other Information                         | 33 33 |
| Looking Forward                           | 33 33 |
| Liquidity and Capital Resources           | 34 34 |
| Critical Accounting Estimates             | 37 37 |
| Currency Rate Fluctuations                | 39 39 |
| Market Risk                               | 40 40 |
| Financing                                 | 41 41 |
| Report of Management                      | 43 43 |
| Report of Independent Registered          |       |
| Public Accounting Firm                    | 44 44 |
| CONSOLIDATED FINANCIAL STATEMENTS         |       |
| Income Statement                          | 46 46 |
| Comprehensive Income                      | 47 47 |
| Balance Sheet                             | 48 48 |
| Cash Flows                                | 49 49 |
| Equity                                    | 50 50 |


| 6 6 Basis & Policies                           | 6 6 Basis & Policies                           |     |
|------------------------------------------------|------------------------------------------------|-----|
| 7 7 A                                          | Significant Accounting Policies                | 52  |
| 8 8 B                                          | Accounting Changes                             | 66  |
| 11 11                                          | Performance & Operations                       |     |
| 16 16 C                                        | Revenue Recognition                            | 67  |
| 29 29 D                                        | Segments                                       | 69  |
| 33 33 E                                        | Acquisitions & Divestitures                    | 74  |
| 33 33 F                                        | Other (Income) and Expense                     | 78  |
| 34 34 G                                        | Taxes                                          | 79  |
| 37 37 H                                        | Earnings Per Share                             | 82  |
| 39 39 Balance Sheet & Liquidity                | 39 39 Balance Sheet & Liquidity                |     |
| 40 40 I                                        | Financial Assets & Liabilities                 | 83  |
| 41 41 J                                        | Inventory                                      | 84  |
| K                                              | Financing Receivables                          | 84  |
| 43 43 L                                        | Property, Plant & Equipment                    | 87  |
| M                                              | Leases                                         | 87  |
| 44 44 N                                        | Intangible Assets Including Goodwill           | 90  |
| O                                              | Borrowings                                     | 91  |
| P                                              | Other Liabilities                              | 94  |
| 46 46 Q                                        | Commitments & Contingencies                    | 95  |
| 47 47 R                                        | Equity Activity                                | 98  |
| Risk Management, Compensation/Benefits & Other | Risk Management, Compensation/Benefits & Other |     |
| 49 49 S                                        | Derivative Financial Instruments               | 100 |
| 50 50 T                                        | Stock-Based Compensation                       | 105 |
| U                                              | Retirement-Related Benefits                    | 108 |
| V                                              | Subsequent Events                              | 121 |


| Performance Graphs                       |   122 |
|------------------------------------------|-------|
| Stockholder Information                  |   123 |
| Board of Directors and Senior Leadership |   124 |

## 6 Management Discussion

International Business Machines Corporation and Subsidiary Companies

## OVERVIEW

The financial section of the International Business Machines Corporation (IBM or "the company") 2024 Annual Report includes the Management Discussion, the Consolidated Financial Statements and the Notes to Consolidated Financial Statements. This Overview is designed to provide the reader with some perspective regarding the information contained in the financial section.

## Organization of Information

· The Management Discussion is designed to provide readers with an overview of the business and a narrative on our financial results and certain factors that may affect our future prospects from the perspective of management. The "Management Discussion Snapshot" presents an overview of the key performance drivers in 2024.

· Beginning with the "Year in Review," the Management Discussion contains the results of operations for each reportable segment of the business, a discussion of our financial position and a discussion of cash flows as reflected in the Consolidated Statement of Cash Flows. "Prior Year in Review," provides a summary of our reportable segment results and year-to-year comparisons between 2023 and 2022. These segment results have been recast to conform to our organizational structure and management system changes described below. Management Discussion also includes: "Looking Forward" and "Liquidity and Capital Resources," the latter of which includes a description of management's definition and use of free cash flow.

· The Consolidated Financial Statements provide an overview of income and cash flow performance and financial position.

· The Notes follow the Consolidated Financial Statements. Among other items, the Notes contain our accounting policies, revenue information, acquisitions and divestitures, certain commitments and contingencies and retirement-related plans information.

· In the first quarter of 2024, we made changes to our organizational structure and management system to better align our portfolio to the market, increase transparency and improve segment comparability to peers. These changes did not impact our Consolidated Financial Statements, but did impact our reportable segments. The segments are reported on a comparable basis for all periods. In addition, due to the removal of certain components of segment profitability we also updated the title of our segment performance metric from pre-tax income from continuing operations to segment profit. Refer to note D, "Segments" for additional information on our reportable segments.

· Over the past several years, we have taken actions to reduce the risk profile of our worldwide retirement-related plans, while at the same time increasing the funded status of the plans. In 2022 and 2024, non-participating single group annuity contracts were purchased from insurers which irrevocably transferred to the insurers certain defined benefit ("DB") pension obligations and related plan assets. There were no changes to the amount of benefits payable to the participants and beneficiaries of the plans transferred. These pension transfers reduced our pension obligations and assets by approximately the same amount and were purchased using assets from their respective retirement plans with no additional funding contributions required from IBM. Each transaction resulted in the recognition of a one-time, non-operating, non-cash, pre-tax pension settlement charge ("pension settlement charge") in the respective period of the pension transfer. In September 2022, the IBM Personal Pension Plan ("Qualified PPP") irrevocably transferred to insurers approximately $16 billion of the Qualified PPP's DB pension obligations and related plan assets, resulting in a pension settlement charge of $5.9 billion ($4.4 billion net of tax) in the third quarter of 2022. In September 2024, the Qualified PPP irrevocably transferred to an insurer approximately $6 billion of the Qualified PPP's DB pension obligations and related plan assets, resulting in a pension settlement charge of $2.7 billion ($2.0 billion net of tax) in the third quarter of 2024. In October 2024, IBM Canada LTD ("IBMC") irrevocably transferred to insurers approximately $1.2 billion of the IBMC IBM Retirement Plan DB pension obligations and related plan assets, resulting in a pension settlement charge of $0.4 billion in the fourth quarter of 2024. These pension settlement charges were primarily related to the accelerated recognition of accumulated actuarial losses of the plans and, given they were non-operating and non-cash, they did not impact our operating (non-GAAP) earnings or cash flow results. Refer to note U, "Retirement-Related Benefits," for additional information.

· The references to "adjusted for currency" or "at constant currency" in the Management Discussion do not include operational impacts that could result from fluctuations in foreign currency rates. When we refer to growth rates at constant currency or adjust such growth rates for currency, it is done so that certain financial results can be viewed without the impact of fluctuations in foreign currency exchange rates, thereby facilitating period-to-period comparisons of business performance. Financial results adjusted for currency are calculated by translating current period activity in local currency using the comparable prior-year period's currency conversion rate. This approach is used for countries where the functional currency is the local currency. Generally, when the dollar either strengthens or weakens against other currencies, the growth at constant currency rates or adjusting for currency will be higher or lower than growth reported at actual exchange rates. Refer to "Currency Rate Fluctuations" for additional information.

· Within the financial statements and tables in this Annual Report, certain columns and rows may not add due to the use of rounded numbers for disclosure purposes. Percentages presented are calculated from the underlying whole-dollar numbers. Certain prior-year amounts have been reclassified to conform to the change in current year presentation. This is annotated where applicable.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## Operating (non-GAAP) Earnings

In an effort to provide better transparency into the operational results of the business, supplementally, management separates business results into operating and non-operating categories. Operating earnings from continuing operations is a non-GAAP measure that excludes the effects of certain acquisition-related charges and intangible asset amortization, expense resulting from basis differences on equity method investments, retirement-related costs, certain impacts from the Kyndryl separation and their related tax impacts. Due to the unique, non-recurring nature of the enactment of the U.S. Tax Cuts and Jobs Act (U.S. tax reform), management characterizes the one-time provisional charge recorded in the fourth quarter of 2017 and adjustments to that charge as non-operating. Adjustments primarily include true-ups, accounting elections and any changes to regulations, laws or audit adjustments that affect the recorded one-time charge. Management characterized direct and incremental charges incurred related to the Kyndryl separation as non-operating given their unique and non-recurring nature. In 2022, these charges primarily related to any net gains or losses on the Kyndryl common stock and the related cash-settled swap with a third-party financial institution, which were recorded in other (income) and expense in the Consolidated Income Statement. As of November 2, 2022, the company no longer held an ownership interest in Kyndryl. For acquisitions, operating (non-GAAP) earnings exclude the amortization of purchased intangible assets and acquisition-related charges such as in-process research and development, transaction costs, applicable retention, restructuring and related expenses, tax charges related to acquisition integration and pre-closing charges, such as financing costs. These charges are excluded as they may be inconsistent in amount and timing from period to period and are significantly impacted by the size, type and frequency of our acquisitions. Management has also characterized as non-operating expense, given its unique and temporary nature, the mark-to-market impact on the foreign exchange derivative contracts entered into prior to the acquisition of StreamSets and webMethods from Software AG, beginning in December 2023, to economically hedge the foreign currency exposure related to the purchase price of this acquisition. These derivative contracts expired by June 28, 2024. This impact was recorded in other (income) and expense in the Consolidated Income Statement and reflects the changes in fair value of these derivative contracts. All other spending for acquired businesses is included in both earnings from continuing operations and in operating (non-GAAP) earnings. For retirement-related costs, management characterizes certain items as operating and others as non-operating, consistent with GAAP. We include defined benefit plan and nonpension postretirement benefit plan service costs, multi-employer plan costs and the cost of defined contribution plans in operating earnings. Nonoperating retirement-related costs include defined benefit plan and nonpension postretirement benefit plan amortization of prior service costs, interest cost, expected return on plan assets, amortized actuarial gains/losses, the impacts of any plan curtailments/ settlements including the impact of the pension settlement charges of $3.1 billion ($2.4 billion net of tax) and $5.9 billion ($4.4 billion net of tax) in 2024 and 2022, respectively. Refer to note U, "Retirement-Related Benefits," for additional information. Nonoperating retirement-related costs are primarily related to changes in pension plan assets and liabilities which are tied to financial market performance, and we consider these costs to be outside of the operational performance of the business.

Overall, management believes that supplementally providing investors with a view of operating earnings as described above provides increased transparency and clarity into both the operational results of the business and the performance of our pension plans; improves visibility to management decisions and their impacts on operational performance; enables better comparison to peer companies; and allows us to provide a long-term strategic view of the business going forward. In addition, these non-GAAP measures provide a perspective consistent with areas of interest we routinely receive from investors and analysts.

## FORWARD-LOOKING AND CAUTIONARY STATEMENTS

Certain statements contained in this Annual Report may constitute forward-looking statements within the meaning of the Private Securities Litigation Reform Act of 1995. Any forward-looking statement in this Annual Report speaks only as of the date on which it is made; IBM assumes no obligation to update or revise any such statements except as required by law. Forward-looking statements are based on IBM's current assumptions regarding future business and financial performance; these statements, by their nature, address matters that are uncertain to different degrees. Forward-looking statements involve a number of risks, uncertainties and other factors that could cause actual results to be materially different, as discussed more fully elsewhere in this Annual Report and in the company's filings with the Securities and Exchange Commission (SEC), including IBM's 2024 Form 10-K filed on February 25, 2025.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## MANAGEMENT DISCUSSION SNAPSHOT

($ and shares in millions except per share amounts)


| For year ended December 31:                                          | 2024  (2)   | 2023       | Yr.-to-Yr.  Percent/Margin  Change   |
|----------------------------------------------------------------------|-------------|------------|--------------------------------------|
| Revenue  (1)                                                         | $  62,753   | $  61,860  | 1.4 %                                |
| Gross profit margin                                                  | 56.7 %      | 55.4 %     | 1.2 pts.                             |
| Total expense and other (income)                                     | $  29,754   | $  25,610  | 16.2 %                               |
| Income from continuing operations before income taxes                | $  5,797    | $  8,690   | (33.3) %                             |
| Provision for/(benefit from) income taxes from continuing operations | $  (218)    | $  1,176   | NM                                   |
| Income from continuing operations                                    | $  6,015    | $  7,514   | (19.9) %                             |
| Income from continuing operations margin                             | 9.6 %       | 12.1 %     | (2.6) pts.                           |
| Income/(Loss) from discontinued operations, net of tax               | $  8        | $  (12)    | NM                                   |
| Net income                                                           | $  6,023    | $  7,502   | (19.7) %                             |
| Earnings per share from continuing operations-assuming dilution      | $  6.42     | $  8.15    | (21.2) %                             |
| Consolidated earnings per share-assuming dilution                    | $  6.43     | $  8.14    | (21.0) %                             |
| Weighted-average shares outstanding-assuming dilution                | $  937.2    | $  922.1   | 1.6 %                                |
| Assets  (3)                                                          | $  137,175  | $  135,241 | 1.4 %                                |
| Liabilities  (3)                                                     | $  109,783  | $  112,628 | (2.5) %                              |
| Equity  (3)                                                          | $  27,393   | $  22,613  | 21.1 %                               |

(1) Year-to-year revenue growth of 3 percent adjusted for currency.

(2) 2024 includes the impact of pension settlement charges of $3.1 billion ($2.4 billion net of tax) resulting in an impact of ($2.57) to diluted earnings per share from continuing operations and an impact of ($2.56) to consolidated diluted earnings per share. Refer to note U, "Retirement-Related Benefits," for additional information.

(3) At December 31.

NM-Not meaningful

The following table provides the company's operating (non-GAAP) earnings for 2024 and 2023. Refer to page 28 for additional information.

($ in millions except per share amounts)


| For year ended December 31:                            | 2024     | 2023     | Yr.-to-Yr. Percent Change   |
|--------------------------------------------------------|----------|----------|-----------------------------|
| Net income as reported  (1)                            | $  6,023 | $  7,502 | (19.7) %                    |
| Income/(Loss) from discontinued operations, net of tax | 8        | (12)     | NM                          |
| Income from continuing operations  (1)                 | $  6,015 | $  7,514 | (19.9) %                    |
| Non-operating adjustments (net of tax)                 |          |          |                             |
| Acquisition-related charges                            | 1,456    | 1,292    | 12.7 %                      |
| Non-operating retirement-related costs/(income)  (1)   | 2,668    | (30)     | NM                          |
| U.S. tax reform impacts                                | (455)    | 95       | NM                          |
| Operating (non-GAAP) earnings                          | $  9,684 | $  8,870 | 9.2 %                       |
| Diluted operating (non-GAAP) earnings per share        | $  10.33 | $  9.62  | 7.4 %                       |

(1) 2024 includes the impact of pension settlement charges of $2.4 billion net of tax. Refer to note U, "Retirement-Related Benefits," for additional information.

NM-Not meaningful

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## Macroeconomic Environment

Our business portfolio underpinned by advanced technology and deep consulting expertise positions us uniquely to deliver end-toend business transformations. Our diversification across geographies, industries, clients and business mix and our recurring revenue base provides some stability in revenue, profit and cash generation. Clients and partners continue to leverage technology to allow businesses to scale, drive efficiencies and fuel sustainable and profitable growth. The economic headwinds driven by factors such as geopolitical tensions, interest rate volatility, supply chain vulnerabilities, demographic shifts and evolving cyber threats are leading clients to manage their discretionary spending, which has impacted certain areas of our Consulting business during 2024.

For the year ended December 31, 2024, movements in global currencies continued to impact our reported year-to-year revenue and profit. We execute hedging programs which defer, but do not eliminate, the impact of currency. The (gains)/losses from these hedging programs are reflected primarily in other (income) and expense. Refer to "Currency Rate Fluctuations," for additional information.

## Financial Performance Summary

In 2024, we reported $62.8 billion in revenue, income from continuing operations of $6.0 billion, which includes the impact of the pension settlement charges of $3.1 billion ($2.4 billion net of tax), and operating (non-GAAP) earnings of $9.7 billion, which excludes the impact of the pension settlement charges. Refer to "Organization of Information," for additional information. Diluted earnings per share from continuing operations was $6.42 as reported, including an impact of $2.57 from the pension settlement charges, and diluted earnings per share was $10.33 on an operating (non-GAAP) basis. We generated $13.4 billion in cash from operations and $12.7 billion in free cash flow, and returned $6.1 billion to shareholders in dividends. We are pleased with the progress we made in 2024, delivering revenue growth in our re-positioned business and strong cash flow generation. Our 2024 performance demonstrates the success of our focused strategy, enhanced portfolio and sustainable revenue growth. We increased our investment in innovation and talent and completed eleven acquisitions in 2024, strengthening our hybrid cloud and AI capabilities, all while continuing to return value to shareholders through our dividend.

Total revenue grew 1.4 percent year to year as reported and 3 percent adjusted for currency compared to the prior year, led by our Software performance. Software revenue increased 8.3 percent as reported and 9.0 percent adjusted for currency, with strength across our portfolio. Hybrid Platform & Solutions increased 8.1 percent as reported and 8.7 percent adjusted for currency, reflecting growth across all lines of business with double-digit revenue growth in Red Hat and Automation. Transaction Processing increased 8.7 percent as reported and 9.6 percent adjusted for currency, with growth in both recurring and transactional revenue. Consulting revenue decreased 0.9 percent as reported but grew 0.6 percent adjusted for currency, and continued to be impacted by a dynamic market environment as clients reprioritized spending. Infrastructure decreased 3.9 percent year to year as reported and 2.7 percent adjusted for currency, reflecting product cycle dynamics.

From a geographic perspective, Americas revenue decreased 1.3 percent year to year as reported (0.7 percent adjusted for currency). Europe/Middle East/Africa (EMEA) increased 5.1 percent as reported (4.7 percent adjusted for currency). Asia Pacific grew 3.0 percent as reported (7.9 percent adjusted for currency).

Gross margin of 56.7 percent increased 1.2 points year to year, with continued margin expansion driven by portfolio mix and ongoing productivity initiatives. Operating (non-GAAP) gross margin of 57.8 percent increased 1.3 points versus the prior year, due to the same dynamics.

Total expense and other (income) increased 16.2 percent in 2024 versus the prior year primarily driven by the pension settlement charges of $3.1 billion in 2024, higher spending reflecting our continued investment in portfolio innovation to drive our strategy and higher workforce rebalancing charges. This was partially offset by a gain from the sale of certain QRadar Software-as-a-Service (SaaS) assets, the gain on the divestiture of The Weather Company assets, the benefits from productivity and the actions taken to transform our operations, and the effects of currency. Total operating (non-GAAP) expense and other (income) increased 1.8 percent year to year, driven primarily by the factors described above, excluding the pension settlement charges.

Pre-tax income from continuing operations was $5.8 billion in 2024 compared with $8.7 billion in the prior year and pre-tax margin was 9.2 percent, a decrease of 4.8 points versus 2023. The year-to-year performance was primarily driven by the pension settlement charges in 2024 partially offset by our gross margin expansion and the benefits from productivity and the actions taken to transform our operations which enabled investments to drive innovation. The continuing operations effective tax rate for 2024 was (3.8) percent compared to 13.5 percent in 2023. The current-year effective tax rate was primarily driven by the tax impact of the pension settlement charges and the resolution of certain tax audit matters. Net income from continuing operations was $6.0 billion in 2024 compared with $7.5 billion in the prior year and net income from continuing operations margin was 9.6 percent, a decrease of 2.6 points year to year. Operating (non-GAAP) pre-tax income from continuing operations of $11.2 billion increased 8.7 percent year to year and the operating (non-GAAP) pre-tax margin from continuing operations increased 1.2 points to 17.9 percent. Our revenue growth, portfolio mix and productivity initiatives resulted in strong operating (non-GAAP) pre-tax income growth in 2024 compared to the prior year. The operating (non-GAAP) effective tax rate for 2024 was 13.6 percent compared to 14.0 percent

## 10 Management Discussion

International Business Machines Corporation and Subsidiary Companies

in 2023. Operating (non-GAAP) income from continuing operations of $9.7 billion increased 9.2 percent and the operating (nonGAAP) income margin from continuing operations of 15.4 percent was up 1.1 points year to year.

Diluted earnings per share from continuing operations, which included an impact of $2.57 from the pension settlement charges, was $6.42 in 2024 compared with $8.15 in 2023. Operating (non-GAAP) diluted earnings per share of $10.33 increased 7.4 percent versus 2023.

At December 31, 2024, the balance sheet remained strong with financial flexibility to support and invest in the business. Cash and cash equivalents, restricted cash and marketable securities at year end were $14.8 billion, an increase of $1.3 billion from December 31, 2023. During 2024, we invested $3.3 billion in acquisitions and returned $6.1 billion to shareholders through dividends. Total debt of $55.0 billion at December 31, 2024 decreased $1.6 billion driven by maturities partially offset by debt issuances.

Total assets increased $1.9 billion ($5.2 billion adjusted for currency) from December 31, 2023 primarily driven by an increase in goodwill mainly related to the StreamSets and webMethods acquisition, and higher cash and cash equivalents. Total liabilities decreased $2.8 billion (increased $0.5 billion adjusted for currency) from December 31, 2023 primarily driven by a decrease in debt and postretirement benefit obligations partially offset by an increase in deferred income. Total equity of $27.4 billion increased $4.8 billion from December 31, 2023, primarily driven by net income, common stock issuances and a decrease in accumulated other comprehensive loss; partially offset by dividends.

During 2024, we generated $13.4 billion in cash from operating activities, compared to $13.9 billion in 2023. While cash provided by financing receivables declined year to year from business variability, we had performance-related improvements within net income driving an increase within cash from operating activities. Our free cash flow was $12.7 billion, an increase of $1.5 billion versus the prior year. Refer to page 35 for additional information on free cash flow. Net cash used in investing activities of $4.9 billion decreased $2.1 billion compared to the prior year, mainly driven by a decrease in cash used in acquisitions, higher cash provided by divestitures and the proceeds from the sale of certain QRadar SaaS assets; partially offset by higher net purchases of marketable securities and other investments. Net cash used in financing activities of $7.1 billion increased $5.3 billion compared to 2023, mainly due to a lower level of debt issuances and a higher level of maturities in the current year.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## DESCRIPTION OF BUSINESS

Please refer to IBM's Annual Report on Form 10-K filed with the SEC on February 25, 2025, for Item 1A. entitled "Risk Factors."

IBM is addressing the hybrid cloud and AI opportunity with a platform-centric approach, focused on providing client value through a combination of technology and business expertise. We provide integrated solutions and products that leverage: data, information technology, deep expertise in industries and business processes, with trust and security and a broad ecosystem of partners and alliances. Our hybrid cloud platform and AI technology and services capabilities support clients' digital transformations and help them engage with their customers and employees in new ways. These solutions draw from an industry-leading portfolio of capabilities in software, consulting services and a deep incumbency in mission-critical systems, all bolstered by one of the world's leading research organizations.

## IBM Strategy

Over the past 5 years, IBM has shifted to higher growth areas, with approximately 75 percent of our business mix in Software and Consulting. Our strategic focus is hybrid cloud and artificial intelligence (AI), today's most transformative technologies. As clients drive business growth using their existing technology and investing in new ones, they seek flexibility across distributed technology environments and the need to realize value from AI. We have shaped our business to focus on those client needs.

## Our strategy aligns with the needs of our clients

Companies are increasingly deploying technology workloads across environments where the business runs, with over 90 percent of executives reporting moving to hybrid cloud architectures (IBM IBV). As organizations continue to face innovation challenges, including increased technical complexity, rapidly growing costs, and scarcity of expertise, AI is an opportunity to unlock unrealized value. However, AI brings similar challenges, including costs of AI models, complexity of AI solutions and its governance, and expertise gaps in integrating AI solutions into business workflows.

To solve these innovation challenges, leading organizations are embracing a hybrid 'by design' platform approach. It allows them to take advantage of hybrid multi-cloud by minimizing cost and complexity which simplifies innovation and operations. IBM Consulting has quantified the value of a hybrid by design approach and shown it delivers over three times higher return on investment.

Companies continue to invest in AI and are looking for better approaches to drive enterprise AI adoption. AI is inherently hybrid as it needs to inference, govern, and manage across multiple environments. Conversely, AI simplifies the complexity of hybrid cloud environments through visibility, resource optimization, and automation across platforms and processes.

IBM is strategically positioned to help clients unlock their next chapter of technology-led business growth. It will be built across hybrid multi-cloud and leverage AI. With our portfolio of technology and consulting capabilities, we uniquely help deliver that growth.

## IBM's differentiated portfolio value

IBM Software makes technology that delivers innovation and productivity with capabilities to enable end-to-end enterprise use cases, client usage, consumption, and expansion. We deliver this value in four major areas: Transaction Processing, powering IBM Z to deliver unmatched scalability, security, availability and real-time fraud detection for our client's mission-critical workloads; Automation, boosting application performance and optimizing costs across clients' technology operations and reducing overall complexity; Data, accelerating productivity by infusing AI at scale into applications and business processes to drive decisions in real-time; Hybrid cloud platform (Red Hat), unifying on-prem, public and private clouds, and the edge to scale applications and AI models across environments. All capabilities support hybrid cloud deployment and have security and AI embedded throughout.

IBM Consulting provides strategy & technology and intelligent operations services to address clients' most challenging business goals - including how to be more productive, accelerate growth, and drive innovation. We deliver domain expertise to drive client adoption through our offerings, leveraging hybrid cloud and AI technologies from IBM Software and with strategic partners including AWS, Microsoft, Oracle, SAP, and many others across the ecosystem. IBM Consulting brings speed and scale to innovative solutions that combine industry, domain, and hybrid cloud knowledge together with AI-powered assets, such as IBM Consulting Advantage, a first of its kind AI delivery platform designed to deliver solutions at scale and realize faster time to value, transforming how our consultants work.

IBM Infrastructure enables hybrid cloud environments for mission-critical transactions and AI workloads, while maintaining the highest security and availability. The business is anchored by IBM Z which excels at delivering transaction processing capability with an industry-first integrated on-chip AI accelerator designed for high-speed, latency-optimized inferencing to deliver unmatched throughput, availability, and security. Our distributed infrastructure offerings, Power, Storage, and Cloud, accelerate client's digital transformations while our Infrastructure Support delivers lifecycle services enhanced with AI to optimize hybrid cloud environments.

## 12 Management Discussion

International Business Machines Corporation and Subsidiary Companies

In support for each business segment, our AI strategy focuses on four key differentiators to help address adoption and challenges: Open, Cost Efficient, Hybrid and Domain Expertise, which we deliver across our portfolio. We enable cheaper inferencing built for hybrid cloud architectures with our Red Hat AI portfolio. We provide small, open Granite models that deliver better performance at a fraction of the price. We embed domain expertise in our models, technologies, and consulting offerings to speed client adoption and value.

IBM Research continues to demonstrate the ability to transition research to market-ready solutions; reinventing how work gets done and building on its legacy of transforming innovation in computing into client-grade solutions. In 2024, we continued to innovate around hybrid cloud and AI which created new business opportunities for IBM, including Granite 3.0 models and InstructLab. In quantum computing, we continue to progress along our Quantum Development & Innovation Roadmap, including the release of the Heron quantum chip and launch of Qiskit 1.0 software development kit.

In addition to organic innovation, we accelerate our strategy and client value with inorganic investments . Areas of focus include hybrid cloud, data, and AI technology along with strategic consulting capabilities. In 2024 IBM closed multiple deals, the most material being the acquisition of assets from Software AG to bolster our automation, data and AI portfolios, and Neural Magic to fuel optimized generative AI innovation across hybrid cloud. Additionally, we announced our intention to acquire HashiCorp, adding advanced capabilities in hybrid multi-cloud infrastructure automation and orchestration.

Hybrid cloud and AI together have the power to unleash business productivity . IBM can bring hybrid cloud and AI to life for clients through our portfolio across the various business segments. Each of our business segments contribute to and benefit from the hybrid cloud and AI strategy. Clients realize greater value when complementary parts of the portfolio come together. For example, within Consulting, we have the world's largest Red Hat practice differentiated with hybrid by design methodologies, with Consulting Advantage used to leverage AI across every stage of the project lifecycle. In IBM Z, watsonx code assistant for Z uses AI to accelerate modernization journeys, delivering more value to clients.

## Collaborating to create value with clients and ecosystem partners

Building our ecosystem is core to our overall strategy, focusing on helping clients transform their core operations and create new sources of competitive advantage through the application of AI and hybrid cloud technologies. Our approach to client engagement allows us to meet clients where they are. We bring our next-generation innovations and core platforms to a wide range of clients and partners through our signature THINK event tour and IBM TechXchange conference. The Partner Plus program makes it easy for partners to deepen technical expertise on IBM products, allowing clients more choice on who to partner with. Additionally, we continue to co-invest with our strategic partners - Adobe, AWS, Microsoft, Oracle, Palo Alto Networks, Salesforce, SAP, ServiceNow - to amplify joint impact for our clients by embedding IBM technology into core platforms that run their businesses.

We also bring product innovations to clients through use cases, our internal "client zero" productivity proof points, and technical experiences to demonstrate the value of our technology as a source of competitive advantage. For example, we have resolved 94 percent of low-level HR inquiries with our AskHR assistant, built on watsonx, freeing up HR professionals to focus on more complex issues. We believe that being a client zero exemplar accelerates our product roadmap and commercial success in addition to delivering productivity to the business.

## Business Segments and Capabilities

IBM operates in more than 175 countries around the world. Our platform-centric hybrid cloud and AI strategy is executed through our operations and consists of four business segments: Software, Consulting, Infrastructure and Financing.

In the first quarter of 2025, we announced changes to the reported revenue categories within our Software and Consulting reportable segments effective January 1, 2025. These changes will not impact our Consolidated Financial Statements or our reportable segments. Refer to "Looking Forward," for additional information.

## Software

Software provides software solutions that address client needs for a hybrid cloud platform, data and AI, automation, and security on their journey to hybrid cloud. It includes all software, except operating system software reported in the Infrastructure segment.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

Software comprises two business areas - Hybrid Platform & Solutions and Transaction Processing, which have the following capabilities:

Hybrid Platform & Solutions: includes software, infused with AI, to help clients operate, manage and optimize their IT resources and business processes within hybrid, multi-cloud environments. It includes the following:

Red Hat: provides enterprise open-source solutions, for hybrid, multi-cloud environments, which includes Red Hat Enterprise Linux (RHEL), OpenShift, our hybrid cloud platform, as well as Ansible.

Automation: optimizes processes from business workflows to IT operations with AI-powered automation. Automation includes software for business automation, IT automation, integration and application runtimes.

Data & AI: accelerates data-driven agendas by infusing AI throughout the enterprise, empowering intelligent decision making. The portfolio includes capabilities that simplify data consumption through data fabric with data management, optimize lifecycle management, and make better predictions through business analytics. Data & AI capabilities facilitate sustainable, resilient businesses and enable intelligent management of enterprise assets and supply chains with environmental intelligence.

Security: creates a risk-aware, secure business by gaining real-time threat insights, orchestrating actions and automating responses across all touchpoints, in line with a zero-trust security strategy. Security includes software for data security, identity and access management, and threat management.

Transaction Processing: supports clients' mission-critical, on-premise workloads in industries such as banking, airlines and retail. This includes transaction processing software such as Customer Information Control System and storage software, as well as the analytics and integration software running on IBM operating systems such as DB2 and WebSphere running on z/OS.

## Consulting

Consulting provides deep domain, technical, and industry expertise and market-leading capabilities in business transformation, technology implementation and managed services, including cloud managed and application services. Consulting designs, builds and operates technology and business processes based on open, hybrid cloud architectures leveraging the power of generative AI, with IBM technology and ecosystem partner technologies. Consulting uses its IBM Garage method and assets deployed through IBM Consulting Advantage to convene experts to co-create solutions with clients to accelerate their digital transformations through AI and automation.

Consulting comprises three business areas - Business Transformation, Technology Consulting and Application Operations, which have the following capabilities:

Business Transformation: provides strategy, process design, system implementation and operations services to improve and transform key experiences and business processes. These services deploy AI and automation in business processes to exploit the value of data and include an ecosystem of partners alongside IBM technology, including strategic partnerships with Adobe, Oracle, Salesforce and SAP, among others.

Technology Consulting: helps clients architect and implement solutions securely across cloud platforms, including Amazon, Microsoft, Palo Alto Networks, and IBM, and deploy strategies to transform the enterprise experience and enable innovation, including data transformation for AI with watsonx and application modernization for hybrid cloud with Red Hat OpenShift.

Application Operations: focuses on managing, optimizing, orchestrating, and securing custom application and ISV packages for clients. Services include application management, platform engineering, and security services across hybrid cloud environments.

## Infrastructure

Infrastructure provides trusted and secure solutions for hybrid cloud and is optimized for infusing AI into mission-critical transactions.

Infrastructure comprises two business areas - Hybrid Infrastructure and Infrastructure Support, which have the following capabilities:

Hybrid Infrastructure: provides clients with innovative infrastructure platforms to help meet the new requirements of hybrid multicloud and enterprise AI workloads leveraging flexible and as-a-service consumption models. Hybrid Infrastructure includes IBM Z and Distributed Infrastructure.

## 14 Management Discussion

International Business Machines Corporation and Subsidiary Companies

IBM Z: the premier transaction processing platform with leading security, resilience and scale, highly optimized for mission-critical, high-volume transaction workloads and enabled for enterprise AI and hybrid cloud. It includes IBM Z and LinuxONE, with a range of high-performance systems designed to address enterprise computing capacity, security and performance needs, z/OS, a securityrich, high-performance enterprise operating system, as well as Linux and other operating systems.

Distributed Infrastructure: includes Power, Storage and IBM Cloud Infrastructure-as-a-Service (IaaS). Power consists of highperformance servers, designed and engineered for data intensive and AI-enabled workloads and optimized for hybrid cloud and Linux. The Storage portfolio consists of a broad range of storage hardware and software-defined offerings, including Z-attach and distributed flash, tape solutions, software-defined storage controllers, data protection software and network-attach storage. IBM Cloud IaaS is built on enterprise-grade hardware with leading security and compliance capabilities and offers flexible computing options across architectures to meet client workload needs.

Infrastructure Support: delivers comprehensive, proactive and AI-enabled maintenance and support services to maintain and improve the availability and value of clients' IT infrastructure (hardware and software) both on-premises and in the cloud including maintenance for IBM products and other technology products.

## Financing

Financing facilitates IBM clients' acquisition of hardware, software and services through its financing solutions. The financing arrangements are predominantly for products or services that are critical to the end users' business operations and support IBM's hybrid cloud and AI strategy. Financing conducts a comprehensive credit evaluation of its clients prior to extending financing. As a captive financier, Financing has the benefit of both deep knowledge of its client base and a clear insight into the products and services financed. These factors allow the business to effectively manage two of the primary risks associated with financing, credit and residual value, while generating strong returns on equity.

Financing comprises the following two business areas - Client Financing and Commercial Financing:

Client Financing: lease, installment payment plan and loan financing to end-user clients for terms generally up to seven years. Assets financed are primarily new and used IBM hardware, software and services.

Commercial Financing: short-term working capital financing to business partners and distributors primarily of IBM products and services. The company has an existing agreement with a third-party investor to sell IBM short-term commercial financing receivables on a revolving basis. Refer to note K, "Financing Receivables," for additional information.

## Human Capital

## Employees and Related Workforce


|                                 |   (In thousands) |
|---------------------------------|------------------|
| For the year ended December 31: |           2024   |
| IBM/wholly owned subsidiaries   |            270.3 |
| Complementary  (1)              |             14.2 |

(1) The complementary workforce is an approximation of equivalent full-time employees hired under temporary, part-time and limited-term employment arrangements to meet specific business needs in a flexible and cost-effective manner.

As a globally integrated enterprise, IBM operates in more than 175 countries. Our highly skilled global workforce is reflective of the work we do for clients in support of their digital transformations and mission-critical operations through our focus on hybrid cloud and AI. Our employees are among the world's leading experts in hybrid cloud, AI, quantum computing, cybersecurity and industryspecific solutions. We believe our success depends on the caliber of our talent and the engagement and inclusion of IBMers in the workplace.

## Talent, Skills and Culture

At IBM, we're committed to attracting, developing and retaining top talent in a dynamic and competitive environment. Our employee value proposition offers a compelling combination of competitive compensation and exciting career opportunities in the development and delivery of innovative technologies that transform businesses worldwide. Our value proposition and talent strategy are designed to retain our talented professionals.

We are continuously transforming and developing our talent through a combination of learning and hiring. In 2024, we focused on adding skills in key areas such as consulting and technical expertise, while also scaling our capacity in strategically important markets. We're committed to upskilling and reskilling our workforce, and our digital learning and career platforms are designed to provide employees with the resources they need to build strategic skills and advance their careers. We believe that sharing candid

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

feedback is essential to helping our employees develop their skills and elevate their performance, which is critical to our ability to transform and evolve.

Employee engagement is a key indicator of employee well-being and dedication to our mission, purpose and values. We conduct an annual engagement survey to assess the health of our growth culture and employee sentiment. In 2024, over 200,000 employees globally participated in the survey, providing valuable insights that we are using to enhance the employee experience, transform our culture, and improve our interactions with clients and partners. For the fourth year in a row, more than eight out of ten employees who participated in the survey responded that they felt engaged at work, a testament to our industry-leading talent practices.

An inclusive workplace serves as a catalyst for heightened innovation, agility, and overall performance. This environment fuels business growth, sustainable business outcomes and differentiated value to our clients. This is evident in our ability to attract and retain some of the industry's most skilled and talented individuals. Our goal is to ensure individuals from all backgrounds feel a sense of belonging, nurture their talents and advance in their careers. We strive to help all employees build new capabilities, explore various career paths, and engage with mentors to progress in their professional journeys. Once again, our efforts have resulted in nearly nine out of ten of employees who participated in the engagement survey feeling empowered to be their authentic selves at work.

We are committed to pay equity and transparency, fostering an environment of equal pay for equal work regardless of gender, race, or other personal characteristics. Statistical pay equity assessments are conducted across all countries with IBM employees, reinforcing our dedication to our longstanding pay equity practice.

## Health, Safety and Well-Being

IBM demonstrates an unwavering commitment to fostering a culture of health, safety, and well-being for its employees. This commitment is reflected in our comprehensive Health & Safety Management System (HSMS), which is externally certified and aims to create a healthy and safe work environment, minimize work-related injuries and illnesses, and empower our workforce to take an active role in managing health and safety risks.

Recognizing employees as our most valuable asset, we have seamlessly integrated well-being into every facet of our business operations. We believe that our employees perform best at work, at home and in the communities where they live and work when their well-being is supported. We believe in not taking a one-size-fits-all approach and strive to provide programs that are culturally relevant and inclusive to address the needs of a global employee population. We take a holistic approach to well-being, not only focusing on fundamental safety items but also addressing physical, mental and financial health.

Access to well-being services and resources are offered through onsite activities and partnerships with external vendors, among other methods of delivery. IBMers worldwide have confidential, 24/7 access to critical mental health support through employee assistance programs and supplemental resources. Other programs include training for employees on resilience, ergonomics, and financial well-being.

In 2024, a resilience-building tool and a digital well-being solution were made available to all IBM employees worldwide. These resources offer a personalized approach to assist IBMers with making small changes - with big results. These resources foster healthier habits focused on physical, mental, and emotional well-being.

International Business Machines Corporation and Subsidiary Companies

## YEAR IN REVIEW

## Results of Continuing Operations

## Segment Details

As discussed in the "Organization of Information" section, we made changes to our organizational structure and management system in the first quarter of 2024. With these changes, we revised our reportable segments and updated the title of our segment performance metric from pre-tax income from continuing operations to segment profit. Prior-year results have been recast to reflect the January 2024 segment changes as described in note D, "Segments."

The table below presents each reportable segment's revenue and gross margin results, followed by an analysis of the 2024 versus 2023 reportable segment results. The segment details below are presented under our historical reported revenue categories. Refer to "Looking Forward" for changes to the revenue categories reported within our Software and Consulting reportable segments effective in the first quarter of 2025. These changes will not impact our Consolidated Financial Statements or our reportable segments.

($ in millions)


| For the year ended December 31:            | 2024      | 2023  (1)   | Yr.-to-Yr.  Percent/ Margin  Change   | Yr.-to-Yr. Percent Change Adjusted for Currency   |
|--------------------------------------------|-----------|-------------|---------------------------------------|---------------------------------------------------|
| Revenue                                    |           |             |                                       |                                                   |
| Software                                   | $  27,085 | $  25,011   | 8.3 %                                 | 9.0 %                                             |
| Gross margin                               | 83.7 %    | 82.9 %      | 0.8 pts.                              |                                                   |
| Consulting                                 | 20,692    | 20,884      | (0.9) %                               | 0.6 %                                             |
| Gross margin                               | 27.0 %    | 26.8 %      | 0.3 pts.                              |                                                   |
| Infrastructure                             | 14,020    | 14,593      | (3.9) %                               | (2.7) %                                           |
| Gross margin                               | 55.8 %    | 56.1 %      | (0.3) pts.                            |                                                   |
| Financing                                  | 713       | 741         | (3.7) %                               | (2.5) %                                           |
| Gross margin                               | 47.9 %    | 48.1 %      | (0.3) pts.                            |                                                   |
| Other                                      | 243       | 632         | (61.6) %                              | (61.7) %                                          |
| Gross margin                               | (352.8) % | (87.4) %    | (265.3) pts.                          |                                                   |
| Total revenue                              | $  62,753 | $  61,860   | 1.4 %                                 | 2.5 %                                             |
| Total gross profit                         | $  35,551 | $  34,300   | 3.6 %                                 |                                                   |
| Total gross margin                         | 56.7 %    | 55.4 %      | 1.2 pts.                              |                                                   |
| Non-operating adjustments                  |           |             |                                       |                                                   |
| Amortization of acquired intangible assets | 724       | 631         | 14.6 %                                |                                                   |
| Operating (non-GAAP) gross profit          | $  36,275 | $  34,931   | 3.8 %                                 |                                                   |
| Operating (non-GAAP) gross margin          | 57.8 %    | 56.5 %      | 1.3 pts.                              |                                                   |

(1) Recast to reflect January 2024 segment changes.

## Software

($ in millions)


| For the year ended December 31:   | 2024      | 2023  (1)   | Yr.-to-Yr.  Percent  Change   | Yr.-to-Yr.  Percent Change  Adjusted for  Currency   |
|-----------------------------------|-----------|-------------|-------------------------------|------------------------------------------------------|
| Software revenue                  | $  27,085 | $  25,011   | 8.3 %                         | 9.0 %                                                |
| Hybrid Platform & Solutions       | $  18,808 | $  17,396   | 8.1 %                         | 8.7 %                                                |
| Red Hat                           |           |             | 11.4                          | 12.0                                                 |
| Automation                        |           |             | 14.2                          | 14.8                                                 |
| Data & AI                         |           |             | 1.6                           | 2.2                                                  |
| Security                          |           |             | 0.8                           | 1.5                                                  |
| Transaction Processing            | 8,277     | 7,615       | 8.7                           | 9.6                                                  |

(1) Recast to reflect January 2024 segment changes.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

Software revenue of $27,085 million increased 8.3 percent as reported (9.0 percent adjusted for currency) in 2024 compared to the prior year, reflecting growth across all lines of business with double-digit growth in Red Hat and Automation and high single-digit growth in Transaction Processing. This revenue performance reflects the investments we have been making in Software, both organically and through acquisitions. Our investments in generative AI are contributing to growth, as we had strong demand for our generative AI products such as watsonx, Concert and our AI assistants. We also launched new products in the fourth quarter of 2024 including our next generation of watsonx Code Assistant and Guardium Quantum Safe. In 2024, we also had increased revenue contribution from acquisitions compared to the prior year, including Apptio and StreamSets and webMethods. In addition, we had solid growth in our recurring revenue and double-digit growth in our transactional software revenue in 2024, as we accelerated growth through innovation across our Software portfolio.

Hybrid Platform & Solutions revenue of $18,808 million increased 8.1 percent as reported (8.7 percent adjusted for currency) in 2024 compared to the prior year. Within Hybrid Platform & Solutions, Red Hat revenue increased 11.4 percent as reported (12.0 percent adjusted for currency), which reflects the continued demand for our hybrid cloud solutions as clients are prioritizing application modernization on OpenShift containers and Ansible automation to optimize their IT spending and reduce operational complexity. In 2024, we had double-digit revenue growth in OpenShift and Ansible, and high single-digit revenue growth in RHEL. The growth in OpenShift revenue reflects increased volume in OpenShift Virtualization engagements, and we exited 2024 with OpenShift annual recurring revenue of $1.4 billion. Automation revenue increased 14.2 percent as reported (14.8 percent adjusted for currency), driven by our SaaS subscription offerings such as AIOps and Management, which includes the higher revenue contribution from Apptio. Data & AI revenue increased 1.6 percent as reported (2.2 percent adjusted for currency), with strong growth in Data Fabric and our AI assistant for Customer Care, driven by client demand for our watsonx platform offerings, and strength in asset and supply chain management software which helps clients run sustainable operations. Security revenue increased 0.8 percent as reported (1.5 percent adjusted for currency), with revenue growth in data security and identity and access management, partially offset by a revenue decline in security threat management.

Across Hybrid Platform & Solutions, our annual recurring revenue (ARR) was $15.3 billion exiting 2024, growing at a double-digit rate compared to the prior year. ARR is a key performance metric management uses to assess the health and growth trajectory of our Hybrid Platform & Solutions business within the Software segment. The metric was updated in the first quarter of 2024 to reflect the organizational changes described in the "Organization of Information" section above, and to simplify the calculation. ARR is calculated by using the current quarter's recurring revenue and then multiplying that value by four. This value includes the following consumption models: (1) software subscription agreements, including committed term licenses, (2) as-a-service arrangements such as SaaS and PaaS, and (3) maintenance and support contracts. ARR should be viewed independently of revenue as this performance metric and its inputs may not represent revenue that will be recognized in future periods.

Transaction Processing revenue of $8,277 million increased 8.7 percent as reported (9.6 percent adjusted for currency) in 2024 compared to the prior year. The performance in 2024 is the result of the combination of clients' growing capacity demands, solid renewal rates, and increased contribution from our generative AI products, including watsonx code assistant for Z. This growth reflects the innovation and value of our transaction processing software, which helps our clients manage their most mission-critical workloads.

($ in millions)


| For the year ended December 31:   | 2024      | 2023  (1)   | Yr.-to-Yr. Percent/ Margin Change   |
|-----------------------------------|-----------|-------------|-------------------------------------|
| Software                          |           |             |                                     |
| Gross profit                      | $  22,658 | $  20,721   | 9.3 %                               |
| Gross profit margin               | 83.7 %    | 82.9 %      | 0.8 pts.                            |
| Segment profit                    | $  8,684  | $  7,499    | 15.8 %                              |
| Segment profit margin             | 32.1 %    | 30.0 %      | 2.1 pts.                            |

(1) Recast to reflect January 2024 segment changes.

Software gross profit margin of 83.7 percent in 2024 increased 0.8 points compared to the prior year. Segment profit of $8,684 million increased 15.8 percent and pre-tax margin of 32.1 percent increased 2.1 points compared to the prior year. The year-to-year increases in segment profit and profit margin reflect our operating leverage driven by our revenue performance and the benefits of the productivity actions taken in 2024; partially offset by key investments across our software portfolio.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## Consulting

($ in millions)


| For the year ended December 31:   | 2024      | 2023  (1)   | Yr.-to-Yr. Percent Change   | Yr.-to-Yr. Percent Change Adjusted for Currency   |
|-----------------------------------|-----------|-------------|-----------------------------|---------------------------------------------------|
| Consulting revenue                | $  20,692 | $  20,884   | (0.9) %                     | 0.6 %                                             |
| Business Transformation           | $  9,347  | $  9,179    | 1.8 %                       | 3.2 %                                             |
| Technology Consulting             | 3,653     | 3,775       | (3.2)                       | (1.5)                                             |
| Application Operations            | 7,692     | 7,930       | (3.0)                       | (1.5)                                             |

(1) Recast to reflect January 2024 segment changes.

Consulting revenue of $20,692 million decreased 0.9 percent as reported, but increased 0.6 percent adjusted for currency in 2024 compared to the prior year. We had year-to-year revenue growth in Business Transformation, while revenue declined in Technology Consulting and Application Operations in 2024. During 2024, we operated in a dynamic macroeconomic environment following our strong performance in 2023, as clients reprioritized their IT spend toward digital transformation and AI initiatives for cost optimization and operational efficiency. We continued to focus on rapidly evolving our offerings and enhancing investments in skills and capabilities to align with these priorities. Our ability to address client demands contributed to Consulting signings growth in 2024 compared to the prior year. Our generative AI offerings contributed to this signings growth, as clients recognized the value we bring in accelerating their digital transformations through our extensive industry and enterprise AI expertise. Our Red Hat consulting practice grew at a double-digit rate in 2024, with revenue contribution across Consulting and ended the year with total revenue of approximately $3 billion. In addition, Consulting revenue and signings generated through our strategic partnerships continued to grow, contributing double-digit revenue growth year to year. We are actively investing to enhance our skills and capabilities to address our clients' top priorities, including our fourth-quarter 2024 acquisition of Accelalpha, a global Oracle services provider.

Business Transformation revenue of $9,347 million increased 1.8 percent as reported (3.2 percent adjusted for currency) compared to the prior year, driven by revenue growth in transformation projects for finance, supply chain, and data.

Technology Consulting revenue of $3,653 million decreased 3.2 percent as reported (1.5 percent adjusted for currency), driven by a decline in client spending on application development; partially offset by revenue growth in cloud-based application modernization projects.

Application Operations revenue of $7,692 million decreased 3.0 percent as reported (1.5 percent adjusted for currency), as clients reprioritized spending away from on-premise customized services.

($ in millions)


| For the year ended December 31:   | 2024     | 2023  (1)   | Yr.-to-Yr. Percent/ Margin Change   |
|-----------------------------------|----------|-------------|-------------------------------------|
| Consulting                        |          |             |                                     |
| Gross profit                      | $  5,589 | $  5,588    | 0.0 %                               |
| Gross profit margin               | 27.0 %   | 26.8 %      | 0.3 pts.                            |
| Segment profit                    | $  2,054 | $  2,130    | (3.6) %                             |
| Segment profit margin             | 9.9 %    | 10.2 %      | (0.3) pts.                          |

(1) Recast to reflect January 2024 segment changes.

Consulting gross profit margin increased 0.3 points to 27.0 percent compared to the prior year. Segment profit of $2,054 million decreased 3.6 percent and segment profit margin decreased 0.3 points to 9.9 percent compared to the prior year. The segment profit and profit margin performance reflects the investment in skills and capabilities we have made to meet the priorities of our clients, partially offset by the benefits from the productivity actions we took in 2024.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## Consulting Signings and Book-to-Bill

($ in millions)


| For the year ended December 31:   | 2024      | 2023  (1)   | Yr.-to-Yr. Percent Change   | Yr.-to-Yr. Percent Change Adjusted for Currency   |
|-----------------------------------|-----------|-------------|-----------------------------|---------------------------------------------------|
| Total Consulting signings         | $  25,103 | $  24,305   | 3.3 %                       | 4.7 %                                             |

(1) Recast to reflect January 2024 segment changes.

Consulting signings grew 3.3 percent as reported (4.7 percent adjusted for currency) in 2024, driven by our strong performance in signings in the fourth quarter of 2024. This performance reflects our ability to address client demands and the contribution of our generative AI solutions that help clients accelerate their digital transformations. Our book-to-bill ratio over the trailing twelve months was 1.21. Book-to-bill represents the ratio of IBM Consulting signings to its revenue over the same period and is a useful indicator of the demand for our business over time.

Signings are management's initial estimate of the value of a client's commitment under a services contract within IBM Consulting. There are no third-party standards or requirements governing the calculation of signings. The calculation used by management involves estimates and judgments to gauge the extent of a client's commitment, including the type and duration of the agreement and the presence of termination charges or wind-down costs.

Contract extensions and increases in scope are treated as signings only to the extent of the incremental new value. Total signings can vary over time due to a variety of factors including, but not limited to, the timing of signing a small number of larger contracts. Signings associated with an acquisition will be recognized on a prospective basis.

Management believes the estimated values of signings disclosed provide an indication of our forward-looking revenue. Signings are used to monitor the performance of the business and viewed as useful information for management and shareholders. The conversion of signings into revenue may vary based on the types of services and solutions, contract duration, customer decisions, and other factors, which may include, but are not limited to, the macroeconomic environment.

## Infrastructure

($ in millions)


| For the year ended December 31:   | 2024      | 2023      | Yr.-to-Yr. Percent Change   | Yr.-to-Yr. Percent Change Adjusted for Currency   |
|-----------------------------------|-----------|-----------|-----------------------------|---------------------------------------------------|
| Infrastructure revenue            | $  14,020 | $  14,593 | (3.9) %                     | (2.7) %                                           |
| Hybrid Infrastructure             | $  8,913  | $  9,215  | (3.3) %                     | (2.3) %                                           |
| IBM Z                             |           |           | (10.0)                      | (8.9)                                             |
| Distributed Infrastructure        |           |           | 1.6                         | 2.6                                               |
| Infrastructure Support            | 5,107     | 5,377     | (5.0)                       | (3.4)                                             |

Infrastructure revenue of $14,020 million decreased 3.9 percent as reported (2.7 percent adjusted for currency) as compared to the prior year, reflecting product cycle dynamics within Hybrid Infrastructure and Infrastructure Support.

Hybrid Infrastructure revenue of $8,913 million decreased 3.3 percent as reported (2.3 percent adjusted for currency) as compared to the prior year. Within Hybrid Infrastructure, IBM Z revenue decreased 10.0 percent as reported (8.9 percent adjusted for currency) on a year-to-year basis. At the end of 2024, z16 was in its eleventh quarter of availability, and the combination of resiliency, reliability, and security of this platform continues to resonate with clients. The total revenue performance from the z16 program has outpaced prior Z cycles, and program-to-date installed MIPS have increased more than 30 percent as clients' capacity needs continued to grow. IBM Z remains an enduring platform for mission-critical workloads, driving hardware adoption as well as related software, storage and services. Distributed Infrastructure revenue increased 1.6 percent as reported (2.6 percent adjusted for currency), driven primarily by double-digit growth in Storage systems, partially offset by a decline in cloud platform revenue. Storage revenue performance was driven by growth in high-end storage tied to the z16 platform and solutions tailored to protect, manage and access data for generative AI. In the fourth quarter of 2024, we introduced new innovation within Storage designed to give clients the ability to scale storage capacity to meet the growing data demands to support the next generation of AI workloads and projects.

Infrastructure Support revenue of $5,107 million decreased 5.0 percent as reported (3.4 percent adjusted for currency), driven by volume declines in support of non-IBM equipment and IBM product cycle dynamics.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

($ in millions)


| For the year ended December 31:   | 2024     | 2023  (1)   | Yr.-to-Yr. Percent/ Margin Change   |
|-----------------------------------|----------|-------------|-------------------------------------|
| Infrastructure                    |          |             |                                     |
| Gross profit                      | $  7,819 | $  8,187    | (4.5) %                             |
| Gross profit margin               | 55.8 %   | 56.1 %      | (0.3) pts.                          |
| Segment profit                    | $  2,450 | $  2,828    | (13.4) %                            |
| Segment profit margin             | 17.5 %   | 19.4 %      | (1.9) pts.                          |

(1) Recast to reflect January 2024 segment changes.

Infrastructure gross profit margin decreased 0.3 points to 55.8 percent in 2024 compared to the prior year, reflecting product cycle dynamics within both Hybrid Infrastructure and Infrastructure Support. Segment profit of $2,450 million decreased 13.4 percent and segment profit margin decreased 1.9 points to 17.5 percent primarily driven by product cycle dynamics and the investments in innovation we continued to make across IBM Z, Power and Storage systems in support of our clients' increasing demand for capacity, reliability and security, and the integration of generative AI across their enterprises. The impact to segment profit from these increased investments was partially offset by a year-to-year increase in intellectual property and custom development income in 2024.

## Financing

Refer to pages 41 through 42 for a discussion of Financing's segment results.

## Geographic Revenue

In addition to the revenue presentation by reportable segment, we also measure revenue performance on a geographic basis.

($ in millions)


| For the year ended December 31:   | 2024      | 2023      | Yr.-to-Yr. Percent Change   | Yr.-to-Yr. Percent Change Adjusted for Currency   |
|-----------------------------------|-----------|-----------|-----------------------------|---------------------------------------------------|
| Total revenue                     | $  62,753 | $  61,860 | 1.4 %                       | 2.5 %                                             |
| Americas                          | $  31,266 | $  31,666 | (1.3) %                     | (0.7) %                                           |
| Europe/Middle East/Africa         | 19,429    | 18,492    | 5.1                         | 4.7                                               |
| Asia Pacific                      | 12,058    | 11,702    | 3.0                         | 7.9                                               |

Geographic revenue performance for 2024 as compared to 2023:

Americas revenue decreased 1.3 percent as reported and 0.7 percent adjusted for currency. The U.S. decreased 0.5 percent. Canada decreased 4.5 percent as reported and 2.9 percent adjusted for currency. Latin America decreased 3.5 percent as reported, but was flat adjusted for currency. Within Latin America, Brazil revenue decreased 9.4 percent as reported and 5.0 percent adjusted for currency.

EMEA revenue increased 5.1 percent as reported and 4.7 percent adjusted for currency. Germany increased 14.5 percent as reported and 15.1 percent adjusted for currency. The UK increased 4.3 percent as reported and 1.8 percent adjusted for currency. Italy increased 3.5 percent as reported and 3.9 percent adjusted for currency. France was flat both as reported and adjusted for currency.

Asia Pacific revenue increased 3.0 percent as reported and 7.9 percent adjusted for currency. Japan revenue increased 7.6 percent as reported and 16.2 percent adjusted for currency. China decreased 7.2 percent as reported and 6.1 percent adjusted for currency. Australia decreased 3.6 percent as reported and 2.6 percent adjusted for currency. India decreased 1.5 percent as reported, but was flat adjusted for currency.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## Total Expense and Other (Income)

($ in millions)


| For the year ended December 31:                      | 2024      | 2023      | Yr.-to-Yr. Percent/ Margin Change   |
|------------------------------------------------------|-----------|-----------|-------------------------------------|
| Total expense and other (income)  (1)                | $  29,754 | $  25,610 | 16.2 %                              |
| Non-operating adjustments                            |           |           |                                     |
| Amortization of acquired intangible assets           | (1,107)   | (996)     | 11.1                                |
| Acquisition-related charges                          | (122)     | (33)      | 271.1                               |
| Non-operating retirement-related (costs)/income  (1) | (3,457)   | 39        | NM                                  |
| Operating (non-GAAP) expense and other (income)      | $  25,068 | $  24,620 | 1.8 %                               |
| Total expense-to-revenue ratio                       | 47.4 %    | 41.4 %    | 6.0 pts.                            |
| Operating (non-GAAP) expense-to-revenue ratio        | 39.9 %    | 39.8 %    | 0.1 pts.                            |

(1) 2024 includes the impact of pension settlement charges of $3.1 billion. Refer to note U, "Retirement-Related Benefits," for additional information.

NM-Not meaningful

Our expense dynamics in 2024 reflect our continued investment to execute our hybrid cloud and AI strategy. We remain focused on our productivity initiatives as we digitally transform our business processes and scale AI within IBM. This includes simplifying our application and infrastructure environments, aligning our teams by workflow and enabling a higher value-add workforce through automation and AI-driven efficiencies. These productivity initiatives allowed for continued investments to drive innovation in our portfolio.

Total expense and other (income) increased 16.2 percent in 2024 versus the prior year primarily driven by the pension settlement charges of $3.1 billion in 2024, higher spending reflecting our continued investment in portfolio innovation to drive our strategy and higher workforce rebalancing charges; partially offset by the benefits from productivity and the actions taken to transform our operations, higher gains from divestitures, and the effects of currency.

Total operating (non-GAAP) expense and other (income) increased 1.8 percent year to year, driven primarily by the factors described above, excluding the pension settlement charges.

For additional information regarding total expense and other (income) for both expense presentations, refer to the following analyses by category.

Selling, General and Administrative Expense


| For the year ended December 31:                                  | 2024      | 2023      | Yr.-to-Yr. Percent Change   |
|------------------------------------------------------------------|-----------|-----------|-----------------------------|
| Selling, general and administrative expense                      |           |           |                             |
| Selling, general and administrative-other                        | $  16,047 | $  15,706 | 2.2 %                       |
| Advertising and promotional expense                              | 1,173     | 1,237     | (5.2)                       |
| Workforce rebalancing charges                                    | 696       | 438       | 58.8                        |
| Amortization of acquired intangible assets                       | 1,105     | 995       | 11.0                        |
| Stock-based compensation                                         | 690       | 616       | 12.0                        |
| Provision for/(benefit from) expected credit loss expense        | (21)      | 10        | NM                          |
| Total selling, general and administrative expense                | $  19,688 | $  19,003 | 3.6 %                       |
| Non-operating adjustments                                        |           |           |                             |
| Amortization of acquired intangible assets                       | (1,105)   | (995)     | 11.0                        |
| Acquisition-related charges                                      | (55)      | (44)      | 23.8                        |
| Operating (non-GAAP) selling, general and administrative expense | $  18,529 | $  17,964 | 3.1 %                       |

NM-Not meaningful

## 22 Management Discussion

International Business Machines Corporation and Subsidiary Companies

Total selling, general and administrative (SG&A) expense increased 3.6 percent in 2024 versus 2023, driven primarily by the following factors:

· Higher net spending (3 points), including expenses of acquired businesses (1 point), as a result of our continued investment to drive our hybrid cloud and AI strategy; partially offset by benefits from productivity and the actions taken to transform our operations; and

· Higher workforce rebalancing charges (1 point) to address stranded costs and accelerate our productivity initiatives; partially offset by

· The effects of currency (1 point).

Operating (non-GAAP) SG&A expense increased 3.1 percent year to year primarily driven by the same factors.

Expected credit loss was a benefit of $21 million in 2024 as compared to a provision of $10 million in 2023. The year-to-year change was primarily driven by lower specific reserve requirements in the current year. Refer to "Receivables and Allowances" section on page 25 for additional information.

Research, Development and Engineering Expense


|                                             | ($ in millions)   | ($ in millions)   | ($ in millions)           |
|---------------------------------------------|-------------------|-------------------|---------------------------|
| For the year ended December 31:             | 2024              | 2023              | Yr.-to-Yr. Percent Change |
| Total research, development and engineering | $  7,479          | $  6,775          | 10.4 %                    |

Research, development and engineering (RD&E) expense increased 10.4 percent in 2024 versus 2023, primarily driven by investments to drive innovation in AI, hybrid cloud and quantum, as well as in Infrastructure ahead of our next IBM Z cycle in 2025.

Intellectual Property and Custom Development Income


|                                       | ($ in millions)   | ($ in millions)   | ($ in millions)           |
|---------------------------------------|-------------------|-------------------|---------------------------|
| For the year ended December 31:       | 2024              | 2023              | Yr.-to-Yr. Percent Change |
| Intellectual property income  (1) (2) | $  329            | $  374            | (12.1) %                  |
| Custom development income             | 667               | 485               | 37.5                      |
| Total                                 | $  996            | $  860            | 15.9 %                    |

(1) Includes licensing, royalty-based fees and sales.

(2) Prior-year amounts have been reclassified to conform to the change in 2024 presentation.

Total Intellectual Property and Custom Development Income increased 15.9 percent in 2024 compared to 2023. The increase was primarily driven by joint development and licensing agreements with a Japanese consortium to leverage our intellectual property and expertise on advanced semiconductors.

The timing and amount of licensing, sales or other transfers of IP may vary significantly from period to period depending upon the timing of licensing agreements, economic conditions, industry consolidation and the timing of new patents and know-how development.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

Other (Income) and Expense


| For the year ended December 31:                          | 2024       | 2023     | Yr.-to-Yr. Percent  Change   |
|----------------------------------------------------------|------------|----------|------------------------------|
| Other (income) and expense                               |            |          |                              |
| (Gains)/losses on foreign currency transactions          | $  (458)   | $  116   | NM                           |
| (Gains)/losses on derivative instruments  (1)            | 515        | (17)     | NM                           |
| Interest income                                          | (747)      | (670)    | 11.4 %                       |
| Net (gains)/losses from securities and investment assets | (20)       | (39)     | (49.4)                       |
| Retirement-related costs/(income)                        | 3,457      | (39)     | NM                           |
| Other                                                    | (877)      | (266)    | 230.3                        |
| Total other (income) and expense                         | $  1,871   | $  (914) | NM                           |
| Non-operating adjustments                                |            |          |                              |
| Amortization of acquired intangible assets               | (2)        | (1)      | 144.6                        |
| Acquisition-related charges  (1)                         | (68)       | 11       | NM                           |
| Non-operating retirement-related costs/(income)          | (3,457)    | 39       | NM                           |
| Operating (non-GAAP) other (income) and expense          | $  (1,656) | $  (866) | 91.3 %                       |

(1) 2024 and 2023 include the impact of a $68 million loss and $12 million gain, respectively, recognized on foreign exchange derivative contracts entered into by the company prior to the acquisition of StreamSets and webMethods from Software AG. Refer to note S, "Derivative Financial Instruments," for additional information.

NM-Not meaningful

Total other (income) and expense was $1,871 million of expense in 2024 compared to income of $914 million in 2023. The year-toyear change was primarily driven by:

· Non-operating retirement-related cost of $3,457 million in the current-year period versus $39 million of income in the prior-year period primarily driven by the impact of the pension settlement charges of $3,113 million in 2024 and an increase in recognized actuarial losses due to the change in amortization period of the Qualified PPP, effective January 1, 2024. Refer to note U, "Retirement-Related Benefits," for additional information; and

· Lower gains on land/building dispositions ($126 million) included in "Other"; partially offset by

· A gain of $349 million from the sale of certain QRadar SaaS assets in 2024, included in "Other". Refer to note E, "Acquisitions & Divestitures," for additional information; and

· Higher gains on divestitures ($206 million) primarily driven by the divestiture of The Weather Company assets ($243 million), included in "Other". Refer to note E, "Acquisitions & Divestitures," for additional information; and

· Higher gains on sales of intangibles ($87 million) included in "Other"; and

· Higher interest income ($77 million) primarily driven by a higher average cash balance in the current year.

Operating (non-GAAP) other (income) and expense was income of $1,656 million in 2024 and increased $790 million compared to the prior year. The year-to-year change was primarily driven by the gain recognized from the sale of certain QRadar SaaS assets in the current year, higher gains on divestitures and sales of intangibles and higher interest income.

Interest Expense


|                                 | ($ in millions)   | ($ in millions)   | ($ in millions)             |
|---------------------------------|-------------------|-------------------|-----------------------------|
| For the year ended December 31: | 2024              | 2023              | Yr.-to-Yr.  Percent  Change |
| Total interest expense          | $  1,712          | $  1,607          | 6.5 %                       |

Interest expense of $1,712 million in 2024 increased $105 million compared to 2023. Interest expense is presented in cost of financing in the Consolidated Income Statement only if the related external borrowings are to support the Financing external business. Overall interest expense (excluding capitalized interest) in 2024 was $2,048 million, an increase of $108 million year to year primarily driven by higher average interest rates.

Diobmiofjiwpnfibnn( aefibnxjmkjmofjiiNp nffmtxjhkifbn

## Noa< nbxkbinoi

+ mb5os noja5 nb ajhkbinofji ajno jcU W&9 WW hffji fiambnb U W= 1' hffji ajhkmb oj 8 6 8 9 8 Oefn rn kmfhmft pb oj fiambnbn cmjh mbnomfaob noja pifon .U W6 1 hffjiO & kbmcjmhiab nemb pifon .U 9 < hffjiO & noja jkofjin .U 8 9 hffjiO i bhkjtbbnnojakpmaenbki.U WWhffjiO 8Oebfiambnbnrbmbkmfhmftmfqbi tnoja5 nbajhkbinofjirmndmiobn kmo jc jpm iip atabn cjm bsbapofqbn i joebm bhkjtbbn8 Oeb tbm5oj5tbm aeidb finoja5 nb ajhkbinofji ajno rn mbcbaobfioebcjjrfidaobdjmfbn9xjno9U 8 8 9 hffji&pkU 9 9 hffjiH NB3vbskbinb9U < 26 hffji&pkU = : hffjiH iMy3z bskbinb9U 9 21hffji&pkU = 6 hffji8

## Mbombbio< Mbob+ in

Oebcjjrfido bkmjqfbnoebojokmb5osajnocjmmbofmbhbio5mbobkin8Ojojkbmofidajnon:.fiajhbO mb fiapbfi oebxjin jfobDiajhbNoobhbiorfoefioebakofji.b8d8&xjno&NB3v&My3zO mbofidojoebgj cpiaofjijcoebkikmofafkion8


| Amoebtbmbibybabh bmVT4                  | 5 S5 7      | 5 S5 V     | Rm3= o= Rm3 * bmabio eidb   |
|-----------------------------------------|-------------|------------|-----------------------------|
| Lbombhbio= mbobin1ano                   |             |            |                             |
| Nbmqfabajno                             | U  0< 1     | U  W19     | 8 6 281,                    |
| ( pof5bhkjtbmkin                        | W9          | W9         | .9 8= O                     |
| xjnojcbcfibajiomf pofjikin              | : : 6       | 22W        | .008< O                     |
| NobmoidanonF 7iahbE                     | U  W&6 8 W  | U  W&W11   | .W: 86 O ,                  |
| Diobmbnoajno                            | U  8 &W9 0  | U  8 &: W0 | .WW8< O ,                   |
| zskbaobmbopmijikinnbon                  | .8 &16 6 O  | .8 &2= WO  | .08= O                      |
| Mbajdifubaopmfjnnbn                     | 2< =        | 06 1       | 26 88                       |
| vhjmofuofjijckmfjmnbmqfabajnon:.ambfonO | .= O        | .2O        | .W= 82O                     |
| xpmofhbion:nboobhbion .WO               | 9 &W02      | 0          | I(                          |
| Joebmajnon                              | 9           | W9         | .= : 8= O                   |
| Ooii< kbmoidanonE C iabD  C VD          | U  9 &: 0=  | U  .9 2O   | I(                          |
| Oombombbio< mbobkin= ano C VD           | U  : &: = 1 | U  W&W: 2  | 8 128= ,                    |

.WO 8 6 8 : fiapbnkbinfjinboobhbioaemdbnjcU 9 8W ffji8MbcbmojijobP&-Mbofmbhbio5Mbobwbibcfon&M cjmfofjificjmhofji8

I( 6Ijohbifidcp

Ojo kmb5os mbofmbhbio5mbob ki ajno fiambnb t U 9 &9 8 2 hffji ajhkmb oj 8 6 8 9 & kmfhmft pb oj fiambn b fi apm ofhbion:nboobhbion.U 9 &W0: hffjiO kmfhmftmfqbi toebkbinfjinboobhbioaemdbnfi8 6 8 : &efdebmmbajdifubaopmf jnnbn.U : 02hffjiO &efdebmnbmqfabajno.U 9 10hffjiO ijrbmbskbaobmbopminjikinnbon.U W= WhffjiO H kmoftjccnbo t jrbmajnojcbcfibajiomf pofjikin.U 00WhffjiO ijrbmfiobmbnoajnon.U 8 16 hffjiO 8

vnfnapnnbfioeb-Jkbmofid.iji5Bvv+ O zmifidnM nbaofji&rbaemaobmfubabmofimbofmbhbio5mbobajnonnjkbmofidi joebmnniji5jkbmofid8Poffufidoefnaemaobmfuofji&jkbmofidmbofmbhbio5mbobajnonfi8 6 8 : rbmbU W&6 8 Whffji&bambnb jcU W< = hffjiajhkmboj8 6 8 9 &kmfhmftmfqbi tjrbmajnojcbcfibajiomf pofjikin.U 00WhffjiO &kmoftjccnbo t efdebmnbmqfabajno.U 9 10hffjiO pbojP8N8mbofmbhbiokiaeidbnbccbaofqbEipmt'W&8 6 8 : 8Diapfidoebmbobbhkjtbb nmt fiambnb bccbaofqb Eipmt' W& 8 6 8 : & oeb ibo fhkao oj jpm jkbmofid ajnon cmjh oeb P8N8 mbofmbhbio ki aeidbn rn fhhobmfcjmoebapmmbiotbm8MbcbmojijobP&-Mbofmbhbio5Mbobwbibcfon&M cjmfofjificjmhofji8Iji5jkbmofidajnorn U 9 &: 0= hffjifi8 6 8 : najhkmbojfiajhbjcU 9 2hffjifi8 6 8 9 8Oebtbm5oj5tbmaeidbfiiji5jkbmofidajnonrnmfqbi kmfhmft toebkbinfjinboobhbioaemdbn fioebapmmbiotbmiefdebmmbajdifubaopmfjnnbnH kmoftjccnbo tjrbm fiobmbnoajnon8

## $ iabOsbn

Oeb ajiofipfid jkbmofjin bccbaofqb os mob cjm 8 6 8 : rn .9 81O kbmabio ajhkmb oj W9 80 kbmabio fi8 6 8 9 8 Oeb apmmbio5tbm bccbaofqbosmobrnkmfhmftmfqbi toebosfhkaojcoebkbinfjinboobhbioaemdbnioebmbnjpofjijcabmofiospfo hoobmn8Oebjkbmofid.iji5Bvv+ O bccbaofqbosmobcjm8 6 8 : rnW9 8< kbmabioajhkmbojW: 86 kbmabiofi8 6 8 9 8Ajmfofji ficjmhofji&mbcbmojijobB&-Osbn8M

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## 1 Financial Position

## Dynamics

Our balance sheet at December 31, 2024 continues to provide us with flexibility to support and invest in the business.

Cash and cash equivalents, restricted cash and marketable securities at December 31, 2024 were $14,804 million, an increase of $1,342 million compared to prior-year end. Total debt of $54,973 million decreased $1,574 million compared to December 31, 2023. We continue to manage our debt levels while being acquisitive and without sacrificing investments in our business.

During 2024, we generated $13,445 million in cash from operating activities, compared to $13,931 million in 2023. While cash provided by financing receivables declined year to year from business variability, we had performance-related improvements within net income driving an increase within cash from operating activities. Our free cash flow for 2024 was $12,749 million, an increase of $1,538 million versus the prior year. Refer to page 35 for additional information on free cash flow. Our cash generation enables us to continue investing in innovation and expertise across the portfolio, while returning value to shareholders through dividends. We invested $3,289 million in acquisitions and returned $6,147 million to shareholders through dividends in 2024.

Consistent with accounting standards, the company remeasured the funded status of our retirement and postretirement plans at December 31. The overall net underfunded position at December 31, 2024 was $2,657 million, a decrease of $1,348 million from the prior-year end, primarily due to higher discount rates. At year end, our qualified defined benefit pension plans were well funded and the required contributions related to these plans and multi-employer plans are expected to be $100 million in 2025. In 2024, the return on the U.S. Personal Pension Plan assets was 2.6 percent and the plan was 136 percent funded at December 31, 2024. Overall, global asset returns were 2.0 percent and the qualified defined benefit plans worldwide were 116 percent funded at December 31, 2024.

IBM Working Capital


| ($ in millions)     |           |            |
|---------------------|-----------|------------|
| At December 31:     | 2024      | 2023       |
| Current assets      | $  34,482 | $  32,908  |
| Current liabilities | $  33,142 | $  34,122  |
| Working capital     | $  1,340  | $  (1,214) |
| Current ratio       | 1.04:1    | 0.96:1     |

Working capital increased $2,554 million from the year-end 2023 position. Current assets increased $1,574 million ($2,707 million adjusted for currency) primarily in cash and cash equivalents, and short-term financing receivables. Current liabilities decreased $980 million (increased $37 million adjusted for currency) as a result of a decrease in short-term debt mainly due to maturities; partially offset by an increase in deferred income.

## Receivables and Allowances

## Roll Forward of Total IBM Receivables Allowance for Credit Losses


| ($ in millions) January 1, 2024   | Additions/  (Releases)   | Write-offs  (2)   | Foreign currency  and other  (3)   | December 31, 2024   |
|-----------------------------------|--------------------------|-------------------|------------------------------------|---------------------|
| $457                              | $(18)                    | $(146)            | $(21)                              | $273                |

(1) Additions/(Releases) for allowance for credit losses are recorded in expense.

(2) Refer to note A, "Significant Accounting Policies," for additional information regarding allowance for credit loss write-offs.

(3) Other includes additions/(releases) related to discontinued operations.

Excluding receivables classified as held for sale, the total IBM receivables provision coverage was 1.4 percent at December 31, 2024, a decrease of 80 basis points compared to December 31, 2023. The decrease in coverage is due to declines in reserves primarily driven by write-offs. The majority of the write-offs during the year were related to receivables which had been previously reserved and were considered uncollectible as the related customer is no longer in operation, or there was no reasonable expectation of repossession or additional collections primarily due to the age of the receivables. Write-offs also includes about $60 million of previously reserved receivables from discontinued operations. Refer to Financing's "Financial Position" on page 42 for additional details regarding the Financing segment receivables and allowances.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

Noncurrent Assets and Liabilities


|                                         | ($ in millions)   | ($ in millions)   |
|-----------------------------------------|-------------------|-------------------|
| At December 31:                         | 2024              | 2023              |
| Noncurrent assets                       | $  102,693        | $  102,333        |
| Long-term debt                          | $  49,884         | $  50,121         |
| Noncurrent liabilities (excluding debt) | $  26,756         | $  28,385         |

The increase in noncurrent assets of $360 million ($2,453 million adjusted for currency) was primarily due to an increase in goodwill primarily from the StreamSets and webMethods acquisition; partially offset by currency impacts.

Long-term debt decreased $237 million (increased $761 million adjusted for currency) primarily driven by reclassifications to shortterm debt to reflect upcoming maturities and currency impacts; partially offset by our first-quarter 2024 debt issuances.

Noncurrent liabilities (excluding debt) decreased $1,629 million ($337 million adjusted for currency) primarily driven by lower retirement and postretirement benefit obligations.

## Debt

Our funding requirements are continually monitored as we execute our strategies to manage the overall asset and liability profile. Additionally, we maintain sufficient flexibility to access global funding sources as needed.


|                             | ($ in millions)   | ($ in millions)   |
|-----------------------------|-------------------|-------------------|
| At December 31:             | 2024              | 2023              |
| Total debt                  | $  54,973         | $  56,547         |
| Financing segment debt  (1) | $  12,116         | $  11,879         |
| Non-Financing debt          | $  42,858         | $  44,668         |

(1) Refer to Financing's "Financial Position" on page 41 for additional details.

Total debt of $54,973 million decreased $1,574 million ($536 million adjusted for currency) from December 31, 2023, primarily driven by maturities of $6,615 million; partially offset by proceeds from issuances of $5,705 million.

Non-Financing debt of $42,858 million decreased $1,810 million ($1,029 million adjusted for currency) from December 31, 2023, primarily driven by maturities; partially offset by proceeds from issuances.

Financing segment debt of $12,116 million increased $236 million ($493 million adjusted for currency) from December 31, 2023, primarily due to higher funding requirements associated with financing receivables.

Financing provides financing solutions predominantly for IBM's external client assets, and the debt used to fund Financing assets is primarily composed of intercompany loans. Total debt changes generally correspond with the level of client and commercial financing receivables, the level of cash and cash equivalents, the change in intercompany and external payables and the change in intercompany investment from IBM. The terms of the intercompany loans are set by the company to substantially match the term, currency and interest rate variability underlying the financing receivable. The Financing debt-to-equity ratio remained at 9.0 to 1 at December 31, 2024.

Interest expense relating to debt supporting Financing's external client and internal business is included in the "Financing Results of Operations" and in note D, "Segments." In the Consolidated Income Statement, the external debt-related interest expense supporting Financing's internal financing to the company is classified as interest expense.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## Equity

Total equity increased $4,780 million from December 31, 2023, primarily driven by an increase from net income of $6,023 million which includes the impact of the pension settlement charges of $2,407 million net of tax, a decrease in accumulated other comprehensive loss of $3,492 million driven by retirement-related benefit plans primarily due to the pension settlement charges and amortization of net losses, and an increase in common stock of $1,737 million; partially offset by dividends paid of $6,147 million.

## Cash Flow

Our cash flows from operating, investing and financing activities, as reflected in the Consolidated Statement of Cash Flows on page 49, are summarized in the table below. These amounts also include the cash flows associated with the Financing business.


| ($ in millions)                                                               |           |           |
|-------------------------------------------------------------------------------|-----------|-----------|
| For the year ended December 31:                                               | 2024      | 2023      |
| Net cash provided by/(used in)                                                |           |           |
| Operating activities                                                          | $  13,445 | $  13,931 |
| Investing activities                                                          | (4,937)   | (7,070)   |
| Financing activities                                                          | (7,079)   | (1,769)   |
| Effect of exchange rate changes on cash, cash equivalents and restricted cash | (359)     | 9         |
| Net change in cash, cash equivalents and restricted cash                      | $  1,071  | $  5,101  |

During 2024, we generated $13,445 million in cash from operating activities, compared to $13,931 million in 2023. While cash provided by financing receivables declined year to year due to variability in volumes, we had performance-related improvements within net income driving an increase within cash from operating activities.

Net cash used in investing activities decreased $2,133 million mainly driven by the Apptio acquisition in 2023, an increase in cash provided by divestitures from the sale of The Weather Company assets and an increase in cash from disposition of property, plant and equipment/other mainly driven by proceeds from the sale of certain QRadar SaaS assets; partially offset by the current year acquisition of StreamSets and webMethods and higher net purchases of marketable securities and other investments.

Net cash used in financing activities increased $5,309 million mainly due to an decrease in net cash provided by debt of $5,377 million primarily driven by a lower level of debt issuances and a higher level of maturities in the current year compared to 2023.

Management Discussion

International Business Machines Corporation and Subsidiary Companies

## GAAP Reconciliation

The tables below provide a reconciliation of our income statement results as reported under GAAP to our operating earnings presentation which is a non-GAAP measure. Management's calculation of operating (non-GAAP) earnings, as presented, may differ from similarly titled measures reported by other companies. Please refer to the "Operating (non-GAAP) Earnings" section for management's rationale for presenting operating earnings information.


| ($ in millions except per share amounts)              |          |                                   |                                       |                                |                       |
|-------------------------------------------------------|----------|-----------------------------------|---------------------------------------|--------------------------------|-----------------------|
| For the year ended December 31, 2024:                 | GAAP     | Acquisition- Related  Adjustments | Retirement- Related  Adjustments  (1) | U.S. Tax  Reform  Impacts  (2) | Operating  (non-GAAP) |
| Gross profit                                          | $ 35,551 | $  724                            | $  -                                  | $  -                           | $ 36,275              |
| Gross profit margin                                   | 56.7 %   | 1.2 pts.                          | - pts.                                | - pts.                         | 57.8 %                |
| SG&A                                                  | $ 19,688 | $ (1,159)                         | $  -                                  | $  -                           | $ 18,529              |
| Other (income) and expense  (3)                       | 1,871    | (70)                              | (3,457)                               | -                              | (1,656)               |
| Total expense and other (income)                      | 29,754   | (1,229)                           | (3,457)                               | -                              | 25,068                |
| Pre-tax income from continuing operations             | 5,797    | 1,953                             | 3,457                                 | -                              | 11,207                |
| Pre-tax margin from continuing operations             | 9.2 %    | 3.1 pts.                          | 5.5 pts.                              | - pts.                         | 17.9 %                |
| Provision for/(benefit from) income taxes  (4)        | $  (218) | $  497                            | $  790                                | $  455                         | $  1,523              |
| Effective tax rate                                    | (3.8) %  | 5.1 pts.                          | 8.2 pts.                              | 4.1 pts.                       | 13.6 %                |
| Income from continuing operations                     | $  6,015 | $ 1,456                           | $  2,668                              | $  (455)                       | $  9,684              |
| Income margin from continuing operations              | 9.6 %    | 2.3 pts.                          | 4.3 pts.                              | (0.7) pts.                     | 15.4 %                |
| Diluted earnings per share from continuing operations | $  6.42  | $  1.55                           | $  2.85                               | $ (0.49)                       | $  10.33              |

($ in millions except per share amounts)


| For the year ended December 31, 2023:                 | GAAP     | Acquisition- Related  Adjustments   | Acquisition- Related  Adjustments   | Retirement- Related  Adjustments   | U.S. Tax  Reform  Impacts   | U.S. Tax  Reform  Impacts   | Operating  (non-GAAP)   |    |
|-------------------------------------------------------|----------|-------------------------------------|-------------------------------------|------------------------------------|-----------------------------|-----------------------------|-------------------------|----|
| Gross profit                                          | $ 34,300 | $  631                              |                                     | $  -                               | $  -                        |                             | $ 34,931                |    |
| Gross profit margin                                   | 55.4 %   | 1.0                                 | pts.                                | - pts.                             | - pts.                      |                             | 56.5 %                  |    |
| SG&A                                                  | $ 19,003 | $ (1,039)                           |                                     | $  -                               | $  -                        |                             | $ 17,964                |    |
| Other (income) and expense                            | (914)    | 10                                  |                                     | 39                                 | -                           |                             | (866)                   |    |
| Total expense and other (income)  (3)                 | 25,610   | (1,029)                             |                                     | 39                                 | -                           |                             | 24,620                  |    |
| Pre-tax income from continuing operations             | 8,690    | 1,660                               |                                     | (39)                               | -                           |                             | 10,311                  |    |
| Pre-tax margin from continuing operations             | 14.0 %   | 2.7                                 | pts.                                | (0.1) pts.                         | - pts.                      |                             | 16.7 %                  |    |
| Provision for income taxes  (4)                       | $  1,176 | $  368                              |                                     | $  (8)                             | $  (95)                     |                             | $  1,441                |    |
| Effective tax rate                                    | 13.5 %   | 1.4                                 | pts.                                | 0.0 pts.                           |                             | (0.9) pts.                  | 14.0 %                  |    |
| Income from continuing operations                     | $  7,514 | $ 1,292                             |                                     | $  (30)                            | $  95                       |                             | $  8,870                |    |
| Income margin from continuing operations              | 12.1 %   | 2.1                                 | pts.                                | 0.0 pts.                           | 0.2                         | pts.                        | 14.3 %                  |    |
| Diluted earnings per share from continuing operations | $  8.15  | $  1.40                             |                                     | $  (0.03)                          | $  0.10                     |                             | $  9.62                 |    |

(1) Retirement-Related Adjustments in 2024 includes the impact of pension settlement charges of $3.1 billion ($2.4 billion net of tax) . Refer to note U, "Retirement-Related Benefits," for additional information.

(2) 2024 includes a benefit from income taxes due to the resolution of certain tax audit matters.

(3) Acquisition-Related Adjustments in 2024 and 2023 include the impact of a $68 million loss and $12 million gain, respectively, recognized on foreign exchange derivative contracts entered into by the company prior to the acquisition of StreamSets and webMethods from Software AG. Refer to note S, "Derivative Financial Instruments," for additional information.

(4) The tax impact on operating (non-GAAP) pre-tax income is calculated under the same accounting principles applied to the GAAP pre-tax income.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## 1 PRIOR YEAR IN REVIEW

This section provides a summary of our segment results and year-to-year comparisons between 2023 and 2022. These segment results have been recast to conform to our segment changes effective first-quarter 2024. There was no change to our consolidated results. Refer to "Year in Review" section of our "Management Discussion," (pages 17 to 28), of our 2023 Annual Report on Form 10-K for a discussion of all other details of our financial condition and results of operations for the year ended December 31, 2023 compared to the year ended December 31, 2022.

## Segment Details

The table below presents each reportable segment's revenue and gross margin results which are presented on a comparable basis. Refer to "Organization of Information" section of "Management Discussion" and note D, "Segments," for additional information on the recast of our segment financial results for 2023 and 2022.

($ in millions)


| For the year ended December 31:            | 2023  (1)   | 2022  (1)   | Yr.-to-Yr.  Percent/ Margin  Change   | Yr.-to-Yr. Percent Change Adjusted for Currency   |
|--------------------------------------------|-------------|-------------|---------------------------------------|---------------------------------------------------|
| Revenue                                    |             |             |                                       |                                                   |
| Software                                   | $  25,011   | $  23,629   | 5.8 %                                 | 5.9 %                                             |
| Gross margin                               | 82.9 %      | 82.5 %      | 0.4 pts.                              |                                                   |
| Consulting                                 | 20,884      | 20,058      | 4.1 %                                 | 5.6 %                                             |
| Gross margin                               | 26.8 %      | 25.8 %      | 0.9 pts.                              |                                                   |
| Infrastructure                             | 14,593      | 15,288      | (4.5) %                               | (3.9) %                                           |
| Gross margin                               | 56.1 %      | 52.8 %      | 3.3 pts.                              |                                                   |
| Financing                                  | 741         | 645         | 14.8 %                                | 15.0 %                                            |
| Gross margin                               | 48.1 %      | 38.3 %      | 9.8 pts.                              |                                                   |
| Other                                      | 632         | 909         | (30.5) %                              | (31.6) %                                          |
| Gross margin                               | (87.4) %    | (32.9) %    | (54.5) pts.                           |                                                   |
| Total revenue                              | $  61,860   | $  60,530   | 2.2 %                                 | 2.9 %                                             |
| Total gross profit                         | $  34,300   | $  32,687   | 4.9 %                                 |                                                   |
| Total gross margin                         | 55.4 %      | 54.0 %      | 1.4 pts.                              |                                                   |
| Non-operating adjustments                  |             |             |                                       |                                                   |
| Amortization of acquired intangible assets | 631         | 682         | (7.5) %                               |                                                   |
| Operating (non-GAAP) gross profit          | $  34,931   | $  33,370   | 4.7 %                                 |                                                   |
| Operating (non-GAAP) gross margin          | 56.5 %      | 55.1 %      | 1.3 pts.                              |                                                   |

(1) Recast to reflect January 2024 segment changes.

## Software

($ in millions)


| For the year ended December 31:   | 2023  (1)   | 2022  (1)   | Yr.-to-Yr.  Percent  Change   | Yr.-to-Yr.  Percent Change  Adjusted for  Currency   |
|-----------------------------------|-------------|-------------|-------------------------------|------------------------------------------------------|
| Software revenue                  | $  25,011   | $  23,629   | 5.8 %                         | 5.9 %                                                |
| Hybrid Platform & Solutions       | $  17,396   | $  16,458   | 5.7 %                         | 5.8 %                                                |
| Red Hat                           |             |             | 9.1                           | 9.0                                                  |
| Automation                        |             |             | 3.4                           | 3.6                                                  |
| Data & AI                         |             |             | 6.0                           | 6.4                                                  |
| Security                          |             |             | (1.4)                         | (1.4)                                                |
| Transaction Processing            | 7,615       | 7,171       | 6.2                           | 6.3                                                  |

(1) Recast to reflect January 2024 segment changes.

Software revenue of $25,011 increased 5.8 percent as reported (5.9 percent adjusted for currency) in 2023 compared to the prior year, driven by growth in both Hybrid Platform & Solutions and Transaction Processing. The growth in Hybrid Platform & Solutions was led by Red Hat, Automation and Data & AI. In Transaction Processing, our IBM Z platform continued to drive client demand. Our Software revenue performance in 2023 reflected growth in our high-value, recurring revenue base, which was approximately 80 percent of our annual software revenue, as well as transactional revenue.

## 30 Management Discussion

International Business Machines Corporation and Subsidiary Companies

Hybrid Platform & Solutions revenue of $17,396 increased 5.7 percent as reported (5.8 percent adjusted for currency) in 2023 compared to the prior year. Within Hybrid Platform & Solutions, Red Hat revenue increased 9.1 percent as reported (9.0 percent adjusted for currency) led by double-digit growth in OpenShift and Ansible, and solid growth in RHEL. OpenShift continued its strong performance with annual recurring revenue of $1.2 billion exiting 2023. Automation revenue increased 3.4 percent as reported (3.6 percent adjusted for currency), with strength in AIOps and Management solutions as clients looked to optimize business performance and enhance productivity. Data & AI revenue increased 6.0 percent as reported (6.4 percent adjusted for currency), reflecting demand for data management as clients prepared for generative AI, and strength in asset and supply chain management software which helps clients run sustainable operations. Security revenue decreased 1.4 percent as reported and adjusted for currency. While we had revenue declines in security threat management and identity and access management, we delivered revenue growth in data security.

Across Hybrid Platform & Solutions, our annual recurring revenue (ARR) was $13.8 billion exiting 2023. ARR is a key performance metric management uses to assess the health and growth trajectory of our Hybrid Platform & Solutions business within the Software segment. Refer to the "Year in Review" section on page 17 for our definition of ARR.

Transaction Processing revenue of $7,615 million increased 6.2 percent as reported (6.3 percent adjusted for currency) in 2023 compared to the prior year. Clients continued to value this portfolio of mission-critical software in support of growing workloads on our hardware platforms, such as IBM Z. This, together with price increases, contributed to growth in both recurring and transactional revenue in Transaction Processing.


| ($ in millions) For the year ended December 31:   | 2023  (1)   | 2022  (1)   | Yr.-to-Yr. Percent/ Margin Change   |
|---------------------------------------------------|-------------|-------------|-------------------------------------|
| Software                                          |             |             |                                     |
| Gross profit                                      | $  20,721   | $  19,483   | 6.4 %                               |
| Gross profit margin                               | 82.9 %      | 82.5 %      | 0.4 pts.                            |
| Segment profit                                    | $  7,499    | $  7,012    | 6.9 %                               |
| Segment profit margin                             | 30.0 %      | 29.7 %      | 0.3 pts.                            |

(1) Recast to reflect January 2024 segment changes.

Software gross profit margin of 82.9 percent in 2023 increased 0.4 points compared to the prior year, primarily driven by margin expansion in software services due to portfolio mix. Segment profit of $7,499 million increased 6.9 percent and segment profit margin of 30.0 percent increased 0.3 points compared to 2022. The year-to-year increases in segment profit and segment profit margin were driven by our solid revenue growth, higher gross profit contribution and the productivity actions that were taken; partially offset by key investments in innovation. Segment profit margin in 2023 included approximately 1 point of impact from currency.

## Consulting

($ in millions)


| For the year ended December 31:   | 2023  (1)   | 2022  (1)   | Yr.-to-Yr. Percent Change   | Yr.-to-Yr. Percent Change Adjusted for Currency   |
|-----------------------------------|-------------|-------------|-----------------------------|---------------------------------------------------|
| Consulting revenue                | $  20,884   | $  20,058   | 4.1 %                       | 5.6 %                                             |
| Business Transformation           | $  9,179    | $  8,834    | 3.9 %                       | 5.3 %                                             |
| Technology Consulting             | 3,775       | 3,730       | 1.2                         | 2.8                                               |
| Application Operations            | 7,930       | 7,494       | 5.8                         | 7.3                                               |

(1) Recast to reflect January 2024 segment changes.

Consulting revenue of $20,884 million increased 4.1 percent as reported (5.6 percent adjusted for currency) in 2023 compared to the prior year, with growth across all three business areas. This growth reflected the solid demand for our data and technology transformation projects with a focus on AI and analytics. Clients were also prioritizing cloud modernization and cloud-based application development projects. There was a consistent client focus throughout 2023 on digital transformation and AI initiatives to drive productivity and cost savings for their enterprises. Our integrated value proposition, investments in skills and strategic partnerships and focused execution differentiated us in the marketplace. Our strategic partnerships, which accounted for approximately 40 percent of Consulting revenue, delivered double-digit Consulting revenue growth in 2023 compared to the prior year.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

Business Transformation revenue of $9,179 million increased 3.9 percent as reported (5.3 percent adjusted for currency) year to year, led by data and technology transformations including AI and analytics-focused projects, and finance and supply chain transformations.

Technology Consulting revenue of $3,775 million increased 1.2 percent as reported (2.8 percent adjusted for currency), led by cloud-based application development and cloud modernization projects.

Application Operations revenue of $7,930 million increased 5.8 percent as reported (7.3 percent adjusted for currency) driven by growth in platform engineering services and cloud application management.


|                                 | ($ in millions)   | ($ in millions)   | ($ in millions)                  |
|---------------------------------|-------------------|-------------------|----------------------------------|
| For the year ended December 31: | 2023  (1)         | 2022  (1)         | Yr.-to-Yr. Percent/Margin Change |
| Consulting                      |                   |                   |                                  |
| Gross profit                    | $  5,588          | $  5,180          | 7.9 %                            |
| Gross profit margin             | 26.8 %            | 25.8 %            | 0.9 pts.                         |
| Segment profit                  | $  2,130          | $  1,871          | 13.8 %                           |
| Segment profit margin           | 10.2 %            | 9.3 %             | 0.9 pts.                         |

(1) Recast to reflect January 2024 segment changes.

Consulting gross profit margin increased 0.9 points to 26.8 percent in 2023 compared to the prior year. Segment profit of $2,130 million increased 13.8 percent and segment profit margin increased 0.9 points to 10.2 percent. The increases in gross profit margin and segment profit margin reflected benefits from pricing and productivity actions, which were partially offset by increased labor costs.

## Infrastructure

($ in millions)


| For the year ended December 31:   | 2023      | 2022      | Yr.-to-Yr. Percent Change   | Yr.-to-Yr. Percent Change Adjusted for Currency   |
|-----------------------------------|-----------|-----------|-----------------------------|---------------------------------------------------|
| Infrastructure revenue            | $  14,593 | $  15,288 | (4.5) %                     | (3.9) %                                           |
| Hybrid Infrastructure             | $  9,215  | $  9,451  | (2.5) %                     | (2.2) %                                           |
| IBM Z                             |           |           | (4.5)                       | (4.2)                                             |
| Distributed Infrastructure        |           |           | (1.0)                       | (0.7)                                             |
| Infrastructure Support            | 5,377     | 5,837     | (7.9)                       | (6.6)                                             |

Infrastructure revenue of $14,593 million decreased 4.5 percent as reported (3.9 percent adjusted for currency) in 2023 as compared to the prior year, reflecting product cycle dynamics which impacted both Hybrid Infrastructure and Infrastructure Support.

Hybrid Infrastructure revenue of $9,215 million decreased 2.5 percent as reported (2.2 percent adjusted for currency) in 2023 as compared to the prior year. Within Hybrid Infrastructure, IBM Z revenue decreased 4.5 percent as reported (4.2 percent adjusted for currency) on a year-to-year basis, consistent with the z16 cycle, as it was introduced in the second quarter of 2022. Overall, across the program cycle, z16 revenue performance at year-end 2023 had significantly outperformed prior cycles, including the successful z15 program. The z16 program incorporates a number of key innovations for our clients including cloud-native development for hybrid cloud, embedded AI at scale, quantum safe cyber-resilient security, energy efficiency and strong reliability and scalability. Clients increasingly leveraged IBM Z for more workloads which drove demand for more capacity. Installed MIPS have doubled during the last two IBM Z product cycles. IBM Z remains an enduring platform, driving hardware adoption as well as related software, storage and services. Distributed Infrastructure revenue decreased 1.0 percent as reported (0.7 percent adjusted for currency). We had year-to-year declines in high-end Power and cloud platform revenue; partially offset by strong growth in highend Storage and low- to mid-range Power.

Infrastructure Support revenue of $5,377 million decreased 7.9 percent as reported (6.6 percent adjusted for currency), which reflected reduced demand for support services as a result of product cycle dynamics.

## 32 Management Discussion

International Business Machines Corporation and Subsidiary Companies

($ in millions)


| For the year ended December 31:   | 2023  (1)   | 2022  (1)   | Yr.-to-Yr. Percent/ Margin Change   |
|-----------------------------------|-------------|-------------|-------------------------------------|
| Infrastructure                    |             |             |                                     |
| Gross profit                      | $  8,187    | $  8,076    | 1.4 %                               |
| Gross profit margin               | 56.1 %      | 52.8 %      | 3.3 pts.                            |
| Segment profit                    | $  2,828    | $  2,671    | 5.9 %                               |
| Segment profit margin             | 19.4 %      | 17.5 %      | 1.9 pts.                            |

(1) Recast to reflect January 2024 segment changes.

Infrastructure gross profit margin increased 3.3 points to 56.1 percent in 2023 compared to the prior year. The increase was driven by margin expansion in Hybrid Infrastructure across both Distributed Infrastructure and IBM Z, reflecting our continued focus on productivity initiatives including streamlining our supply chain; partially offset by margin decline in Infrastructure Support due to product cycle dynamics. Segment profit of $2,828 million increased 5.9 percent and segment profit margin increased 1.9 points to 19.4 percent primarily driven by the increase in gross profit contribution, an increase in IP and custom development income, a benefit from the change in the useful life of servers and network equipment, and productivity actions. Segment profit margin in 2023 included approximately 1 point of impact from currency.

## Financing

($ in millions)


| For the year ended December 31:   | 2023   | 2022   | Yr.-to-Yr.  Percent  Change   |
|-----------------------------------|--------|--------|-------------------------------|
| Revenue                           | $  741 | $  645 | 14.8 %                        |
| Segment profit  (1)               | $  373 | $  340 | 9.8 %                         |

(1) Recast to reflect January 2024 segment changes.

Financing revenue increased 14.8 percent (15.0 percent adjusted for currency) to $741 million in 2023 compared to the prior year, primarily driven by client financing up $89 million to $728 million. The increase in client financing revenue was primarily driven by an increase in client financing asset yields.

Financing segment profit increased 9.8 percent to $373 million in 2023 compared to the prior year and the segment profit margin of 50.3 percent decreased 2.3 points year to year. The increase in segment profit in 2023 was primarily driven by a decrease in SG&A expenses and settlements on non-accrual assets.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## OTHER INFORMATION

## Looking Forward

Technology has proven to be a fundamental source of competitive advantage and is now the key to sustainable growth and business transformation. Continued demand for technology will serve as a major driving force behind global economic and business growth as businesses look to scale, offer better services, drive efficiencies and seize new market opportunities. AI-driven productivity, in particular, continues to be a top priority for businesses for both cost reductions and new revenue opportunities.

Enterprise AI continues to gain momentum. Our clients have moved beyond experimentation and are now looking to scale AI in their businesses and generate return from their investments. The portfolio of AI offerings we have built is focused on generating that return through productivity improvements and automation. We have infused AI across the business, from the tools clients use to manage and optimize their hybrid cloud environments, to the tools to deploy AI within their enterprise, to Infrastructure and Consulting, there is AI innovation within all of our segments. For example, in Software, IBM watsonx provides a robust portfolio of AI products for developing AI apps, managing data, and governing the entire lifecycle of AI models. Red Hat is bringing AI to the platform with innovation such as OpenShift AI and RHEL AI. In Transaction Processing, we are experiencing continued customer interest in our generative AI product, watsonx Code Assistant for Z. In Infrastructure, IBM Z is equipped with real time AI inferencing capabilities. We continue to see Infrastructure play a larger role, enabling hybrid cloud environments for mission-critical transactions and AI workloads, as clients bring AI to their data. In Consulting, our experts are helping clients design and execute AI strategies by leveraging the IBM Consulting Advantage platform, an AI delivery platform designed to implement solutions at scale, transforming how our consultants work and harnessing AI across every stage of the project lifecycle.

We are committed to an open innovation ecosystem around AI, to help our clients maximize flexibility and leverage skills, and IBM with Red Hat can be a key driver of open-source AI. In the second quarter of 2024, we open-sourced IBM's Granite models, which are designed for specific purposes and significantly more cost-efficient than larger alternatives, and we see parallels to how Linux became a leader in the enterprise server space as a result of the speed and innovation offered by open source. Red Hat and IBM also launched InstructLab to evolve and improve AI models. Our partner ecosystem remains essential to both AI and hybrid cloud growth and we continue to progress strategic partnerships with leading technology providers. In August 2024, we completed the sale of certain IBM QRadar SaaS assets to Palo Alto, which is part of a partnership with them to deliver AI-powered security solutions using watsonx to clients.

We continue to invest in emerging technologies, bringing new innovations to market. In 2024, we expanded our IBM Quantum Data Center in Poughkeepsie, New York and opened the first IBM Quantum Data Center in Europe. We also announced a partnership with the State of Illinois to build the National Quantum Algorithm Center in Chicago and deploy a next-generation IBM Quantum System Two, supporting the future of quantum-centric supercomputing and greatly advancing our goal of expanding access to the world's most performant quantum computers. We also remained focused on portfolio optimization. In January 2024, we closed the divestiture of The Weather Company assets. To complement our portfolio, we completed eleven acquisitions in 2024, including the acquisition of the StreamSets and webMethods assets from Software AG. This acquisition brings together leading capabilities in integration, API management, and data ingestion. At the end of 2024, we closed the acquisition of Neural Magic, which strengthens our AI capabilities in performance engineering and model optimization.

On April 24, 2024, we announced our intent to acquire all of the outstanding shares of HashiCorp. The combination of IBM's and HashiCorp's combined portfolios will help clients manage growing application and infrastructure complexity and create a comprehensive end-to-end hybrid cloud platform designed for the AI era. Under the terms of the definitive agreement, HashiCorp shareholders on record immediately prior to the effective time on the closing date will receive $35 per share in cash, representing a total enterprise value of approximately $6.4 billion. On July 15, 2024, HashiCorp stockholders voted to approve the merger with IBM. The transaction is expected to close in the first quarter of 2025, subject to regulatory approvals and other customary closing conditions. Upon closing, HashiCorp will be integrated into the Software segment.

In 2024, we continued to invest organically and inorganically, bring new products and innovation to market, expand our ecosystem and drive productivity across our business. We have made significant progress in becoming a higher growth, more focused business that has delivered sustained revenue growth, strong cash generation and meaningful returns to all our stakeholders - our 2024 performance is a proof point of this progress. Today, IBM is a software-led, fully integrated platform company, a business well positioned for 2025 and the future.

In the first quarter of 2025, we announced changes to the reported revenue categories within our Software and Consulting reportable segments to better reflect the market opportunities and how we address them. IBM will report revenue and year-to-year revenue percent change for Hybrid Cloud (Red Hat), Automation, Data, and Transaction Processing within Software, and for Strategy and Technology and Intelligent Operations within Consulting. These changes were effective January 1, 2025 and will not impact our Consolidated Financial Statements or our reportable segments. Since these changes did not occur until first-quarter 2025, the periods presented in this Annual Report reflect the historical reported revenue categories.

## 34 Management Discussion

International Business Machines Corporation and Subsidiary Companies

## Retirement-Related Plans

Our retirement-related plans remain in a strong financial position. In aggregate, our worldwide qualified plans are funded 116 percent, with the U.S. at 136 percent. Contributions for all retirement-related plans are expected to be approximately $1.3 billion in 2025, approximately flat compared to 2024, of which $0.1 billion relates to legally required contributions to non-U.S. defined benefits and multi-employer plans. We expect 2025 pre-tax retirement-related plan cost to be approximately $1.1 billion. This estimate reflects current pension plan assumptions at December 31, 2024. Within total retirement-related plan cost, operating retirement-related plan cost is expected to be approximately $1.0 billion in 2025, essentially flat compared to the prior year. Nonoperating retirement-related plan cost is expected to be approximately $0.1 billion, a decrease of approximately $3.3 billion compared to 2024, primarily driven by the $3.1 billion pension settlement charges resulting from the U.S. and Canada pension transfers in 2024, and lower recognized actuarial losses. Refer to note U, "Retirement-Related Benefits," for additional information on the pension transfers.

## Liquidity and Capital Resources

We have generated strong cash flow from operations allowing us to invest and deploy capital to areas with the most attractive longterm opportunities. We provide for additional liquidity through several sources: maintaining an adequate cash balance, access to global funding sources, committed global credit facilities and other committed and uncommitted lines of credit worldwide. The following table provides a summary of the major sources of liquidity for the years ended December 31, 2022 through 2024.

## Cash Flow and Liquidity Trends


|                                                                                 | ($ in billions)   | ($ in billions)   | ($ in billions)   |
|---------------------------------------------------------------------------------|-------------------|-------------------|-------------------|
|                                                                                 | 2024              | 2023              | 2022              |
| Net cash from operating activities                                              | $  13.4           | $  13.9           | $  10.4           |
| Cash and cash equivalents, restricted cash and short-term marketable securities | $  14.8           | $  13.5           | $  8.8            |
| Committed global credit facilities  (1)                                         | $  10.0           | $  10.0           | $  10.0           |

(1) Refer to note O, "Borrowings," for additional information.

The indenture governing our debt securities and our various credit facilities each contain significant covenants which obligate the company to promptly pay principal and interest, limit the aggregate amount of secured indebtedness and sale and leaseback transactions to 10 percent of IBM's consolidated net tangible assets, and restrict our ability to merge or consolidate unless certain conditions are met. The credit facilities also include a covenant on our consolidated net interest expense ratio, which cannot be less than 2.20 to 1.0, as well as a cross default provision with respect to other defaulted indebtedness of at least $500 million.

We are in compliance with all of our significant debt covenants and provide periodic certification to our lenders. The failure to comply with debt covenants could constitute an event of default with respect to our debt to which such provisions apply. If certain events of default were to occur, the principal and interest on the debt to which such event of default applied would become immediately due and payable.

We do not have "ratings trigger" provisions in our debt covenants or documentation, which would allow the holders to declare an event of default and seek to accelerate payments thereunder in the event of a change in credit rating. Our debt covenants are well within the required levels. Our contractual agreements governing derivative instruments contain standard market clauses which can trigger the termination of the agreement if IBM's credit rating were to fall below investment grade. At December 31, 2024, the fair value of those instruments that were in a liability position was $726 million, before any applicable netting, and this position is subject to fluctuations in fair value period to period based on the level of our outstanding instruments and market conditions. We have no other contractual arrangements that, in the event of a change in credit rating, would result in a material adverse effect on our financial position or liquidity.

The following table presents the major ratings agencies' ratings assigned to our debt securities as of December 31, 2024. The Moody's, Standard and Poor's and Fitch's ratings remain unchanged from December 31, 2023.


| IBM Ratings           | Standard  and Poor's   | Moody's  Investors  Service   | Fitch  Ratings   |
|-----------------------|------------------------|-------------------------------|------------------|
| Senior long-term debt | A-                     | A3                            | A-               |
| Commercial paper      | A-2                    | Prime-2                       | F1               |

We have financial flexibility, supported by our strong liquidity position and cash flows, to operate at a single A credit rating. Debt levels decreased $1.6 billion from December 31, 2023 primarily driven by currency, and maturities of $6.6 billion partially offset by proceeds from issuances of $5.7 billion in the current year. In the first quarter of 2025, we issued $8.4 billion of debt for general

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

corporate purposes, including our future debt maturity obligations, as well as capital allocation priorities. Refer to note V, "Subsequent Events," for additional information.

We prepare our Consolidated Statement of Cash Flows in accordance with applicable accounting standards for cash flow presentation on page 49 and highlight causes and events underlying sources and uses of cash in that format on page 27. For the purpose of running its business, IBM manages, monitors and analyzes cash flows in a different manner.

Management uses free cash flow as a measure to evaluate its operating results, plan shareholder return levels, strategic investments and assess its ability and need to incur and service debt. The entire free cash flow amount is not necessarily available for discretionary expenditures. We define free cash flow as net cash from operating activities less the change in Financing receivables and net capital expenditures, including the investment in software and other asset sales (e.g., the sale of certain QRadar SaaS assets). A key objective of the Financing business is to generate strong returns on equity, and our Financing receivables are the basis for that growth. Accordingly, management considers Financing receivables as a profit-generating investment, not as working capital that should be minimized for efficiency. Therefore, management includes presentations of both free cash flow and net cash from operating activities that exclude the effect of Financing receivables.

The following is management's view of cash flows for 2024, 2023 and 2022 prepared in a manner consistent with the description above.


| ($ in billions)                                                                         |         |         |           |
|-----------------------------------------------------------------------------------------|---------|---------|-----------|
| For the year ended December 31:                                                         | 2024    | 2023    | 2022  (1) |
| Net cash from operating activities per GAAP                                             | $  13.4 | $  13.9 | $  10.4   |
| Less: change in Financing receivables                                                   | (0.4)   | 1.2     | (0.7)     |
| Net cash from operating activities, excluding Financing receivables                     | 13.9    | 12.7    | 11.2      |
| Capital expenditures, net                                                               | (1.1)   | (1.5)   | (1.9)     |
| Free cash flow                                                                          | 12.7    | 11.2    | 9.3       |
| Change in Financing receivables  (2)                                                    | (0.4)   | 1.2     | (0.7)     |
| Acquisitions                                                                            | (3.3)   | (5.1)   | (2.3)     |
| Divestitures                                                                            | 0.7     | 0.0     | 1.3       |
| Dividends                                                                               | (6.1)   | (6.0)   | (5.9)     |
| Change in total debt  (2)                                                               | (0.9)   | 4.5     | 1.2       |
| Other  (2)                                                                              | (1.0)   | (1.2)   | (1.2)     |
| Effect of exchange rate changes on cash, cash equivalents and restricted  cash  (2)     | (0.4)   | 0.0     | (0.2)     |
| Change in cash, cash equivalents, restricted cash and short-term  marketable securities | $  1.3  | $  4.6  | $  1.3    |

(1) Includes immaterial cash flows from discontinued operations.

(2) Prior-year amounts have been reclassified to conform to the change in 2024 presentation.

From the perspective of how management views cash flow, in 2024, after investing $1.1 billion in net capital investments, we generated free cash flow of $12.7 billion, an increase of $1.5 billion versus the prior year. The year-to-year increase in free cash flow primarily reflects current year performance-related improvements within net income and sustainable lower cash requirements through changes in our retirement plans. In 2024, net capital expenditures and net cash from operating activities include $0.4 billion and $0.1 billion, respectively, of cash proceeds from the sale of certain QRadar SaaS assets. This benefit to net capital expenditures, net cash from operating activities and to free cash flow represented only a nominal net benefit to current-year cash flows due to payments for structural actions and foregone profit from the QRadar business. Refer to note E, "Acquisitions & Divestitures," for additional information. In 2024, we continued to return value to shareholders with $6.1 billion in dividends and invested $3.3 billion in acquisitions.

IBM's Board of Directors considers the dividend payment on a quarterly basis. In the second quarter of 2024, the Board of Directors increased the company's quarterly common stock dividend from $1.66 to $1.67 per share. Beginning in the first quarter of 2025, we expect to file our quarterly reports on Form 10-Q closer to the timing of our quarterly earnings release, which may not coincide with the timing of our Board of Directors meeting. If the company's Board of Directors approves a common stock dividend following the filing, the company will disclose this event in a current report on Form 8-K.

Events that could temporarily change the historical cash flow dynamics discussed previously include significant changes in operating results, material changes in geographic sources of cash, unexpected adverse impacts from litigation, future pension

## 36 Management Discussion

International Business Machines Corporation and Subsidiary Companies

funding requirements during periods of severe downturn in the capital markets or the timing of tax payments. Whether any litigation has such an adverse impact will depend on a number of variables, which are more completely described in note Q, "Commitments & Contingencies."

With respect to pension funding, in 2024, we contributed $79 million to our non-U.S. defined benefit plans compared to $70 million in 2023. As highlighted in the Contractual Obligations table, we expect to make legally mandated pension plan contributions to certain non-U.S. plans of approximately $0.7 billion in the next five years. The 2025 contributions are currently expected to be approximately $100 million. Contributions related to all retirement-related plans are expected to be approximately $1.3 billion in 2025, approximately flat compared to 2024. Refer to "Retirement-Related Plans" within the "Looking Forward" section for additional information. Financial market performance could increase the legally mandated minimum contributions in certain nonU.S. countries that require more frequent remeasurement of the funded status. We are not quantifying any further impact from pension funding because it is not possible to predict future movements in the capital markets or pension plan funding regulations. In 2025, we are not legally required to make any contributions to the U.S. defined benefit pension plans.

Our cash flows are sufficient to fund our current operations and obligations, including investing and financing activities such as dividends and debt service. When additional requirements arise, we have several liquidity options available. These options may include the ability to borrow additional funds at reasonable interest rates and utilizing our committed global credit facilities. Our overall shareholder payout remains at a comfortable level, and we remain fully committed to our long-standing dividend policy.

## Contractual Obligations


| ($ in millions)                                               | Total Contractual   |           | Payments Due In   |           |            |
|---------------------------------------------------------------|---------------------|-----------|-------------------|-----------|------------|
|                                                               | Payment Stream      |           |                   |           |            |
|                                                               |                     | 2025      | 2026-27           | 2028-29   | After 2029 |
| Long-term debt obligations                                    | $  55,111           | $  4,850  | $  12,326         | $  8,503  | $  29,433  |
| Interest on long-term debt obligations                        | 21,441              | 1,901     | 3,132             | 2,467     | 13,942     |
| Finance lease obligations  (1)                                | 1,000               | 198       | 334               | 286       | 183        |
| Operating lease obligations  (1)                              | 4,026               | 906       | 1,417             | 765       | 938        |
| Purchase obligations                                          | 4,892               | 1,657     | 1,880             | 1,065     | 291        |
| Other long-term liabilities:                                  |                     |           |                   |           |            |
| Minimum defined benefit pension plan  funding (mandated)  (2) | 700                 | 100       | 300               | 300       |            |
| Excess Savings Plan                                           | 1,674               | 229       | 482               | 513       | 450        |
| Long-term termination benefits                                | 785                 | 214       | 113               | 78        | 380        |
| Tax reserves  (3)                                             | 5,355               | 46        |                   |           |            |
| Other                                                         | 597                 | 97        | 118               | 84        | 298        |
| Total                                                         | $  95,582           | $  10,198 | $  20,100         | $  14,061 | $  45,915  |

(1) Finance lease obligations are presented on a discounted cash flow basis, whereas operating lease obligations are presented on an undiscounted cash flow basis.

(2) As funded status on plans will vary, obligations for mandated minimum pension payments after 2028 could not be reasonably estimated.

(3) These amounts represent the liability for unrecognized tax benefits. We estimate that approximately $46 million of the liability is expected to be settled within the next 12 months. The settlement period for the noncurrent portion of the income tax liability cannot be reasonably estimated as the timing of the payments will depend on the progress of tax examinations with the various tax authorities; however, it is not expected to be due within the next 12 months.

Certain contractual obligations reported in the previous table exclude the effects of time value and therefore, may not equal the amounts reported in the Consolidated Balance Sheet. Certain noncurrent liabilities are excluded from the previous table as their future cash outflows are uncertain. This includes deferred taxes, derivatives, deferred income, disability benefits and other sundry items. Certain obligations related to our divestitures are included.

Purchase obligations include all commitments to purchase goods or services of either a fixed or minimum quantity that meet any of the following criteria: (1) they are noncancelable, (2) we would incur a penalty if the agreement was canceled, or (3) we must make specified minimum payments even if we do not take delivery of the contracted products or services (take-or-pay). If the obligation to purchase goods or services is noncancelable, the entire value of the contract is included in the previous table. If the obligation is cancelable, but we would incur a penalty if canceled, the dollar amount of the penalty is included as a purchase obligation. Contracted minimum amounts specified in take-or-pay contracts are also included in the table as they represent the portion of each contract that is a firm commitment.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

In the ordinary course of business, we enter into contracts that specify that we will purchase all or a portion of our requirements of a specific product, commodity or service from a supplier or vendor. These contracts are generally entered into in order to secure pricing or other negotiated terms. They do not specify fixed or minimum quantities to be purchased and, therefore, we do not consider them to be purchase obligations.

Interest on floating-rate debt obligations is calculated using the effective interest rate at December 31, 2024, plus the interest rate spread associated with that debt, if any.

## Off-Balance Sheet Arrangements

In the normal course of business, we may enter into off-balance sheet arrangements such as client financing commitments and guarantees. At December 31, 2024, we had no off-balance sheet arrangements that have, or are reasonably likely to have, a material current or future effect on our financial condition, changes in financial condition, revenues or expenses, results of operations, liquidity, capital expenditures or capital resources. Refer to the table above for our contractual obligations, and note Q, "Commitments & Contingencies," for detailed information about our guarantees, financial commitments and indemnification arrangements. We do not have retained interests in assets transferred to unconsolidated entities or other material off-balance sheet interests or instruments.

## Critical Accounting Estimates

The application of GAAP requires IBM to make estimates and assumptions about certain items and future events that directly affect its reported financial condition. The accounting estimates and assumptions discussed in this section are those that we consider to be the most critical to our financial statements. An accounting estimate is considered critical if both (a) the nature of the estimate or assumption is material due to the levels of subjectivity and judgment involved, and (b) the impact within a reasonable range of outcomes of the estimate and assumption is material to IBM's financial condition. Senior management has discussed the development, selection and disclosure of these estimates with the Audit Committee of IBM's Board of Directors. Our significant accounting policies are described in note A, "Significant Accounting Policies."

A quantitative sensitivity analysis is provided where that information is reasonably available, can be reliably estimated and provides material information to investors. The amounts used to assess sensitivity (e.g., 1 percent, 10 percent, etc.) are included to allow users of the financial statements to understand a general direction cause and effect of changes in the estimates and do not represent management's predictions of variability. For all of these estimates, it should be noted that future events rarely develop exactly as forecasted, and estimates require regular review and adjustment.

## Pension Assumptions

For our defined benefit pension plans, the measurement of the benefit obligation to plan participants and net periodic pension (income)/cost requires the use of certain assumptions, including, among others, estimates of discount rates, interest crediting rates and expected return on plan assets. Beginning in 2024, as a result of changes to the Qualified PPP as discussed in note U, "Retirement-Related Benefits," the interest crediting rate and expected return on plan assets will be based on their relationship to the plan's discount rate.

Changes in the discount rate and the interest crediting rate assumptions would impact the service cost, (gain)/loss amortization and interest cost components of the net periodic pension (income)/cost calculation and the projected benefit obligation (PBO). Changes in the expected long-term return on plan assets assumption impacts the net periodic pension (income)/cost. Expected returns on plan assets are calculated based on the market-related value of plan assets, which recognizes changes in the fair value of plan assets systematically over a five-year period in the expected return on plan assets line in net periodic pension (income)/cost. The differences between the actual return on plan assets and the expected long-term return on plan assets are recognized over five years in the expected return on plan assets line in net periodic pension (income)/cost and also as a component of actuarial (gains)/ losses, which are recognized over the service lives or life expectancy of the participants, depending on the plan, provided such amounts exceed thresholds which are based upon the benefit obligation or the value of plan assets, as provided by accounting standards.

The discount rate assumption for the Qualified PPP and Excess Personal Pension Plan (U.S. Defined Benefit Pension Plans), increased by 50 basis points to 5.5 percent on December 31, 2024. This change will increase pre-tax income recognized in 2025 by an estimated $104 million. A 25 basis point increase in the discount rate assumption would cause a corresponding increase in the pre-tax income recognized in 2025 by an estimated $75 million. A 25 basis point decrease in the discount rate assumption would cause a corresponding decrease in the pre-tax income recognized in 2025 by an estimated $27 million. The impact on pre-tax income as a result of a change in discount rate includes the impact of a similar change in the interest crediting rate. The increase or decrease in the discount rate would also cause a corresponding increase or decrease, respectively, in the 2025 expected return on plan assets assumption. Further changes in the discount rate assumptions would impact the PBO which, in turn, may impact our funding decisions if the PBO exceeds plan assets. A 25 basis point increase in the discount rate would decrease the PBO by $256 million. A 25 basis point decrease in the discount rate would increase the PBO by $265 million. The impact on the PBO as a result of a change in discount rate includes the impact of a similar change in the interest crediting rate. Each 50 basis point change in the

## 38 Management Discussion

International Business Machines Corporation and Subsidiary Companies

expected long-term return on these U.S. defined benefit plan assets assumption would have an estimated impact of $98 million on the following year's pre-tax net periodic pension (income)/cost (based upon the 2025 assumptions).

We may voluntarily make contributions or be required, by law, to make contributions to our pension plans. Actual results that differ from the estimates may result in more or less future IBM funding into the pension plans than is planned by management. Impacts of these types of changes on our pension plans in other countries worldwide would vary depending upon the status of each respective plan.

In addition to the above, we evaluate other pension assumptions involving demographic factors, such as retirement age and mortality, and update these assumptions to reflect experience and expectations for the future. Actual results in any given year can differ from actuarial assumptions because of economic and other factors.

For additional information on our pension plans and the development of these assumptions, refer to note U, "Retirement-Related Benefits."

## Revenue Recognition

Application of GAAP related to the measurement and recognition of revenue requires us to make judgments and estimates. Specifically, complex arrangements with nonstandard terms and conditions may require significant contract interpretation to determine the appropriate accounting, including whether promised goods and services specified in an arrangement are distinct performance obligations. Other significant judgments include determining the standalone selling price (SSP), determining whether IBM or a reseller is acting as the principal in a transaction and whether separate contracts should be combined and considered part of one arrangement.

Revenue recognition is also impacted by our ability to determine when a contract is probable of collection and to estimate variable consideration, including, for example, rebates, volume discounts, service-level penalties and performance bonuses. We consider various factors when making these judgments, including a review of specific transactions, historical experience and market and economic conditions. Evaluations are conducted each quarter to assess the adequacy of the estimates. If the estimates were changed by 10 percent in 2024, the impact on net income would have been $31 million.

## Costs to Complete Service Contracts

We enter into numerous service contracts through our services businesses. During the contractual period, revenue, cost and profits may be impacted by estimates of the ultimate profitability of each contract, especially contracts for which we use cost-to-cost measures of progress. For those contracts, if at any time these estimates indicate the contract will be unprofitable, the entire estimated loss for the remainder of the contract is recorded immediately in cost. We perform ongoing profitability analyses of these services contracts in order to determine whether the latest estimates require updating. Key factors reviewed to estimate the future costs to complete each contract are future labor costs and product costs and expected productivity efficiencies. Contract loss provisions recorded as a component of other accrued expenses and liabilities were immaterial at December 31, 2024 and 2023.

## Income Taxes

We are subject to income taxes in the U.S. and numerous foreign jurisdictions. Significant judgment is required in determining the consolidated provision for income taxes.

During the ordinary course of business, there are many transactions and calculations for which the ultimate tax determination is uncertain. As a result, we recognize tax liabilities based on estimates of whether additional taxes and interest will be due. These tax liabilities are recognized when, despite our belief that our tax return positions are supportable, we believe that certain positions may not be fully sustained upon review by tax authorities. We believe that our accruals for tax liabilities are adequate for all open audit years based on our assessment of many factors, including past experience and interpretations of tax law. This assessment relies on estimates and assumptions and may involve a series of complex judgments about future events. To the extent that new information becomes available which causes us to change our judgment regarding the adequacy of existing tax liabilities, such changes to tax liabilities will impact income tax expense in the period in which such determination is made.

Significant judgment is also required in determining any valuation allowance recorded against deferred tax assets. In assessing the need for a valuation allowance, management considers all available evidence for each jurisdiction including past operating results, estimates of future taxable income and the feasibility of ongoing tax planning strategies/actions. In the event that we change our determination as to the amount of deferred tax assets that can be realized, we will adjust the valuation allowance with a corresponding impact to income tax expense in the period in which such determination is made.

The consolidated provision for income taxes will change period to period based on non-recurring events, such as the settlement of income tax audits and changes in tax laws, as well as recurring factors including the geographic mix of income before taxes, state and local taxes and the effects of various global income tax strategies.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

To the extent that the provision for income taxes increases/decreases by 1 percent of income from continuing operations before income taxes, consolidated net income would have decreased/improved by $58 million in 2024.

## Valuation of Assets

The application of business combination and impairment accounting requires the use of significant estimates and assumptions. The acquisition method of accounting for business combinations requires us to estimate the fair value of assets acquired including separately identifiable intangible assets, liabilities assumed, and any noncontrolling interest in the acquiree to properly allocate purchase price consideration. Impairment testing for assets, other than goodwill, requires the allocation of cash flows to those assets or group of assets and if required, an estimate of fair value for the assets or group of assets. Our estimates are based upon assumptions believed to be reasonable, but which are inherently uncertain and unpredictable. These valuations require the use of management's assumptions, which would not reflect unanticipated events and circumstances that may occur.

## Valuation of Goodwill

We review goodwill for impairment annually and whenever events or changes in circumstances indicate the carrying value of goodwill may not be recoverable. In 2024, the company elected to bypass the qualitative assessment and performed a quantitative goodwill impairment test to compare the fair value of each reporting unit to its carrying value. Estimating the fair value of a reporting unit is judgmental in nature and involves the use of significant estimates and assumptions. We estimate the fair value of our reporting units using the income approach. When circumstances warrant, we may also use a combination of the income approach and certain market approaches. Under the income approach, we estimate the fair value of a reporting unit based on the present value of estimated discounted future cash flows. The discounted cash flow methodology includes the use of projections, which require the use of significant estimates and assumptions specific to the reporting unit as well as those based on general economic conditions. Factors specific to each reporting unit include revenue growth rates, gross margins, discount rates, terminal value growth rates, capital expenditures projections, assumed tax rates and other assumptions deemed reasonable by management.

The annual goodwill impairment analysis using the quantitative test performed during the fourth quarter of 2024 did not result in an impairment charge. All of the company's reporting units had fair values that substantially exceeded their carrying values.

## Loss Contingencies

We are currently involved in various claims and legal proceedings. At least quarterly, we review the status of each significant matter and assess our potential financial exposure. If the potential loss from any claim or legal proceeding is considered probable and the amount can be reasonably estimated, we accrue a liability for the estimated loss. Significant judgment is required in both the determination of probability and the determination as to whether an exposure is reasonably estimable. Because of uncertainties related to these matters, accruals are based only on the best information available at the time. As additional information becomes available, we reassess the potential liability related to our pending claims and litigation, and may revise our estimates. These revisions in the estimates of the potential liabilities could have a material impact on our results of operations and financial position.

## Financing Receivables Allowance for Credit Losses

The Financing business reviews its financing receivables portfolio on a regular basis in order to assess collectibility and records adjustments to the allowance for credit losses at least quarterly. A description of the methods used by management to estimate the amount of uncollectible receivables is included in note A, "Significant Accounting Policies." Factors that could result in actual receivable losses that are materially different from the estimated reserve include significant changes in the economy, or a sudden change in the economic health of a client that represents a significant concentration in Financing's receivables portfolio.

To the extent that actual collectibility differs from management's estimates currently provided for by 10 percent, Financing's segment profit and our income from continuing operations before income taxes would be higher or lower by an estimated $13 million depending upon whether the actual collectibility was better or worse, respectively, than the estimates.

## Currency Rate Fluctuations

Changes in the relative values of non-U.S. currencies to the U.S. dollar affect our financial results and financial position. Movements in currency, and the fact that we do not hedge 100 percent of our currency exposures, resulted in a currency impact to our revenues, profit and cash flows throughout 2024. We execute a hedging program which defers, versus eliminates, the volatility of currency impacts on our financial results. During periods of sustained movements in currency, the marketplace and competition adjust to the changing rates over time.

References to "adjusted for currency" or "constant currency" reflect adjustments based upon a simple mathematical formula. However, this constant currency methodology that we utilize to disclose this information does not incorporate any operational actions that management could take to mitigate fluctuating currency rates. Based on the currency rate movements in 2024, revenue from continuing operations increased 1.4 percent as reported and 3 percent at constant currency versus 2023.

## 40 Management Discussion

International Business Machines Corporation and Subsidiary Companies

At December 31, 2024, currency changes resulted in assets and liabilities denominated in most local currencies being translated into fewer U.S. dollars than at year-end 2023. We use financial hedging instruments to limit specific currency risks related to foreign currency-based transactions.

We translate revenue, cost and expense in our non-U.S. operations at current exchange rates in the reported period. Currency translation and hedging impacted year-to-year pre-tax income growth and operating (non-GAAP) pre-tax income growth by approximately $100 million in 2024. From a segment perspective, in 2024, the impact from currency translation and hedging to our segments profit margin year-to-year growth was immaterial. We view these amounts as a theoretical maximum impact to our asreported financial results. Hedging and certain underlying foreign currency transaction gains and losses are allocated to our segment results. Considering the operational responses mentioned above, movements of exchange rates, and the nature and timing of hedging instruments, it is difficult to predict future currency impacts on any particular period.

For non-U.S. subsidiaries and branches that operate in U.S. dollars or whose economic environment is highly inflationary, translation adjustments are reflected in results of operations. Generally, we manage currency risk in these entities by linking prices and contracts to U.S. dollars.

## Market Risk

In the normal course of business, our financial position is routinely subject to a variety of risks, including the market risk associated with interest rate and currency movements on outstanding debt and non-U.S. dollar denominated assets and liabilities, and other risks such as collectibility of accounts receivable.

We regularly assess these risks and have established policies and business practices to protect against the adverse effects of these and other potential exposures. As a result, we do not anticipate any material losses from these risks.

Our debt, in support of the geographic breadth of our operations and our Financing business, contains an element of market risk from changes in interest and currency rates. We manage this risk, in part, through the use of a variety of financial instruments including derivatives, as described in note S, "Derivative Financial Instruments."

To meet disclosure requirements, we perform a sensitivity analysis to determine the effects that market risk exposures may have on the fair values of our debt and other financial instruments.

The financial instruments that are included in the sensitivity analysis are comprised of our cash and cash equivalents, marketable securities, short-term and long-term loans, commercial financing and installment payment receivables, investments, long-term and short-term debt and derivative financial instruments. Our derivative financial instruments generally include interest rate swaps, foreign currency swaps, forward contracts, and options.

To perform the sensitivity analysis, we assess the risk of loss in fair values from the effect of hypothetical changes in interest rates and foreign currency exchange rates on market-sensitive instruments. The market values for interest and foreign currency exchange risk are computed based on the present value of future cash flows as affected by the changes in rates that are attributable to the market risk being measured. The discount rates used for the present value computations were selected based on market interest and foreign currency exchange rates in effect at December 31, 2024 and 2023. The differences in this comparison are the hypothetical losses associated with each type of risk.

Information provided by the sensitivity analysis does not necessarily represent the actual changes in fair value that we would incur under normal market conditions because, due to practical limitations, all variables other than the specific market risk factor are held constant. In addition, the results of the model are constrained by the fact that certain items are specifically excluded from the analysis, while the financial instruments relating to the financing or hedging of those items are included by definition. Excluded items include short-term and long-term receivables from sales-type and direct financing leases, forecasted foreign currency cash flows and the company's net investment in foreign operations. As a consequence, reported changes in the values of some of the financial instruments impacting the results of the sensitivity analysis are not matched with the offsetting changes in the values of the items that those instruments are designed to finance or hedge.

The results of the sensitivity analysis at December 31, 2024 and 2023, are as follows:

## Interest Rate Risk

A hypothetical 10 percent adverse change in the levels of interest rates, with all other variables held constant, would result in a decrease in the fair value of our financial instruments of approximately $0.3 billion at both December 31, 2024 and 2023. Changes in the relative sensitivity of the fair value of our financial instrument portfolio for these theoretical changes in the level of interest rates from the prior year are primarily driven by changes in debt maturities, interest rate profile and amount.

## Management Discussion

International Business Machines Corporation and Subsidiary Companies

## Foreign Currency Exchange Rate Risk

A hypothetical 10 percent adverse change in the levels of foreign currency exchange rates relative to the U.S. dollar, with all other variables held constant, would result in a decrease in the fair value of our financial instruments of approximately $1.3 billion and $1.6 billion at December 31, 2024 and 2023, respectively. The theoretical changes from the prior year are primarily driven by changes in foreign currency activities related to long-term debt and derivatives.

## Financing Risks

Refer to the "Description of Business" on page 14 for a discussion of the financing risks associated with the Financing business and management's actions to mitigate such risks.

## FINANCING

Financing is a reportable segment that facilitates IBM clients' acquisition of hardware, software and services by providing financing solutions, while generating solid returns on equity.

## Results of Operations

($ in millions)


| For the year ended December 31:   | 2024   | 2023   | Yr.-to-Yr.  Percent  Change   |
|-----------------------------------|--------|--------|-------------------------------|
| Revenue                           | $  713 | $  741 | (3.7) %                       |
| Segment profit  (1)               | $  348 | $  373 | (6.6) %                       |

(1) Prior-year amounts recast to reflect January 2024 segment changes.

Financing revenue decreased 3.7 percent (2.5 percent adjusted for currency) to $713 million compared to the prior year. Financing segment profit decreased 6.6 percent to $348 million compared to the prior year and the segment profit margin of 48.8 percent decreased 1.5 points. The decreases in revenue and segment profit are primarily driven by a reduction in used equipment sales.

## Financial Position


| ($ in millions)                                               |           |           |
|---------------------------------------------------------------|-----------|-----------|
| At December 31:                                               | 2024      | 2023      |
| Cash and cash equivalents                                     | $  561    | $  555    |
| Client financing receivables                                  |           |           |
| Net investment in sales-type and direct financing leases  (1) | 3,490     | 4,237     |
| Client loans                                                  | 6,804     | 6,486     |
| Total client financing receivables                            | $  10,294 | $  10,723 |
| Commercial financing receivables                              |           |           |
| Held for investment                                           | 1,317     | 1,155     |
| Held for sale                                                 | 900       | 692       |
| Other receivables                                             | 17        | 26        |
| Total external receivables  (2)                               | $  12,528 | $  12,596 |
| Intercompany assets  (3)                                      | 800       | 963       |
| Other assets                                                  | 187       | 294       |
| Total assets                                                  | $  14,075 | $  14,409 |
| Debt  (4)                                                     | 12,116    | 11,879    |
| Other liabilities  (5)(6)                                     | 613       | 1,205     |
| Total liabilities  (5)                                        | $  12,729 | $  13,085 |
| Total equity  (5)                                             | $  1,346  | $  1,324  |
| Total liabilities and equity                                  | $  14,075 | $  14,409 |

(1) Includes deferred initial direct costs which are expensed in IBM's consolidated financial results.

(2) The difference between the change in total external receivables of $(0.1) billion and the $(0.4) billion change in Financing segment's receivables disclosed in the free cash flow presentation on page 35 is primarily attributable to currency impacts.

(3) Total amount is eliminated in IBM's consolidated financial results and therefore does not appear in the Consolidated Balance Sheet.

(4) Financing segment debt is primarily composed of intercompany loans.

(5) Prior-year amounts recast to reflect January 2024 segment change. Other liabilities have been reclassified to conform to the change in 2024 presentation.

(6) Includes intercompany payables of $0.4 billion at December 31, 2023. There were no intercompany payables outstanding at December 31, 2024. These intercompany payables were eliminated in IBM's consolidated financial results.

## 42 Management Discussion

International Business Machines Corporation and Subsidiary Companies

## Financing Segment Receivables and Allowances

The following table presents external Financing segment receivables excluding receivables classified as held for sale, and immaterial miscellaneous receivables.


| ($ in millions)                         |           |           |
|-----------------------------------------|-----------|-----------|
| At December 31:                         | 2024      | 2023      |
| Amortized cost  (1)                     | $  11,738 | $  12,034 |
| Specific allowance for credit losses    | 99        | 111       |
| Unallocated allowance for credit losses | 29        | 45        |
| Total allowance for credit losses       | 128       | 156       |
| Net financing receivables               | $  11,611 | $  11,878 |
| Allowance for credit losses coverage    | 1.1 %     | 1.3 %     |

(1) Includes deferred initial direct costs which are expensed in IBM's consolidated financial results.

The percentage of Financing segment receivables reserved decreased from 1.3 percent at December 31, 2023, to 1.1 percent at December 31, 2024 primarily driven by improvements in forward looking economic indicators.

We continue to apply our rigorous credit policies. Approximately 74 percent of the total external portfolio was with investmentgrade clients, an increase of 2 points compared to December 31, 2023. This investment grade percentage is based on the credit ratings of the companies in the portfolio and reflects certain mitigating actions taken to reduce the risk to IBM.

For additional information related to the company 's sales of receivables, refer to "Transfer of Financial Assets" in note K, "Financing Receivables."

## Return on Equity Calculation


|                                             | ($ in millions)   | ($ in millions)   |
|---------------------------------------------|-------------------|-------------------|
| At December 31:                             | 2024              | 2023  (1)         |
| Numerator                                   |                   |                   |
| Financing after-tax segment profit (A)  (2) | $  287            | $  311            |
| Denominator                                 |                   |                   |
| Average Financing equity (B)  (3)           | $  1,231          | $  1,240          |
| Financing return on equity (A)/(B)          | 23.3 %            | 25.1 %            |

(1) Recast to reflect January 2024 segment changes.

(2) Calculated based upon an estimated tax rate, which is a function of IBM's provision for income taxes determined on a consolidated basis.

(3) Average of the ending equity for Financing for the last five quarters.

Return on equity was 23.3 percent compared to 25.1 percent for the years ended December 31, 2024 and 2023, respectively. The decrease was driven by a decrease in net income.

## Residual Value

The following table presents the recorded amount of unguaranteed residual value for sales-type and direct financing leases at December 31, 2024 and 2023. In addition, the table presents the run out of when the unguaranteed residual value assigned to equipment on leases at December 31, 2024, is expected to be returned to the company. The unguaranteed residual value for operating leases at December 31, 2024 and 2023 was not material. For additional information related to the company 's residual value, refer to note A, "Significant Accounting Policies."

## Unguaranteed Residual Value


|                                        |                      |                      | Estimated Run Out of December 31, 2024 Balance   | Estimated Run Out of December 31, 2024 Balance   | Estimated Run Out of December 31, 2024 Balance   | Estimated Run Out of December 31, 2024 Balance   |
|----------------------------------------|----------------------|----------------------|--------------------------------------------------|--------------------------------------------------|--------------------------------------------------|--------------------------------------------------|
|                                        | At December 31, 2023 | At December 31, 2024 | 2025                                             | 2026                                             | 2027                                             | 2028 and Beyond                                  |
| Sales-type and direct financing leases | $  458               | $  479               | $  145                                           | $  115                                           | $  141                                           | $  78                                            |

## Report of Management

International Business Machines Corporation and Subsidiary Companies

## Management Responsibility for Financial Information

Responsibility for the integrity and objectivity of the financial information presented in this Annual Report rests with IBM management. The accompanying financial statements have been prepared in accordance with accounting principles generally accepted in the United States of America, applying certain estimates and judgments as required.

IBM maintains an effective internal control structure. It consists, in part, of organizational arrangements with clearly defined lines of responsibility and delegation of authority, and comprehensive systems and control procedures. An important element of the control environment is an ongoing internal audit program. Our system also contains self-monitoring mechanisms, and actions are taken to correct deficiencies as they are identified.

To assure the effective administration of internal controls, we carefully select and train our employees, develop and disseminate written policies and procedures, provide appropriate communication channels and foster an environment conducive to the effective functioning of controls. We believe that it is essential for the company to conduct its business affairs in accordance with the highest ethical standards, as set forth in the IBM Business Conduct Guidelines. These guidelines, translated into numerous languages, are distributed to employees throughout the world, and reemphasized through internal programs to assure that they are understood and followed.

The Audit Committee of the Board of Directors is composed solely of independent, non-management directors, and is responsible for recommending to the Board the independent registered public accounting firm to be retained for the coming year, subject to stockholder ratification. The Audit Committee meets regularly and privately with the independent registered public accounting firm, with the company's internal auditors, as well as with IBM management, to review accounting, auditing, internal control structure and financial reporting matters.

## Management's Report on Internal Control Over Financial Reporting

Management is responsible for establishing and maintaining adequate internal control over financial reporting of the company. Internal control over financial reporting is a process designed to provide reasonable assurance regarding the reliability of financial reporting and the preparation of financial statements for external purposes in accordance with accounting principles generally accepted in the United States of America.

The company's internal control over financial reporting includes those policies and procedures that (i) pertain to the maintenance of records that, in reasonable detail, accurately and fairly reflect the transactions and dispositions of the assets of the company; (ii) provide reasonable assurance that transactions are recorded as necessary to permit preparation of financial statements in accordance with accounting principles generally accepted in the United States of America, and that receipts and expenditures of the company are being made only in accordance with authorizations of management and directors of the company; and (iii) provide reasonable assurance regarding prevention or timely detection of unauthorized acquisition, use, or disposition of the company's assets that could have a material effect on the financial statements.

Because of its inherent limitations, internal control over financial reporting may not prevent or detect misstatements. Also, projections of any evaluation of effectiveness to future periods are subject to the risk that controls may become inadequate because of changes in conditions, or that the degree of compliance with the policies or procedures may deteriorate.

Management conducted an evaluation of the effectiveness of internal control over financial reporting based on the criteria established in Internal Control-Integrated Framework (2013) issued by the Committee of Sponsoring Organizations of the Treadway Commission (COSO). Based on this evaluation, management concluded that the company's internal control over financial reporting was effective as of December 31, 2024.

PricewaterhouseCoopers LLP, an independent registered public accounting firm, is retained to audit IBM's Consolidated Financial Statements and the effectiveness of the internal control over financial reporting. Its accompanying report is based on audits conducted in accordance with the standards of the Public Company Accounting Oversight Board (United States).

## 44 Report of Independent Registered Public Accounting Firm

International Business Machines Corporation and Subsidiary Companies

## To the Board of Directors and Stockholders of International Business Machines Corporation

## Opinions on the Financial Statements and Internal Control over Financial Reporting

We have audited the accompanying consolidated balance sheets of International Business Machines Corporation and its subsidiaries (the "Company") as of December 31, 2024 and 2023, and the related consolidated statements of income, of comprehensive income, of equity and of cash flows for each of the three years in the period ended December 31, 2024, including the related notes (collectively referred to as the "consolidated financial statements"). We also have audited the Company 's internal control over financial reporting as of December 31, 2024, based on criteria established in Internal Control - Integrated Framework (2013) issued by the Committee of Sponsoring Organizations of the Treadway Commission (COSO).

In our opinion, the consolidated financial statements referred to above present fairly, in all material respects, the financial position of the Company as of December 31, 2024 and 2023, and the results of its operations and its cash flows for each of the three years in the period ended December 31, 2024 in conformity with accounting principles generally accepted in the United States of America. Also in our opinion, the Company maintained, in all material respects, effective internal control over financial reporting as of December 31, 2024, based on criteria established in Internal Control - Integrated Framework (2013) issued by the COSO.

## Basis for Opinions

The Company 's management is responsible for these consolidated financial statements, for maintaining effective internal control over financial reporting, and for its assessment of the effectiveness of internal control over financial reporting, included in the accompanying Management's Report on Internal Control Over Financial Reporting. Our responsibility is to express opinions on the Company's consolidated financial statements and on the Company's internal control over financial reporting based on our audits. We are a public accounting firm registered with the Public Company Accounting Oversight Board (United States) (PCAOB) and are required to be independent with respect to the Company in accordance with the U.S. federal securities laws and the applicable rules and regulations of the Securities and Exchange Commission and the PCAOB.

We conducted our audits in accordance with the standards of the PCAOB. Those standards require that we plan and perform the audits to obtain reasonable assurance about whether the consolidated financial statements are free of material misstatement, whether due to error or fraud, and whether effective internal control over financial reporting was maintained in all material respects.

Our audits of the consolidated financial statements included performing procedures to assess the risks of material misstatement of the consolidated financial statements, whether due to error or fraud, and performing procedures that respond to those risks. Such procedures included examining, on a test basis, evidence regarding the amounts and disclosures in the consolidated financial statements. Our audits also included evaluating the accounting principles used and significant estimates made by management, as well as evaluating the overall presentation of the consolidated financial statements. Our audit of internal control over financial reporting included obtaining an understanding of internal control over financial reporting, assessing the risk that a material weakness exists, and testing and evaluating the design and operating effectiveness of internal control based on the assessed risk. Our audits also included performing such other procedures as we considered necessary in the circumstances. We believe that our audits provide a reasonable basis for our opinions.

## Definition and Limitations of Internal Control over Financial Reporting

A company's internal control over financial reporting is a process designed to provide reasonable assurance regarding the reliability of financial reporting and the preparation of financial statements for external purposes in accordance with generally accepted accounting principles. A company's internal control over financial reporting includes those policies and procedures that (i) pertain to the maintenance of records that, in reasonable detail, accurately and fairly reflect the transactions and dispositions of the assets of the company; (ii) provide reasonable assurance that transactions are recorded as necessary to permit preparation of financial statements in accordance with generally accepted accounting principles, and that receipts and expenditures of the company are being made only in accordance with authorizations of management and directors of the company; and (iii) provide reasonable assurance regarding prevention or timely detection of unauthorized acquisition, use, or disposition of the company's assets that could have a material effect on the financial statements.

Because of its inherent limitations, internal control over financial reporting may not prevent or detect misstatements. Also, projections of any evaluation of effectiveness to future periods are subject to the risk that controls may become inadequate because of changes in conditions, or that the degree of compliance with the policies or procedures may deteriorate.

## Critical Audit Matters

The critical audit matter communicated below is a matter arising from the current period audit of the consolidated financial statements that was communicated or required to be communicated to the audit committee and that (i) relates to accounts or disclosures that are material to the consolidated financial statements and (ii) involved our especially challenging, subjective, or complex judgments. The communication of critical audit matters does not alter in any way our opinion on the consolidated financial statements, taken as a whole, and we are not, by communicating the critical audit matter below, providing a separate opinion on the critical audit matter or on the accounts or disclosures to which it relates.

## Income Taxes - Uncertain Tax Positions

As described in Notes A and G to the consolidated financial statements, the Company is subject to income taxes in the United States and numerous foreign jurisdictions. As disclosed by management, during the ordinary course of business there are many transactions and calculations for which the ultimate tax determination is uncertain. As a result, management recognizes tax liabilities based on estimates of whether additional taxes and interest will be due. As further described by management, these tax liabilities are recognized when, despite management's belief that the tax return positions are supportable, management believes that certain positions may not be fully sustained upon review by tax authorities. Management bases its assessment of the accruals for tax liabilities on many factors, including past experience and interpretations of tax law. These assessments rely on estimates and assumptions and may involve a series of complex judgments about future events. As of December 31, 2024, unrecognized tax benefits were $8.9 billion. .

The principal considerations for our determination that performing procedures relating to uncertain tax positions is a critical audit matter are the significant judgment by management when estimating the uncertain tax positions, including applying complex tax laws, and a high degree of estimation uncertainty based on potential for significant adjustments as a result of audits by tax authorities or other forms of tax settlement. This in turn led to a high degree of auditor judgment, effort, and subjectivity in performing procedures to evaluate management's timely identification and measurement of uncertain tax positions. Also, the evaluation of audit evidence available to support the uncertain tax positions is complex and required significant auditor judgment as the nature of the evidence is often inherently subjective, and the audit effort involved the use of professionals with specialized skill and knowledge.

Addressing the matter involved performing procedures and evaluating audit evidence in connection with forming our overall opinion on the consolidated financial statements. These procedures included testing the effectiveness of controls relating to the identification and recognition of the uncertain tax positions, and controls addressing completeness of the uncertain tax positions, as well as controls over measurement of the amount recorded. These procedures also included, among others (i) testing the information used in the calculation of the uncertain tax positions, including intercompany agreements and international, federal, and state filing positions; (ii) testing the calculation of the uncertain tax positions by jurisdiction, including management's assessment of the technical merits of tax positions and estimates of the amount of tax benefit expected to be sustained; (iii) testing the completeness of management's assessment of both the identification of uncertain tax positions and possible outcomes of each uncertain tax position; and (iv) evaluating the status and results of income tax audits pending in various tax jurisdictions. Professionals with specialized skill and knowledge were used to assist in the evaluation of the completeness and measurement of the Company's uncertain tax positions, including evaluating the reasonableness of management's assessment of whether tax positions are more-likely-than-not of being sustained and the amount of potential benefit to be realized.

PricewaterhouseCoopers LLP New York, New York February 25, 2025
<!-- image -->

We, or firms that we have ultimately acquired, have served as the Company's auditor since 1923. For the period from 1923 to 1958, the Company was audited by firms that a predecessor firm to PricewaterhouseCoopers LLP ultimately acquired.

## Consolidated Income Statement

International Business Machines Corporation and Subsidiary Companies


| ($ in millions except per share amounts) For the year ended December 31:   | Notes   | 2024        | 2023        | 2022        |
|----------------------------------------------------------------------------|---------|-------------|-------------|-------------|
| Revenue                                                                    |         |             |             |             |
| Services                                                                   |         | $  29,813   | $  30,378   | $  30,206   |
| Sales                                                                      |         | 32,231      | 30,745      | 29,673      |
| Financing                                                                  |         | 709         | 737         | 651         |
| Total revenue                                                              | C       | 62,753      | 61,860      | 60,530      |
| Cost                                                                       |         |             |             |             |
| Services                                                                   |         | 20,529      | 21,051      | 21,062      |
| Sales                                                                      |         | 6,303       | 6,127       | 6,374       |
| Financing                                                                  |         | 369         | 382         | 406         |
| Total cost                                                                 |         | 27,201      | 27,560      | 27,842      |
| Gross profit                                                               |         | 35,551      | 34,300      | 32,687      |
| Expense and other (income)                                                 |         |             |             |             |
| Selling, general and administrative                                        |         | 19,688      | 19,003      | 18,609      |
| Research, development and engineering                                      |         | 7,479       | 6,775       | 6,567       |
| Intellectual property and custom development income                        |         | (996)       | (860)       | (663)       |
| Other (income) and expense  (1)                                            | F       | 1,871       | (914)       | 5,803       |
| Interest expense                                                           | O&S     | 1,712       | 1,607       | 1,216       |
| Total expense and other (income)                                           |         | 29,754      | 25,610      | 31,531      |
| Income from continuing operations before income taxes                      |         | 5,797       | 8,690       | 1,156       |
| Provision for/(benefit from) income taxes  (1)                             | G       | (218)       | 1,176       | (626)       |
| Income from continuing operations                                          |         | 6,015       | 7,514       | 1,783       |
| Income/(loss) from discontinued operations, net of tax                     |         | 8           | (12)        | (143)       |
| Net income  (1)                                                            |         | $  6,023    | $  7,502    | $  1,639    |
| Earnings/(loss) per share of common stock  (1)                             |         |             |             |             |
| Assuming dilution                                                          |         |             |             |             |
| Continuing operations                                                      | H       | $  6.42     | $  8.15     | $  1.95     |
| Discontinued operations                                                    | H       | 0.01        | (0.01)      | (0.16)      |
| Total                                                                      | H       | $  6.43     | $  8.14     | $  1.80     |
| Basic                                                                      |         |             |             |             |
| Continuing operations                                                      | H       | $  6.53     | $  8.25     | $  1.97     |
| Discontinued operations                                                    | H       | 0.01        | (0.01)      | (0.16)      |
| Total                                                                      | H       | $  6.53     | $  8.23     | $  1.82     |
| Weighted-average number of common shares outstanding                       |         |             |             |             |
| Assuming dilution                                                          |         | 937,161,224 | 922,073,828 | 912,269,062 |
| Basic                                                                      |         | 921,767,834 | 911,210,319 | 902,664,190 |

(1) 2024 and 2022 include the impacts of pension settlement charges. Refer to note U, "Retirement-Related Benefits," for additional information .

Amounts may not add due to rounding.

The accompanying notes are an integral part of the financial statements.

## Consolidated Statement of Comprehensive Income

International Business Machines Corporation and Subsidiary Companies


| ($ in millions)                                                             |       |          |          |          |
|-----------------------------------------------------------------------------|-------|----------|----------|----------|
| For the year ended December 31:                                             | Notes | 2024     | 2023     | 2022     |
| Net income                                                                  |       | $  6,023 | $  7,502 | $  1,639 |
| Other comprehensive income/(loss), before tax                               |       |          |          |          |
| Foreign currency translation adjustments                                    | R     | 301      | 3        | 176      |
| Net changes related to available-for-sale securities                        | R     |          |          |          |
| Unrealized gains/(losses) arising during the period                         |       | 2        | 0        | (1)      |
| Reclassification of (gains)/losses to net income                            |       | -        | -        | -        |
| Total net changes related to available-for-sale securities                  |       | 2        | 0        | (1)      |
| Unrealized gains/(losses) on cash flow hedges                               | R     |          |          |          |
| Unrealized gains/(losses) arising during the period                         |       | 389      | 207      | 241      |
| Reclassification of (gains)/losses to net income                            |       | 85       | (159)    | (400)    |
| Total unrealized gains/(losses) on cash flow hedges                         |       | 474      | 47       | (158)    |
| Retirement-related benefit plans                                            | R     |          |          |          |
| Prior service costs/(credits)                                               |       | (56)     | 2        | 463      |
| Net (losses)/gains arising during the period                                |       | 70       | (3,115)  | 878      |
| Curtailments and settlements                                                |       | 3,159    | 5        | 5,970    |
| Amortization of prior service (credits)/costs                               |       | (7)      | (9)      | 12       |
| Amortization of net (gains)/losses                                          |       | 975      | 515      | 1,596    |
| Total retirement-related benefit plans                                      |       | 4,142    | (2,602)  | 8,919    |
| Other comprehensive income/(loss), before tax                               | R     | 4,919    | (2,552)  | 8,936    |
| Income tax (expense)/benefit related to items of other comprehensive income | R     | (1,426)  | 531      | (2,442)  |
| Other comprehensive income/(loss)                                           | R     | 3,492    | (2,021)  | 6,494    |
| Total comprehensive income                                                  |       | $  9,516 | $  5,481 | $  8,134 |

Amounts may not add due to rounding.

The accompanying notes are an integral part of the financial statements.

## Consolidated Balance Sheet

International Business Machines Corporation and Subsidiary Companies


| ($ in millions except per share amounts) At December 31:                                 | Notes   | 2024             | 2023          |
|------------------------------------------------------------------------------------------|---------|------------------|---------------|
| Assets                                                                                   |         |                  |               |
| Current assets                                                                           |         |                  |               |
| Cash and cash equivalents                                                                |         | $  13,947        | $  13,068     |
| Restricted cash                                                                          |         | 214              | 21            |
| Marketable securities                                                                    | I       | 644              | 373           |
| Notes and accounts receivable-trade (net of allowances of $114 in 2024 and $192 in 2023) |         | 6,804            | 7,214         |
| Short-term financing receivables                                                         | K       |                  |               |
| Held for investment (net of allowances of $109 in 2024 and $129 in 2023)                 |         | 6,259            | 6,102         |
| Held for sale                                                                            |         | 900              | 692           |
| Other accounts receivable (net of allowances of $31 in 2024 and $109 in 2023)            |         | 947              | 640           |
| Inventory                                                                                | J       | 1,289            | 1,161         |
| Deferred costs                                                                           | C       | 959              | 998           |
| Prepaid expenses and other current assets                                                |         | 2,520            | 2,639         |
| Total current assets                                                                     |         | 34,482           | 32,908        |
| Property, plant and equipment                                                            | L       | 17,691           | 18,122        |
| Less: Accumulated depreciation                                                           | L       | 11,959           | 12,621        |
| Property, plant and equipment - net                                                      | L       | 5,731            | 5,501         |
| Operating right-of-use assets-net                                                        | M       | 3,197            | 3,220         |
| Long-term financing receivables (net of allowances of $19 in 2024 and $27 in 2023)       |         |                  |               |
|                                                                                          | K       | 5,353            | 5,766         |
| Prepaid pension assets Deferred costs                                                    | U C     | 7,492  788       | 7,506  842    |
| Deferred taxes                                                                           | G       |                  |               |
|                                                                                          |         | 6,978            | 6,656         |
| Goodwill                                                                                 | N       | 60,706           | 60,178        |
| Intangible assets-net Investments and sundry assets                                      | N       | 10,660           | 11,036  1,626 |
| Total assets                                                                             |         | 1,787  $ 137,175 | $ 135,241     |
| Liabilities and equity                                                                   |         |                  |               |
| Current liabilities                                                                      |         |                  |               |
| Taxes                                                                                    | G       | $  2,033         | $  2,270      |
| Short-term debt                                                                          | I&O     | 5,089            | 6,426         |
| Accounts payable                                                                         |         | 4,032            | 4,132         |
| Compensation and benefits                                                                |         | 3,605            | 3,501         |
| Deferred income                                                                          |         | 13,907           | 13,451        |
| Operating lease liabilities                                                              | M       | 768              | 820           |
| Other accrued expenses and liabilities                                                   |         | 3,709            | 3,521         |
| Total current liabilities                                                                |         | 33,142           | 34,122        |
| Long-term debt                                                                           | I&O     | 49,884           | 50,121        |
| Retirement and nonpension postretirement benefit obligations                             | U       | 9,432            | 10,808        |
| Deferred income                                                                          |         | 3,622            | 3,533         |
| Operating lease liabilities                                                              | M       | 2,655            | 2,568         |
| Other liabilities                                                                        | P       | 11,048           | 11,475        |
| Total liabilities                                                                        |         | 109,783          | 112,628       |
| Commitments and Contingencies                                                            |         |                  |               |
| Equity                                                                                   | Q R     |                  |               |
| IBM stockholders' equity                                                                 |         |                  |               |
| Common stock, par value $.20 per share, and additional paid-in capital                   |         | 61,380           | 59,643        |
| Shares authorized: 4,687,500,000                                                         |         |                  |               |
| Shares issued (2024-2,279,164,313; 2023-2,266,911,160)                                   |         |                  |               |
| Retained earnings                                                                        |         | 151,163          | 151,276       |
| Treasury stock, at cost (shares: 2024-1,352,874,243; 2023-1,351,897,514)                 |         | (169,968)        | (169,624)     |
| Accumulated other comprehensive income/(loss)                                            |         | (15,269)         | (18,761)      |
| Total IBM stockholders' equity                                                           |         | 27,307           | 22,533        |
| Noncontrolling interests                                                                 | A       | 86               | 80            |
| Total equity                                                                             |         | 27,393           | 22,613        |
| Total liabilities and equity                                                             |         | $ 137,175        | $ 135,241     |

Amounts may not add due to rounding.

The accompanying notes are an integral part of the financial statements.

## Consolidated Statement of Cash Flows

International Business Machines Corporation and Subsidiary Companies


| ($ in millions) For the year ended December 31:                               | 2024      | 2023      | 2022     |
|-------------------------------------------------------------------------------|-----------|-----------|----------|
| Cash flows from operating activities                                          |           |           |          |
| Net income                                                                    | $  6,023  | $  7,502  | $  1,639 |
| Adjustments to reconcile net income to cash provided by operating activities  |           |           |          |
| Pension settlement charges                                                    | 3,113     | -         | 5,894    |
| Depreciation  (1)                                                             | 2,168     | 2,109     | 2,407    |
| Amortization of capitalized software and acquired intangible assets           | 2,499     | 2,287     | 2,395    |
| Stock-based compensation                                                      | 1,311     | 1,133     | 987      |
| Deferred taxes                                                                | (2,330)   | (1,114)   | (2,726)  |
| Net (gain)/loss on divestitures, asset sales and other                        | (652)     | (170)     | (363)    |
| Change in operating assets and liabilities, net of acquisitions/divestitures  |           |           |          |
| Receivables (including financing receivables)                                 | (374)     | 725       | (539)    |
| Retirement related                                                            | 265       | (462)     | 331      |
| Inventory                                                                     | (166)     | 390       | 71       |
| Other assets/other liabilities                                                | 1,601     | 1,466     | 126      |
| Accounts payable                                                              | (13)      | 65        | 213      |
| Net cash provided by operating activities                                     | 13,445    | 13,931    | 10,435   |
| Cash flows from investing activities                                          |           |           |          |
| Payments for property, plant and equipment                                    | (1,048)   | (1,245)   | (1,346)  |
| Proceeds from disposition of property, plant and equipment/other              | 557       | 321       | 111      |
| Investment in software                                                        | (637)     | (565)     | (626)    |
| Purchases of marketable securities and other investments                      | (7,762)   | (11,143)  | (5,930)  |
| Proceeds from disposition of marketable securities and other investments      | 6,544     | 10,647    | 4,665    |
| Acquisition of businesses, net of cash acquired                               | (3,289)   | (5,082)   | (2,348)  |
| Divestiture of businesses, net of cash transferred                            | 698       | (4)       | 1,272    |
| Net cash provided by/(used in) investing activities                           | (4,937)   | (7,070)   | (4,202)  |
| Cash flows from financing activities                                          |           |           |          |
| Proceeds from new debt                                                        | 5,705     | 9,586     | 7,804    |
| Payments to settle debt                                                       | (6,615)   | (5,082)   | (6,800)  |
| Short-term borrowings/(repayments) less than 90 days - net                    | 30        | (7)       | 217      |
| Common stock repurchases for tax withholdings                                 | (651)     | (402)     | (407)    |
| Proceeds from issuance of shares  (2)                                         | 745       | 414       | 279      |
| Financing-other  (2)                                                          | (145)     | (239)     | (103)    |
| Cash dividends paid                                                           | (6,147)   | (6,040)   | (5,948)  |
| Net cash provided by/(used in) financing activities                           | (7,079)   | (1,769)   | (4,958)  |
| Effect of exchange rate changes on cash, cash equivalents and restricted cash | (359)     | 9         | (244)    |
| Net change in cash, cash equivalents and restricted cash                      | 1,071     | 5,101     | 1,032    |
| Cash, cash equivalents and restricted cash at January 1                       | 13,089    | 7,988     | 6,957    |
| Cash, cash equivalents and restricted cash at December 31                     | $  14,160 | $  13,089 | $  7,988 |
| Supplemental data                                                             |           |           |          |
| Income taxes paid-net of refunds received                                     | $  1,723  | $  1,564  | $  1,865 |
| Interest paid on debt                                                         | $  1,978  | $  1,668  | $  1,401 |

(1) Includes operating lease right-of-use assets amortization expense of $0.9 billion in 2024, 2023 and 2022.

(2) Prior-year amounts have been reclassified to conform to the change in 2024 presentation.

Amounts may not add due to rounding.

The accompanying notes are an integral part of the financial statements.

## Consolidated Statement of Equity

International Business Machines Corporation and Subsidiary Companies


|                                                                                                         | Common  Stock and  Additional  Paid-in  Capital   | Retained  Earnings   | Treasury  Stock   | Accumulated  Other  Comprehensive  Income/(Loss)   | Total IBM  Stockholders'  Equity   | Non- Controlling  Interests   | Total  Equity   |
|---------------------------------------------------------------------------------------------------------|---------------------------------------------------|----------------------|-------------------|----------------------------------------------------|------------------------------------|-------------------------------|-----------------|
| 2022                                                                                                    |                                                   |                      |                   |                                                    |                                    |                               |                 |
| Equity, January 1, 2022                                                                                 | $ 57,319                                          | $ 154,209            | $ (169,392)       | $  (23,234)                                        | $  18,901                          | $  95                         | $ 18,996        |
| Net income plus other  comprehensive income/(loss)                                                      |                                                   |                      |                   |                                                    |                                    |                               |                 |
| Net income                                                                                              |                                                   | 1,639                |                   |                                                    | 1,639                              |                               | 1,639           |
| Other comprehensive income/ (loss)                                                                      |                                                   |                      |                   | 6,494                                              | 6,494                              |                               | 6,494           |
| Total comprehensive income                                                                              |                                                   |                      |                   |                                                    | $  8,134                           |                               | $ 8,134         |
| Cash dividends paid-common  stock ($6.59 per share)                                                     |                                                   | (5,948)              |                   |                                                    | (5,948)                            |                               | (5,948)         |
| Common stock issued under  employee plans (8,539,072 shares)                                            | 962                                               |                      |                   |                                                    | 962                                |                               | 962             |
| Purchases (3,027,994 shares) and  sales (2,512,300 shares) of  treasury stock under employee  plans-net |                                                   | (12)                 | (92)              |                                                    | (104)                              |                               | (104)           |
| Other equity                                                                                            | 63                                                | (63)                 |                   |                                                    | 0                                  |                               | 0               |
| Changes in noncontrolling interests                                                                     |                                                   |                      |                   |                                                    |                                    | (18)                          | (18)            |
| Equity, December 31, 2022                                                                               | $ 58,343                                          | $ 149,825            | $ (169,484)       | $  (16,740)                                        | $  21,944                          | $  77                         | $ 22,021        |

Amounts may not add due to rounding.

The accompanying notes are an integral part of the financial statements.

($ in millions except per share amounts)


|                                                                                                         | Common  Stock and  Additional  Paid-in  Capital   | Retained  Earnings   | Treasury  Stock   | Accumulated  Other  Comprehensive  Income/(Loss)   | Total IBM  Stockholders'  Equity   | Non- Controlling  Interests   | Total  Equity   |
|---------------------------------------------------------------------------------------------------------|---------------------------------------------------|----------------------|-------------------|----------------------------------------------------|------------------------------------|-------------------------------|-----------------|
| 2023                                                                                                    |                                                   |                      |                   |                                                    |                                    |                               |                 |
| Equity, January 1, 2023                                                                                 | $ 58,343                                          | $ 149,825            | $ (169,484)       | $  (16,740)                                        | $  21,944                          | $  77                         | $ 22,021        |
| Net income plus other  comprehensive income/(loss)                                                      |                                                   |                      |                   |                                                    |                                    |                               |                 |
| Net income                                                                                              |                                                   | 7,502                |                   |                                                    | 7,502                              |                               | 7,502           |
| Other comprehensive income/ (loss)                                                                      |                                                   |                      |                   | (2,021)                                            | (2,021)                            |                               | (2,021)         |
| Total comprehensive income                                                                              |                                                   |                      |                   |                                                    | $  5,481                           |                               | $ 5,481         |
| Cash dividends paid-common  stock ($6.63 per share)                                                     |                                                   | (6,040)              |                   |                                                    | (6,040)                            |                               | (6,040)         |
| Common stock issued under  employee plans (9,794,240 shares)                                            | 1,300                                             |                      |                   |                                                    | 1,300                              |                               | 1,300           |
| Purchases (2,953,554 shares) and  sales (2,080,983 shares) of  treasury stock under employee  plans-net |                                                   | (11)                 | (140)             |                                                    | (152)                              |                               | (152)           |
| Changes in noncontrolling interests                                                                     |                                                   |                      |                   |                                                    |                                    | 3                             | 3               |
| Equity, December 31, 2023                                                                               | $ 59,643                                          | $ 151,276            | $ (169,624)       | $  (18,761)                                        | $  22,533                          | $  80                         | $ 22,613        |

Amounts may not add due to rounding.

The accompanying notes are an integral part of the financial statements.

## Consolidated Statement of Equity

International Business Machines Corporation and Subsidiary Companies


|                                                                                                         | Common  Stock and  Additional  Paid-in  Capital   | Retained  Earnings   | Treasury  Stock   | Accumulated  Other  Comprehensive  Income/(Loss)   | Total IBM  Stockholders'  Equity   | Non- Controlling  Interests   | Total  Equity   |
|---------------------------------------------------------------------------------------------------------|---------------------------------------------------|----------------------|-------------------|----------------------------------------------------|------------------------------------|-------------------------------|-----------------|
| 2024                                                                                                    |                                                   |                      |                   |                                                    |                                    |                               |                 |
| Equity, January 1, 2024                                                                                 | $ 59,643                                          | $ 151,276            | $ (169,624)       | $  (18,761)                                        | $  22,533                          | $  80                         | $ 22,613        |
| Net income plus other  comprehensive income/(loss)                                                      |                                                   |                      |                   |                                                    |                                    |                               |                 |
| Net income                                                                                              |                                                   | 6,023                |                   |                                                    | 6,023                              |                               | 6,023           |
| Other comprehensive income/ (loss)                                                                      |                                                   |                      |                   | 3,492                                              | 3,492                              |                               | 3,492           |
| Total comprehensive income                                                                              |                                                   |                      |                   |                                                    | $  9,516                           |                               | $ 9,516         |
| Cash dividends paid-common  stock ($6.67 per share)                                                     |                                                   | (6,147)              |                   |                                                    | (6,147)                            |                               | (6,147)         |
| Common stock issued under  employee plans (12,253,153 shares)                                           | 1,737                                             |                      |                   |                                                    | 1,737                              |                               | 1,737           |
| Purchases (3,430,885 shares) and  sales (2,454,155 shares) of  treasury stock under employee  plans-net |                                                   | 11                   | (343)             |                                                    | (332)                              |                               | (332)           |
| Changes in noncontrolling interests                                                                     |                                                   |                      |                   |                                                    |                                    | 6                             | 6               |
| Equity, December 31, 2024                                                                               | $ 61,380                                          | $ 151,163            | $ (169,968)       | $  (15,269)                                        | $  27,307                          | $  86                         | $ 27,393        |

Amounts may not add due to rounding.

The accompanying notes are an integral part of the financial statements.

Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## NOTE A. SIGNIFICANT ACCOUNTING POLICIES

## Basis of Presentation

The accompanying Consolidated Financial Statements and footnotes of the International Business Machines Corporation (IBM or "the company") have been prepared in accordance with accounting principles generally accepted in the United States of America (GAAP).

Within the financial statements and tables presented, certain columns and rows may not add due to the use of rounded numbers for disclosure purposes. Percentages presented are calculated from the underlying whole-dollar amounts. Certain prior-year amounts have been reclassified to conform to the change in current year presentation. This is annotated where applicable.

Over the past several years, the company has taken actions to reduce the risk profile of its worldwide retirement-related plans, while at the same time increasing the funded status of the plans. In 2022 and 2024, non-participating single group annuity contracts were purchased from insurers which irrevocably transferred to the insurers certain defined benefit ("DB") pension obligations and related plan assets, as described below. There were no changes to the amount of benefits payable to the participants and beneficiaries of the plans transferred. These pension transfers reduced the company's pension obligations and assets by approximately the same amount and were purchased using assets from their respective retirement plans with no additional funding contributions required from the company. Each transaction resulted in the recognition of a one-time, non-cash, pre-tax pension settlement charge ("pension settlement charge") in the respective period of the pension transfer. Additional details of each transfer are included below:

In September 2022, the IBM Personal Pension Plan ("Qualified PPP") irrevocably transferred to insurers approximately $16 billion of the Qualified PPP's DB pension obligations and related plan assets. As a result of this transaction, the company recognized a pension settlement charge of $5.9 billion ($4.4 billion net of tax) in the third quarter of 2022.

In September 2024, the Qualified PPP irrevocably transferred to an insurer approximately $6 billion of the Qualified PPP's DB pension obligations and related plan assets. As a result of this transaction, the company recognized a pension settlement charge of $2.7 billion ($2.0 billion net of tax) in the third quarter of 2024.

In October 2024, IBM Canada LTD ("IBMC") irrevocably transferred to insurers approximately $1.2 billion of the IBMC IBM Retirement Plan DB pension obligations and related plan assets. As a result of this transaction, the company recognized a pension settlement charge of $0.4 billion in the fourth quarter of 2024.

The pension settlement charges described above were primarily related to the accelerated recognition of accumulated actuarial losses of the plans. The tax benefits associated with these pension settlement charges are reflected as an adjustment to reconcile net income to net cash provided by operating activities within deferred taxes in the Consolidated Statement of Cash Flows. Refer to note U, "Retirement-Related Benefits," for additional information.

The company reported a benefit from income taxes of $218 million and $626 million for the years ended December 31, 2024 and December 31, 2022, respectively. The 2024 and 2022 tax benefits were driven by the tax impact of the pension settlement charges, as described above. The 2024 tax benefit was also driven by the resolution of certain tax audit matters. Refer to note G, "Taxes," for additional information.

Noncontrolling interest amounts of $17 million, $16 million and $20 million, net of tax, for the years ended December 31, 2024, 2023 and 2022, respectively, are included as a reduction within other (income) and expense in the Consolidated Income Statement.

## Principles of Consolidation

The Consolidated Financial Statements include the accounts of IBM and its controlled subsidiaries, which are primarily majority owned. Any noncontrolling interest in the equity of a subsidiary is reported as a component of total equity in the Consolidated Balance Sheet. Net income and losses attributable to the noncontrolling interest are reported as described above in the Consolidated Income Statement. The accounts of variable interest entities (VIEs) are included in the Consolidated Financial Statements, if required. Investments in business entities in which the company does not have control but has the ability to exercise significant influence over operating and financial policies, are accounted for using the equity method and the company's proportionate share of income or loss is recorded in other (income) and expense. At December 31, 2024 and 2023, equity method investments were $108 million and $125 million, respectively. Equity investments in non-publicly traded entities lacking controlling financial interest or significant influence are primarily measured at cost, absent other indicators of fair value, net of impairment, if any. At December 31, 2024 and 2023, equity investments measured at cost were $156 million and $131 million, respectively. Equity method investments and equity investments measured at cost are included in investments and sundry assets in the Consolidated Balance Sheet. The accounting policy for other investments in equity securities is described within the "Marketable Securities" section of this note. All intercompany transactions and accounts have been eliminated in IBM 's consolidated financial results.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Use of Estimates

The preparation of financial statements in conformity with GAAP requires management to make estimates and assumptions that affect amounts that are reported in the Consolidated Financial Statements and accompanying disclosures. Estimates are made for the following, among others: revenue, costs to complete service contracts, income taxes, pension assumptions, valuation of assets including goodwill and intangible assets, loss contingencies, allowance for credit losses and other matters. These estimates are based on management's best knowledge of current events, historical experience, actions that the company may undertake in the future and on various other assumptions that are believed to be reasonable under the circumstances. Actual results may be different from these estimates.

In the fourth quarter of 2022, the company completed its annual assessment of the useful lives of its information technology equipment. Due to advances in technology, the company determined it should increase the estimated useful lives of its server and network equipment from five to six years for new assets and from three to four years for used assets. This change in accounting estimate was effective beginning January 1, 2023.

## Revenue

The company accounts for a contract with a client when it has written approval, the contract is committed, the rights of the parties, including payment terms, are identified, the contract has commercial substance and consideration is probable of collection.

Revenue is recognized when, or as, control of a promised product or service transfers to a client, in an amount that reflects the consideration to which the company expects to be entitled in exchange for transferring those products or services. If the consideration promised in a contract includes a variable amount, the company estimates the amount to which it expects to be entitled using either the expected value or most likely amount method. The company's contracts may include terms that could cause variability in the transaction price, including, for example, rebates, volume discounts, service-level penalties, and performance bonuses or other forms of contingent revenue.

The company only includes estimated amounts in the transaction price to the extent it is probable that a significant reversal of cumulative revenue recognized will not occur when the uncertainty associated with the variable consideration is resolved. The company may not be able to reliably estimate contingent revenue in certain long-term arrangements due to uncertainties that are not expected to be resolved for a long period of time or when the company's experience with similar types of contracts is limited. The company's arrangements infrequently include contingent revenue. Changes in estimates of variable consideration are included in note C, "Revenue Recognition."

The company's standard billing terms are that payment is due upon receipt of invoice, payable within 30 days. Invoices are generally issued as control transfers and/or as services are rendered. Additionally, in determining the transaction price, the company adjusts the promised amount of consideration for the effects of the time value of money if the billing terms are not standard and the timing of payments agreed to by the parties to the contract provide the client or the company with a significant benefit of financing, in which case the contract contains a significant financing component. As a practical expedient, the company does not account for significant financing components if the period between when the company transfers the promised product or service to the client and when the client pays for that product or service will be one year or less. Most arrangements that contain a financing component are financed through the company's Financing business and include explicit financing terms.

The company may include subcontractor services or third-party vendor equipment or software in certain integrated services arrangements. In these types of arrangements, revenue from sales of third-party vendor products or services is recorded net of costs when the company is acting as an agent between the client and the vendor, and gross when the company is the principal for the transaction. To determine whether the company is an agent or principal, the company considers whether it obtains control of the products or services before they are transferred to the customer. In making this evaluation, several factors are considered, most notably whether the company has primary responsibility for fulfillment to the client, as well as inventory risk and pricing discretion.

The company recognizes revenue on sales to solution providers, resellers and distributors (herein referred to as resellers) when the reseller has economic substance apart from the company and the reseller is considered the principal for the transaction with the end-user client.

The company reports revenue net of any revenue-based taxes assessed by governmental authorities that are imposed on and concurrent with specific revenue-producing transactions.

In addition to the aforementioned general policies, the following are the specific revenue recognition policies for arrangements with multiple performance obligations and for each major category of revenue.

## 54 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Arrangements with Multiple Performance Obligations

The company's global capabilities as a hybrid cloud platform and AI company include services, software, hardware and related financing. The company enters into revenue arrangements that may consist of any combination of these products and services based on the needs of its clients.

The company continues to develop new products and offerings and their associated consumption and delivery methods, including the use of cloud and as-a-Service models. These are not separate businesses; they are offerings across the segments that address market opportunities in areas such as cloud, data, AI, analytics and security. Revenue from these offerings follows the specific revenue recognition policies for arrangements with multiple performance obligations and for each major category of revenue, depending on the type of offering, which are comprised of services, software and/or hardware.

To the extent that a product or service in multiple performance obligation arrangements is subject to other specific accounting guidance, such as leasing guidance, that product or service is accounted for in accordance with such specific guidance. For all other products or services in these arrangements, the company determines if the products or services are distinct and allocates the consideration to each distinct performance obligation on a relative standalone selling price basis.

When products and services are not distinct, the company determines an appropriate measure of progress based on the nature of its overall promise for the single performance obligation.

The revenue policies in the Services, Hardware and/or Software sections below are applied to each performance obligation, as applicable.

## Services

The company's primary services offerings include consulting services, including business transformation; technology consulting and application operations including the design and development of complex IT environments to a client's specifications (e.g., design and build); cloud services; business process outsourcing; security services and infrastructure support. Many of these services can be delivered entirely or partially through cloud or as-a-Service delivery models. The company's services are provided on a time-andmaterial basis, as a fixed-price contract or as a fixed-price per measure of output contract and the contract terms generally range from less than one year to 5 years.

In services arrangements, the company typically satisfies the performance obligation and recognizes revenue over time. In design and build arrangements, the performance obligation is satisfied over time either because the client controls the asset as it is created (e.g., when the asset is built at the customer site) or because the company's performance does not create an asset with an alternative use and the company has an enforceable right to payment plus a reasonable profit for performance completed to date. In most other services arrangements, the performance obligation is satisfied over time because the client simultaneously receives and consumes the benefits provided as the company performs the services.

Revenue from time-and-material contracts is recognized on an output basis as labor hours are delivered and/or direct expenses are incurred. Revenue from as-a-Service type contracts, such as Infrastructure-as-a-Service, is recognized either on a straight-line basis or on a usage basis, depending on the terms of the arrangement (such as whether the company is standing ready to perform or whether the contract has usage-based metrics). If an as-a-Service contract includes setup activities, those promises in the arrangement are evaluated to determine if they are distinct.

In areas such as application management, business process outsourcing and other cloud-based services arrangements, the company determines whether the services performed during the initial phases of the arrangement, such as setup activities, are distinct. In most cases, the arrangement is a single performance obligation comprised of a series of distinct services that are substantially the same and that have the same pattern of transfer (i.e., distinct days of service). The company applies a measure of progress (typically time-based) to any fixed consideration and allocates variable consideration to the distinct periods of service based on usage. As a result, revenue is generally recognized over the period the services are provided on a usage basis. This results in revenue recognition that corresponds with the value to the client of the services transferred to date relative to the remaining services promised.

Revenue related to maintenance and infrastructure support and extended warranty is recognized on a straight-line basis over the period of performance because the company is standing ready to provide services.

In design and build contracts, revenue is recognized based on progress toward completion of the performance obligation using a cost-to-cost measure of progress. Revenue is recognized based on the labor costs incurred to date as a percentage of the total estimated labor costs to fulfill the contract. Due to the nature of the work performed in these arrangements, the estimation of cost at completion is complex, subject to many variables and requires significant judgment. Key factors reviewed by the company to estimate costs to complete each contract are future labor and product costs and expected productivity efficiencies. Changes in original estimates are reflected in revenue on a cumulative catch-up basis in the period in which the circumstances that gave rise to

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

the revision become known by the company. Refer to note C, "Revenue Recognition," for the amount of revenue recognized in the reporting period on a cumulative catch-up basis (i.e., from performance obligations satisfied, or partially satisfied, in previous periods).

The company performs ongoing profitability analyses of its design and build services contracts accounted for using a cost-to-cost measure of progress in order to determine whether the latest estimates of revenues, costs and profits require updating. If at any time these estimates indicate that the contract will be unprofitable, the entire estimated loss for the remainder of the contract is recorded immediately. For other types of services contracts, any losses are recorded as incurred.

In some services contracts, the company bills the client prior to recognizing revenue from performing the services. Deferred income of $3,169 million and $3,444 million at December 31, 2024 and 2023, respectively, is included in the Consolidated Balance Sheet. In other services contracts, the company performs the services prior to billing the client. When the company performs services prior to billing the client in design and build contracts, the right to consideration is typically subject to milestone completion or client acceptance and the unbilled accounts receivable is classified as a contract asset. At December 31, 2024 and 2023, contract assets for services contracts of $403 million and $420 million, respectively, are included in prepaid expenses and other current assets in the Consolidated Balance Sheet. The remaining amount of unbilled accounts receivable for services contracts of $808 million and $816 million at December 31, 2024 and 2023, respectively, are included in notes and accounts receivable-trade in the Consolidated Balance Sheet.

Billings usually occur in the month after the company performs the services or in accordance with specific contractual provisions.

## Hardware

The company's hardware offerings include the sale or lease of Hybrid Infrastructure solutions including IBM Z as well as Distributed Infrastructure solutions such as Power and Storage solutions. The capabilities of these products can also be delivered through as-aService or cloud delivery models, such as Infrastructure-as-a-Service and Storage-as-a-Service. The company also offers installation services for its more complex hardware products. Hardware offerings are often sold with distinct maintenance services, described in the Services section above.

Revenue from hardware sales is recognized when control has transferred to the customer which typically occurs when the hardware has been shipped to the client, risk of loss has transferred to the client and the company has a present right to payment for the hardware. In limited circumstances when a hardware sale includes client acceptance provisions, revenue is recognized either when client acceptance has been obtained, client acceptance provisions have lapsed, or the company has objective evidence that the criteria specified in the client acceptance provisions have been satisfied. Revenue from hardware sales-type leases is recognized at the beginning of the lease term. Revenue from rentals and operating leases is recognized on a straight-line basis over the term of the rental or lease.

Revenue from as-a-Service arrangements is recognized either on a straight-line basis or on a usage basis as described in the Services section above. Installation services are accounted for as distinct performance obligations with revenue recognized as the services are performed. Shipping and handling activities that occur after the client has obtained control of a product are accounted for as an activity to fulfill the promise to transfer the product rather than as an additional promised service and, therefore, no revenue is deferred and recognized over the shipping period.

## Software

The company's software offerings include hybrid platform software solutions, which contain many of the company's strategic areas including Red Hat, automation, data and AI, and security; transaction processing, which primarily supports mission-critical systems for clients; and distributed infrastructure software, which provides operating systems for IBM Z and Power Systems hardware. These offerings include proprietary software and open-source software, and many can be delivered entirely or partially through asa-Service or cloud delivery models, while others are delivered as on-premise software licenses.

Revenue from proprietary perpetual (one-time charge) license software is recognized at a point in time at the inception of the arrangement when control transfers to the client, if the software license is distinct from the post-contract support (PCS) offered by the company.

Revenue from proprietary term license software is recognized at a point in time for the committed term of the contract, unless consideration depends on client usage, in which case revenue is recognized when the usage occurs.

Proprietary term licenses often have a one-month contract term due to client termination rights, in which case, revenue would be recognized in that month for both the license and PCS. Clients may contract to convert their existing IBM term license software into perpetual license software plus PCS. When proprietary term license software is converted to perpetual license software, the consideration becomes fixed with no cancellability and, therefore, revenue for the perpetual license is recognized upon conversion, consistent with the accounting for other perpetual licenses, as described above. PCS revenue is recognized as described below.

## 56 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The company also has open-source software offerings. Since open-source software is offered under an open-source licensing model and therefore, the license is available for free, the standalone selling price is zero. As such, when the license is sold with PCS or other products and services, no consideration is allocated to the license when it is a distinct performance obligation and therefore no revenue is recognized when control of the license transfers to the client. Revenue is recognized over the PCS period. In certain cases, open-source software is bundled with proprietary software and, if the open-source software is not considered distinct, the software bundle is accounted for under a proprietary software model.

Revenue from PCS is recognized over the contract term on a straight-line basis because the company is providing a service of standing ready to provide support, when-and-if needed, and is providing unspecified software upgrades on a when-and-if available basis over the contract term.

Revenue from software hosting or Software-as-a-Service (SaaS) arrangements is recognized either on a straight-line basis or on a usage basis as described in the Services section above. In software hosting arrangements, the rights provided to the client (e.g., ownership of a license, contract termination provisions and the feasibility of the client to operate the software) are considered in determining whether the arrangement includes a license. In arrangements that include a software license, the associated revenue is recognized in accordance with the software license recognition policy above rather than over time as a service.

## Financing

Financing income attributable to sales-type leases, direct financing leases and loans is recognized on the accrual basis using the effective interest method. Operating lease income is recognized on a straight-line basis over the term of the lease.

## Standalone Selling Price

The company allocates the transaction price to each performance obligation on a relative standalone selling price basis. The standalone selling price (SSP) is the price at which the company would sell a promised product or service separately to a client. In most cases, the company is able to establish SSP based on the observable prices of products or services sold separately in comparable circumstances to similar clients. The company typically establishes SSP ranges for its products and services which are reassessed on a periodic basis or when facts and circumstances change.

In certain instances, the company may not be able to establish a SSP range based on observable prices, and as a result, the company estimates SSP. The company estimates SSP by considering multiple factors including, but not limited to, overall market conditions, including geographic or regional specific factors, internal costs, profit objectives and pricing practices. Additionally, in certain circumstances, the company may estimate SSP for a product or service by applying the residual approach. Estimating SSP is a formal process that includes review and approval by the company's management.

## Services Costs

Recurring operating costs for services contracts are recognized as incurred. For fixed-price design and build contracts, the costs of external hardware and software accounted for under the cost-to-cost measure of progress are deferred and recognized based on the labor costs incurred to date (i.e., the measure of progress), as a percentage of the total estimated labor costs to fulfill the contract as control transfers over time for these performance obligations. Certain eligible, non-recurring costs (i.e., setup costs) incurred in the initial phases of business process outsourcing contracts and other cloud-based services contracts, including Software-as-a-Service arrangements, are capitalized when the costs relate directly to the contract, the costs generate or enhance resources of the company that will be used in satisfying the performance obligation in the future, and the costs are expected to be recovered. These costs consist of transition and setup costs related to the provisioning, configuring, implementation and training and other deferred fulfillment costs, including, for example, prepaid assets used in services contracts (i.e., prepaid software or prepaid maintenance). Capitalized costs are amortized on a straight-line basis over the expected period of benefit, which can include anticipated contract renewals or extensions, consistent with the transfer to the client of the services to which the asset relates. Additionally, fixed assets associated with these contracts are capitalized and depreciated on a straight-line basis over the expected useful life of the asset. If an asset is contract specific, then the depreciation period is the shorter of the useful life of the asset or the contract term. Amounts paid to clients in excess of the fair value of acquired assets used in business process outsourcing arrangements are deferred and amortized on a straight-line basis as a reduction of revenue over the expected period of benefit. The company performs periodic reviews to assess the recoverability of deferred contract transition and setup costs. If the carrying amount is deemed not recoverable, an impairment loss is recognized. Refer to note C, "Revenue Recognition," for the amount of deferred costs to fulfill a contract at December 31, 2024 and 2023.

In situations in which a business process outsourcing or other cloud-based services contract is terminated, the terms of the contract may require the client to reimburse the company for the recovery of unbilled accounts receivable, unamortized deferred contract costs and additional costs incurred by the company to transition the services.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Software Costs

Costs that are related to the conceptual formulation and design of licensed software programs are expensed as incurred to research, development and engineering expense; costs that are incurred to produce the finished product after technological feasibility has been established are capitalized as an intangible asset. Capitalized amounts are amortized on a straight-line basis over periods ranging up to three years and are recorded in software cost within cost of sales. The company performs periodic reviews to ensure that unamortized program costs remain recoverable from future revenue. Costs to support or service licensed programs are charged to software cost within cost of sales as incurred.

The company capitalizes certain costs that are incurred to purchase or develop internal-use software. Internal-use software programs also include software used by the company to deliver Software-as-a-Service when the client does not receive a license to the software and the company has no substantive plans to market the software externally. Capitalized costs are amortized on a straight-line basis over periods ranging up to three years and are recorded in selling, general and administrative expense or cost of sales, depending on whether the software is used by the company in revenue generating transactions. Additionally, the company may capitalize certain types of implementation costs and amortize them over the term of the arrangement when the company is a customer in a cloud-computing arrangement.

## Incremental Costs of Obtaining a Contract

Incremental costs of obtaining a contract (e.g., sales commissions) are capitalized and amortized on a straight-line basis over the expected customer relationship period if the company expects to recover those costs. The expected customer relationship period, determined based on the average customer relationship period, including expected renewals, for each offering type, is three years. Expected renewal periods are only included in the expected customer relationship period if commission amounts paid upon renewal are not commensurate with amounts paid on the initial contract. Incremental costs of obtaining a contract include only those costs the company incurs to obtain a contract that it would not have incurred if the contract had not been obtained. The company has determined that certain commissions programs meet the requirements to be capitalized. Some commission programs are not subject to capitalization as the commission expense is paid and recognized as the related revenue is recognized. Additionally, as a practical expedient, the company expenses costs to obtain a contract as incurred if the amortization period would have been a year or less. These costs are included in selling, general and administrative expenses.

## Product Warranties

The company offers warranties for its hardware products that generally range up to three years, with the majority being either one or three years. Any cost of standard warranties is accrued when the corresponding revenue is recognized. The company estimates its standard warranty costs for products based on historical warranty claim experience and estimates of future spending and applies this estimate to the revenue stream for products under warranty. Estimated future costs for warranties applicable to revenue recognized in the current period are charged to cost of sales. The warranty liability is reviewed quarterly to verify that it properly reflects the remaining obligation based on the anticipated expenditures over the balance of the obligation period. Adjustments are made when actual warranty claim experience differs from estimates. Costs from fixed-price support or maintenance contracts, including extended warranty contracts, are recognized as incurred.

Revenue from extended warranty contracts is initially recorded as deferred income and subsequently recognized on a straight-line basis over the delivery period because the company is providing a service of standing ready to provide services over such term.

Refer to note Q, "Commitments & Contingencies," for additional information.

## Shipping and Handling

Costs related to shipping and handling are recognized as incurred and included in cost in the Consolidated Income Statement.

## Expense and Other Income

## Selling, General and Administrative

Selling, general and administrative (SG&A) expense is charged to income as incurred, except for certain sales commissions, which are capitalized and amortized. For further information regarding capitalizing sales commissions, refer to "Incremental Costs of Obtaining a Contract" above. Expenses of promoting and selling products and services are classified as selling expense and, in addition to sales commissions, include such items as compensation, advertising and travel. General and administrative expense includes such items as compensation, IT costs, legal costs, office rental, non-income taxes, and insurance. In addition, general and administrative expense includes other operating items such as amortization of certain intangible assets, workforce rebalancing charges related to employees terminated in the ongoing course of business, acquisition costs related to business combinations, environmental remediation costs, and allowance for credit losses.

Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Advertising and Promotional Expense

The company expenses advertising and promotional costs as incurred. Cooperative advertising reimbursements from vendors are recorded net of advertising and promotional expense in the period in which the related advertising and promotional expense is incurred.

Advertising and promotional expense, which includes media, agency and promotional expense, was $1,173 million, $1,237 million and $1,330 million in 2024, 2023 and 2022, respectively, and is recorded in SG&A expense in the Consolidated Income Statement.

## Research, Development and Engineering

Research, development and engineering (RD&E) costs are expensed as incurred. These costs are predominantly research and development expenses, related to scientific research and the application of scientific advances to the development of new and improved products and their uses, as well as services and their application. Software costs that are incurred to produce the finished product after technological feasibility has been established are capitalized as an intangible asset.

## Intellectual Property and Custom Development Income

The company licenses and sells the rights to certain of its intellectual property (IP) including internally developed patents, trade secrets and technological know-how. Certain IP transactions to third parties are licensing/royalty-based and others are transactionbased sales/other transfers. Income from licensing arrangements is recognized at the inception of the license term if the nature of the company's promise is to provide a right to use the company's intellectual property as it exists at that point in time (i.e., the license is functional intellectual property) and control has transferred to the client. Income is recognized over time if the nature of the company's promise is to provide a right to access the company's intellectual property throughout the license period (i.e., the license is symbolic intellectual property), such as a trademark license. Income from royalty-based fee arrangements is recognized at the later of when the subsequent sale or usage occurs or the performance obligation to which some or all of the royalty has been allocated has been satisfied (or partially satisfied). The company also enters into cross-licensing arrangements of patents, and income from these arrangements is recognized when control transfers to the customer. In addition, the company earns income from certain custom development projects with strategic technology partners and specific clients. The company records the income from these projects over time as the company satisfies the performance obligation if there are no repayment provisions and the fee is not dependent upon the ultimate success of the project.

## Government Assistance

The company receives grants from governments and government agencies (government) in support of certain of the company's business activities, primarily related to research, job creation, or job training. Grants are generally received in the form of cash as either a recovery for expenses incurred or as an incentive for meeting certain requirements as agreed to in the grant, with terms ranging from one to five years. Grants are recorded as credits against Cost, SG&A and RD&E in the Consolidated Income Statement based on the nature of the grant and the expense being offset once the conditions and restrictions of the grant have been met and payment has been received from the government. When a grant is received before conditions of the grant have been met, the grant is recorded in other accrued expenses and liabilities or other liabilities in the Consolidated Balance Sheet. For the years ended December 31, 2024 and 2023, grants recorded in the company's Consolidated Financial Statements were not material.

## Business Combinations and Intangible Assets Including Goodwill

The company accounts for business combinations using the acquisition method and accordingly, the identifiable assets acquired, the liabilities assumed, and any noncontrolling interest in the acquiree are generally recorded at their acquisition date fair values. Contract assets and contract liabilities are measured in accordance with the guidance on revenue recognition. Goodwill represents the excess of the purchase price over the fair value of net assets, including the amount assigned to identifiable intangible assets. The primary drivers that generate goodwill are the value of synergies between the acquired entities and the company and the acquired assembled workforce, neither of which qualifies as a separately identifiable intangible asset. Goodwill recorded in an acquisition is assigned to applicable reporting units based on expected revenues or expected cash flows. Identifiable intangible assets with finite lives are amortized over their useful lives. Amortization of completed technology is recorded in cost, and amortization of all other intangible assets is recorded in SG&A expense. Acquisition-related costs, including advisory, legal, accounting, valuation and pre-close and other costs, are typically expensed in the periods in which the costs are incurred and are recorded in SG&A expense. The results of operations of acquired businesses are included in the Consolidated Financial Statements from the acquisition date.

## Impairment

Long-lived assets, other than goodwill, are tested for impairment whenever events or changes in circumstances indicate that the carrying amount may not be recoverable. The impairment test is typically based on undiscounted cash flows and, if impaired, the asset is written down to fair value based on either discounted cash flows or appraised values. Goodwill is tested for impairment at least annually, in the fourth quarter and whenever changes in circumstances indicate an impairment may exist. The goodwill impairment test is performed at the reporting unit level, which is generally at the level of or one level below an operating segment.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Depreciation and Amortization

Property, plant and equipment are carried at cost and depreciated over their estimated useful lives using the straight-line method. The estimated useful lives of certain depreciable assets are as follows: buildings, 30 to 50 years; building equipment, 10 to 20 years; land improvements, 20 years; production, engineering, office and other equipment, 2 to 20 years; and information technology equipment, 1.5 to 6 years. Leasehold improvements are amortized over the shorter of their estimated useful lives or the related lease term, rarely exceeding 25 years.

As noted within the "Software Costs" section of this note, capitalized software costs are amortized on a straight-line basis over periods ranging up to 3 years. Other intangible assets are amortized over periods between 1 and 20 years.

## Environmental

The cost of internal environmental protection programs that are preventative in nature are expensed as incurred. When a cleanup program becomes likely, and it is probable that the company will incur cleanup costs and those costs can be reasonably estimated, the company accrues remediation costs for known environmental liabilities.

## Asset Retirement Obligations

Asset retirement obligations (ARO) are legal obligations associated with the retirement of long-lived assets and the liability is initially recorded at fair value. The related asset retirement costs are capitalized by increasing the carrying amount of the related assets by the same amount as the liability. Asset retirement costs are subsequently depreciated over the useful lives of the related assets. Subsequent to initial recognition, the company records period-to-period changes in the ARO liability resulting from the passage of time in interest expense and revisions to either the timing or the amount of the original expected cash flows to the related assets.

## Defined Benefit Pension and Nonpension Postretirement Benefit Plans

The funded status of the company's defined benefit pension plans and nonpension postretirement benefit plans (retirement-related benefit plans) is recognized in the Consolidated Balance Sheet. The funded status is measured as the difference between the fair value of plan assets and the benefit obligation at December 31, the measurement date. For defined benefit pension plans, the benefit obligation is the projected benefit obligation (PBO), which represents the actuarial present value of benefits expected to be paid upon retirement based on employee services already rendered and estimated future compensation levels. For the nonpension postretirement benefit plans, the benefit obligation is the accumulated postretirement benefit obligation (APBO), which represents the actuarial present value of postretirement benefits attributed to employee services already rendered. The fair value of plan assets represents the current market value of assets held in an irrevocable trust fund, held for the sole benefit of participants, which are invested by the trust fund. Overfunded plans, with the fair value of plan assets exceeding the benefit obligation, are aggregated and recorded as a prepaid pension asset equal to this excess. Underfunded plans, with the benefit obligation exceeding the fair value of plan assets, are aggregated and recorded as a retirement and nonpension postretirement benefit obligation equal to this excess.

The current portion of the retirement and nonpension postretirement benefit obligations represents the actuarial present value of benefits payable in the next 12 months exceeding the fair value of plan assets, measured on a plan-by-plan basis. This obligation is recorded in compensation and benefits in the Consolidated Balance Sheet.

Net periodic pension and nonpension postretirement benefit cost/(income) is recorded in the Consolidated Income Statement and includes service cost, interest cost, expected return on plan assets, amortization of prior service costs/(credits) and (gains)/losses previously recognized as a component of other comprehensive income/(loss) (OCI) and amortization of the net transition asset remaining in accumulated other comprehensive income/(loss) (AOCI). The service cost component of net benefit cost is recorded in Cost, SG&A and RD&E in the Consolidated Income Statement (unless eligible for capitalization) based on the employees' respective functions. The other components of net benefit cost are presented separately from service cost within other (income) and expense in the Consolidated Income Statement.

(Gains)/losses and prior service costs/(credits) are recognized as a component of OCI in the Consolidated Statement of Comprehensive Income as they arise. Those (gains)/losses and prior service costs/(credits) are subsequently recognized as a component of net periodic cost/(income) pursuant to the recognition and amortization provisions of applicable accounting guidance. (Gains)/losses arise as a result of differences between actual experience and assumptions or as a result of changes in actuarial assumptions. Prior service costs/(credits) represent the cost of benefit changes attributable to prior service granted in plan amendments.

The measurement of benefit obligations and net periodic cost/(income) is based on estimates and assumptions approved by the company's management. These valuations reflect the terms of the plans and use participant-specific information such as compensation, age and years of service, as well as certain assumptions, including estimates of discount rates, expected return on plan assets, rate of compensation increases, interest crediting rates and mortality rates.

## 60 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Defined Contribution Plans

The company's contribution for defined contribution plans is recorded when the employee renders service to the company. The charge is recorded in Cost, SG&A and RD&E in the Consolidated Income Statement based on the employees' respective functions.

## Stock-Based Compensation

Stock-based compensation represents the cost related to stock-based awards granted to employees. The company measures stock-based compensation cost at the grant date, based on the estimated fair value of the award and recognizes the cost on a straight-line basis (net of estimated forfeitures) over the employee requisite service period. The company grants its employees Restricted Stock Units (RSUs), including Retention Restricted Stock Units (RRSUs); Performance Share Units (PSUs); and stock options. RSUs are stock awards granted to employees that entitle the holder to shares of common stock as the award vests, typically over a one- to four-year period. PSUs are stock awards where the number of shares ultimately received by the employee depends on performance against specified targets and typically vest over a three-year period. Over the performance period, the number of shares that will be issued is adjusted based upon the probability of achievement of performance targets. The ultimate number of shares issued and the related compensation cost recognized as expense will be based on a comparison of the final performance metrics to the specified targets. Dividend equivalents are not paid on the stock awards described above. The fair value of the awards is determined and fixed on the grant date based on the company's stock price, adjusted for the exclusion of dividend equivalents where applicable and for PSUs assumes that performance targets will be achieved. The company estimates the fair value of stock options using a Black-Scholes valuation model. Stock-based compensation cost is recorded in Cost, SG&A, and RD&E in the Consolidated Income Statement based on the employees' respective functions.

The company records deferred tax assets for awards that result in deductions on the company's income tax returns, based on the amount of compensation cost recognized and the relevant statutory tax rates. The differences between the deferred tax assets recognized for financial reporting purposes and the actual tax deduction reported on the income tax return are recorded as a benefit or expense to the provision for income taxes in the Consolidated Income Statement.

## Income Taxes

Income tax expense is based on reported income before income taxes. Deferred income taxes reflect the tax effect of temporary differences between asset and liability amounts that are recognized for financial reporting purposes and the amounts that are recognized for income tax purposes. These deferred taxes are measured by applying currently enacted tax laws. The company includes Global Intangible Low-Taxed Income (GILTI) in measuring deferred taxes. Valuation allowances are recognized to reduce deferred tax assets to the amount that will more likely than not be realized. In assessing the need for a valuation allowance, management considers all available evidence for each jurisdiction including past operating results, estimates of future taxable income and the feasibility of ongoing tax planning strategies/actions. When the company changes its determination as to the amount of deferred tax assets that can be realized, the valuation allowance is adjusted with a corresponding impact to income tax expense in the period in which such determination is made.

The company recognizes additional tax liabilities when the company believes that certain positions may not be fully sustained upon review by tax authorities. Benefits from tax positions are measured at the largest amount of benefit that is greater than 50 percent likely of being realized upon settlement. The noncurrent portion of tax liabilities is included in other liabilities in the Consolidated Balance Sheet. To the extent that new information becomes available which causes the company to change its judgment regarding the adequacy of existing tax liabilities, such changes to tax liabilities will impact income tax expense in the period in which such determination is made. Interest and penalties, if any, related to accrued liabilities for potential tax assessments are included in income tax expense.

## Translation of Non-U.S. Currency Amounts

Assets and liabilities of non-U.S. subsidiaries that have a local functional currency are translated to U.S. dollars at year-end exchange rates. Translation adjustments are recorded in OCI. Income and expense items are translated at weighted-average rates of exchange prevailing during the year.

Inventory, property, plant and equipment-net and other non-monetary assets and liabilities of non-U.S. subsidiaries and branches that operate in U.S. dollars are translated at the approximate exchange rates prevailing when the company acquired the assets or liabilities. All other assets and liabilities denominated in a currency other than U.S. dollars are translated at year-end exchange rates with the transaction gain or loss recognized in other (income) and expense. Income and expense items are translated at the weighted-average rates of exchange prevailing during the year. These translation gains and losses are included in net income for the period in which exchange rates change.

## Derivative Financial Instruments

The company uses derivative financial instruments primarily to manage foreign currency and interest rate risk, and to a lesser extent equity. The company does not use derivative financial instruments for trading or speculative purposes. Derivatives that qualify for hedge accounting can be designated as either cash flow hedges, net investment hedges, or fair value hedges. The company may

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

enter into derivative contracts that economically hedge certain of its risks, even when hedge accounting does not apply, or the company elects not to apply hedge accounting.

Derivatives are recognized in the Consolidated Balance Sheet at fair value on a gross basis as either assets or liabilities and classified as current or noncurrent based upon whether the maturity of the instrument is less than or greater than 12 months.

Changes in the fair value of derivatives designated as a cash flow hedge are recorded, net of applicable taxes, in OCI and subsequently reclassified into the same income statement line as the hedged exposure when the underlying hedged item is recognized in earnings. For forward contracts designated as cash flow hedges of the principal associated with foreign currency denominated debt, the company excludes the initial forward points from the assessment of hedge effectiveness and recognizes it in other (income) and expense in the Consolidated Income Statement on a straight-line basis over the life of the hedging instrument. Changes in the fair value of the amounts excluded from the assessment of hedge effectiveness are recognized in OCI. Effectiveness for net investment hedging derivatives is measured on a spot-to-spot basis. Changes in the fair value of highly effective net investment hedging derivatives and other non-derivative financial instruments designated as net investment hedges are recorded as foreign currency translation adjustments in OCI. Unrealized gains or losses on excluded components of net investment hedging derivatives are recorded in OCI and recognized on a straight-line basis over the life of the hedge in interest expense and cost of financing in the Consolidated Income Statement. Changes in the fair value of interest rate derivatives designated as a fair value hedge and the offsetting changes in the fair value of the underlying hedged exposure are recorded in interest expense and cost of financing. Changes in the fair value of derivatives not designated as hedges are reported in earnings primarily in other (income) and expense. Refer to note S, "Derivative Financial Instruments," for further information.

The cash flows associated with derivatives designated as fair value and cash flow hedges are reported in cash flows from operating activities in the Consolidated Statement of Cash Flows. Cash flows from derivatives designated as net investment hedges and derivatives not designated as hedges are reported in cash flows from investing activities in the Consolidated Statement of Cash Flows. Cash flows from derivatives designated as hedges of foreign currency denominated debt directly associated with the settlement of the principal are reported in payments to settle debt in cash flows from financing activities in the Consolidated Statement of Cash Flows.

## Financial Instruments

In determining the fair value of its financial instruments, the company uses a variety of methods and assumptions that are based on market conditions and risks existing at each balance sheet date. Refer to note I, "Financial Assets & Liabilities," for further information. All methods of assessing fair value result in a general approximation of value, and such value may never actually be realized.

## Fair Value Measurement

Fair value is defined as the price that would be received to sell an asset or paid to transfer a liability in an orderly transaction between market participants at the measurement date. The company classifies certain assets and liabilities based on the following fair value hierarchy:

· Level 1-Quoted prices (unadjusted) in active markets for identical assets or liabilities that can be accessed at the measurement date;

· Level 2-Inputs other than quoted prices included within Level 1 that are observable for the asset or liability, either directly or indirectly; and

· Level 3-Unobservable inputs for the asset or liability.

When available, the company uses unadjusted quoted market prices in active markets to measure the fair value and classifies such items as Level 1. If quoted market prices are not available, fair value is based upon internally developed models that use current market-based or independently sourced market parameters such as interest rates and currency rates. Items valued using internally generated models are classified according to the lowest level input or value driver that is significant to the valuation.

The determination of fair value considers various factors including interest rate yield curves and time value underlying the financial instruments. For derivatives and debt securities, the company uses a discounted cash flow analysis using discount rates commensurate with the duration of the instrument.

In determining the fair value of financial instruments, the company considers certain market valuation adjustments to the "base valuations" calculated using the methodologies described below for several parameters that market participants would consider in determining fair value:

· Counterparty credit risk adjustments are applied to financial instruments, taking into account the actual credit risk of a counterparty as observed in the credit default swap market to determine the true fair value of such an instrument.

## 62 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

· Credit risk adjustments are applied to reflect the company's own credit risk when valuing all liabilities measured at fair value. The methodology is consistent with that applied in developing counterparty credit risk adjustments, but incorporates the company's own credit risk as observed in the credit default swap market.

The company holds investments primarily in time deposits, certificates of deposit, and U.S. government debt that are designated as available-for-sale. The primary objective of the company's cash and debt investment portfolio is to protect principal by investing in very liquid investment securities with highly rated counterparties.

Available-for-sale securities are measured for impairment on a recurring basis by comparing the security's fair value with its amortized cost basis. If the fair value of the security falls below its amortized cost basis, the change in fair value is recognized in the period the impairment is identified when the loss is due to credit factors. The change in fair value due to non-credit factors is recorded in other comprehensive income when the company does not intend to sell and has the ability to hold the investment. The company's standard practice is to hold all of its debt security investments classified as available-for-sale until maturity. There were no impairments for credit losses and no material non-credit impairments recognized for the years ended December 31, 2024, 2023 and 2022.

Certain nonfinancial assets such as property, plant and equipment, land, goodwill and intangible assets are subject to non-recurring fair value measurements if they are deemed to be impaired. The impairment models used for nonfinancial assets depend on the type of asset. There were no material impairments of nonfinancial assets for the years ended December 31, 2024, 2023 and 2022.

## Cash Equivalents

All highly liquid investments with original maturities of three months or less at the date of purchase are considered to be cash equivalents.

## Marketable Securities

The company measures equity investments at fair value with changes recognized in net income.

Debt securities included in current assets represent securities that are expected to be realized in cash within one year of the balance sheet date. Long-term debt securities are included in investments and sundry assets. Debt securities are considered available-for-sale and are reported at fair value with unrealized gains and losses, net of applicable taxes, in OCI. The realized gains and losses on available-for-sale debt securities are included in other (income) and expense in the Consolidated Income Statement. Realized gains and losses are calculated based on the specific identification method. Refer to note I, "Financial Assets & Liabilities," for additional information.

## Inventory

Raw materials, work in process and finished goods are stated at the lower of average cost or net realizable value.

## Notes and Accounts Receivable-Trade and Contract Assets

The company classifies the right to consideration in exchange for products or services transferred to a client as either a receivable or a contract asset. A receivable is a right to consideration that is unconditional as compared to a contract asset which is a right to consideration that is conditional upon factors other than the passage of time. The majority of the company's contract assets represent unbilled amounts related to design and build services contracts when the cost-to-cost method of revenue recognition is utilized, revenue recognized exceeds the amount billed to the client, and the right to consideration is subject to milestone completion or client acceptance. Contract assets are generally classified as current and are recorded on a net basis with deferred income (i.e., contract liabilities) at the contract level.

## Financing Receivables

Financing receivables primarily consist of client loan and installment payment receivables (loans) and investment in sales-type and direct financing leases (collectively referred to as client financing receivables) and commercial financing receivables. Leases are accounted for in accordance with lease accounting standards. Loans, which are generally unsecured, are primarily for IBM hardware, software and services. Commercial financing receivables are primarily for working capital financing to business partners and distributors of IBM products and services. Financing receivables are classified as either held for sale or held for investment, depending on the company's intent and ability to hold the underlying contract for the foreseeable future or until maturity or payoff. Loans and commercial financing receivables are recorded at amortized cost, which approximates fair value.

## Transfers of Financial Assets

The company enters into arrangements to sell certain financial assets (primarily notes and accounts receivable-trade and financing receivables) to third-party financial institutions. For a transfer of financial assets to be considered a sale, the asset must be legally isolated from the company and the purchaser must have control of the asset ("true sale"). Determining whether all the true sale requirements have been met includes an evaluation of legal considerations, the extent of the company's continuing involvement with the assets transferred and any other relevant consideration. When the true sale criteria are met, the company derecognizes the

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

carrying value of the financial asset transferred and recognizes a net gain or loss on the sale. The proceeds from these arrangements are reflected as cash provided by operating activities in the Consolidated Statement of Cash Flows. If the true sale criteria are not met, the transfer is considered a secured borrowing and the financial asset remains on the Consolidated Balance Sheet with proceeds from the sale recognized as debt and recorded as cash flows from financing activities in the Consolidated Statement of Cash Flows.

Arrangements to sell notes and accounts receivable-trade are used in the normal course of business as part of the company's cash and liquidity management. Facilities primarily in the U.S. and several countries in Europe enable the company to sell certain notes and accounts receivable-trade, without recourse, to third parties in order to manage credit, collection, concentration and currency risk. The gross amounts sold (the gross proceeds) under these arrangements were $4.2 billion, $3.4 billion and $3.3 billion for the years ended December 31, 2024, 2023 and 2022, respectively. Within the notes and accounts receivables-trade sold and derecognized from the Consolidated Balance Sheet, $0.9 billion, $0.5 billion and $1.0 billion remained uncollected from customers at December 31, 2024, 2023 and 2022, respectively. The fees and the net gains and losses associated with the transfer of notes and accounts receivables-trade were not material for any of the periods presented. Refer to note K, "Financing Receivables," for more information on transfers of financing receivables.

## Allowance for Credit Losses

Receivables are recorded concurrent with billing and shipment of a product and/or delivery of a service to customers. An allowance for uncollectible trade receivables and contract assets, if needed, is estimated based on specific customer situations, current and future expected economic conditions, past experiences of losses, as well as an assessment of potential recoverability of the balance due.

The company estimates its allowances for expected credit losses for financing receivables by considering past events, including any historical default, historical concessions and resulting troubled debt restructurings, current economic conditions, any nonfreestanding mitigating credit enhancements, and certain forward-looking information, including reasonable and supportable forecasts. The methodologies that the company uses to calculate its financing receivables reserves, which are applied consistently to its different portfolios, are as follows:

Individually Evaluated-The company reviews all financing receivables considered at risk quarterly, and performs an analysis based upon current information available about the client, such as financial statements, news reports, published credit ratings, current market-implied credit analysis, as well as collateral net of repossession cost, prior collection history and current and future expected economic conditions. For loans that are collateral dependent, impairment is measured using the fair value of the collateral when foreclosure is probable. Using this information, the company determines the expected cash flow for the receivable and calculates an estimate of the potential loss and the probability of loss. For those accounts in which the loss is probable, the company records a specific reserve.

Collectively Evaluated-The company determines its allowances for credit losses for collectively evaluated financing receivables (unallocated) based on two portfolio segments: client financing receivables and commercial financing receivables. The company further segments the portfolio into three classes: Americas, Europe/Middle East/Africa (EMEA) and Asia Pacific.

For client financing receivables, the company uses a credit loss model to calculate allowances based on its internal loss experience and current conditions and forecasts, by class of financing receivable. The company records an unallocated reserve that is calculated by applying a reserve rate to its portfolio, excluding accounts that have been individually evaluated and specifically reserved. This reserve rate is based upon credit rating, probability of default, term and loss history. The allowance is adjusted quarterly for expected recoveries of amounts that were previously written off or are expected to be written off. Recoveries cannot exceed the aggregated amount of the previous write-off or expected write-off.

The company considers forward-looking macroeconomic variables such as gross domestic product, unemployment rates, equity prices and corporate profits when quantifying the impact of economic forecasts on its client financing receivables allowance for expected credit losses. Macroeconomic variables may vary by class of financing receivables based on historical experiences, portfolio composition and current environment. The company also considers the impact of current conditions and economic forecasts relating to specific industries, geographical areas, and client credit ratings, in addition to performing a qualitative review of credit risk factors across the portfolio. Under this approach, forecasts of these variables over two years are considered reasonable and supportable. Beyond two years, the company reverts to long-term average loss experience. Forward-looking estimates require the use of judgment, particularly in times of economic uncertainty.

The portfolio of commercial financing receivables is short term in nature and any allowance for these assets is estimated based on a combination of write-off history and current economic conditions, excluding any individually evaluated accounts.

## 64 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Other Credit-Related Policies

Past Due-The company views client financing receivables as past due when payment has not been received after 90 days, measured from the original billing date.

Non-Accrual-Non-accrual assets include those receivables (impaired loans or nonperforming leases) with specific reserves and other accounts for which it is likely that the company will be unable to collect all amounts due according to original terms of the lease or loan agreement. Interest income recognition is discontinued on these receivables. Cash collections are first applied as a reduction to principal outstanding. Any cash received in excess of principal payments outstanding is recognized as interest income. Receivables may be removed from non-accrual status, if appropriate, based upon changes in client circumstances, such as a sustained history of payments.

Write-Off-Receivable losses are charged against the allowance in the period in which the receivable is deemed uncollectible. Subsequent recoveries, if any, are credited to the allowance. Write-offs of receivables and associated reserves occur to the extent that the customer is no longer in operation and/or there is no reasonable expectation of additional collections or repossession.

## Supplier Financing

The company has supplier finance programs with third-party financial institutions where the company agrees to pay the financial institutions the stated amounts of invoices from participating suppliers on the originally invoiced maturity date, which have an average term of 90 to 120 days, consistent with the company's standard payment terms. The financial institutions offer earlier payment of the invoices at the sole discretion of the supplier for a discounted amount. The company does not provide secured legal assets or other forms of guarantees under the arrangements. The company is not a party to the arrangements between its suppliers and the financial institutions. These obligations are recognized as accounts payable in the Consolidated Balance Sheet. The obligations outstanding under these programs at December 31, 2024 and December 31, 2023 were $110 million and $101 million, respectively. The amount of the invoices received and paid under these obligations was $512 million and $503 million, respectively, for the year ended December 31, 2024.

## Leases

The company conducts business as both a lessee and a lessor. In its ordinary course of business, the company enters into leases as a lessee for property, plant and equipment. The company is also the lessor of certain equipment, mainly through its Financing segment.

When procuring goods or services, or upon entering into a contract with its clients, the company determines whether an arrangement contains a lease at its inception. As part of that evaluation, the company considers whether there is an implicitly or explicitly identified asset in the arrangement and whether the company, as the lessee, or the client, if the company is the lessor, has the right to control the use of that asset.

## Accounting for Leases as a Lessee

When the company is the lessee, all leases with a term of more than 12 months are recognized as right-of-use (ROU) assets and associated lease liabilities in the Consolidated Balance Sheet. The lease liabilities are measured at the lease commencement date and determined using the present value of the lease payments not yet paid and the company's incremental borrowing rate, which approximates the rate at which the company would borrow on a secured basis in the country where the lease was executed. The interest rate implicit in the lease is generally not determinable in transactions where the company is the lessee. The ROU asset equals the lease liability adjusted for any initial direct costs (IDCs), prepaid rent and lease incentives. The company's variable lease payments generally relate to payments tied to various indexes, non-lease components and payments above a contractual minimum fixed amount.

Operating leases are included in operating right-of-use assets-net, current operating lease liabilities and operating lease liabilities in the Consolidated Balance Sheet. Finance leases are included in property, plant and equipment, short-term debt and long-term debt in the Consolidated Balance Sheet. The lease term includes options to extend or terminate the lease when it is reasonably certain that the company will exercise that option.

The company made a policy election to not recognize leases with a lease term of 12 months or less in the Consolidated Balance Sheet.

For all asset classes, the company has elected the lessee practical expedient to combine lease and non-lease components (e.g., maintenance services) and account for the combined unit as a single lease component. A significant portion of the company's lease portfolio is real estate, which are mainly accounted for as operating leases, and are primarily used for corporate offices and data centers. The average term of the real estate leases is approximately five years. The company also has equipment leases, such as IT and semiconductor research equipment, which have lease terms that range from five to ten years. For certain of these operating and finance leases, the company applies a portfolio approach to account for the lease assets and lease liabilities.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Accounting for Leases as a Lessor

The company typically enters into leases as an alternative means of realizing value from equipment that it would otherwise sell. Assets under lease primarily include new and used IBM equipment. IBM equipment generally consists of IBM Z, Power and Storage products.

Lease payments due to IBM are typically fixed and paid in equal installments over the lease term. The majority of the company's leases do not contain variable payments that are dependent on an index or a rate. Variable lease payments that do not depend on an index or a rate (e.g., property taxes), that are paid directly by the company and are reimbursed by the client, are recorded as revenue, along with the related cost, in the period in which collection of these payments is probable. Payments that are made directly by the client to a third party, including certain property taxes and insurance, are not considered part of variable payments and therefore are not recorded by the company. The company has made a policy election to exclude from consideration in contracts all collections from sales and other similar taxes.

The company's payment terms for leases are typically unconditional. Therefore, in an instance when the client requests to terminate the lease prior to the end of the lease term, the client would typically be required to pay the remaining lease payments in full. At the end of the lease term, the company allows the client to either return the equipment, purchase the equipment at the then-current fair market value or at a pre-stated purchase price, or renew the lease based on mutually agreed upon terms.

When lease arrangements include multiple performance obligations, the company allocates the consideration in the contract between the lease components and the non-lease components on a relative standalone selling price basis.

## Sales-Type and Direct Financing Leases

For a sales-type or direct financing lease, the carrying amount of the asset is derecognized from inventory and a net investment in the lease is recorded. For a sales-type lease, the net investment in the lease is measured at commencement date as the sum of the lease receivable and the estimated residual value of the equipment less unearned income and allowance for credit losses. Any selling profit or loss arising from a sales-type lease is recorded at lease commencement. Selling profit or loss is presented on a gross basis when the company enters into a lease to realize value from a product that it would otherwise sell in its ordinary course of business. For segment reporting, the net investment in sales-type leases excluding the allowance for credit losses is recognized as hardware revenue in the Infrastructure segment, while the estimated residual value less related unearned income is recognized as a reduction in revenue in the Other revenue category and represents the portion of fair value retained by the company. In transactions where the company enters into a lease for the purpose of generating revenue by providing financing, the selling profit or loss is presented on a net basis. Under a sales-type lease, initial direct costs are expensed at lease commencement. Over the term of the lease, the company recognizes finance income on the net investment in the lease and any variable lease payments, which are not included in the net investment in the lease.

For a direct financing lease, the net investment in the lease is measured similarly to a sales-type lease, however, the net investment in the lease is reduced by any selling profit. In a direct financing lease, the selling profit and initial direct costs are deferred at commencement and recognized over the lease term. The company rarely enters into direct financing leases.

The estimated residual value represents the estimated fair value of the equipment under lease at the end of the lease. The company estimates the future fair value of leased equipment by using historical models, analyzing the current market for new and used equipment and obtaining forward-looking product information such as marketing plans and technology innovations. The company optimizes the recovery of residual values by extending lease arrangements with, or selling leased equipment to existing clients, and periodically reassesses the realizable value of its lease residual values. Anticipated decreases in specific future residual values that are considered to be other-than-temporary are recognized immediately upon identification and are recorded as adjustments to the residual value estimate and unearned income, which reduces current period and future period financing income, respectively.

## Common Stock

Common stock refers to the $.20 par value per share capital stock as designated in the company's Certificate of Incorporation. Treasury stock is accounted for using the cost method. When treasury stock is reissued, the value is computed and recorded using a weighted-average basis.

## Earnings Per Share of Common Stock

Earnings per share (EPS) is computed using the two-class method, which determines EPS for each class of common stock and participating securities according to dividends and dividend equivalents and their respective participation rights in undistributed earnings. Basic EPS of common stock is computed by dividing net income by the weighted-average number of common shares outstanding for the period. Diluted EPS of common stock is computed on the basis of the weighted-average number of shares of common stock plus the effect of dilutive potential common shares outstanding during the period using the treasury stock method. Dilutive potential common shares include outstanding stock awards, convertible notes and stock options.

## NOTE B. ACCOUNTING CHANGES

## New Standards to be Implemented

## Disaggregation of Income Statement Expenses

Standard/Description -Issuance date: November 2024. This guidance requires a new tabular disclosure of certain types of expenses (including purchases of inventory, employee compensation, depreciation and amortization) that are included within commonly presented expense captions on the income statement. The guidance also requires the disclosure of a qualitative description of the amounts remaining in relevant expense captions that are not separately disaggregated quantitatively. Additionally, the guidance requires the disclosure of the total amount of selling expenses and an entity's definition of selling expenses. The disclosures are required on an interim and annual basis.

Effective Date and Adoption Considerations -The guidance is effective for the company for annual reporting periods beginning in 2027, and for interim reporting periods beginning January 1, 2028. Early adoption is permitted. The company expects to adopt the guidance as of the effective date and to apply the guidance on a prospective basis.

Effect on Financial Statements or Other Significant Matters -Given the scope of the work required to implement the new standard, the company began its assessment process in 2024. A cross-functional implementation team has been established which is evaluating the need for any changes to systems, processes, data or controls to meet the additional disclosure requirements. As the guidance is a change to disclosures only, it will impact the Notes to the Consolidated Financial Statements but will not impact the consolidated financial results.

## Income Tax Disclosures

Standard/Description -Issuance date: December 2023. This guidance requires disaggregated disclosure of the tax rate reconciliation into eight categories, with further disaggregation required for items greater than a specific threshold. Additionally, the guidance requires the disclosure of income taxes paid disaggregated by federal, state and foreign jurisdictions.

Effective Date and Adoption Considerations -The guidance is effective January 1, 2025 and early adoption is permitted. The company expects to adopt the guidance as of the effective date.

Effect on Financial Statements or Other Significant Matters -As the guidance is a change to disclosures only, it will impact note G, "Taxes," but will not impact the consolidated financial results.

## Standards Implemented

## Segment Reporting Disclosures

Standard/Description -Issuance date: November 2023. This guidance requires the disclosure of significant segment expenses that are regularly provided to a company 's chief operating decision maker and included within each reported measure of segment profit or loss. The company must also disclose "other segment items," which is the difference between segment revenue less significant expenses for each reported measure of segment profit or loss, and a description of its composition. This guidance also requires all segment annual disclosures to be provided on an interim basis.

Effective Date and Adoption Considerations -The guidance was effective for annual periods beginning in 2024, and for interim periods beginning January 1, 2025, and is required to be applied on a retrospective basis to all prior periods presented. Early adoption was permitted. The company adopted the guidance as of the effective date.

Effect on Financial Statements or Other Significant Matter s -The guidance is a change to disclosures only, that impacted note D, "Segments," but did not have an impact on the consolidated financial results.

## Disclosures of Supplier Finance Program Obligations

Standard/Description -Issuance date: September 2022. This guidance requires an entity to provide certain interim and annual disclosures about the use of supplier finance programs in connection with the purchase of goods or services.

Effective Date and Adoption Considerations -The guidance was effective January 1, 2023 with certain annual disclosures required beginning in 2024 and early adoption was permitted. The company adopted the guidance as of the effective date.

Effect on Financial Statements or Other Significant Matters -The guidance is a change to disclosures only, that impacted the supplier financing disclosure in note A, "Significant Accounting Policies," but did not have an impact on the consolidated financial results.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## NOTE C. REVENUE RECOGNITION

## Disaggregation of Revenue

The following tables provide details of revenue by major products/service offerings and revenue by geography. In the first quarter of 2025, the company announced changes to the reported revenue categories within its Software and Consulting reportable segments. Since these changes did not occur until first-quarter 2025, the periods presented in this Annual Report are reported under the historical reported revenue categories, as shown in the following tables. These changes will not impact the company's Consolidated Financial Statements or its reportable segments.

## Revenue by Major Products/Service Offerings


| ($ in millions) For the year ended December 31:   | 2024      | 2023  (1)   | 2022  (1)   |
|---------------------------------------------------|-----------|-------------|-------------|
| Hybrid Platform & Solutions                       | $  18,808 | $  17,396   | $  16,458   |
| Transaction Processing                            | 8,277     | 7,615       | 7,171       |
| Total Software                                    | $  27,085 | $  25,011   | $  23,629   |
| Business Transformation                           | $  9,347  | $  9,179    | $  8,834    |
| Application Operations                            | 7,692     | 7,930       | 7,494       |
| Technology Consulting                             | 3,653     | 3,775       | 3,730       |
| Total Consulting                                  | $  20,692 | $  20,884   | $  20,058   |
| Hybrid Infrastructure                             | $  8,913  | $  9,215    | $  9,451    |
| Infrastructure Support                            | 5,107     | 5,377       | 5,837       |
| Total Infrastructure                              | $  14,020 | $  14,593   | $  15,288   |
| Financing  (2)                                    | $  713    | $  741      | $  645      |
| Other                                             | $  243    | $  632      | $  909      |
| Total Revenue                                     | $  62,753 | $  61,860   | $  60,530   |

(1) Recast to reflect January 2024 segment changes. Refer to note D, "Segments," for additional information.

(2) Contains lease and loan financing arrangements which are not subject to the guidance on revenue from contracts with customers.

## Revenue by Geography


|                                 | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|---------------------------------|-------------------|-------------------|-------------------|
| For the year ended December 31: | 2024              | 2023              | 2022              |
| Americas                        | $  31,266         | $  31,666         | $  31,057         |
| Europe/Middle East/Africa       | 19,429            | 18,492            | 17,950            |
| Asia Pacific                    | 12,058            | 11,702            | 11,522            |
| Total                           | $  62,753         | $  61,860         | $  60,530         |

## Remaining Performance Obligations

The remaining performance obligation (RPO) disclosure provides the aggregate amount of the transaction price yet to be recognized as of the end of the reporting period and an explanation as to when the company expects to recognize these amounts in revenue. It is intended to be a statement of overall work under contract that has not yet been performed and does not include contracts in which the customer is not committed, such as certain as-a-Service, governmental, term software license and services offerings. The customer is not considered committed when they are able to terminate for convenience without payment of a substantive penalty. The disclosure includes estimates of variable consideration, except when the variable consideration is a sales-based or usagebased royalty promised in exchange for a license of intellectual property. Additionally, as a practical expedient, the company does not include contracts that have an original duration of one year or less. RPO estimates are subject to change and are affected by several factors, including terminations, changes in the scope of contracts, periodic revalidations, adjustment for revenue that has not materialized and adjustments for currency.

At December 31, 2024, the aggregate amount of the transaction price allocated to RPO related to customer contracts that are unsatisfied or partially unsatisfied was approximately $63 billion, of which approximately 67 percent is expected to be recognized as revenue in the subsequent two years, approximately 29 percent in the subsequent three to five years, and the balance thereafter.

## Revenue Recognized for Performance Obligations Satisfied (or Partially Satisfied) in Prior Periods

For the year ended December 31, 2024, revenue for performance obligations satisfied or partially satisfied in previous periods was immaterial.

## 68 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Reconciliation of Contract Balances

The following table provides information about notes and accounts receivable-trade, contract assets and deferred income balances.


|                                                                                            | ($ in millions)   | ($ in millions)   |
|--------------------------------------------------------------------------------------------|-------------------|-------------------|
| At December 31:                                                                            | 2024              | 2023              |
| Notes and accounts receivable - trade (net of allowances of $114 in 2024 and $192 in 2023) | $  6,804          | $  7,214          |
| Contract assets  (1)                                                                       | 433               | 505               |
| Deferred income (current)                                                                  | 13,907            | 13,451            |
| Deferred income (noncurrent)                                                               | 3,622             | 3,533             |

(1) Included within prepaid expenses and other current assets in the Consolidated Balance Sheet.

The amount of revenue recognized during the year ended December 31, 2024 that was included within the deferred income balance at December 31, 2023 was $11.0 billion and primarily related to software and services.

The following table provides roll forwards of the notes and accounts receivable-trade allowance for expected credit losses for the years ended December 31, 2024 and 2023.


| ($ in millions)   | ($ in millions)      | ($ in millions)   | ($ in millions)            | ($ in millions)   |
|-------------------|----------------------|-------------------|----------------------------|-------------------|
| January 1, 2024   | Additions/(Releases) | Write-offs  (1)   | Foreign currency and Other | December 31, 2024 |
| $192              | $(2)                 | $(78)             | $2                         | $114              |
| January 1, 2023   | Additions/(Releases) | Write-offs  (1)   | Foreign currency and Other | December 31, 2023 |
| $233              | $32                  | $(79)             | $6                         | $192              |

(1) The majority of the write-offs during the period related to receivables which had been previously reserved.

The contract assets allowance for expected credit losses was not material in the years ended December 31, 2024 and 2023.

## Deferred Costs


| ($ in millions)                        |          |          |
|----------------------------------------|----------|----------|
| At December 31:                        | 2024     | 2023     |
| Capitalized costs to obtain a contract | $  794   | $  686   |
| Deferred costs to fulfill a contract   |          |          |
| Deferred setup costs                   | 326      | 399      |
| Other deferred fulfillment costs       | 628      | 755      |
| Total deferred costs  (1)              | $  1,748 | $  1,841 |

(1) Of the total deferred costs, $959 million was current and $788 million was noncurrent at December 31, 2024 and $998 million was current and $842 million was noncurrent at December 31, 2023.

The amount of total deferred costs amortized during the year ended December 31, 2024 was $1,363 million and there were no material impairment losses incurred. Refer to note A, "Significant Accounting Policies," for additional information on deferred costs to fulfill a contract and capitalized costs of obtaining a contract.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## NOTE D. SEGMENTS

In the first quarter of 2024, the company made changes to its organizational structure and management system to better align its portfolio with the market, increase transparency and improve segment comparability to peers. These changes did not impact the company's Consolidated Financial Statements, but did impact its reportable segments. Due to the removal of certain components of segment profitability, as described below, the company also updated the title of its segment performance metric from pre-tax income from continuing operations to segment profit.

The following table displays the segment updates:


| Reportable Segment Change                                                                    | Resulting Segment Implications                                                          |
|----------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------|
| The Weather Company asset divestiture  (1)                                                   | - Software Segment                                                                      |
|                                                                                              | + Other-divested business                                                               |
| Security Services realignment                                                                | - Software Segment                                                                      |
|                                                                                              | + Consulting Segment                                                                    |
| Removal of stock-based compensation and net interest  allocations from segment profitability | - Software Segment, Consulting Segment, Infrastructure  Segment, Financing Segment  (2) |
|                                                                                              | + Other                                                                                 |

(1) The Weather Company asset divestiture closed January 31, 2024.

(2) Presentation of interest for the Financing Segment did not change.

The segments represent components of the company for which separate financial information is available that is utilized on a regular basis by the chief operating decision maker (Chairman, President and Chief Executive Officer) in determining how to allocate resources and evaluate performance. The segments are determined based on several factors, including client base, homogeneity of products, technology, delivery channels and similar economic characteristics.

Certain transactions between the segments are recorded to other (income) and expense and are reflected in segment profit. The company utilizes globally integrated support organizations to realize economies of scale and efficient use of resources. As a result, a considerable amount of expense is shared by all of the segments. This shared expense includes sales coverage, certain marketing functions and support functions such as Accounting, Treasury, Procurement, Legal, Human Resources, Chief Information Office, and Billing and Collections. Where practical, shared expenses are allocated based on measurable drivers of expense, e.g., headcount. When a clear and measurable driver cannot be identified, shared expenses are allocated on a financial basis that is consistent with the company's management system, e.g., advertising expense is allocated based on the gross profits of the segments. A portion of the shared expenses, which are recorded in net income, are not allocated to the segments. These expenses are associated with the elimination of internal transactions and other miscellaneous items.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The following tables reflect the results of continuing operations of the company's segments consistent with the management and measurement system utilized within the company and have been recast for the prior-year periods to reflect the company's segment changes described above. Performance measurement is based on segment profit. The chief operating decision maker considers budget-to-actual results of segment profit, both when evaluating the performance of and allocating resources to each of the segments as well as in developing certain compensation recommendations.

## Management System Segment View


| For the year ended December 31 $^{(1)}$:   | Software   | Consulting   | Infrastructure   | Financing  (2)   | Total  Segments   |
|--------------------------------------------|------------|--------------|------------------|------------------|-------------------|
| 2024                                       |            |              |                  |                  |                   |
| Revenue                                    | $  27,085  | $  20,692    | $  14,020        | $  713           | $  62,510         |
| Segment cost                               | 4,428      | 15,103       | 6,201            | 372              | 26,103            |
| Other expense and (income)  (3)            | 13,974     | 3,535        | 5,369            | (6)              | 22,872            |
| Segment profit                             | 8,684      | 2,054        | 2,450            | 348              | 13,535            |
| Revenue year-to-year change                | 8.3%       | (0.9) %      | (3.9) %          | (3.7) %          | 2.1%              |
| Segment profit year-to-year change         | 15.8%      | (3.6) %      | (13.4) %         | (6.6) %          | 5.5%              |
| Segment profit margin                      | 32.1%      | 9.9 %        | 17.5 %           | 48.8 %           | 21.7%             |
| 2023                                       |            |              |                  |                  |                   |
| Revenue                                    | $  25,011  | $  20,884    | $  14,593        | $  741           | $  61,229         |
| Segment cost                               | 4,289      | 15,297       | 6,406            | 384              | 26,376            |
| Other expense and (income)  (3)            | 13,222     | 3,458        | 5,359            | (16)             | 22,023            |
| Segment profit                             | 7,499      | 2,130        | 2,828            | 373              | 12,829            |
| Revenue year-to-year change                | 5.8%       | 4.1 %        | (4.5) %          | 14.8 %           | 2.7%              |
| Segment profit year-to-year change         | 6.9%       | 13.8 %       | 5.9 %            | 9.8 %            | 7.9%              |
| Segment profit margin                      | 30.0%      | 10.2 %       | 19.4 %           | 50.3 %           | 21.0%             |
| 2022                                       |            |              |                  |                  |                   |
| Revenue                                    | $  23,629  | $  20,058    | $  15,288        | $  645           | $  59,621         |
| Segment cost                               | 4,146      | 14,878       | 7,212            | 398              | 26,634            |
| Other expense and (income)  (3)            | 12,471     | 3,310        | 5,405            | (92)             | 21,093            |
| Segment profit                             | 7,012      | 1,871        | 2,671            | 340              | 11,893            |

(1) Prior-year amounts recast to reflect January 2024 segment changes.

(2) Refer to "Segment Assets and Other Items" section below for additional information on financing interest income and expense.

(3) Other expense and (income) by segment primarily includes:

Software - SG&A, RD&E, Other income, Intellectual property and custom development income

Consulting - SG&A

Infrastructure - SG&A, RD&E, Intellectual property and custom development income, Other income

Financing - Intercompany financing net other income, SG&A

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Reconciliations of IBM as Reported


| ($ in millions)                 |           |           |           |
|---------------------------------|-----------|-----------|-----------|
| For the year ended December 31: | 2024      | 2023  (1) | 2022  (1) |
| Revenue                         |           |           |           |
| Total reportable segments       | $  62,510 | $  61,229 | $  59,621 |
| Other-divested businesses       | 35        | 397       | 774       |
| Other revenue                   | 207       | 235       | 135       |
| Total revenue                   | $  62,753 | $  61,860 | $  60,530 |


| ($ in millions)                                      |           |           |           |
|------------------------------------------------------|-----------|-----------|-----------|
| For the year ended December 31:                      | 2024      | 2023  (1) | 2022  (1) |
| Pre-tax income from continuing operations            |           |           |           |
| Total reportable segment profit                      | $  13,535 | $  12,829 | $  11,893 |
| Amortization of acquired intangible assets           | (1,830)   | (1,627)   | (1,747)   |
| Acquisition-related (charges)/income  (2)            | (122)     | (33)      | (18)      |
| Non-operating retirement-related (costs)/income  (3) | (3,457)   | 39        | (6,548)   |
| Kyndryl-related impacts  (4)                         | -         | -         | (351)     |
| Stock-based compensation                             | (1,311)   | (1,133)   | (987)     |
| Net interest excluding the Financing segment         | (984)     | (973)     | (1,071)   |
| Workforce rebalancing charges  (5)                   | (692)     | (435)     | -         |
| Other-divested businesses  (6)                       | 234       | 83        | 239       |
| Unallocated corporate amounts and other  (7)         | 425       | (59)      | (254)     |
| Total pre-tax income from continuing operations      | $  5,797  | $  8,690  | $  1,156  |

(1) Recast to reflect January 2024 segment changes.

(2) 2024 and 2023 include the impacts of foreign exchange derivative contracts entered into by the company prior to the acquisition of StreamSets and webMethods from Software AG. Refer to note S, "Derivative Financial Instruments," for additional information.

(3) 2024 and 2022 include the impacts of pension settlement charges of $3.1 billion and $5.9 billion, respectively. Refer to note U, "Retirement-Related Benefits," for additional information.

(4) Net impacts for Kyndryl retained shares and related swaps. Refer to note S, "Derivative Financial Instruments," for additional information.

(5) Beginning in the first quarter of 2023, the company updated its measure of segment profit, consistent with its management system, to no longer allocate workforce rebalancing charges to its reportable segments. Workforce rebalancing charges of $40 million for 2022 were included in the segments.

(6) 2024 includes a gain from the divestiture of The Weather Company assets. 2022 includes a gain from the sale of healthcare software assets. Refer to note E, "Acquisitions & Divestitures," for additional information.

(7) 2024 includes a gain from the sale of certain QRadar SaaS assets. Refer to note E, "Acquisitions & Divestitures," for additional information.

## 72 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Immaterial Items

## Equity Method Investments and Equity Method Investments Gains/(Losses)

The equity method investments and the resulting gains and (losses) from these investments that are attributable to the segments did not have a material effect on the financial position or the financial results of the segments.

## Segment Assets and Other Items

Software assets are mainly goodwill, acquired intangible assets and accounts receivable. Consulting assets are primarily goodwill and accounts receivable. Infrastructure assets are primarily goodwill, plant, property and equipment, manufacturing inventory and accounts receivable. Financing assets are primarily financing receivables and cash and marketable securities.

To ensure the efficient use of the company's space and equipment, several segments may share leased or owned plant, property and equipment assets. Where assets are shared, landlord ownership of the assets is assigned to one segment and is not allocated to each user segment. This is consistent with the company's management system and is reflected accordingly in the table below. In those cases, there will not be a precise correlation between segment profit and segment assets.

Depreciation expense and capital expenditures that are reported by each segment also are consistent with the landlord ownership basis of asset assignment.

Financing interest income of $681 million, $680 million and $582 million for the years ended December 31, 2024, 2023 and 2022, respectively, reflect the income associated with Financing's external client transactions, as well as the income from investment in cash and marketable securities. Financing interest expense of $369 million, $298 million and $175 million for the years ended December 31, 2024, 2023 and 2022, respectively, reflect the expense associated with intercompany loans set to substantially match the term, currency and interest rate variability underlying the financing receivables and secured borrowings both supporting Financing 's external client transactions. These secured borrowings are included in note O, "Borrowings." Financing segment cost primarily reflects the cost of financing presented in IBM's Consolidated Income Statement. Intercompany financing activities are recorded to other (income) and expense and are reflected in segment profit. These intercompany transactions are eliminated in IBM's consolidated financial results.

## Management System Segment View


| For the year ended December 31:                        | Software   | Consulting   | Infrastructure   | Financing   | Total  Segments   |
|--------------------------------------------------------|------------|--------------|------------------|-------------|-------------------|
| 2024                                                   |            |              |                  |             |                   |
| Assets                                                 | $  60,707  | $  14,826    | $  12,161        | $  14,075   | $  101,769        |
| Depreciation/amortization of non-acquired  intangibles | 495        | 100          | 1,103            | 9           | 1,708             |
| Capital expenditures/investments in intangibles        | 338        | 14           | 684              | 11          | 1,048             |
| 2023  (1)                                              |            |              |                  |             |                   |
| Assets                                                 | $  59,811  | $  15,089    | $  11,991        | $  14,409   | $  101,300        |
| Depreciation/amortization of non-acquired  intangibles | 510        | 109          | 1,018            | 8           | 1,646             |
| Capital expenditures/investments in intangibles        | 369        | 21           | 836              | 15          | 1,241             |
| 2022  (1)                                              |            |              |                  |             |                   |
| Assets                                                 | $  55,822  | $  14,261    | $  12,243        | $  15,757   | $  98,083         |
| Depreciation/amortization of non-acquired  intangibles | 547        | 112          | 1,250            | 14          | 1,923             |
| Capital expenditures/investments in intangibles        | 463        | 29           | 853              | 27          | 1,371             |

(1) Recast to reflect January 2024 segment changes.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Reconciliations of IBM as Reported


| At December 31:                      | 2024       | 2023       |
|--------------------------------------|------------|------------|
| Assets                               |            |            |
| Total reportable segments  (1)       | $  101,769 | $  101,300 |
| Elimination of internal transactions | (853)      | (1,028)    |
| Other-divested businesses  (1)       | 74         | 601        |
| Unallocated amounts                  |            |            |
| Cash and marketable securities       | 14,243     | 12,907     |
| Deferred tax assets                  | 6,850      | 6,468      |
| Plant, other property and equipment  | 1,952      | 1,838      |
| Operating right-of-use assets        | 2,001      | 2,085      |
| Pension assets                       | 7,492      | 7,506      |
| Other                                | 3,647      | 3,563      |
| Total IBM consolidated assets        | $  137,175 | $  135,241 |

(1) Prior-year amount recast to reflect January 2024 segment changes.

## Major Clients

No single client represented 10 percent or more of the company's total revenue in 2024, 2023 or 2022.

## Geographic Information

The following tables provide information for those countries that are 10 percent or more of the specific category.

## Revenue (1)


|                                 | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|---------------------------------|-------------------|-------------------|-------------------|
| For the year ended December 31: | 2024              | 2023              | 2022              |
| United States                   | $  25,144         | $  25,309         | $  25,098         |
| Other countries                 | 37,609            | 36,551            | 35,432            |
| Total revenue                   | $  62,753         | $  61,860         | $  60,530         |

(1) Revenues are attributed to countries based on the location of the client.

## Plant and Other Property-Net (1)


|                 | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|-----------------|-------------------|-------------------|-------------------|
| At December 31: | 2024              | 2023              | 2022              |
| United States   | $  4,009          | $  3,466          | $  3,209          |
| Other countries | 1,717             | 2,027             | 2,100             |
| Total           | $  5,726          | $  5,492          | $  5,308          |

(1) Excludes rental machines.

## Operating Right-of-Use Assets-Net


| ($ in millions)      |          |          |          |
|----------------------|----------|----------|----------|
| At December 31:      | 2024     | 2023     | 2022     |
| United States        | $  1,154 | $  1,249 | $  1,074 |
| India  (1)           | 365      | 218      | 254      |
| Japan                | 324      | 340      | 259      |
| Other countries  (1) | 1,355    | 1,413    | 1,290    |
| Total                | $  3,197 | $  3,220 | $  2,878 |

(1) Prior-year amounts have been reclassified to conform to the change in 2024 presentation.

## 74 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Revenue by Classes of Similar Products or Services

The following table presents external revenue for similar classes of products or services within the company's reportable segments. Client solutions often include IBM software and systems and other suppliers' products if the client solution requires it. For each of the segments that include services, Software-as-a-Service, consulting, education, training and other product-related services are included as services. For each of these segments, software includes product license charges and ongoing subscriptions.


|                                 | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|---------------------------------|-------------------|-------------------|-------------------|
| For the year ended December 31: | 2024              | 2023  (1)         | 2022  (1)         |
| Software                        |                   |                   |                   |
| Software                        | $  24,055         | $  22,409         | $  21,326         |
| Services                        | 3,002             | 2,562             | 2,237             |
| Systems                         | 29                | 40                | 66                |
| Consulting                      |                   |                   |                   |
| Services                        | $  20,277         | $  20,515         | $  19,757         |
| Software                        | 324               | 272               | 207               |
| Systems                         | 91                | 98                | 94                |
| Infrastructure                  |                   |                   |                   |
| Maintenance                     | $  3,951          | $  4,138          | $  4,590          |
| Servers                         | 3,693             | 4,253             | 4,471             |
| Storage                         | 2,360             | 2,081             | 1,989             |
| Services                        | 2,262             | 2,463             | 2,653             |
| Software                        | 1,753             | 1,658             | 1,585             |
| Financing                       |                   |                   |                   |
| Financing                       | $  681            | $  680            | $  582            |
| Used equipment sales            | 32                | 60                | 64                |

(1) Recast to reflect January 2024 segment changes.

## NOTE E. ACQUISITIONS & DIVESTITURES

## Acquisitions

Purchase price consideration for all acquisitions was paid primarily in cash. All acquisitions, except otherwise stated, were for 100 percent of the acquired business and are reported in the Consolidated Statement of Cash Flows, net of acquired cash and cash equivalents.

The goodwill generated from these acquisitions is primarily attributable to the assembled workforce and the expected synergies from the integration of the acquired businesses. The identified intangible assets are amortized on a straight-line basis over their useful life which approximates the economic life of the assets.

## 2024

In 2024, the company completed seven acquisitions within the Software segment and four acquisitions within the Consulting segment at an aggregate cost of $3,515 million. These acquisitions are expected to enhance the company's portfolio of products and services capabilities and further advance IBM's hybrid cloud and AI strategy.

At December 31, 2024, the remaining cash to be remitted by the company related to certain 2024 acquisitions was $156 million, of which $90 million was classified as restricted cash in the Consolidated Balance Sheet. The remaining cash amount is primarily expected to be paid in 2025.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The following table reflects the purchase price related to these acquisitions and the resulting purchase price allocations as of December 31, 2024.

($ in millions)


|                                                 | Amortization  Life (in Years)   | StreamSets and  webMethods   | Other  Acquisitions   |
|-------------------------------------------------|---------------------------------|------------------------------|-----------------------|
| Current assets                                  |                                 | $  347                       | $  120                |
| Property, plant and equipment/noncurrent assets |                                 | 12                           | 14                    |
| Intangible assets                               |                                 |                              |                       |
| Goodwill                                        | N/A                             | 1,074                        | 918                   |
| Client relationships                            | 1-7                             | 680                          | 167                   |
| Completed technology                            | 5-7                             | 550                          | 179                   |
| Trademarks                                      | 1-7                             | 45                           | 6                     |
| Total assets acquired                           |                                 | $  2,707                     | $  1,403              |
| Current liabilities                             |                                 | 196                          | 66                    |
| Noncurrent liabilities                          |                                 | 253                          | 81                    |
| Total liabilities assumed                       |                                 | $  448                       | $  147                |
| Total purchase price                            |                                 | $  2,259                     | $  1,256              |

N/A-Not applicable

The valuation of the assets acquired and liabilities assumed is subject to revision. If additional information becomes available, the company may further revise the purchase price allocation as soon as practical, but no later than one year from the acquisition date; however, material changes are not expected.

StreamSets and webMethods-On July 1, 2024, the company completed the acquisition of StreamSets and webMethods from Software AG for approximately $2.3 billion (€2.13 billion) in cash. StreamSets added new data ingestion capabilities to IBM's data platform and webMethods brought integration platform-as-a-service (iPaaS) capabilities to IBM 's automation solutions. Goodwill of $1,074 million was assigned to the Software segment. It is expected that 56 percent of the goodwill will be deductible for tax purposes. The overall weighted-average useful life of the identified amortizable intangible assets acquired was 7.0 years. The acquisition was integrated into the Software segment. Prior to the acquisition, the company entered into foreign currency derivative contracts which expired by June 28, 2024. Refer to note S, "Derivative Financial Instruments," for financial impacts and additional information.

Other Acquisitions-Goodwill of $470 million, $439 million and $8 million was assigned to the Consulting, Software and Infrastructure segments, respectively. It is expected that 5 percent of the goodwill will be deductible for tax purposes. The overall weighted-average useful life of the identified amortizable intangible assets acquired was 6.7 years.

Transactions Announced-Each of the announced acquisitions is subject to regulatory approvals and other customary closing conditions.

On April 24, 2024, the company announced its intent to acquire all of the outstanding shares of HashiCorp, Inc. (HashiCorp). IBM's and HashiCorp's combined portfolios will help clients manage growing application and infrastructure complexity and create a comprehensive end-to-end hybrid cloud platform designed for the AI era. Under the terms of the definitive agreement, HashiCorp 's shareholders on record immediately prior to the effective time on the closing date will receive $35 per share in cash, representing a total enterprise value of approximately $6.4 billion. On July 15, 2024, HashiCorp stockholders voted to approve the merger with IBM. The transaction is expected to close in the first quarter of 2025, subject to regulatory approvals and other customary closing conditions. Upon closing, HashiCorp will be integrated into the Software segment.

On January 16, 2025, the company announced its intent to acquire an Oracle consultancy company with expertise in driving business transformations with Oracle Cloud Applications, including for clients in the public sector. The acquisition is expected to close in the first quarter of 2025. Upon closing, the acquisition will be integrated into the Consulting segment.

On February 25, 2025, the company announced its intent to acquire a provider of enterprise-grade databases to build and deliver Generative AI applications. The acquisition is expected to close in the second quarter of 2025. Upon closing, the acquisition will be integrated into the Software segment.

Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## 2023

In 2023, the company completed seven acquisitions within the Software segment and two acquisitions within the Consulting segment at an aggregate cost of $5,197 million.

At December 31, 2024 and 2023, the remaining cash to be remitted by the company related to certain 2023 acquisitions was not material.

The following table reflects the purchase price related to these acquisitions and the resulting purchase price allocations as of December 31, 2024. Net purchase price adjustments recorded in 2024 were not material.


|                                                 | Amortization  Life (in Years)   | Apptio, Inc.   | Other Acquisitions   |
|-------------------------------------------------|---------------------------------|----------------|----------------------|
| Current assets                                  |                                 | $  145         | $  83                |
| Property, plant and equipment/noncurrent assets |                                 | 23             | 20                   |
| Intangible assets                               |                                 |                |                      |
| Goodwill                                        | N/A                             | 3,501          | 382                  |
| Client relationships                            | 6-10                            | 770            | 44                   |
| Completed technology                            | 5-7                             | 530            | 108                  |
| Trademarks                                      | 1-5                             | 35             | 2                    |
| Total assets acquired                           |                                 | $  5,005       | $  639               |
| Current liabilities                             |                                 | 250            | 44                   |
| Noncurrent liabilities                          |                                 | 143            | 10                   |
| Total liabilities assumed                       |                                 | $  393         | $  54                |
| Total purchase price                            |                                 | $  4,612       | $  585               |

N/A-Not applicable

Apptio, Inc.-On August 10, 2023, the company completed the acquisition of Apptio, Inc., a leading provider of financial and operational IT management and optimization software which enables enterprise leaders to deliver enhanced business value across technology investments. Goodwill of $3,134 million and $367 million was assigned to the Software and Consulting segments, respectively. It is expected that one percent of the goodwill will be deductible for tax purposes. The overall weighted-average useful life of the identified amortizable intangible assets acquired was 8.7 years. The acquisition was integrated into the Software segment.

Other Acquisitions-Goodwill of $341 million, $30 million and $11 million was assigned to the Software, Consulting and Infrastructure segments, respectively. It is expected that none of the goodwill will be deductible for tax purposes. The overall weighted-average useful life of the identified amortizable intangible assets acquired was 6.6 years.

## 2022

In 2022, the company completed four acquisitions within the Software segment and four acquisitions within the Consulting segment at an aggregate cost of $2,651 million.

At December 31, 2024, the remaining cash to be remitted by the company related to certain 2022 acquisitions was $72 million.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The following table reflects the purchase price related to these acquisitions and the resulting purchase price allocations as of December 31, 2023. Net purchase price adjustments recorded in 2023 were not material.


|                                                 | Amortization  Life (in Years)   | Octo     | Other  Acquisitions   |
|-------------------------------------------------|---------------------------------|----------|-----------------------|
| Current assets                                  |                                 | $  119   | $  87                 |
| Property, plant and equipment/noncurrent assets |                                 | 8        | 8                     |
| Intangible assets                               |                                 |          |                       |
| Goodwill                                        | N/A                             | 829      | 1,055                 |
| Client relationships                            | 7-10                            | 365      | 204                   |
| Completed technology                            | 4-7                             | 30       | 90                    |
| Trademarks                                      | 2-3                             | 15       | 10                    |
| Total assets acquired                           |                                 | $  1,366 | $  1,454              |
| Current liabilities                             |                                 | 53       | 52                    |
| Noncurrent liabilities                          |                                 | 50       | 15                    |
| Total liabilities assumed                       |                                 | $  103   | $  67                 |
| Total purchase price                            |                                 | $  1,264 | $  1,387              |

N/A-Not applicable

Octo-On December 22, 2022, the company completed the acquisition of Octo, an IT modernization and digital transformation services provider exclusively serving the U.S. federal government. Goodwill of $709 million and $120 million was assigned to the Consulting and Software segments, respectively. It is expected that 24 percent of the goodwill will be deductible for tax purposes. The overall weighted-average useful life of the identified amortizable intangible assets acquired was 9.3 years. The acquisition was integrated into the Consulting segment.

Other acquisitions-Goodwill of $625 million and $431 million was assigned to the Consulting and Software segments, respectively. It is expected that 52 percent of the goodwill will be deductible for tax purposes. The overall weighted-average useful life of the identified amortizable intangible assets acquired was 6.7 years.

## Divestitures

## 2024

The Weather Company Assets-On January 31, 2024, the company completed the sale of The Weather Company assets to Zephyr Buyer, L.P., a wholly-owned subsidiary of Francisco Partners (collectively, Francisco). Under the agreement, Francisco acquired The Weather Company assets from IBM for $1,100 million inclusive of $250 million of contingent consideration, of which $200 million is contingent on Francisco's attainment of certain investment return metrics. The assets include The Weather Company 's digital consumer-facing offerings, The Weather Channel mobile and cloud-based digital properties including Weather.com, Weather Underground and Storm Radar, as well as its enterprise offerings for broadcast, media, aviation, advertising technology and data solutions for other emerging industries.

Upon closing, the company received cash proceeds of $750 million and provided seller financing to Francisco in the form of a $100 million loan with a term of 7 years. The cash proceeds from the sale were primarily included in cash from investing activities within the Consolidated Statement of Cash Flows. The seller financing is a non-cash investing activity. For the year ended December 31, 2024, the company recognized a pre-tax gain on sale of $243 million in other (income) and expense in the Consolidated Income Statement. As discussed in note D, "Segments," in the first quarter of 2024, The Weather Company assets previously reported in the Software segment were moved and recast to the Other-divested businesses category.

Other Divestitures-The company completed two divestitures in 2024. The financial terms related to each of these transactions did not have a material impact to IBM's Consolidated Financial Statements.

## 2023

The company completed two divestitures in 2023. The financial terms related to each of these transactions did not have a material impact to IBM 's Consolidated Financial Statements.

Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## 2022

Healthcare Software Assets-On June 30, 2022, the company completed the sale of healthcare software assets for the U.S. and Canada to Francisco Partners (Francisco) and received a cash payment of $1,065 million. Subsequent closings were completed in most other countries in the second half of 2022, with the remaining country closings completed in 2023. The assets included Health Insights, MarketScan, Clinical Development, Social Program Management, Micromedex, and imaging software offerings. In addition, IBM provided Francisco with transition services including IT and other services. For the years ended December 31, 2024, 2023 and 2022, the company recognized a pre-tax gain on sale of $13 million, $45 million and $258 million, respectively, in other (income) and expense in the Consolidated Income Statement.

Other Divestitures-In the first quarter of 2022, the Infrastructure segment completed one divestiture. The financial terms related to this transaction did not have a material impact to IBM 's Consolidated Financial Statements.

## Sale of Assets

## 2024

On August 31, 2024, the company completed the sale of certain QRadar SaaS (software-as-a-service) assets including QRadar intellectual property, customer relationships and customer contracts to Palo Alto Networks (Palo Alto). Upon closing, the company received cash proceeds of $500 million from Palo Alto. Proceeds of $437 million from the sale were included in proceeds from disposition of property, plant and equipment/other within cash from investing activities and the remaining $63 million related to transition and migration services described below were included within cash from operating activities in the Consolidated Statement of Cash Flows. For the year ended December 31, 2024, the company recognized a pre-tax gain on sale of $349 million in other (income) and expense in the Consolidated Income Statement.

In connection with the sale of the QRadar SaaS assets, IBM and Palo Alto are facilitating the migration of QRadar SaaS and IBM's QRadar on-premise (on-prem) clients who choose to migrate to Palo Alto's Cortex XSIAM, their security operations (SOC) platform. As part of the agreement, IBM will receive incremental future cash payments from Palo Alto for QRadar on-prem clients who choose to migrate to the Cortex XSIAM platform. Until this migration is completed, or contracts expire, the contractual relationship with certain QRadar SaaS and IBM's QRadar on-prem clients remains with IBM. IBM also provides Palo Alto with transition services including support, operations and other services for QRadar SaaS customer contracts. The client migrations to Cortex XSIAM platform and transition services did not have a material impact on IBM's Consolidated Financial Statements in 2024.

## NOTE F. OTHER (INCOME) AND EXPENSE

Components of other (income) and expense are as follows:


|                                                          | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|----------------------------------------------------------|-------------------|-------------------|-------------------|
| For the year ended December 31:                          | 2024              | 2023              | 2022              |
| Other (income) and expense                               |                   |                   |                   |
| (Gains)/losses on foreign currency transactions  (1)     | $  (458)          | $  116            | $  (643)          |
| (Gains)/losses on derivative instruments  (1)            | 515               | (17)              | 225               |
| Interest income                                          | (747)             | (670)             | (162)             |
| Net (gains)/losses from securities and investment assets | (20)              | (39)              | 278               |
| Retirement-related costs/(income)  (2)                   | 3,457             | (39)              | 6,548             |
| Other  (3)                                               | (877)             | (266)             | (443)             |
| Total other (income) and expense                         | $  1,871          | $  (914)          | $  5,803          |

(1) The company uses financial hedging instruments to limit specific currency risks related to foreign currency-based transactions. The hedging program does not hedge 100 percent of currency exposures and defers, versus eliminates, the impact of currency. Refer to note S, "Derivative Financial Instruments," for additional information on foreign exchange risk.

(2) 2024 and 2022 include the impacts of pension settlement charges of $3.1 billion and $5.9 billion, respectively. Refer to note U, "Retirement-Related Benefits," for additional information.

(3) 2024 includes pre-tax gains of $349 million from the sale of certain QRadar SaaS assets and $243 million from the divestiture of The Weather Company assets. 2022 includes a pre-tax gain of $258 million from the sale of healthcare software assets. Refer to note E, "Acquisitions & Divestitures," for additional information.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## NOTE G. TAXES


|                                                              | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|--------------------------------------------------------------|-------------------|-------------------|-------------------|
| For the year ended December 31:                              | 2024              | 2023              | 2022              |
| Income/(loss) from continuing operations before income taxes |                   |                   |                   |
| U.S. operations  (1)                                         | $  (3,405)        | $  (227)          | $  (6,602)        |
| Non-U.S. operations                                          | 9,202             | 8,917             | 7,758             |
| Total income from continuing operations before income taxes  | $  5,797          | $  8,690          | $  1,156          |

(1) 2024 and 2022 include the impact of a pension settlement charge of $2.7 billion and $5.9 billion, respectively. Refer to note U, "Retirement-Related Benefits," for additional information.

The components of the income from continuing operations provision for/(benefit from) income taxes by taxing jurisdiction were as follows:


| ($ in millions)                                                       |            |          |            |
|-----------------------------------------------------------------------|------------|----------|------------|
| For the year ended December 31:                                       | 2024       | 2023     | 2022       |
| U.S. federal                                                          |            |          |            |
| Current                                                               | $  (335)   | $  560   | $  391     |
| Deferred                                                              | (2,204)    | (1,371)  | (2,645)    |
|                                                                       | $  (2,539) | $  (811) | $  (2,253) |
| U.S. state and local                                                  |            |          |            |
| Current                                                               | $  152     | $  127   | $  184     |
| Deferred                                                              | (335)      | (162)    | (486)      |
|                                                                       | $  (183)   | $  (34)  | $  (302)   |
| Non-U.S.                                                              |            |          |            |
| Current                                                               | $  2,301   | $  1,594 | $  1,676   |
| Deferred                                                              | 203        | 428      | 252        |
|                                                                       | $  2,504   | $  2,022 | $  1,929   |
| Total continuing operations provision for/(benefit from) income taxes | $  (218)   | $  1,176 | $  (626)   |
| Discontinued operations provision for/(benefit from) income taxes     | $  6       | $  (9)   | $  124     |
| Total provision for/(benefit from) income taxes                       | $  (212)   | $  1,167 | $  (503)   |

In addition to the total provision for/(benefit from) income taxes, the company recorded a provision included in net income for social security, real estate, personal property and other taxes of approximately $2.9 billion in 2024. The total taxes included in net income was approximately $2.7 billion in 2024.

A reconciliation of the statutory U.S. federal tax rate to the company's effective tax rate from continuing operations was as follows:


| For the year ended December 31:         | 2024   | 2023   | 2022   |
|-----------------------------------------|--------|--------|--------|
| Statutory rate                          | 21 %   | 21 %   | 21 %   |
| Tax differential on foreign income  (1) | (13)   | (3)    | (29)   |
| Domestic incentives  (1)                | (7)    | (5)    | (24)   |
| State and local  (1)                    | (2)    | 0      | (21)   |
| Other  (1)                              | (3)    | 1      | (1)    |
| Effective rate                          | (4) %  | 14 %   | (54) % |

(1) 2024 includes the impacts of pension settlement charges on tax differential on foreign income, domestic incentives, state and local, and other of (4) points, (3) points, (2) points, and (1) point, respectively. 2022 includes the impacts of a pension settlement charge on tax differential on foreign income, domestic incentives, state and local, and other of (24) points, (20) points, (21) points, and (1) point, respectively. Refer to note U, "Retirement-Related Benefits," for additional information.

Percentages rounded for disclosure purposes.

The significant components reflected within the tax rate reconciliation labeled "Tax differential on foreign income" include the effects of foreign subsidiaries' earnings taxed at rates other than the U.S. statutory rate, U.S. taxes on foreign income and any net impacts of intercompany transactions. These items also reflect audit settlements or changes in the amount of unrecognized tax benefits associated with each of these items.

Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The continuing operations effective tax rate was (3.8) percent, 13.5 percent, and (54.2) percent in 2024, 2023, and 2022, respectively. The 2024 and 2022 effective tax rates were driven by the tax impact of the pension settlement charges. Refer to note U, "Retirement-Related Benefits," for additional information. The 2024 effective tax rate was also driven by the resolution of certain tax audit matters.

The effect of tax law changes on deferred tax assets and liabilities did not have a material impact on the company's 2024 effective tax rate.

## Deferred Tax Assets


| ($ in millions) At December 31:                | 2024      | 2023      |
|------------------------------------------------|-----------|-----------|
| Retirement benefits                            | $  1,898  | $  2,269  |
| Leases                                         | 1,157     | 1,055     |
| Share-based and other compensation             | 796       | 720       |
| Tax losses/credits  (1) (2)                    | 3,615     | 3,069     |
| Deferred income                                | 790       | 682       |
| Bad debt, inventory and warranty reserves      | 198       | 305       |
| Depreciation                                   | 238       | 205       |
| Accruals (includes restructuring charges)  (2) | 395       | 347       |
| Intangible assets                              | 2,482     | 2,774     |
| Capitalized research and development           | 4,185     | 3,524     |
| Other  (2)                                     | 784       | 917       |
| Gross deferred tax assets                      | 16,537    | 15,868    |
| Less: valuation allowance                      | 1,223     | 765       |
| Net deferred tax assets                        | $  15,314 | $  15,103 |

## Deferred Tax Liabilities


| ($ in millions)                |          |          |
|--------------------------------|----------|----------|
| At December 31:                | 2024     | 2023     |
| Goodwill and intangible assets | $  3,147 | $  3,054 |
| GILTI deferred taxes           | 1,200    | 2,195    |
| Leases and right-of-use assets | 1,483    | 1,369    |
| Depreciation                   | 438      | 523      |
| Retirement benefits            | 1,478    | 1,443    |
| Undistributed foreign earnings | 211      | 192      |
| Hedging  (2)                   | 448      | 30       |
| Other  (2)                     | 746      | 786      |
| Gross deferred tax liabilities | $  9,151 | $  9,593 |

(1) Includes domestic tax loss/credit carryforwards and foreign tax loss/credit carryforwards.

(2) Prior-year amounts have been reclassified to conform to the change in 2024 presentation.

For financial reporting purposes, as of December 31, 2024, the company had loss carryforwards, the tax effect of which was $1,774 million, as well as credit carryforwards of $1,681 million. Substantially all of these carryforwards are available for at least two years and the majority are available for 10 years or more.

The valuation allowances as of December 31, 2024, 2023 and 2022 were $1,223 million, $765 million and $770 million, respectively. The amounts principally apply to certain loss carryforwards and credits. In the opinion of management, it is more likely than not that these assets will not be realized. However, to the extent that tax benefits related to these carryforwards and credits are realized in the future, the reduction in the valuation allowance will reduce income tax expense.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The amount of unrecognized tax benefits at December 31, 2024 increased by $103 million in 2024 to $8,875 million. A reconciliation of the beginning and ending amount of unrecognized tax benefits was as follows:


|                                                              | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|--------------------------------------------------------------|-------------------|-------------------|-------------------|
|                                                              | 2024              | 2023              | 2022              |
| Balance at January 1                                         | $  8,772          | $  8,728          | $  8,709          |
| Additions based on tax positions related to the current year | 667               | 296               | 355               |
| Additions for tax positions of prior years                   | 452               | 231               | 174               |
| Reductions for tax positions of prior years                  | (955)             | (457)             | (470)             |
| Settlements                                                  | (61)              | (26)              | (41)              |
| Balance at December 31                                       | $  8,875          | $  8,772          | $  8,728          |

The additions to unrecognized tax benefits related to the current and prior years were primarily attributable to U.S. federal, state, and non-U.S. tax matters, including transfer pricing. The settlements and reductions to unrecognized tax benefits for tax positions of prior years were primarily attributable to U.S federal, state, and non-U.S. tax matters, including impacts due to lapse of statute of limitations and foreign currency translation adjustments.

The unrecognized tax benefits at December 31, 2024 of $8,875 million can be reduced by $617 million associated with timing adjustments, potential transfer pricing adjustments and state income taxes. The net amount of $8,258 million, if recognized, would favorably affect the company's effective tax rate. The net amounts at December 31, 2023 and 2022 were $8,205 million and $8,191 million, respectively.

Interest and penalties related to income tax liabilities are included in income tax expense. During the years ended December 31, 2024, 2023 and 2022, the company recognized $282 million, $379 million and $185 million, respectively, in interest expense and penalties. The company had $1,560 million and $1,321 million for the payment of interest and penalties accrued at December 31, 2024 and December 31, 2023, respectively.

Within the next 12 months, the company believes it is reasonably possible that the total amount of unrecognized tax benefits associated with certain positions may be reduced. The potential decrease in the amount of unrecognized tax benefits is associated with certain non-U.S. positions that are expected to be recognized due to a lapse in statute of limitations, as well as anticipated resolution of various audits. The company estimates that the unrecognized tax benefits at December 31, 2024 could be reduced by $139 million.

During the fourth quarter of 2020, the U.S. Internal Revenue Service (IRS) concluded its examination of the company's U.S. income tax returns for 2013 and 2014 and issued a final Revenue Agent's Report (RAR) proposing adjustments related to certain crossborder transactions that occurred in 2013. The company filed its IRS Appeals protest in the first quarter of 2021, and in October of 2023, the IRS issued a revised RAR. These adjustments, if sustained, would increase the company's income subject to tax by approximately $4.2 billion, with tax calculated at the relevant federal income tax rate. The company continues to strongly disagree with the IRS position and will pursue resolution at IRS Appeals and then court, if necessary. In the first quarter of 2024, the IRS concluded its examination of the company's U.S. income tax returns for 2015 and 2016 and issued a final RAR proposing adjustments related to certain cross-border transactions that occurred in 2015. The proposed adjustments, if sustained, would increase the company's income subject to tax by approximately $1.2 billion, with tax calculated at the relevant federal income tax rate. The company strongly disagrees with the IRS position and filed its IRS Appeals protest in the second quarter of 2024. In the fourth quarter of 2021, the IRS commenced its audit of the company's U.S. tax returns for 2017 and 2018. The company anticipates that this audit will be completed in 2025. With respect to major U.S. state and foreign taxing jurisdictions, the company is generally no longer subject to tax examinations for years prior to 2016. The company is no longer subject to income tax examination of its U.S. federal tax return for years prior to 2013. The open years contain matters that could be subject to differing interpretations of applicable tax laws and regulations as it relates to the amount and/or timing of income, deductions, and tax credits. Although the outcome of tax audits is always uncertain, the company believes that adequate amounts of tax, interest and penalties have been provided for any adjustments that are expected to result for these years.

The company is involved in a number of income tax-related matters in India challenging tax assessments issued by the India Tax Authorities. As of December 31, 2024, the company had recorded approximately $400 million as prepaid income taxes in India. A significant portion of this balance represents cash tax deposits paid over time to protect the company's right to appeal various income tax assessments made by the India Tax Authorities. Although the outcome of tax audits is always uncertain, the company believes that adequate amounts of tax, interest and penalties have been provided for any adjustments that are expected to result for these years.

Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

Within consolidated retained earnings at December 31, 2024 were undistributed after-tax earnings from certain non-U.S. subsidiaries that were not indefinitely reinvested. At December 31, 2024, the company had a deferred tax liability of $211 million for the estimated taxes associated with the repatriation of these earnings. Undistributed earnings of approximately $1.3 billion and other outside basis differences in foreign subsidiaries were indefinitely reinvested in foreign operations. Quantification of the deferred tax liability, if any, associated with indefinitely reinvested earnings and outside basis differences was not practicable.

## NOTE H. EARNINGS PER SHARE

The following table presents the computation of basic and diluted earnings per share of common stock.


| ($ in millions except per share amounts) For the year ended December 31:                                   | 2024  (1)   | 2023        | 2022  (1)   |
|------------------------------------------------------------------------------------------------------------|-------------|-------------|-------------|
| Weighted-average number of shares on which earnings per share  calculations are based                      |             |             |             |
| Basic                                                                                                      | 921,767,834 | 911,210,319 | 902,664,190 |
| Add-incremental shares under stock-based compensation plans                                                | 13,012,755  | 8,700,951   | 7,593,455   |
| Add-incremental shares associated with contingently issuable shares                                        | 2,380,636   | 2,162,558   | 2,011,417   |
| Assuming dilution                                                                                          | 937,161,224 | 922,073,828 | 912,269,062 |
| Income from continuing operations                                                                          | $  6,015    | $  7,514    | $  1,783    |
| Income/(loss) from discontinued operations, net of tax  (2)                                                | 8           | (12)        | (143)       |
| Net income on which basic earnings per share is calculated                                                 | $  6,023    | $  7,502    | $  1,639    |
| Income from continuing operations                                                                          | $  6,015    | $  7,514    | $  1,783    |
| Net income applicable to contingently issuable shares                                                      | -           | -           | -           |
| Income from continuing operations on which diluted earnings per  share is calculated                       | $  6,015    | $  7,514    | $  1,783    |
| Income/(loss) from discontinued operations, net of tax, on which  diluted earnings per share is calculated | 8           | (12)        | (143)       |
| Net income on which diluted earnings per share is calculated                                               | $  6,023    | $  7,502    | $  1,639    |
| Earnings/(loss) per share of common stock                                                                  |             |             |             |
| Assuming dilution                                                                                          |             |             |             |
| Continuing operations                                                                                      | $  6.42     | $  8.15     | $  1.95     |
| Discontinued operations                                                                                    | 0.01        | (0.01)      | (0.16)      |
| Total                                                                                                      | $  6.43     | $  8.14     | $  1.80     |
| Basic                                                                                                      |             |             |             |
| Continuing operations                                                                                      | $  6.53     | $  8.25     | $  1.97     |
| Discontinued operations                                                                                    | 0.01        | (0.01)      | (0.16)      |
| Total                                                                                                      | $  6.53     | $  8.23     | $  1.82     |

(1) 2024 and 2022 include the impacts of pension settlement charges. Refer to note U, "Retirement-Related Benefits," for additional information.

(2) Primarily relates to discontinued operations of Kyndryl, separated in 2021.

Weighted-average stock options to purchase 764,673 common shares in 2024, 1,761,463 common shares in 2023 and 814,976 common shares in 2022 were outstanding, but were not included in the computation of diluted earnings per share because the exercise price of the options was greater than the average market price of the common shares for the full year, and therefore, the effect would have been antidilutive.

## HobnooebinobAiiaMoobhbion

Diobmiofjiwpnfibnn( aefibnxjmkjmofjiiNp nffmtxjhkifbn

## I* O $ ? A$ IIx$ ' NN ON; ' $ $ ' $ O$ N

## AmPpb' bnpmbhbion

## Aiiannboni' obn( bnpmboAm1 pbiMbapmmidnn

Oebcjjrfido bkmbnbionoebajhkit-ncfiiafnnbonicfiiaff ffofbnoeombhbnpmbocfmqpbjimbapmmfid nfnoybabh bm'9 W&8 6 8 : i8 6 8 9 8


| .U fihffjinO                           | AmPpb      | 5 S5 7      | 5 S5 7     | 5 S5 V      | 5 S5 V     |
|----------------------------------------|------------|-------------|------------|-------------|------------|
| voybabh bmVT4                          | CbmmaetFbb | vnnbon 7YE  | F obn 7: E | vnnbon 7YE  | F obn 7: E |
| xneblpfqbion .WO                       |            |             |            |             |            |
| Ofhbbkjnfoniabmofcfaobnjcbkjnfo .8 O   | 8          | U  < &< < 9 | I:v        | U  = &8 6 < | I:v        |
| ( jibthmbocpin                         | W          | 8 1:        | I:v        | : 2:        | I:v        |
| Ojoaneblpfqbion                        |            | U  < &2: 1  | I:v        | U  = &< 22  | I:v        |
| zlpfotfiqbnohbion                      | W          | 7           | I:v        | 8 0         | I:v        |
| yb onbapmfofbn6apmmbio .8 O .9 O       | 8          | < : :       | I:v        | 9 = 9       | I:v        |
| yb onbapmfofbn6ijiapmmbio .8 O .: O    | 8 &9       | W8 :        | I:v        | 1           | I:v        |
| ybmfqofqbnbnfdiobnebdfidfinomphbion    |            |             |            |             |            |
| Diobmbnomobajiomaon                    | 8          | 7           | 9 < 8      | 8           | 8 22       |
| Ajmbfdibsaeidbajiomaon                 | 8          | < : 0       | 8 2:       | W9 W        | 8 = 0      |
| ybmfqofqbnijobnfdiobnebdfidfinomphbion |            |             |            |             |            |
| Ajmbfdibsaeidbajiomaon .0O             | 8          | 8 8         | : 9        | WW0         | W2         |
| zlpfotajiomaon                         | 8          | :           | 8 =        | 29          | 7          |
| No                                     |            | U  1&9 1<   | U  = 8 <   | U  1&: : <  | U  029     |

.WO DiapbrfoefianeianeblpfqbionfioebxjinjfobwiabNebbo8

.8 O vqf b5cjm5nbb onbapmfofbnrfoeammtfidqpbnoeokkmjsfhobcfmqpb8

.9 O ObmhbkjnfoniP8N8ombnpmt fnoeombmbkjmobrfoefihmbo bnbapmfofbnfioebxjinjfobwiabNebbo8

.: O 8 6 8 : nnbonfiapbU W6 8 hffjinbbmcfiiafidjifiajiibaofjirfoeoebfqbnofopmbjcOebRboebmxjhkitnnbonmbkjmobrfo efifiqbno hbioninpimtnnbonfioebxjinjfobwiabNebbo8Mbcbmojijobz&-valpfnfofjin3yfqbnofopmbn&M cjmfofjificjmhofji8

.0O 8 6 8 9 nnbonfiapbU < 8 'hffjimbobojcjmbfdibsaeidbajkofjiajiomaonbiobmbfiojfiajiibaofjirfoeoebalpfnfofjijcNombhNboni rb ( boejncmjhNjcormbvB8Oebmbrbmbijnnjafobbmfqofqbnjponoifidoybabh bm'9 W&8 6 8 : 8Mbcbmojijobz&-valpfnfofjin3 yfqbnofopmbn&M iijobN&-ybmfqofqbAfiiafDinomphbion&M cjmfofjificjmhofji8

.< O Oebdmjnn iabnjcbmfqofqbnnbonajiofibrfoefikmbkfbskbinbnijoebmapmmbionnbon&ifiqbnohbioninpimtnnbonfioeb xjinjfobwiabNebbooybabh bm'9 W&8 6 8 : rbmbU 0= 0hffjiiU 2< hffji&mbnkbaofqbt&ioybabh bm'9 W&8 6 8 9 rbmbU 9 6 : hffjii U 9 = hffji&mbnkbaofqbt8

.= O Oebdmjnn iabnjcbmfqofqbf ffofbnajiofibrfoefijoebmaampbbskbinbnif ffofbn&ijoebmf ffofbnfioebxjinjfobwiab Nebbooybabh bm'9 W&8 6 8 : rbmbU 8 < 8 hffjiiU : < 9 hffji&mbnkbaofqbt&ioybabh bm'9 W&8 6 8 9 rbmbU 8 2: hffjiiU 8 22hffji& mbnkbaofqbt8

I:v6Ijokkfa b

## Aiiannboni' obnIo( bnpmboAm1 pb

## Memo= NbmhLbab bni* t bn

Nejmo5obmh mbabfq bn .bsapfid oeb apmmbio kjmofji jc jid5obmh mbabfq bnO i joebm fiqbnohbion mb cfiiaf nnbon rfoe ammtfidqpbnoeokkmjsfhobcfmqpb8vaajpionkt b&joebmaampbbskbinbninejmo5obmhb o.bsapfidoebapmmbio kjmofjijcjid5obmhb oO mbcfiiaff ffofbnrfoeammtfidqpbnoeokkmjsfhobcfmqpb8Dchbnpmbocfmqpbfioeb cfiiafnoobhbion&oebnbcfiiaffinomphbionrjp bannfcfbnGbqb9 fioebcfmqpbefbmmaet&bsabkocjmnejmo5obmh b orefaerjp bannfcfbnGbqb8 8

## FiniFid= NbmhLbab bn

Afmqpbnmb nbjifnajpiobcpopmbanecjrnpnfidapmmbiofiobmbnomobnjccbmbcjmnfhfmjinojafbionrfoenfhfm ambfomofidncjmoebnhbmbhfifidhopmfofbn8voybabh bm9 W&8 6 8 : i8 6 8 9 &oebfccbmbiab borbbioebammtfidhjpioi bnofhobcfmqpbcjmjinijid5obmhmbabfq bnrnfhhobmf8Dchbnpmbocfmqpbfioebcfiiafnoobhbion&oebnb cfiiaffinomphbionrjp bannfcfbnGbqb9 fioebcfmqpbefbmmaet8

## Fid= Nbmhyb o

Afmqpbjckp fatombjid5obmhb ofn nbjilpjobhmbokmfabncjmoebfbiofaf ffotrebiombninnbofii aofqb hmbo8 Ajm joebm jid5obmh b o .fiapfid jid5obmh cfiiab bnb f ffofbnO cjm refae lpjob hmbo kmfab fn ijo qf b&ibskbaobkmbnbioqpbobaeiflpboeopnbnmobnapmmbiotqf bojoebajhkitcjmb orfoenfhfmobmhni mbhfifid hopmfofbn fn pnb oj bnofhob cfm qpb8 Oeb ammtfid hjpio jc jid5obmh b o rn U : 2&11: hffji i U 06 &W8 W

## 84 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

million, and the estimated fair value was $47,389 million and $48,284 million at December 31, 2024 and 2023, respectively. If measured at fair value in the financial statements, long-term debt (including the current portion) would be classified as Level 2 in the fair value hierarchy.

## NOTE J. INVENTORY


|                                   | ($ in millions)   | ($ in millions)   |
|-----------------------------------|-------------------|-------------------|
| At December 31:                   | 2024              | 2023              |
| Finished goods                    | $  134            | $  78             |
| Work in process and raw materials | 1,155             | 1,083             |
| Total                             | $  1,289          | $  1,161          |

## NOTE K. FINANCING RECEIVABLES

Financing receivables primarily consist of client loan and installment payment receivables (loans), investment in sales-type and direct financing leases (collectively referred to as client financing receivables) and commercial financing receivables. Loans are provided primarily to clients to finance the purchase of IBM hardware, software and services. Payment terms on these financing arrangements are for terms generally up to seven years. Investment in sales-type and direct financing leases relate principally to the company's Infrastructure products and are for terms generally up to five years. Commercial financing receivables, which consist of both held-for-investment and held-for-sale receivables, relate primarily to working capital financing for business partners and distributors of IBM products and services. Payment terms for working capital financing generally range from 30 to 60 days.

A summary of the components of the company's financing receivables is presented as follows:


| ($ in millions)                                  | Client Financing Receivables        | Client Financing Receivables   |                      |                      |           |
|--------------------------------------------------|-------------------------------------|--------------------------------|----------------------|----------------------|-----------|
|                                                  |                                     |                                | Commercial Financing | Commercial Financing |           |
|                                                  | Client Loan and Installment Payment | Investment in Sales-Type and   | Receivables          | Receivables          |           |
|                                                  | Receivables                         | Direct Financing               | Held for             | Held for             |           |
| At December 31, 2024:                            | (Loans)                             | Leases                         | Investment           | Sale  (1)            | Total     |
| Financing receivables, gross                     | $  7,425                            | $  3,406                       | $  1,322             | $  900               | $  13,052 |
| Unearned income                                  | (547)                               | (344)                          | -                    | -                    | (891)     |
| Unguaranteed residual value                      | -                                   | 479                            | -                    | -                    | 479       |
| Amortized cost                                   | $  6,878                            | $  3,540                       | $  1,322             | $  900               | $  12,639 |
| Allowance for credit losses                      | (73)                                | (50)                           | (5)                  | -                    | (128)     |
| Total financing receivables, net Current portion | $  6,804  $                         | $  3,491                       | $  1,317             | $  900               | $  12,512 |
|                                                  | 3,535                               | $  1,408                       | $  1,317             | $  900               | $  7,159  |
| Noncurrent portion                               | $  3,269                            | $  2,083                       | $  -                 | $  -                 | $  5,353  |

($ in millions)


|                                  | Client Financing Receivables   | Client Financing Receivables   |                                   |                                   |           |
|----------------------------------|--------------------------------|--------------------------------|-----------------------------------|-----------------------------------|-----------|
|                                  | Client Loan and                | Investment in                  | Commercial Financing  Receivables | Commercial Financing  Receivables |           |
|                                  | Installment Payment            | Sales-Type and                 |                                   |                                   |           |
| At December 31, 2023:            | Receivables (Loans)            | Direct Financing Leases        | Held for Investment               | Held for Sale  (1)                | Total     |
| Financing receivables, gross     | $  7,060                       | $  4,261                       | $  1,160                          | $  692                            | $  13,173 |
| Unearned income                  | (486)                          | (429)                          | -                                 | -                                 | (915)     |
| Unguaranteed residual value      | -                              | 458                            | -                                 | -                                 | 458       |
| Amortized cost                   | $  6,574                       | $  4,290                       | $  1,160                          | $  692                            | $  12,716 |
| Allowance for credit losses      | (87)                           | (63)                           | (6)                               | -                                 | (156)     |
| Total financing receivables, net | $  6,486                       | $  4,227                       | $  1,155                          | $  692                            | $  12,560 |
| Current portion                  | $  3,427                       | $  1,520                       | $  1,155                          | $  692                            | $  6,793  |
| Noncurrent portion               | $  3,059                       | $  2,707                       | $  -                              | $  -                              | $  5,766  |

(1) The carrying value of the receivables classified as held for sale approximates fair value.

The company has a long-standing practice of taking mitigation actions, in certain circumstances, to transfer credit risk to third parties. These actions may include credit insurance, financial guarantees, nonrecourse secured borrowings, true sales or sales of

## ( otes to the Consolidated ! inancial Statements

$ ( .

E . K E

! U 8 7 9 U 8 9 8 W 9 7 G 8 6 8 : 8 6 8 9 G E / * G L E M

## - rar o aal

% 7 G 8 6 8 ; G 8 < B B U 7 E 9 $ ( B E $ G B G G E / W 9 7 G 8 6 8 : 8 6 8 9 E

/ E


|                                 | N U O        | N U O        |
|---------------------------------|--------------|--------------|
| ! or the ear ended ecemer 6 4 A | 5 3 5 7      | 5 3 5 6      |
| Commercial financing receivales |              |              |
| -                               | U  = G > < 6 | U  ? G 8 : > |
| -  N 7 O                        | U  7 G 7 ; 6 | U  7 G < 6 6 |

N 7 O * . G W 9 7 G 8 6 8 : 8 6 8 9 E

/ E / E ! W 9 7 G 8 6 8 : 8 6 8 9 G G G U < > U ? > G G N O $ . E ! K G G L . + E M

## a + al ) orolo S

/ W 9 7 G 8 6 8 : 8 6 8 9 G F G P ( P N ( O + E / K E


| At ecemer 6 4 B 5 3 5 7 A               | Americas     | Asia Pacific   | . otal         |
|-----------------------------------------|--------------|----------------|----------------|
| Amortied cost                           | U  ; G > < 7 | U  7 G : 8 ?   | U  7 6 G : 7 > |
| Alloance for credit losses              |              |                |                |
| Beginning alance at % anuar 4 B 5 3 5 7 | U  ? 8       | U  7 7         | U  7 ; 6       |
| 2 B                                     | N 8 O        | 6              | N 9 O          |
| -                                       | 7            | 6              | 7              |
| P N O                                   | N 7 6 O      | N 8 O          | N 7 8 O        |
| *  N 7 O                                | N 7 7 O      | 6              | N 7 : O        |
| nding alance at ecemer 6 4 B 5 3 5 7    | U  < ?       | U  ?           | U  7 8 9       |


| At ecemer 6 4 B 5                       |    |          |        |         |              |              |                              | . otal                       |
|-----------------------------------------|----|----------|--------|---------|--------------|--------------|------------------------------|------------------------------|
| 3 5 6 A                                 |    | Americas | M A    |         | Asia Pacific | Asia Pacific | U  7 G 9 < >  U  7 6 G > < 9 | U  7 G 9 < >  U  7 6 G > < 9 |
| Alloance for credit losses              |    |          |        |         |              |              |                              |                              |
| Beginning alance at % anuar 4 B 5 3 5 6 | U  | > >      | U  < 6 | U       |              | 8            | 6                            | U  7 < >                     |
| 2 B                                     |    | N ? O    |        | N 7 O   | N > O        |              |                              | N 7 > O                      |
| -                                       |    | 6        | 8      |         |              | 9            | N : O                        | ;                            |
| P N O  *  N 7 O                         |    | ;  =     | 7      | N 7 : O |              | N 7 O        |                              | N 7 8 O  >                   |
| nding alance at ecemer 6 4 B 5 3 5 6    | U  | ? 8      | U      | : >  U  |              | 7 7          | U                            | 7 ; 6                        |

N 7 O + E

Notes to the Consolidated Financial Statements International Business Machines Corporation and Subsidiary Companies

When determining the allowances, financing receivables are evaluated either on an individual or a collective basis. For the company's policy on determining allowances for credit losses, refer to note A, "Significant Accounting Policies."

## Past Due Financing Receivables

The company summarizes information about the amortized cost basis for client financing receivables, including amortized cost aged over 90 days and still accruing, billed invoices aged over 90 days and still accruing, and amortized cost not accruing.


| At December 31, 2024:              | Total  Amortized  Cost   | Amortized  Cost  > 90 Days  (1)   | Amortized  Cost  > 90 Days and  Accruing  (1)   | Billed  Invoices  > 90 Days and  Accruing   | Amortized  Cost  Not  Accruing  (2)   |
|------------------------------------|--------------------------|-----------------------------------|-------------------------------------------------|---------------------------------------------|---------------------------------------|
| Americas                           | $  5,861                 | $  66                             | $  7                                            | $  1                                        | $  62                                 |
| EMEA                               | 3,128                    | 29                                | 1                                               | 0                                           | 28                                    |
| Asia Pacific                       | 1,429                    | 8                                 | 0                                               | 0                                           | 7                                     |
| Total client financing receivables | $  10,418                | $  103                            | $  8                                            | $  1                                        | $  97                                 |

($ in millions)


| At December 31, 2023:              | Total  Amortized  Cost   | Amortized  Cost  > 90 Days  (1)   | Amortized  Cost  > 90 Days and  Accruing  (1)   | Billed  Invoices  > 90 Days and  Accruing   | Amortized  Cost  Not  Accruing  (2)   |
|------------------------------------|--------------------------|-----------------------------------|-------------------------------------------------|---------------------------------------------|---------------------------------------|
| Americas                           | $  6,488                 | $  111                            | $  40                                           | $  6                                        | $  71                                 |
| EMEA                               | 3,007                    | 31                                | 1                                               | 1                                           | 31                                    |
| Asia Pacific                       | 1,368                    | 9                                 | 1                                               | 0                                           | 8                                     |
| Total client financing receivables | $  10,863                | $  151                            | $  43                                           | $  7                                        | $  110                                |

(1) At a contract level, which includes total billed and unbilled amounts for financing receivables aged greater than 90 days.

(2) Of the amortized cost not accruing, there was a related allowance of $94 million and $106 million at December 31, 2024 and 2023, respectively. Financing income recognized on these receivables was immaterial for the years ended December 31, 2024 and 2023.

## Credit Quality Indicators

The company's credit quality indicators, which are based on rating agency data, publicly available information and information provided by customers, are reviewed periodically based on the relative level of risk. The resulting indicators are a numerical rating system that maps to Moody's Investors Service credit ratings as shown below. The company uses information provided by Moody's, where available, as one of many inputs in its determination of customer credit ratings. The credit quality of the customer is evaluated based on these indicators and is assigned the same risk rating whether the receivable is a lease or a loan.

The following tables present the amortized cost basis for client financing receivables by credit quality indicator at December 31, 2024 and 2023, respectively. Receivables with a credit quality indicator ranging from Aaa to Baa3 are considered investment grade. All others are considered non-investment grade. The credit quality indicators reflect mitigating credit enhancement actions taken by customers which reduce the risk to IBM. Gross write-offs by vintage year at December 31, 2024 were not material.


| ($ in millions)       | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|-----------------------|-------------------|-------------------|-------------------|-------------------|-------------------|-------------------|
|                       | Americas          | Americas          | EMEA              | EMEA              | Asia Pacific      | Asia Pacific      |
| At December 31, 2024: | Aaa - Baa3        | Ba1 - C           | Aaa - Baa3        | Ba1 - C           | Aaa - Baa3        | Ba1 - C           |
| Vintage year          |                   |                   |                   |                   |                   |                   |
| 2024                  | $  2,080          | $  621            | $  1,145          | $  514            | $  616            | $  77             |
| 2023                  | 1,372             | 310               | 341               | 258               | 285               | 19                |
| 2022                  | 950               | 113               | 408               | 194               | 254               | 26                |
| 2021                  | 233               | 24                | 125               | 27                | 69                | 5                 |
| 2020                  | 43                | 17                | 29                | 15                | 36                | 8                 |
| 2019 and prior        | 53                | 44                | 37                | 35                | 26                | 7                 |
| Total                 | $  4,732          | $  1,129          | $  2,085          | $  1,043          | $  1,287          | $  142            |

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies


| ($ in millions)       | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|-----------------------|-------------------|-------------------|-------------------|-------------------|-------------------|-------------------|
|                       | Americas          | Americas          | EMEA              | EMEA              | Asia Pacific      | Asia Pacific      |
| At December 31, 2023: | Aaa - Baa3        | Ba1 - C           | Aaa - Baa3        | Ba1 - C           | Aaa - Baa3        | Ba1 - C           |
| Vintage year          |                   |                   |                   |                   |                   |                   |
| 2023                  | $  2,292          | $  1,028          | $  750            | $  520            | $  501            | $  70             |
| 2022                  | 1,645             | 268               | 687               | 374               | 386               | 42                |
| 2021                  | 655               | 85                | 284               | 83                | 110               | 40                |
| 2020                  | 205               | 79                | 106               | 60                | 97                | 22                |
| 2019                  | 104               | 23                | 58                | 38                | 40                | 8                 |
| 2018 and prior        | 55                | 50                | 16                | 30                | 39                | 12                |
| Total                 | $  4,955          | $  1,533          | $  1,901          | $  1,106          | $  1,174          | $  195            |

## Modifications

The company did not have any significant modifications due to clients experiencing financial difficulty for the years ended December 31, 2024 and 2023.

## NOTE L. PROPERTY, PLANT & EQUIPMENT


| At December 31:                                     | 2024     | 2023     |
|-----------------------------------------------------|----------|----------|
| Land and land improvements                          | $  179   | $  182   |
| Buildings and building and leasehold improvements   | 4,825    | 5,333    |
| Information technology equipment                    | 8,895    | 9,223    |
| Production, engineering, office and other equipment | 3,792    | 3,385    |
| Total-gross                                         | 17,691   | 18,122   |
| Less: Accumulated depreciation                      | 11,959   | 12,621   |
| Total-net                                           | $  5,731 | $  5,501 |

## NOTE M. LEASES

## Accounting for Leases as a Lessee

The following table presents the various components of lease costs.


| ($ in millions)                 |          |          |          |
|---------------------------------|----------|----------|----------|
| For the year ended December 31: | 2024     | 2023     | 2022     |
| Finance lease cost              | $  229   | $  114   | $  67    |
| Operating lease cost            | 1,018    | 1,013    | 1,050    |
| Short-term lease cost           | 9        | 9        | 7        |
| Variable lease cost             | 321      | 331      | 262      |
| Sublease income                 | (39)     | (61)     | (72)     |
| Total lease cost                | $  1,537 | $  1,406 | $  1,315 |

The company recorded net gains on sale and leaseback transactions of $17 million, $145 million and $41 million for the years ended December 31, 2024, 2023 and 2022, respectively.

## 88 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The following table presents supplemental information relating to the cash flows arising from lease transactions. Cash payments related to variable lease costs and short-term leases are not included in the measurement of operating and finance lease liabilities, and, as such, are excluded from the amounts below.


| ($ in millions)                                                        |       |       |       |
|------------------------------------------------------------------------|-------|-------|-------|
| For the year ended December 31:                                        | 2024  | 2023  | 2022  |
| Cash paid for amounts included in the measurement of lease liabilities |       |       |       |
| Operating cash outflows from finance leases                            | $  43 | $  16 | $  9  |
| Financing cash outflows from finance leases                            | 189   | 75    | 55    |
| Operating cash outflows from operating leases                          | 961   | 961   | 1,020 |
| ROU assets obtained in exchange for new finance lease liabilities      | 698   | 355   | 196   |
| ROU assets obtained in exchange for new operating lease liabilities    | 988   | 1,220 | 705   |

The following table presents the weighted-average lease term and discount rate for finance and operating leases.


| At December 31:                                  | 2024   | 2023   |
|--------------------------------------------------|--------|--------|
| Finance leases                                   |        |        |
| Weighted-average remaining lease term (in years) | 6.0    | 5.1    |
| Weighted-average discount rate                   | 5.03 % | 4.62 % |
| Operating leases                                 |        |        |
| Weighted-average remaining lease term (in years) | 6.4    | 6.2    |
| Weighted-average discount rate                   | 4.91 % | 4.46 % |

The following table presents a maturity analysis of expected undiscounted cash flows for operating and finance leases on an annual basis for the next five years and thereafter.


|                  | ($ in millions) 2025   | 2026   | 2027   | 2028   | 2029   | Thereafter   | Imputed  Interest  (1)   | Total  (2)   |
|------------------|------------------------|--------|--------|--------|--------|--------------|--------------------------|--------------|
| Finance leases   | $  246                 | $  210 | $  194 | $  168 | $  155 | $  202       | $  (174)                 | $  1,000     |
| Operating leases | 906                    | 787    | 630    | 447    | 318    | 938          | (603)                    | 3,422        |

(1) Imputed interest represents the difference between undiscounted cash flows and discounted cash flows.

(2) The company entered into lease agreements, primarily related to operating leases, for certain facilities and equipment with payments totaling approximately $496 million that have not yet commenced as of December 31, 2024, and therefore are not included in this table.

The following table presents information on the company's finance leases recognized in the Consolidated Balance Sheet.


| ($ in millions)                          |        |        |
|------------------------------------------|--------|--------|
| At December 31:                          | 2024   | 2023   |
| ROU assets-Property, plant and equipment | $  984 | $  481 |
| Lease liabilities                        |        |        |
| Short-term debt                          | 198    | 121    |
| Long-term debt                           | 803    | 379    |

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Accounting for Leases as a Lessor

The following table presents amounts included in the Consolidated Income Statement related to lessor activity.


|                                                     | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|-----------------------------------------------------|-------------------|-------------------|-------------------|
| For the year ended December 31:                     | 2024              | 2023              | 2022              |
| Lease income-sales-type and direct financing leases |                   |                   |                   |
| Sales-type lease selling price                      | $  865            | $  1,280          | $  1,636          |
| Less: Carrying value of underlying assets  (1)      | (176)             | (245)             | (385)             |
| Gross profit                                        | 689               | 1,034             | 1,251             |
| Interest income on lease receivables                | 268               | 242               | 200               |
| Total sales-type and direct financing lease income  | 958               | 1,276             | 1,451             |
| Lease income-operating leases                       | 60                | 93                | 116               |
| Variable lease income                               | 68                | 68                | 87                |
| Total lease income                                  | $  1,085          | $  1,437          | $  1,653          |

(1) Excludes unguaranteed residual value.

## Sales-Type and Direct Financing Leases

At December 31, 2024 and 2023, the unguaranteed residual values of sales-type and direct financing leases were $479 million and $458 million, respectively. Refer to note K, "Financing Receivables," for additional information on the company's net investment in leases.

For the years ended December 31, 2024 and 2023, impairment of residual values was immaterial.

The following table presents a maturity analysis of the lease payments due to IBM on sales-type and direct financing leases over the next five years and thereafter, as well as a reconciliation of the undiscounted cash flows to the financing receivables recognized in the Consolidated Balance Sheet at December 31, 2024.


| ($ in millions)                                                            |          |
|----------------------------------------------------------------------------|----------|
| 2025                                                                       | $  1,552 |
| 2026                                                                       | 963      |
| 2027                                                                       | 584      |
| 2028                                                                       | 244      |
| 2029                                                                       | 60       |
| Thereafter                                                                 | 3        |
| Total undiscounted cash flows                                              | $  3,406 |
| Present value of lease payments (recognized as financing receivables)  (1) | 3,062    |
| Difference between undiscounted cash flows and discounted cash flows       | $  344   |

(1) The present value of the lease payments will not equal the financing receivables balances in the Consolidated Balance Sheet due to certain items, including IDCs, allowance for credit losses and residual values, which are included in the financing receivable balance, but are not included in the future lease payments.

Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## NOTE N. INTANGIBLE ASSETS INCLUDING GOODWILL

## Intangible Assets

The following table presents the company's intangible asset balances by major asset class.


|                        | ($ in millions)        | ($ in millions)           | ($ in millions)           |
|------------------------|------------------------|---------------------------|---------------------------|
| At December 31, 2024:  | Gross Carrying  Amount | Accumulated  Amortization | Net Carrying  Amount  (1) |
| Intangible asset class |                        |                           |                           |
| Capitalized software   | $  1,282               | $  (492)                  | $  790                    |
| Client relationships   | 9,704                  | (4,387)                   | 5,317                     |
| Completed technology   | 6,297                  | (3,164)                   | 3,132                     |
| Patents/trademarks     | 1,826                  | (519)                     | 1,307                     |
| Other  (2)             | 138                    | (24)                      | 114                       |
| Total                  | $  19,247              | $  (8,587)                | $  10,660                 |

($ in millions)


| At December 31, 2023:   | Gross Carrying  Amount   | Accumulated  Amortization   | Net Carrying  Amount  (1)   |
|-------------------------|--------------------------|-----------------------------|-----------------------------|
| Intangible asset class  |                          |                             |                             |
| Capitalized software    | $  1,636                 | $  (762)                    | $  874                      |
| Client relationships    | 9,053                    | (3,500)                     | 5,553                       |
| Completed technology    | 5,713                    | (2,510)                     | 3,203                       |
| Patents/trademarks      | 1,821                    | (436)                       | 1,385                       |
| Other  (2)              | 41                       | (20)                        | 22                          |
| Total                   | $  18,265                | $  (7,229)                  | $  11,036                   |

(1) Amounts as of December 31, 2024 and December 31, 2023 include a decrease in the net intangible asset balance of $126 million and an increase in the net intangible asset balance of $50 million, respectively, due to foreign currency translation.

(2) Other intangibles are primarily acquired proprietary and nonproprietary technology licenses, data, business processes, methodologies and systems.

There was no impairment of intangible assets recorded in 2024 and 2023. The net carrying amount of intangible assets decreased $376 million during the year ended December 31, 2024, primarily due to intangible asset amortization, partially offset by additions of acquired intangibles from business combinations of $1,627 million, driven by the acquisition of StreamSets and webMethods in the third quarter of 2024, and additions of capitalized software. The aggregate intangible amortization expense was $2,499 million and $2,287 million for the years ended December 31, 2024 and 2023, respectively. In addition, in 2024 and 2023, respectively, the company retired $923 million and $1,505 million of fully amortized intangible assets, impacting both the gross carrying amount and accumulated amortization by this amount.

The future amortization expense relating to intangible assets currently recorded in the Consolidated Balance Sheet is estimated to be the following at December 31, 2024:


| ($ in millions)   | Capitalized  Software   | Acquired  Intangibles   | Total    |
|-------------------|-------------------------|-------------------------|----------|
| 2025              | $  427                  | $  1,939                | $  2,365 |
| 2026              | 260                     | 1,902                   | 2,162    |
| 2027              | 103                     | 1,881                   | 1,984    |
| 2028              | 0                       | 1,582                   | 1,582    |
| 2029              | 0                       | 936                     | 936      |
| Thereafter        | -                       | 1,631                   | 1,631    |

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Goodwill

The changes in the goodwill balances by reportable segment for the years ended December 31, 2024 and 2023 are as follows:

($ in millions)


| Segment        | Balance at  January 1, 2024   | Goodwill  Additions   | Purchase  Price  Adjustments  (1)   | Divestitures   | Foreign  Currency  Translation  and Other  Adjustments  (2)   | Balance at  December 31, 2024   |
|----------------|-------------------------------|-----------------------|-------------------------------------|----------------|---------------------------------------------------------------|---------------------------------|
| Software       | $  46,447                     | $  1,511              | $  (51)                             | $  -           | $  (770)                                                      | $  47,136                       |
| Consulting     | 8,883                         | 469                   | (3)                                 | (1)            | (142)                                                         | 9,206                           |
| Infrastructure | 4,384                         | 8                     | (1)                                 | -              | (28)                                                          | 4,363                           |
| Other  (3)     | 464                           | -                     | -                                   | (464)          | -                                                             | -                               |
| Total          | $  60,178                     | $  1,987              | $  (55)                             | $  (465)       | $  (940)                                                      | $  60,706                       |


| Segment         | Balance at  January 1, 2023   | Goodwill  Additions   | Purchase  Price  Adjustments   | Divestitures   | Foreign  Currency  Translation  and Other  Adjustments  (2)   | Balance at  December 31, 2023   |
|-----------------|-------------------------------|-----------------------|--------------------------------|----------------|---------------------------------------------------------------|---------------------------------|
| Software  (4)   | $  42,712                     | $  3,538              | $  (17)                        | $  -           | $  214                                                        | $  46,447                       |
| Consulting  (4) | 8,409                         | 403                   | 2                              | -              | 69                                                            | 8,883                           |
| Infrastructure  | 4,363                         | 12                    | -                              | -              | 8                                                             | 4,384                           |
| Other  (4)      | 464                           | -                     | -                              | -              | -                                                             | 464                             |
| Total           | $  55,949                     | $  3,953              | $  (15)                        | $  -           | $  291                                                        | $  60,178                       |

(1) Includes measurement period adjustments related to business combinations that closed in the current and prior year.

(2) Primarily driven by foreign currency translation.

(3) In the first quarter of 2024, the company derecognized goodwill related to the divestiture of The Weather Company assets. Refer to note E, "Acquisitions & Divestitures," for additional information.

(4) Recast to reflect January 2024 segment changes. Refer to note D, "Segments," for additional information.

There were no goodwill impairment losses recorded during 2024 or 2023, and the company has no accumulated impairment losses. Purchase price adjustments recorded in 2024 and 2023 were related to acquisitions that were still subject to the measurement period that ends at the earlier of 12 months from the acquisition date or when information becomes available. Net purchase price adjustments recorded in 2024 and 2023 were not material.

## NOTE O. BORROWINGS

## Short-Term Debt

The company's total short-term debt at December 31, 2024 and December 31, 2023 was $5,089 million and $6,426 million, respectively, and primarily consisted of current maturities of long-term debt detailed in "Long-Term Debt" below.

## 92 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Long-Term Debt

## Pre-Swap Borrowing


| ($ in millions) At December 31:                                                      | Maturities   | 2024            | 2023           |
|--------------------------------------------------------------------------------------|--------------|-----------------|----------------|
| U.S. dollar debt (weighted-average interest rate at December 31, 2024):  (1)         |              |                 |                |
| 3.3%                                                                                 | 2024         | $  -            | $  5,003       |
| 5.1%                                                                                 | 2025         | 1,601           | 1,601          |
| 3.7%                                                                                 | 2026         | 5,800           | 5,201          |
| 3.3%                                                                                 | 2027         | 4,119           | 3,619          |
| 5.0%                                                                                 | 2028         | 1,313           | 1,313          |
| 3.6%                                                                                 | 2029         | 3,750           | 3,250          |
| 2.0%                                                                                 | 2030         | 1,350           | 1,350          |
| 4.8%                                                                                 | 2031         | 500             | -              |
| 4.4%                                                                                 |              |                 |                |
| 4.8%                                                                                 | 2032         | 1,850           | 1,850          |
| 4.9%                                                                                 | 2033         | 750             | 750            |
| 8.0%                                                                                 | 2034 2038    | 1,000           | -  83          |
| 4.5%                                                                                 | 2039         | 83              |                |
|                                                                                      |              | 2,745           | 2,745          |
| 2.9%                                                                                 | 2040         | 650             | 650            |
| 4.0%                                                                                 | 2042         | 1,107           | 1,107          |
| 5.3%                                                                                 | 2044         | 1,000           | -              |
| 7.0%                                                                                 | 2045         | 27              | 27             |
| 4.7%                                                                                 | 2046         | 650             | 650            |
| 4.3%                                                                                 | 2049         | 3,000           | 3,000          |
| 3.0%                                                                                 | 2050         | 750             | 750            |
| 4.2%                                                                                 | 2052         | 1,400           | 1,400          |
| 5.1%                                                                                 | 2053         | 650             | 650            |
| 5.3%                                                                                 | 2054         | 1,400           | -              |
| 7.1%                                                                                 | 2096         | 316             | 316            |
|                                                                                      |              | $ 35,813        | $ 35,317       |
| Euro debt (weighted-average interest rate at December 31, 2024):  (1)                |              |                 |                |
| 1.1%                                                                                 | 2024         | -               | 829            |
| 1.6%                                                                                 | 2025         | 3,106           | 3,315          |
| 2.3%                                                                                 | 2027         | 2,071           | 2,210          |
| 0.7%                                                                                 | 2028         | 1,863           | 1,989          |
| 1.5%                                                                                 | 2029         | 1,035           | 1,105          |
| 0.9%                                                                                 | 2030         | 1,035           | 1,105          |
| 2.7%                                                                                 | 2031         | 2,588           | 2,762          |
| 0.7%                                                                                 | 2032         | 1,656           | 1,768          |
| 1.3%                                                                                 | 2034         | 1,035           | 1,105          |
| 3.8%                                                                                 | 2035         | 1,035           | 1,105          |
| 1.2%                                                                                 | 2040         | 880             | 939            |
| 4.0%                                                                                 | 2043         | 1,035           | 1,105          |
|                                                                                      |              | $ 17,340        | $ 19,335       |
| Other currencies (weighted-average interest rate at December 31, 2024):  (1)         |              |                 |                |
| Pound sterling (4.9%)                                                                | 2038         | $  939          | $  955         |
| Japanese yen (0.7%)                                                                  | 2026-2028    | 808             | 1,251          |
| Other (13.8%)                                                                        | 2025-2027    | 212             | 241            |
|                                                                                      |              | $ 55,111        | $ 57,099       |
| Finance lease obligations (5.0% weighted-average interest rate at December 31, 2024) | 2025-2034    | 1,000           | 499            |
| Less: net unamortized discount                                                       |              | $ 56,112  824   | $ 57,598  838  |
| Less: net unamortized debt issuance costs                                            |              | 168             | 154            |
| Add: fair value adjustment  (2)                                                      |              | (176)  $ 54,943 | (60)  $ 56,546 |
| Less: current maturities                                                             |              | 5,059           | 6,425          |
| Total                                                                                |              |                 |                |
|                                                                                      |              | $ 49,884        | $ 50,121       |

(1) Includes notes, debentures, bank loans and secured borrowings.

(2) The portion of the company's fixed-rate debt obligations that is hedged is reflected in the Consolidated Balance Sheet as an amount equal to the sum of the debt's carrying value and a fair value adjustment representing changes in the fair value of the hedged debt obligations attributable to movements in benchmark interest rates.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The company's indenture governing its debt securities and its various credit facilities each contain significant covenants which obligate the company to promptly pay principal and interest, limit the aggregate amount of secured indebtedness and sale and leaseback transactions to 10 percent of the company's consolidated net tangible assets, and restrict the company's ability to merge or consolidate unless certain conditions are met. The credit facilities also include a covenant on the company's consolidated net interest expense ratio, which cannot be less than 2.20 to 1.0, as well as a cross default provision with respect to other defaulted indebtedness of at least $500 million.

The company is in compliance with all of its debt covenants and provides periodic certifications to its lenders. The failure to comply with its debt covenants could constitute an event of default with respect to the debt to which such provisions apply. If certain events of default were to occur, the principal and interest on the debt to which such event of default applied would become immediately due and payable.

In the first quarter of 2023, the company issued $0.7 billion of Japanese yen floating-rate syndicated bank loans with a maturity of 5 years; $4.6 billion of Euro fixed-rate notes in tranches with maturities ranging from 4 to 20 years and coupons ranging from 3.375 to 4 percent; $0.9 billion of Pound sterling fixed-rate notes with a maturity of 15 years and a coupon of 4.875 percent; and $3.25 billion of U.S. dollar fixed-rate notes in tranches with maturities ranging from 3 to 30 years and coupons ranging from 4.5 to 5.1 percent.

In the first quarter of 2024, IBM International Capital Pte. Ltd (IIC), a wholly owned finance subsidiary of the company, issued $5.5 billion of U.S. dollar fixed rate notes (IIC Notes) in tranches with maturities ranging from 2 to 30 years and coupons ranging from 4.6 to 5.3 percent. IIC is a 100 percent owned finance subsidiary of IBM, as described by the SEC in Rule 13-01(a)(4)(vi) of Regulation S-X, the primary purpose of which is to borrow money to be made available for the benefit of IBM and its affiliates. The IIC Notes are fully and unconditionally guaranteed by IBM, and no other subsidiary of IBM guarantees the IIC Notes.

## Post-Swap Borrowing (Long-Term Debt, Including Current Portion)


|                         | ($ in millions)                        | ($ in millions)                        | ($ in millions)   | ($ in millions)   | ($ in millions)                 | ($ in millions)                 |
|-------------------------|----------------------------------------|----------------------------------------|-------------------|-------------------|---------------------------------|---------------------------------|
|                         | 2024                                   | 2024                                   | 2024              |                   | 2023                            | 2023                            |
| At December 31:         | Amount Weighted-Average  Interest Rate | Amount Weighted-Average  Interest Rate | Amount            | Amount            | Weighted-Average  Interest Rate | Weighted-Average  Interest Rate |
| Fixed-rate debt         |                                        | $  47,712                              | 3.3 %             | $  48,803         |                                 | 3.0 %                           |
| Floating-rate debt  (1) |                                        | 7,231                                  | 5.6 % 7,743       |                   |                                 | 6.1 %                           |
| Total                   |                                        | $  54,943                              | $                 | 56,546            |                                 |                                 |

(1) Includes $6,725 million in both 2024 and 2023, of notional interest-rate swaps that effectively convert fixed-rate long-term debt into floating-rate debt. Refer to note S, "Derivative Financial Instruments," for additional information.

Pre-swap annual contractual obligations of long-term debt outstanding at December 31, 2024, are as follows:


|            | ($ in millions)   |
|------------|-------------------|
| 2025       | $  5,047          |
| 2026       | 6,302             |
| 2027       | 6,357             |
| 2028       | 3,863             |
| 2029       | 4,926             |
| Thereafter | 29,616            |
| Total      | $  56,112         |

## 94 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Interest on Debt


| ($ in millions)                 |          |          |          |
|---------------------------------|----------|----------|----------|
| For the year ended December 31: | 2024     | 2023     | 2022     |
| Cost of financing               | $  336   | $  334   | $  346   |
| Interest expense                | 1,712    | 1,607    | 1,216    |
| Interest capitalized            | 12       | 9        | 5        |
| Total interest paid and accrued | $  2,060 | $  1,949 | $  1,566 |

Refer to the related discussion in note D, "Segments," for interest expense of the Financing segment. Refer to note S, "Derivative Financial Instruments," for a discussion of the use of foreign currency denominated debt designated as a hedge of net investment, as well as a discussion of the use of currency and interest-rate swaps in the company's debt risk management program.

## Lines of Credit

On June 17, 2024, the company amended its existing $2.5 billion Three-Year Credit Agreement and $7.5 billion Five-Year Credit Agreement (the Credit Agreements) to extend the maturity dates to June 20, 2027 and June 22, 2029, respectively. The Credit Agreements permit the company and its subsidiary borrowers to borrow up to $10 billion on a revolving basis. The total expense recorded by the company related to these agreements was $8 million, $8 million and $11 million in 2024, 2023 and 2022, respectively. Subject to certain conditions stated in the Credit Agreements, the borrower may borrow, prepay and re-borrow amounts under the Credit Agreements at any time during the term of such agreements. Funds borrowed may be used for the general corporate purposes of the borrower.

Interest rates on borrowings under the Credit Agreements will be based on prevailing market interest rates, as further described in the Credit Agreements. The Credit Agreements contain customary representations and warranties, covenants, events of default, and indemnification provisions. The company believes that circumstances that might give rise to breach of these covenants or an event of default, as specified in the Credit Agreements, are remote. As of December 31, 2024, there were no borrowings by the company under the Credit Agreements.

The company also has other committed lines of credit in some of the geographies which are not significant in the aggregate. Interest rates and other terms of borrowing under these lines of credit vary from country to country, depending on local market conditions. As of December 31, 2024, there were no material borrowings by the company under these credit facilities.

## NOTE P. OTHER LIABILITIES


|                        | ($ in millions)   | ($ in millions)   |
|------------------------|-------------------|-------------------|
| At December 31:        | 2024              | 2023              |
| Income tax reserves    | $  6,865          | $  6,916          |
| Deferred taxes         | 815               | 1,146             |
| Excess Savings Plan    | 1,445             | 1,437             |
| Disability benefits    | 274               | 308               |
| Derivative liabilities | 463               | 299               |
| Workforce reductions   | 445               | 526               |
| Environmental accruals | 204               | 206               |
| Other                  | 536               | 639               |
| Total                  | $  11,048         | $  11,475         |

In response to changing business needs, the company periodically takes workforce reduction actions to improve productivity, cost competitiveness and to rebalance skills. The noncurrent future payments associated with these activities are reflected in the workforce reductions caption in the previous table. The noncurrent liabilities are workforce accruals primarily related to terminated employees who are no longer working for the company and who were granted annual payments to supplement their incomes in certain countries. Depending on the individual country's legal requirements, these required payments will continue until the former employee begins receiving pension benefits or passes away. The total amounts accrued for workforce reductions, including amounts classified as other accrued expenses and liabilities in the Consolidated Balance Sheet, were $665 million and $725 million at December 31, 2024 and 2023, respectively.

The company employs extensive internal environmental protection programs that primarily are preventive in nature. The company also participates in environmental assessments and cleanups at a number of locations, including operating facilities, previously owned facilities and Superfund sites. The company's maximum exposure for all environmental liabilities cannot be estimated and no amounts have been recorded for non-ARO environmental liabilities that are not probable or estimable. The total amounts accrued

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

for non-ARO environmental liabilities, including amounts classified as current in the Consolidated Balance Sheet, that do not reflect actual or anticipated insurance recoveries, were $247 million and $244 million at December 31, 2024 and 2023, respectively. Estimated environmental costs are not expected to materially affect the consolidated financial position or consolidated results of the company's operations in future periods. However, estimates of future costs are subject to change due to protracted cleanup periods, changing environmental remediation regulations and changes in assumptions.

As of December 31, 2024, the company was unable to estimate the range of settlement dates and the related probabilities for certain asbestos remediation AROs. These conditional AROs are primarily related to the encapsulated structural fireproofing that is not subject to abatement unless the buildings are demolished and non-encapsulated asbestos that the company would remediate only if it performed major renovations of certain existing buildings. Because these conditional obligations have indeterminate settlement dates, the company could not develop a reasonable estimate of their fair values. The company will continue to assess its ability to estimate fair values at each future reporting date. The related liability will be recognized once sufficient additional information becomes available. The total amounts accrued for ARO liabilities, including amounts classified as current in the Consolidated Balance Sheet, were $80 million and $113 million at December 31, 2024 and 2023, respectively.

## NOTE Q. COMMITMENTS & CONTINGENCIES

## Commitments

The company's extended lines of credit to third-party entities include unused amounts of $1.6 billion and $1.4 billion at December 31, 2024 and 2023, respectively. A portion of these amounts was available to the company's business partners to support their working capital needs. In addition, the company has committed to provide future financing to its clients in connection with client purchase agreements for $2.2 billion and $1.9 billion at December 31, 2024 and 2023, respectively. The company collectively evaluates the allowance for these arrangements using a provision methodology consistent with the portfolio of the commitments. Refer to note A, "Significant Accounting Policies," for additional information. The allowance for these commitments is recorded in other liabilities in the Consolidated Balance Sheet and was not material at December 31, 2024 and 2023.

The company has applied the guidance requiring a guarantor to disclose certain types of guarantees, even if the likelihood of requiring the guarantor's performance is remote. The following is a description of arrangements in which the company is the guarantor.

The company is a party to a variety of agreements pursuant to which it may be obligated to indemnify the other party with respect to certain matters. Typically, these obligations arise in the context of contracts entered into by the company, under which the company customarily agrees to hold the party harmless against losses arising from a breach of representations and covenants related to such matters as title to the assets sold, certain intellectual property rights, specified environmental matters, third-party performance of nonfinancial contractual obligations and certain income taxes. In each of these circumstances, payment by the company is conditioned on the other party making a claim pursuant to the procedures specified in the particular contract, the procedures of which typically allow the company to challenge the other party's claims. While indemnification provisions typically do not include a contractual maximum on the company's payment, the company's obligations under these agreements may be limited in terms of time and/or nature of claim, and in some instances, the company may have recourse against third parties for certain payments made by the company.

It is not possible to predict the maximum potential amount of future payments under these or similar agreements due to the conditional nature of the company's obligations and the unique facts and circumstances involved in each particular agreement. Historically, payments made by the company under these agreements have not had a material effect on the company's business, financial condition or results of operations.

In addition, the company guarantees certain loans and financial commitments. The maximum potential future payment under these financial guarantees and the fair value of these guarantees recognized in the Consolidated Balance Sheet at December 31, 2024 and 2023 was not material.

Changes in the company's warranty liability for standard warranties, which are included in other accrued expenses and liabilities and other liabilities in the Consolidated Balance Sheet, and for extended warranty contracts, which are included in deferred income in the Consolidated Balance Sheet, are presented in the following tables.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Standard Warranty Liability


| ($ in millions)                           |      |      |      |      |      |
|-------------------------------------------|------|------|------|------|------|
|                                           |      |      |      |      | 2023 |
| Balance at January 1                      | $    |      |      | $    | 65   |
| Current period accruals                   |      | 82   |      |      |      |
| Accrual adjustments to reflect experience |      |      | 9    | 9    | 9    |
| Charges incurred                          | (81) |      |      |      |      |
| Balance at December 31                    |      | (83) | (83) | (83) | (83) |
|                                           | $    | 76   |      | $    | $    |

## Extended Warranty Liability (Deferred Income)


|                                                      | ($ in millions)   | ($ in millions)   |
|------------------------------------------------------|-------------------|-------------------|
|                                                      | 2024              | 2023              |
| Balance at January 1                                 | $  184            | $  272            |
| Revenue deferred for new extended warranty contracts | 23                | 70                |
| Amortization of deferred revenue                     | (113)             | (158)             |
| Other  (1)                                           | (6)               | 0                 |
| Balance at December 31                               | $  88             | $  184            |
| Current portion                                      | $  61             | $  110            |
| Noncurrent portion                                   | $  27             | $  74             |

(1) Other consists primarily of foreign currency translation adjustments.

The decrease in extended warranty liability is primarily due to the company's shift to alternative maintenance and support offerings without a warranty element.

## Contingencies

As a company with a substantial employee population and with clients in more than 175 countries, IBM is involved, either as plaintiff or defendant, in a variety of ongoing claims, demands, suits, investigations, tax matters and proceedings that arise from time to time in the ordinary course of its business. The company is a leader in the information technology industry and, as such, has been and will continue to be subject to claims challenging its IP rights and associated products and offerings, including claims of copyright and patent infringement and violations of trade secrets and other IP rights. In addition, the company enforces its own IP against infringement, through license negotiations, lawsuits or otherwise. Further, given the rapidly evolving external landscape of cybersecurity, AI, privacy and data protection laws, regulations and threat actors, the company and its clients have been and will continue to be subject to actions or proceedings in various jurisdictions. Also, as is typical for companies of IBM's scope and scale, the company is party to actions and proceedings in various jurisdictions involving a wide range of labor and employment issues (including matters related to contested employment decisions, country-specific labor and employment laws, and the company's pension, retirement and other benefit plans), as well as actions with respect to contracts, product liability, cybersecurity, data privacy, securities, foreign operations, competition law and environmental matters. These actions may be commenced by a number of different parties, including competitors, clients, current or former employees, government and regulatory agencies, stockholders and representatives of the locations in which the company does business. Some of the actions to which the company is party may involve particularly complex technical issues, and some actions may raise novel questions under the laws of the various jurisdictions in which these matters arise.

The company records a provision with respect to a claim, suit, investigation or proceeding when it is probable that a liability has been incurred and the amount of the loss can be reasonably estimated. Any recorded liabilities, including any changes to such liabilities for the years ended December 31, 2024, 2023 and 2022 were not material to the Consolidated Financial Statements.

In accordance with the relevant accounting guidance, the company provides disclosures of matters for which the likelihood of material loss is at least reasonably possible. In addition, the company also discloses matters based on its consideration of other matters and qualitative factors, including the experience of other companies in the industry, and investor, customer and employee relations considerations.

With respect to certain of the claims, suits, investigations and proceedings discussed herein, the company believes at this time that the likelihood of any material loss is remote, given, for example, the procedural status, court rulings, and/or the strength of the company's defenses in those matters. With respect to the remaining claims, suits, investigations and proceedings discussed in this note, except as specifically discussed herein, the company is unable to provide estimates of reasonably possible losses or range of losses, including losses in excess of amounts accrued, if any, for the following reasons. Claims, suits, investigations and proceedings

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

are inherently uncertain, and it is not possible to predict the ultimate outcome of these matters. It is the company's experience that damage amounts claimed in litigation against it are unreliable and unrelated to possible outcomes, and as such are not meaningful indicators of the company's potential liability. Further, the company is unable to provide such an estimate due to a number of other factors with respect to these claims, suits, investigations and proceedings, including considerations of the procedural status of the matter in question, the presence of complex or novel legal theories, and/or the ongoing discovery and development of information important to the matters. The company reviews claims, suits, investigations and proceedings at least quarterly, and decisions are made with respect to recording or adjusting provisions and disclosing reasonably possible losses or range of losses (individually or in the aggregate), to reflect the impact and status of settlement discussions, discovery, procedural and substantive rulings, reviews by counsel and other information pertinent to a particular matter.

Whether any losses, damages or remedies finally determined in any claim, suit, investigation or proceeding could reasonably have a material effect on the company's business, financial condition, results of operations or cash flows will depend on a number of variables, including: the timing and amount of such losses or damages; the structure and type of any such remedies; the significance of the impact any such losses, damages or remedies may have in the Consolidated Financial Statements; and the unique facts and circumstances of the particular matter that may give rise to additional factors. While the company will continue to defend itself vigorously, it is possible that the company's business, financial condition, results of operations or cash flows could be affected in any particular period by the resolution of one or more of these matters.

The following is a summary of the more significant legal matters involving the company.

On June 8, 2021, IBM sued GlobalFoundries U.S. Inc. (GF) in New York State Supreme Court for claims including fraud and breach of contract relating to a long-term strategic relationship between IBM and GF for researching, developing, and manufacturing advanced semiconductor chips for IBM. GF walked away from its obligations and IBM sued to recover amounts paid to GF, and other compensatory and punitive damages, totaling more than $1.5 billion. On September 14, 2021, the court ruled on GF's motion to dismiss. On April 7, 2022, the Appellate Division unanimously reversed the lower court's dismissal of IBM's fraud claim. In December 2024, the parties settled the lawsuit, with no material financial impact to IBM, and in January 2025, the lawsuit was discontinued with prejudice.

On June 2, 2022, a putative class action lawsuit was filed in the United States District Court for the Southern District of New York alleging that the IBM Pension Plan miscalculated certain joint and survivor annuity pension benefits by using outdated actuarial tables in violation of the Employee Retirement Income Security Act of 1974. IBM, the Plan Administrator Committee, and the IBM Pension Plan are named as defendants. On April 4, 2024, the court dismissed the lawsuit with prejudice. On May 3, 2024, the plaintiffs appealed.

As disclosed in the Kyndryl Form 10 and subsequent Kyndryl public filings, in 2017, BMC Software, Inc. (BMC) filed suit against IBM in the United States District Court for the Southern District of Texas in a dispute involving IBM's former managed infrastructure services business. On May 30, 2022, the trial court awarded BMC $718 million in direct damages and $718 million in punitive damages, plus interest and fees. On April 30, 2024, the United States Court of Appeals for the Fifth Circuit reversed and rendered the district court's judgment in IBM's favor. IBM does not believe it has any material exposure relating to this litigation. No material liability or related indemnification asset has been recorded by IBM.

The company is party to, or otherwise involved in, proceedings brought by U.S. federal or state environmental agencies under the Comprehensive Environmental Response, Compensation and Liability Act (CERCLA), known as "Superfund," or laws similar to CERCLA. Such statutes require potentially responsible parties to participate in remediation activities regardless of fault or ownership of sites. The company is also conducting environmental investigations, assessments or remediations at or in the vicinity of several current or former operating sites globally pursuant to permits, administrative orders or agreements with country, state or local environmental agencies, and is involved in lawsuits and claims concerning certain current or former operating sites.

The company is also subject to ongoing tax examinations and governmental assessments in various jurisdictions. Along with many other U.S. companies doing business in Brazil, the company is involved in various challenges with Brazilian tax authorities regarding non-income tax assessments and non-income tax litigation matters. The total potential amount related to all these matters for all applicable years is approximately $300 million. The company believes it will prevail on these matters and that this amount is not a meaningful indicator of liability.

Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## NOTE R. EQUITY ACTIVITY

The authorized capital stock of IBM consists of (i) 4,687,500,000 shares of common stock with a $0.20 per share par value, of which 926,290,070 shares were outstanding at December 31, 2024, and (ii) 150,000,000 shares of preferred stock with a $0.01 per share par value, whereby 75,000,000 shares have been designated as Series A Preferred Stock, of which 57,916,244 shares of Series A Preferred Stock were issued to a wholly owned subsidiary of the company but were not outstanding at December 31, 2024. The company does not intend to issue or transfer any shares of Series A Preferred Stock to any third parties.

## Stock Repurchases

The Board of Directors authorizes the company to repurchase IBM common stock. The company suspended its share repurchase program at the time of the Red Hat acquisition in 2019. At December 31, 2024, $2,008 million of Board common stock repurchase authorization was available.

## Other Stock Transactions

The company issued the following shares of common stock as part of its stock-based compensation plans and employees stock purchase plan: 12,253,153 shares in 2024, 9,794,240 shares in 2023, and 8,539,072 shares in 2022. The company issued 2,454,155 treasury shares in 2024, 2,080,983 treasury shares in 2023, and 2,512,300 treasury shares in 2022, as a result of restricted stock unit releases and exercises of stock options by employees of certain acquired businesses and by non-U.S. employees. Also, as part of the company's stock-based compensation plans, 3,430,885 common shares at a cost of $651 million, 2,953,554 common shares at a cost of $402 million, and 3,027,994 common shares at a cost of $407 million in 2024, 2023 and 2022, respectively, were remitted by employees to the company in order to satisfy minimum statutory tax withholding requirements. These amounts are included in the treasury stock balance in the Consolidated Balance Sheet and the Consolidated Statement of Equity.

## Reclassifications and Taxes Related to Items of Other Comprehensive Income


|                                                                  | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|------------------------------------------------------------------|-------------------|-------------------|-------------------|
|                                                                  | Before Tax        | Tax (Expense)/    | Net of Tax        |
| For the year ended December 31, 2024:                            | Amount            | Benefit           | Amount            |
| Other comprehensive income/(loss)                                |                   |                   |                   |
| Foreign currency translation adjustments                         | $  301            | $  (324)          | $  (23)           |
| Net changes related to available-for-sale securities             |                   |                   |                   |
| Unrealized gains/(losses) arising during the period              | $  2              | $  0              | $  1              |
| Reclassification of (gains)/losses to other (income) and expense | -                 | -                 | -                 |
| Total net changes related to available-for-sale securities       | $  2              | $  0              | 1                 |
| Unrealized gains/(losses) on cash flow hedges                    |                   |                   | $                 |
| Unrealized gains/(losses) arising during the period              | $  389            | $  (113)          | $  276            |
| Reclassification of (gains)/losses to:                           |                   |                   |                   |
| Cost of services                                                 | (22)              | 6                 | (16)              |
| Cost of sales                                                    | (40)              | 13                | (27)              |
| Cost of financing                                                | 6                 | (2)               | 5                 |
| SG&A expense                                                     | (16)              | 5                 | (11)              |
| Other (income) and expense                                       | 125               | (32)              | 94                |
| Interest expense                                                 | 31                | (8)               | 24                |
| Total unrealized gains/(losses) on cash flow hedges              | $  474            | $  (130)          | $  343            |
| Retirement-related benefit plans  (1)                            |                   |                   |                   |
| Prior service costs/(credits)                                    | $  (56)           | $  11             | $  (45)           |
| Net (losses)/gains arising during the period                     | 70                | (65)              | 6                 |
| Curtailments and settlements                                     | 3,159             | (719)             | 2,441             |
| Amortization of prior service (credits)/costs                    | (7)               | 2                 | (5)               |
| Amortization of net (gains)/losses                               | 975               | (201)             | 775               |
| Total retirement-related benefit plans                           | $  4,142          | $  (971)          | $  3,171          |
| Other comprehensive income/(loss)                                | $  4,919          | $  (1,426)        | $  3,492          |

(1) These AOCI components are included in the computation of net periodic pension cost and include the impact of pension settlement charges of $3.1 billion ($2.4 billion net of tax). Refer to note U, "Retirement-Related Benefits," for additional information.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies


|                                                                  | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|------------------------------------------------------------------|-------------------|-------------------|-------------------|
|                                                                  | Before Tax        | Tax (Expense)/    | Net of Tax        |
| For the year ended December 31, 2023:                            | Amount            | Benefit           | Amount            |
| Other comprehensive income/(loss)                                |                   |                   |                   |
| Foreign currency translation adjustments                         | $  3              | $  100            | $  103            |
| Net changes related to available-for-sale securities             |                   |                   |                   |
| Unrealized gains/(losses) arising during the period              | $  0              | $  0              | $  0              |
| Reclassification of (gains)/losses to other (income) and expense | -                 | -                 | -                 |
| Total net changes related to available-for-sale securities       | $  0              | $  0              | $  0              |
| Unrealized gains/(losses) on cash flow hedges                    |                   |                   |                   |
| Unrealized gains/(losses) arising during the period              | $  207            | $  (63)           | $  144            |
| Reclassification of (gains)/losses to:                           |                   |                   |                   |
| Cost of services                                                 | 5                 | (1)               | 5                 |
| Cost of sales                                                    | (22)              | 8                 | (14)              |
| Cost of financing                                                | 14                | (3)               | 10                |
| SG&A expense                                                     | (12)              | 4                 | (8)               |
| Other (income) and expense                                       | (209)             | 53                | (157)             |
| Interest expense                                                 | 66                | (17)              | 49                |
| Total unrealized gains/(losses) on cash flow hedges              | $  47             | $  (19)           | $  28             |
| Retirement-related benefit plans  (1)                            |                   |                   |                   |
| Prior service costs/(credits)                                    | $  2              | $  0              | $  2              |
| Net (losses)/gains arising during the period                     | (3,115)           | 536               | (2,579)           |
| Curtailments and settlements                                     | 5                 | (1)               | 4                 |
| Amortization of prior service (credits)/costs                    | (9)               | 3                 | (6)               |
| Amortization of net (gains)/losses                               | 515               | (88)              | 427               |
| Total retirement-related benefit plans                           | $  (2,602)        | $  450            | $  (2,152)        |
| Other comprehensive income/(loss)                                | $  (2,552)        | $  531            | $  (2,021)        |

(1) These AOCI components are included in the computation of net periodic pension cost. Refer to note U, "Retirement-Related Benefits," for additional information.

Accumulated Other Comprehensive Income/(Loss) (net of tax)

($ in millions)


| For the year ended December 31, 2022:                            | Before Tax  Amount   | Tax (Expense)/  Benefit   | Net of Tax  Amount   |
|------------------------------------------------------------------|----------------------|---------------------------|----------------------|
| Other comprehensive income/(loss)                                |                      |                           |                      |
| Foreign currency translation adjustments                         | $  176               | $  (406)                  | $  (229)             |
| Net changes related to available-for-sale securities             |                      |                           |                      |
| Unrealized gains/(losses) arising during the period              | $  (1)               | $  0                      | $  (1)               |
| Reclassification of (gains)/losses to other (income) and expense | -                    | -                         | -                    |
| Total net changes related to available-for-sale securities       | $  (1)               | $  0                      | $  (1)               |
| Unrealized gains/(losses) on cash flow hedges                    |                      |                           |                      |
| Unrealized gains/(losses) arising during the period              | $  241               | $  (64)                   | $  178               |
| Reclassification of (gains)/losses to:                           |                      |                           |                      |
| Cost of services                                                 | (24)                 | 6                         | (18)                 |
| Cost of sales                                                    | (99)                 | 28                        | (70)                 |
| Cost of financing                                                | 24                   | (6)                       | 18                   |
| SG&A expense                                                     | (38)                 | 11                        | (28)                 |
| Other (income) and expense                                       | (349)                | 88                        | (261)                |
| Interest expense                                                 | 86                   | (22)                      | 64                   |
| Total unrealized gains/(losses) on cash flow hedges              | $  (158)             | $  41                     | $  (117)             |
| Retirement-related benefit plans  (1)                            |                      |                           |                      |
| Prior service costs/(credits)                                    | $  463               | $  (99)                   | $  364               |
| Net (losses)/gains arising during the period                     | 878                  | (183)                     | 695                  |
| Curtailments and settlements                                     | 5,970                | (1,490)                   | 4,480                |
| Amortization of prior service (credits)/costs                    | 12                   | (3)                       | 9                    |
| Amortization of net (gains)/losses                               | 1,596                | (304)                     | 1,293                |
| Total retirement-related benefit plans                           | $  8,919             | $  (2,078)                | $  6,841             |
| Other comprehensive income/(loss)                                | $  8,936             | $  (2,442)                | $  6,494             |

(1) These AOCI components are included in the computation of net periodic pension cost and include the impact of a pension settlement charge of $5.9 billion ($4.4 billion net of tax). Refer to note U, "Retirement-Related Benefits," for additional information.

## 100 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

($ in millions)


|                                                                       | Net Unrealized  Gains/(Losses)  on Cash Flow  Hedges   | Foreign  Currency  Translation  Adjustments  (1)   | Net Change  Retirement- Related  Benefit  Plans   | Net Unrealized  Gains/(Losses)  on Available- For-Sale  Securities   | Accumulated  Other  Comprehensive  Income/(Loss)   |
|-----------------------------------------------------------------------|--------------------------------------------------------|----------------------------------------------------|---------------------------------------------------|----------------------------------------------------------------------|----------------------------------------------------|
| December 31, 2021                                                     | $  (18)                                                | $  (3,362)                                         | $  (19,854)                                       | $  (1)                                                               | $  (23,234)                                        |
| Other comprehensive income before  reclassifications                  | 178                                                    | (229)                                              | 1,059                                             | (1)                                                                  | 1,007                                              |
| Amount reclassified from accumulated  other comprehensive income  (2) | (295)                                                  | -                                                  | 5,782                                             | -                                                                    | 5,487                                              |
| Total change for the period                                           | (117)                                                  | (229)                                              | 6,841                                             | (1)                                                                  | 6,494                                              |
| December 31, 2022                                                     | (135)                                                  | (3,591)                                            | (13,013)                                          | (1)                                                                  | (16,740)                                           |
| Other comprehensive income before  reclassifications                  | 144                                                    | 103                                                | (2,577)                                           | 0                                                                    | (2,331)                                            |
| Amount reclassified from accumulated  other comprehensive income      | (115)                                                  | -                                                  | 425                                               | -                                                                    | 310                                                |
| Total change for the period                                           | 28                                                     | 103                                                | (2,152)                                           | 0                                                                    | (2,021)                                            |
| December 31, 2023                                                     | (106)                                                  | (3,488)                                            | (15,165)                                          | (1)                                                                  | (18,761)                                           |
| Other comprehensive income before  reclassifications                  | 276                                                    | (23)                                               | (39)                                              | 1                                                                    | 215                                                |
| Amount reclassified from accumulated  other comprehensive income  (3) | 67                                                     | -                                                  | 3,210                                             | -                                                                    | 3,278                                              |
| Total change for the period                                           | 343                                                    | (23)                                               | 3,171                                             | 1                                                                    | 3,492                                              |
| December 31, 2024                                                     | $  237                                                 | $  (3,512)                                         | $  (11,994)                                       | $  0                                                                 | $  (15,269)                                        |

(1) Foreign currency translation adjustments are presented gross except for any associated hedges which are presented net of tax.

(2) Net change in retirement-related benefit plans includes the impact of a pension settlement charge of $5.9 billion ($4.4 billion net of tax). Refer to note U, "Retirement-Related Benefits," for additional information.

(3) Net change in retirement-related benefit plans includes the impact of pension settlement charges of $3.1 billion ($2.4 billion net of tax). Refer to note U, "Retirement-Related Benefits," for additional information.

## NOTE S. DERIVATIVE FINANCIAL INSTRUMENTS

The company operates in multiple functional currencies and is a significant lender and borrower in the global markets. In the normal course of business, the company is exposed to the impact of interest rate changes and foreign currency fluctuations, and to a lesser extent equity risk. The company limits these risks by following established risk management policies and procedures, including the use of derivatives, and, where cost effective, financing with debt in the currencies in which assets are denominated. For interest rate exposures, derivatives are used to better align rate movements between the interest rates associated with the company's lease and other financial assets and the interest rates associated with its financing debt. Derivatives are also used to manage the related cost of debt. For foreign currency exposures, derivatives are used to better manage the cash flow volatility arising from foreign exchange rate fluctuations.

In the Consolidated Balance Sheet, the company does not offset derivative assets against liabilities in master netting arrangements nor does it offset receivables or payables recognized upon payment or receipt of cash collateral against the fair values of the related derivative instruments. The amount recognized in other accounts receivable for the right to reclaim cash collateral was $29 million and $11 million at December 31, 2024 and 2023, respectively. The amount recognized in accounts payable for the obligation to return cash collateral was $3 million and $7 million at December 31, 2024 and 2023, respectively. The company restricts the use of cash collateral received to rehypothecation, and therefore reports it in restricted cash in the Consolidated Balance Sheet. The amount rehypothecated was $3 million and $7 million at December 31, 2024 and 2023, respectively. Additionally, if derivative exposures covered by a qualifying master netting agreement had been netted in the Consolidated Balance Sheet at December 31, 2024 and 2023, the total derivative asset and liability positions each would have been reduced by $352 million and $235 million, respectively.

As discussed in note E, "Acquisitions & Divestitures," the company completed the acquisition of StreamSets and webMethods from Software AG on July 1, 2024. Prior to the acquisition, beginning in December 2023, the company entered into foreign currency derivative contracts which were accounted for as non-hedge derivatives and expired by June 28, 2024. For the years ended December 31, 2024 and 2023, the company recorded a realized loss of $68 million and an unrealized gain of $12 million, respectively, in other (income) and expense in the Consolidated Income Statement. At December 31, 2023, the fair value of the call options was $62 million, and was included in prepaid expenses and other current assets in the Consolidated Balance Sheet. There were no associated derivatives outstanding at December 31, 2024.

In 2021, the company completed the separation of its managed infrastructure services unit into a new public company, Kyndryl. During 2022, the company fully disposed of its previously retained interest in Kyndryl common stock pursuant to exchange

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

agreements with a third-party financial institution and entered into a cash-settled swap that maintained IBM's continued economic exposure in those shares. For the year ended December 31, 2022, IBM recognized a total realized loss of $351 million, including $267 million on the disposition of shares and $83 million on the settlement of the swap in other (income) and expense in the Consolidated Income Statement.

In its hedging programs, the company may use forward contracts, futures contracts, interest-rate swaps, cross-currency swaps, equity swaps and options depending upon the underlying exposure. The company is not a party to leveraged derivative instruments.

A brief description of the major hedging programs, categorized by underlying risk, follows.

## Interest Rate Risk

## Fixed and Variable Rate Borrowings

The company issues debt in the global capital markets to fund its operations and financing business. Access to cost-effective financing can result in interest rate mismatches with the underlying assets. To manage these mismatches and to reduce overall interest cost, the company may use interest-rate swaps to convert specific fixed-rate debt issuances into variable-rate debt (i.e., fair value hedges) and to convert specific variable-rate debt issuances into fixed-rate debt (i.e., cash flow hedges). At both December 31, 2024 and 2023, the total notional amount of the company's interest-rate swaps was $6.7 billion. The weighted-average remaining maturity of these instruments at December 31, 2024 and 2023 was approximately 4.5 years and 5.5 years, respectively. These interest-rate contracts were accounted for as fair value hedges. The company did not have any cash flow hedges relating to this program outstanding at December 31, 2024 and 2023.

## Forecasted Debt Issuance

The company is exposed to interest rate volatility on future debt issuances. To manage this risk, the company may use instruments such as forward starting interest-rate swaps to lock in the rate on the interest payments related to the forecasted debt issuances. There were no instruments outstanding at December 31, 2024 and 2023.

In connection with cash flow hedges of forecasted interest payments related to the company's borrowings, there were unrealized net losses (before taxes) of $106 million and $121 million at December 31, 2024 and 2023, respectively, deferred in AOCI. The company estimates that $14 million of the deferred net losses (before taxes) on derivatives in AOCI at December 31, 2024 will be reclassified to net income within the next 12 months, providing an offsetting economic impact against the underlying interest payments.

## Foreign Exchange Risk

## Long-Term Investments in Foreign Subsidiaries (Net Investment)

A large portion of the company's foreign currency denominated debt portfolio is designated as a hedge of net investment in major foreign subsidiaries to reduce the volatility in stockholders' equity caused by changes in foreign currency exchange rates in the subsidiaries' functional currency with respect to the U.S. dollar. At December 31, 2024 and 2023, the carrying value of debt designated as hedging instruments was $14.0 billion and $15.9 billion, respectively. The company also uses foreign currency derivatives, which may include forward contracts, long-term cross-currency swaps and options, for this risk management purpose. In the third quarter of 2024, the company entered into long-term cross-currency swaps designated as hedge of net investment instruments that the company also relates to its underlying U.S. dollar denominated debt. The notional value of these long-term cross-currency swaps at December 31, 2024 was $2.2 billion. Cash flows associated with interim net interest settlements of these swaps are reported in cash flows from operating activities in the Consolidated Statement of Cash Flows. For the year ended December 31, 2024, interim net interest cash settlements were not material. There were no associated derivatives at December 31, 2023. At December 31, 2024 and 2023, the total notional amount of derivative instruments designated as net investment hedges was $6.2 billion and $4.9 billion, respectively. At December 31, 2024 and 2023, the weighted-average remaining maturity of these instruments was approximately 0.8 years and 0.1 years, respectively.

## Anticipated Royalties and Cost Transactions

The company's operations generate significant nonfunctional currency, third-party vendor payments and intercompany payments for royalties and goods and services among the company's non-U.S. subsidiaries and with the company. In anticipation of these foreign currency cash flows and in view of the volatility of the currency markets, the company selectively employs foreign exchange forward contracts to manage its currency risk. These forward contracts are accounted for as cash flow hedges. At December 31, 2024, the maximum remaining length of time over which the company has hedged its exposure to the variability in future cash flows is approximately two years. At December 31, 2024 and 2023, the total notional amount of forward contracts designated as cash flow hedges of forecasted royalty and cost transactions was $9.7 billion and $9.2 billion, respectively. At both December 31, 2024 and 2023, the weighted-average remaining maturity of these instruments was approximately 0.6 years.

At December 31, 2024 and 2023, in connection with cash flow hedges of anticipated royalties and cost transactions, there were unrealized net gains (before taxes) of $415 million and $40 million, respectively, deferred in AOCI. The company estimates that

## 102 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

$363 million of the deferred net gains (before taxes) on derivatives in AOCI at December 31, 2024 will be reclassified to net income within the next 12 months, providing an offsetting economic impact against the underlying anticipated transactions.

## Foreign Currency Denominated Borrowings

The company is exposed to exchange rate volatility on foreign currency denominated debt. To manage this risk, the company may employ forward contracts or cross-currency swaps to convert the principal, or principal and interest payments of foreign currency denominated debt to debt denominated in the functional currency of the borrowing entity. These derivatives are accounted for as cash flow hedges.

At December 31, 2024, the maximum length of time remaining over which the company has hedged its exposure was approximately six years. At December 31, 2024 and 2023, the total notional amount of derivative instruments designated as cash flow hedges of foreign currency denominated debt was $5.0 billion and $5.2 billion, respectively.

At December 31, 2024 and 2023, in connection with the cross-currency swaps terminated in August 2023, there were unrealized net losses (before taxes) of $46 million and $68 million, respectively, deferred in AOCI, of which $15 million of the deferred net losses (before taxes) is estimated to be reclassified to net income within the next 12 months.

At December 31, 2024 and 2023, in connection with forward contracts, there were unrealized net gains (before taxes) of $84 million and $23 million, respectively, deferred in AOCI. Approximately $54 million of losses (before taxes) related to the initial forward points excluded from the assessment of hedge effectiveness is expected to be amortized to other (income) and expenses within the next 12 months.

## Subsidiary Cash and Foreign Currency Asset/Liability Management

The company uses its Global Treasury Centers to manage the cash of its subsidiaries. These centers principally use currency swaps to convert cash flows in a cost-effective manner. In addition, the company uses foreign exchange forward contracts to economically hedge, on a net basis, the foreign currency exposure of a portion of the company's nonfunctional currency assets and liabilities. The terms of these forward and swap contracts are generally less than one year. The changes in the fair values of these contracts and of the underlying hedged exposures are generally offsetting and are recorded in other (income) and expense in the Consolidated Income Statement. At December 31, 2024 and 2023, the total notional amount of derivative instruments in economic hedges of foreign currency exposure was $7.4 billion and $6.7 billion, respectively.

## Equity Risk Management

The company is exposed to market price changes in certain broad market indices and in the company's own stock primarily related to certain obligations to employees. Changes in the overall value of these employee compensation obligations are recorded in SG&A expense in the Consolidated Income Statement. Although not designated as accounting hedges, the company utilizes derivatives, including equity swaps and futures, to economically hedge the exposures related to its employee compensation obligations. The derivatives are linked to the total return on certain broad market indices or the total return on the company's common stock, and are recorded at fair value with gains or losses also reported in SG&A expense in the Consolidated Income Statement. At December 31, 2024 and 2023, the total notional amount of derivative instruments in economic hedges of these compensation obligations was $1.5 billion and $1.2 billion, respectively.

## Cumulative Basis Adjustments for Fair Value Hedges

At December 31, 2024 and 2023, the following amounts were recorded in the Consolidated Balance Sheet related to cumulative basis adjustments for fair value hedges:


| At December 31:                                                                          | 2024    | 2023    |
|------------------------------------------------------------------------------------------|---------|---------|
| Short-term debt                                                                          |         |         |
| Carrying amount of the hedged item                                                       | $  (13) | $  (1)  |
| Cumulative hedging adjustments included in the carrying amount-assets/(liabilities)      | (13)    | (1)     |
| Long-term debt                                                                           |         |         |
| Carrying amount of the hedged item                                                       | (6,497) | (6,629) |
| Cumulative hedging adjustments included in the carrying amount-assets/(liabilities)  (1) | 190     | 61      |

(1) Includes ($155) million and ($200) million of hedging adjustments on discontinued hedging relationships at December 31, 2024 and 2023, respectively.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## The Effect of Derivative Instruments in the Consolidated Income Statement

The total amounts of income and expense line items presented in the Consolidated Income Statement in which the effects of fair value hedges, cash flow hedges, net investment hedges and derivatives not designated as hedging instruments are recorded and the total effect of hedge activity on these income and expense line items are as follows:

($ in millions)


|                                 | Total     | Total     | Total     | Gains/(Losses) of  Total Hedge Activity   | Gains/(Losses) of  Total Hedge Activity   | Gains/(Losses) of  Total Hedge Activity   |
|---------------------------------|-----------|-----------|-----------|-------------------------------------------|-------------------------------------------|-------------------------------------------|
| For the year ended December 31: | 2024      | 2023      | 2022      | 2024                                      | 2023                                      | 2022                                      |
| Cost of services                | $  20,529 | $  21,051 | $  21,062 | $  22                                     | $  (5)                                    | $  24                                     |
| Cost of sales                   | 6,303     | 6,127     | 6,374     | 40                                        | 22                                        | 99                                        |
| Cost of financing               | 369       | 382       | 406       | (10)                                      | (11)                                      | 2                                         |
| SG&A expense                    | 19,688    | 19,003    | 18,609    | 151                                       | 165                                       | (211)                                     |
| Other (income) and expense      | 1,871     | (914)     | 5,803     | (515)                                     | 17                                        | (225)                                     |
| Interest expense                | 1,712     | 1,607     | 1,216     | (51)                                      | (54)                                      | 6                                         |


|                                                               | Gain/(Loss) Recognized in Consolidated Income Statement   | Gain/(Loss) Recognized in Consolidated Income Statement   | Gain/(Loss) Recognized in Consolidated Income Statement   | Gain/(Loss) Recognized in Consolidated Income Statement   | Gain/(Loss) Recognized in Consolidated Income Statement   | Gain/(Loss) Recognized in Consolidated Income Statement   | Gain/(Loss) Recognized in Consolidated Income Statement   |
|---------------------------------------------------------------|-----------------------------------------------------------|-----------------------------------------------------------|-----------------------------------------------------------|-----------------------------------------------------------|-----------------------------------------------------------|-----------------------------------------------------------|-----------------------------------------------------------|
|                                                               | Consolidated                                              | Recognized on Derivatives                                 | Recognized on Derivatives                                 | Recognized on Derivatives                                 | Attributable to Risk Being Hedged  (1)                    | Attributable to Risk Being Hedged  (1)                    | Attributable to Risk Being Hedged  (1)                    |
| For the year ended December 31:                               | Income Statement Line Item                                | 2024                                                      | 2023                                                      | 2022                                                      | 2024                                                      | 2023                                                      | 2022                                                      |
| Derivative instruments in fair value hedges  (2)              |                                                           |                                                           |                                                           |                                                           |                                                           |                                                           |                                                           |
| Interest rate contracts                                       | Cost of financing                                         | $  (41)                                                   | $  (17)                                                   | $  (73)                                                   | $  19                                                     | $  (2)                                                    | $  85                                                     |
|                                                               | Interest expense                                          | (208)                                                     | (83)                                                      | (257)                                                     | 97                                                        | (11)                                                      | 299                                                       |
| Derivative instruments not designated as  hedging instruments |                                                           |                                                           |                                                           |                                                           |                                                           |                                                           |                                                           |
| Foreign exchange contracts                                    | Other (income)  and expense                               | (390)                                                     | (192)                                                     | (492)                                                     | N/A                                                       | N/A                                                       | N/A                                                       |
| Equity contracts                                              | SG&A expense                                              | 135                                                       | 153                                                       | (249)                                                     | N/A                                                       | N/A                                                       | N/A                                                       |
|                                                               | Other (income)  and expense                               | -                                                         | -                                                         | (83)                                                      | N/A                                                       | N/A                                                       | N/A                                                       |
| Total                                                         |                                                           | $ (504)                                                   | $ (140)                                                   | $ (1,153)                                                 | $  116                                                    | $  (13)                                                   | $  384                                                    |

(1) The amount includes basis adjustments to the carrying value of the hedged item recorded during the period and amortization of basis adjustments recorded on de-designated hedging relationships during the period.

(2) The amount includes changes in clean fair values of the derivative instruments in fair value hedging relationships and the periodic accrual for coupon payments required under these derivative contracts.

## 104 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies


| ($ in millions)                                        | Gain/(Loss) Recognized in Consolidated Income Statement and Other Comprehensive Income   | Gain/(Loss) Recognized in Consolidated Income Statement and Other Comprehensive Income   | Gain/(Loss) Recognized in Consolidated Income Statement and Other Comprehensive Income   | Gain/(Loss) Recognized in Consolidated Income Statement and Other Comprehensive Income   | Gain/(Loss) Recognized in Consolidated Income Statement and Other Comprehensive Income   | Gain/(Loss) Recognized in Consolidated Income Statement and Other Comprehensive Income   | Gain/(Loss) Recognized in Consolidated Income Statement and Other Comprehensive Income   | Gain/(Loss) Recognized in Consolidated Income Statement and Other Comprehensive Income   | Gain/(Loss) Recognized in Consolidated Income Statement and Other Comprehensive Income   | Gain/(Loss) Recognized in Consolidated Income Statement and Other Comprehensive Income   |
|--------------------------------------------------------|------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|
| For the year ended                                     | Recognized in OCI                                                                        | Recognized in OCI                                                                        | Recognized in OCI                                                                        | Consolidated                                                                             | Reclassified from AOCI                                                                   | Reclassified from AOCI                                                                   | Reclassified from AOCI                                                                   | Amounts Excluded from Effectiveness Testing  (1)                                         | Amounts Excluded from Effectiveness Testing  (1)                                         | Amounts Excluded from Effectiveness Testing  (1)                                         |
| December 31:                                           | 2024                                                                                     | 2023                                                                                     | 2022                                                                                     | Income Statement Line Item                                                               | 2024                                                                                     | 2023                                                                                     | 2022                                                                                     | 2024                                                                                     | 2023                                                                                     | 2022                                                                                     |
| Derivative instruments  in cash flow hedges            |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |
| Interest rate contracts                                | $  -                                                                                     | $  -                                                                                     | $  -                                                                                     | Cost of financing                                                                        | $  (2)                                                                                   | $  (3)                                                                                   | $  (4)                                                                                   | $  -                                                                                     | $  -                                                                                     | $  -                                                                                     |
|                                                        |                                                                                          |                                                                                          |                                                                                          | Interest expense                                                                         | (13)                                                                                     | (15)                                                                                     | (14)                                                                                     | -                                                                                        | -                                                                                        | -                                                                                        |
| Foreign exchange  contracts                            |                                                                                          |                                                                                          |                                                                                          | Cost of services                                                                         | 22                                                                                       | (5)                                                                                      | 24                                                                                       | -                                                                                        | -                                                                                        | -                                                                                        |
| Amount included in  the assessment of  effectiveness   | 405                                                                                      | 213                                                                                      | 241                                                                                      | Cost of sales                                                                            | 40                                                                                       | 22                                                                                       | 99                                                                                       | -                                                                                        | -                                                                                        | -                                                                                        |
| Amount excluded from  the assessment of  effectiveness | (16)                                                                                     | (6)                                                                                      | -                                                                                        | Cost of financing                                                                        | (4)                                                                                      | (11)                                                                                     | (21)                                                                                     | -                                                                                        |                                                                                          | -                                                                                        |
|                                                        |                                                                                          |                                                                                          |                                                                                          | SG&A expense                                                                             | 16                                                                                       | 12                                                                                       | 38                                                                                       | -                                                                                        | -  -                                                                                     | -                                                                                        |
|                                                        |                                                                                          |                                                                                          |                                                                                          | Other (income) and  expense                                                              | (48)                                                                                     | 239                                                                                      | 349                                                                                      | (77)                                                                                     | (29)                                                                                     | -                                                                                        |
|                                                        |                                                                                          |                                                                                          |                                                                                          | Interest expense                                                                         | (19)                                                                                     | (51)                                                                                     | (72)                                                                                     | -                                                                                        | -                                                                                        | -                                                                                        |
| Instruments in net  investment hedges  (2)             |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |
| Foreign exchange  contracts                            |                                                                                          |                                                                                          |                                                                                          | Cost of financing                                                                        | -                                                                                        | -                                                                                        | -                                                                                        | 18                                                                                       | 22                                                                                       | 14                                                                                       |
| Amount included in  the assessment of  effectiveness   | 1,354                                                                                    | (397)                                                                                    | 1,613                                                                                    | Interest expense                                                                         | -                                                                                        | -                                                                                        | -                                                                                        | 91                                                                                       | 105                                                                                      | 50                                                                                       |
| Amount excluded from  the assessment of  effectiveness | 4                                                                                        | -                                                                                        | -                                                                                        |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |                                                                                          |
| Total                                                  | $ 1,747                                                                                  | $ (190)                                                                                  | $ 1,854                                                                                  |                                                                                          | $  (7)                                                                                   | $ 189                                                                                    | $ 400                                                                                    | $  32                                                                                    | $  98                                                                                    | $  64                                                                                    |

(1) Amounts excluded from effectiveness testing for both net investment hedges and cash flow hedges of foreign currency debt are amortized to net income on a straight-line basis over the life of the relevant hedging instrument.

(2) Instruments in net investment hedges include derivative and non-derivative instruments with the amounts recognized in OCI providing an offset to the translation of foreign subsidiaries.

N/A-Not applicable

For the years ended December 31, 2024 and 2023, there were no material gains or losses associated with an underlying exposure that did not or was not expected to occur (for cash flow hedges); nor are there any anticipated in the normal course of business.

## NOTE T. STOCK-BASED COMPENSATION

The following table presents total stock-based compensation cost included in income from continuing operations.


| ($ in millions)                       |        |        |        |
|---------------------------------------|--------|--------|--------|
| For the year ended December 31:       | 2024   | 2023   | 2022   |
| Cost                                  | $  223 | $  190 | $  164 |
| SG&A expense                          | 690    | 616    | 566    |
| RD&E expense                          | 398    | 328    | 258    |
| Pre-tax stock-based compensation cost | 1,311  | 1,133  | 987    |
| Income tax benefits                   | (469)  | (290)  | (249)  |
| Net stock-based compensation cost     | $  842 | $  843 | $  738 |

The company's total unrecognized compensation cost related to non-vested awards at December 31, 2024 was $1.9 billion and is expected to be recognized over a weighted-average period of approximately 2.5 years.

Capitalized stock-based compensation cost was not material at December 31, 2024, 2023 and 2022.

## Incentive Awards

Stock-based incentive awards are provided to employees under the terms of the company's long-term performance plans (the Plans). The Plans are administered by the Executive Compensation and Management Resources Committee of the Board of Directors. Awards available under the Plans principally include restricted stock units, performance share units, stock options or any combination thereof.

There were 293 million shares originally authorized to be awarded under the company's existing Plans and 66 million shares granted under previous plans that, if and when those awards were cancelled, could be reissued under the existing Plans. At December 31, 2024, 40 million unused shares were available to be granted.

## Stock Awards

Stock awards for the periods presented were made in the form of Restricted Stock Units (RSUs), including Retention Restricted Stock Units (RRSUs), or Performance Share Units (PSUs).

The following table summarizes RSU and PSU activity under the Plans during the years ended December 31, 2024, 2023 and 2022.


|                                                     | RSUs                          | RSUs            | PSUs                          | PSUs                 |
|-----------------------------------------------------|-------------------------------|-----------------|-------------------------------|----------------------|
|                                                     | Weighted-Average  Grant Price | Number of Units | Weighted-Average  Grant Price | Number of Units  (1) |
| Balance at January 1, 2022                          | $  116                        | 19,038,480      | $  118                        | 3,728,857            |
| Awards granted                                      | 112                           | 11,447,966      | 110                           | 1,237,019            |
| Awards released                                     | 114                           | (7,013,530)     | 114                           | (679,601)            |
| Awards canceled/forfeited/performance adjusted  (2) | 116                           | (2,420,002)     | 116                           | (720,197)            |
| Balance at December 31, 2022                        | $  115                        | 21,052,914      | $  117                        | 3,566,078            |
| Awards granted                                      | 118                           | 10,915,958      | 117                           | 1,295,937            |
| Awards released                                     | 114                           | (7,383,980)     | 113                           | (840,111)            |
| Awards canceled/forfeited/performance adjusted  (2) | 115                           | (1,527,249)     | 114                           | (548,865)            |
| Balance at December 31, 2023                        | $  116                        | 23,057,643      | $  118                        | 3,473,039            |
| Awards granted                                      | 176                           | 8,220,339       | 165                           | 1,110,929            |
| Awards released                                     | 117                           | (8,532,751)     | 126                           | (963,249)            |
| Awards canceled/forfeited/performance adjusted  (2) | 123                           | (1,681,686)     | 131                           | (319,169)            |
| Balance at December 31, 2024                        | $  139                        | 21,063,545      | $  130                        | 3,301,550            |

(1) The balances at December 31 for each period presented represent the number of shares expected to be issued based on achievement of grant date performance targets. The actual number of shares issued will depend on final performance against specified targets over the vesting period.

(2) Includes adjustments of (196,544), (404,655) and (362,247) for PSUs in 2024, 2023 and 2022, respectively, because final performance metrics were above or below specified targets.

## 106 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The total fair value of RSUs and PSUs granted and vested during the years ended December 31, 2024, 2023 and 2022 were as follows:


| ($ in millions)                 |      |          |      |      |        |
|---------------------------------|------|----------|------|------|--------|
| For the year ended December 31: | 2024 | 2024     | 2023 | 2023 |        |
| RSUs                            |      |          |      |      |        |
| Granted                         |      | $  1,449 |      | $    | 1,293  |
| PSUs                            |      |          |      |      |        |
| Granted                         |      | $  183   |      |      | $  151 |
| Vested                          |      | 121      |      | 95   |        |

In connection with vesting and release of RSUs and PSUs, the tax benefits realized by the company for the years ended December 31, 2024, 2023 and 2022 were $413 million, $256 million and $249 million, respectively.

## Stock Options

Stock options are awards which allow the employee to purchase shares of the company's stock at a fixed price. Stock options are granted at an exercise price equal to the company's average high and low stock price on the date of grant. These awards generally vest in four equal increments on the first four anniversaries of the grant date and have a contractual term of 10 years. The company estimates the fair value of stock options at the date of grant using a Black-Scholes valuation model. Key inputs and assumptions used to estimate the fair value of stock options include the grant price of the award, the expected option term, volatility of the company's stock, the risk-free rate and the company's dividend yield. For the stock options granted for the years ended December 31, 2024, 2023 and 2022, the expected option term was determined from historical exercise patterns, volatility was based on an analysis of the company's historical stock prices over the expected option term, the risk-free rate was obtained from the U.S. Treasury yield curve in effect at the time of grant and the dividend yield was based on the company's expectation of paying dividends in the foreseeable future. Estimates of fair value are not intended to predict actual future events or the value ultimately realized by employees who receive equity awards, and subsequent events are not indicative of the reasonableness of the original estimates of fair value made by the company. Stock options are primarily granted by the company as part of its executive compensation programs.

The weighted-average fair value of stock options granted for the years ended December 31, 2024, 2023 and 2022 was $40.09, $22.75 and $14.29, respectively. The fair value was estimated based on the following weighted-average assumptions:


| For the year ended December 31:   | 2024   | 2023   | 2022   |
|-----------------------------------|--------|--------|--------|
| Expected term (in years)          | 6.3    | 6.3    | 6.3    |
| Expected volatility               | 26.2%  | 26.0%  | 25.5%  |
| Risk-free rate                    | 4.4%   | 4.2%   | 2.0%   |
| Dividend yield                    | 3.7%   | 5.0%   | 5.3%   |

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The following table summarizes option activity under the Plans during the years ended December 31, 2024, 2023 and 2022.


|                                             | Weighted-Average  Exercise Price   | Number of Shares  Under Option   |
|---------------------------------------------|------------------------------------|----------------------------------|
| Balance at January 1, 2022                  | $  135                             | 1,549,732                        |
| Options granted                             | 125                                | 5,044,353                        |
| Options exercised                           | -                                  | -                                |
| Options forfeited/cancelled/expired         | 125                                | (319,560)                        |
| Balance at December 31, 2022                | $  128                             | 6,274,525                        |
| Options granted                             | 133                                | 4,574,756                        |
| Options exercised                           | 125                                | (408,045)                        |
| Options forfeited/cancelled/expired         | 129                                | (584,674)                        |
| Balance at December 31, 2023                | $  130                             | 9,856,562                        |
| Options granted                             | 181                                | 3,156,770                        |
| Options exercised                           | 133                                | (2,384,273)                      |
| Options forfeited/cancelled/expired         | 143                                | (623,663)                        |
| Balance at December 31, 2024                | $  145                             | 10,005,396                       |
| Vested and exercisable at December 31, 2024 | $  128                             | 2,029,748                        |

The weighted-average remaining contractual term and the aggregate intrinsic value of stock options outstanding was 8.1 years and $750 million, respectively, at December 31, 2024. The weighted-average remaining contractual term and the aggregate intrinsic value of stock options vested and exercisable was 7.5 years and $186 million, respectively, at December 31, 2024.

## Exercises of Stock Options

The total intrinsic value of options exercised for the years ended December 31, 2024 and 2023 was $138 million and $10 million, respectively. No stock options were exercised for the year ended December 31, 2022 because the company did not grant stock options during the year ended December 31, 2021. The total cash received from employees as a result of stock option exercises for the years ended December 31, 2024 and 2023 was approximately $317 million and $51 million, respectively, and was included within proceeds from issuance of shares within cash from financing activities in the Consolidated Statement of Cash Flows. In connection with these exercises, the tax benefits realized by the company for the year ended December 31, 2024 was $34 million. The tax benefits realized during 2023 were immaterial. The company settles employees stock option exercises primarily with newly issued common shares and, occasionally, with treasury shares. Total treasury shares held at December 31, 2024 and 2023 were 1,353 million and 1,352 million shares, respectively.

## Acquisitions

In connection with various acquisition transactions, there were 0.2 million stock options outstanding at December 31, 2024, as a result of the company's conversion of stock-based awards previously granted by acquired entities. The weighted-average exercise price of these stock options was $23 per share. No stock awards were outstanding at December 31, 2024.

## IBM Employees Stock Purchase Plan

Effective April 1, 2022, the company increased the discount for eligible participants to purchase shares of IBM common stock under its Employees Stock Purchase Plan (ESPP) from 5 percent to 15 percent off the average market price on the date of purchase. Since this change, the ESPP has been considered compensatory under the accounting requirements for stock-based compensation. The ESPP enables eligible participants to purchase shares of IBM common stock through payroll deductions of up to 10 percent of eligible compensation. Eligible compensation includes any compensation received by the employee during the year. The ESPP provides for semi-annual offering periods during which shares may be purchased and continues as long as shares remain available under the ESPP, unless terminated earlier at the discretion of the Board of Directors. Individual ESPP participants are restricted from purchasing more than $25,000 of common stock in one calendar year or 1,000 shares in an offering period.

Employees purchased approximately 2.6 million, 3.1 million and 2.4 million shares under the ESPP during the years ended December 31, 2024, 2023 and 2022, respectively. For the years ended December 31, 2024, 2023 and 2022, the average market price of shares purchased was $161, $117 and $114 per share, respectively, and the total stock-based compensation cost was $75 million, $64 million and $43 million, respectively. Cash dividends declared and paid by the company on its common stock also include cash dividends on the company stock purchased through the ESPP. Dividends are paid on full and fractional shares and can be reinvested. The company stock purchased through the ESPP is considered outstanding and is included in the weighted-average outstanding shares for purposes of computing basic and diluted earnings per share.

Approximately 8.7 million shares were available for purchase under the ESPP at December 31, 2024.

## 108 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## NOTE U. RETIREMENT-RELATED BENEFITS

## Description of Plans

IBM sponsors the following retirement-related plans/benefits:


| Plan                                          | Plan                                                                                                                       | Eligibility                                                                                                                                                                                                 | Funding                                                                                                                                                                                                            |                                                                                                                                                                                                                             | Other                                                                                                                                                                                                                            |
|-----------------------------------------------|----------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| U.S. Defined Benefit  (DB) Pension Plans      | IBM Personal Pension  Plan (Qualified PPP)  which includes the  Retirement Benefit  Account ("RBA") as of  January 1, 2024 | U.S. regular, full-time  and part-time  employees hired prior  to January 1, 2005 RBA - U.S. regular, full- time, and part time  employees with at  least one year of  service on or after  January 1, 2024 | Any company  contributions, required  or voluntary, are to an  irrevocable trust fund,  held for the sole  benefit of participants  and beneficiaries                                                              | Benefit Calculation Vary based on the  participant: Based on average  earnings, years of  service, and age  Cash balance formula  based on percentage of  employees' annual  salary, as well as an  interest crediting rate | Excluding RBA, benefit  accruals ceased  December 31, 2007 Certain defined benefit  pension obligations  and related plan assets  were transferred in  2022 and 2024, as  described under "IBM  Retirement Plan  Changes," below |
|                                               | Excess Personal  Pension Plan ("Excess  PPP")                                                                              | U.S. regular, full-time  and part-time  employees hired prior  to January 1, 2005                                                                                                                           | Unfunded, provides  benefits in excess of  IRS limitations for  qualified plans                                                                                                                                    | (includes RBA as of  January 1, 2024)                                                                                                                                                                                       | Benefit accruals  ceased December 31,  2007                                                                                                                                                                                      |
|                                               | Supplemental  Executive Retention  Plan ("Retention Plan")                                                                 | Eligible U.S. executives                                                                                                                                                                                    | Unfunded                                                                                                                                                                                                           | Based on average  earnings, years of  service and age                                                                                                                                                                       |                                                                                                                                                                                                                                  |
| U.S. Defined  Contribution (DC)  Plans        | 401(k) Plan  (1)                                                                                                           | U.S. regular, full-time  and part-time  employees                                                                                                                                                           | All plan participant  contributions are made  in cash and invested in  accordance with  participants'                                                                                                              | Employees can save up  to 80% of eligible pay,  subject to the Internal  Revenue Code (IRC)  annual contribution                                                                                                            | All amounts in the plan  are 100% vested                                                                                                                                                                                         |
|                                               | Excess Savings Plan  (1)                                                                                                   | U.S. employees whose  eligible compensation  is expected to exceed  IRS compensation limit  for qualified plans                                                                                             | investment elections Unfunded, non- qualified amounts  deferred are record- keeping (notional)  accounts and are not  held in trust for the  participants, but may  be invested in  accordance with  participants' | limit  Company matches  contributions on  eligible compensation  deferred and on  compensation earned  in excess of the IRC  pay limit                                                                                      | Amounts deferred into  the Plan, including  company contributions,  are recorded as  liabilities                                                                                                                                 |
| U.S. Nonpension  Postretirement  Benefit Plan | Nonpension  Postretirement Plan  (IBM Benefits Plan for  Retired Employees)                                                | Medical and dental  benefits for eligible  U.S. retirees and  eligible dependents, as  well as life insurance  for eligible U.S. retirees                                                                   | Company contributes  to irrevocable trust  fund, held for the sole  benefit of participants  and beneficiaries                                                                                                     | Varies based on plan  design formulas and  eligibility requirements                                                                                                                                                         | Since January 1, 2004,  new hires are not  eligible for these  benefits                                                                                                                                                          |
| Non-U.S. Plans                                | DB or DC                                                                                                                   | Eligible regular  employees in certain  non-U.S. subsidiaries  or branches                                                                                                                                  | Company deposits  funds under various  fiduciary-type  arrangements,  purchases annuities  under group contracts  or provides reserves for  these plans                                                            | Based either on years  of service and the  employee's  compensation  (generally during a  fixed number of years  immediately before  retirement) or on  annual credits                                                      | In certain countries,  benefit accruals have  ceased and/or have  been closed to new  hires as of various  dates Certain defined benefit  pension obligations  and related plan assets                                           |
|                                               | Nonpension  Postretirement Plan                                                                                            | Medical and dental  benefits for eligible  non-U.S. retirees and  eligible dependents, as  well as life insurance  for certain eligible non- U.S. retirees                                                  | Primarily unfunded  except for a few select  countries where the  company contributes to  irrevocable trust funds  held for the sole  benefit of participants  and beneficiaries                                   | Varies based on plan  design formulas and  eligibility requirements  by country                                                                                                                                             | Most non-U.S. retirees  are covered by local  government sponsored  and administered  programs                                                                                                                                   |

(1) Effective January 1, 2024, the 401(k) Plus Plan was renamed to the 401(k) Plan and the Excess 401(k) Plus Plan was renamed to the Excess Savings Plan. Refer to the section below entitled "IBM Retirement Plan Changes," for additional information.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Plan Financial Information

## Summary of Financial Information

The following table presents a summary of the total retirement-related benefits net periodic (income)/cost recorded in the Consolidated Income Statement.


| ($ in millions)                                           |            |            |            |                |                |                |         |         |         |
|-----------------------------------------------------------|------------|------------|------------|----------------|----------------|----------------|---------|---------|---------|
|                                                           | U.S. Plans | U.S. Plans | U.S. Plans | Non-U.S. Plans | Non-U.S. Plans | Non-U.S. Plans | Total   | Total   | Total   |
| For the year ended December 31:                           | 2024       | 2023       | 2022       | 2024           | 2023           | 2022           | 2024    | 2023    | 2022    |
| Total defined benefit pension plans  (income)/cost  (1)   | $ 3,265    | $ (329)    | $ 5,857    | $ 652          | $ 359          | $ 836          | $ 3,918 | $  30   | $ 6,693 |
| Total defined contribution plans cost  (2)                | $  57      | $ 615      | $ 555      | $ 383          | $ 376          | $ 369          | $ 440   | $ 991   | $ 924   |
| Nonpension postretirement benefit  plans cost             | $  79      | $  92      | $  85      | $  41          | $  36          | $  30          | $ 120   | $ 128   | $ 115   |
| Total retirement-related benefits net  periodic cost  (1) | $ 3,402    | $ 378      | $ 6,497    | $ 1,077        | $ 771          | $ 1,235        | $ 4,478 | $ 1,149 | $ 7,732 |

(1) In 2024, U.S. and Non-U.S. Plans include the impact of pension settlement charges of $2.7 billion and $0.4 billion, respectively, and the increase in total defined benefit pension plans (income)/cost due to the RBA that was effective January 1, 2024. In 2022, U.S. Plans includes the impact of a pension settlement charge of $5.9 billion. Refer to the section below entitled "IBM Retirement Plan Changes," for additional information.

(2) Decrease in 2024 U.S. Plans total defined contributions plans cost is due to the introduction of the RBA that was effective January 1, 2024. Refer to the section below entitled "IBM Retirement Plan Changes," for additional information.

The following table presents a summary of the total PBO for defined benefit pension plans, APBO for nonpension postretirement benefit plans, fair value of plan assets and the associated funded status recorded in the Consolidated Balance Sheet.


| ($ in millions)                                  | Benefit Obligations   | Benefit Obligations   | Fair Value of Plan Assets   | Fair Value of Plan Assets   | Funded Status  (1)   | Funded Status  (1)   |
|--------------------------------------------------|-----------------------|-----------------------|-----------------------------|-----------------------------|----------------------|----------------------|
| At December 31:                                  | 2024                  | 2023                  | 2024                        | 2023                        | 2024                 | 2023                 |
| U.S. Plans                                       |                       |                       |                             |                             |                      |                      |
| Overfunded plans                                 |                       |                       |                             |                             |                      |                      |
| Qualified PPP  (2)                               | $ 12,941              | $ 19,854              | $ 17,591                    | $ 24,437                    | $  4,651             | $  4,584             |
| Underfunded plans                                |                       |                       |                             |                             |                      |                      |
| Nonqualified defined benefit pension plans  (3)  | 1,278                 | 1,382                 | -                           | -                           | (1,278)              | (1,382)              |
| Nonpension postretirement benefit plan           | 2,257                 | 2,233                 | 6                           | 10                          | (2,251)              | (2,224)              |
| Total underfunded U.S. plans                     | $  3,535              | $  3,615              | $  6                        | $  10                       | $ (3,529)            | $ (3,605)            |
| Non-U.S. Plans                                   |                       |                       |                             |                             |                      |                      |
| Overfunded plans                                 |                       |                       |                             |                             |                      |                      |
| Qualified defined benefit pension plans  (4) (5) | $ 13,568              | $ 16,515              | $ 16,410                    | $ 19,438                    | $  2,842             | $  2,923             |
| Nonpension postretirement benefit plans          | -                     | -                     | -                           | -                           | -                    | -                    |
| Total overfunded non-U.S. plans                  | $ 13,568              | $ 16,515              | $ 16,410                    | $ 19,438                    | $  2,842             | $  2,923             |
| Underfunded plans                                |                       |                       |                             |                             |                      |                      |
| Qualified defined benefit pension plans  (4)     | $ 10,482              | $ 11,946              | $  8,795                    | $  9,621                    | $ (1,688)            | $ (2,325)            |
| Nonqualified defined benefit pension plans  (4)  | 4,440                 | 5,018                 | -                           | -                           | (4,440)              | (5,018)              |
| Nonpension postretirement benefit plans          | 507                   | 586                   | 14                          | 23                          | (493)                | (564)                |
| Total underfunded non-U.S. plans                 | $ 15,429              | $ 17,550              | $  8,809                    | $  9,643                    | $ (6,620)            | $ (7,907)            |
| Total overfunded plans                           | $ 26,509              | $ 36,369              | $ 34,001                    | $ 43,875                    | $  7,492             | $  7,506             |
| Total underfunded plans                          | $ 18,964              | $ 21,165              | $  8,815                    | $  9,653                    | $ (10,149)           | $ (11,512)           |

(1) Funded status is recognized in the Consolidated Balance Sheet as follows: Asset amounts as prepaid pension assets; (Liability) amounts as compensation and benefits (current liability) and retirement and nonpension postretirement benefit obligations (noncurrent liability).

(2) Year-to-year reduction in Benefit Obligations and Fair Value of Plan Assets includes the transfer of approximately $6 billion of pension benefit obligations and assets to Prudential Insurance Company of America. Refer to the section below entitled "IBM Retirement Plan Changes," for additional information.

(3) Excess PPP and Retention Plan.

(4) Non-U.S. qualified plans represent plans funded outside of the U.S. Non-U.S. nonqualified plans are unfunded.

(5) Year-to-year reduction in Benefit Obligations and Fair Value of Plan Assets includes the transfer of $1.2 billion of pension benefit obligations and assets to RBC Life Insurance Company and Brookfield Annuity Company. Refer to the section below entitled "IBM Retirement Plan Changes," for additional information.

## 110 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

At December 31, 2024, the company's qualified defined benefit pension plans worldwide were 116 percent funded compared to the benefit obligations, with the Qualified PPP 136 percent funded.

## Defined Benefit Pension and Nonpension Postretirement Benefit Plan Financial Information

The following tables through page 113 represent financial information for the company's retirement-related benefit plans, excluding defined contribution plans. The defined benefit pension plans under U.S. Plans consist of the Qualified PPP, the Excess PPP and the Retention Plan. The defined benefit pension plans and the nonpension postretirement benefit plans under non-U.S. Plans consist of all plans sponsored by the company's subsidiaries. The nonpension postretirement benefit plan under U.S. Plan consists of only the U.S. Nonpension Postretirement Benefit Plan.

The following tables present the components of net periodic (income)/cost of the retirement-related benefit plans recognized in the Consolidated Income Statement, excluding defined contribution plans.


| ($ in millions)                                    | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|----------------------------------------------------|-------------------|-------------------|-------------------|-------------------|-------------------|-------------------|
|                                                    | U.S. Plans        | U.S. Plans        | U.S. Plans        | Non-U.S. Plans    | Non-U.S. Plans    | Non-U.S. Plans    |
| For the year ended December 31:                    | 2024              | 2023              | 2022              | 2024              | 2023              | 2022              |
| Service cost  (1)                                  | $  394            | $  -              | $  -              | $  170            | $  177            | $  237            |
| Interest cost  (2)                                 | 911               | 1,090             | 1,129             | 1,077             | 1,170             | 493               |
| Expected return on plan assets  (2)                | (1,253)           | (1,529)           | (1,729)           | (1,546)           | (1,440)           | (1,016)           |
| Amortization of prior service costs/(credits)  (2) | -                 | 0                 | 8                 | 22                | 20                | 14                |
| Recognized actuarial losses  (2)                   | 452               | 109               | 527               | 516               | 400               | 1,031             |
| Curtailments and settlements  (2) (3)              | 2,761             | -                 | 5,923             | 398               | 7                 | 47                |
| Multi-employer plans                               | -                 | -                 | -                 | 13                | 13                | 15                |
| Other costs/(credits)  (2)                         | -                 | -                 | -                 | 3                 | 13                | 15                |
| Total net periodic (income)/cost  (3)              | $  3,265          | $  (329)          | $  5,857          | $  652            | $  359            | $  836            |

($ in millions)


|                                                    | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   |
|----------------------------------------------------|-------------------------------------------|-------------------------------------------|-------------------------------------------|-------------------------------------------|-------------------------------------------|-------------------------------------------|
|                                                    | U.S. Plan                                 | U.S. Plan                                 | U.S. Plan                                 | Non-U.S. Plans                            | Non-U.S. Plans                            | Non-U.S. Plans                            |
| For the year ended December 31:                    | 2024                                      | 2023                                      | 2022                                      | 2024                                      | 2023                                      | 2022                                      |
| Service cost                                       | $  2                                      | $  4                                      | $  5                                      | $  2                                      | $  2                                      | $  3                                      |
| Interest cost  (2)                                 | 106                                       | 117                                       | 85                                        | 41                                        | 39                                        | 24                                        |
| Expected return on plan assets  (2)                | -                                         | -                                         | -                                         | (1)                                       | (2)                                       | (2)                                       |
| Amortization of prior service costs/(credits)  (2) | (29)                                      | (29)                                      | (10)                                      | 0                                         | 0                                         | 0                                         |
| Recognized actuarial losses  (2)                   | -                                         | -                                         | 5                                         | (1)                                       | (1)                                       | 4                                         |
| Curtailments and settlements  (2)                  | -                                         | -                                         | -                                         | 0                                         | (2)                                       | 0                                         |
| Other costs/(credits)  (2)                         | -                                         | -                                         | -                                         | 0                                         | 0                                         | 0                                         |
| Total net periodic cost                            | $  79                                     | $  92                                     | $  85                                     | $  41                                     | $  36                                     | $  30                                     |

(1) Increase in U.S. Plans Service Cost in 2024 is due to the RBA that was effective January 1, 2024. Refer to the section below entitled "IBM Retirement Plan Changes," for additional information.

(2) These components of net periodic pension costs are included in other (income) and expense in the Consolidated Income Statement.

(3) In 2024, U.S. and Non-U.S. Plans include the impact of pension settlement charges of $2.7 billion and $0.4 billion, respectively. In 2022, U.S. Plans includes the impact of a pension settlement charge of $5.9 billion. Refer to the section below entitled "IBM Retirement Plan Changes," for additional information.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## IBM Retirement Plan Changes

In September 2022, the Qualified PPP irrevocably transferred to The Prudential Insurance Company of America and Metropolitan Life Insurance Company approximately $16 billion of the Qualified PPP's defined benefit pension obligations and related plan assets, thereby reducing the company's pension obligations and assets by the same amount.

Upon issuance of the group annuity contracts, the Qualified PPP's benefit obligations and administration for approximately 100,000 of the company's retirees and beneficiaries were transferred to The Prudential Insurance Company of America and Metropolitan Life Insurance Company. Under the group annuity contracts, The Prudential Insurance Company of America and Metropolitan Life Insurance Company have made an irrevocable commitment, and are solely responsible, to pay 50 percent of the pension benefits of the company's retirees and beneficiaries due on and after January 1, 2023. The transaction resulted in no changes to the amount of benefits payable to the company's retirees and beneficiaries. The company recognized a one-time, non-cash, pre-tax pension settlement charge of $5.9 billion ($4.4 billion net of tax) in the third quarter of 2022 primarily related to the accelerated recognition of actuarial losses included within AOCI in the Consolidated Statement of Equity.

In September 2022, the company amended its U.S. Nonpension Postretirement Plan to transition coverage for Medicare-eligible participants to a new IBM-sponsored group Medicare Advantage program administered by UnitedHealthcare, as of January 1, 2023. The changes were intended to provide an enhanced member experience, better value and more comprehensive benefits to IBM participants. This change resulted in a decrease in nonpension postretirement benefit obligations and a corresponding decrease in AOCI in 2022.

Effective January 1, 2024, IBM changed how it provides certain retirement-related benefits in the U.S. IBM is providing a new benefit to most U.S. employees under its existing Qualified PPP called the Retirement Benefit Account (RBA). This is in place of any IBM contributions to the U.S. employees' 401(k) Plus accounts. IBM U.S. regular full-time and part-time employees with at least one year of service will participate in the RBA. Each eligible employee's RBA will be credited monthly with an amount equal to five percent of their eligible pay with no employee contribution required. Under the RBA, eligible employees will earn six percent interest through 2026 and starting in 2027, will earn interest equal to the 10-year U.S. Treasury Yield, subject to a three percent minimum per year through 2033. Eligible employees also received a salary increase effective January 1, 2024 for the difference between the IBM 401(k) Plus contribution percent they were previously entitled to receive and the five percent RBA pay credit. Since the RBA is a component of the Qualified PPP, it is funded by the trust for the Qualified PPP along with all other benefits in the Qualified PPP. At December 31, 2024, the Qualified PPP was 136 percent funded with assets exceeding liabilities by $4.7 billion.

As a result of this change, inactive pension plan participants no longer represent substantially all of the participants in the Qualified PPP. As required by U.S. GAAP, as of January 1, 2024, the amortization period of unrecognized actuarial losses changed from the average remaining life expectancy of inactive plan participants to the average remaining service period of active plan participants. Amortization expense for the year ended December 31, 2024 was approximately $0.5 billion, primarily driven by the change in amortization period. There was no impact to funded status, retiree benefit payments or funding requirements of the Qualified PPP due to the change in amortization period.

In September 2024, the Qualified PPP irrevocably transferred to The Prudential Insurance Company of America approximately $6 billion of the Qualified PPP's defined benefit pension obligations and related plan assets, thereby reducing the company's pension obligations and assets by the same amount. After the transaction, the Qualified PPP remained in an overfunded position.

Upon issuance of the group annuity contract, the Qualified PPP's benefit obligations and administration for approximately 32,000 of the company's Plan participants and beneficiaries were transferred to The Prudential Insurance Company of America. Under the group annuity contract, The Prudential Insurance Company of America has made an irrevocable commitment, and will be solely responsible, to pay the benefits payable to the participants and beneficiaries. The transaction resulted in no changes to the amount of benefits payable to the Plan participants and beneficiaries. The company recognized a one-time, non-cash, pre-tax pension settlement charge of $2.7 billion ($2.0 billion net of tax) in the third quarter of 2024 primarily related to the accelerated recognition of actuarial losses included within AOCI in the Consolidated Statement of Equity. As a result of this transaction, the company was required to remeasure the benefit obligation and plan assets of the Qualified PPP. The remeasurement reflected the use of the discount rate and actual return on plan assets as of August 31, 2024, applying the practical expedient to remeasure plan assets and obligations as of the nearest calendar month-end date.

In October 2024, IBM Canada Ltd. ("IBMC") purchased two separate nonparticipating single premium group annuity contracts from RBC Life Insurance Company and Brookfield Annuity Company that transferred approximately $1.2 billion of the IBMC IBM Retirement Plan defined benefit pension obligations to them for approximately 6,000 Plan participants and beneficiaries. It was funded directly by the assets of the IBMC IBM Retirement Plan and required no cash contribution from IBM. There were no changes to the amount of benefits payable to the Plan participants and beneficiaries. As a result of the transaction, the company recognized a one time, non-cash, pre-tax, pension settlement charge of $0.4 billion in the fourth quarter of 2024.

## 7 7 8 ( otes to the Consolidated ! inancial Statements

$ ( .

/ K B E

/ K B G E

N U O


|                                           | efined Benefit Pension Plans   | efined Benefit Pension Plans   | efined Benefit Pension Plans   | efined Benefit Pension Plans   | ( onpension Postretirement Benefit Plans   | ( onpension Postretirement Benefit Plans   | ( onpension Postretirement Benefit Plans   | ( onpension Postretirement Benefit Plans   |
|-------------------------------------------|--------------------------------|--------------------------------|--------------------------------|--------------------------------|--------------------------------------------|--------------------------------------------|--------------------------------------------|--------------------------------------------|
|                                           | / @ S@ Plans                   | / @ S@ Plans                   | ( on= / @ S@ Plans             | ( on= / @ S@ Plans             | / @ S@ Plan                                | / @ S@ Plan                                | ( on= / @ S@ Plans                         | ( on= / @ S@ Plans                         |
|                                           | 5 3 5 7                        | 5 3 5 6                        | 5 3 5 7                        | 5 3 5 6                        | 5 3 5 7                                    | 5 3 5 6                                    | 5 3 5 7                                    | 5 3 5 6                                    |
| Change in enefit oligation                |                                |                                |                                |                                |                                            |                                            |                                            |                                            |
| % 7                                       | U  8 7 G 8 9 ;                 | U  8 7 G : ? 9                 | U  9 9 G : = ?                 | U  9 7 G 8 < 7                 | U 8 G 8 9 9                                | U 8 G 9 < ?                                | U  ; > <                                   | U  ; 9 7                                   |
| .  N 7 O                                  | 9 ? :                          | D                              | 7 = 6                          | 7 = =                          | 8                                          | :                                          | 8                                          | 8                                          |
| $                                         | ? 7 7                          | 7 G 6 ? 6                      | 7 G 6 = =                      | 7 G 7 = 6                      | 7 6 <                                      | 7 7 =                                      | : 7                                        | 9 ?                                        |
| + I                                       | D                              | D                              | 7 =                            | 7 =                            | 9 9                                        | 9 >                                        | D                                          | D                                          |
| P G                                       | D                              | D                              | =                              | N 8 6 O                        | D                                          | D                                          | D                                          | D                                          |
| P N O                                     | N ; > ? O                      | : > <                          | N 7 G 6 = < O                  | 8 G 6 = =                      | 7 7 <                                      | N 7 ? O                                    | 6                                          | 9 ;                                        |
|                                           | N 7 G : 9 8 O                  | N 7 G : 8 : O                  | N 7 G < 9 ; O                  | N 7 G < 8 ? O                  | N 8 9 9 O                                  | N 8 = : O                                  | N : O                                      | N = O                                      |
|                                           | N 7 8 8 O                      | N 7 8 8 O                      | N : 8 8 O                      | N 9 ? < O                      | N 8 O                                      | N 9 O                                      | N 9 8 O                                    | N 9 7 O                                    |
| !                                         | D                              | D                              | N 7 G > ; 6 O                  | 7 G 6 8 7                      | D                                          | D                                          | N > ; O                                    | 8 8                                        |
| P P  P  N 8 O                             | N < G 7 = > O                  | N 8 > > O                      | N 7 G 8 = = O                  | N 7 ? > O                      | D                                          | D                                          | N 7 O                                      | N : O                                      |
| Benefit oligation at ecemer 6 4           | U  7 : G 8 7 ?                 | U  8 7 G 8 9 ;                 | U  8 > G : ? 6                 | U  9 9 G : = ?                 | U 8 G 8 ; =                                | U 8 G 8 9 9                                | U  ; 6 =                                   | U  ; > <                                   |
| Change in plan assets                     |                                |                                |                                |                                |                                            |                                            |                                            |                                            |
| ! % 7                                     | U  8 : G : 9 =                 | U  8 ; G 6 ? :                 | U  8 ? G 6 ; ?                 | U  8 > G 9 = 7                 | U  7 6                                     | U  7 6                                     | U  8 9                                     | U  8 ?                                     |
|                                           | = < :                          | 7 G 6 ; ;                      | : ? ?                          | 7 G 9 ? 7                      | D                                          | D                                          | 7                                          | 9                                          |
|                                           | D                              | D                              | < =                            | ; =                            | 7 ? :                                      | 8 9 9                                      | D                                          | D                                          |
| P G                                       | D                              | D                              | :                              | N 8 : O                        | D                                          | D                                          | D                                          | D                                          |
| + I                                       | D                              | D                              | 7 =                            | 7 =                            | 9 9                                        | 9 >                                        | D                                          | D                                          |
|                                           | N 7 G : 9 8 O                  | N 7 G : 8 : O                  | N 7 G < 9 ; O                  | N 7 G < 8 ? O                  | N 8 9 9 O                                  | N 8 = : O                                  | N : O                                      | N = O                                      |
| !                                         | D                              | D                              | N 7 G ; 9 6 O                  | 7 G 6 ; >                      | D                                          | D                                          | N ; O                                      | 9                                          |
| P P  P  N 8 O                             | N < G 7 = > O                  | N 8 > > O                      | N 7 G 8 = = O                  | N 7 > 7 O                      | 8                                          | 8                                          | 6                                          | N < O                                      |
| ! air value of plan assets at  ecemer 6 4 | U  7 = G ; ? 7                 | U  8 : G : 9 =                 | U  8 ; G 8 6 ;                 | U  8 ? G 6 ; ?                 | U  <                                       | U  7 6                                     |                                            | U  8 9                                     |
| ! unded status at ecemer 6 4              | U 9 G 9 = 9                    | U 9 G 8 6 8                    | U N 9 G 8 > < O                | U N : G : 8 6 O                | U N 8 G 8 ; 7 O                            | U N 8 G 8 8 : O                            | U  7 :  U  N : ? 9 O                       | U  N ; < : O                               |
| N 9 O                                     | U  7 : G 8 7 ?                 | U  8 7 G 8 9 ;                 | U  8 > G 7 > =                 | U  9 9 G 7 8 >                 | ) P                                        | ) P                                        | ) P                                        | ) P                                        |

N 7 O $ 0 E . E + . 8 6 8 : - % 7 G 8 6 8 : E - L $ ( + G M E

N 8 O $ 8 6 8 : G 0 E . E + + , + + + / + $ ) B 0 E . E + + $ ( $ ( - + - ' $ E

N 9 O E

) P C )

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The following table presents the net funded status recognized in the Consolidated Balance Sheet.


|                                                                                       | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   | ($ in millions)   |
|---------------------------------------------------------------------------------------|-------------------|-------------------|-------------------|-------------------|-------------------|-------------------|-------------------|-------------------|
|                                                                                       | U.S. Plans        | U.S. Plans        | Non-U.S. Plans    | Non-U.S. Plans    | U.S. Plan         | U.S. Plan         | Non-U.S. Plans    | Non-U.S. Plans    |
| At December 31:                                                                       | 2024              | 2023              | 2024              | 2023              | 2024              | 2023              | 2024              | 2023              |
| Prepaid pension assets                                                                | $ 4,651           | $ 4,584           | $ 2,842           | $ 2,923           | $  0              | $  0              | $  0              | $  0              |
| Current liabilities-compensation  and benefits                                        | (117)             | (119)             | (362)             | (366)             | (218)             | (202)             | (20)              | (17)              |
| Noncurrent liabilities-retirement  and nonpension postretirement  benefit obligations | (1,160)           | (1,262)           | (5,766)           | (6,977)           | (2,033)           | (2,022)           | (473)             | (547)             |
| Funded status-net                                                                     | $ 3,373           | $ 3,202           | $ (3,286)         | $ (4,420)         | $ (2,251)         | $ (2,224)         | $ (493)           | $ (564)           |

The following table presents the pre-tax net loss, prior service costs/(credits) and transition (assets)/liabilities recognized in OCI and the changes in the pre-tax net loss, prior service costs/(credits) and transition (assets)/liabilities recognized in AOCI for the retirement-related benefit plans.


|                                                                                       | Defined Benefit Pension Plans   | Defined Benefit Pension Plans   | Defined Benefit Pension Plans   | Defined Benefit Pension Plans   | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   |
|---------------------------------------------------------------------------------------|---------------------------------|---------------------------------|---------------------------------|---------------------------------|-------------------------------------------|-------------------------------------------|-------------------------------------------|-------------------------------------------|
|                                                                                       | U.S. Plans                      | U.S. Plans                      | Non-U.S. Plans                  | Non-U.S. Plans                  | U.S. Plan                                 | U.S. Plan                                 | Non-U.S. Plans                            | Non-U.S. Plans                            |
|                                                                                       | 2024                            | 2023                            | 2024                            | 2023                            | 2024                                      | 2023                                      | 2024                                      | 2023                                      |
| Net loss at January 1                                                                 | $ 9,467                         | $ 8,617                         | $ 12,937                        | $ 11,219                        | $  73                                     | $  94                                     | $ 123                                     | $  86                                     |
| Current period loss/(gain)                                                            | (101)                           | 959                             | (73)                            | 2,125                           | 115                                       | (20)                                      | 0                                         | 34                                        |
| Curtailments and settlements  (1)                                                     | (2,761)                         | -                               | (398)                           | (7)                             | -                                         | -                                         | 0                                         | 2                                         |
| Amortization of net loss included in net  periodic (income)/cost  (2)                 | (452)                           | (109)                           | (516)                           | (400)                           | -                                         | -                                         | 1                                         | 1                                         |
| Net loss at December 31                                                               | $ 6,153                         | $ 9,467                         | $ 11,950                        | $ 12,937                        | $ 188                                     | $  73                                     | $ 125                                     | $ 123                                     |
| Prior service costs/(credits) at January 1                                            | $  0                            | $  0                            | $  309                          | $  330                          | $ (350)                                   | $                                         |                                           | $  0                                      |
| Current period prior service costs/(credits)                                          | -                               | -                               | 56                              | (1)                             | -                                         | (379)  -                                  | $  (1)  0                                 | (1)                                       |
| Curtailments, settlements and other                                                   | -                               | -                               | -                               | -                               | -                                         | -                                         | -                                         | -                                         |
| Amortization of prior service (costs)/credits  included in net periodic (income)/cost | 0                               | 0                               | (22)                            | (20)                            | 29                                        | 29                                        | 0                                         | 0                                         |
| Prior service costs/(credits) at December 31                                          | $  0                            | $  0                            | $  342                          | $  309                          | $ (321)                                   | $ (350)                                   | $  (1)                                    | $  (1)                                    |
| Transition (assets)/liabilities at January 1                                          | $  -                            | $  -                            | $  0                            | $  0                            | $  -                                      | $  -                                      | $  0                                      | $  0                                      |
| Transition (assets)/liabilities at December 31                                        | $  -                            | $  -                            | $  0                            | $  0                            | $  -                                      | $  -                                      | $  0                                      | $  0                                      |
| Total loss recognized in accumulated other  comprehensive income/(loss)  (3)          | $ 6,153                         | $ 9,467                         | $ 12,293                        | $ 13,245                        | $ (133)                                   | $ (276)                                   | $ 124                                     | $ 122                                     |

(1) In 2024, the amount related to U.S. Defined Benefit Pension Plans includes the impact of a pension settlement charge of $2.7 billion, and the amount related to Non-U.S. Defined Benefit Pension Plans includes the impact of a pension settlement charge of $0.4 billion. Refer to the section above entitled "IBM Retirement Plan Changes," for additional information.

(2) Increase in U.S. Plans Amortization of net loss included in net periodic (income)/cost in 2024 is due to the RBA that was effective January 1, 2024. Refer to the section above entitled "IBM Retirement Plan Changes," for additional information.

(3) Refer to note R, "Equity Activity," for the total change in AOCI, and the Consolidated Statement of Comprehensive Income for the components of net periodic (income)/cost, including the related tax effects, recognized in OCI for the retirement-related benefit plans.

## 114 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Assumptions Used to Determine Plan Financial Information

Underlying both the measurement of benefit obligations and net periodic (income)/cost are actuarial valuations. These valuations use participant-specific information such as salary, age and years of service, as well as certain assumptions, the most significant of which include estimates of discount rates, expected return on plan assets, rate of compensation increases, interest crediting rates and mortality rates. The company evaluates these assumptions, at a minimum, annually, and makes changes as necessary.

The following tables present the assumptions used to measure the net periodic (income)/cost and the year-end benefit obligations for retirement-related benefit plans.


|                                                                                                         | Defined Benefit Pension Plans   | Defined Benefit Pension Plans   | Defined Benefit Pension Plans   | Defined Benefit Pension Plans   | Defined Benefit Pension Plans   | Defined Benefit Pension Plans   |
|---------------------------------------------------------------------------------------------------------|---------------------------------|---------------------------------|---------------------------------|---------------------------------|---------------------------------|---------------------------------|
|                                                                                                         | U.S. Plans                      | U.S. Plans                      | U.S. Plans                      | Non-U.S. Plans                  | Non-U.S. Plans                  | Non-U.S. Plans                  |
|                                                                                                         | 2024                            | 2023                            | 2022                            | 2024                            | 2023                            | 2022                            |
| Weighted-average assumptions used to measure net periodic  (income)/cost for the year ended December 31 |                                 |                                 |                                 |                                 |                                 |                                 |
| Discount rate  (1) (2) (3)                                                                              | 5.00 %                          | 5.30 %                          | 3.30 %                          | 3.37 %                          | 3.80 %                          | 1.26 %                          |
| Expected long-term returns on plan assets  (1) (2) (3)                                                  | 5.08 %                          | 5.50 %                          | 4.33 %                          | 4.89 %                          | 4.44 %                          | 2.97 %                          |
| Rate of compensation increase  (4)                                                                      | 5.00 %                          | N/A                             | N/A                             | 4.18 %                          | 4.00 %                          | 3.02 %                          |
| Interest crediting rate  (1) (3)                                                                        | 3.80 %                          | 4.40 %                          | 2.07 %                          | 0.28 %                          | 0.34 %                          | 0.26 %                          |
| Weighted-average assumptions used to measure benefit  obligations at December 31                        |                                 |                                 |                                 |                                 |                                 |                                 |
| Discount rate                                                                                           | 5.50 %                          | 5.00 %                          | 5.30 %                          | 3.61 %                          | 3.36 %                          | 3.80 %                          |
| Rate of compensation increase                                                                           | 4.00 %                          | 5.00 %                          | N/A                             | 4.04 %                          | 4.18 %                          | 4.00 %                          |
| Interest crediting rate                                                                                 | 4.30 %                          | 3.80 %                          | 4.40 %                          | 0.32 %                          | 0.28 %                          | 0.34 %                          |

(1) The Qualified PPP discount rate, expected long-term return on plan assets and interest crediting rate of 5.00 percent, 5.00 percent, and 3.80 percent, respectively, for the period January 1, 2024 through August 31, 2024, changed to 5.00 percent, 5.25 percent and 3.80 percent, respectively, for the period September 1, 2024 through December 31, 2024 due to remeasurement of the plan as a result of the changes described in the section above entitled "IBM Retirement Plan Changes."

(2) The Non-U.S. Plan discount rate and expected long-term return on plan assets of 4.60 percent, and 5.50 percent, respectively, for the period January 1, 2024 through October 29, 2024, changed to 4.70 percent and 4.50 percent respectively, for the period October 30, 2024 through December 31, 2024 due to remeasurement of the IBMC IBM Retirement Plan as a result of the changes described in the section above entitled "IBM Retirement Plan Changes."

(3) The Qualified PPP discount rate, expected long-term return on plan assets and interest crediting rate of 2.60 percent, 4.00 percent and 1.10 percent, respectively, for the period January 1, 2022 through August 31, 2022, changed to 4.70 percent, 5.00 percent and 4.00 percent, respectively, for the period September 1, 2022 through December 31, 2022 due to remeasurement of the plan as a result of the changes described in the section above entitled "IBM Retirement Plan Changes."

(4) The rate of compensation increase in 2024 is due to the RBA that was effective January 1, 2024. Refer to the section above entitled "IBM Retirement Plan Changes," for additional information.

N/A-Not applicable


|                                                                                                | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   | Nonpension Postretirement Benefit Plans   |
|------------------------------------------------------------------------------------------------|-------------------------------------------|-------------------------------------------|-------------------------------------------|-------------------------------------------|-------------------------------------------|-------------------------------------------|
|                                                                                                | U.S. Plan                                 | U.S. Plan                                 | U.S. Plan                                 | Non-U.S. Plans                            | Non-U.S. Plans                            | Non-U.S. Plans                            |
|                                                                                                | 2024                                      | 2023                                      | 2022                                      | 2024                                      | 2023                                      | 2022                                      |
| Weighted-average assumptions used to measure net periodic  cost for the year ended December 31 |                                           |                                           |                                           |                                           |                                           |                                           |
| Discount rate  (1)                                                                             | 5.00 %                                    | 5.30 %                                    | 3.05 %                                    | 7.66 %                                    | 7.25 %                                    | 5.35 %                                    |
| Expected long-term returns on plan assets                                                      | N/A                                       | N/A                                       | N/A                                       | 8.12 %                                    | 8.05 %                                    | 6.64 %                                    |
| Interest crediting rate  (1)                                                                   | 3.80 %                                    | 4.40 %                                    | 2.16 %                                    | N/A                                       | N/A                                       | N/A                                       |
| Weighted-average assumptions used to measure benefit  obligations at December 31               |                                           |                                           |                                           |                                           |                                           |                                           |
| Discount rate                                                                                  | 5.30 %                                    | 5.00 %                                    | 5.30 %                                    | 8.21 %                                    | 7.66 %                                    | 7.25 %                                    |
| Interest crediting rate                                                                        | 4.30 %                                    | 3.80 %                                    | 4.40 %                                    | N/A                                       | N/A                                       | N/A                                       |

(1) The U.S. Nonpension Postretirement Plan discount rate and interest crediting rate of 2.30 percent and 1.10 percent, respectively, for the period January 1, 2022 through July 31, 2022, changed to 4.10 percent and 3.65 percent, respectively, for the period August 1, 2022 through December 31, 2022 due to remeasurement of the plan as a result of the changes described in the section above entitled "IBM Retirement Plan Changes."

N/A-Not applicable

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies


| Item                                                | Description of Assumptions                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
|-----------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Discount Rate                                       | Changes in discount rate assumptions impact net periodic (income)/cost and the PBO. For the U.S. and certain non-U.S. countries, a portfolio of high-quality corporate bonds is used to construct  a yield curve. Cash flows from the company's expected benefit obligation payments are matched to the  yield curve to derive the discount rates. In other non-U.S. countries where the markets for high-quality long-term bonds are not as well developed,  a portfolio of long-term government bonds is used as a base, and a credit spread is added to simulate                                                                                                                                                           |
| Expected Long- Term Returns on  Plan Assets         | Represents the expected long-term returns on plan assets based on the calculated market-related value of  plan assets and considers long-term expectations for future returns and the investment policies and  strategies discussed on page 116. These rates of return are developed and tested for reasonableness  against historical returns by the company.                                                                                                                                                                                                                                                                                                                                                                |
|                                                     | The use of expected returns may result in pension income that is greater or less than the actual return of  those plan assets in a given year. Over time, however, the expected long-term returns are designed to  approximate the actual long-term returns, and therefore result in a pattern of income or loss recognition that  more closely matches the pattern of the services provided by the employees. The difference between actual and expected returns is recognized as a component of net loss or gain in  AOCI, which is amortized as a component of net periodic (income)/cost over the service lives or life  expectancy of the plan participants, depending on the plan, provided such amounts exceed certain |
|                                                     | The projected long-term rate of return on plan assets for 2025 is 5.50 percent for U.S. and 4.86 percent for  non-U.S. DB Plans.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| Rate of                                             | Compensation rate increases are determined based on the company's long-term plans for such increases.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| Compensation  Increases and  Mortality  Assumptions | Mortality assumptions are based on life expectancy and death rates for different types of participants and  are periodically updated based on actual experience.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| Interest Crediting  Rate                            | Benefits for participants in Cash Balance Plans are calculated using a cash balance formula. An assumption  underlying this formula is an interest crediting rate, which impacts both net periodic (income)/cost and the  PBO. This provides the basis for projecting the expected interest rate that plan participants will earn on the  benefits that they are expected to receive in the following year.                                                                                                                                                                                                                                                                                                                   |
| Healthcare Cost  Trend Rate                         | For nonpension postretirement benefit plans, the company determines healthcare cost trend rates based  on medical cost inflation expectations in each market and IBM's plan characteristics. The healthcare cost  trend rate is an important consideration when setting future expectations for plan costs or benefit  obligations, taking into account the terms of the plan which limit the company's future obligations to the  participants.                                                                                                                                                                                                                                                                              |
|                                                     | The company's U.S. healthcare cost trend rate assumption for 2025 is 6.47 percent and is expected to  decrease to 4.50 percent over approximately 14 years.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |

## 116 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Plan Assets

Retirement-related benefit plan assets are recognized and measured at fair value. Because of the inherent uncertainty of valuations, these fair value measurements may not necessarily reflect the amounts the company could realize in current market transactions.

## Investment Policies and Strategies

The investment objectives of the Qualified PPP portfolio are designed to generate returns that will enable the plan to meet its future obligations. The precise amount for which these obligations will be settled depends on future events, including the retirement dates and life expectancy of the plan participants. The obligations are estimated using actuarial assumptions, based on the current economic environment and other pertinent factors described above. The Qualified PPP portfolio's investment strategy balances the requirement to generate returns, using assets with higher expected returns such as equity securities, with the need to control risk in the portfolio with less volatile assets, such as fixed-income securities. Risks include, among others, inflation, volatility in equity values and changes in interest rates that could cause the plan to become underfunded, thereby increasing its dependence on contributions from the company. To mitigate any potential concentration risk, careful consideration is given to balancing the portfolio among industry sectors, companies and geographies, taking into account interest rate sensitivity, dependence on economic growth, currency and other factors that affect investment returns. In 2024, the company changed its investment, strategy, modifying asset allocation, primarily by increasing return-seeking assets and reducing debt securities. The change was designed to improve expected returns for the plan given that the plan began accruing new liabilities in the form of Retirement Benefit Accounts. The Qualified PPP portfolio's target allocation is 11 percent equity securities, 70 percent fixed-income securities, 3 percent real estate and 16 percent other investments.

The assets are managed by professional investment firms and investment professionals who are employees of the company. They are bound by investment mandates determined by the company's management and are measured against specific benchmarks. Among these managers, consideration is given, but not limited to, balancing security concentration, issuer concentration, investment style and reliance on particular active and passive investment strategies.

Market liquidity risks are tightly controlled, with $1,465 million of the Qualified PPP portfolio as of December 31, 2024 invested in private market assets consisting of private equities, private real estate investments and private infrastructure equity, which are less liquid than publicly traded securities and primarily measured at net asset value (NAV). In addition, the Qualified PPP portfolio had $843 million in commitments for future investments in private markets to be made over a number of years. These commitments are expected to be funded from plan assets.

Derivatives are used as an effective means to achieve investment objectives and/or as a component of the plan's risk management strategy. The primary reasons for the use of derivatives are fixed income management, including duration, interest rate management and credit exposure, cash equitization and to manage currency strategies.

The non-U.S. Plans investment objectives are similar to those described previously, subject to local regulations. The weightedaverage target allocation for the non-U.S. plans is 16 percent equity securities, 63 percent fixed-income securities, 3 percent real estate, 13 percent insurance contracts and 5 percent other investments, which is consistent with the allocation decisions made by the company's management. In some countries, a higher percentage allocation to fixed income is required to manage solvency and funding risks. In others, the responsibility for managing the investments typically lies with a board that may include up to 50 percent of members elected by employees and retirees. This can result in slight differences compared with the strategies previously described. The percentage of non-U.S. plans investment in assets that are less liquid is consistent with the U.S. plan. The use of derivatives is also consistent with the U.S. plan and mainly for currency hedging, interest rate risk management, credit exposure and alternative investment strategies.

The company's nonpension postretirement benefit plans are underfunded or unfunded. For some plans, the company maintains a nominal, highly liquid trust fund balance to ensure timely benefit payments.

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

## Defined Benefit Pension Plan Assets

The following table presents the company's defined benefit pension plans' asset classes and their associated fair value at December 31, 2024. The U.S. Plan consists of the Qualified PPP and the non-U.S. Plans consist of all plans sponsored by the company's subsidiaries.


| ($ in millions)                                                                   | U.S. Plan   | U.S. Plan   | U.S. Plan   | U.S. Plan   | Non-U.S. Plans   | Non-U.S. Plans   | Non-U.S. Plans   | Non-U.S. Plans   |
|-----------------------------------------------------------------------------------|-------------|-------------|-------------|-------------|------------------|------------------|------------------|------------------|
|                                                                                   | Level 1     | Level 2     | Level 3     | Total       | Level 1          | Level 2          | Level 3          | Total            |
| Equity                                                                            |             |             |             |             |                  |                  |                  |                  |
| Equity securities  (1)                                                            | $  655      | $  -        | $  7        | $  661      | $  67            | $  1             | $  -             | $  68            |
| Equity mutual funds  (2)                                                          | 183         | -           | -           | 183         | -                | -                | -                | -                |
| Fixed income                                                                      |             |             |             |             |                  |                  |                  |                  |
| Government and related  (3)                                                       | -           | 7,010       | -           | 7,010       | 110              | 6,807            | -                | 6,917            |
| Corporate bonds  (4)                                                              | -           | 3,663       | 186         | 3,849       | 7                | 2,550            | -                | 2,557            |
| Mortgage and asset-backed securities                                              | -           | 141         | -           | 141         | -                | 4                | -                | 4                |
| Fixed income mutual funds  (5)                                                    | 240         | -           | -           | 240         | -                | -                | -                | -                |
| Insurance contracts  (6)                                                          | -           | -           | -           | -           | -                | 3,332            | -                | 3,332            |
| Cash and short-term investments  (7)                                              | 670         | (24)        | -           | 646         | 170              | 277              | -                | 447              |
| Private equity                                                                    | -           | -           | -           | -           | -                | -                | -                | -                |
| Real estate                                                                       | -           | -           | -           | -           | -                | -                | 3                | 3                |
| Derivatives  (8)                                                                  | -           | 8           | -           | 8           | 39               | 58               | -                | 97               |
| Other mutual funds  (9)                                                           | -           | -           | -           | -           | 20               | -                | -                | 20               |
| Subtotal                                                                          | 1,747       | 10,799      | 193         | 12,739      | 413              | 13,029           | 3                | 13,444           |
| Investments measured at net asset  value using the NAV practical  expedient  (10) | -           | -           | -           | 4,852       | -                | -                | -                | 11,807           |
| Other  (11)                                                                       | -           | -           | -           | 0           | -                | -                | -                | (47)             |
| Fair value of plan assets                                                         | $ 1,747     | $ 10,799    | $  193      | $ 17,591    | $  413           | $ 13,029         | $  3             | $ 25,205         |

(1) Represents U.S. and international securities. The U.S. Plan includes IBM common stock of $1 million. Non-U.S. Plans include IBM common stock of $1 million.

(2) Invests in predominantly equity securities.

(3) Includes debt issued by national, state and local governments and agencies.

(4) The U.S. Plans include IBM corporate bonds of $4 million. Non-U.S. Plans include IBM corporate bonds of $4 million.

(5) Invests predominantly in fixed-income securities.

(6) Primarily represents insurance policy contracts (Buy-In) in certain non-U.S. plans.

(7) Includes cash, cash equivalents and short-term marketable securities.

(8) Includes interest-rate derivatives, forwards, exchange-traded and other over-the-counter derivatives.

(9) Invests in both equity and fixed-income securities.

(10) Investments measured at fair value using the net asset value (NAV) per share (or its equivalent) as a practical expedient, including commingled funds, hedge funds, private equity and real estate partnerships.

(11) Represents net unsettled transactions, relating primarily to purchases and sales of plan assets.

The U.S. nonpension postretirement benefit plan assets of $6 million were invested primarily in cash equivalents, categorized as Level 1 in the fair value hierarchy. The non-U.S. nonpension postretirement benefit plan assets of $14 million, primarily in Brazil, and, to a lesser extent, in Mexico and South Africa, were invested primarily in government and related fixed-income securities and corporate bonds, categorized as Level 2 in the fair value hierarchy.

## 118 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The following table presents the company's defined benefit pension plans' asset classes and their associated fair value at December 31, 2023. The U.S. Plan consists of the Qualified PPP and the non-U.S. Plans consist of all plans sponsored by the company's subsidiaries.


| ($ in millions)                                                                   | U.S. Plan   | U.S. Plan   | U.S. Plan   | U.S. Plan   | Non-U.S. Plans   | Non-U.S. Plans   | Non-U.S. Plans   | Non-U.S. Plans   |
|-----------------------------------------------------------------------------------|-------------|-------------|-------------|-------------|------------------|------------------|------------------|------------------|
|                                                                                   | Level 1     | Level 2     | Level 3     | Total       | Level 1          | Level 2          | Level 3          | Total            |
| Equity                                                                            |             |             |             |             |                  |                  |                  |                  |
| Equity securities  (1)                                                            | $  631      | $  -        | $  -        | $  631      | $  243           | $  -             | $  -             | $  243           |
| Equity mutual funds  (2)                                                          | 155         | -           | -           | 155         | 5                | -                | -                | 5                |
| Fixed income                                                                      |             |             |             |             |                  |                  |                  |                  |
| Government and related  (3)                                                       | -           | 9,861       | -           | 9,861       | -                | 7,700            | -                | 7,700            |
| Corporate bonds  (4)                                                              | -           | 7,074       | 709         | 7,783       | -                | 2,691            | -                | 2,691            |
| Mortgage and asset-backed securities                                              | -           | 178         | -           | 178         | -                | 9                | -                | 9                |
| Fixed income mutual funds  (5)                                                    | 251         | -           | -           | 251         | -                | -                | 75               | 75               |
| Insurance contracts  (6)                                                          | -           | -           | -           | -           | -                | 3,774            | -                | 3,774            |
| Cash and short-term investments  (7)                                              | 495         | 119         | -           | 614         | 264              | 315              | -                | 579              |
| Private equity                                                                    | -           | -           | 13          | 13          | -                | -                | -                | -                |
| Real estate                                                                       | -           | -           | -           | -           | -                | -                | 4                | 4                |
| Derivatives  (8)                                                                  | -           | -           | -           | -           | 51               | 258              | -                | 309              |
| Other mutual funds  (9)                                                           | -           | -           | -           | -           | 20               | -                | -                | 20               |
| Subtotal                                                                          | 1,532       | 17,231      | 722         | 19,485      | 584              | 14,747           | 78               | 15,409           |
| Investments measured at net asset  value using the NAV practical  expedient  (10) | -           | -           | -           | 4,952       | -                | -                | -                | 13,709           |
| Other  (11)                                                                       | -           | -           | -           | 0           | -                | -                | -                | (59)             |
| Fair value of plan assets                                                         | $ 1,532     | $ 17,231    | $  722      | $ 24,437    | $  584           | $ 14,747         | $  78            | $ 29,059         |

(1) Represents U.S. and international securities. The U.S. Plan includes IBM common stock of $1 million. Non-U.S. Plans include IBM common stock of $2 million.

(2) Invests in predominantly equity securities.

(3) Includes debt issued by national, state and local governments and agencies.

(4) The U.S. Plans include IBM corporate bonds of $16 million. Non-U.S. Plans include IBM corporate bonds of $5 million.

(5) Invests in predominantly fixed-income securities.

(6) Primarily represents insurance policy contracts (Buy-In) in certain non-U.S. plans.

(7) Includes cash, cash equivalents and short-term marketable securities.

(8) Includes interest-rate derivatives, forwards, exchange-traded and other over-the-counter derivatives.

(9) Invests in both equity and fixed-income securities.

(10) Investments measured at fair value using the net asset value (NAV) per share (or its equivalent) as a practical expedient, including commingled funds, hedge funds, private equity and real estate partnerships.

(11) Represents net unsettled transactions, relating primarily to purchases and sales of plan assets.

The U.S. nonpension postretirement benefit plan assets of $10 million were invested in cash equivalents, categorized as Level 1 in the fair value hierarchy. The non-U.S. nonpension postretirement benefit plan assets of $23 million, primarily in Brazil, and, to a lesser extent, in Mexico and South Africa, were invested primarily in government and related fixed-income securities and corporate bonds, categorized as Level 2 in the fair value hierarchy.

The following tables present the reconciliation of the beginning and ending balances of Level 3 assets for the years ended December 31, 2024 and 2023 for the U.S. Plan.


| ($ in millions)                                                             |                    |                    |       |       |                  |                  |                        |                        |                        |
|-----------------------------------------------------------------------------|--------------------|--------------------|-------|-------|------------------|------------------|------------------------|------------------------|------------------------|
|                                                                             | Equity  Securities | Equity  Securities |       |       | Corporate  Bonds | Corporate  Bonds | Private   Equity Total | Private   Equity Total | Private   Equity Total |
| Balance at January 1, 2024                                                  | $  -               | $                  | 709   | $  13 | $  13            | $  13            | 722                    | $  13                  | $                      |
| Return on assets held at end of year                                        | (2)                |                    | 4     | -     |                  | 2                | 2                      | 2                      | 2                      |
| Return on assets sold during the year Purchases, sales and settlements, net | 0  2               |                    | 16    | -     |                  |                  | 16  (554)              | (10)                   |                        |
| Transfers, net                                                              | 7                  |                    | (545) | 1     |                  | (2)              | 6                      |                        | $                      |
| Balance at December 31, 2024                                                | $  7               | $                  | 186   | $     |                  |                  |                        | -                      | 193                    |

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies


| ($ in millions)                       |                  |                  |          |
|---------------------------------------|------------------|------------------|----------|
|                                       | Corporate  Bonds | Private   Equity | Total    |
| Balance at January 1, 2023            | $  721           | $  421           | $  1,142 |
| Return on assets held at end of year  | (18)             | (5)              | (23)     |
| Return on assets sold during the year | 10               | 0                | 10       |
| Purchases, sales and settlements, net | (5)              | (404)            | (409)    |
| Transfers, net                        | 2                | -                | 2        |
| Balance at December 31, 2023          | $  709           | $  13            | $  722   |

The following tables present the reconciliation of the beginning and ending balances of Level 3 assets for the years ended December 31, 2024 and 2023 for the non-U.S. Plans.

($ in millions)


|                                       | Fixed Income  Mutual Funds   | Real Estate   | Real Estate   | Total   |
|---------------------------------------|------------------------------|---------------|---------------|---------|
| Balance at January 1, 2024            | $  75                        | $             | 4             | $  78   |
| Return on assets held at end of year  | -                            |               | -             | -       |
| Return on assets sold during the year | 5                            |               | -             | 5       |
| Purchases, sales and settlements, net | (77)                         |               | -             | (77)    |
| Transfers, net                        | -                            |               | 0             | 0       |
| Foreign exchange impact               | (3)                          |               | (1)           | (4)     |
| Balance at December 31, 2024          | $  -                         | $             | 3             | $  3    |


|                                       | Fixed Income  Mutual Funds   | Real Estate   | Total   |
|---------------------------------------|------------------------------|---------------|---------|
| Balance at January 1, 2023            | $  9                         | $  145        | $  155  |
| Return on assets held at end of year  | 1                            | (66)          | (65)    |
| Return on assets sold during the year | -                            | 56            | 56      |
| Purchases, sales and settlements, net | 63                           | (137)         | (74)    |
| Transfers, net                        | -                            | 0             | 0       |
| Foreign exchange impact               | 2                            | 5             | 7       |
| Balance at December 31, 2023          | $  75                        | $  4          | $  78   |

## Valuation Techniques

The following is a description of the valuation techniques used to measure plan assets at fair value. There were no changes in valuation techniques during 2024 and 2023.

Equity securities are valued at the closing price reported on the stock exchange on which the individual securities are traded. IBM common stock is valued at the closing price reported on the New York Stock Exchange. Mutual funds are typically valued based on quoted market prices. These assets are generally classified as Level 1.

The fair value of fixed-income securities is typically estimated using pricing models, quoted prices of securities with similar characteristics or discounted cash flows and are generally classified as Level 2. If available, they are valued using the closing price reported on the major market on which the individual securities are traded.

Cash includes money market accounts that are valued at their cost plus interest on a daily basis, which approximates fair value. Short-term investments represent securities with original maturities of one year or less. These assets are classified as Level 1 or Level 2.

Real estate valuations require significant judgment due to the absence of quoted market prices, the inherent lack of liquidity and the long-term nature of such assets. These assets are initially valued at cost and are reviewed periodically utilizing available and relevant market data, including appraisals, to determine if the carrying value of these assets should be adjusted. These assets are classified as Level 3.

Exchange-traded derivatives are valued at the closing price reported on the exchange on which the individual securities are traded, while forward contracts are valued using a mid-close price. Over-the-counter derivatives are typically valued using pricing models. The models require a variety of inputs, including, for example, yield curves, credit curves, measures of volatility and foreign exchange rates. These assets are classified as Level 1 or Level 2 depending on availability of quoted market prices.

## 120 Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

Certain investments are measured at fair value using the net asset value (NAV) per share (or its equivalent) as a practical expedient. These investments, which include commingled funds, hedge funds, private equity and real estate partnerships, are typically valued using the NAV provided by the administrator of the fund and reviewed by the company. The NAV is based on the value of the underlying assets owned by the fund, minus liabilities and divided by the number of shares or units outstanding.

## Contributions and Direct Benefit Payments

It is the company's general practice to fund amounts for pensions sufficient to meet the minimum requirements set forth in applicable employee benefits laws and local tax laws. From time to time, the company contributes additional amounts as it deems appropriate.

The following table presents the contributions made to the non-U.S. DB plans, nonpension postretirement benefit plans, multiemployer plans, DC plans and direct benefit payments for 2024 and 2023. The cash contributions to the multi-employer plans represent the annual cost included in the net periodic (income)/cost recognized in the Consolidated Income Statement. The company's participation in multi-employer plans has no material impact on the company's financial statements.


| ($ in millions)                         |          |          |
|-----------------------------------------|----------|----------|
| For the years ended December 31:        | 2024     | 2023     |
| Non-U.S. DB plans                       | $  67    | $  57    |
| Nonpension postretirement benefit plans | 194      | 233      |
| Multi-employer plans                    | 13       | 13       |
| DC plans  (1)                           | 440      | 991      |
| Direct benefit payments                 | 578      | 552      |
| Total                                   | $  1,291 | $  1,847 |

(1) Decrease in DC plans is primarily due to the introduction of the RBA that was effective January 1, 2024. Refer to the section above entitled "IBM Retirement Plan Changes," for additional information.

In 2024 and 2023, $194 million and $256 million, respectively, of contributions to the non-U.S. DB plans and U.S. nonpension postretirement benefit plans were made in U.S. Treasury securities. Additionally, in 2024 and 2023, contributions of $741 million and $682 million, respectively, were made to the Active Medical Trust in U.S. Treasury securities. Contributions made with U.S. Treasury securities are considered a non-cash transaction.

## Defined Benefit Pension Plans

In 2025, the company is not legally required to make any contributions to the U.S. defined benefit pension plans. However, depending on market conditions, or other factors, the company may elect to make discretionary contributions to the Qualified PPP during the year.

In 2025, the company estimates contributions to its non-U.S. defined benefit and multi-employer plans to be approximately $100 million, the largest of which will be contributed to defined benefit pension plans in Japan and India. This amount generally represents legally mandated minimum contributions.

Financial market performance in 2025 could increase the legally mandated minimum contribution in certain countries which require monthly or daily remeasurement of the funded status. The company could also elect to contribute more than the legally mandated amount based on market conditions or other factors.

## Expected Benefit Payments

## Defined Benefit Pension Plan Expected Payments

The following table presents the total expected benefit payments to defined benefit pension plan participants subsequent to the retirement plan changes, as described in 'IBM Retirement Plan Changes' section above. These payments have been estimated based on the same assumptions used to measure the plans' PBO at December 31, 2024 and include benefits attributable to estimated future compensation increases, where applicable.


|           | ($ in millions)              | ($ in millions)                  | ($ in millions)                   | ($ in millions)                      | ($ in millions)                 |
|-----------|------------------------------|----------------------------------|-----------------------------------|--------------------------------------|---------------------------------|
|           | Qualified U.S. Plan Payments | Nonqualified U.S. Plans Payments | Qualified Non-U.S. Plans Payments | Nonqualified Non-U.S. Plans Payments | Total Expected Benefit Payments |
| 2025      | $  1,136                     | $  121                           | $  1,833                          | $  248                               | $  3,338                        |
| 2026      | 1,178                        | 119                              | 1,760                             | 224                                  | 3,282                           |
| 2027      | 1,214                        | 116                              | 1,749                             | 221                                  | 3,300                           |
| 2028      | 1,202                        | 114                              | 1,710                             | 217                                  | 3,243                           |
| 2029      | 1,186                        | 111                              | 1,705                             | 218                                  | 3,221                           |
| 2030-2034 | 5,671                        | 507                              | 8,049                             | 1,016                                | 15,243                          |

## Notes to the Consolidated Financial Statements

International Business Machines Corporation and Subsidiary Companies

The 2025 expected benefit payments to defined benefit pension plan participants not covered by the respective plan assets (underfunded plans) represent a component of compensation and benefits, within current liabilities, in the Consolidated Balance Sheet.

## Nonpension Postretirement Benefit Plan Expected Payments

The following table presents the total expected benefit payments to nonpension postretirement benefit plan participants. These payments have been estimated based on the same assumptions used to measure the plans' APBO at December 31, 2024.


|           | ($ in millions)    | ($ in millions)                   | ($ in millions)                      | ($ in millions)                 |
|-----------|--------------------|-----------------------------------|--------------------------------------|---------------------------------|
|           | U.S. Plan Payments | Qualified Non-U.S. Plans Payments | Nonqualified Non-U.S. Plans Payments | Total Expected Benefit Payments |
| 2025      | $  230             | $  16                             | $  26                                | $  272                          |
| 2026      | 237                | 17                                | 27                                   | 280                             |
| 2027      | 249                | 18                                | 27                                   | 293                             |
| 2028      | 253                | 18                                | 27                                   | 299                             |
| 2029      | 246                | 19                                | 28                                   | 293                             |
| 2030-2034 | 1,090              | 107                               | 153                                  | 1,350                           |

The 2025 expected benefit payments to nonpension postretirement benefit plan participants not covered by the respective plan assets represent a component of compensation and benefits, within current liabilities, in the Consolidated Balance Sheet.

## Other Plan Information

The following table presents information for defined benefit pension plans with accumulated benefit obligations (ABO) in excess of plan assets. For a more detailed presentation of the funded status of the company's defined benefit pension plans, refer to the table on page 112.


| ($ in millions)                                         | ($ in millions)    | ($ in millions)                  | ($ in millions)            | ($ in millions)            |
|---------------------------------------------------------|--------------------|----------------------------------|----------------------------|----------------------------|
|                                                         |                    |                                  | 18,345 18,029 36,369 2,820 | 18,345 18,029 36,369 2,820 |
| At December 31: Plans with PBO in excess of plan assets | Benefit Obligation | Plan Assets Benefit Obligation $ |                            |                            |
|                                                         | $  16,216          | $  8,811                         | $                          | $                          |
|                                                         | 16,194 26,493      | 8,789  33,985                    | 9,604                      | 9,604                      |

The following table presents information for the nonpension postretirement benefit plan with APBO in excess of plan assets. For a more detailed presentation of the funded status of the company's nonpension postretirement benefit plans, refer to the table on page 112.


|                                          | ($ in millions) 2024   | ($ in millions) 2024   | ($ in millions) 2024   | ($ in millions) 2024   | ($ in millions) 2024   |
|------------------------------------------|------------------------|------------------------|------------------------|------------------------|------------------------|
|                                          |                        |                        |                        |                        |                        |
| At December 31:                          |                        | Benefit Obligation     | Plan Assets            | Benefit Obligation     |                        |
| Plans with APBO in excess of plan assets |                        | $  2,764               | 20                     | $                      | $  2,820               |
| Plans with plan assets in excess of APBO |                        | -                      |                        | -                      | -                      |

## NOTE V. SUBSEQUENT EVENTS

On January 28, 2025, the company announced that the Board of Directors approved a quarterly dividend of $1.67 per common share. The dividend is payable March 10, 2025 to stockholders of record on February 10, 2025.

On February 10, 2025, the company issued $3.6 billion of Euro fixed-rate notes in tranches with maturities ranging from 5 to 20 years and coupons ranging from 2.9 to 3.8 percent; and $4.75 billion of U.S. dollar fixed-rate notes in tranches with maturities ranging from 3 to 30 years and coupons ranging from 4.65 to 5.7 percent.

## 122 Performance Graphs

International Business Machines Corporation and Subsidiary Companies

## COMPARISON OF ONE-, THREE- AND FIVE-YEAR CUMULATIVE TOTAL RETURN FOR IBM, S&P 500 STOCK INDEX AND S&P INFORMATION TECHNOLOGY INDEX

The following graphs compare the one-, three- and five-year cumulative total returns for IBM common stock with the comparable cumulative returns of certain Standard & Poor's (S&P) indices. Due to the fact that IBM is a company included in the S&P 500 Stock Index, the SEC's rules require the use of that index for the required five-year graph. Under those rules, the second index used for comparison may be a published industry or line-of-business index. The S&P Information Technology Index is such an index. IBM is also included in this index.

The graph assumes $100 invested on December 31 (of the initial year shown in the graph) in IBM common stock and $100 invested on the same date in each of the S&P indices. The comparisons assume that all dividends are reinvested. On November 3, 2021, we completed the separation of Kyndryl. IBM stockholders received one share of common stock in Kyndryl for every five shares of IBM common stock held at the close of business on October 25, 2021, the record date for the distribution. The effect of the Kyndryl transaction is reflected in the five-year graph in the cumulative total return as reinvested dividends.

One-Year

Three-Year


<!-- image -->


<!-- image -->


<!-- image -->

## One-Year


| (U.S. Dollar)   | (U.S. Dollar)                   | 12/2023   | 3/2024   | 6/2024   | 9/2024   | 12/2024   |
|-----------------|---------------------------------|-----------|----------|----------|----------|-----------|
| -               | International Business Machines | $ 100.00  | $ 117.81 | $ 107.77 | $ 138.96 | $ 139.27  |
| · · · ·         | S & P 500                       | $ 100.00  | $ 110.56 | $ 115.29 | $ 122.08 | $ 125.02  |
| - - - -         | S & P Information Technology    | $ 100.00  | $ 112.69 | $ 128.24 | $ 130.31 | $ 136.61  |

## Three-Year


| (U.S. Dollar)   | (U.S. Dollar)                   | 2021     | 2022     | 2023     | 2024     |
|-----------------|---------------------------------|----------|----------|----------|----------|
| -               | International Business Machines | $ 100.00 | $ 110.70 | $ 134.92 | $ 187.91 |
| · · · ·         | S & P 500                       | $ 100.00 | $ 81.89  | $ 103.42 | $ 129.29 |
| - - - -         | S & P Information Technology    | $ 100.00 | $ 71.81  | $ 113.34 | $ 154.83 |

## Five-Year


| (U.S. Dollar)   |                                 | 2019     | 2020     | 2021     | 2022     | 2023     | 2024     |
|-----------------|---------------------------------|----------|----------|----------|----------|----------|----------|
| -               | International Business Machines | $ 100.00 | $ 99.04  | $ 115.88 | $ 128.29 | $ 156.35 | $ 217.76 |
| · · · ·         | S & P 500                       | $ 100.00 | $ 118.40 | $ 152.39 | $ 124.79 | $ 157.59 | $ 197.02 |
| - - - -         | S & P Information Technology    | $ 100.00 | $ 143.89 | $ 193.58 | $ 139.00 | $ 219.40 | $ 299.72 |

## Stockholder Information

International Business Machines Corporation and Subsidiary Companies

## IBM Stockholder Services

Stockholders with questions about their accounts should contact:

Computershare Trust Company, N.A., P.O. Box 43078, Providence, Rhode Island 02940-3078, (888) IBM-6700.

Investors residing outside the United States, Canada and Puerto Rico should call (781) 575-2727.

Stockholders can also reach Computershare Trust Company, N.A. via e-mail at: ibm@computershare.com

Hearing-impaired stockholders with access to a telecommunications device (TDD) can communicate directly with Computershare Trust Company, N.A., by calling (800) 490-1493. Stockholders residing outside the United States, Canada and Puerto Rico should call (781) 575-2694.

## IBM on the Internet

Topics featured in this Annual Report can be found online at www.ibm.com. Financial results, news on IBM products, services and other activities can also be found at that website.

IBM files reports with the Securities and Exchange Commission (SEC), including the annual report on Form 10-K, quarterly reports on Form 10-Q, current reports on Form 8-K and any other filings required by the SEC.

IBM's website (www.ibm.com/investor) contains a significant amount of information about IBM, including the company's annual report on Form 10-K, quarterly reports on Form 10-Q, current reports on Form 8-K, and all amendments to those reports filed or furnished pursuant to Sections 13(a) and 15(d) of the Securities Exchange Act of 1934 as soon as reasonably practicable after such material is electronically filed with or furnished to the SEC. These materials are available free of charge on or through IBM's website.

The SEC maintains a website (www.sec.gov) that contains reports, proxy and information statements, and other information regarding issuers that file electronically with the SEC.

## Computershare Investment Plan (CIP)

The Computershare Investment Plan brochure outlines a number of services provided for IBM stockholders and potential IBM investors, including the reinvestment of dividends, direct purchase and the deposit of IBM stock certificates for safekeeping. The brochure is available at www.computershare.com/ibmcip or by calling (888) IBM-6700. Investors residing outside the United States, Canada and Puerto Rico should call (781) 575-2727.

Investors with other requests may write to: IBM Stockholder Relations, New Orchard Road, M/D 325, Armonk, New York 10504.

## IBM Stock

IBM common stock is listed on the New York Stock Exchange and the NYSE Chicago under the symbol "IBM".

## Stockholder Communications

Stockholders can get quarterly financial results and voting results from the Annual Meeting by calling (914) 499-7777, by sending an e-mail to infoibm@us.ibm.com, or by writing to IBM Stockholder Relations, New Orchard Road, M/D 325, Armonk, New York 10504.

## Annual Meeting

The IBM Annual Meeting of Stockholders will be held on Tuesday, April 29, 2025, at 1 p.m. (ET).

## Literature for IBM Stockholders

The literature mentioned below on IBM is available without charge from:

Computershare Trust Company, N.A., P.O. Box 43078, Providence, Rhode Island 02940-3078, (888) IBM-6700.

Investors residing outside the United States, Canada and Puerto Rico should call (781) 575-2727.

The company's annual report on Form 10-K and the quarterly reports on Form 10-Q provide additional information on IBM's business. The 10-K report is released by the end of February; 10-Q reports are released by the end of April, July and October.

IBM believes that corporate responsibility drives long-term value not just in our business, but also for IBM stakeholders. Our 2023 Impact Report is available online at https://www.ibm.com/impact.

## General Information

Stockholders of record can receive account information and answers to frequently asked questions regarding stockholder accounts online at www.ibm.com/investor. Stockholders of record can also consent to receive future IBM Annual Reports and Proxy Statements online through this site.

For answers to general questions about IBM from within the continental United States, call (800) IBM-4YOU. From outside the United States, Canada and Puerto Rico, call (914) 499-1900.

## Board of Directors and Senior Leadership

International Business Machines Corporation and Subsidiary Companies

## BOARD OF DIRECTORS

Marianne C. Brown Former Chief Operating Officer Global Financial Solutions, Fidelity National Information Services, Inc.

Thomas Buberl Chief Executive Officer AXA S.A.

David N. Farr Retired Chairman and Chief Executive Officer Emerson Electric Co.

Alex Gorsky Former Chairman and Chief Executive Officer Johnson & Johnson

Michelle J. Howard Retired Admiral United States Navy

## SENIOR LEADERSHIP

Jonathan H. Adashek Senior Vice President Marketing and Communications

Mohamad Ali Senior Vice President IBM Consulting

Kelly C. Chambliss Senior Vice President IBM Consulting, Americas

Gary D. Cohn Vice Chairman

Jane P. Edwards Vice President Assistant General Counsel and Secretary

Nicolás Fehring Vice President and Controller

Darío Gil Senior Vice President and Director IBM Research

Arvind Krishna Chairman, President and Chief Executive Officer IBM

Andrew N. Liveris Retired Chairman and Chief Executive Officer The Dow Chemical Company

Frederick William McNabb III Retired Chairman and Chief Executive Officer The Vanguard Group, Inc.

Michael Miebach Chief Executive Officer Mastercard Incorporated

Martha E. Pollack President Emerita Cornell University

James J. Kavanaugh Senior Vice President and Chief Financial Officer

Arvind Krishna Chairman, President and Chief Executive Officer IBM

Nickle J. LaMoreaux Senior Vice President and Chief Human Resources Officer

Ric Lewis Senior Vice President IBM Infrastructure

Dinesh Nirmal Senior Vice President, Products IBM Software

Anne E. Robinson Senior Vice President and Chief Legal Officer

Peter R. Voser Retired Chief Executive Officer Royal Dutch Shell plc Chairman ABB Ltd.

Frederick H. Waddell Retired Chairman and Chief Executive Officer Northern Trust Corporation

Alfred W. Zollar Former Executive Advisor Siris Capital Group, LLC

Alex Stern Senior Vice President Strategy and Mergers & Acquisitions

Robert D. Thomas Senior Vice President IBM Software and Chief Commercial Officer

Brien Wierzchowski Vice President and Treasurer

Joanne Wright Senior Vice President Transformation and Operations

Kareem Yusuf Senior Vice President Product Management and Growth IBM Software


<!-- image -->

International Business Machines Corporation New Orchard Road Armonk, New York 10504 914-499-1900

Db2, IBM, IBM Cloud, IBM Cloud Pak, IBM Garage, IBM Q Network, IBM Quantum, IBM Z, Instana, Nordcloud, Octo, IBM Partner Plus, Power, Randori, 7Summits, Taos, TruQua, Turbonomic, Waeg, watsonx, WebSphere, z15, z/OS and z Systems are trademarks of International Business Machines Corporation or its wholly owned subsidiaries. Kyndryl is a trademark of Kyndryl, Inc. Azure and Microsoft Edge are trademarks of Microsoft. The registered trademark Linux is used pursuant to a sublicense from the Linux Foundation, the exclusive licensee of Linus Torvalds, owner of the mark on a worldwide basis. Red Hat, Ansible, OpenShift and StackRox are trademarks of Red Hat, Inc. or its subsidiaries in the United States and other countries. UNIX is a registered trademark of The Open Group in the United States and other countries. Other company, product and service names may be trademarks or service marks of others.

The IBM Annual Report is printed on papers harvested to sustainable standards.

Printed in U.S.A. COL03002-USEN-21


<!-- image -->


<!-- image -->