"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaArmFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
class LambdaArmFunction extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.runtime === lambda.Runtime.NODEJS_12_X) {
            cdk.Annotations.of(this).addWarning('You are using Node.js 12.x at ARM');
        }
        else if (props.runtime === lambda.Runtime.NODEJS_14_X) {
            cdk.Annotations.of(this).addWarning('You are using Node.js 14.x at ARM');
        }
        else if (props.runtime === lambda.Runtime.PYTHON_3_8) {
            cdk.Annotations.of(this).addWarning('You are using Python 3.8 at ARM');
        }
        else if (props.runtime === lambda.Runtime.PYTHON_3_9) {
            cdk.Annotations.of(this).addWarning('You are using Python 3.9 at ARM');
        }
        else if (props.runtime === lambda.Runtime.JAVA_8_CORRETTO) {
            cdk.Annotations.of(this).addWarning('You are using Java 8 on al2 at ARM');
        }
        else if (props.runtime === lambda.Runtime.JAVA_11) {
            cdk.Annotations.of(this).addWarning('You are using Java 11 at ARM');
        }
        else if (props.runtime === lambda.Runtime.DOTNET_CORE_3_1) {
            cdk.Annotations.of(this).addWarning('You are using DOTNET CORE 3.1 at ARM');
        }
        else if (props.runtime === lambda.Runtime.RUBY_2_7) {
            cdk.Annotations.of(this).addWarning('You are using RUBY 2.7 at ARM');
        }
        else {
            throw new Error(`Invalid Runtime ${props.runtime} at ARM, See https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html?icmpid=docs_lambda_rss`);
        }
        this.lambdaFunction = new lambda.Function(this, 'LambdaFunction', { architecture: lambda.Architecture.ARM_64, ...props });
    }
}
exports.LambdaArmFunction = LambdaArmFunction;
_a = JSII_RTTI_SYMBOL_1;
LambdaArmFunction[_a] = { fqn: "cdk-common.LambdaArmFunction", version: "1.0.874" };
//# sourceMappingURL=data:application/json;base64,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