from importlib.metadata import (
    version as __version,
)

from .abi import (
    abi_to_signature,
    collapse_if_tuple,
    event_abi_to_log_topic,
    event_signature_to_log_topic,
    filter_abi_by_name,
    filter_abi_by_type,
    function_abi_to_4byte_selector,
    function_signature_to_4byte_selector,
    get_abi_input_names,
    get_abi_input_types,
    get_abi_output_names,
    get_abi_output_types,
    get_aligned_abi_inputs,
    get_all_event_abis,
    get_all_function_abis,
    get_normalized_abi_inputs,
)
from .address import (
    is_address,
    is_binary_address,
    is_canonical_address,
    is_checksum_address,
    is_checksum_formatted_address,
    is_hex_address,
    is_normalized_address,
    is_same_address,
    to_canonical_address,
    to_checksum_address,
    to_normalized_address,
)
from .applicators import (
    apply_formatter_at_index,
    apply_formatter_if,
    apply_formatter_to_array,
    apply_formatters_to_dict,
    apply_formatters_to_sequence,
    apply_key_map,
    apply_one_of_formatters,
    combine_argument_formatters,
)
from .conversions import (
    hexstr_if_str,
    text_if_str,
    to_bytes,
    to_hex,
    to_int,
    to_text,
)
from .crypto import (
    keccak,
)
from .currency import (
    denoms,
    from_wei,
    from_wei_decimals,
    to_wei,
    to_wei_decimals,
)
from .decorators import (
    combomethod,
    replace_exceptions,
)
from .encoding import (
    big_endian_to_int,
    int_to_big_endian,
)
from .exceptions import (
    ValidationError,
)
from .functional import (
    apply_to_return_value,
    flatten_return,
    reversed_return,
    sort_return,
    to_dict,
    to_list,
    to_ordered_dict,
    to_set,
    to_tuple,
)
from .hexadecimal import (
    add_0x_prefix,
    decode_hex,
    encode_hex,
    is_0x_prefixed,
    is_hex,
    is_hexstr,
    remove_0x_prefix,
)
from .humanize import (
    humanize_bytes,
    humanize_hash,
    humanize_hexstr,
    humanize_integer_sequence,
    humanize_ipfs_uri,
    humanize_seconds,
    humanize_wei,
)
from .logging import (
    DEBUG2_LEVEL_NUM,
    ExtendedDebugLogger,
    HasExtendedDebugLogger,
    HasExtendedDebugLoggerMeta,
    HasLogger,
    HasLoggerMeta,
    get_extended_debug_logger,
    get_logger,
    setup_DEBUG2_logging,
)
from .module_loading import (
    import_string,
)
from .network import (
    Network,
    name_from_chain_id,
    network_from_chain_id,
    short_name_from_chain_id,
)
from .numeric import (
    clamp,
)
from .pydantic import (
    CamelModel,
)
from .types import (
    is_boolean,
    is_bytes,
    is_dict,
    is_integer,
    is_list,
    is_list_like,
    is_null,
    is_number,
    is_string,
    is_text,
    is_tuple,
)

__version__ = __version("faster-eth-utils")
