# Generated by Django 3.1.5 on 2021-01-25 16:28

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("eveuniverse", "0004_effect_longer_name"),
        ("memberaudit", "0003_stats_n_skillset_autocomplete"),
    ]

    operations = [
        migrations.AlterField(
            model_name="characterupdatestatus",
            name="section",
            field=models.CharField(
                choices=[
                    ("assets", "assets"),
                    ("character_details", "character details"),
                    ("contacts", "contacts"),
                    ("contracts", "contracts"),
                    ("corporation_history", "corporation history"),
                    ("implants", "implants"),
                    ("jump_clones", "jump clones"),
                    ("location", "location"),
                    ("loyalty", "loyalty"),
                    ("mails", "mails"),
                    ("online_status", "online status"),
                    ("skills", "skills"),
                    ("skill_queue", "skill queue"),
                    ("skill_sets", "skill sets"),
                    ("wallet_balance", "wallet balance"),
                    ("wallet_journal", "wallet journal"),
                    ("wallet_transactions", "wallet transactions"),
                ],
                db_index=True,
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="characterwalletjournalentry",
            name="entry_id",
            field=models.PositiveBigIntegerField(db_index=True),
        ),
        migrations.CreateModel(
            name="CharacterWalletTransaction",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("transaction_id", models.PositiveBigIntegerField(db_index=True)),
                ("date", models.DateTimeField()),
                ("is_buy", models.BooleanField()),
                ("is_personal", models.BooleanField()),
                ("quantity", models.PositiveIntegerField()),
                ("unit_price", models.DecimalField(decimal_places=2, max_digits=17)),
                (
                    "character",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="wallet_transactions",
                        to="memberaudit.character",
                    ),
                ),
                (
                    "client",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.evetype",
                    ),
                ),
                (
                    "journal_ref",
                    models.OneToOneField(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="wallet_transaction",
                        to="memberaudit.characterwalletjournalentry",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="memberaudit.location",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.AddConstraint(
            model_name="characterwallettransaction",
            constraint=models.UniqueConstraint(
                fields=("character", "transaction_id"),
                name="functional_pk_characterwallettransactions",
            ),
        ),
    ]
