# ❓ Why Janito? The Power of Prompt and Tool Flexibility

Janito is designed to give you maximum control over how AI assists you with your codebase. Unlike tools tightly coupled with a specific IDE, Janito’s flexible system prompt and tool configuration offer unique advantages:

## 🎯 Benefits of Adjustable System Prompts

- 📝 **Tailor the Assistant’s Perspective:** By editing the system prompt, you can instruct the AI to focus on what matters most—UI/UX, backend logic, architecture, or even documentation style.
- 🔄 **Adapt to Different Tasks:** Switch between reviewing code for bugs, generating documentation, or brainstorming features simply by changing the prompt.
- 👀 **Guide the Model’s Focus:** A prompt like “You are a UI/UX expert” will make the model prioritize interface concerns, while “Focus on code structure and algorithms” will drive it to analyze raw code logic.

## 🧩 Flexible Tools vs. IDE-Coupled Plugins

- 💻 **Not Locked to an Editor:** Janito works in the terminal, scripts, or web—no need for a heavyweight IDE or plugin ecosystem.
- 🧰 **Composable and Extensible:** Tools can be enabled, disabled, or customized for each session, letting you experiment or automate workflows.
- 🕒 **Session-Scoped Adjustments:** Session-based overrides (via CLI options or prompt tweaks) let you try new approaches without changing your global setup.

## 🧑‍💻 Example: Prompt-Driven Focus

- A prompt like:
  > “You are a code reviewer. Focus on accessibility and UI clarity.”
  will make the model highlight interface and user experience issues.

- Change the prompt to:
  > “You are a backend architect. Ignore UI, focus on data flow and performance.”
  and the model will shift its analysis accordingly.

## 🏁 Summary

Janito’s decoupled, prompt-driven approach empowers you to get the AI help you need, where and how you want it—without being boxed in by IDE limitations or rigid workflows.
