# Code Generation Observability

## Overview

Code Generation Observability is a feature that provides users with transparent, step-by-step visibility into the assistant's code search, analysis, and generation process. This allows users to:

- See which files, lines, and patterns are being searched.
- Observe the assistant's inference and workflow as it investigates issues or implements features.
- Intervene or redirect the assistant by providing feedback at each step, improving the quality and relevance of the results.

## Benefits

- **Transparency:** Users understand how results are produced.
- **Debuggability:** Easier to spot where misunderstandings or errors occur.
- **Control:** Users can guide the assistant more effectively.

## Example Workflow

When investigating a problem (e.g., a missing keyboard shortcut), the assistant will:

1. Search for relevant keywords or patterns in the codebase.
2. Display search results, including file names and matching lines.
3. Summarize findings and request user input if multiple directions are possible.
4. Continue investigation or implementation based on user feedback.

## Screenshot

![Code Generation Observability Example](../imgs/code-generation-observability.png)

---
_generated by janito.dev_
