# ⚡ One-Shot Terminal

If you want to run a single command or prompt in the terminal shell without entering interactive mode, you can use the "one-shot" feature. This is useful for quick tasks or scripting.

To use one-shot mode, simply provide your prompt as a command-line argument:

```
janito "what are the key classes of this project?"
```

Janito will process your request and exit after displaying the result.

### Shell Command Execution

Janito supports executing shell commands in one-shot mode using the built-in `run_bash_command` and `run_powershell_command` tools:

```bash
# Execute a bash command
janito "run_bash_command('ls -la')"

# Execute a PowerShell command  
janito "run_powershell_command('Get-Process | Select-Object Name, CPU')"
```

### Quick Permission Setup

For one-shot mode, you can quickly enable all tool permissions using the `/rwx` prefix:

```bash
# Enable read, write, and execute permissions
janito /rwx "create a python script and run it"

# Or use individual flags
janito -r -w -x "create a python script and run it"
```

> ⚠️ **Warning:** Some models may not complete all required steps in a single-shot (one-off) run. If the model does not act as expected, try appending "; just do it" to your command-line prompt to encourage direct action.

![One-Shot Terminal Shell](../imgs/terminal-one-shot.png)

---
_generated by janito.dev_
