# Janito Documentation

Welcome to the Janito documentation! This site contains comprehensive guides, tutorials, and reference materials for using and extending Janito.

## What is Janito?

Janito is a powerful AI assistant designed for developers, providing intelligent code assistance, terminal integration, and extensible tooling capabilities.

## Quick Start

- [**Installation Guide**](guides/installation.md) - Get Janito up and running
- [**Quickstart & Basic Usage**](guides/using.md) - Learn the basics
- [**Configuration**](guides/configuration.md) - Set up Janito for your needs

## Key Features

- **Terminal Integration**: Seamless shell integration with intelligent command assistance (optimized for Windows Terminal)
- **Shell Command Support**: Built-in bash and PowerShell command execution with live output streaming and security controls
- **Code Intelligence**: Advanced code analysis and generation capabilities
- **Extensible Tools**: Custom tool development and integration
- **Multi-Provider Support**: Works with OpenAI, DeepSeek (including V3.1 and R1), Moonshot, and more
- **Human-Guided AI**: Collaborative AI that works with you, not instead of you

## Documentation Sections

### Using Janito

Learn how to use Janito effectively:

- [Terminal Shell](guides/terminal-shell.md) - Interactive terminal sessions
- [Single-Shot Commands](guides/single-shot-terminal.md) - One-off command execution
- [Profiles](guides/profiles.md) - Custom configurations for different workflows
- [Stock Market Guide](guides/stock-market-guide.md) - Accessing financial market data
- [Market Data Sources](guides/market-data-sources.md) - Reliable sources for financial data


### Development & Extension

For developers looking to extend Janito:

- [Developer Guide](guides/developing.md) - Core development concepts
- [Tools Developer Guide](guides/tools-developer-guide.md) - Creating custom tools
- [Developer Toolchain](meta/developer-toolchain.md) - Development setup and workflows

### Supported Providers

Janito supports multiple AI providers:

- [OpenAI](openai-setup.md)
- [DeepSeek](deepseek-setup.md)
- [Moonshot](moonshot-setup.md)
- [Mistral](mistral-setup.md)
- [Z.ai](z-ai-setup.md)
- [Cerebras](cerebras-setup.md)
- [IBM WatsonX](ibm-setup.md)

### Public Data Sources

- [Government & Public Sources](public-sources.md) - Access to public finance and government data

## Getting Help

- Check our [troubleshooting guides](guides/configuration.md)
- Review [common issues](guides/using.md)
- Explore [alternative solutions](alternatives.md)

---

*This documentation is automatically deployed from the latest commit and will always reflect the most current version of Janito.*