"""IBM WatsonX AI model specifications."""

from janito.llm.model import LLMModelInfo

MODEL_SPECS = {
    "openai/gpt-oss-120b": LLMModelInfo(
        name="openai/gpt-oss-120b",
        context=128000,
        max_input=128000,
        max_response=4096,
        max_cot=4096,
        thinking_supported=True,
        category="IBM WatsonX",
    ),
    "ibm/granite-3-8b-instruct": LLMModelInfo(
        name="ibm/granite-3-8b-instruct",
        context=128000,
        max_input=128000,
        max_response=4096,
        max_cot=4096,
        thinking_supported=False,
        category="IBM WatsonX",
    ),
    "ibm/granite-3-3-8b-instruct": LLMModelInfo(
        name="ibm/granite-3-3-8b-instruct",
        context=128000,
        max_input=128000,
        max_response=4096,
        max_cot=4096,
        thinking_supported=False,
        category="IBM WatsonX",
    ),
    "meta-llama/llama-3-1-70b-instruct": LLMModelInfo(
        name="meta-llama/llama-3-1-70b-instruct",
        context=128000,
        max_input=128000,
        max_response=4096,
        max_cot=4096,
        thinking_supported=False,
        category="IBM WatsonX",
    ),
    "meta-llama/llama-3-3-70b-instruct": LLMModelInfo(
        name="meta-llama/llama-3-3-70b-instruct",
        context=128000,
        max_input=128000,
        max_response=4096,
        max_cot=4096,
        thinking_supported=False,
        category="IBM WatsonX",
    ),
    "mistralai/mistral-large": LLMModelInfo(
        name="mistralai/mistral-large",
        context=128000,
        max_input=128000,
        max_response=4096,
        max_cot=4096,
        thinking_supported=False,
        category="IBM WatsonX",
    ),
    "mistralai/mistral-large-2407": LLMModelInfo(
        name="mistralai/mistral-large-2407",
        context=128000,
        max_input=128000,
        max_response=4096,
        max_cot=4096,
        thinking_supported=False,
        category="IBM WatsonX",
    ),
    "openai/gpt-oss-120b": LLMModelInfo(
        name="openai/gpt-oss-120b",
        context=128000,
        max_input=128000,
        max_response=4096,
        max_cot=4096,
        thinking_supported=True,
        category="IBM WatsonX",
    ),
    "openai/gpt-oss-20b": LLMModelInfo(
        name="openai/gpt-oss-20b",
        context=128000,
        max_input=128000,
        max_response=4096,
        max_cot=4096,
        thinking_supported=True,
        category="IBM WatsonX",
    ),
}
