from janito.llm.model import LLMModelInfo

MODEL_SPECS = {
    "codestral-latest": LLMModelInfo(
        name="codestral-latest",
        context=256000,
        max_input=250000,
        max_cot="N/A",
        max_response=4096,
        thinking_supported=False,
        default_temp=0.2,
        open="mistral",
        driver="OpenAIModelDriver",
    ),
    "codestral-2405": LLMModelInfo(
        name="codestral-2405",
        context=256000,
        max_input=250000,
        max_cot="N/A",
        max_response=4096,
        thinking_supported=False,
        default_temp=0.2,
        open="mistral",
        driver="OpenAIModelDriver",
    ),
    "mistral-small-latest": LLMModelInfo(
        name="mistral-small-latest",
        context=32000,
        max_input=28000,
        max_cot="N/A",
        max_response=4096,
        thinking_supported=False,
        default_temp=0.7,
        open="mistral",
        driver="OpenAIModelDriver",
    ),
    "mistral-medium-latest": LLMModelInfo(
        name="mistral-medium-latest",
        context=32000,
        max_input=28000,
        max_cot="N/A",
        max_response=4096,
        thinking_supported=False,
        default_temp=0.7,
        open="mistral",
        driver="OpenAIModelDriver",
    ),
    "mistral-large-latest": LLMModelInfo(
        name="mistral-large-latest",
        context=128000,
        max_input=120000,
        max_cot="N/A",
        max_response=4096,
        thinking_supported=False,
        default_temp=0.7,
        open="mistral",
        driver="OpenAIModelDriver",
    ),
    "devstral-small-latest": LLMModelInfo(
        name="devstral-small-latest",
        context=128000,
        max_input=120000,
        max_cot="N/A",
        max_response=4096,
        thinking_supported=False,
        default_temp=0.7,
        open="mistral",
        driver="OpenAIModelDriver",
    ),
    "devstral-medium-latest": LLMModelInfo(
        name="devstral-medium-latest",
        context=128000,
        max_input=120000,
        max_cot="N/A",
        max_response=4096,
        thinking_supported=False,
        default_temp=0.7,
        open="mistral",
        driver="OpenAIModelDriver",
    ),
}
