"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafGeoRestrictRuleGroup = exports.Scope = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const waf = require("aws-cdk-lib/aws-wafv2");
var Scope;
(function (Scope) {
    Scope["GLOBAL"] = "Global";
    Scope["REGIONAL"] = "Regional";
})(Scope || (exports.Scope = Scope = {}));
class WafGeoRestrictRuleGroup extends waf.CfnRuleGroup {
    constructor(scope, id, props) {
        super(scope, id, {
            name: props.name,
            description: 'geo restrict rule group',
            scope: (() => {
                switch (props.scope) {
                    case Scope.GLOBAL:
                        return 'CLOUDFRONT';
                    case Scope.REGIONAL:
                        return 'REGIONAL';
                }
            })(),
            capacity: 10,
            rules: (() => {
                const defaults = [
                    {
                        priority: 4,
                        name: 'allow-geo-rule',
                        action: {
                            allow: {},
                        },
                        visibilityConfig: {
                            cloudWatchMetricsEnabled: true,
                            sampledRequestsEnabled: true,
                            metricName: 'AllowGeoRule',
                        },
                        statement: {
                            geoMatchStatement: {
                                countryCodes: props.allowCountries,
                            },
                        },
                    },
                    {
                        priority: 5,
                        name: 'deny-geo-rule',
                        action: {
                            block: {
                                CustomResponse: {
                                    CustomResponseBodyKey: 'geo-restrict',
                                    ResponseCode: 403,
                                },
                            },
                        },
                        visibilityConfig: {
                            cloudWatchMetricsEnabled: true,
                            sampledRequestsEnabled: true,
                            metricName: 'DenyGeoRule',
                        },
                        statement: {
                            notStatement: {
                                statement: {
                                    geoMatchStatement: {
                                        countryCodes: props.allowCountries,
                                    },
                                },
                            },
                        },
                    },
                ];
                if (props.ipRateLimiting) {
                    if (props.ipRateLimiting.enable) {
                        if (props.ipRateLimiting.count < 100) {
                            throw new Error('IP rate limiting count value needs to be above 100');
                        }
                        else {
                            const rule = {
                                priority: 2,
                                name: 'ip-rate-limiting-rule',
                                action: {
                                    block: {
                                        CustomResponse: {
                                            CustomResponseBodyKey: 'ip-rate-restrict',
                                            ResponseCode: 429,
                                        },
                                    },
                                },
                                visibilityConfig: {
                                    cloudWatchMetricsEnabled: true,
                                    sampledRequestsEnabled: true,
                                    metricName: 'DenyIpLimitingRule',
                                },
                                statement: {
                                    rateBasedStatement: {
                                        aggregateKeyType: 'IP',
                                        limit: props.ipRateLimiting.count,
                                    },
                                },
                            };
                            defaults.push(rule);
                        }
                    }
                }
                if (props.allowIpSetArn) {
                    const rule = {
                        priority: 0,
                        name: 'allow-ip-set-rule',
                        action: { allow: {} },
                        visibilityConfig: {
                            sampledRequestsEnabled: true,
                            cloudWatchMetricsEnabled: true,
                            metricName: 'AllowIpSetRule',
                        },
                        statement: {
                            ipSetReferenceStatement: {
                                arn: props.allowIpSetArn,
                            },
                        },
                    };
                    defaults.push(rule);
                }
                return defaults;
            })(),
            customResponseBodies: {
                ['geo-restrict']: {
                    contentType: 'TEXT_PLAIN',
                    content: 'Sorry, You Are Not Allowed to Access This Service.',
                },
                ['ip-rate-restrict']: {
                    contentType: 'TEXT_PLAIN',
                    content: 'Sorry, You Are Not Allowed to Access This Service.',
                },
                ['sample-restrict']: {
                    contentType: 'TEXT_PLAIN',
                    content: 'Sorry, You Are Not Allowed to Access This Service.',
                },
            },
            visibilityConfig: {
                cloudWatchMetricsEnabled: true,
                sampledRequestsEnabled: true,
                metricName: 'GeoRestrictRule',
            },
        });
    }
}
exports.WafGeoRestrictRuleGroup = WafGeoRestrictRuleGroup;
_a = JSII_RTTI_SYMBOL_1;
WafGeoRestrictRuleGroup[_a] = { fqn: "@gammarers/aws-waf-geo-restriction-rule-group.WafGeoRestrictRuleGroup", version: "1.4.14" };
//# sourceMappingURL=data:application/json;base64,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