# mypy-boto3-neptune

[![PyPI - mypy-boto3-neptune](https://img.shields.io/pypi/v/mypy-boto3-neptune.svg?color=blue)](https://pypi.org/project/mypy-boto3-neptune)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-neptune.svg?color=blue)](https://pypi.org/project/mypy-boto3-neptune)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Neptune 1.13.6](https://boto3.amazonaws.com/v1/documentation/api/1.13.6/reference/services/neptune.html#Neptune) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-neptune](#mypy-boto3-neptune)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Neptune` service.

```bash
python -m pip install boto3-stubs[neptune]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import neptune
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_neptune as neptune

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("neptune")
client: neptune.NeptuneClient = boto3.client("neptune")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: neptune.NeptuneClient = session.client("neptune")


# Waiters need type annotation on creation
db_instance_available_waiter: neptune.DBInstanceAvailableWaiter = client.get_waiter("db_instance_available")
db_instance_deleted_waiter: neptune.DBInstanceDeletedWaiter = client.get_waiter("db_instance_deleted")

# Paginators need type annotation on creation
describe_db_cluster_parameter_groups_paginator: neptune.DescribeDBClusterParameterGroupsPaginator = client.get_paginator("describe_db_cluster_parameter_groups")
describe_db_cluster_parameters_paginator: neptune.DescribeDBClusterParametersPaginator = client.get_paginator("describe_db_cluster_parameters")
describe_db_cluster_snapshots_paginator: neptune.DescribeDBClusterSnapshotsPaginator = client.get_paginator("describe_db_cluster_snapshots")
describe_db_clusters_paginator: neptune.DescribeDBClustersPaginator = client.get_paginator("describe_db_clusters")
describe_db_engine_versions_paginator: neptune.DescribeDBEngineVersionsPaginator = client.get_paginator("describe_db_engine_versions")
describe_db_instances_paginator: neptune.DescribeDBInstancesPaginator = client.get_paginator("describe_db_instances")
describe_db_parameter_groups_paginator: neptune.DescribeDBParameterGroupsPaginator = client.get_paginator("describe_db_parameter_groups")
describe_db_parameters_paginator: neptune.DescribeDBParametersPaginator = client.get_paginator("describe_db_parameters")
describe_db_subnet_groups_paginator: neptune.DescribeDBSubnetGroupsPaginator = client.get_paginator("describe_db_subnet_groups")
describe_engine_default_parameters_paginator: neptune.DescribeEngineDefaultParametersPaginator = client.get_paginator("describe_engine_default_parameters")
describe_event_subscriptions_paginator: neptune.DescribeEventSubscriptionsPaginator = client.get_paginator("describe_event_subscriptions")
describe_events_paginator: neptune.DescribeEventsPaginator = client.get_paginator("describe_events")
describe_orderable_db_instance_options_paginator: neptune.DescribeOrderableDBInstanceOptionsPaginator = client.get_paginator("describe_orderable_db_instance_options")
describe_pending_maintenance_actions_paginator: neptune.DescribePendingMaintenanceActionsPaginator = client.get_paginator("describe_pending_maintenance_actions")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.