"""BACnet enums."""

__all__ = ["ObjectType", "PropertyIdentifier"]

from enum import Enum


class ObjectType(Enum):
    """ObjectType enumerator."""

    analogInput = 0
    analogOutput = 1
    analogValue = 2
    binaryInput = 3
    binaryOutput = 4
    binaryValue = 5
    calendar = 6
    command = 7
    device = 8
    eventEnrollment = 9
    file = 10
    group = 11
    loop = 12
    multiStateInput = 13
    multiStateOutput = 14
    notificationClass = 15
    program = 16
    schedule = 17
    averaging = 18
    multiStateValue = 19
    trendLog = 20
    lifeSafetyPoint = 21
    lifeSafetyZone = 22
    accumulator = 23
    pulseConverter = 24
    eventLog = 25
    globalGroup = 26
    trendLogMultiple = 27
    loadControl = 28
    structuredView = 29
    accessDoor = 30
    timer = 31
    accessCredential = 32
    accessPoint = 33
    accessRights = 34
    accessUser = 35
    accessZone = 36
    credentialDataInput = 37
    networkSecurity = 38
    bitstringValue = 39
    characterstringValue = 40
    datePatternValue = 41
    dateValue = 42
    datetimePatternValue = 43
    datetimeValue = 44
    integerValue = 45
    largeAnalogValue = 46
    octetstringValue = 47
    positiveIntegerValue = 48
    timePatternValue = 49
    timeValue = 50
    notificationForwarder = 51
    alertEnrollment = 52
    channel = 53
    lightingOutput = 54
    binaryLightingOutput = 55
    networkPort = 56
    elevatorGroup = 57
    escalator = 58
    lift = 59


class PropertyIdentifier(Enum):
    """PropertyIdentifier enumerator."""

    ackedTransitions = 0
    ackRequired = 1
    action = 2
    actionText = 3
    activeText = 4
    activeVtSessions = 5
    alarmValue = 6
    alarmValues = 7
    all = 8
    allWritesSuccessful = 9
    apduSegmentTimeout = 10
    apduTimeout = 11
    applicationSoftwareVersion = 12
    archive = 13
    bias = 14
    changeOfStateCount = 15
    changeOfStateTime = 16
    notificationClass = 17
    controlledVariableReference = 19
    controlledVariableUnits = 20
    controlledVariableValue = 21
    covIncrement = 22
    dateList = 23
    daylightSavingsStatus = 24
    deadband = 25
    derivativeConstant = 26
    derivativeConstantUnits = 27
    description = 28
    descriptionOfHalt = 29
    deviceAddressBinding = 30
    deviceType = 31
    effectivePeriod = 32
    elapsedActiveTime = 33
    errorLimit = 34
    eventEnable = 35
    eventState = 36
    eventType = 37
    exceptionSchedule = 38
    faultValues = 39
    feedbackValue = 40
    fileAccessMethod = 41
    fileSize = 42
    fileType = 43
    firmwareRevision = 44
    highLimit = 45
    inactiveText = 46
    inProcess = 47
    instanceOf = 48
    integralConstant = 49
    integralConstantUnits = 50
    limitEnable = 52
    listOfGroupMembers = 53
    listOfObjectPropertyReferences = 54
    localDate = 56
    localTime = 57
    location = 58
    lowLimit = 59
    manipulatedVariableReference = 60
    maximumOutput = 61
    maxApduLengthAccepted = 62
    maxInfoFrames = 63
    maxMaster = 64
    maxPresValue = 65
    minimumOffTime = 66
    minimumOnTime = 67
    minimumOutput = 68
    minPresValue = 69
    modelName = 70
    modificationDate = 71
    notifyType = 72
    numberOfApduRetries = 73
    numberOfStates = 74
    objectIdentifier = 75
    objectList = 76
    objectName = 77
    objectPropertyReference = 78
    objectType = 79
    optional = 80
    outOfService = 81
    outputUnits = 82
    eventParameters = 83
    polarity = 84
    presentValue = 85
    priority = 86
    priorityArray = 87
    priorityForWriting = 88
    processIdentifier = 89
    programChange = 90
    programLocation = 91
    programState = 92
    proportionalConstant = 93
    proportionalConstantUnits = 94
    protocolObjectTypesSupported = 96
    protocolServicesSupported = 97
    protocolVersion = 98
    readOnly = 99
    reasonForHalt = 100
    recipientList = 102
    reliability = 103
    relinquishDefault = 104
    required = 105
    resolution = 106
    segmentationSupported = 107
    setpoint = 108
    setpointReference = 109
    stateText = 110
    statusFlags = 111
    systemStatus = 112
    timeDelay = 113
    timeOfActiveTimeReset = 114
    timeOfStateCountReset = 115
    timeSynchronizationRecipients = 116
    units = 117
    updateInterval = 118
    utcOffset = 119
    vendorIdentifier = 120
    vendorName = 121
    vtClassesSupported = 122
    weeklySchedule = 123
    attemptedSamples = 124
    averageValue = 125
    bufferSize = 126
    clientCovIncrement = 127
    covResubscriptionInterval = 128
    eventTimeStamps = 130
    logBuffer = 131
    logDeviceObjectProperty = 132
    enable = 133
    logInterval = 134
    maximumValue = 135
    minimumValue = 136
    notificationThreshold = 137
    protocolRevision = 139
    recordsSinceNotification = 140
    recordCount = 141
    startTime = 142
    stopTime = 143
    stopWhenFull = 144
    totalRecordCount = 145
    validSamples = 146
    windowInterval = 147
    windowSamples = 148
    maximumValueTimestamp = 149
    minimumValueTimestamp = 150
    varianceValue = 151
    activeCovSubscriptions = 152
    backupFailureTimeout = 153
    configurationFiles = 154
    databaseRevision = 155
    directReading = 156
    lastRestoreTime = 157
    maintenanceRequired = 158
    memberOf = 159
    mode = 160
    operationExpected = 161
    setting = 162
    silenced = 163
    trackingValue = 164
    zoneMembers = 165
    lifeSafetyAlarmValues = 166
    maxSegmentsAccepted = 167
    profileName = 168
    autoSlaveDiscovery = 169
    manualSlaveAddressBinding = 170
    slaveAddressBinding = 171
    slaveProxyEnable = 172
    lastNotifyRecord = 173
    scheduleDefault = 174
    acceptedModes = 175
    adjustValue = 176
    count = 177
    countBeforeChange = 178
    countChangeTime = 179
    covPeriod = 180
    inputReference = 181
    limitMonitoringInterval = 182
    loggingObject = 183
    loggingRecord = 184
    prescale = 185
    pulseRate = 186
    scale = 187
    scaleFactor = 188
    updateTime = 189
    valueBeforeChange = 190
    valueSet = 191
    valueChangeTime = 192
    alignIntervals = 193
    intervalOffset = 195
    lastRestartReason = 196
    loggingType = 197
    restartNotificationRecipients = 202
    timeOfDeviceRestart = 203
    timeSynchronizationInterval = 204
    trigger = 205
    utcTimeSynchronizationRecipients = 206
    nodeSubtype = 207
    nodeType = 208
    structuredObjectList = 209
    subordinateAnnotations = 210
    subordinateList = 211
    actualShedLevel = 212
    dutyWindow = 213
    expectedShedLevel = 214
    fullDutyBaseline = 215
    requestedShedLevel = 218
    shedDuration = 219
    shedLevelDescriptions = 220
    shedLevels = 221
    stateDescription = 222
    doorAlarmState = 226
    doorExtendedPulseTime = 227
    doorMembers = 228
    doorOpenTooLongTime = 229
    doorPulseTime = 230
    doorStatus = 231
    doorUnlockDelayTime = 232
    lockStatus = 233
    maskedAlarmValues = 234
    securedStatus = 235
    absenteeLimit = 244
    accessAlarmEvents = 245
    accessDoors = 246
    accessEvent = 247
    accessEventAuthenticationFactor = 248
    accessEventCredential = 249
    accessEventTime = 250
    accessTransactionEvents = 251
    accompaniment = 252
    accompanimentTime = 253
    activationTime = 254
    activeAuthenticationPolicy = 255
    assignedAccessRights = 256
    authenticationFactors = 257
    authenticationPolicyList = 258
    authenticationPolicyNames = 259
    authenticationStatus = 260
    authorizationMode = 261
    belongsTo = 262
    credentialDisable = 263
    credentialStatus = 264
    credentials = 265
    credentialsInZone = 266
    daysRemaining = 267
    entryPoints = 268
    exitPoints = 269
    expirationTime = 270
    extendedTimeEnable = 271
    failedAttemptEvents = 272
    failedAttempts = 273
    failedAttemptsTime = 274
    lastAccessEvent = 275
    lastAccessPoint = 276
    lastCredentialAdded = 277
    lastCredentialAddedTime = 278
    lastCredentialRemoved = 279
    lastCredentialRemovedTime = 280
    lastUseTime = 281
    lockout = 282
    lockoutRelinquishTime = 283
    maxFailedAttempts = 285
    members = 286
    musterPoint = 287
    negativeAccessRules = 288
    numberOfAuthenticationPolicies = 289
    occupancyCount = 290
    occupancyCountAdjust = 291
    occupancyCountEnable = 292
    occupancyLowerLimit = 294
    occupancyLowerLimitEnforced = 295
    occupancyState = 296
    occupancyUpperLimit = 297
    occupancyUpperLimitEnforced = 298
    passbackMode = 300
    passbackTimeout = 301
    positiveAccessRules = 302
    reasonForDisable = 303
    supportedFormats = 304
    supportedFormatClasses = 305
    threatAuthority = 306
    threatLevel = 307
    traceFlag = 308
    transactionNotificationClass = 309
    userExternalIdentifier = 310
    userInformationReference = 311
    userName = 317
    userType = 318
    usesRemaining = 319
    zoneFrom = 320
    zoneTo = 321
    accessEventTag = 322
    globalIdentifier = 323
    verificationTime = 326
    baseDeviceSecurityPolicy = 327
    distributionKeyRevision = 328
    doNotHide = 329
    keySets = 330
    lastKeyServer = 331
    networkAccessSecurityPolicies = 332
    packetReorderTime = 333
    securityPduTimeout = 334
    securityTimeWindow = 335
    supportedSecurityAlgorithms = 336
    updateKeySetTimeout = 337
    backupAndRestoreState = 338
    backupPreparationTime = 339
    restoreCompletionTime = 340
    restorePreparationTime = 341
    bitMask = 342
    bitText = 343
    isUtc = 344
    groupMembers = 345
    groupMemberNames = 346
    memberStatusFlags = 347
    requestedUpdateInterval = 348
    covuPeriod = 349
    covuRecipients = 350
    eventMessageTexts = 351
    eventMessageTextsConfig = 352
    eventDetectionEnable = 353
    eventAlgorithmInhibit = 354
    eventAlgorithmInhibitRef = 355
    timeDelayNormal = 356
    reliabilityEvaluationInhibit = 357
    faultParameters = 358
    faultType = 359
    localForwardingOnly = 360
    processIdentifierFilter = 361
    subscribedRecipients = 362
    portFilter = 363
    authorizationExemptions = 364
    allowGroupDelayInhibit = 365
    channelNumber = 366
    controlGroups = 367
    executionDelay = 368
    lastPriority = 369
    writeStatus = 370
    propertyList = 371
    serialNumber = 372
    blinkWarnEnable = 373
    defaultFadeTime = 374
    defaultRampRate = 375
    defaultStepIncrement = 376
    egressTime = 377
    inProgress = 378
    instantaneousPower = 379
    lightingCommand = 380
    lightingCommandDefaultPriority = 381
    maxActualValue = 382
    minActualValue = 383
    power = 384
    transition = 385
    egressActive = 386
    interfaceValue = 387
    faultHighLimit = 388
    faultLowLimit = 389
    lowDiffLimit = 390
    strikeCount = 391
    timeOfStrikeCountReset = 392
    defaultTimeout = 393
    initialTimeout = 394
    lastStateChange = 395
    stateChangeValues = 396
    timerRunning = 397
    timerState = 398
    apduLength = 399
    ipAddress = 400
    ipDefaultGateway = 401
    ipDhcpEnable = 402
    ipDhcpLeaseTime = 403
    ipDhcpLeaseTimeRemaining = 404
    ipDhcpServer = 405
    ipDnsServer = 406
    bacnetIpGlobalAddress = 407
    bacnetIpMode = 408
    bacnetIpMulticastAddress = 409
    bacnetIpNatTraversal = 410
    ipSubnetMask = 411
    bacnetIpUdpPort = 412
    bbmdAcceptFdRegistrations = 413
    bbmdBroadcastDistributionTable = 414
    bbmdForeignDeviceTable = 415
    changesPending = 416
    command = 417
    fdBbmdAddress = 418
    fdSubscriptionLifetime = 419
    linkSpeed = 420
    linkSpeeds = 421
    linkSpeedAutonegotiate = 422
    macAddress = 423
    networkInterfaceName = 424
    networkNumber = 425
    networkNumberQuality = 426
    networkType = 427
    routingTable = 428
    virtualMacAddressTable = 429
    commandTimeArray = 430
    currentCommandPriority = 431
    lastCommandTime = 432
    valueSource = 433
    valueSourceArray = 434
    bacnetIpv6Mode = 435
    ipv6Address = 436
    ipv6PrefixLength = 437
    bacnetIpv6UdpPort = 438
    ipv6DefaultGateway = 439
    bacnetIpv6MulticastAddress = 440
    ipv6DnsServer = 441
    ipv6AutoAddressingEnable = 442
    ipv6DhcpLeaseTime = 443
    ipv6DhcpLeaseTimeRemaining = 444
    ipv6DhcpServer = 445
    ipv6ZoneIndex = 446
    assignedLandingCalls = 447
    carAssignedDirection = 448
    carDoorCommand = 449
    carDoorStatus = 450
    carDoorText = 451
    carDoorZone = 452
    carDriveStatus = 453
    carLoad = 454
    carLoadUnits = 455
    carMode = 456
    carMovingDirection = 457
    carPosition = 458
    elevatorGroup = 459
    energyMeter = 460
    energyMeterRef = 461
    escalatorMode = 462
    faultSignals = 463
    floorText = 464
    groupId = 465
    groupMode = 467
    higherDeck = 468
    installationId = 469
    landingCalls = 470
    landingCallControl = 471
    landingDoorStatus = 472
    lowerDeck = 473
    machineRoomId = 474
    makingCarCall = 475
    nextStoppingFloor = 476
    operationDirection = 477
    passengerAlarm = 478
    powerMode = 479
    registeredCarCall = 480
    activeCovMultipleSubscriptions = 481
    protocolLevel = 482
    referencePort = 483
    deployedProfileLocation = 484
    profileLocation = 485
    tags = 486
    subordinateNodeTypes = 487
    subordinateTags = 488
    subordinateRelationships = 489
    defaultSubordinateRelationship = 490
    represents = 491
