# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev6
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from synctera_client import schemas  # noqa: F401


class OutgoingAchRequest(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Send an ACH
    """


    class MetaOapg:
        required = {
            "amount",
            "dc_sign",
            "originating_account_id",
            "receiving_account_id",
            "currency",
            "customer_id",
        }
        
        class properties:
            amount = schemas.IntSchema
            currency = schemas.StrSchema
            customer_id = schemas.UUIDSchema
            
            
            class dc_sign(
                schemas.EnumBase,
                schemas.StrSchema
            ):
                
                @schemas.classproperty
                def DEBIT(cls):
                    return cls("debit")
                
                @schemas.classproperty
                def CREDIT(cls):
                    return cls("credit")
            originating_account_id = schemas.UUIDSchema
            receiving_account_id = schemas.UUIDSchema
            
            
            class company_entry_description(
                schemas.StrSchema
            ):
                pass
            effective_date = schemas.DateSchema
            external_data = schemas.DictSchema
            final_customer_id = schemas.UUIDSchema
        
            @staticmethod
            def hold() -> typing.Type['AchRequestHoldData']:
                return AchRequestHoldData
            id = schemas.UUIDSchema
            is_same_day = schemas.BoolSchema
            memo = schemas.StrSchema
            reference_info = schemas.StrSchema
        
            @staticmethod
            def risk() -> typing.Type['RiskData']:
                return RiskData
            __annotations__ = {
                "amount": amount,
                "currency": currency,
                "customer_id": customer_id,
                "dc_sign": dc_sign,
                "originating_account_id": originating_account_id,
                "receiving_account_id": receiving_account_id,
                "company_entry_description": company_entry_description,
                "effective_date": effective_date,
                "external_data": external_data,
                "final_customer_id": final_customer_id,
                "hold": hold,
                "id": id,
                "is_same_day": is_same_day,
                "memo": memo,
                "reference_info": reference_info,
                "risk": risk,
            }
    
    amount: MetaOapg.properties.amount
    dc_sign: MetaOapg.properties.dc_sign
    originating_account_id: MetaOapg.properties.originating_account_id
    receiving_account_id: MetaOapg.properties.receiving_account_id
    currency: MetaOapg.properties.currency
    customer_id: MetaOapg.properties.customer_id
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["currency"]) -> MetaOapg.properties.currency: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["customer_id"]) -> MetaOapg.properties.customer_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dc_sign"]) -> MetaOapg.properties.dc_sign: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["originating_account_id"]) -> MetaOapg.properties.originating_account_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["receiving_account_id"]) -> MetaOapg.properties.receiving_account_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["company_entry_description"]) -> MetaOapg.properties.company_entry_description: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["effective_date"]) -> MetaOapg.properties.effective_date: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["external_data"]) -> MetaOapg.properties.external_data: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["final_customer_id"]) -> MetaOapg.properties.final_customer_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["hold"]) -> 'AchRequestHoldData': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["is_same_day"]) -> MetaOapg.properties.is_same_day: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["memo"]) -> MetaOapg.properties.memo: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["reference_info"]) -> MetaOapg.properties.reference_info: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["risk"]) -> 'RiskData': ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["amount", "currency", "customer_id", "dc_sign", "originating_account_id", "receiving_account_id", "company_entry_description", "effective_date", "external_data", "final_customer_id", "hold", "id", "is_same_day", "memo", "reference_info", "risk", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["currency"]) -> MetaOapg.properties.currency: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["customer_id"]) -> MetaOapg.properties.customer_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dc_sign"]) -> MetaOapg.properties.dc_sign: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["originating_account_id"]) -> MetaOapg.properties.originating_account_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["receiving_account_id"]) -> MetaOapg.properties.receiving_account_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["company_entry_description"]) -> typing.Union[MetaOapg.properties.company_entry_description, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["effective_date"]) -> typing.Union[MetaOapg.properties.effective_date, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["external_data"]) -> typing.Union[MetaOapg.properties.external_data, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["final_customer_id"]) -> typing.Union[MetaOapg.properties.final_customer_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["hold"]) -> typing.Union['AchRequestHoldData', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> typing.Union[MetaOapg.properties.id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["is_same_day"]) -> typing.Union[MetaOapg.properties.is_same_day, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["memo"]) -> typing.Union[MetaOapg.properties.memo, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["reference_info"]) -> typing.Union[MetaOapg.properties.reference_info, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["risk"]) -> typing.Union['RiskData', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["amount", "currency", "customer_id", "dc_sign", "originating_account_id", "receiving_account_id", "company_entry_description", "effective_date", "external_data", "final_customer_id", "hold", "id", "is_same_day", "memo", "reference_info", "risk", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        amount: typing.Union[MetaOapg.properties.amount, decimal.Decimal, int, ],
        dc_sign: typing.Union[MetaOapg.properties.dc_sign, str, ],
        originating_account_id: typing.Union[MetaOapg.properties.originating_account_id, str, uuid.UUID, ],
        receiving_account_id: typing.Union[MetaOapg.properties.receiving_account_id, str, uuid.UUID, ],
        currency: typing.Union[MetaOapg.properties.currency, str, ],
        customer_id: typing.Union[MetaOapg.properties.customer_id, str, uuid.UUID, ],
        company_entry_description: typing.Union[MetaOapg.properties.company_entry_description, str, schemas.Unset] = schemas.unset,
        effective_date: typing.Union[MetaOapg.properties.effective_date, str, date, schemas.Unset] = schemas.unset,
        external_data: typing.Union[MetaOapg.properties.external_data, dict, frozendict.frozendict, schemas.Unset] = schemas.unset,
        final_customer_id: typing.Union[MetaOapg.properties.final_customer_id, str, uuid.UUID, schemas.Unset] = schemas.unset,
        hold: typing.Union['AchRequestHoldData', schemas.Unset] = schemas.unset,
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, schemas.Unset] = schemas.unset,
        is_same_day: typing.Union[MetaOapg.properties.is_same_day, bool, schemas.Unset] = schemas.unset,
        memo: typing.Union[MetaOapg.properties.memo, str, schemas.Unset] = schemas.unset,
        reference_info: typing.Union[MetaOapg.properties.reference_info, str, schemas.Unset] = schemas.unset,
        risk: typing.Union['RiskData', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'OutgoingAchRequest':
        return super().__new__(
            cls,
            *_args,
            amount=amount,
            dc_sign=dc_sign,
            originating_account_id=originating_account_id,
            receiving_account_id=receiving_account_id,
            currency=currency,
            customer_id=customer_id,
            company_entry_description=company_entry_description,
            effective_date=effective_date,
            external_data=external_data,
            final_customer_id=final_customer_id,
            hold=hold,
            id=id,
            is_same_day=is_same_day,
            memo=memo,
            reference_info=reference_info,
            risk=risk,
            _configuration=_configuration,
            **kwargs,
        )

from synctera_client.model.ach_request_hold_data import AchRequestHoldData
from synctera_client.model.risk_data import RiskData
