# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev6
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from synctera_client import schemas  # noqa: F401


class TransferResponse(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """


    class MetaOapg:
        required = {
            "country_code",
            "created_time",
            "amount",
            "account_id",
            "last_modified_time",
            "merchant",
            "currency",
            "id",
            "customer_id",
            "type",
            "status",
        }
        
        class properties:
            account_id = schemas.UUIDSchema
            amount = schemas.IntSchema
            country_code = schemas.StrSchema
            created_time = schemas.DateTimeSchema
        
            @staticmethod
            def currency() -> typing.Type['CurrencyCode']:
                return CurrencyCode
            customer_id = schemas.UUIDSchema
            id = schemas.StrSchema
            last_modified_time = schemas.DateTimeSchema
        
            @staticmethod
            def merchant() -> typing.Type['Merchant']:
                return Merchant
            
            
            class status(
                schemas.EnumBase,
                schemas.StrSchema
            ):
                
                @schemas.classproperty
                def SUCCEEDED(cls):
                    return cls("SUCCEEDED")
                
                @schemas.classproperty
                def PENDING(cls):
                    return cls("PENDING")
                
                @schemas.classproperty
                def DECLINED(cls):
                    return cls("DECLINED")
                
                @schemas.classproperty
                def CANCELED(cls):
                    return cls("CANCELED")
                
                @schemas.classproperty
                def UNKNOWN(cls):
                    return cls("UNKNOWN")
        
            @staticmethod
            def type() -> typing.Type['TransferType']:
                return TransferType
            transaction_id = schemas.UUIDSchema
            __annotations__ = {
                "account_id": account_id,
                "amount": amount,
                "country_code": country_code,
                "created_time": created_time,
                "currency": currency,
                "customer_id": customer_id,
                "id": id,
                "last_modified_time": last_modified_time,
                "merchant": merchant,
                "status": status,
                "type": type,
                "transaction_id": transaction_id,
            }
    
    country_code: MetaOapg.properties.country_code
    created_time: MetaOapg.properties.created_time
    amount: MetaOapg.properties.amount
    account_id: MetaOapg.properties.account_id
    last_modified_time: MetaOapg.properties.last_modified_time
    merchant: 'Merchant'
    currency: 'CurrencyCode'
    id: MetaOapg.properties.id
    customer_id: MetaOapg.properties.customer_id
    type: 'TransferType'
    status: MetaOapg.properties.status
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["account_id"]) -> MetaOapg.properties.account_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["country_code"]) -> MetaOapg.properties.country_code: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["created_time"]) -> MetaOapg.properties.created_time: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["currency"]) -> 'CurrencyCode': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["customer_id"]) -> MetaOapg.properties.customer_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["last_modified_time"]) -> MetaOapg.properties.last_modified_time: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["merchant"]) -> 'Merchant': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> 'TransferType': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["transaction_id"]) -> MetaOapg.properties.transaction_id: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["account_id", "amount", "country_code", "created_time", "currency", "customer_id", "id", "last_modified_time", "merchant", "status", "type", "transaction_id", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["account_id"]) -> MetaOapg.properties.account_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["country_code"]) -> MetaOapg.properties.country_code: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["created_time"]) -> MetaOapg.properties.created_time: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["currency"]) -> 'CurrencyCode': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["customer_id"]) -> MetaOapg.properties.customer_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["last_modified_time"]) -> MetaOapg.properties.last_modified_time: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["merchant"]) -> 'Merchant': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> 'TransferType': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["transaction_id"]) -> typing.Union[MetaOapg.properties.transaction_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["account_id", "amount", "country_code", "created_time", "currency", "customer_id", "id", "last_modified_time", "merchant", "status", "type", "transaction_id", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        country_code: typing.Union[MetaOapg.properties.country_code, str, ],
        created_time: typing.Union[MetaOapg.properties.created_time, str, datetime, ],
        amount: typing.Union[MetaOapg.properties.amount, decimal.Decimal, int, ],
        account_id: typing.Union[MetaOapg.properties.account_id, str, uuid.UUID, ],
        last_modified_time: typing.Union[MetaOapg.properties.last_modified_time, str, datetime, ],
        merchant: 'Merchant',
        currency: 'CurrencyCode',
        id: typing.Union[MetaOapg.properties.id, str, ],
        customer_id: typing.Union[MetaOapg.properties.customer_id, str, uuid.UUID, ],
        type: 'TransferType',
        status: typing.Union[MetaOapg.properties.status, str, ],
        transaction_id: typing.Union[MetaOapg.properties.transaction_id, str, uuid.UUID, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'TransferResponse':
        return super().__new__(
            cls,
            *_args,
            country_code=country_code,
            created_time=created_time,
            amount=amount,
            account_id=account_id,
            last_modified_time=last_modified_time,
            merchant=merchant,
            currency=currency,
            id=id,
            customer_id=customer_id,
            type=type,
            status=status,
            transaction_id=transaction_id,
            _configuration=_configuration,
            **kwargs,
        )

from synctera_client.model.currency_code import CurrencyCode
from synctera_client.model.merchant import Merchant
from synctera_client.model.transfer_type import TransferType
