

class ColDesc:
    
    col_name = ""
    col_type = ""
    desc:str = ""
    val_enum = [{}]  #枚举值及说明，
    guanlian_cols = []
    
    def __init__(self,col_name,col_type,desc,val_enum=[{}],guanlian_cols = []):
        self.col_name = col_name
        self.col_type = col_type
        self.desc = desc
        self.val_enum = val_enum
        self.guanlian_cols = guanlian_cols
        
class ClsDict:
    """类别字典"""
        
    qudao_dict = {
        "11": "网上交易",
        "12": "通过POS机交易",
        "13": "通过电话交易",
        "14": "通过热键机交易",
        "15": "通过ATM",
        "16": "通过传真交易",
        "17": "营业场所交易（仅针对证券期货业可疑交易报告）",
        "99": "其他（若选择此项，报告机构应在字段“其他非柜台交易方式"
    }
    qingsuan_dict  = {
        "01": "通过大小额支付系统和超级网银清算的交易",
        "02": "通过银联清算的交易",
        "03": "通过外汇交易系统的交易",
        "04": "金融机构内部交易",
        "05": "通过城市商业银行资金清算中心清算的交易",
        "06": "通过农信银资金清算中心清算的交易",
        "11": "票据清算"
    }
    
    business_type = {
        "A1": "电子银行",
        "A2": "自助终端",
        "A3": "现金",
        "A4": "POS或类似业务",
        "A5": "柜面业务",
        "A6": "理财产品",
        "A7": "票据",
        "A8": "外汇",
        "A9": "跨境业务",
        "A10": "代理业务",
        "A11": "一次性金融业务",
        "A12": "其他银行业务"
    }
    
    cat2 = {
        "01": "ATM他代本",
        "02": "基金类交易",
        "03": "股票类交易",
        "04": "理财类交易",
        "05": "其他投资类交易",
        "06": "对公清算资金入账交易",
        "07": "对私清算资金入账交易",
        "08": "他行对公商户清算资金入账交易",
        "09": "他行对私商户清算资金入账交易",
        "10": "面对面收款",
        "11": "第四方支付",
        "12": "保管箱交易",
        "13": "国结代理行交易",
        "21": "代销贵金属",
        "22": "代销理财",
        "23": "代销基金",
        "31": "国结结算",
        "32": "国结融资",
        "41": "同业本币",
        "42": "同业外币",
        "99": "其他"
    }
    
    cat1 = {
        "00-1": "银行汇票",
        "01-1": "银行承兑汇票",
        "02-1": "商业承兑汇票",
        "03-1": "本票",
        "04-1": "支票",
        "10-1": "银行卡",
        "11-1": "境外银行卡(非柜台方式交易)",
        "12-1": "银行卡（通过POS）",
        "13-1": "银行卡（通过ATM且跨行交易）",
        "14-1": "银行卡（通过ATM且非跨行交易）",
        "15-1": "境外银行卡（非柜台方式交易——通过POS）",
        "16-1": "境外银行卡（非柜台方式交易——通过ATM）",
        "17-1": "境外银行卡（柜台方式交易）",
        "20-1": "网上支付",
        "21-1": "移动支付",
        "30-1": "现金支付",
        "31-1": "汇兑",
        "32-1": "托收承付",
        "33-1": "委托收款",
        "34-1": "定期借记",
        "35-1": "定期贷记",
        "36-1": "国内信用证",
        "51-1": "其他",
        "0001-2": "现金",
        "0002-2": "现金结售汇",
        "0003-2": "现钞兑换",
        "0004-2": "其他现金",
        "0005-2": "境外银行卡(非柜台方式现金交易)",
        "0006-2": "境外银行卡（非柜台方式现金交易--ATM）",
        "0007-2": "境外银行卡（柜台方式现金交易）",
        "0101-2": "信用证",
        "0102-2": "托收",
        "0103-2": "保函",
        "0104-2": "电汇",
        "0105-2": "票汇",
        "0106-2": "信汇",
        "0107-2": "其他非现金支付",
        "0108-2": "境外银行卡(非柜台方式非现金交易)",
        "0109-2": "境外银行卡（非柜台方式非现金交易--ATM）",
        "0110-2": "境外银行卡（非柜台方式非现金交易--POS）",
        "0111-2": "旅行支票",
        "D001-2": "代理西联国际汇款(现金业务)",
        "D002-2": "代理速汇金国际汇款(现金业务)",
        "D003-2": "代理银星速汇国际汇款(现金业务)",
        "D004-2": "代理侨汇通国际汇款(现金业务)",
        "D005-2": "代理Paystone国际汇款(现金业务)",
        "D099-2": "代理其他公司汇款(现金业务)",
        "D101-2": "代理西联国际汇款(非现金业务)",
        "D102-2": "代理速汇金国际汇款(非现金业务)",
        "D103-2": "代理银星速汇国际汇款(非现金业务)",
        "D104-2": "代理侨汇通国际汇款(非现金业务)",
        "D105-2": "代理Paystone国际汇款(非现金业务)",
        "D199-2": "代理其他公司汇款(非现金业务)",
        "E100-1": "人民币账户购汇并转账",
        "E100-2": "人民币账户购汇并转账",
        "E110-1": "外币账户结汇并转账",
        "E110-2": "外币账户结汇并转账",
        "E120-1": "外币间兑换并转账",
        "E120-2": "外币间兑换并转账"
    }
        
    channel_map = {
        "1": "柜面",
        "2": "网银",
        "3": "电话银行",
        "4": "ATM",
        "5": "POS",
        "6": "手机银行",
        "00": "其他自有实体经营场所",
        "01": "其他自有互联网渠道",
        "02": "其他自有自助设备和终端（例如：智能柜台、大额现金机具、移动柜台IPAD、ATM、POS、等）",
        "03": "第三方引流渠道",
        "04": "代理行",
        "9": "其他"
    }
    aml_type = {
        "1001": "柜面无卡存款",
        "1002": "ATM无卡存款",
        "2001": "现金汇款",
        "2002": "货币兑换",
        "3010": "还贷",
        "3013": "部分提前还贷",
        "3014": "全部提前还贷",
        "3015": "贷款平台放贷",
        "3016": "贷款平台还贷",
        "3017": "受托支付",
        "3110": "信用卡消费",
        "3120": "信用卡现金",
        "3160": "信用卡退货",
        "3170": "信用卡还款",
        "3171": "公务卡还款",
        "3201": "数字货币充钱包",
        "3202": "数字货币存银行",
        "3203": "数字货币转账",
        "3204": "数字货币消费",
        "3205": "数字货币付钱",
        "3206": "数字货币收钱",
        "4001": "缴税",
        "4002": "收单交易",
        "4003": "境外ATM查询费",
        "4004": "手续费",
        "4005": "收单交易(数币)",
        "5001": "结汇",
        "5002": "售汇",
        "5003": "套汇",
        "5011": "出售旅行支票",
        "5012": "开外币汇票",
        "5021": "解付外币汇票",
        "5022": "解付旅支",
        "7001": "掉期",
        "6001": "直贴",
        "6002": "贷款放款",
        "6110": "国结-客户汇款",
        "6140": "国结-托收",
        "6170": "国结-信用证",
        "6200": "国结-贸易融资",
        "6370": "国结-国内信用证",
        "6400": "国结-国内贸易融资",
        "8001": "代发工资",
        "8002": "批量代扣",
        "8003": "第三方托管",
        "9001": "第三方支付-消费",
        "9002": "第三方支付-充值",
        "9003": "第三方支付-提现",
        "9004": "第三方支付-转账",
        "9999": "其他",
        "A001": "互金-自资贷-客户账",
        "A002": "互金-自资贷-内部账",
        "B001": "互金-平台贷-客户账",
        "B002": "互金-平台贷-内部账",
        "C001": "互金-联合贷-客户账",
        "C002": "互金-联合贷-内部账",
        "Dxxx": "互金-其他（现场配置）",
        "E001": "睡眠户/久悬户激活",
        "N001": "二三类开户",
        "N002": "二三类销户",
        "N003": "二三类绑定账户",
        "N004": "二三类解除绑定",
        "N005": "二三类修改手机号码",
        "N007": "二三类银联鉴权(发起方)",
        "N008": "二三类银联鉴权(接收方)",
        "N009": "二三类升级",
        "N010": "二三类降级",
        "N101": "数币钱包绑卡",
        "N102": "数币钱包解绑卡",
        "N111": "升级1类数币钱包",
        "N112": "升级2类数币钱包",
        "N113": "升级3类数币钱包",
        "N114": "降级2类数币钱包",
        "N115": "降级3类数币钱包",
        "N116": "降级4类数币钱包",
        "IS401": "托收-客户申请改单",
        "IS402": "托收-免费放单",
        "IS701": "信用证-客户申请改单",
        "IS702": "信用证-免费放单"
    }
    shewai = {
        "1": "货物贸易",
        "121": "纳入海关统计的货物贸易",
        "121010": "一般贸易",
        "121020": "进料加工贸易",
        "121030": "海关特殊监管区域及保税监管场所进出境物流货物",
        "121040": "非货币黄金进出口",
        "121050": "金融性租赁贸易",
        "121060": "接受/提供国家间、国际组织无偿援助和赠送的物资",
        "121070": "国内机构或个人提供无偿援助和赠送的物资/接受华侨、港澳台同胞、外籍华人等捐赠的物资",
        "121080": "边境小额贸易",
        "121090": "对外承包工程货物出口",
        "121100": "外商投资企业作为投资进口设备、物品的支出",
        "121110": "加工贸易进口设备",
        "121990": "其他纳入海关统计的货物贸易",
        "122": "未纳入海关统计的货物贸易",
        "122010": "离岸转手买卖",
        "122020": "未纳入海关统计的非货币黄金",
        "122030": "未纳入海关统计的网络购物",
        "122990": "其他未纳入海关统计的货物贸易",
        "2": "服务贸易",
        "221": "加工服务",
        "221000": "来料加工工缴费收入/出料加工工缴费支出",
        "222": "运输服务",
        "22201": "海运",
        "222011": "涉及我国出口的海洋货运服务",
        "222012": "涉及我国进口的海洋货运服务",
        "222013": "不涉及我国进出口的海洋货运服务",
        "222014": "海运客运",
        "222019": "其他海运服务",
        "22202": "空运",
        "222021": "涉及我国出口的空中货运服务",
        "222022": "涉及我国进口的空中货运服务",
        "222023": "不涉及我国进出口的空中货运服务",
        "222024": "空运客运",
        "222029": "其他空运服务",
        "22203": "其他运输方式",
        "222031": "涉及我国出口的其他运输方式货运服务",
        "222032": "涉及我国进口的其他运输方式货运服务",
        "222033": "不涉及我国进出口的其他运输方式货运服务",
        "222034": "其他运输方式客运",
        "222039": "其他运输方式的其他服务",
        "22204": "邮政及寄递服务",
        "222040": "邮政及寄递服务",
        "223": "旅行",
        "223010": "公务及商务旅行",
        "22302": "私人旅行",
        "223021": "就医及健康相关旅行",
        "223022": "留学及教育相关旅行（一年以上）",
        "223023": "留学及教育相关旅行（一年及一年以下）",
        "223029": "其他私人旅行",
        "224": "建设",
        "224010": "境外建设",
        "224020": "境内建设",
        "225": "保险服务",
        "225010": "寿险",
        "22502": "非人寿险",
        "225021": "为我国出口提供的保险",
        "225022": "为我国进口提供的保险",
        "225029": "其他非寿险",
        "225030": "再保险",
        "225040": "标准化担保服务",
        "225050": "保险辅助服务",
        "226": "金融服务",
        "226000": "金融服务",
        "227": "电信、计算机和信息服务",
        "227010": "电信服务",
        "227020": "计算机服务",
        "227030": "信息服务",
        "228": "其他商业服务",
        "228010": "研发成果转让费及委托研发",
        "22802": "法律、会计、广告等专业和管理咨询服务",
        "228021": "法律服务",
        "228022": "会计服务",
        "228023": "管理咨询和公共关系服务",
        "228024": "广告服务",
        "228025": "展会服务",
        "228026": "市场调查、民意测验服务",
        "22803": "技术服务",
        "228031": "建筑、工程技术服务",
        "228032": "废物处理和防止污染服务",
        "228033": "农业和采矿服务",
        "228039": "其他技术服务",
        "228040": "经营性租赁服务",
        "228050": "货物或服务交易佣金及相关服务",
        "228060": "办事处、代表处等办公经费",
        "228990": "上述未提及的其他商业服务",
        "229": "文化和娱乐服务",
        "229010": "视听和相关服务",
        "229020": "教育服务",
        "229030": "医疗服务",
        "229990": "其他文化和娱乐服务",
        "230": "别处未涵盖的维护和维修服务",
        "230000": "别处未涵盖的维护和维修服务",
        "231": "别处未涵盖的知识产权使用费",
        "231010": "特许和商标使用费",
        "231020": "研发成果使用费",
        "231030": "复制或分销计算机软件许可费",
        "231040": "复制或分销视听及相关产品许可费",
        "231990": "其他知识产权使用费",
        "232": "别处未涵盖的政府货物和服务",
        "232000": "别处未涵盖的政府货物和服务",
        "3": "初次收入（收益）",
        "321": "职工报酬",
        "321000": "职工报酬（工资、薪金和福利）",
        "322": "投资收益",
        "32201": "直接投资股息、红利",
        "322011": "从境外子公司等获得的股息、红利或利润/向境外母公司支付的股息、红利或利润",
        "322012": "从境外母公司获得的股息、红利（持有境外母公司10%以下股权）/向境外子公司等支付的股息、红",
        "322013": "从境外联属企业获得的股息、红利（持股10%以下的关联机构）/向境外联属企业支付的股息、红利",
        "322014": "因拥有境外建筑物而获得的租金/向境内建筑物的非居民所有者支付的租金",
        "32202": "直接投资利息",
        "322021": "从境外子公司获得的利息/向境外母公司支付的利息",
        "322022": "从境外母公司获得的利息（持有境外母公司10%以下股权）/向境外子公司等支付的利息（持有本机",
        "322023": "从境外联属企业获得的利息（持股10%以下的关联机构）/向境外联属企业支付的利息（持股10%以下",
        "32203": "证券投资收益",
        "322031": "股票投资的股息、红利",
        "322032": "投资基金份额的股息、红利",
        "322033": "短期债券利息",
        "322034": "中长期债券利息",
        "32204": "其他投资收益",
        "322041": "存贷款利息",
        "322042": "保单持有人获得的红利和利息/向保单持有者支付的红利和利息",
        "322043": "从准公司（持表决权10%以下）和国际组织（因份额投资）获得的红利、收益/向准公司和国际组织",
        "322049": "其他的其他投资收益",
        "323": "其他初次收入",
        "323010": "使用自然资源的租金",
        "323020": "产品和生产的税收及补贴",
        "4": "二次收入（经常转移）",
        "421": "捐赠和无偿援助",
        "421010": "个人间捐赠及无偿援助",
        "421020": "政府、国际组织间捐赠及无偿援助（与固定资产无关）",
        "421990": "其他捐赠及无偿援助（与固定资产无关）",
        "422000": "非寿险保险赔偿",
        "423": "社会保障",
        "423010": "社保缴款",
        "423020": "社保返还的福利",
        "424000": "其他二次收入（经常转移）",
        "5": "资本账户",
        "521": "资本转移",
        "521010": "债务减免",
        "521020": "与固定资产有关的捐赠及无偿援助",
        "521030": "移民转移",
        "521990": "其他资本转移",
        "522": "非生产非金融资产转让",
        "522000": "品牌、商标、契约和许可所有权等非生产非金融资产转让",
        "6": "直接投资",
        "621": "我国对境外直接投资",
        "62101": "投资资本金",
        "621011": "因境外子公司清算、终止等撤资/新设境外子公司资本金汇出",
        "621012": "筹备资金撤回/筹备资金汇出",
        "621013": "因境外子公司减资收回资金/对境外子公司增资",
        "621014": "转让境外子公司股权收入/购买转让的境外企业股权",
        "621015": "接受境外子公司的股权投资（逆向股权投资）/境外子公司撤回对境内母公司的股权投资（逆向股",
        "621016": "非法人投资款撤回/汇出",
        "62102": "借贷及其他往来",
        "621021": "收回对境外子公司的贷款及其他往来/对境外子公司的贷款及其他往来",
        "621022": "接受境外子公司的贷款及其他往来（逆向贷款投资）/偿还境外子公司的贷款及其他往来（逆向投",
        "621030": "出售境外不动产收入/购买境外不动产支出",
        "62104": "收益再投资",
        "621040": "收益再投资支出",
        "62105": "用境内股权交换境外股权",
        "621050": "用境内股权交换境外股权",
        "62106": "实物投资",
        "621060": "实物投资",
        "62107": "无形资产投资",
        "621070": "无形资产投资",
        "622": "外国来华直接投资",
        "62201": "投资资本金",
        "622011": "新设外商投资企业资本金汇入/因外商投资企业清算、终止等撤资",
        "622012": "筹备资金汇入/撤出",
        "622013": "外商投资企业增资/外商投资企业减资",
        "622014": "转让境内企业股权/购买转让的外商投资企业股权",
        "622015": "对境外母公司的股权投资的撤回（逆向股权投资的撤回）/外商投资企业对境外母公司的股权投资",
        "622016": "非法人投资款汇入/撤出",
        "62202": "借贷及其他往来",
        "622021": "接受境外母公司的贷款及其他往来/偿还境外母公司的贷款及其他往来",
        "622022": "收回对境外母公司的贷款及其他往来（逆向贷款投资的撤回）/对境外母公司的贷款及其他往来（",
        "622030": "向非居民出售境内不动产收入/从非居民购买境内不动产支出",
        "62204": "外商投资企业外方收益再投资",
        "622040": "外商投资企业外方收益再投资收入",
        "62205": "用境外股权交换境内股权",
        "622050": "用境外股权交换境内股权",
        "62206": "实物投资",
        "622060": "实物投资",
        "62207": "无形资产投资",
        "622070": "无形资产投资",
        "623": "联属企业之间的投资",
        "62301": "投资资本金",
        "623011": "撤回对境外联属企业的股权投资/对境外联属企业的股权投资",
        "623012": "接受境外联属企业的股权投资/境外联属企业撤回对境内的股权投资",
        "62302": "借贷及其他往来",
        "623021": "收回对境外联属企业的贷款及其他往来/向境外联属企业提供贷款及其他债权",
        "623022": "接受境外联属企业的贷款及其他往来/偿还境外联属企业贷款及其他债务",
        "7": "证券投资及金融衍生工具",
        "721": "股本",
        "721010": "卖出境外机构境外发行的股票或股权/投资境外机构境外发行的股票或股权",
        "721020": "卖出境内机构在境外发行的股票或股权/投资境内机构在境外发行的股票或股权",
        "721030": "在境外市场发行股票或股权/境内公司回购境外发行的股票或股权",
        "721040": "非居民买入/卖出境内股票或股权",
        "721050": "非居民回购/发行境内股票或股权",
        "722": "投资基金",
        "722010": "赎回/申购境外投资基金",
        "722020": "募集/清算境外投资基金",
        "722030": "非居民申购/赎回境内投资基金",
        "722040": "非居民清算境内募集的/境内募集投资基金",
        "723": "债券交易",
        "72301": "短期债券交易",
        "723011": "卖出/买入境外短期债券",
        "723012": "发行/偿付境外短期债券",
        "723013": "非居民买入/卖出境内短期债券",
        "723014": "非居民偿付/发行境内短期债券",
        "72302": "中长期债券交易",
        "723021": "卖出/买入境外中长期债券",
        "723022": "发行/偿付境外中长期债券",
        "723023": "非居民买入/卖出境内中长期债券",
        "723024": "非居民偿付/发行境内中长期债券",
        "724": "金融衍生工具",
        "724000": "因金融衍生工具交易引起的收入/支出",
        "8": "其他投资",
        "821": "资产",
        "82101": "资产-人寿保险和年金权益",
        "821010": "资产-人寿保险和年金权益",
        "82102": "对外贷款的收回/向境外提供贷款",
        "821020": "对外贷款的收回/向境外提供贷款",
        "82103": "收回或调回存放境外存款本金/存放境外存款",
        "821030": "收回或调回存放境外存款本金/存放境外存款",
        "82104": "贸易信贷",
        "821041": "出口延期应收款",
        "821042": "进口预付货款",
        "82199": "其他的其他投资资产",
        "821990": "其他债权",
        "822": "负债",
        "82201": "负债-人寿保险和年金权益",
        "822010": "负债-人寿保险和年金权益",
        "82202": "获得/偿还境外贷款",
        "822020": "获得/偿还境外贷款",
        "82203": "货币和存款",
        "822030": "境外存入款项/调出",
        "82204": "贸易信贷",
        "822041": "进口延期应付款",
        "822042": "出口预收货款",
        "82205": "实物外债",
        "822050": "实物外债",
        "82299": "其他的其他投资负债",
        "822990": "借入/偿还其他债务",
        "9": "境内外汇收支交易及其他特殊交易",
        "921": "贸易",
        "921010": "转入/偿还出口押汇",
        "921020": "转入/偿还进口押汇",
        "921030": "代理进出口收入/支出",
        "922": "收益",
        "922010": "外汇存款利息收入",
        "922090": "其他",
        "923": "境内投资",
        "923010": "代外国投资者划入/划出投资款",
        "923020": "境内投资者投资款划入/划出",
        "923090": "其他境内投资收入/支出",
        "924": "国内外汇贷款",
        "924010": "获得/偿还国内银行及其他金融机构外汇贷款本金",
        "924020": "获得/偿还委托贷款本金",
        "924030": "划回/划出委托贷款",
        "924090": "获得/偿还其他贷款",
        "925": "个人资金划转",
        "925010": "个人直系亲属账户资金转入/转出",
        "925020": "个人经营性资金转入/转出",
        "929": "其他",
        "929010": "同名账户资金转入/转出",
        "929020": "收到因或有负债交易产生的收入",
        "929030": "存入/提取外币现钞",
        "929040": "存入/划出保证金",
        "929050": "总分公司之间划转的外汇收入/支出",
        "929060": "企业集团公司与境内其他成员企业之间经常项目外汇资金集中管理项下收入/支出",
        "929070": "结汇待支付账户（视同外汇账户管理）资金划出",
        "929080": "因跨境电子商务引起支付机构境内外汇收入/支出",
        "929090": "其他",
        "999998": "无实际资金收付的轧差结算",
        "999999": "有实际资金收付的集中或轧差结算"
    }
        
        
        
    diqu = {
        "1": {
            "name": "现金",
            "A": "存取钞发生地",
            "B": None,
            "C": None,
            "sub_categories": {
                "1.1": {
                    "name": "柜面存取现",
                    "rule": "交易机构所在地区"
                },
                "1.2": {
                    "name": "本行ATM存取现", 
                    "rule": "交易机构所在地区"
                },
                "1.3": {
                    "name": "外行ATM存取现",
                    "rule": "受理机构所在地区"
                },
                "1.4": {
                    "name": "本行卡境外取现",
                    "rule": "000000，国家为对应国家"
                }
            }
        }
    }
       
       
    dfhhao = {
        "11": "现代化支付系统行号",
        "12": "人民币结算账户管理系统行号", 
        "13": "银行内部机构号",
        "14": "金融机构代码",
        "99": "其他"
    } 
    cat11 = {
        "00": "客户通过在境内金融机构开立的账户或者银行卡所发生的大额交易。“金融机构”为开立账户的机构或发卡银行",
        "01": "客户通过境外银行卡所发生的大额交易，“金融机构”为收单行",
        "02": "客户不通过账户或者银行卡发生的大额交易，“金融机构”为办理业务的机构"
    }
    
    shfu_type = {
        "01": "通过大小额支付系统和超级网银清算的交易",
        "02": "通过银联清算的交易",
        "03": "通过外汇交易系统的交易",
        "04": "金融机构内部交易",
        "05": "通过城市商业银行资金清算中心清算的交易",
        "06": "通过农信银资金清算中心清算的交易",
        "11": "票据清算"
    }
        
cd = ClsDict()

jiaoyi_col_desc = [
    ColDesc("id", "str", "流水号",guanlian_cols=["TICD"]),
    ColDesc("status", "str", "交易状态",[{'0000':'成功','0001':'失败'}],guanlian_cols=["TR_STATUS_CD"]),
    ColDesc("is_xianjin", "int64", "是否现金",[{1:"是",0:"否"}],guanlian_cols=["CASH_IND"]),
    ColDesc("jigou", "str", "交易机构",[],guanlian_cols=["ORGANKEY"]),
    ColDesc("shoufu", "int64", "收付标识",[{'01':"收",'02':"付"}],guanlian_cols=["TSDR"]),
    ColDesc("acc1", "str", "账户1,本行账户",guanlian_cols=["ACCT_NUM"]),
    ColDesc("acc1_type", "str", "账户1类型,参见人行账户类型",guanlian_cols=["CATP"]),
    ColDesc("card1", "str", "凭证代码（银行卡号）",guanlian_cols=["CARD_NUM"]),
    ColDesc("card1_type", "str", "凭证类型（银行卡类型）",[{"10": "借记卡/普通卡","20": "贷记卡/信用卡","30": "准贷记卡，兼具借记卡和贷记卡特性","90": "其他"}],guanlian_cols=["CARD_TYPE"]),
    ColDesc("acc2", "str", "账户2,对方账户",guanlian_cols=["TCAC"]),
    ColDesc("time8", "str", "yyyy-mm-dd格式的日期",guanlian_cols=["TSTM"]),
    ColDesc("time14", "str", "yyyy-mm-dd hh:mm:ss格式的日期",guanlian_cols=["DT_TIME"]),
    ColDesc("label", "int64", "标签",[{1:"异常",0:"正常"}]),
    ColDesc("amt", "float64", "人民币金额",guanlian_cols=["CNY_AMT"]),
    ColDesc("balance", "float64", "人民币余额",guanlian_cols=["AMT_VAL"]),
    ColDesc("amt_usd", "float64", "拆美元",guanlian_cols=["USD_AMT"]),
    ColDesc("amt_yuanshi", "float64", "原始金额",guanlian_cols=["CRAT"]),
    ColDesc("bizhong", "str", "原始币种",guanlian_cols=["CRTP"]),
    ColDesc("is_benbi", "str", "本外币标志",[{1:'本币',2:'外币'}],guanlian_cols=["CRTP"]),
    
    ColDesc("acc1_type2", "str", "账户1类型",guanlian_cols=["TYPE_CD"]),
    ColDesc("acc2_type", "str", "账户2类型",guanlian_cols=["TCAT"]),
    ColDesc("is_kuajing", "int64", "是否跨境",[{1:"是",0:"否"}],guanlian_cols=["OVERAREA_IND"]),
    ColDesc("is_shanghu", "int64", "是否我行商户",[{1:"是",0:"否"}],guanlian_cols=["IS_MERCH"]),
    ColDesc("is_rule", "str", "是否规则",[],guanlian_cols=["IS_RULE"]),
    ColDesc("guojia", "str", "交易发生地国别",[],guanlian_cols=["TRCD_COUNTRY"]),
    ColDesc("diqu", "str", "交易发生地行政区",[cd.diqu],guanlian_cols=["TRCD_AREA"]),
    ColDesc("dfhhao", "str", "对方行号",guanlian_cols=["CFIC"]),
    ColDesc("dfhhao_cat", "str", "对方行号类型",[cd.dfhhao],guanlian_cols=["CFCT"]),
    ColDesc("shouji", "str", "手机号",[],guanlian_cols=["PHONE_NUM"]),
    ColDesc("shouji2", "str", "鉴权交易中填写的手机号",[],guanlian_cols=["PHONE_NUM_C"]),
    ColDesc("ip", "str", "交易IP地址",[],guanlian_cols=["TRAN_IP"]),
    ColDesc("cat1", "str", "Aml交易代码",[cd.cat1],guanlian_cols=["TX_CD"]),
    ColDesc("cat2", "str", "交易类型",[cd.cat2],guanlian_cols=["TX_TYPE_CD"]),
    ColDesc("cat3", "str", "交易类型",[{ "11": "有卡交易", "12": "无卡交易（网银交易）", "13": "无卡交易（非网银交易）"}],guanlian_cols=["USE_CARD_FLAG"]),
    ColDesc("cat4", "str", "交易方式",[cd.cat1],guanlian_cols=["TSTP"]),
    ColDesc("cat5", "str", "交易渠道",[cd.channel_map],guanlian_cols=["CHANNEL"]),
    ColDesc("cat6", "str", "非柜台交易方式,TSTP_TYPE_F",[cd.qudao_dict],guanlian_cols=["TSTP_TYPE_F"]),
    ColDesc("cat7", "str", "非柜台交易方式的设备代码,对于网上交易，填写IP地址和mac地址，之间使用@符号分隔；对于POS机交易，填写POS机编号；对于电话交易，填写电话号码；对于热键机交易，填写mac地址；对于atm交易，填写atm编号。",[cd.qudao_dict],guanlian_cols=["TSTP_TYPE_F_CD"]),
    ColDesc("cat8", "str", "交易渠道,收付款方匹配号",[cd.qingsuan_dict],guanlian_cols=["RECEIVE_PAY_NUM"]),
    ColDesc("cat9", "str", "交易渠道，业务产品类型统计",[cd.business_type],guanlian_cols=["BUSINESSTYPE"]),
    ColDesc("cat10", "str", "",guanlian_cols=[""]),
    ColDesc("cat11", "str", "交易渠道,银行与支付机构之间的业务交易编码",[],guanlian_cols=["PAYMENT_TRANS_NUM"]),
    ColDesc("cat12", "str", "涉外收支交易代码,国结系统都有此字段（且是外管局统一制定的码表）",[cd.shewai],guanlian_cols=["TSCT"]),
    ColDesc("cat13", "str", "金融机构和交易关系",[cd.cat11],guanlian_cols=["ORG_TRANS_RELA"]),
    ColDesc("cat14", "str", "收付款方匹配号类型",[cd.shfu_type],guanlian_cols=["RECEIVE_PAY_TYPE"]),
    ColDesc("cat15", "str", "事件类型",[{'04' :'人工交易'}],guanlian_cols=["TRANS_TYPE"]),
    ColDesc("cat16", "str", "交易类型",[{ "11": "有卡交易", "12": "无卡交易（网银交易）", "13": "无卡交易（非网银交易）"}],guanlian_cols=["USE_CARD_FLAG"]),
    ColDesc("cat17", "str", "",guanlian_cols=[""]),
    
    ColDesc("text1", "str", "摘要",guanlian_cols=["DES"]),
    ColDesc("text2", "str", "用途",guanlian_cols=["CRSP"]),
    ColDesc("text3", "str", "备注1,交易备注",guanlian_cols=["TEMP1"]),
    ColDesc("text4", "str", "交易备注（如果只有一个备注可以同上）",guanlian_cols=["TEMP2"]),
    ColDesc("text5", "str", "",guanlian_cols=[""]),
    
    ColDesc("cst1", "str", "我行客户号",guanlian_cols=["PARTY_ID"]),
    ColDesc("cst1_type", "str", "客户类型",[{"C": "对公当事人","I": "个人当事人"}],guanlian_cols=["PARTY_CLASS_CD"]),
    ColDesc("cst2", "str", "对方客户号",guanlian_cols=["OPP_PARTY_ID"]),
    ColDesc("cst2_name", "str", "对方名称",guanlian_cols=["TCNM"]),
    ColDesc("cst2_zhengjian_code", "str", "对方证件号码,对方行外的，默认NULL",guanlian_cols=["TCID"]),
    ColDesc("cst2_zhengjian_cat", "str", "对方证件类型",guanlian_cols=["TCIT"]),
    ColDesc("cst2_type", "str", "对方客户类型",[{ "C": "对公当事人",   "I": "个人当事人"}], guanlian_cols=["OPP_PARTY_CLASS_CD"]),
    ColDesc("cst2_renh_cat", "str", "对方人行客户类型",[{ "01": "法人", "02": "自然人", "03": "个体工商户", "04": "其他组织"}],guanlian_cols=["OPP_PBC_PARTY_CLASS_CD"]),
    ColDesc("cst2_li-an", "str", "对方是否离岸账户",[{1:"是",0:"否"}],guanlian_cols=["OPP_OFF_SHORE_IND"]),
    ColDesc("guiyuan", "str", "柜员",guanlian_cols=["TELLER"]),

]

import pandas as pd
import numpy as np
from tpf.conf.common import ParamConfig 
pc = ParamConfig()

save_file_path="/ai/data/jiaoyi/tra_20251104.csv"
df = pd.read_csv(save_file_path,low_memory=False)
pc.lg(f"1. read data df=\n{df[:3]}")
pc.lg(f"2. df.columns:\n{df.columns}")
""" 
[2025-11-04 17:17:59] 2. df.columns:
Index(['TICD', 'ORGANKEY', 'ACCT_NUM', 'IS_MERCH', 'OVERAREA_IND',
       'TSTP_TYPE_F_CD', 'CFIN', 'TSDR', 'CHANNEL', 'CATP', 'CFIC',
       'OPP_PBC_PARTY_CLASS_CD', 'PHONE_NUM', 'ORG_TRANS_RELA', 'CASH_IND',
       'USD_AMT', 'TX_CD', 'TCIT', 'CARD_NUM', 'CALENDAR_TIME', 'OPP_ISPARTY',
       'CRTP', 'CNY_AMT', 'CFRC_COUNTRY', 'CARD_TYPE', 'TX_GO_COUNTRY',
       'AMT_VAL', 'USE_CARD_FLAG', 'DT_TIME', 'TSCT', 'OPP_SYSID', 'TCNM',
       'TRCD_COUNTRY', 'TCAT', 'TRANS_TYPE', 'TRAN_IP', 'CFCT',
       'OPP_OFF_SHORE_IND', 'TSTM', 'PARTY_NAME', 'SUBJECTNO', 'DES',
       'RECEIVE_PAY_TYPE', 'BUSINESSTYPE', 'OPP_PARTY_CLASS_CD', 'TCAC',
       'RECEIVE_PAY_NUM', 'PARTY_ID', 'TSTP_TYPE_F', 'CFRC_AREA', 'TELLER',
       'TX_TYPE_CD', 'CRAT', 'TRCD_AREA', 'TX_GO_AREA', 'OPP_PARTY_ID', 'TCID',
       'CURR_CD', 'PARTY_CLASS_CD', 'PHONE_NUM_C'],
      dtype='object')
"""

# 创建列名映射关系
col_mapping = {}
for col_desc in jiaoyi_col_desc:
    for guanlian_col in col_desc.guanlian_cols:
        if guanlian_col:  # 确保关联列不为空
            col_mapping[guanlian_col] = col_desc.col_name

pc.lg(f"3. Column mapping: {col_mapping}")

# 转换DataFrame列名
df_transformed = df.copy()
df_transformed = df_transformed.rename(columns=col_mapping)

# 完善列类型信息
num_columns = []
classify_columns = []
date_columns = []

for col_desc in jiaoyi_col_desc:
    if col_desc.col_name in df_transformed.columns:
        if col_desc.col_type in ['int64', 'float64']:
            num_columns.append(col_desc.col_name)
        elif col_desc.col_type == 'str':
            if any(keyword in col_desc.desc.lower() for keyword in ['类型', '标识', '方式', '代码', '类别']):
                classify_columns.append(col_desc.col_name)
            elif any(keyword in col_desc.desc.lower() for keyword in ['日期', '时间']):
                date_columns.append(col_desc.col_name)

pc.col_type.identity = ['id', 'acc1','card1','time8','acc2']
pc.col_type.num_type =  [ 'amt', 'balance', 'amt_usd', 'amt_yuanshi' ]
pc.col_type.classify_type = []
pc.col_type.date_type = ['time14']

from tpf.data.deal import Data2Feature as dtf  

dtf.data_type_change(df_transformed, num_type=pc.col_type.num_type, date_type=pc.col_type.date_type)



pc.lg(f"4. Transformed DataFrame columns 10: {list(df_transformed.columns[:10])}")
pc.lg(f"5. Numeric columns: {num_columns}")
pc.lg(f"6. Classification columns: {classify_columns}")
pc.lg(f"7. Date columns: {date_columns}")