# Examples of use

## Introductory Example

See [PersonSchema](https://github.com/linkml/linkml/tree/main/examples/PersonSchema)

This schema will be used as a core example throughout. It represents
people, their attributes, and related entities such as
organizations.

## Example Models

### Biolink

The Biolink Model is a knowledge graph schema for representing core biological and clinical entities and their inter-relationships.

 * [biolink/biolink-model](https://github.com/biolink/biolink-model) repo
 * [generated docs](https://biolink.github.io/biolink-model/)

### National Microbiome Data Collaborative

The NMDC schema represents environmental omics samples, associated
biogeochemical and environmental metadata, and the outputs of various
kinds of omics processes and computational workflows on these samples.

See [National Microbiome Data Collaborative](https://github.com/microbiomedata/nmdc-schema)

### Cancer Research Data Commons - Harmonized Model

See [Cancer Research Data Commons - Harmonized Model](https://cancerdhc.github.io/ccdhmodel/), developed by the NIH [Center for Cancer Data Harmonization](https://harmonization.datacommons.cancer.gov/)

* [CCDH Pilot Demo](https://docs.google.com/presentation/d/1bw2iY7yoyCAGCKYu21fcSHo7rWXZgbeVac2joTShpPg/edit#slide=id.g6c52a2e8d8_0_177)

### LinkML

LinkML is itself described as a LinkML model

 * [linkml/linkml-model](https://github.com/linkml/linkml-model) repo
 * [generated docs](https://linkml.io/linkml-model/docs/)

## INCLUDE Data Coordination Center

Data model for the INvestigation of Co-occurring conditions across the Lifespan to Understand Down syndromE (INCLUDE) project

* [include-dcc/include-linkml](https://github.com/include-dcc/include-linkml)

## LinkML Registry

The LinkML registry collects some existing schemas and allows for basic browsing:

 * [linkml/linkml-registry](https://linkml.io/linkml-registry/registry/)

## Presentations about LinkML

 * [AI-assisted workflows for integrating data using LinkML](https://zenodo.org/records/15186182) (slides) 2025-04-10
 * [Introduction to LinkML by Sierra Moxon](https://www.youtube.com/watch?v=nyNp09WYLzw&t=183s) (video, 47 min) 2023-10-04
 * [An introduction to LinkML](https://zenodo.org/records/7778641) (slides) 2022-07-01
 * [Yosemite Project Webinar](https://www.youtube.com/watch?v=1cZu4kZ2ufQ) (video) - April 2021
 * [ICBO 2021 talk](http://ceur-ws.org/Vol-3073/paper24.pdf) (proceedings) Sept 2021
