# FAQ: Contributing

## How can I contribute?

We welcome any and all kinds of contribution, including:

 * bug fixes and code contributions
 * ideas for new features
 * testing
 * documentation improvements
 * stlyistic improvements to the linkml site
 * general suggestions on how we can do better

You are free to make PRs on any LinkML repo, including:

 * [linkml](https://github.com/linkml/linkml)
 * [linkml-runtime](https://github.com/linkml/linkml-runtime)
 * [linkml-model](https://github.com/linkml/linkml-model)

Be sure to read the CONTRIBUTING.md for the repo you wish to contribute to.

For filing new issues, please use the [main linkml repo](https://github.com/linkml/linkml/issues).

You may wish to browse the list of [good first issues](https://github.com/linkml/linkml/labels/good%20first%20issue),
and you can [vote for your favorite issue here](https://github.com/linkml/linkml/issues/974).

## How do I stay involved?

- Mailing list (low traffic; mostly announcements about upcoming LinkML Community Meetings): [sign up](https://groups.google.com/g/linkml-community)
- Separate Slack channels for the core development team and the LinkML community: [join here](https://join.slack.com/t/obo-communitygroup/shared_invite/zt-1oq48ttk7-kKo0i6TwntYtAq~Jcjjg4g)
- LinkedIn group: [join](https://www.linkedin.com/groups/14303246/)
- Mastodon: [follow us](https://fosstodon.org/@linkml)
- Community meetings: we hold an open meeting once a month (usually the third Thursday of the month at 11am ET). Please join the mailing list or Slack channel (see above) for info on how to participate.


## How do I register my schema?

You can make a GitHub Pull Request (PR) on the main [linkml-registry](https://linkml.io/linkml-registry/home/) metadata file.

If you are not familiar with the process of making PRs via the GitHub interface, you may find the [guide to registering OBO ontologies](https://github.com/linkml/linkml-registry/blob/main/models.yaml) useful (of course, LinkML schemas are not OBO ontologies, but the process is analogous).
