"""
Generators translate between a SchemaDefinition and an alternative
representation such as JsonSchema
"""

from linkml.generators.javagen import JavaGenerator
from linkml.generators.jsonldcontextgen import ContextGenerator
from linkml.generators.jsonldgen import JSONLDGenerator
from linkml.generators.jsonschemagen import JsonSchemaGenerator
from linkml.generators.owlgen import OwlSchemaGenerator
from linkml.generators.panderagen import PanderaGenerator
from linkml.generators.pydanticgen import PydanticGenerator
from linkml.generators.pythongen import PythonGenerator
from linkml.generators.rdfgen import RDFGenerator
from linkml.generators.rustgen import RustGenerator
from linkml.generators.shaclgen import ShaclGenerator
from linkml.generators.shexgen import ShExGenerator
from linkml.generators.sqlalchemygen import SQLAlchemyGenerator
from linkml.generators.sqltablegen import SQLTableGenerator

__all__ = [
    "csvgen",
    "dotgen",
    "docgen",
    "golrgen",
    "graphqlgen",
    "javagen",
    "jsonldcontextgen",
    "jsonldgen",
    "jsonschemagen",
    "markdowngen",
    "namespacegen",
    "owlgen",
    "plantumlgen",
    "protogen",
    "pythongen",
    "pydanticgen",
    "rdfgen",
    "shexgen",
    "shaclgen",
    "sssomgen",
    "summarygen",
    "yamlgen",
    "yumlgen",
    "OwlSchemaGenerator",
    "PydanticGenerator",
    "PanderaGenerator",
    "PythonGenerator",
    "JavaGenerator",
    "ContextGenerator",
    "JSONLDGenerator",
    "JsonSchemaGenerator",
    "RustGenerator",
    "ShaclGenerator",
    "ShExGenerator",
    "SQLAlchemyGenerator",
    "SQLTableGenerator",
    "RDFGenerator",
]

# TODO: deprecate usage of these
# GENERATOR_BASE = "0.9"

# PYTHON_GEN_VERSION = GENERATOR_BASE + ".0"
