
# Slot: aliases

Alternate names/labels for the element. These do not alter the semantics of the schema, but may be useful to support search and alignment.

URI: [linkml:aliases](https://w3id.org/linkml/aliases)


## Domain and Range

[Element](Element.md) &#8594;  <sub>0..\*</sub> [String](types/String.md)

## Parents


## Children


## Used by

 * [AnonymousClassExpression](AnonymousClassExpression.md)
 * [AnonymousExpression](AnonymousExpression.md)
 * [AnonymousSlotExpression](AnonymousSlotExpression.md)
 * [ArrayExpression](ArrayExpression.md)
 * [ClassDefinition](ClassDefinition.md)
 * [ClassRule](ClassRule.md)
 * [CommonMetadata](CommonMetadata.md)
 * [Definition](Definition.md)
 * [DimensionExpression](DimensionExpression.md)
 * [Element](Element.md)
 * [EnumBinding](EnumBinding.md)
 * [EnumDefinition](EnumDefinition.md)
 * [ImportExpression](ImportExpression.md)
 * [PathExpression](PathExpression.md)
 * [PatternExpression](PatternExpression.md)
 * [PermissibleValue](PermissibleValue.md)
 * [SchemaDefinition](SchemaDefinition.md)
 * [SlotDefinition](SlotDefinition.md)
 * [StructuredAlias](StructuredAlias.md)
 * [SubsetDefinition](SubsetDefinition.md)
 * [TypeDefinition](TypeDefinition.md)
 * [TypeMapping](TypeMapping.md)
 * [UniqueKey](UniqueKey.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Aliases:** | | synonyms |
|  | | alternate names |
|  | | alternative labels |
|  | | designations |
| **Mappings:** | | skos:altLabel |
| **Comments:** | | not be confused with the metaslot alias. |
| **In Subsets:** | | BasicSubset |
| **Exact Mappings:** | | schema:alternateName |
