
# Slot: mixins

A collection of secondary parent mixin classes from which inheritable metaslots are propagated

URI: [linkml:class_definition_mixins](https://w3id.org/linkml/class_definition_mixins)


## Domain and Range

[ClassDefinition](ClassDefinition.md) &#8594;  <sub>0..\*</sub> [ClassDefinition](ClassDefinition.md)

## Parents

 *  is_a: [mixins](mixins.md)

## Children


## Used by

 * [ClassDefinition](ClassDefinition.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Aliases:** | | traits |
| **Comments:** | | mixins act in the same way as parents (is_a). They allow a model to have a primary strict hierarchy, while keeping the benefits of multiple inheritance |
| **In Subsets:** | | SpecificationSubset |
|  | | BasicSubset |
|  | | ObjectOrientedProfile |
|  | | OwlProfile |
| **See also:** | | [https://en.wikipedia.org/wiki/Mixin](https://en.wikipedia.org/wiki/Mixin) |
