
# Slot: name

the unique name of the element within the context of the schema.  Name is combined with the default prefix to form the globally unique subject of the target class.

URI: [linkml:name](https://w3id.org/linkml/name)


## Domain and Range

[Element](Element.md) &#8594;  <sub>1..1</sub> [String](types/String.md)

## Parents


## Children

 *  [schema_definition➞name](schema_definition_name.md)

## Used by

 * [ClassDefinition](ClassDefinition.md)
 * [Definition](Definition.md)
 * [Element](Element.md)
 * [EnumDefinition](EnumDefinition.md)
 * [SlotDefinition](SlotDefinition.md)
 * [SubsetDefinition](SubsetDefinition.md)
 * [TypeDefinition](TypeDefinition.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Aliases:** | | short name |
|  | | unique name |
| **Mappings:** | | rdfs:label |
| **In Subsets:** | | SpecificationSubset |
|  | | OwlProfile |
|  | | MinimalSubset |
|  | | BasicSubset |
|  | | RelationalModelProfile |
|  | | ObjectOrientedProfile |
| **See also:** | | [https://en.wikipedia.org/wiki/Data_element_name](https://en.wikipedia.org/wiki/Data_element_name) |
|  | | [https://linkml.io/linkml/faq/modeling.html#why-are-my-class-names-translated-to-camelcase](https://linkml.io/linkml/faq/modeling.html#why-are-my-class-names-translated-to-camelcase) |
| **Exact Mappings:** | | schema:name |
