
# Slot: mixins

A collection of secondary parent classes or slots from which inheritable metaslots are propagated from.

URI: [linkml:permissible_value_mixins](https://w3id.org/linkml/permissible_value_mixins)


## Domain and Range

[PermissibleValue](PermissibleValue.md) &#8594;  <sub>0..\*</sub> [PermissibleValue](PermissibleValue.md)

## Parents

 *  is_a: [mixins](mixins.md)

## Children


## Used by

 * [PermissibleValue](PermissibleValue.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Aliases:** | | traits |
| **Comments:** | | mixins act in the same way as parents (is_a). They allow a model to have a primary strict hierarchy, while keeping the benefits of multiple inheritance |
| **In Subsets:** | | SpecificationSubset |
|  | | BasicSubset |
|  | | ObjectOrientedProfile |
|  | | OwlProfile |
| **See also:** | | [https://en.wikipedia.org/wiki/Mixin](https://en.wikipedia.org/wiki/Mixin) |
