
# Slot: name

a unique name for the schema that is both human-readable and consists of only characters from the NCName set

URI: [linkml:schema_definition_name](https://w3id.org/linkml/schema_definition_name)


## Domain and Range

[SchemaDefinition](SchemaDefinition.md) &#8594;  <sub>1..1</sub> [Ncname](types/Ncname.md)

## Parents

 *  is_a: [name](name.md)

## Children


## Used by

 * [SchemaDefinition](SchemaDefinition.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Aliases:** | | short name |
|  | | unique name |
| **Mappings:** | | rdfs:label |
| **In Subsets:** | | SpecificationSubset |
|  | | OwlProfile |
|  | | MinimalSubset |
|  | | BasicSubset |
|  | | RelationalModelProfile |
|  | | ObjectOrientedProfile |
| **See also:** | | [https://en.wikipedia.org/wiki/Data_element_name](https://en.wikipedia.org/wiki/Data_element_name) |
|  | | [https://linkml.io/linkml/faq/modeling.html#why-are-my-class-names-translated-to-camelcase](https://linkml.io/linkml/faq/modeling.html#why-are-my-class-names-translated-to-camelcase) |
| **Exact Mappings:** | | schema:name |
