
# Slot: source

A related resource from which the element is derived.

URI: [linkml:source](https://w3id.org/linkml/source)


## Domain and Range

[Element](Element.md) &#8594;  <sub>0..1</sub> [Uriorcurie](types/Uriorcurie.md)

## Parents


## Children


## Used by

 * [AnonymousClassExpression](AnonymousClassExpression.md)
 * [AnonymousExpression](AnonymousExpression.md)
 * [AnonymousSlotExpression](AnonymousSlotExpression.md)
 * [ArrayExpression](ArrayExpression.md)
 * [ClassDefinition](ClassDefinition.md)
 * [ClassRule](ClassRule.md)
 * [CommonMetadata](CommonMetadata.md)
 * [Definition](Definition.md)
 * [DimensionExpression](DimensionExpression.md)
 * [Element](Element.md)
 * [EnumBinding](EnumBinding.md)
 * [EnumDefinition](EnumDefinition.md)
 * [ImportExpression](ImportExpression.md)
 * [PathExpression](PathExpression.md)
 * [PatternExpression](PatternExpression.md)
 * [PermissibleValue](PermissibleValue.md)
 * [SchemaDefinition](SchemaDefinition.md)
 * [SlotDefinition](SlotDefinition.md)
 * [StructuredAlias](StructuredAlias.md)
 * [SubsetDefinition](SubsetDefinition.md)
 * [TypeDefinition](TypeDefinition.md)
 * [TypeMapping](TypeMapping.md)
 * [UniqueKey](UniqueKey.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Aliases:** | | origin |
|  | | derived from |
| **Mappings:** | | dcterms:source |
| **Comments:** | | The described resource may be derived from the related resource in whole or in part |
| **In Subsets:** | | BasicSubset |
| **Close Mappings:** | | prov:wasDerivedFrom |
|  | | schema:isBasedOn |
