#!/usr/bin/env python
# Copyright 2002 by PyMMLib Development Group, http://pymmlib.sourceforge.net/
# This code is part of the PyMMLib distribution and governed by
# its license.Please see the LICENSE_pymmlib file that should have been
# included as part of this package.
"""Space groups defined as a part of the pymmlib."""

from diffpy.structure.spacegroupmod import (
    Rot_mX_mXY_mZ,
    Rot_mX_mXY_Z,
    Rot_mX_mY_mZ,
    Rot_mX_mY_Z,
    Rot_mX_mZ_mY,
    Rot_mX_mZ_Y,
    Rot_mX_Y_mZ,
    Rot_mX_Y_Z,
    Rot_mX_Z_mY,
    Rot_mX_Z_Y,
    Rot_mXY_mX_mZ,
    Rot_mXY_mX_Z,
    Rot_mXY_Y_mZ,
    Rot_mXY_Y_Z,
    Rot_mY_mX_mZ,
    Rot_mY_mX_Z,
    Rot_mY_mZ_mX,
    Rot_mY_mZ_X,
    Rot_mY_X_mZ,
    Rot_mY_X_Z,
    Rot_mY_XmY_mZ,
    Rot_mY_XmY_Z,
    Rot_mY_Z_mX,
    Rot_mY_Z_X,
    Rot_mZ_mX_mY,
    Rot_mZ_mX_Y,
    Rot_mZ_mY_mX,
    Rot_mZ_mY_X,
    Rot_mZ_X_mY,
    Rot_mZ_X_Y,
    Rot_mZ_Y_mX,
    Rot_mZ_Y_X,
    Rot_X_mY_mZ,
    Rot_X_mY_Z,
    Rot_X_mZ_mY,
    Rot_X_mZ_Y,
    Rot_X_XmY_mZ,
    Rot_X_XmY_Z,
    Rot_X_Y_mZ,
    Rot_X_Y_Z,
    Rot_X_Z_mY,
    Rot_X_Z_Y,
    Rot_XmY_mY_mZ,
    Rot_XmY_mY_Z,
    Rot_XmY_X_mZ,
    Rot_XmY_X_Z,
    Rot_Y_mX_mZ,
    Rot_Y_mX_Z,
    Rot_Y_mXY_mZ,
    Rot_Y_mXY_Z,
    Rot_Y_mZ_mX,
    Rot_Y_mZ_X,
    Rot_Y_X_mZ,
    Rot_Y_X_Z,
    Rot_Y_Z_mX,
    Rot_Y_Z_X,
    Rot_Z_mX_mY,
    Rot_Z_mX_Y,
    Rot_Z_mY_mX,
    Rot_Z_mY_X,
    Rot_Z_X_mY,
    Rot_Z_X_Y,
    Rot_Z_Y_mX,
    Rot_Z_Y_X,
    SpaceGroup,
    SymOp,
    Tr_0_0_0,
    Tr_0_0_12,
    Tr_0_0_13,
    Tr_0_0_14,
    Tr_0_0_16,
    Tr_0_0_23,
    Tr_0_0_34,
    Tr_0_0_56,
    Tr_0_12_0,
    Tr_0_12_12,
    Tr_0_12_14,
    Tr_0_12_34,
    Tr_12_0_0,
    Tr_12_0_12,
    Tr_12_0_14,
    Tr_12_0_34,
    Tr_12_12_0,
    Tr_12_12_12,
    Tr_12_12_14,
    Tr_12_12_34,
    Tr_13_23_16,
    Tr_13_23_23,
    Tr_14_14_14,
    Tr_14_14_34,
    Tr_14_34_14,
    Tr_14_34_34,
    Tr_23_13_13,
    Tr_23_13_56,
    Tr_34_14_14,
    Tr_34_14_34,
    Tr_34_34_14,
    Tr_34_34_34,
)

# spacegroup definitions
sg1 = SpaceGroup(
    number=1,
    num_sym_equiv=1,
    num_primitive_sym_equiv=1,
    short_name="P1",
    point_group_name="PG1",
    crystal_system="TRICLINIC",
    pdb_name="P 1",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0)],
)

sg2 = SpaceGroup(
    number=2,
    num_sym_equiv=2,
    num_primitive_sym_equiv=2,
    short_name="P-1",
    point_group_name="PG1bar",
    crystal_system="TRICLINIC",
    pdb_name="P -1",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_mX_mY_mZ, Tr_0_0_0)],
)

sg3 = SpaceGroup(
    number=3,
    num_sym_equiv=2,
    num_primitive_sym_equiv=2,
    short_name="P2",
    point_group_name="PG2",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 2 1",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_mX_Y_mZ, Tr_0_0_0)],
)

sg4 = SpaceGroup(
    number=4,
    num_sym_equiv=2,
    num_primitive_sym_equiv=2,
    short_name="P21",
    point_group_name="PG2",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 21 1",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_mX_Y_mZ, Tr_0_12_0)],
)

sg5 = SpaceGroup(
    number=5,
    num_sym_equiv=4,
    num_primitive_sym_equiv=2,
    short_name="C2",
    point_group_name="PG2",
    crystal_system="MONOCLINIC",
    pdb_name="C 1 2 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
    ],
)

sg6 = SpaceGroup(
    number=6,
    num_sym_equiv=2,
    num_primitive_sym_equiv=2,
    short_name="Pm",
    point_group_name="PGm",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 m 1",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_X_mY_Z, Tr_0_0_0)],
)

sg7 = SpaceGroup(
    number=7,
    num_sym_equiv=2,
    num_primitive_sym_equiv=2,
    short_name="Pc",
    point_group_name="PGm",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 c 1",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_X_mY_Z, Tr_0_0_12)],
)

sg8 = SpaceGroup(
    number=8,
    num_sym_equiv=4,
    num_primitive_sym_equiv=2,
    short_name="Cm",
    point_group_name="PGm",
    crystal_system="MONOCLINIC",
    pdb_name="C 1 m 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
    ],
)

sg9 = SpaceGroup(
    number=9,
    num_sym_equiv=4,
    num_primitive_sym_equiv=2,
    short_name="Cc",
    point_group_name="PGm",
    crystal_system="MONOCLINIC",
    pdb_name="C 1 c 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
    ],
)

sg10 = SpaceGroup(
    number=10,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P2/m",
    point_group_name="PG2/m",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 2/m 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
    ],
)

sg11 = SpaceGroup(
    number=11,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P21/m",
    point_group_name="PG2/m",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 21/m 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_12_0),
    ],
)

sg12 = SpaceGroup(
    number=12,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="C2/m",
    point_group_name="PG2/m",
    crystal_system="MONOCLINIC",
    pdb_name="C 1 2/m 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
    ],
)

sg13 = SpaceGroup(
    number=13,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P2/c",
    point_group_name="PG2/m",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 2/c 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
    ],
)

sg14 = SpaceGroup(
    number=14,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P21/c",
    point_group_name="PG2/m",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 21/c 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
    ],
)

sg15 = SpaceGroup(
    number=15,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="C2/c",
    point_group_name="PG2/m",
    crystal_system="MONOCLINIC",
    pdb_name="C 1 2/c 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
    ],
)

sg16 = SpaceGroup(
    number=16,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P222",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 2 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
    ],
)

sg17 = SpaceGroup(
    number=17,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P2221",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 2 2 21",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
    ],
)

sg18 = SpaceGroup(
    number=18,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P21212",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21 21 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
    ],
)

sg19 = SpaceGroup(
    number=19,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P212121",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21 21 21",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
    ],
)

sg20 = SpaceGroup(
    number=20,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="C2221",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C 2 2 21",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
    ],
)

sg21 = SpaceGroup(
    number=21,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="C222",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C 2 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
    ],
)

sg22 = SpaceGroup(
    number=22,
    num_sym_equiv=16,
    num_primitive_sym_equiv=4,
    short_name="F222",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="F 2 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
    ],
)

sg23 = SpaceGroup(
    number=23,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="I222",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="I 2 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
    ],
)

sg24 = SpaceGroup(
    number=24,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="I212121",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="I 21 21 21",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
    ],
)

sg25 = SpaceGroup(
    number=25,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="Pmm2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P m m 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
    ],
)

sg26 = SpaceGroup(
    number=26,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="Pmc21",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P m c 21",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
    ],
)

sg27 = SpaceGroup(
    number=27,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="Pcc2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P c c 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
    ],
)

sg28 = SpaceGroup(
    number=28,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="Pma2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P m a 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_Z, Tr_12_0_0),
    ],
)

sg29 = SpaceGroup(
    number=29,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="Pca21",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P c a 21",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_Z, Tr_12_0_12),
    ],
)

sg30 = SpaceGroup(
    number=30,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="Pnc2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P n c 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_12_12),
    ],
)

sg31 = SpaceGroup(
    number=31,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="Pmn21",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P m n 21",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
    ],
)

sg32 = SpaceGroup(
    number=32,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="Pba2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P b a 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg33 = SpaceGroup(
    number=33,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="Pna21",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P n a 21",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
    ],
)

sg34 = SpaceGroup(
    number=34,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="Pnn2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P n n 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
    ],
)

sg35 = SpaceGroup(
    number=35,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="Cmm2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C m m 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg36 = SpaceGroup(
    number=36,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="Cmc21",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C m c 21",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg37 = SpaceGroup(
    number=37,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="Ccc2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C c c 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
    ],
)

sg38 = SpaceGroup(
    number=38,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="Amm2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="A m m 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_12_12),
    ],
)

sg39 = SpaceGroup(
    number=39,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="Abm2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="A b m 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_Z, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
    ],
)

sg40 = SpaceGroup(
    number=40,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="Ama2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="A m a 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_Z, Tr_12_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
    ],
)

sg41 = SpaceGroup(
    number=41,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="Aba2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="A b a 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_0_12),
    ],
)

sg42 = SpaceGroup(
    number=42,
    num_sym_equiv=16,
    num_primitive_sym_equiv=4,
    short_name="Fmm2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="F m m 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg43 = SpaceGroup(
    number=43,
    num_sym_equiv=16,
    num_primitive_sym_equiv=4,
    short_name="Fdd2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="F d d 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_14_14_14),
        SymOp(Rot_mX_Y_Z, Tr_14_14_14),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_14_34_34),
        SymOp(Rot_mX_Y_Z, Tr_14_34_34),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_34_14_34),
        SymOp(Rot_mX_Y_Z, Tr_34_14_34),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_34_34_14),
        SymOp(Rot_mX_Y_Z, Tr_34_34_14),
    ],
)

sg44 = SpaceGroup(
    number=44,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="Imm2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="I m m 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
    ],
)

sg45 = SpaceGroup(
    number=45,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="Iba2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="I b a 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
    ],
)

sg46 = SpaceGroup(
    number=46,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="Ima2",
    point_group_name="PGmm2",
    crystal_system="ORTHORHOMBIC",
    pdb_name="I m a 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_Z, Tr_12_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_12_12),
    ],
)

sg47 = SpaceGroup(
    number=47,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pmmm",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 2/m 2/m 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
    ],
)

sg48 = SpaceGroup(
    number=48,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pnnn",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 2/n 2/n 2/n",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
    ],
)

sg49 = SpaceGroup(
    number=49,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pccm",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 2/c 2/c 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
    ],
)

sg50 = SpaceGroup(
    number=50,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pban",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 2/b 2/a 2/n",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg51 = SpaceGroup(
    number=51,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pmma",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21/m 2/m 2/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_12_0_0),
    ],
)

sg52 = SpaceGroup(
    number=52,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pnna",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 2/n 21/n 2/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_12_12),
    ],
)

sg53 = SpaceGroup(
    number=53,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pmna",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 2/m 2/n 21/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
    ],
)

sg54 = SpaceGroup(
    number=54,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pcca",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21/c 2/c 2/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_0_12),
    ],
)

sg55 = SpaceGroup(
    number=55,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pbam",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21/b 21/a 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg56 = SpaceGroup(
    number=56,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pccn",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21/c 21/c 2/n",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_0_12),
    ],
)

sg57 = SpaceGroup(
    number=57,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pbcm",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 2/b 21/c 21/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_12_0),
    ],
)

sg58 = SpaceGroup(
    number=58,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pnnm",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21/n 21/n 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
    ],
)

sg59 = SpaceGroup(
    number=59,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pmmn",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21/m 21/m 2/n",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
    ],
)

sg60 = SpaceGroup(
    number=60,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pbcn",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21/b 2/c 21/n",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg61 = SpaceGroup(
    number=61,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pbca",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21/b 21/c 21/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg62 = SpaceGroup(
    number=62,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pnma",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21/n 21/m 21/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
    ],
)

sg63 = SpaceGroup(
    number=63,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="Cmcm",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C 2/m 2/c 21/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg64 = SpaceGroup(
    number=64,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="Cmca",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C 2/m 2/c 21/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg65 = SpaceGroup(
    number=65,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="Cmmm",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C 2/m 2/m 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg66 = SpaceGroup(
    number=66,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="Cccm",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C 2/c 2/c 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
    ],
)

sg67 = SpaceGroup(
    number=67,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="Cmma",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C 2/m 2/m 2/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg68 = SpaceGroup(
    number=68,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="Ccca",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C 2/c 2/c 2/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_0_12),
        SymOp(Rot_X_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_12_12),
    ],
)

sg69 = SpaceGroup(
    number=69,
    num_sym_equiv=32,
    num_primitive_sym_equiv=8,
    short_name="Fmmm",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="F 2/m 2/m 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_12_12),
        SymOp(Rot_X_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_0_12),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
    ],
)

sg70 = SpaceGroup(
    number=70,
    num_sym_equiv=32,
    num_primitive_sym_equiv=8,
    short_name="Fddd",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="F 2/d 2/d 2/d",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_14_14_14),
        SymOp(Rot_X_Y_mZ, Tr_14_14_14),
        SymOp(Rot_X_mY_Z, Tr_14_14_14),
        SymOp(Rot_mX_Y_Z, Tr_14_14_14),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_14_34_34),
        SymOp(Rot_X_Y_mZ, Tr_14_34_34),
        SymOp(Rot_X_mY_Z, Tr_14_34_34),
        SymOp(Rot_mX_Y_Z, Tr_14_34_34),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_34_14_34),
        SymOp(Rot_X_Y_mZ, Tr_34_14_34),
        SymOp(Rot_X_mY_Z, Tr_34_14_34),
        SymOp(Rot_mX_Y_Z, Tr_34_14_34),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_34_34_14),
        SymOp(Rot_X_Y_mZ, Tr_34_34_14),
        SymOp(Rot_X_mY_Z, Tr_34_34_14),
        SymOp(Rot_mX_Y_Z, Tr_34_34_14),
    ],
)

sg71 = SpaceGroup(
    number=71,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="Immm",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="I 2/m 2/m 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
    ],
)

sg72 = SpaceGroup(
    number=72,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="Ibam",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="I 2/b 2/a 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
    ],
)

sg73 = SpaceGroup(
    number=73,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="Ibca",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="I 21/b 21/c 21/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
    ],
)

sg74 = SpaceGroup(
    number=74,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="Imma",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="I 21/m 21/m 21/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
    ],
)

sg75 = SpaceGroup(
    number=75,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P4",
    point_group_name="PG4",
    crystal_system="TETRAGONAL",
    pdb_name="P 4",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
    ],
)

sg76 = SpaceGroup(
    number=76,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P41",
    point_group_name="PG4",
    crystal_system="TETRAGONAL",
    pdb_name="P 41",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mY_X_Z, Tr_0_0_14),
        SymOp(Rot_Y_mX_Z, Tr_0_0_34),
    ],
)

sg77 = SpaceGroup(
    number=77,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P42",
    point_group_name="PG4",
    crystal_system="TETRAGONAL",
    pdb_name="P 42",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_mX_Z, Tr_0_0_12),
    ],
)

sg78 = SpaceGroup(
    number=78,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P43",
    point_group_name="PG4",
    crystal_system="TETRAGONAL",
    pdb_name="P 43",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mY_X_Z, Tr_0_0_34),
        SymOp(Rot_Y_mX_Z, Tr_0_0_14),
    ],
)

sg79 = SpaceGroup(
    number=79,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="I4",
    point_group_name="PG4",
    crystal_system="TETRAGONAL",
    pdb_name="I 4",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
    ],
)

sg80 = SpaceGroup(
    number=80,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="I41",
    point_group_name="PG4",
    crystal_system="TETRAGONAL",
    pdb_name="I 41",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_0_12_14),
        SymOp(Rot_Y_mX_Z, Tr_12_0_34),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_0_34),
        SymOp(Rot_Y_mX_Z, Tr_0_12_14),
    ],
)

sg81 = SpaceGroup(
    number=81,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P-4",
    point_group_name="PG4bar",
    crystal_system="TETRAGONAL",
    pdb_name="P -4",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
    ],
)

sg82 = SpaceGroup(
    number=82,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="I-4",
    point_group_name="PG4bar",
    crystal_system="TETRAGONAL",
    pdb_name="I -4",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
    ],
)

sg83 = SpaceGroup(
    number=83,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P4/m",
    point_group_name="PG4/m",
    crystal_system="TETRAGONAL",
    pdb_name="P 4/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
    ],
)

sg84 = SpaceGroup(
    number=84,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P42/m",
    point_group_name="PG4/m",
    crystal_system="TETRAGONAL",
    pdb_name="P 42/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_mX_Z, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mY_X_mZ, Tr_0_0_12),
    ],
)

sg85 = SpaceGroup(
    number=85,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P4/n",
    point_group_name="PG4/m",
    crystal_system="TETRAGONAL",
    pdb_name="P 4/n",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_0),
        SymOp(Rot_Y_mX_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
    ],
)

sg86 = SpaceGroup(
    number=86,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P42/n",
    point_group_name="PG4/m",
    crystal_system="TETRAGONAL",
    pdb_name="P 42/n",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
    ],
)

sg87 = SpaceGroup(
    number=87,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I4/m",
    point_group_name="PG4/m",
    crystal_system="TETRAGONAL",
    pdb_name="I 4/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
    ],
)

sg88 = SpaceGroup(
    number=88,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I41/a",
    point_group_name="PG4/m",
    crystal_system="TETRAGONAL",
    pdb_name="I 41/a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_0_12_14),
        SymOp(Rot_Y_mX_Z, Tr_12_0_34),
        SymOp(Rot_mX_mY_mZ, Tr_0_12_14),
        SymOp(Rot_X_Y_mZ, Tr_12_0_34),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_0_34),
        SymOp(Rot_Y_mX_Z, Tr_0_12_14),
        SymOp(Rot_mX_mY_mZ, Tr_12_0_34),
        SymOp(Rot_X_Y_mZ, Tr_0_12_14),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
    ],
)

sg89 = SpaceGroup(
    number=89,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P422",
    point_group_name="PG422",
    crystal_system="TETRAGONAL",
    pdb_name="P 4 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
    ],
)

sg90 = SpaceGroup(
    number=90,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P4212",
    point_group_name="PG422",
    crystal_system="TETRAGONAL",
    pdb_name="P 4 21 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_0),
        SymOp(Rot_Y_mX_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
    ],
)

sg91 = SpaceGroup(
    number=91,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P4122",
    point_group_name="PG422",
    crystal_system="TETRAGONAL",
    pdb_name="P 41 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mY_X_Z, Tr_0_0_14),
        SymOp(Rot_Y_mX_Z, Tr_0_0_34),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_34),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_14),
    ],
)

sg92 = SpaceGroup(
    number=92,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P41212",
    point_group_name="PG422",
    crystal_system="TETRAGONAL",
    pdb_name="P 41 21 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_14),
        SymOp(Rot_Y_mX_Z, Tr_12_12_34),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_14),
        SymOp(Rot_X_mY_mZ, Tr_12_12_34),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
    ],
)

sg93 = SpaceGroup(
    number=93,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P4222",
    point_group_name="PG422",
    crystal_system="TETRAGONAL",
    pdb_name="P 42 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_mX_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
    ],
)

sg94 = SpaceGroup(
    number=94,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P42212",
    point_group_name="PG422",
    crystal_system="TETRAGONAL",
    pdb_name="P 42 21 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
    ],
)

sg95 = SpaceGroup(
    number=95,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P4322",
    point_group_name="PG422",
    crystal_system="TETRAGONAL",
    pdb_name="P 43 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mY_X_Z, Tr_0_0_34),
        SymOp(Rot_Y_mX_Z, Tr_0_0_14),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_14),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_34),
    ],
)

sg96 = SpaceGroup(
    number=96,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P43212",
    point_group_name="PG422",
    crystal_system="TETRAGONAL",
    pdb_name="P 43 21 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_34),
        SymOp(Rot_Y_mX_Z, Tr_12_12_14),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_34),
        SymOp(Rot_X_mY_mZ, Tr_12_12_14),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
    ],
)

sg97 = SpaceGroup(
    number=97,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I422",
    point_group_name="PG422",
    crystal_system="TETRAGONAL",
    pdb_name="I 4 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
    ],
)

sg98 = SpaceGroup(
    number=98,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I4122",
    point_group_name="PG422",
    crystal_system="TETRAGONAL",
    pdb_name="I 41 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_0_12_14),
        SymOp(Rot_Y_mX_Z, Tr_12_0_34),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_34),
        SymOp(Rot_X_mY_mZ, Tr_0_12_14),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_0_34),
        SymOp(Rot_Y_mX_Z, Tr_0_12_14),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_14),
        SymOp(Rot_X_mY_mZ, Tr_12_0_34),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
    ],
)

sg99 = SpaceGroup(
    number=99,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P4mm",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4 m m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
    ],
)

sg100 = SpaceGroup(
    number=100,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P4bm",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4 b m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_0),
    ],
)

sg101 = SpaceGroup(
    number=101,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P42cm",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42 c m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_mX_Z, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
    ],
)

sg102 = SpaceGroup(
    number=102,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P42nm",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42 n m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
    ],
)

sg103 = SpaceGroup(
    number=103,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P4cc",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4 c c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
    ],
)

sg104 = SpaceGroup(
    number=104,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P4nc",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4 n c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
    ],
)

sg105 = SpaceGroup(
    number=105,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P42mc",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42 m c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_mX_Z, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
    ],
)

sg106 = SpaceGroup(
    number=106,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P42bc",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42 b c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_mX_Z, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
    ],
)

sg107 = SpaceGroup(
    number=107,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I4mm",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="I 4 m m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
    ],
)

sg108 = SpaceGroup(
    number=108,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I4cm",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="I 4 c m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_0),
    ],
)

sg109 = SpaceGroup(
    number=109,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I41md",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="I 41 m d",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_0_12_14),
        SymOp(Rot_Y_mX_Z, Tr_12_0_34),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_0_12_14),
        SymOp(Rot_Y_X_Z, Tr_12_0_34),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_0_34),
        SymOp(Rot_Y_mX_Z, Tr_0_12_14),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_12_0_34),
        SymOp(Rot_Y_X_Z, Tr_0_12_14),
    ],
)

sg110 = SpaceGroup(
    number=110,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I41cd",
    point_group_name="PG4mm",
    crystal_system="TETRAGONAL",
    pdb_name="I 41 c d",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_0_12_14),
        SymOp(Rot_Y_mX_Z, Tr_12_0_34),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_0_12_34),
        SymOp(Rot_Y_X_Z, Tr_12_0_14),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_0_34),
        SymOp(Rot_Y_mX_Z, Tr_0_12_14),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_12_0_14),
        SymOp(Rot_Y_X_Z, Tr_0_12_34),
    ],
)

sg111 = SpaceGroup(
    number=111,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P-42m",
    point_group_name="PG4bar2m",
    crystal_system="TETRAGONAL",
    pdb_name="P -4 2 m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
    ],
)

sg112 = SpaceGroup(
    number=112,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P-42c",
    point_group_name="PG4bar2m",
    crystal_system="TETRAGONAL",
    pdb_name="P -4 2 c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
    ],
)

sg113 = SpaceGroup(
    number=113,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P-421m",
    point_group_name="PG4bar2m",
    crystal_system="TETRAGONAL",
    pdb_name="P -4 21 m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_0),
    ],
)

sg114 = SpaceGroup(
    number=114,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P-421c",
    point_group_name="PG4bar2m",
    crystal_system="TETRAGONAL",
    pdb_name="P -4 21 c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
    ],
)

sg115 = SpaceGroup(
    number=115,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P-4m2",
    point_group_name="PG4barm2",
    crystal_system="TETRAGONAL",
    pdb_name="P -4 m 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
    ],
)

sg116 = SpaceGroup(
    number=116,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P-4c2",
    point_group_name="PG4barm2",
    crystal_system="TETRAGONAL",
    pdb_name="P -4 c 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
    ],
)

sg117 = SpaceGroup(
    number=117,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P-4b2",
    point_group_name="PG4barm2",
    crystal_system="TETRAGONAL",
    pdb_name="P -4 b 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_0),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_0),
    ],
)

sg118 = SpaceGroup(
    number=118,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P-4n2",
    point_group_name="PG4barm2",
    crystal_system="TETRAGONAL",
    pdb_name="P -4 n 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
    ],
)

sg119 = SpaceGroup(
    number=119,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I-4m2",
    point_group_name="PG4barm2",
    crystal_system="TETRAGONAL",
    pdb_name="I -4 m 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
    ],
)

sg120 = SpaceGroup(
    number=120,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I-4c2",
    point_group_name="PG4barm2",
    crystal_system="TETRAGONAL",
    pdb_name="I -4 c 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_0),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_0),
    ],
)

sg121 = SpaceGroup(
    number=121,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I-42m",
    point_group_name="PG4bar2m",
    crystal_system="TETRAGONAL",
    pdb_name="I -4 2 m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
    ],
)

sg122 = SpaceGroup(
    number=122,
    num_sym_equiv=16,
    num_primitive_sym_equiv=8,
    short_name="I-42d",
    point_group_name="PG4bar2m",
    crystal_system="TETRAGONAL",
    pdb_name="I -4 2 d",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_34),
        SymOp(Rot_X_mY_mZ, Tr_12_0_34),
        SymOp(Rot_mY_mX_Z, Tr_12_0_34),
        SymOp(Rot_Y_X_Z, Tr_12_0_34),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_14),
        SymOp(Rot_X_mY_mZ, Tr_0_12_14),
        SymOp(Rot_mY_mX_Z, Tr_0_12_14),
        SymOp(Rot_Y_X_Z, Tr_0_12_14),
    ],
)

sg123 = SpaceGroup(
    number=123,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P4/mmm",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4/m 2/m 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
    ],
)

sg124 = SpaceGroup(
    number=124,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P4/mcc",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4/m 2/c 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
    ],
)

sg125 = SpaceGroup(
    number=125,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P4/nbm",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4/n 2/b 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_0),
        SymOp(Rot_mY_X_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_0),
    ],
)

sg126 = SpaceGroup(
    number=126,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P4/nnc",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4/n 2/n 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
    ],
)

sg127 = SpaceGroup(
    number=127,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P4/mbm",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4/m 21/b 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_0),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_0),
    ],
)

sg128 = SpaceGroup(
    number=128,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P4/mnc",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4/m 21/n 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
    ],
)

sg129 = SpaceGroup(
    number=129,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P4/nmm",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4/n 21/m 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_0),
        SymOp(Rot_Y_mX_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_0),
    ],
)

sg130 = SpaceGroup(
    number=130,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P4/ncc",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 4/n 2/c 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_0),
        SymOp(Rot_Y_mX_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
    ],
)

sg131 = SpaceGroup(
    number=131,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P42/mmc",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42/m 2/m 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_mX_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mY_X_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
    ],
)

sg132 = SpaceGroup(
    number=132,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P42/mcm",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42/m 2/c 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_mX_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mY_X_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
    ],
)

sg133 = SpaceGroup(
    number=133,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P42/nbc",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42/n 2/b 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_12_12_0),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
    ],
)

sg134 = SpaceGroup(
    number=134,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P42/nnm",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42/n 2/n 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
    ],
)

sg135 = SpaceGroup(
    number=135,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P42/mbc",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42/m 21/b 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_mX_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mY_X_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
    ],
)

sg136 = SpaceGroup(
    number=136,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P42/mnm",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42/m 21/n 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
    ],
)

sg137 = SpaceGroup(
    number=137,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P42/nmc",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42/n 21/m 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
    ],
)

sg138 = SpaceGroup(
    number=138,
    num_sym_equiv=16,
    num_primitive_sym_equiv=16,
    short_name="P42/ncm",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="P 42/n 21/c 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_0),
    ],
)

sg139 = SpaceGroup(
    number=139,
    num_sym_equiv=32,
    num_primitive_sym_equiv=16,
    short_name="I4/mmm",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="I 4/m 2/m 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
    ],
)

sg140 = SpaceGroup(
    number=140,
    num_sym_equiv=32,
    num_primitive_sym_equiv=16,
    short_name="I4/mcm",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="I 4/m 2/c 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_0),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_0),
    ],
)

sg141 = SpaceGroup(
    number=141,
    num_sym_equiv=32,
    num_primitive_sym_equiv=16,
    short_name="I41/amd",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="I 41/a 2/m 2/d",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_0_12_14),
        SymOp(Rot_Y_mX_Z, Tr_12_0_34),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_34),
        SymOp(Rot_X_mY_mZ, Tr_0_12_14),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_12_14),
        SymOp(Rot_X_Y_mZ, Tr_12_0_34),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_12_0_34),
        SymOp(Rot_Y_X_Z, Tr_0_12_14),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_0_34),
        SymOp(Rot_Y_mX_Z, Tr_0_12_14),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_14),
        SymOp(Rot_X_mY_mZ, Tr_12_0_34),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_0_34),
        SymOp(Rot_X_Y_mZ, Tr_0_12_14),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_0_12_14),
        SymOp(Rot_Y_X_Z, Tr_12_0_34),
    ],
)

sg142 = SpaceGroup(
    number=142,
    num_sym_equiv=32,
    num_primitive_sym_equiv=16,
    short_name="I41/acd",
    point_group_name="PG4/mmm",
    crystal_system="TETRAGONAL",
    pdb_name="I 41/a 2/c 2/d",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_0_12_14),
        SymOp(Rot_Y_mX_Z, Tr_12_0_34),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_14),
        SymOp(Rot_X_mY_mZ, Tr_0_12_34),
        SymOp(Rot_Y_X_mZ, Tr_12_12_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_12_14),
        SymOp(Rot_X_Y_mZ, Tr_12_0_34),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_12_0_14),
        SymOp(Rot_Y_X_Z, Tr_0_12_34),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_0_34),
        SymOp(Rot_Y_mX_Z, Tr_0_12_14),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_34),
        SymOp(Rot_X_mY_mZ, Tr_12_0_14),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_0_34),
        SymOp(Rot_X_Y_mZ, Tr_0_12_14),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_0_12_34),
        SymOp(Rot_Y_X_Z, Tr_12_0_14),
    ],
)

sg143 = SpaceGroup(
    number=143,
    num_sym_equiv=3,
    num_primitive_sym_equiv=3,
    short_name="P3",
    point_group_name="PG3",
    crystal_system="TRIGONAL",
    pdb_name="P 3",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_mY_XmY_Z, Tr_0_0_0), SymOp(Rot_mXY_mX_Z, Tr_0_0_0)],
)

sg144 = SpaceGroup(
    number=144,
    num_sym_equiv=3,
    num_primitive_sym_equiv=3,
    short_name="P31",
    point_group_name="PG3",
    crystal_system="TRIGONAL",
    pdb_name="P 31",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_mY_XmY_Z, Tr_0_0_13), SymOp(Rot_mXY_mX_Z, Tr_0_0_23)],
)

sg145 = SpaceGroup(
    number=145,
    num_sym_equiv=3,
    num_primitive_sym_equiv=3,
    short_name="P32",
    point_group_name="PG3",
    crystal_system="TRIGONAL",
    pdb_name="P 32",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_mY_XmY_Z, Tr_0_0_23), SymOp(Rot_mXY_mX_Z, Tr_0_0_13)],
)

sg146 = SpaceGroup(
    number=146,
    num_sym_equiv=9,
    num_primitive_sym_equiv=3,
    short_name="H3",
    point_group_name="PG3",
    crystal_system="TRIGONAL",
    pdb_name="H 3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_23_13_13),
        SymOp(Rot_mY_XmY_Z, Tr_23_13_13),
        SymOp(Rot_mXY_mX_Z, Tr_23_13_13),
        SymOp(Rot_X_Y_Z, Tr_13_23_23),
        SymOp(Rot_mY_XmY_Z, Tr_13_23_23),
        SymOp(Rot_mXY_mX_Z, Tr_13_23_23),
    ],
)

sg1146 = SpaceGroup(
    number=1146,
    num_sym_equiv=3,
    num_primitive_sym_equiv=3,
    short_name="R3",
    point_group_name="PG3",
    crystal_system="TRIGONAL",
    pdb_name="R 3",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_Z_X_Y, Tr_0_0_0), SymOp(Rot_Y_Z_X, Tr_0_0_0)],
)

sg147 = SpaceGroup(
    number=147,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P-3",
    point_group_name="PG3bar",
    crystal_system="TRIGONAL",
    pdb_name="P -3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
    ],
)

sg148 = SpaceGroup(
    number=148,
    num_sym_equiv=18,
    num_primitive_sym_equiv=6,
    short_name="H-3",
    point_group_name="PG3bar",
    crystal_system="TRIGONAL",
    pdb_name="H -3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_23_13_13),
        SymOp(Rot_mY_XmY_Z, Tr_23_13_13),
        SymOp(Rot_mXY_mX_Z, Tr_23_13_13),
        SymOp(Rot_mX_mY_mZ, Tr_23_13_13),
        SymOp(Rot_Y_mXY_mZ, Tr_23_13_13),
        SymOp(Rot_XmY_X_mZ, Tr_23_13_13),
        SymOp(Rot_X_Y_Z, Tr_13_23_23),
        SymOp(Rot_mY_XmY_Z, Tr_13_23_23),
        SymOp(Rot_mXY_mX_Z, Tr_13_23_23),
        SymOp(Rot_mX_mY_mZ, Tr_13_23_23),
        SymOp(Rot_Y_mXY_mZ, Tr_13_23_23),
        SymOp(Rot_XmY_X_mZ, Tr_13_23_23),
    ],
)

sg1148 = SpaceGroup(
    number=1148,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="R-3",
    point_group_name="PG3bar",
    crystal_system="TRIGONAL",
    pdb_name="R -3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
    ],
)

sg149 = SpaceGroup(
    number=149,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P312",
    point_group_name="PG312",
    crystal_system="TRIGONAL",
    pdb_name="P 3 1 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_0),
    ],
)

sg150 = SpaceGroup(
    number=150,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P321",
    point_group_name="PG321",
    crystal_system="TRIGONAL",
    pdb_name="P 3 2 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_0),
    ],
)

sg151 = SpaceGroup(
    number=151,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P3112",
    point_group_name="PG312",
    crystal_system="TRIGONAL",
    pdb_name="P 31 1 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_13),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_23),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_23),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_13),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_0),
    ],
)

sg152 = SpaceGroup(
    number=152,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P3121",
    point_group_name="PG321",
    crystal_system="TRIGONAL",
    pdb_name="P 31 2 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_13),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_23),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_23),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_13),
    ],
)

sg153 = SpaceGroup(
    number=153,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P3212",
    point_group_name="PG312",
    crystal_system="TRIGONAL",
    pdb_name="P 32 1 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_23),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_13),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_13),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_23),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_0),
    ],
)

sg154 = SpaceGroup(
    number=154,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P3221",
    point_group_name="PG321",
    crystal_system="TRIGONAL",
    pdb_name="P 32 2 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_23),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_13),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_13),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_23),
    ],
)

sg155 = SpaceGroup(
    number=155,
    num_sym_equiv=18,
    num_primitive_sym_equiv=6,
    short_name="H32",
    point_group_name="PG321",
    crystal_system="TRIGONAL",
    pdb_name="H 3 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_23_13_13),
        SymOp(Rot_mY_XmY_Z, Tr_23_13_13),
        SymOp(Rot_mXY_mX_Z, Tr_23_13_13),
        SymOp(Rot_Y_X_mZ, Tr_23_13_13),
        SymOp(Rot_XmY_mY_mZ, Tr_23_13_13),
        SymOp(Rot_mX_mXY_mZ, Tr_23_13_13),
        SymOp(Rot_X_Y_Z, Tr_13_23_23),
        SymOp(Rot_mY_XmY_Z, Tr_13_23_23),
        SymOp(Rot_mXY_mX_Z, Tr_13_23_23),
        SymOp(Rot_Y_X_mZ, Tr_13_23_23),
        SymOp(Rot_XmY_mY_mZ, Tr_13_23_23),
        SymOp(Rot_mX_mXY_mZ, Tr_13_23_23),
    ],
)

sg1155 = SpaceGroup(
    number=1155,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="R32",
    point_group_name="PG32",
    crystal_system="TRIGONAL",
    pdb_name="R 3 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mZ_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mY_mX, Tr_0_0_0),
    ],
)

sg156 = SpaceGroup(
    number=156,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P3m1",
    point_group_name="PG3m1",
    crystal_system="TRIGONAL",
    pdb_name="P 3 m 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_XmY_Z, Tr_0_0_0),
    ],
)

sg157 = SpaceGroup(
    number=157,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P31m",
    point_group_name="PG31m",
    crystal_system="TRIGONAL",
    pdb_name="P 3 1 m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_0),
    ],
)

sg158 = SpaceGroup(
    number=158,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P3c1",
    point_group_name="PG3m1",
    crystal_system="TRIGONAL",
    pdb_name="P 3 c 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_12),
        SymOp(Rot_X_XmY_Z, Tr_0_0_12),
    ],
)

sg159 = SpaceGroup(
    number=159,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P31c",
    point_group_name="PG31m",
    crystal_system="TRIGONAL",
    pdb_name="P 3 1 c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_12),
    ],
)

sg160 = SpaceGroup(
    number=160,
    num_sym_equiv=18,
    num_primitive_sym_equiv=6,
    short_name="H3m",
    point_group_name="PG3m",
    crystal_system="TRIGONAL",
    pdb_name="H 3 m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_XmY_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_23_13_13),
        SymOp(Rot_mY_XmY_Z, Tr_23_13_13),
        SymOp(Rot_mXY_mX_Z, Tr_23_13_13),
        SymOp(Rot_mY_mX_Z, Tr_23_13_13),
        SymOp(Rot_mXY_Y_Z, Tr_23_13_13),
        SymOp(Rot_X_XmY_Z, Tr_23_13_13),
        SymOp(Rot_X_Y_Z, Tr_13_23_23),
        SymOp(Rot_mY_XmY_Z, Tr_13_23_23),
        SymOp(Rot_mXY_mX_Z, Tr_13_23_23),
        SymOp(Rot_mY_mX_Z, Tr_13_23_23),
        SymOp(Rot_mXY_Y_Z, Tr_13_23_23),
        SymOp(Rot_X_XmY_Z, Tr_13_23_23),
    ],
)

sg1160 = SpaceGroup(
    number=1160,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="R3m",
    point_group_name="PG3m",
    crystal_system="TRIGONAL",
    pdb_name="R 3 m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Z_Y, Tr_0_0_0),
        SymOp(Rot_Z_Y_X, Tr_0_0_0),
    ],
)

sg161 = SpaceGroup(
    number=161,
    num_sym_equiv=18,
    num_primitive_sym_equiv=6,
    short_name="H3c",
    point_group_name="PG3m",
    crystal_system="TRIGONAL",
    pdb_name="H 3 c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_12),
        SymOp(Rot_X_XmY_Z, Tr_0_0_12),
        SymOp(Rot_X_Y_Z, Tr_23_13_13),
        SymOp(Rot_mY_XmY_Z, Tr_23_13_13),
        SymOp(Rot_mXY_mX_Z, Tr_23_13_13),
        SymOp(Rot_mY_mX_Z, Tr_23_13_56),
        SymOp(Rot_mXY_Y_Z, Tr_23_13_56),
        SymOp(Rot_X_XmY_Z, Tr_23_13_56),
        SymOp(Rot_X_Y_Z, Tr_13_23_23),
        SymOp(Rot_mY_XmY_Z, Tr_13_23_23),
        SymOp(Rot_mXY_mX_Z, Tr_13_23_23),
        SymOp(Rot_mY_mX_Z, Tr_13_23_16),
        SymOp(Rot_mXY_Y_Z, Tr_13_23_16),
        SymOp(Rot_X_XmY_Z, Tr_13_23_16),
    ],
)

sg1161 = SpaceGroup(
    number=1161,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="R3c",
    point_group_name="PG3m",
    crystal_system="TRIGONAL",
    pdb_name="R 3 c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
        SymOp(Rot_X_Z_Y, Tr_12_12_12),
        SymOp(Rot_Z_Y_X, Tr_12_12_12),
    ],
)

sg162 = SpaceGroup(
    number=162,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P-31m",
    point_group_name="PG3bar1m",
    crystal_system="TRIGONAL",
    pdb_name="P -3 1 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_0),
    ],
)

sg163 = SpaceGroup(
    number=163,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P-31c",
    point_group_name="PG3bar1m",
    crystal_system="TRIGONAL",
    pdb_name="P -3 1 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_12),
    ],
)

sg164 = SpaceGroup(
    number=164,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P-3m1",
    point_group_name="PG3barm1",
    crystal_system="TRIGONAL",
    pdb_name="P -3 2/m 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_XmY_Z, Tr_0_0_0),
    ],
)

sg165 = SpaceGroup(
    number=165,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P-3c1",
    point_group_name="PG3barm1",
    crystal_system="TRIGONAL",
    pdb_name="P -3 2/c 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_12),
        SymOp(Rot_X_XmY_Z, Tr_0_0_12),
    ],
)

sg166 = SpaceGroup(
    number=166,
    num_sym_equiv=36,
    num_primitive_sym_equiv=12,
    short_name="H-3m",
    point_group_name="PG3barm",
    crystal_system="TRIGONAL",
    pdb_name="H -3 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_XmY_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_23_13_13),
        SymOp(Rot_mY_XmY_Z, Tr_23_13_13),
        SymOp(Rot_mXY_mX_Z, Tr_23_13_13),
        SymOp(Rot_Y_X_mZ, Tr_23_13_13),
        SymOp(Rot_XmY_mY_mZ, Tr_23_13_13),
        SymOp(Rot_mX_mXY_mZ, Tr_23_13_13),
        SymOp(Rot_mX_mY_mZ, Tr_23_13_13),
        SymOp(Rot_Y_mXY_mZ, Tr_23_13_13),
        SymOp(Rot_XmY_X_mZ, Tr_23_13_13),
        SymOp(Rot_mY_mX_Z, Tr_23_13_13),
        SymOp(Rot_mXY_Y_Z, Tr_23_13_13),
        SymOp(Rot_X_XmY_Z, Tr_23_13_13),
        SymOp(Rot_X_Y_Z, Tr_13_23_23),
        SymOp(Rot_mY_XmY_Z, Tr_13_23_23),
        SymOp(Rot_mXY_mX_Z, Tr_13_23_23),
        SymOp(Rot_Y_X_mZ, Tr_13_23_23),
        SymOp(Rot_XmY_mY_mZ, Tr_13_23_23),
        SymOp(Rot_mX_mXY_mZ, Tr_13_23_23),
        SymOp(Rot_mX_mY_mZ, Tr_13_23_23),
        SymOp(Rot_Y_mXY_mZ, Tr_13_23_23),
        SymOp(Rot_XmY_X_mZ, Tr_13_23_23),
        SymOp(Rot_mY_mX_Z, Tr_13_23_23),
        SymOp(Rot_mXY_Y_Z, Tr_13_23_23),
        SymOp(Rot_X_XmY_Z, Tr_13_23_23),
    ],
)

sg1166 = SpaceGroup(
    number=1166,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="R-3m",
    point_group_name="PG3barm",
    crystal_system="TRIGONAL",
    pdb_name="R -3 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mZ_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mY_mX, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Z_Y, Tr_0_0_0),
        SymOp(Rot_Z_Y_X, Tr_0_0_0),
    ],
)

sg167 = SpaceGroup(
    number=167,
    num_sym_equiv=36,
    num_primitive_sym_equiv=12,
    short_name="H-3c",
    point_group_name="PG3barm",
    crystal_system="TRIGONAL",
    pdb_name="H -3 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_12),
        SymOp(Rot_X_XmY_Z, Tr_0_0_12),
        SymOp(Rot_X_Y_Z, Tr_23_13_13),
        SymOp(Rot_mY_XmY_Z, Tr_23_13_13),
        SymOp(Rot_mXY_mX_Z, Tr_23_13_13),
        SymOp(Rot_Y_X_mZ, Tr_23_13_56),
        SymOp(Rot_XmY_mY_mZ, Tr_23_13_56),
        SymOp(Rot_mX_mXY_mZ, Tr_23_13_56),
        SymOp(Rot_mX_mY_mZ, Tr_23_13_13),
        SymOp(Rot_Y_mXY_mZ, Tr_23_13_13),
        SymOp(Rot_XmY_X_mZ, Tr_23_13_13),
        SymOp(Rot_mY_mX_Z, Tr_23_13_56),
        SymOp(Rot_mXY_Y_Z, Tr_23_13_56),
        SymOp(Rot_X_XmY_Z, Tr_23_13_56),
        SymOp(Rot_X_Y_Z, Tr_13_23_23),
        SymOp(Rot_mY_XmY_Z, Tr_13_23_23),
        SymOp(Rot_mXY_mX_Z, Tr_13_23_23),
        SymOp(Rot_Y_X_mZ, Tr_13_23_16),
        SymOp(Rot_XmY_mY_mZ, Tr_13_23_16),
        SymOp(Rot_mX_mXY_mZ, Tr_13_23_16),
        SymOp(Rot_mX_mY_mZ, Tr_13_23_23),
        SymOp(Rot_Y_mXY_mZ, Tr_13_23_23),
        SymOp(Rot_XmY_X_mZ, Tr_13_23_23),
        SymOp(Rot_mY_mX_Z, Tr_13_23_16),
        SymOp(Rot_mXY_Y_Z, Tr_13_23_16),
        SymOp(Rot_X_XmY_Z, Tr_13_23_16),
    ],
)

sg1167 = SpaceGroup(
    number=1167,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="R-3c",
    point_group_name="PG3barm",
    crystal_system="TRIGONAL",
    pdb_name="R -3 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mZ_mY, Tr_12_12_12),
        SymOp(Rot_mZ_mY_mX, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
        SymOp(Rot_X_Z_Y, Tr_12_12_12),
        SymOp(Rot_Z_Y_X, Tr_12_12_12),
    ],
)

sg168 = SpaceGroup(
    number=168,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P6",
    point_group_name="PG6",
    crystal_system="HEXAGONAL",
    pdb_name="P 6",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_0),
        SymOp(Rot_XmY_X_Z, Tr_0_0_0),
    ],
)

sg169 = SpaceGroup(
    number=169,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P61",
    point_group_name="PG6",
    crystal_system="HEXAGONAL",
    pdb_name="P 61",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_13),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_23),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_56),
        SymOp(Rot_XmY_X_Z, Tr_0_0_16),
    ],
)

sg170 = SpaceGroup(
    number=170,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P65",
    point_group_name="PG6",
    crystal_system="HEXAGONAL",
    pdb_name="P 65",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_23),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_13),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_16),
        SymOp(Rot_XmY_X_Z, Tr_0_0_56),
    ],
)

sg171 = SpaceGroup(
    number=171,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P62",
    point_group_name="PG6",
    crystal_system="HEXAGONAL",
    pdb_name="P 62",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_23),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_13),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_23),
        SymOp(Rot_XmY_X_Z, Tr_0_0_13),
    ],
)

sg172 = SpaceGroup(
    number=172,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P64",
    point_group_name="PG6",
    crystal_system="HEXAGONAL",
    pdb_name="P 64",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_13),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_23),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_13),
        SymOp(Rot_XmY_X_Z, Tr_0_0_23),
    ],
)

sg173 = SpaceGroup(
    number=173,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P63",
    point_group_name="PG6",
    crystal_system="HEXAGONAL",
    pdb_name="P 63",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_12),
        SymOp(Rot_XmY_X_Z, Tr_0_0_12),
    ],
)

sg174 = SpaceGroup(
    number=174,
    num_sym_equiv=6,
    num_primitive_sym_equiv=6,
    short_name="P-6",
    point_group_name="PG6bar",
    crystal_system="HEXAGONAL",
    pdb_name="P -6",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_mY_XmY_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_mX_mZ, Tr_0_0_0),
    ],
)

sg175 = SpaceGroup(
    number=175,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P6/m",
    point_group_name="PG6/m",
    crystal_system="HEXAGONAL",
    pdb_name="P 6/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_0),
        SymOp(Rot_XmY_X_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_mY_XmY_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_mX_mZ, Tr_0_0_0),
    ],
)

sg176 = SpaceGroup(
    number=176,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P63/m",
    point_group_name="PG6/m",
    crystal_system="HEXAGONAL",
    pdb_name="P 63/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_12),
        SymOp(Rot_XmY_X_Z, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_12),
        SymOp(Rot_mY_XmY_mZ, Tr_0_0_12),
        SymOp(Rot_mXY_mX_mZ, Tr_0_0_12),
    ],
)

sg177 = SpaceGroup(
    number=177,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P622",
    point_group_name="PG622",
    crystal_system="HEXAGONAL",
    pdb_name="P 6 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_0),
        SymOp(Rot_XmY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_0),
    ],
)

sg178 = SpaceGroup(
    number=178,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P6122",
    point_group_name="PG622",
    crystal_system="HEXAGONAL",
    pdb_name="P 61 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_13),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_23),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_56),
        SymOp(Rot_XmY_X_Z, Tr_0_0_16),
        SymOp(Rot_Y_X_mZ, Tr_0_0_13),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_23),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_56),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_16),
    ],
)

sg179 = SpaceGroup(
    number=179,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P6522",
    point_group_name="PG622",
    crystal_system="HEXAGONAL",
    pdb_name="P 65 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_23),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_13),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_16),
        SymOp(Rot_XmY_X_Z, Tr_0_0_56),
        SymOp(Rot_Y_X_mZ, Tr_0_0_23),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_13),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_16),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_56),
    ],
)

sg180 = SpaceGroup(
    number=180,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P6222",
    point_group_name="PG622",
    crystal_system="HEXAGONAL",
    pdb_name="P 62 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_23),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_13),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_23),
        SymOp(Rot_XmY_X_Z, Tr_0_0_13),
        SymOp(Rot_Y_X_mZ, Tr_0_0_23),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_13),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_23),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_13),
    ],
)

sg181 = SpaceGroup(
    number=181,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P6422",
    point_group_name="PG622",
    crystal_system="HEXAGONAL",
    pdb_name="P 64 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_13),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_23),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_13),
        SymOp(Rot_XmY_X_Z, Tr_0_0_23),
        SymOp(Rot_Y_X_mZ, Tr_0_0_13),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_23),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_13),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_23),
    ],
)

sg182 = SpaceGroup(
    number=182,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P6322",
    point_group_name="PG622",
    crystal_system="HEXAGONAL",
    pdb_name="P 63 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_12),
        SymOp(Rot_XmY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_12),
    ],
)

sg183 = SpaceGroup(
    number=183,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P6mm",
    point_group_name="PG6mm",
    crystal_system="HEXAGONAL",
    pdb_name="P 6 m m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_0),
        SymOp(Rot_XmY_X_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_XmY_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_0),
    ],
)

sg184 = SpaceGroup(
    number=184,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P6cc",
    point_group_name="PG6mm",
    crystal_system="HEXAGONAL",
    pdb_name="P 6 c c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_0),
        SymOp(Rot_XmY_X_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_12),
        SymOp(Rot_X_XmY_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_12),
    ],
)

sg185 = SpaceGroup(
    number=185,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P63cm",
    point_group_name="PG6mm",
    crystal_system="HEXAGONAL",
    pdb_name="P 63 c m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_12),
        SymOp(Rot_XmY_X_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_12),
        SymOp(Rot_X_XmY_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_0),
    ],
)

sg186 = SpaceGroup(
    number=186,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P63mc",
    point_group_name="PG6mm",
    crystal_system="HEXAGONAL",
    pdb_name="P 63 m c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_12),
        SymOp(Rot_XmY_X_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_XmY_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_12),
    ],
)

sg187 = SpaceGroup(
    number=187,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P-6m2",
    point_group_name="PG6barm2",
    crystal_system="HEXAGONAL",
    pdb_name="P -6 m 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_mY_XmY_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_0),
    ],
)

sg188 = SpaceGroup(
    number=188,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P-6c2",
    point_group_name="PG6barm2",
    crystal_system="HEXAGONAL",
    pdb_name="P -6 c 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_12),
        SymOp(Rot_mY_XmY_mZ, Tr_0_0_12),
        SymOp(Rot_mXY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_12),
        SymOp(Rot_X_XmY_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_0),
    ],
)

sg189 = SpaceGroup(
    number=189,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P-62m",
    point_group_name="PG6bar2m",
    crystal_system="HEXAGONAL",
    pdb_name="P -6 2 m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_mY_XmY_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_0),
    ],
)

sg190 = SpaceGroup(
    number=190,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P-62c",
    point_group_name="PG6bar2m",
    crystal_system="HEXAGONAL",
    pdb_name="P -6 2 c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_12),
        SymOp(Rot_mY_XmY_mZ, Tr_0_0_12),
        SymOp(Rot_mXY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_12),
    ],
)

sg191 = SpaceGroup(
    number=191,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="P6/mmm",
    point_group_name="PG6/mmm",
    crystal_system="HEXAGONAL",
    pdb_name="P 6/m 2/m 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_0),
        SymOp(Rot_XmY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_XmY_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_XmY_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_0),
    ],
)

sg192 = SpaceGroup(
    number=192,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="P6/mcc",
    point_group_name="PG6/mmm",
    crystal_system="HEXAGONAL",
    pdb_name="P 6/m 2/c 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_0),
        SymOp(Rot_XmY_X_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_XmY_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_12),
        SymOp(Rot_X_XmY_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_12),
    ],
)

sg193 = SpaceGroup(
    number=193,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="P63/mcm",
    point_group_name="PG6/mmm",
    crystal_system="HEXAGONAL",
    pdb_name="P 63/m 2/c 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_12),
        SymOp(Rot_XmY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_12),
        SymOp(Rot_mXY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mY_XmY_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_12),
        SymOp(Rot_X_XmY_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_0),
    ],
)

sg194 = SpaceGroup(
    number=194,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="P63/mmc",
    point_group_name="PG6/mmm",
    crystal_system="HEXAGONAL",
    pdb_name="P 63/m 2/m 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mY_XmY_Z, Tr_0_0_0),
        SymOp(Rot_mXY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_Y_mXY_Z, Tr_0_0_12),
        SymOp(Rot_XmY_X_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mXY_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_XmY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mXY_mZ, Tr_0_0_0),
        SymOp(Rot_XmY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_12),
        SymOp(Rot_mXY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mY_XmY_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_mXY_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_XmY_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_XmY_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_mXY_Z, Tr_0_0_12),
    ],
)

sg195 = SpaceGroup(
    number=195,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P23",
    point_group_name="PG23",
    crystal_system="CUBIC",
    pdb_name="P 2 3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
    ],
)

sg196 = SpaceGroup(
    number=196,
    num_sym_equiv=48,
    num_primitive_sym_equiv=12,
    short_name="F23",
    point_group_name="PG23",
    crystal_system="CUBIC",
    pdb_name="F 2 3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_Z_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_12),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_12_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
    ],
)

sg197 = SpaceGroup(
    number=197,
    num_sym_equiv=24,
    num_primitive_sym_equiv=12,
    short_name="I23",
    point_group_name="PG23",
    crystal_system="CUBIC",
    pdb_name="I 2 3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_12),
        SymOp(Rot_mZ_X_mY, Tr_12_12_12),
        SymOp(Rot_Y_Z_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_12),
        SymOp(Rot_mY_mZ_X, Tr_12_12_12),
    ],
)

sg198 = SpaceGroup(
    number=198,
    num_sym_equiv=12,
    num_primitive_sym_equiv=12,
    short_name="P213",
    point_group_name="PG23",
    crystal_system="CUBIC",
    pdb_name="P 21 3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
    ],
)

sg199 = SpaceGroup(
    number=199,
    num_sym_equiv=24,
    num_primitive_sym_equiv=12,
    short_name="I213",
    point_group_name="PG23",
    crystal_system="CUBIC",
    pdb_name="I 21 3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_0_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_0),
    ],
)

sg200 = SpaceGroup(
    number=200,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="Pm-3",
    point_group_name="PGm3bar",
    crystal_system="CUBIC",
    pdb_name="P 2/m -3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_X_mY, Tr_0_0_0),
        SymOp(Rot_Z_mX_Y, Tr_0_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_X, Tr_0_0_0),
        SymOp(Rot_Y_Z_mX, Tr_0_0_0),
    ],
)

sg201 = SpaceGroup(
    number=201,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="Pn-3",
    point_group_name="PGm3bar",
    crystal_system="CUBIC",
    pdb_name="P 2/n -3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mZ_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_X_mY, Tr_12_12_12),
        SymOp(Rot_Z_mX_Y, Tr_12_12_12),
        SymOp(Rot_mY_mZ_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_X, Tr_12_12_12),
        SymOp(Rot_Y_Z_mX, Tr_12_12_12),
    ],
)

sg202 = SpaceGroup(
    number=202,
    num_sym_equiv=96,
    num_primitive_sym_equiv=24,
    short_name="Fm-3",
    point_group_name="PGm3bar",
    crystal_system="CUBIC",
    pdb_name="F 2/m -3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_X_mY, Tr_0_0_0),
        SymOp(Rot_Z_mX_Y, Tr_0_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_X, Tr_0_0_0),
        SymOp(Rot_Y_Z_mX, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_Z_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_12_12),
        SymOp(Rot_X_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_12_12),
        SymOp(Rot_mZ_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_X_mY, Tr_0_12_12),
        SymOp(Rot_Z_mX_Y, Tr_0_12_12),
        SymOp(Rot_mY_mZ_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_X, Tr_0_12_12),
        SymOp(Rot_Y_Z_mX, Tr_0_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_12),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_0_12),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_0_12),
        SymOp(Rot_mZ_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_X_mY, Tr_12_0_12),
        SymOp(Rot_Z_mX_Y, Tr_12_0_12),
        SymOp(Rot_mY_mZ_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_X, Tr_12_0_12),
        SymOp(Rot_Y_Z_mX, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_12_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mZ_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_X_mY, Tr_12_12_0),
        SymOp(Rot_Z_mX_Y, Tr_12_12_0),
        SymOp(Rot_mY_mZ_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_X, Tr_12_12_0),
        SymOp(Rot_Y_Z_mX, Tr_12_12_0),
    ],
)

sg203 = SpaceGroup(
    number=203,
    num_sym_equiv=96,
    num_primitive_sym_equiv=24,
    short_name="Fd-3",
    point_group_name="PGm3bar",
    crystal_system="CUBIC",
    pdb_name="F 2/d -3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_14_14_14),
        SymOp(Rot_X_Y_mZ, Tr_14_14_14),
        SymOp(Rot_X_mY_Z, Tr_14_14_14),
        SymOp(Rot_mX_Y_Z, Tr_14_14_14),
        SymOp(Rot_mZ_mX_mY, Tr_14_14_14),
        SymOp(Rot_mZ_X_Y, Tr_14_14_14),
        SymOp(Rot_Z_X_mY, Tr_14_14_14),
        SymOp(Rot_Z_mX_Y, Tr_14_14_14),
        SymOp(Rot_mY_mZ_mX, Tr_14_14_14),
        SymOp(Rot_Y_mZ_X, Tr_14_14_14),
        SymOp(Rot_mY_Z_X, Tr_14_14_14),
        SymOp(Rot_Y_Z_mX, Tr_14_14_14),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_Z_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_14_34_34),
        SymOp(Rot_X_Y_mZ, Tr_14_34_34),
        SymOp(Rot_X_mY_Z, Tr_14_34_34),
        SymOp(Rot_mX_Y_Z, Tr_14_34_34),
        SymOp(Rot_mZ_mX_mY, Tr_14_34_34),
        SymOp(Rot_mZ_X_Y, Tr_14_34_34),
        SymOp(Rot_Z_X_mY, Tr_14_34_34),
        SymOp(Rot_Z_mX_Y, Tr_14_34_34),
        SymOp(Rot_mY_mZ_mX, Tr_14_34_34),
        SymOp(Rot_Y_mZ_X, Tr_14_34_34),
        SymOp(Rot_mY_Z_X, Tr_14_34_34),
        SymOp(Rot_Y_Z_mX, Tr_14_34_34),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_12),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_34_14_34),
        SymOp(Rot_X_Y_mZ, Tr_34_14_34),
        SymOp(Rot_X_mY_Z, Tr_34_14_34),
        SymOp(Rot_mX_Y_Z, Tr_34_14_34),
        SymOp(Rot_mZ_mX_mY, Tr_34_14_34),
        SymOp(Rot_mZ_X_Y, Tr_34_14_34),
        SymOp(Rot_Z_X_mY, Tr_34_14_34),
        SymOp(Rot_Z_mX_Y, Tr_34_14_34),
        SymOp(Rot_mY_mZ_mX, Tr_34_14_34),
        SymOp(Rot_Y_mZ_X, Tr_34_14_34),
        SymOp(Rot_mY_Z_X, Tr_34_14_34),
        SymOp(Rot_Y_Z_mX, Tr_34_14_34),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_12_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_34_34_14),
        SymOp(Rot_X_Y_mZ, Tr_34_34_14),
        SymOp(Rot_X_mY_Z, Tr_34_34_14),
        SymOp(Rot_mX_Y_Z, Tr_34_34_14),
        SymOp(Rot_mZ_mX_mY, Tr_34_34_14),
        SymOp(Rot_mZ_X_Y, Tr_34_34_14),
        SymOp(Rot_Z_X_mY, Tr_34_34_14),
        SymOp(Rot_Z_mX_Y, Tr_34_34_14),
        SymOp(Rot_mY_mZ_mX, Tr_34_34_14),
        SymOp(Rot_Y_mZ_X, Tr_34_34_14),
        SymOp(Rot_mY_Z_X, Tr_34_34_14),
        SymOp(Rot_Y_Z_mX, Tr_34_34_14),
    ],
)

sg204 = SpaceGroup(
    number=204,
    num_sym_equiv=48,
    num_primitive_sym_equiv=24,
    short_name="Im-3",
    point_group_name="PGm3bar",
    crystal_system="CUBIC",
    pdb_name="I 2/m -3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_X_mY, Tr_0_0_0),
        SymOp(Rot_Z_mX_Y, Tr_0_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_X, Tr_0_0_0),
        SymOp(Rot_Y_Z_mX, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_12),
        SymOp(Rot_mZ_X_mY, Tr_12_12_12),
        SymOp(Rot_Y_Z_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_12),
        SymOp(Rot_mY_mZ_X, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mZ_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_X_mY, Tr_12_12_12),
        SymOp(Rot_Z_mX_Y, Tr_12_12_12),
        SymOp(Rot_mY_mZ_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_X, Tr_12_12_12),
        SymOp(Rot_Y_Z_mX, Tr_12_12_12),
    ],
)

sg205 = SpaceGroup(
    number=205,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="Pa-3",
    point_group_name="PGm3bar",
    crystal_system="CUBIC",
    pdb_name="P 21/a -3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_X_mY, Tr_12_0_12),
        SymOp(Rot_Z_mX_Y, Tr_0_12_12),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_X, Tr_12_12_0),
        SymOp(Rot_Y_Z_mX, Tr_12_0_12),
    ],
)

sg206 = SpaceGroup(
    number=206,
    num_sym_equiv=48,
    num_primitive_sym_equiv=24,
    short_name="Ia-3",
    point_group_name="PGm3bar",
    crystal_system="CUBIC",
    pdb_name="I 21/a -3",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_X_mY, Tr_12_0_12),
        SymOp(Rot_Z_mX_Y, Tr_0_12_12),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_X, Tr_12_12_0),
        SymOp(Rot_Y_Z_mX, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_0_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mZ_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_X_Y, Tr_0_0_12),
        SymOp(Rot_Z_X_mY, Tr_0_12_0),
        SymOp(Rot_Z_mX_Y, Tr_12_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_X, Tr_12_0_0),
        SymOp(Rot_mY_Z_X, Tr_0_0_12),
        SymOp(Rot_Y_Z_mX, Tr_0_12_0),
    ],
)

sg207 = SpaceGroup(
    number=207,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="P432",
    point_group_name="PG432",
    crystal_system="CUBIC",
    pdb_name="P 4 3 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Z_mY, Tr_0_0_0),
        SymOp(Rot_mX_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_mZ_Y, Tr_0_0_0),
        SymOp(Rot_Z_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_X, Tr_0_0_0),
        SymOp(Rot_mZ_mY_mX, Tr_0_0_0),
    ],
)

sg208 = SpaceGroup(
    number=208,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="P4232",
    point_group_name="PG432",
    crystal_system="CUBIC",
    pdb_name="P 42 3 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_X_Z_mY, Tr_12_12_12),
        SymOp(Rot_mX_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_mZ_mY, Tr_12_12_12),
        SymOp(Rot_X_mZ_Y, Tr_12_12_12),
        SymOp(Rot_Z_Y_mX, Tr_12_12_12),
        SymOp(Rot_Z_mY_X, Tr_12_12_12),
        SymOp(Rot_mZ_Y_X, Tr_12_12_12),
        SymOp(Rot_mZ_mY_mX, Tr_12_12_12),
    ],
)

sg209 = SpaceGroup(
    number=209,
    num_sym_equiv=96,
    num_primitive_sym_equiv=24,
    short_name="F432",
    point_group_name="PG432",
    crystal_system="CUBIC",
    pdb_name="F 4 3 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Z_mY, Tr_0_0_0),
        SymOp(Rot_mX_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_mZ_Y, Tr_0_0_0),
        SymOp(Rot_Z_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_X, Tr_0_0_0),
        SymOp(Rot_mZ_mY_mX, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_Z_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_12),
        SymOp(Rot_Y_X_mZ, Tr_0_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_12_12),
        SymOp(Rot_Y_mX_Z, Tr_0_12_12),
        SymOp(Rot_mY_X_Z, Tr_0_12_12),
        SymOp(Rot_X_Z_mY, Tr_0_12_12),
        SymOp(Rot_mX_Z_Y, Tr_0_12_12),
        SymOp(Rot_mX_mZ_mY, Tr_0_12_12),
        SymOp(Rot_X_mZ_Y, Tr_0_12_12),
        SymOp(Rot_Z_Y_mX, Tr_0_12_12),
        SymOp(Rot_Z_mY_X, Tr_0_12_12),
        SymOp(Rot_mZ_Y_X, Tr_0_12_12),
        SymOp(Rot_mZ_mY_mX, Tr_0_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_12),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_mZ, Tr_12_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_0_12),
        SymOp(Rot_Y_mX_Z, Tr_12_0_12),
        SymOp(Rot_mY_X_Z, Tr_12_0_12),
        SymOp(Rot_X_Z_mY, Tr_12_0_12),
        SymOp(Rot_mX_Z_Y, Tr_12_0_12),
        SymOp(Rot_mX_mZ_mY, Tr_12_0_12),
        SymOp(Rot_X_mZ_Y, Tr_12_0_12),
        SymOp(Rot_Z_Y_mX, Tr_12_0_12),
        SymOp(Rot_Z_mY_X, Tr_12_0_12),
        SymOp(Rot_mZ_Y_X, Tr_12_0_12),
        SymOp(Rot_mZ_mY_mX, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_12_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_0),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_0),
        SymOp(Rot_Y_mX_Z, Tr_12_12_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_0),
        SymOp(Rot_X_Z_mY, Tr_12_12_0),
        SymOp(Rot_mX_Z_Y, Tr_12_12_0),
        SymOp(Rot_mX_mZ_mY, Tr_12_12_0),
        SymOp(Rot_X_mZ_Y, Tr_12_12_0),
        SymOp(Rot_Z_Y_mX, Tr_12_12_0),
        SymOp(Rot_Z_mY_X, Tr_12_12_0),
        SymOp(Rot_mZ_Y_X, Tr_12_12_0),
        SymOp(Rot_mZ_mY_mX, Tr_12_12_0),
    ],
)

sg210 = SpaceGroup(
    number=210,
    num_sym_equiv=96,
    num_primitive_sym_equiv=24,
    short_name="F4132",
    point_group_name="PG432",
    crystal_system="CUBIC",
    pdb_name="F 41 3 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_12_12_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_12),
        SymOp(Rot_Y_X_mZ, Tr_34_14_34),
        SymOp(Rot_mY_mX_mZ, Tr_14_14_14),
        SymOp(Rot_Y_mX_Z, Tr_14_34_34),
        SymOp(Rot_mY_X_Z, Tr_34_34_14),
        SymOp(Rot_X_Z_mY, Tr_34_14_34),
        SymOp(Rot_mX_Z_Y, Tr_34_34_14),
        SymOp(Rot_mX_mZ_mY, Tr_14_14_14),
        SymOp(Rot_X_mZ_Y, Tr_14_34_34),
        SymOp(Rot_Z_Y_mX, Tr_34_14_34),
        SymOp(Rot_Z_mY_X, Tr_14_34_34),
        SymOp(Rot_mZ_Y_X, Tr_34_34_14),
        SymOp(Rot_mZ_mY_mX, Tr_14_14_14),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_34_34_14),
        SymOp(Rot_mY_mX_mZ, Tr_14_34_34),
        SymOp(Rot_Y_mX_Z, Tr_14_14_14),
        SymOp(Rot_mY_X_Z, Tr_34_14_34),
        SymOp(Rot_X_Z_mY, Tr_34_34_14),
        SymOp(Rot_mX_Z_Y, Tr_34_14_34),
        SymOp(Rot_mX_mZ_mY, Tr_14_34_34),
        SymOp(Rot_X_mZ_Y, Tr_14_14_14),
        SymOp(Rot_Z_Y_mX, Tr_34_34_14),
        SymOp(Rot_Z_mY_X, Tr_14_14_14),
        SymOp(Rot_mZ_Y_X, Tr_34_14_34),
        SymOp(Rot_mZ_mY_mX, Tr_14_34_34),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_14_14_14),
        SymOp(Rot_mY_mX_mZ, Tr_34_14_34),
        SymOp(Rot_Y_mX_Z, Tr_34_34_14),
        SymOp(Rot_mY_X_Z, Tr_14_34_34),
        SymOp(Rot_X_Z_mY, Tr_14_14_14),
        SymOp(Rot_mX_Z_Y, Tr_14_34_34),
        SymOp(Rot_mX_mZ_mY, Tr_34_14_34),
        SymOp(Rot_X_mZ_Y, Tr_34_34_14),
        SymOp(Rot_Z_Y_mX, Tr_14_14_14),
        SymOp(Rot_Z_mY_X, Tr_34_34_14),
        SymOp(Rot_mZ_Y_X, Tr_14_34_34),
        SymOp(Rot_mZ_mY_mX, Tr_34_14_34),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_mZ, Tr_14_34_34),
        SymOp(Rot_mY_mX_mZ, Tr_34_34_14),
        SymOp(Rot_Y_mX_Z, Tr_34_14_34),
        SymOp(Rot_mY_X_Z, Tr_14_14_14),
        SymOp(Rot_X_Z_mY, Tr_14_34_34),
        SymOp(Rot_mX_Z_Y, Tr_14_14_14),
        SymOp(Rot_mX_mZ_mY, Tr_34_34_14),
        SymOp(Rot_X_mZ_Y, Tr_34_14_34),
        SymOp(Rot_Z_Y_mX, Tr_14_34_34),
        SymOp(Rot_Z_mY_X, Tr_34_14_34),
        SymOp(Rot_mZ_Y_X, Tr_14_14_14),
        SymOp(Rot_mZ_mY_mX, Tr_34_34_14),
    ],
)

sg211 = SpaceGroup(
    number=211,
    num_sym_equiv=48,
    num_primitive_sym_equiv=24,
    short_name="I432",
    point_group_name="PG432",
    crystal_system="CUBIC",
    pdb_name="I 4 3 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Z_mY, Tr_0_0_0),
        SymOp(Rot_mX_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_mZ_Y, Tr_0_0_0),
        SymOp(Rot_Z_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_X, Tr_0_0_0),
        SymOp(Rot_mZ_mY_mX, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_12),
        SymOp(Rot_mZ_X_mY, Tr_12_12_12),
        SymOp(Rot_Y_Z_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_12),
        SymOp(Rot_mY_mZ_X, Tr_12_12_12),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_X_Z_mY, Tr_12_12_12),
        SymOp(Rot_mX_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_mZ_mY, Tr_12_12_12),
        SymOp(Rot_X_mZ_Y, Tr_12_12_12),
        SymOp(Rot_Z_Y_mX, Tr_12_12_12),
        SymOp(Rot_Z_mY_X, Tr_12_12_12),
        SymOp(Rot_mZ_Y_X, Tr_12_12_12),
        SymOp(Rot_mZ_mY_mX, Tr_12_12_12),
    ],
)

sg212 = SpaceGroup(
    number=212,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="P4332",
    point_group_name="PG432",
    crystal_system="CUBIC",
    pdb_name="P 43 3 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_mZ, Tr_14_34_34),
        SymOp(Rot_mY_mX_mZ, Tr_14_14_14),
        SymOp(Rot_Y_mX_Z, Tr_34_34_14),
        SymOp(Rot_mY_X_Z, Tr_34_14_34),
        SymOp(Rot_X_Z_mY, Tr_14_34_34),
        SymOp(Rot_mX_Z_Y, Tr_34_14_34),
        SymOp(Rot_mX_mZ_mY, Tr_14_14_14),
        SymOp(Rot_X_mZ_Y, Tr_34_34_14),
        SymOp(Rot_Z_Y_mX, Tr_14_34_34),
        SymOp(Rot_Z_mY_X, Tr_34_34_14),
        SymOp(Rot_mZ_Y_X, Tr_34_14_34),
        SymOp(Rot_mZ_mY_mX, Tr_14_14_14),
    ],
)

sg213 = SpaceGroup(
    number=213,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="P4132",
    point_group_name="PG432",
    crystal_system="CUBIC",
    pdb_name="P 41 3 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_mZ, Tr_34_14_14),
        SymOp(Rot_mY_mX_mZ, Tr_34_34_34),
        SymOp(Rot_Y_mX_Z, Tr_14_14_34),
        SymOp(Rot_mY_X_Z, Tr_14_34_14),
        SymOp(Rot_X_Z_mY, Tr_34_14_14),
        SymOp(Rot_mX_Z_Y, Tr_14_34_14),
        SymOp(Rot_mX_mZ_mY, Tr_34_34_34),
        SymOp(Rot_X_mZ_Y, Tr_14_14_34),
        SymOp(Rot_Z_Y_mX, Tr_34_14_14),
        SymOp(Rot_Z_mY_X, Tr_14_14_34),
        SymOp(Rot_mZ_Y_X, Tr_14_34_14),
        SymOp(Rot_mZ_mY_mX, Tr_34_34_34),
    ],
)

sg214 = SpaceGroup(
    number=214,
    num_sym_equiv=48,
    num_primitive_sym_equiv=24,
    short_name="I4132",
    point_group_name="PG432",
    crystal_system="CUBIC",
    pdb_name="I 41 3 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_mZ, Tr_34_14_14),
        SymOp(Rot_mY_mX_mZ, Tr_34_34_34),
        SymOp(Rot_Y_mX_Z, Tr_14_14_34),
        SymOp(Rot_mY_X_Z, Tr_14_34_14),
        SymOp(Rot_X_Z_mY, Tr_34_14_14),
        SymOp(Rot_mX_Z_Y, Tr_14_34_14),
        SymOp(Rot_mX_mZ_mY, Tr_34_34_34),
        SymOp(Rot_X_mZ_Y, Tr_14_14_34),
        SymOp(Rot_Z_Y_mX, Tr_34_14_14),
        SymOp(Rot_Z_mY_X, Tr_14_14_34),
        SymOp(Rot_mZ_Y_X, Tr_14_34_14),
        SymOp(Rot_mZ_mY_mX, Tr_34_34_34),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_0_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_0),
        SymOp(Rot_Y_X_mZ, Tr_14_34_34),
        SymOp(Rot_mY_mX_mZ, Tr_14_14_14),
        SymOp(Rot_Y_mX_Z, Tr_34_34_14),
        SymOp(Rot_mY_X_Z, Tr_34_14_34),
        SymOp(Rot_X_Z_mY, Tr_14_34_34),
        SymOp(Rot_mX_Z_Y, Tr_34_14_34),
        SymOp(Rot_mX_mZ_mY, Tr_14_14_14),
        SymOp(Rot_X_mZ_Y, Tr_34_34_14),
        SymOp(Rot_Z_Y_mX, Tr_14_34_34),
        SymOp(Rot_Z_mY_X, Tr_34_34_14),
        SymOp(Rot_mZ_Y_X, Tr_34_14_34),
        SymOp(Rot_mZ_mY_mX, Tr_14_14_14),
    ],
)

sg215 = SpaceGroup(
    number=215,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="P-43m",
    point_group_name="PG4bar3m",
    crystal_system="CUBIC",
    pdb_name="P -4 3 m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_Z_mY, Tr_0_0_0),
        SymOp(Rot_mX_mZ_Y, Tr_0_0_0),
        SymOp(Rot_X_mZ_mY, Tr_0_0_0),
        SymOp(Rot_Z_Y_X, Tr_0_0_0),
        SymOp(Rot_Z_mY_mX, Tr_0_0_0),
        SymOp(Rot_mZ_Y_mX, Tr_0_0_0),
        SymOp(Rot_mZ_mY_X, Tr_0_0_0),
    ],
)

sg216 = SpaceGroup(
    number=216,
    num_sym_equiv=96,
    num_primitive_sym_equiv=24,
    short_name="F-43m",
    point_group_name="PG4bar3m",
    crystal_system="CUBIC",
    pdb_name="F -4 3 m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_Z_mY, Tr_0_0_0),
        SymOp(Rot_mX_mZ_Y, Tr_0_0_0),
        SymOp(Rot_X_mZ_mY, Tr_0_0_0),
        SymOp(Rot_Z_Y_X, Tr_0_0_0),
        SymOp(Rot_Z_mY_mX, Tr_0_0_0),
        SymOp(Rot_mZ_Y_mX, Tr_0_0_0),
        SymOp(Rot_mZ_mY_X, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_Z_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_12),
        SymOp(Rot_Y_X_Z, Tr_0_12_12),
        SymOp(Rot_mY_mX_Z, Tr_0_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_0_12_12),
        SymOp(Rot_mY_X_mZ, Tr_0_12_12),
        SymOp(Rot_X_Z_Y, Tr_0_12_12),
        SymOp(Rot_mX_Z_mY, Tr_0_12_12),
        SymOp(Rot_mX_mZ_Y, Tr_0_12_12),
        SymOp(Rot_X_mZ_mY, Tr_0_12_12),
        SymOp(Rot_Z_Y_X, Tr_0_12_12),
        SymOp(Rot_Z_mY_mX, Tr_0_12_12),
        SymOp(Rot_mZ_Y_mX, Tr_0_12_12),
        SymOp(Rot_mZ_mY_X, Tr_0_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_12),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_Z, Tr_12_0_12),
        SymOp(Rot_mY_mX_Z, Tr_12_0_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_0_12),
        SymOp(Rot_mY_X_mZ, Tr_12_0_12),
        SymOp(Rot_X_Z_Y, Tr_12_0_12),
        SymOp(Rot_mX_Z_mY, Tr_12_0_12),
        SymOp(Rot_mX_mZ_Y, Tr_12_0_12),
        SymOp(Rot_X_mZ_mY, Tr_12_0_12),
        SymOp(Rot_Z_Y_X, Tr_12_0_12),
        SymOp(Rot_Z_mY_mX, Tr_12_0_12),
        SymOp(Rot_mZ_Y_mX, Tr_12_0_12),
        SymOp(Rot_mZ_mY_X, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_12_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_0),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_0),
        SymOp(Rot_mY_X_mZ, Tr_12_12_0),
        SymOp(Rot_X_Z_Y, Tr_12_12_0),
        SymOp(Rot_mX_Z_mY, Tr_12_12_0),
        SymOp(Rot_mX_mZ_Y, Tr_12_12_0),
        SymOp(Rot_X_mZ_mY, Tr_12_12_0),
        SymOp(Rot_Z_Y_X, Tr_12_12_0),
        SymOp(Rot_Z_mY_mX, Tr_12_12_0),
        SymOp(Rot_mZ_Y_mX, Tr_12_12_0),
        SymOp(Rot_mZ_mY_X, Tr_12_12_0),
    ],
)

sg217 = SpaceGroup(
    number=217,
    num_sym_equiv=48,
    num_primitive_sym_equiv=24,
    short_name="I-43m",
    point_group_name="PG4bar3m",
    crystal_system="CUBIC",
    pdb_name="I -4 3 m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_X_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_Z_mY, Tr_0_0_0),
        SymOp(Rot_mX_mZ_Y, Tr_0_0_0),
        SymOp(Rot_X_mZ_mY, Tr_0_0_0),
        SymOp(Rot_Z_Y_X, Tr_0_0_0),
        SymOp(Rot_Z_mY_mX, Tr_0_0_0),
        SymOp(Rot_mZ_Y_mX, Tr_0_0_0),
        SymOp(Rot_mZ_mY_X, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_12),
        SymOp(Rot_mZ_X_mY, Tr_12_12_12),
        SymOp(Rot_Y_Z_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_12),
        SymOp(Rot_mY_mZ_X, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_X_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_Z_mY, Tr_12_12_12),
        SymOp(Rot_mX_mZ_Y, Tr_12_12_12),
        SymOp(Rot_X_mZ_mY, Tr_12_12_12),
        SymOp(Rot_Z_Y_X, Tr_12_12_12),
        SymOp(Rot_Z_mY_mX, Tr_12_12_12),
        SymOp(Rot_mZ_Y_mX, Tr_12_12_12),
        SymOp(Rot_mZ_mY_X, Tr_12_12_12),
    ],
)

sg218 = SpaceGroup(
    number=218,
    num_sym_equiv=24,
    num_primitive_sym_equiv=24,
    short_name="P-43n",
    point_group_name="PG4bar3m",
    crystal_system="CUBIC",
    pdb_name="P -4 3 n",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_X_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_Z_mY, Tr_12_12_12),
        SymOp(Rot_mX_mZ_Y, Tr_12_12_12),
        SymOp(Rot_X_mZ_mY, Tr_12_12_12),
        SymOp(Rot_Z_Y_X, Tr_12_12_12),
        SymOp(Rot_Z_mY_mX, Tr_12_12_12),
        SymOp(Rot_mZ_Y_mX, Tr_12_12_12),
        SymOp(Rot_mZ_mY_X, Tr_12_12_12),
    ],
)

sg219 = SpaceGroup(
    number=219,
    num_sym_equiv=96,
    num_primitive_sym_equiv=24,
    short_name="F-43c",
    point_group_name="PG4bar3m",
    crystal_system="CUBIC",
    pdb_name="F -4 3 c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_X_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_Z_mY, Tr_12_12_12),
        SymOp(Rot_mX_mZ_Y, Tr_12_12_12),
        SymOp(Rot_X_mZ_mY, Tr_12_12_12),
        SymOp(Rot_Z_Y_X, Tr_12_12_12),
        SymOp(Rot_Z_mY_mX, Tr_12_12_12),
        SymOp(Rot_mZ_Y_mX, Tr_12_12_12),
        SymOp(Rot_mZ_mY_X, Tr_12_12_12),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_Z_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_0_0),
        SymOp(Rot_mY_mX_Z, Tr_12_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_12_0_0),
        SymOp(Rot_mY_X_mZ, Tr_12_0_0),
        SymOp(Rot_X_Z_Y, Tr_12_0_0),
        SymOp(Rot_mX_Z_mY, Tr_12_0_0),
        SymOp(Rot_mX_mZ_Y, Tr_12_0_0),
        SymOp(Rot_X_mZ_mY, Tr_12_0_0),
        SymOp(Rot_Z_Y_X, Tr_12_0_0),
        SymOp(Rot_Z_mY_mX, Tr_12_0_0),
        SymOp(Rot_mZ_Y_mX, Tr_12_0_0),
        SymOp(Rot_mZ_mY_X, Tr_12_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_12),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_12_0),
        SymOp(Rot_mY_mX_Z, Tr_0_12_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_12_0),
        SymOp(Rot_mY_X_mZ, Tr_0_12_0),
        SymOp(Rot_X_Z_Y, Tr_0_12_0),
        SymOp(Rot_mX_Z_mY, Tr_0_12_0),
        SymOp(Rot_mX_mZ_Y, Tr_0_12_0),
        SymOp(Rot_X_mZ_mY, Tr_0_12_0),
        SymOp(Rot_Z_Y_X, Tr_0_12_0),
        SymOp(Rot_Z_mY_mX, Tr_0_12_0),
        SymOp(Rot_mZ_Y_mX, Tr_0_12_0),
        SymOp(Rot_mZ_mY_X, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_12_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mY_X_mZ, Tr_0_0_12),
        SymOp(Rot_X_Z_Y, Tr_0_0_12),
        SymOp(Rot_mX_Z_mY, Tr_0_0_12),
        SymOp(Rot_mX_mZ_Y, Tr_0_0_12),
        SymOp(Rot_X_mZ_mY, Tr_0_0_12),
        SymOp(Rot_Z_Y_X, Tr_0_0_12),
        SymOp(Rot_Z_mY_mX, Tr_0_0_12),
        SymOp(Rot_mZ_Y_mX, Tr_0_0_12),
        SymOp(Rot_mZ_mY_X, Tr_0_0_12),
    ],
)

sg220 = SpaceGroup(
    number=220,
    num_sym_equiv=48,
    num_primitive_sym_equiv=24,
    short_name="I-43d",
    point_group_name="PG4bar3m",
    crystal_system="CUBIC",
    pdb_name="I -4 3 d",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_Z, Tr_14_14_14),
        SymOp(Rot_mY_mX_Z, Tr_14_34_34),
        SymOp(Rot_Y_mX_mZ, Tr_34_14_34),
        SymOp(Rot_mY_X_mZ, Tr_34_34_14),
        SymOp(Rot_X_Z_Y, Tr_14_14_14),
        SymOp(Rot_mX_Z_mY, Tr_34_34_14),
        SymOp(Rot_mX_mZ_Y, Tr_14_34_34),
        SymOp(Rot_X_mZ_mY, Tr_34_14_34),
        SymOp(Rot_Z_Y_X, Tr_14_14_14),
        SymOp(Rot_Z_mY_mX, Tr_34_14_34),
        SymOp(Rot_mZ_Y_mX, Tr_34_34_14),
        SymOp(Rot_mZ_mY_X, Tr_14_34_34),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_0_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_0),
        SymOp(Rot_Y_X_Z, Tr_34_34_34),
        SymOp(Rot_mY_mX_Z, Tr_34_14_14),
        SymOp(Rot_Y_mX_mZ, Tr_14_34_14),
        SymOp(Rot_mY_X_mZ, Tr_14_14_34),
        SymOp(Rot_X_Z_Y, Tr_34_34_34),
        SymOp(Rot_mX_Z_mY, Tr_14_14_34),
        SymOp(Rot_mX_mZ_Y, Tr_34_14_14),
        SymOp(Rot_X_mZ_mY, Tr_14_34_14),
        SymOp(Rot_Z_Y_X, Tr_34_34_34),
        SymOp(Rot_Z_mY_mX, Tr_14_34_14),
        SymOp(Rot_mZ_Y_mX, Tr_14_14_34),
        SymOp(Rot_mZ_mY_X, Tr_34_14_14),
    ],
)

sg221 = SpaceGroup(
    number=221,
    num_sym_equiv=48,
    num_primitive_sym_equiv=48,
    short_name="Pm-3m",
    point_group_name="PGm3barm",
    crystal_system="CUBIC",
    pdb_name="P 4/m -3 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Z_mY, Tr_0_0_0),
        SymOp(Rot_mX_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_mZ_Y, Tr_0_0_0),
        SymOp(Rot_Z_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_X, Tr_0_0_0),
        SymOp(Rot_mZ_mY_mX, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_X_mY, Tr_0_0_0),
        SymOp(Rot_Z_mX_Y, Tr_0_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_X, Tr_0_0_0),
        SymOp(Rot_Y_Z_mX, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mZ_Y, Tr_0_0_0),
        SymOp(Rot_X_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_Z_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_mX, Tr_0_0_0),
        SymOp(Rot_Z_Y_X, Tr_0_0_0),
    ],
)

sg222 = SpaceGroup(
    number=222,
    num_sym_equiv=48,
    num_primitive_sym_equiv=48,
    short_name="Pn-3n",
    point_group_name="PGm3barm",
    crystal_system="CUBIC",
    pdb_name="P 4/n -3 2/n",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Z_mY, Tr_0_0_0),
        SymOp(Rot_mX_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_mZ_Y, Tr_0_0_0),
        SymOp(Rot_Z_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_X, Tr_0_0_0),
        SymOp(Rot_mZ_mY_mX, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mZ_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_X_mY, Tr_12_12_12),
        SymOp(Rot_Z_mX_Y, Tr_12_12_12),
        SymOp(Rot_mY_mZ_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_X, Tr_12_12_12),
        SymOp(Rot_Y_Z_mX, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mZ_Y, Tr_12_12_12),
        SymOp(Rot_X_mZ_mY, Tr_12_12_12),
        SymOp(Rot_X_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_Z_mY, Tr_12_12_12),
        SymOp(Rot_mZ_mY_X, Tr_12_12_12),
        SymOp(Rot_mZ_Y_mX, Tr_12_12_12),
        SymOp(Rot_Z_mY_mX, Tr_12_12_12),
        SymOp(Rot_Z_Y_X, Tr_12_12_12),
    ],
)

sg223 = SpaceGroup(
    number=223,
    num_sym_equiv=48,
    num_primitive_sym_equiv=48,
    short_name="Pm-3n",
    point_group_name="PGm3barm",
    crystal_system="CUBIC",
    pdb_name="P 42/m -3 2/n",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_X_Z_mY, Tr_12_12_12),
        SymOp(Rot_mX_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_mZ_mY, Tr_12_12_12),
        SymOp(Rot_X_mZ_Y, Tr_12_12_12),
        SymOp(Rot_Z_Y_mX, Tr_12_12_12),
        SymOp(Rot_Z_mY_X, Tr_12_12_12),
        SymOp(Rot_mZ_Y_X, Tr_12_12_12),
        SymOp(Rot_mZ_mY_mX, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_X_mY, Tr_0_0_0),
        SymOp(Rot_Z_mX_Y, Tr_0_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_X, Tr_0_0_0),
        SymOp(Rot_Y_Z_mX, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mZ_Y, Tr_12_12_12),
        SymOp(Rot_X_mZ_mY, Tr_12_12_12),
        SymOp(Rot_X_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_Z_mY, Tr_12_12_12),
        SymOp(Rot_mZ_mY_X, Tr_12_12_12),
        SymOp(Rot_mZ_Y_mX, Tr_12_12_12),
        SymOp(Rot_Z_mY_mX, Tr_12_12_12),
        SymOp(Rot_Z_Y_X, Tr_12_12_12),
    ],
)

sg224 = SpaceGroup(
    number=224,
    num_sym_equiv=48,
    num_primitive_sym_equiv=48,
    short_name="Pn-3m",
    point_group_name="PGm3barm",
    crystal_system="CUBIC",
    pdb_name="P 42/n -3 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_X_Z_mY, Tr_12_12_12),
        SymOp(Rot_mX_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_mZ_mY, Tr_12_12_12),
        SymOp(Rot_X_mZ_Y, Tr_12_12_12),
        SymOp(Rot_Z_Y_mX, Tr_12_12_12),
        SymOp(Rot_Z_mY_X, Tr_12_12_12),
        SymOp(Rot_mZ_Y_X, Tr_12_12_12),
        SymOp(Rot_mZ_mY_mX, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mZ_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_X_mY, Tr_12_12_12),
        SymOp(Rot_Z_mX_Y, Tr_12_12_12),
        SymOp(Rot_mY_mZ_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_X, Tr_12_12_12),
        SymOp(Rot_Y_Z_mX, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mZ_Y, Tr_0_0_0),
        SymOp(Rot_X_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_Z_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_mX, Tr_0_0_0),
        SymOp(Rot_Z_Y_X, Tr_0_0_0),
    ],
)

sg225 = SpaceGroup(
    number=225,
    num_sym_equiv=192,
    num_primitive_sym_equiv=48,
    short_name="Fm-3m",
    point_group_name="PGm3barm",
    crystal_system="CUBIC",
    pdb_name="F 4/m -3 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Z_mY, Tr_0_0_0),
        SymOp(Rot_mX_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_mZ_Y, Tr_0_0_0),
        SymOp(Rot_Z_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_X, Tr_0_0_0),
        SymOp(Rot_mZ_mY_mX, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_X_mY, Tr_0_0_0),
        SymOp(Rot_Z_mX_Y, Tr_0_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_X, Tr_0_0_0),
        SymOp(Rot_Y_Z_mX, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mZ_Y, Tr_0_0_0),
        SymOp(Rot_X_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_Z_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_mX, Tr_0_0_0),
        SymOp(Rot_Z_Y_X, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_Z_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_12),
        SymOp(Rot_Y_X_mZ, Tr_0_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_12_12),
        SymOp(Rot_Y_mX_Z, Tr_0_12_12),
        SymOp(Rot_mY_X_Z, Tr_0_12_12),
        SymOp(Rot_X_Z_mY, Tr_0_12_12),
        SymOp(Rot_mX_Z_Y, Tr_0_12_12),
        SymOp(Rot_mX_mZ_mY, Tr_0_12_12),
        SymOp(Rot_X_mZ_Y, Tr_0_12_12),
        SymOp(Rot_Z_Y_mX, Tr_0_12_12),
        SymOp(Rot_Z_mY_X, Tr_0_12_12),
        SymOp(Rot_mZ_Y_X, Tr_0_12_12),
        SymOp(Rot_mZ_mY_mX, Tr_0_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_12_12),
        SymOp(Rot_X_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_12_12),
        SymOp(Rot_mZ_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_X_mY, Tr_0_12_12),
        SymOp(Rot_Z_mX_Y, Tr_0_12_12),
        SymOp(Rot_mY_mZ_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_X, Tr_0_12_12),
        SymOp(Rot_Y_Z_mX, Tr_0_12_12),
        SymOp(Rot_mY_mX_Z, Tr_0_12_12),
        SymOp(Rot_Y_X_Z, Tr_0_12_12),
        SymOp(Rot_mY_X_mZ, Tr_0_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_0_12_12),
        SymOp(Rot_mX_mZ_Y, Tr_0_12_12),
        SymOp(Rot_X_mZ_mY, Tr_0_12_12),
        SymOp(Rot_X_Z_Y, Tr_0_12_12),
        SymOp(Rot_mX_Z_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mY_X, Tr_0_12_12),
        SymOp(Rot_mZ_Y_mX, Tr_0_12_12),
        SymOp(Rot_Z_mY_mX, Tr_0_12_12),
        SymOp(Rot_Z_Y_X, Tr_0_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_12),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_mZ, Tr_12_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_0_12),
        SymOp(Rot_Y_mX_Z, Tr_12_0_12),
        SymOp(Rot_mY_X_Z, Tr_12_0_12),
        SymOp(Rot_X_Z_mY, Tr_12_0_12),
        SymOp(Rot_mX_Z_Y, Tr_12_0_12),
        SymOp(Rot_mX_mZ_mY, Tr_12_0_12),
        SymOp(Rot_X_mZ_Y, Tr_12_0_12),
        SymOp(Rot_Z_Y_mX, Tr_12_0_12),
        SymOp(Rot_Z_mY_X, Tr_12_0_12),
        SymOp(Rot_mZ_Y_X, Tr_12_0_12),
        SymOp(Rot_mZ_mY_mX, Tr_12_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_0_12),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_0_12),
        SymOp(Rot_mZ_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_X_mY, Tr_12_0_12),
        SymOp(Rot_Z_mX_Y, Tr_12_0_12),
        SymOp(Rot_mY_mZ_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_X, Tr_12_0_12),
        SymOp(Rot_Y_Z_mX, Tr_12_0_12),
        SymOp(Rot_mY_mX_Z, Tr_12_0_12),
        SymOp(Rot_Y_X_Z, Tr_12_0_12),
        SymOp(Rot_mY_X_mZ, Tr_12_0_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_0_12),
        SymOp(Rot_mX_mZ_Y, Tr_12_0_12),
        SymOp(Rot_X_mZ_mY, Tr_12_0_12),
        SymOp(Rot_X_Z_Y, Tr_12_0_12),
        SymOp(Rot_mX_Z_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mY_X, Tr_12_0_12),
        SymOp(Rot_mZ_Y_mX, Tr_12_0_12),
        SymOp(Rot_Z_mY_mX, Tr_12_0_12),
        SymOp(Rot_Z_Y_X, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_12_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_0),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_0),
        SymOp(Rot_Y_mX_Z, Tr_12_12_0),
        SymOp(Rot_mY_X_Z, Tr_12_12_0),
        SymOp(Rot_X_Z_mY, Tr_12_12_0),
        SymOp(Rot_mX_Z_Y, Tr_12_12_0),
        SymOp(Rot_mX_mZ_mY, Tr_12_12_0),
        SymOp(Rot_X_mZ_Y, Tr_12_12_0),
        SymOp(Rot_Z_Y_mX, Tr_12_12_0),
        SymOp(Rot_Z_mY_X, Tr_12_12_0),
        SymOp(Rot_mZ_Y_X, Tr_12_12_0),
        SymOp(Rot_mZ_mY_mX, Tr_12_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mZ_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_X_mY, Tr_12_12_0),
        SymOp(Rot_Z_mX_Y, Tr_12_12_0),
        SymOp(Rot_mY_mZ_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_X, Tr_12_12_0),
        SymOp(Rot_Y_Z_mX, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_0),
        SymOp(Rot_mY_X_mZ, Tr_12_12_0),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mZ_Y, Tr_12_12_0),
        SymOp(Rot_X_mZ_mY, Tr_12_12_0),
        SymOp(Rot_X_Z_Y, Tr_12_12_0),
        SymOp(Rot_mX_Z_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mY_X, Tr_12_12_0),
        SymOp(Rot_mZ_Y_mX, Tr_12_12_0),
        SymOp(Rot_Z_mY_mX, Tr_12_12_0),
        SymOp(Rot_Z_Y_X, Tr_12_12_0),
    ],
)

sg226 = SpaceGroup(
    number=226,
    num_sym_equiv=192,
    num_primitive_sym_equiv=48,
    short_name="Fm-3c",
    point_group_name="PGm3barm",
    crystal_system="CUBIC",
    pdb_name="F 4/m -3 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_X_Z_mY, Tr_12_12_12),
        SymOp(Rot_mX_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_mZ_mY, Tr_12_12_12),
        SymOp(Rot_X_mZ_Y, Tr_12_12_12),
        SymOp(Rot_Z_Y_mX, Tr_12_12_12),
        SymOp(Rot_Z_mY_X, Tr_12_12_12),
        SymOp(Rot_mZ_Y_X, Tr_12_12_12),
        SymOp(Rot_mZ_mY_mX, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_X_mY, Tr_0_0_0),
        SymOp(Rot_Z_mX_Y, Tr_0_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_X, Tr_0_0_0),
        SymOp(Rot_Y_Z_mX, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mZ_Y, Tr_12_12_12),
        SymOp(Rot_X_mZ_mY, Tr_12_12_12),
        SymOp(Rot_X_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_Z_mY, Tr_12_12_12),
        SymOp(Rot_mZ_mY_X, Tr_12_12_12),
        SymOp(Rot_mZ_Y_mX, Tr_12_12_12),
        SymOp(Rot_Z_mY_mX, Tr_12_12_12),
        SymOp(Rot_Z_Y_X, Tr_12_12_12),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_Z_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_12),
        SymOp(Rot_Y_X_mZ, Tr_12_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_12_0_0),
        SymOp(Rot_Y_mX_Z, Tr_12_0_0),
        SymOp(Rot_mY_X_Z, Tr_12_0_0),
        SymOp(Rot_X_Z_mY, Tr_12_0_0),
        SymOp(Rot_mX_Z_Y, Tr_12_0_0),
        SymOp(Rot_mX_mZ_mY, Tr_12_0_0),
        SymOp(Rot_X_mZ_Y, Tr_12_0_0),
        SymOp(Rot_Z_Y_mX, Tr_12_0_0),
        SymOp(Rot_Z_mY_X, Tr_12_0_0),
        SymOp(Rot_mZ_Y_X, Tr_12_0_0),
        SymOp(Rot_mZ_mY_mX, Tr_12_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_12_12),
        SymOp(Rot_X_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_0_12_12),
        SymOp(Rot_mZ_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_X_mY, Tr_0_12_12),
        SymOp(Rot_Z_mX_Y, Tr_0_12_12),
        SymOp(Rot_mY_mZ_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_X, Tr_0_12_12),
        SymOp(Rot_Y_Z_mX, Tr_0_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_0_0),
        SymOp(Rot_Y_X_Z, Tr_12_0_0),
        SymOp(Rot_mY_X_mZ, Tr_12_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_12_0_0),
        SymOp(Rot_mX_mZ_Y, Tr_12_0_0),
        SymOp(Rot_X_mZ_mY, Tr_12_0_0),
        SymOp(Rot_X_Z_Y, Tr_12_0_0),
        SymOp(Rot_mX_Z_mY, Tr_12_0_0),
        SymOp(Rot_mZ_mY_X, Tr_12_0_0),
        SymOp(Rot_mZ_Y_mX, Tr_12_0_0),
        SymOp(Rot_Z_mY_mX, Tr_12_0_0),
        SymOp(Rot_Z_Y_X, Tr_12_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_12),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_mZ, Tr_0_12_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_12_0),
        SymOp(Rot_Y_mX_Z, Tr_0_12_0),
        SymOp(Rot_mY_X_Z, Tr_0_12_0),
        SymOp(Rot_X_Z_mY, Tr_0_12_0),
        SymOp(Rot_mX_Z_Y, Tr_0_12_0),
        SymOp(Rot_mX_mZ_mY, Tr_0_12_0),
        SymOp(Rot_X_mZ_Y, Tr_0_12_0),
        SymOp(Rot_Z_Y_mX, Tr_0_12_0),
        SymOp(Rot_Z_mY_X, Tr_0_12_0),
        SymOp(Rot_mZ_Y_X, Tr_0_12_0),
        SymOp(Rot_mZ_mY_mX, Tr_0_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_12_0_12),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_Z, Tr_12_0_12),
        SymOp(Rot_mZ_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_X_mY, Tr_12_0_12),
        SymOp(Rot_Z_mX_Y, Tr_12_0_12),
        SymOp(Rot_mY_mZ_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_X, Tr_12_0_12),
        SymOp(Rot_Y_Z_mX, Tr_12_0_12),
        SymOp(Rot_mY_mX_Z, Tr_0_12_0),
        SymOp(Rot_Y_X_Z, Tr_0_12_0),
        SymOp(Rot_mY_X_mZ, Tr_0_12_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_12_0),
        SymOp(Rot_mX_mZ_Y, Tr_0_12_0),
        SymOp(Rot_X_mZ_mY, Tr_0_12_0),
        SymOp(Rot_X_Z_Y, Tr_0_12_0),
        SymOp(Rot_mX_Z_mY, Tr_0_12_0),
        SymOp(Rot_mZ_mY_X, Tr_0_12_0),
        SymOp(Rot_mZ_Y_mX, Tr_0_12_0),
        SymOp(Rot_Z_mY_mX, Tr_0_12_0),
        SymOp(Rot_Z_Y_X, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_12_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_12),
        SymOp(Rot_Y_mX_Z, Tr_0_0_12),
        SymOp(Rot_mY_X_Z, Tr_0_0_12),
        SymOp(Rot_X_Z_mY, Tr_0_0_12),
        SymOp(Rot_mX_Z_Y, Tr_0_0_12),
        SymOp(Rot_mX_mZ_mY, Tr_0_0_12),
        SymOp(Rot_X_mZ_Y, Tr_0_0_12),
        SymOp(Rot_Z_Y_mX, Tr_0_0_12),
        SymOp(Rot_Z_mY_X, Tr_0_0_12),
        SymOp(Rot_mZ_Y_X, Tr_0_0_12),
        SymOp(Rot_mZ_mY_mX, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mZ_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_X_mY, Tr_12_12_0),
        SymOp(Rot_Z_mX_Y, Tr_12_12_0),
        SymOp(Rot_mY_mZ_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_X, Tr_12_12_0),
        SymOp(Rot_Y_Z_mX, Tr_12_12_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_mY_X_mZ, Tr_0_0_12),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mZ_Y, Tr_0_0_12),
        SymOp(Rot_X_mZ_mY, Tr_0_0_12),
        SymOp(Rot_X_Z_Y, Tr_0_0_12),
        SymOp(Rot_mX_Z_mY, Tr_0_0_12),
        SymOp(Rot_mZ_mY_X, Tr_0_0_12),
        SymOp(Rot_mZ_Y_mX, Tr_0_0_12),
        SymOp(Rot_Z_mY_mX, Tr_0_0_12),
        SymOp(Rot_Z_Y_X, Tr_0_0_12),
    ],
)

sg227 = SpaceGroup(
    number=227,
    num_sym_equiv=192,
    num_primitive_sym_equiv=48,
    short_name="Fd-3m",
    point_group_name="PGm3barm",
    crystal_system="CUBIC",
    pdb_name="F 41/d -3 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_12_12_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_12),
        SymOp(Rot_Y_X_mZ, Tr_34_14_34),
        SymOp(Rot_mY_mX_mZ, Tr_14_14_14),
        SymOp(Rot_Y_mX_Z, Tr_14_34_34),
        SymOp(Rot_mY_X_Z, Tr_34_34_14),
        SymOp(Rot_X_Z_mY, Tr_34_14_34),
        SymOp(Rot_mX_Z_Y, Tr_34_34_14),
        SymOp(Rot_mX_mZ_mY, Tr_14_14_14),
        SymOp(Rot_X_mZ_Y, Tr_14_34_34),
        SymOp(Rot_Z_Y_mX, Tr_34_14_34),
        SymOp(Rot_Z_mY_X, Tr_14_34_34),
        SymOp(Rot_mZ_Y_X, Tr_34_34_14),
        SymOp(Rot_mZ_mY_mX, Tr_14_14_14),
        SymOp(Rot_mX_mY_mZ, Tr_14_14_14),
        SymOp(Rot_X_Y_mZ, Tr_14_34_34),
        SymOp(Rot_X_mY_Z, Tr_34_34_14),
        SymOp(Rot_mX_Y_Z, Tr_34_14_34),
        SymOp(Rot_mZ_mX_mY, Tr_14_14_14),
        SymOp(Rot_mZ_X_Y, Tr_34_14_34),
        SymOp(Rot_Z_X_mY, Tr_14_34_34),
        SymOp(Rot_Z_mX_Y, Tr_34_34_14),
        SymOp(Rot_mY_mZ_mX, Tr_14_14_14),
        SymOp(Rot_Y_mZ_X, Tr_34_34_14),
        SymOp(Rot_mY_Z_X, Tr_34_14_34),
        SymOp(Rot_Y_Z_mX, Tr_14_34_34),
        SymOp(Rot_mY_mX_Z, Tr_12_0_12),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_0),
        SymOp(Rot_mX_mZ_Y, Tr_12_0_12),
        SymOp(Rot_X_mZ_mY, Tr_12_12_0),
        SymOp(Rot_X_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_Z_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mY_X, Tr_12_0_12),
        SymOp(Rot_mZ_Y_mX, Tr_0_12_12),
        SymOp(Rot_Z_mY_mX, Tr_12_12_0),
        SymOp(Rot_Z_Y_X, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_34_34_14),
        SymOp(Rot_mY_mX_mZ, Tr_14_34_34),
        SymOp(Rot_Y_mX_Z, Tr_14_14_14),
        SymOp(Rot_mY_X_Z, Tr_34_14_34),
        SymOp(Rot_X_Z_mY, Tr_34_34_14),
        SymOp(Rot_mX_Z_Y, Tr_34_14_34),
        SymOp(Rot_mX_mZ_mY, Tr_14_34_34),
        SymOp(Rot_X_mZ_Y, Tr_14_14_14),
        SymOp(Rot_Z_Y_mX, Tr_34_34_14),
        SymOp(Rot_Z_mY_X, Tr_14_14_14),
        SymOp(Rot_mZ_Y_X, Tr_34_14_34),
        SymOp(Rot_mZ_mY_mX, Tr_14_34_34),
        SymOp(Rot_mX_mY_mZ, Tr_14_34_34),
        SymOp(Rot_X_Y_mZ, Tr_14_14_14),
        SymOp(Rot_X_mY_Z, Tr_34_14_34),
        SymOp(Rot_mX_Y_Z, Tr_34_34_14),
        SymOp(Rot_mZ_mX_mY, Tr_14_34_34),
        SymOp(Rot_mZ_X_Y, Tr_34_34_14),
        SymOp(Rot_Z_X_mY, Tr_14_14_14),
        SymOp(Rot_Z_mX_Y, Tr_34_14_34),
        SymOp(Rot_mY_mZ_mX, Tr_14_34_34),
        SymOp(Rot_Y_mZ_X, Tr_34_14_34),
        SymOp(Rot_mY_Z_X, Tr_34_34_14),
        SymOp(Rot_Y_Z_mX, Tr_14_14_14),
        SymOp(Rot_mY_mX_Z, Tr_12_12_0),
        SymOp(Rot_Y_X_Z, Tr_0_12_12),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_12_0_12),
        SymOp(Rot_mX_mZ_Y, Tr_12_12_0),
        SymOp(Rot_X_mZ_mY, Tr_12_0_12),
        SymOp(Rot_X_Z_Y, Tr_0_12_12),
        SymOp(Rot_mX_Z_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mY_X, Tr_12_12_0),
        SymOp(Rot_mZ_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_mX, Tr_12_0_12),
        SymOp(Rot_Z_Y_X, Tr_0_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_14_14_14),
        SymOp(Rot_mY_mX_mZ, Tr_34_14_34),
        SymOp(Rot_Y_mX_Z, Tr_34_34_14),
        SymOp(Rot_mY_X_Z, Tr_14_34_34),
        SymOp(Rot_X_Z_mY, Tr_14_14_14),
        SymOp(Rot_mX_Z_Y, Tr_14_34_34),
        SymOp(Rot_mX_mZ_mY, Tr_34_14_34),
        SymOp(Rot_X_mZ_Y, Tr_34_34_14),
        SymOp(Rot_Z_Y_mX, Tr_14_14_14),
        SymOp(Rot_Z_mY_X, Tr_34_34_14),
        SymOp(Rot_mZ_Y_X, Tr_14_34_34),
        SymOp(Rot_mZ_mY_mX, Tr_34_14_34),
        SymOp(Rot_mX_mY_mZ, Tr_34_14_34),
        SymOp(Rot_X_Y_mZ, Tr_34_34_14),
        SymOp(Rot_X_mY_Z, Tr_14_34_34),
        SymOp(Rot_mX_Y_Z, Tr_14_14_14),
        SymOp(Rot_mZ_mX_mY, Tr_34_14_34),
        SymOp(Rot_mZ_X_Y, Tr_14_14_14),
        SymOp(Rot_Z_X_mY, Tr_34_34_14),
        SymOp(Rot_Z_mX_Y, Tr_14_34_34),
        SymOp(Rot_mY_mZ_mX, Tr_34_14_34),
        SymOp(Rot_Y_mZ_X, Tr_14_34_34),
        SymOp(Rot_mY_Z_X, Tr_14_14_14),
        SymOp(Rot_Y_Z_mX, Tr_34_34_14),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_12_0_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_12_12),
        SymOp(Rot_mX_mZ_Y, Tr_0_0_0),
        SymOp(Rot_X_mZ_mY, Tr_0_12_12),
        SymOp(Rot_X_Z_Y, Tr_12_0_12),
        SymOp(Rot_mX_Z_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_mX, Tr_12_12_0),
        SymOp(Rot_Z_mY_mX, Tr_0_12_12),
        SymOp(Rot_Z_Y_X, Tr_12_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_mZ, Tr_14_34_34),
        SymOp(Rot_mY_mX_mZ, Tr_34_34_14),
        SymOp(Rot_Y_mX_Z, Tr_34_14_34),
        SymOp(Rot_mY_X_Z, Tr_14_14_14),
        SymOp(Rot_X_Z_mY, Tr_14_34_34),
        SymOp(Rot_mX_Z_Y, Tr_14_14_14),
        SymOp(Rot_mX_mZ_mY, Tr_34_34_14),
        SymOp(Rot_X_mZ_Y, Tr_34_14_34),
        SymOp(Rot_Z_Y_mX, Tr_14_34_34),
        SymOp(Rot_Z_mY_X, Tr_34_14_34),
        SymOp(Rot_mZ_Y_X, Tr_14_14_14),
        SymOp(Rot_mZ_mY_mX, Tr_34_34_14),
        SymOp(Rot_mX_mY_mZ, Tr_34_34_14),
        SymOp(Rot_X_Y_mZ, Tr_34_14_34),
        SymOp(Rot_X_mY_Z, Tr_14_14_14),
        SymOp(Rot_mX_Y_Z, Tr_14_34_34),
        SymOp(Rot_mZ_mX_mY, Tr_34_34_14),
        SymOp(Rot_mZ_X_Y, Tr_14_34_34),
        SymOp(Rot_Z_X_mY, Tr_34_14_34),
        SymOp(Rot_Z_mX_Y, Tr_14_14_14),
        SymOp(Rot_mY_mZ_mX, Tr_34_34_14),
        SymOp(Rot_Y_mZ_X, Tr_14_14_14),
        SymOp(Rot_mY_Z_X, Tr_14_34_34),
        SymOp(Rot_Y_Z_mX, Tr_34_14_34),
        SymOp(Rot_mY_mX_Z, Tr_0_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_0),
        SymOp(Rot_mY_X_mZ, Tr_12_0_12),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mZ_Y, Tr_0_12_12),
        SymOp(Rot_X_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_Z_Y, Tr_12_12_0),
        SymOp(Rot_mX_Z_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mY_X, Tr_0_12_12),
        SymOp(Rot_mZ_Y_mX, Tr_12_0_12),
        SymOp(Rot_Z_mY_mX, Tr_0_0_0),
        SymOp(Rot_Z_Y_X, Tr_12_12_0),
    ],
)

sg228 = SpaceGroup(
    number=228,
    num_sym_equiv=192,
    num_primitive_sym_equiv=48,
    short_name="Fd-3c",
    point_group_name="PGm3barm",
    crystal_system="CUBIC",
    pdb_name="F 41/d -3 2/c",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_12_12_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_12),
        SymOp(Rot_Y_X_mZ, Tr_34_14_34),
        SymOp(Rot_mY_mX_mZ, Tr_14_14_14),
        SymOp(Rot_Y_mX_Z, Tr_14_34_34),
        SymOp(Rot_mY_X_Z, Tr_34_34_14),
        SymOp(Rot_X_Z_mY, Tr_34_14_34),
        SymOp(Rot_mX_Z_Y, Tr_34_34_14),
        SymOp(Rot_mX_mZ_mY, Tr_14_14_14),
        SymOp(Rot_X_mZ_Y, Tr_14_34_34),
        SymOp(Rot_Z_Y_mX, Tr_34_14_34),
        SymOp(Rot_Z_mY_X, Tr_14_34_34),
        SymOp(Rot_mZ_Y_X, Tr_34_34_14),
        SymOp(Rot_mZ_mY_mX, Tr_14_14_14),
        SymOp(Rot_mX_mY_mZ, Tr_34_34_34),
        SymOp(Rot_X_Y_mZ, Tr_34_14_14),
        SymOp(Rot_X_mY_Z, Tr_14_14_34),
        SymOp(Rot_mX_Y_Z, Tr_14_34_14),
        SymOp(Rot_mZ_mX_mY, Tr_34_34_34),
        SymOp(Rot_mZ_X_Y, Tr_14_34_14),
        SymOp(Rot_Z_X_mY, Tr_34_14_14),
        SymOp(Rot_Z_mX_Y, Tr_14_14_34),
        SymOp(Rot_mY_mZ_mX, Tr_34_34_34),
        SymOp(Rot_Y_mZ_X, Tr_14_14_34),
        SymOp(Rot_mY_Z_X, Tr_14_34_14),
        SymOp(Rot_Y_Z_mX, Tr_34_14_14),
        SymOp(Rot_mY_mX_Z, Tr_0_12_0),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_12),
        SymOp(Rot_mX_mZ_Y, Tr_0_12_0),
        SymOp(Rot_X_mZ_mY, Tr_0_0_12),
        SymOp(Rot_X_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_Z_mY, Tr_12_0_0),
        SymOp(Rot_mZ_mY_X, Tr_0_12_0),
        SymOp(Rot_mZ_Y_mX, Tr_12_0_0),
        SymOp(Rot_Z_mY_mX, Tr_0_0_12),
        SymOp(Rot_Z_Y_X, Tr_12_12_12),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_12_12),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_34_34_14),
        SymOp(Rot_mY_mX_mZ, Tr_14_34_34),
        SymOp(Rot_Y_mX_Z, Tr_14_14_14),
        SymOp(Rot_mY_X_Z, Tr_34_14_34),
        SymOp(Rot_X_Z_mY, Tr_34_34_14),
        SymOp(Rot_mX_Z_Y, Tr_34_14_34),
        SymOp(Rot_mX_mZ_mY, Tr_14_34_34),
        SymOp(Rot_X_mZ_Y, Tr_14_14_14),
        SymOp(Rot_Z_Y_mX, Tr_34_34_14),
        SymOp(Rot_Z_mY_X, Tr_14_14_14),
        SymOp(Rot_mZ_Y_X, Tr_34_14_34),
        SymOp(Rot_mZ_mY_mX, Tr_14_34_34),
        SymOp(Rot_mX_mY_mZ, Tr_34_14_14),
        SymOp(Rot_X_Y_mZ, Tr_34_34_34),
        SymOp(Rot_X_mY_Z, Tr_14_34_14),
        SymOp(Rot_mX_Y_Z, Tr_14_14_34),
        SymOp(Rot_mZ_mX_mY, Tr_34_14_14),
        SymOp(Rot_mZ_X_Y, Tr_14_14_34),
        SymOp(Rot_Z_X_mY, Tr_34_34_34),
        SymOp(Rot_Z_mX_Y, Tr_14_34_14),
        SymOp(Rot_mY_mZ_mX, Tr_34_14_14),
        SymOp(Rot_Y_mZ_X, Tr_14_34_14),
        SymOp(Rot_mY_Z_X, Tr_14_14_34),
        SymOp(Rot_Y_Z_mX, Tr_34_34_34),
        SymOp(Rot_mY_mX_Z, Tr_0_0_12),
        SymOp(Rot_Y_X_Z, Tr_12_0_0),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_0_12_0),
        SymOp(Rot_mX_mZ_Y, Tr_0_0_12),
        SymOp(Rot_X_mZ_mY, Tr_0_12_0),
        SymOp(Rot_X_Z_Y, Tr_12_0_0),
        SymOp(Rot_mX_Z_mY, Tr_12_12_12),
        SymOp(Rot_mZ_mY_X, Tr_0_0_12),
        SymOp(Rot_mZ_Y_mX, Tr_12_12_12),
        SymOp(Rot_Z_mY_mX, Tr_0_12_0),
        SymOp(Rot_Z_Y_X, Tr_12_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_12_0_12),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_12_0_12),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
        SymOp(Rot_Y_X_mZ, Tr_14_14_14),
        SymOp(Rot_mY_mX_mZ, Tr_34_14_34),
        SymOp(Rot_Y_mX_Z, Tr_34_34_14),
        SymOp(Rot_mY_X_Z, Tr_14_34_34),
        SymOp(Rot_X_Z_mY, Tr_14_14_14),
        SymOp(Rot_mX_Z_Y, Tr_14_34_34),
        SymOp(Rot_mX_mZ_mY, Tr_34_14_34),
        SymOp(Rot_X_mZ_Y, Tr_34_34_14),
        SymOp(Rot_Z_Y_mX, Tr_14_14_14),
        SymOp(Rot_Z_mY_X, Tr_34_34_14),
        SymOp(Rot_mZ_Y_X, Tr_14_34_34),
        SymOp(Rot_mZ_mY_mX, Tr_34_14_34),
        SymOp(Rot_mX_mY_mZ, Tr_14_34_14),
        SymOp(Rot_X_Y_mZ, Tr_14_14_34),
        SymOp(Rot_X_mY_Z, Tr_34_14_14),
        SymOp(Rot_mX_Y_Z, Tr_34_34_34),
        SymOp(Rot_mZ_mX_mY, Tr_14_34_14),
        SymOp(Rot_mZ_X_Y, Tr_34_34_34),
        SymOp(Rot_Z_X_mY, Tr_14_14_34),
        SymOp(Rot_Z_mX_Y, Tr_34_14_14),
        SymOp(Rot_mY_mZ_mX, Tr_14_34_14),
        SymOp(Rot_Y_mZ_X, Tr_34_14_14),
        SymOp(Rot_mY_Z_X, Tr_34_34_34),
        SymOp(Rot_Y_Z_mX, Tr_14_14_34),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_0_12_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_0_0),
        SymOp(Rot_mX_mZ_Y, Tr_12_12_12),
        SymOp(Rot_X_mZ_mY, Tr_12_0_0),
        SymOp(Rot_X_Z_Y, Tr_0_12_0),
        SymOp(Rot_mX_Z_mY, Tr_0_0_12),
        SymOp(Rot_mZ_mY_X, Tr_12_12_12),
        SymOp(Rot_mZ_Y_mX, Tr_0_0_12),
        SymOp(Rot_Z_mY_mX, Tr_12_0_0),
        SymOp(Rot_Z_Y_X, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_mZ, Tr_14_34_34),
        SymOp(Rot_mY_mX_mZ, Tr_34_34_14),
        SymOp(Rot_Y_mX_Z, Tr_34_14_34),
        SymOp(Rot_mY_X_Z, Tr_14_14_14),
        SymOp(Rot_X_Z_mY, Tr_14_34_34),
        SymOp(Rot_mX_Z_Y, Tr_14_14_14),
        SymOp(Rot_mX_mZ_mY, Tr_34_34_14),
        SymOp(Rot_X_mZ_Y, Tr_34_14_34),
        SymOp(Rot_Z_Y_mX, Tr_14_34_34),
        SymOp(Rot_Z_mY_X, Tr_34_14_34),
        SymOp(Rot_mZ_Y_X, Tr_14_14_14),
        SymOp(Rot_mZ_mY_mX, Tr_34_34_14),
        SymOp(Rot_mX_mY_mZ, Tr_14_14_34),
        SymOp(Rot_X_Y_mZ, Tr_14_34_14),
        SymOp(Rot_X_mY_Z, Tr_34_34_34),
        SymOp(Rot_mX_Y_Z, Tr_34_14_14),
        SymOp(Rot_mZ_mX_mY, Tr_14_14_34),
        SymOp(Rot_mZ_X_Y, Tr_34_14_14),
        SymOp(Rot_Z_X_mY, Tr_14_34_14),
        SymOp(Rot_Z_mX_Y, Tr_34_34_34),
        SymOp(Rot_mY_mZ_mX, Tr_14_14_34),
        SymOp(Rot_Y_mZ_X, Tr_34_34_34),
        SymOp(Rot_mY_Z_X, Tr_34_14_14),
        SymOp(Rot_Y_Z_mX, Tr_14_34_14),
        SymOp(Rot_mY_mX_Z, Tr_12_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_12),
        SymOp(Rot_mY_X_mZ, Tr_0_12_0),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mZ_Y, Tr_12_0_0),
        SymOp(Rot_X_mZ_mY, Tr_12_12_12),
        SymOp(Rot_X_Z_Y, Tr_0_0_12),
        SymOp(Rot_mX_Z_mY, Tr_0_12_0),
        SymOp(Rot_mZ_mY_X, Tr_12_0_0),
        SymOp(Rot_mZ_Y_mX, Tr_0_12_0),
        SymOp(Rot_Z_mY_mX, Tr_12_12_12),
        SymOp(Rot_Z_Y_X, Tr_0_0_12),
    ],
)

sg229 = SpaceGroup(
    number=229,
    num_sym_equiv=96,
    num_primitive_sym_equiv=48,
    short_name="Im-3m",
    point_group_name="PGm3barm",
    crystal_system="CUBIC",
    pdb_name="I 4/m -3 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_0_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_0_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_0),
        SymOp(Rot_mY_mX_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_Z, Tr_0_0_0),
        SymOp(Rot_X_Z_mY, Tr_0_0_0),
        SymOp(Rot_mX_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_mZ_Y, Tr_0_0_0),
        SymOp(Rot_Z_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_X, Tr_0_0_0),
        SymOp(Rot_mZ_mY_mX, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_X_mY, Tr_0_0_0),
        SymOp(Rot_Z_mX_Y, Tr_0_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_X, Tr_0_0_0),
        SymOp(Rot_Y_Z_mX, Tr_0_0_0),
        SymOp(Rot_mY_mX_Z, Tr_0_0_0),
        SymOp(Rot_Y_X_Z, Tr_0_0_0),
        SymOp(Rot_mY_X_mZ, Tr_0_0_0),
        SymOp(Rot_Y_mX_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mZ_Y, Tr_0_0_0),
        SymOp(Rot_X_mZ_mY, Tr_0_0_0),
        SymOp(Rot_X_Z_Y, Tr_0_0_0),
        SymOp(Rot_mX_Z_mY, Tr_0_0_0),
        SymOp(Rot_mZ_mY_X, Tr_0_0_0),
        SymOp(Rot_mZ_Y_mX, Tr_0_0_0),
        SymOp(Rot_Z_mY_mX, Tr_0_0_0),
        SymOp(Rot_Z_Y_X, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_12),
        SymOp(Rot_mZ_X_mY, Tr_12_12_12),
        SymOp(Rot_Y_Z_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_12),
        SymOp(Rot_mY_mZ_X, Tr_12_12_12),
        SymOp(Rot_Y_X_mZ, Tr_12_12_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_Z, Tr_12_12_12),
        SymOp(Rot_X_Z_mY, Tr_12_12_12),
        SymOp(Rot_mX_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_mZ_mY, Tr_12_12_12),
        SymOp(Rot_X_mZ_Y, Tr_12_12_12),
        SymOp(Rot_Z_Y_mX, Tr_12_12_12),
        SymOp(Rot_Z_mY_X, Tr_12_12_12),
        SymOp(Rot_mZ_Y_X, Tr_12_12_12),
        SymOp(Rot_mZ_mY_mX, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_12),
        SymOp(Rot_mZ_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_X_mY, Tr_12_12_12),
        SymOp(Rot_Z_mX_Y, Tr_12_12_12),
        SymOp(Rot_mY_mZ_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_X, Tr_12_12_12),
        SymOp(Rot_Y_Z_mX, Tr_12_12_12),
        SymOp(Rot_mY_mX_Z, Tr_12_12_12),
        SymOp(Rot_Y_X_Z, Tr_12_12_12),
        SymOp(Rot_mY_X_mZ, Tr_12_12_12),
        SymOp(Rot_Y_mX_mZ, Tr_12_12_12),
        SymOp(Rot_mX_mZ_Y, Tr_12_12_12),
        SymOp(Rot_X_mZ_mY, Tr_12_12_12),
        SymOp(Rot_X_Z_Y, Tr_12_12_12),
        SymOp(Rot_mX_Z_mY, Tr_12_12_12),
        SymOp(Rot_mZ_mY_X, Tr_12_12_12),
        SymOp(Rot_mZ_Y_mX, Tr_12_12_12),
        SymOp(Rot_Z_mY_mX, Tr_12_12_12),
        SymOp(Rot_Z_Y_X, Tr_12_12_12),
    ],
)

sg230 = SpaceGroup(
    number=230,
    num_sym_equiv=96,
    num_primitive_sym_equiv=48,
    short_name="Ia-3d",
    point_group_name="PGm3barm",
    crystal_system="CUBIC",
    pdb_name="I 41/a -3 2/d",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_Z_mX_mY, Tr_12_12_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_0_12),
        SymOp(Rot_mZ_X_mY, Tr_0_12_12),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_12_12),
        SymOp(Rot_Y_mZ_mX, Tr_12_12_0),
        SymOp(Rot_mY_mZ_X, Tr_12_0_12),
        SymOp(Rot_Y_X_mZ, Tr_34_14_14),
        SymOp(Rot_mY_mX_mZ, Tr_34_34_34),
        SymOp(Rot_Y_mX_Z, Tr_14_14_34),
        SymOp(Rot_mY_X_Z, Tr_14_34_14),
        SymOp(Rot_X_Z_mY, Tr_34_14_14),
        SymOp(Rot_mX_Z_Y, Tr_14_34_14),
        SymOp(Rot_mX_mZ_mY, Tr_34_34_34),
        SymOp(Rot_X_mZ_Y, Tr_14_14_34),
        SymOp(Rot_Z_Y_mX, Tr_34_14_14),
        SymOp(Rot_Z_mY_X, Tr_14_14_34),
        SymOp(Rot_mZ_Y_X, Tr_14_34_14),
        SymOp(Rot_mZ_mY_mX, Tr_34_34_34),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_Z, Tr_0_12_12),
        SymOp(Rot_mX_Y_Z, Tr_12_12_0),
        SymOp(Rot_mZ_mX_mY, Tr_0_0_0),
        SymOp(Rot_mZ_X_Y, Tr_12_12_0),
        SymOp(Rot_Z_X_mY, Tr_12_0_12),
        SymOp(Rot_Z_mX_Y, Tr_0_12_12),
        SymOp(Rot_mY_mZ_mX, Tr_0_0_0),
        SymOp(Rot_Y_mZ_X, Tr_0_12_12),
        SymOp(Rot_mY_Z_X, Tr_12_12_0),
        SymOp(Rot_Y_Z_mX, Tr_12_0_12),
        SymOp(Rot_mY_mX_Z, Tr_14_34_34),
        SymOp(Rot_Y_X_Z, Tr_14_14_14),
        SymOp(Rot_mY_X_mZ, Tr_34_34_14),
        SymOp(Rot_Y_mX_mZ, Tr_34_14_34),
        SymOp(Rot_mX_mZ_Y, Tr_14_34_34),
        SymOp(Rot_X_mZ_mY, Tr_34_14_34),
        SymOp(Rot_X_Z_Y, Tr_14_14_14),
        SymOp(Rot_mX_Z_mY, Tr_34_34_14),
        SymOp(Rot_mZ_mY_X, Tr_14_34_34),
        SymOp(Rot_mZ_Y_mX, Tr_34_34_14),
        SymOp(Rot_Z_mY_mX, Tr_34_14_34),
        SymOp(Rot_Z_Y_X, Tr_14_14_14),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_12),
        SymOp(Rot_Z_mX_mY, Tr_0_0_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_12_0),
        SymOp(Rot_mZ_X_mY, Tr_12_0_0),
        SymOp(Rot_Y_Z_X, Tr_12_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_0),
        SymOp(Rot_Y_mZ_mX, Tr_0_0_12),
        SymOp(Rot_mY_mZ_X, Tr_0_12_0),
        SymOp(Rot_Y_X_mZ, Tr_14_34_34),
        SymOp(Rot_mY_mX_mZ, Tr_14_14_14),
        SymOp(Rot_Y_mX_Z, Tr_34_34_14),
        SymOp(Rot_mY_X_Z, Tr_34_14_34),
        SymOp(Rot_X_Z_mY, Tr_14_34_34),
        SymOp(Rot_mX_Z_Y, Tr_34_14_34),
        SymOp(Rot_mX_mZ_mY, Tr_14_14_14),
        SymOp(Rot_X_mZ_Y, Tr_34_34_14),
        SymOp(Rot_Z_Y_mX, Tr_14_34_34),
        SymOp(Rot_Z_mY_X, Tr_34_34_14),
        SymOp(Rot_mZ_Y_X, Tr_34_14_34),
        SymOp(Rot_mZ_mY_mX, Tr_14_14_14),
        SymOp(Rot_mX_mY_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_mY_Z, Tr_12_0_0),
        SymOp(Rot_mX_Y_Z, Tr_0_0_12),
        SymOp(Rot_mZ_mX_mY, Tr_12_12_12),
        SymOp(Rot_mZ_X_Y, Tr_0_0_12),
        SymOp(Rot_Z_X_mY, Tr_0_12_0),
        SymOp(Rot_Z_mX_Y, Tr_12_0_0),
        SymOp(Rot_mY_mZ_mX, Tr_12_12_12),
        SymOp(Rot_Y_mZ_X, Tr_12_0_0),
        SymOp(Rot_mY_Z_X, Tr_0_0_12),
        SymOp(Rot_Y_Z_mX, Tr_0_12_0),
        SymOp(Rot_mY_mX_Z, Tr_34_14_14),
        SymOp(Rot_Y_X_Z, Tr_34_34_34),
        SymOp(Rot_mY_X_mZ, Tr_14_14_34),
        SymOp(Rot_Y_mX_mZ, Tr_14_34_14),
        SymOp(Rot_mX_mZ_Y, Tr_34_14_14),
        SymOp(Rot_X_mZ_mY, Tr_14_34_14),
        SymOp(Rot_X_Z_Y, Tr_34_34_34),
        SymOp(Rot_mX_Z_mY, Tr_14_14_34),
        SymOp(Rot_mZ_mY_X, Tr_34_14_14),
        SymOp(Rot_mZ_Y_mX, Tr_14_14_34),
        SymOp(Rot_Z_mY_mX, Tr_14_34_14),
        SymOp(Rot_Z_Y_X, Tr_34_34_34),
    ],
)

sg1003 = SpaceGroup(
    number=1003,
    num_sym_equiv=2,
    num_primitive_sym_equiv=2,
    short_name="P2",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 1 2",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_mX_mY_Z, Tr_0_0_0)],
)

sg1004 = SpaceGroup(
    number=1004,
    num_sym_equiv=2,
    num_primitive_sym_equiv=2,
    short_name="P1121",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 1 21",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_mX_mY_Z, Tr_0_0_12)],
)

sg3004 = SpaceGroup(
    number=3004,
    num_sym_equiv=4,
    num_primitive_sym_equiv=2,
    short_name="I21",
    point_group_name="PG2",
    crystal_system="MONOCLINIC",
    pdb_name="I 1 21 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
    ],
)

sg1005 = SpaceGroup(
    number=1005,
    num_sym_equiv=4,
    num_primitive_sym_equiv=2,
    short_name="B2",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="B 1 1 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
    ],
)

sg2005 = SpaceGroup(
    number=2005,
    num_sym_equiv=4,
    num_primitive_sym_equiv=2,
    short_name="A2",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="A 2 1 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
    ],
)

sg3005 = SpaceGroup(
    number=3005,
    num_sym_equiv=4,
    num_primitive_sym_equiv=2,
    short_name="C21",
    point_group_name="PG2",
    crystal_system="MONOCLINIC",
    pdb_name="C 1 21 1",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_0),
    ],
)

sg1006 = SpaceGroup(
    number=1006,
    num_sym_equiv=2,
    num_primitive_sym_equiv=2,
    short_name="P11m",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 1 m",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_X_Y_mZ, Tr_0_0_0)],
)

sg1007 = SpaceGroup(
    number=1007,
    num_sym_equiv=2,
    num_primitive_sym_equiv=2,
    short_name="P11b",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 1 b",
    symop_list=[SymOp(Rot_X_Y_Z, Tr_0_0_0), SymOp(Rot_X_Y_mZ, Tr_0_12_0)],
)

sg1008 = SpaceGroup(
    number=1008,
    num_sym_equiv=4,
    num_primitive_sym_equiv=2,
    short_name="B11m",
    point_group_name="PG2",
    crystal_system="MONOCLINIC",
    pdb_name="B 1 1 m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
    ],
)

sg1009 = SpaceGroup(
    number=1009,
    num_sym_equiv=4,
    num_primitive_sym_equiv=2,
    short_name="B11b",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="B 1 1 b",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
    ],
)

sg1010 = SpaceGroup(
    number=1010,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P112/m",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 1 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
    ],
)

sg1011 = SpaceGroup(
    number=1011,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P1121/m",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 1 21/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_12),
    ],
)

sg1012 = SpaceGroup(
    number=1012,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="B112/m",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="B 1 1 2/m",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_X_Y_mZ, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_0_12),
    ],
)

sg1013 = SpaceGroup(
    number=1013,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P112/b",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 1 2/b",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_12_0),
    ],
)

sg1014 = SpaceGroup(
    number=1014,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P1121/b",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="P 1 1 21/b",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_X_Y_mZ, Tr_0_12_12),
    ],
)

sg1015 = SpaceGroup(
    number=1015,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="B112/b",
    point_group_name="PG2C",
    crystal_system="MONOCLINIC",
    pdb_name="B 1 1 2/b",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_mZ, Tr_12_0_12),
        SymOp(Rot_X_Y_mZ, Tr_12_12_12),
    ],
)

sg1017 = SpaceGroup(
    number=1017,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P2122",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21 2 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_0),
    ],
)

sg2017 = SpaceGroup(
    number=2017,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P2212",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 2 21 2",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
    ],
)

sg1018 = SpaceGroup(
    number=1018,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P21212a",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21 21 2 (a)",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
    ],
)

sg2018 = SpaceGroup(
    number=2018,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P21221",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21 2 21",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
    ],
)

sg3018 = SpaceGroup(
    number=3018,
    num_sym_equiv=4,
    num_primitive_sym_equiv=4,
    short_name="P22121",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 2 21 21",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
    ],
)

sg1020 = SpaceGroup(
    number=1020,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="C2221a",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C 2 2 21a)",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
    ],
)

sg1021 = SpaceGroup(
    number=1021,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="C222a",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="C 2 2 2a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_0),
    ],
)

sg1022 = SpaceGroup(
    number=1022,
    num_sym_equiv=16,
    num_primitive_sym_equiv=4,
    short_name="F222a",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="F 2 2 2a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_0_12_12),
        SymOp(Rot_mX_mY_Z, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_12_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_0_12),
        SymOp(Rot_X_Y_Z, Tr_12_0_12),
        SymOp(Rot_mX_mY_Z, Tr_0_12_12),
        SymOp(Rot_X_mY_mZ, Tr_0_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_12_12),
        SymOp(Rot_X_Y_Z, Tr_12_12_0),
        SymOp(Rot_mX_mY_Z, Tr_0_0_0),
        SymOp(Rot_X_mY_mZ, Tr_0_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_0),
    ],
)

sg1023 = SpaceGroup(
    number=1023,
    num_sym_equiv=8,
    num_primitive_sym_equiv=4,
    short_name="I222a",
    point_group_name="PG222",
    crystal_system="ORTHORHOMBIC",
    pdb_name="I 2 2 2a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
    ],
)

sg1059 = SpaceGroup(
    number=1059,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="Pmmn2",
    point_group_name="PGmmm",
    crystal_system="ORTHORHOMBIC",
    pdb_name="P 21/m 21/m 2/n",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_0),
        SymOp(Rot_mX_mY_mZ, Tr_0_0_0),
        SymOp(Rot_X_Y_mZ, Tr_12_12_0),
        SymOp(Rot_X_mY_Z, Tr_0_12_0),
        SymOp(Rot_mX_Y_Z, Tr_12_0_0),
    ],
)

sg1094 = SpaceGroup(
    number=1094,
    num_sym_equiv=8,
    num_primitive_sym_equiv=8,
    short_name="P42212a",
    point_group_name="PG422",
    crystal_system="TETRAGONAL",
    pdb_name="P 42 21 2a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_mY_X_Z, Tr_0_12_12),
        SymOp(Rot_Y_mX_Z, Tr_12_0_12),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_0),
        SymOp(Rot_Y_X_mZ, Tr_0_0_12),
        SymOp(Rot_mY_mX_mZ, Tr_12_12_12),
    ],
)

sg1197 = SpaceGroup(
    number=1197,
    num_sym_equiv=24,
    num_primitive_sym_equiv=12,
    short_name="I23a",
    point_group_name="PG23",
    crystal_system="CUBIC",
    pdb_name="I 2 3a",
    symop_list=[
        SymOp(Rot_X_Y_Z, Tr_0_0_0),
        SymOp(Rot_mX_mY_Z, Tr_12_12_0),
        SymOp(Rot_X_mY_mZ, Tr_12_0_0),
        SymOp(Rot_mX_Y_mZ, Tr_0_12_0),
        SymOp(Rot_Y_Z_X, Tr_0_0_0),
        SymOp(Rot_mY_mZ_X, Tr_12_12_0),
        SymOp(Rot_Y_mZ_mX, Tr_12_0_0),
        SymOp(Rot_mY_Z_mX, Tr_0_12_0),
        SymOp(Rot_Z_X_Y, Tr_0_0_0),
        SymOp(Rot_mZ_mX_Y, Tr_12_12_0),
        SymOp(Rot_Z_mX_mY, Tr_12_0_0),
        SymOp(Rot_mZ_X_mY, Tr_0_12_0),
        SymOp(Rot_X_Y_Z, Tr_12_12_12),
        SymOp(Rot_mX_mY_Z, Tr_0_0_12),
        SymOp(Rot_X_mY_mZ, Tr_0_12_12),
        SymOp(Rot_mX_Y_mZ, Tr_12_0_12),
        SymOp(Rot_Y_Z_X, Tr_12_12_12),
        SymOp(Rot_mY_mZ_X, Tr_0_0_12),
        SymOp(Rot_Y_mZ_mX, Tr_0_12_12),
        SymOp(Rot_mY_Z_mX, Tr_12_0_12),
        SymOp(Rot_Z_X_Y, Tr_12_12_12),
        SymOp(Rot_mZ_mX_Y, Tr_0_0_12),
        SymOp(Rot_Z_mX_mY, Tr_0_12_12),
        SymOp(Rot_mZ_X_mY, Tr_12_0_12),
    ],
)


# list of the space groups
mmLibSpaceGroupList = [
    sg1,
    sg2,
    sg3,
    sg4,
    sg5,
    sg6,
    sg7,
    sg8,
    sg9,
    sg10,
    sg11,
    sg12,
    sg13,
    sg14,
    sg15,
    sg16,
    sg17,
    sg18,
    sg19,
    sg20,
    sg21,
    sg22,
    sg23,
    sg24,
    sg25,
    sg26,
    sg27,
    sg28,
    sg29,
    sg30,
    sg31,
    sg32,
    sg33,
    sg34,
    sg35,
    sg36,
    sg37,
    sg38,
    sg39,
    sg40,
    sg41,
    sg42,
    sg43,
    sg44,
    sg45,
    sg46,
    sg47,
    sg48,
    sg49,
    sg50,
    sg51,
    sg52,
    sg53,
    sg54,
    sg55,
    sg56,
    sg57,
    sg58,
    sg59,
    sg60,
    sg61,
    sg62,
    sg63,
    sg64,
    sg65,
    sg66,
    sg67,
    sg68,
    sg69,
    sg70,
    sg71,
    sg72,
    sg73,
    sg74,
    sg75,
    sg76,
    sg77,
    sg78,
    sg79,
    sg80,
    sg81,
    sg82,
    sg83,
    sg84,
    sg85,
    sg86,
    sg87,
    sg88,
    sg89,
    sg90,
    sg91,
    sg92,
    sg93,
    sg94,
    sg95,
    sg96,
    sg97,
    sg98,
    sg99,
    sg100,
    sg101,
    sg102,
    sg103,
    sg104,
    sg105,
    sg106,
    sg107,
    sg108,
    sg109,
    sg110,
    sg111,
    sg112,
    sg113,
    sg114,
    sg115,
    sg116,
    sg117,
    sg118,
    sg119,
    sg120,
    sg121,
    sg122,
    sg123,
    sg124,
    sg125,
    sg126,
    sg127,
    sg128,
    sg129,
    sg130,
    sg131,
    sg132,
    sg133,
    sg134,
    sg135,
    sg136,
    sg137,
    sg138,
    sg139,
    sg140,
    sg141,
    sg142,
    sg143,
    sg144,
    sg145,
    sg146,
    sg1146,
    sg147,
    sg148,
    sg1148,
    sg149,
    sg150,
    sg151,
    sg152,
    sg153,
    sg154,
    sg155,
    sg1155,
    sg156,
    sg157,
    sg158,
    sg159,
    sg160,
    sg1160,
    sg161,
    sg1161,
    sg162,
    sg163,
    sg164,
    sg165,
    sg166,
    sg1166,
    sg167,
    sg1167,
    sg168,
    sg169,
    sg170,
    sg171,
    sg172,
    sg173,
    sg174,
    sg175,
    sg176,
    sg177,
    sg178,
    sg179,
    sg180,
    sg181,
    sg182,
    sg183,
    sg184,
    sg185,
    sg186,
    sg187,
    sg188,
    sg189,
    sg190,
    sg191,
    sg192,
    sg193,
    sg194,
    sg195,
    sg196,
    sg197,
    sg198,
    sg199,
    sg200,
    sg201,
    sg202,
    sg203,
    sg204,
    sg205,
    sg206,
    sg207,
    sg208,
    sg209,
    sg210,
    sg211,
    sg212,
    sg213,
    sg214,
    sg215,
    sg216,
    sg217,
    sg218,
    sg219,
    sg220,
    sg221,
    sg222,
    sg223,
    sg224,
    sg225,
    sg226,
    sg227,
    sg228,
    sg229,
    sg230,
    sg1003,
    sg1004,
    sg3004,
    sg1005,
    sg2005,
    sg3005,
    sg1006,
    sg1007,
    sg1008,
    sg1009,
    sg1010,
    sg1011,
    sg1012,
    sg1013,
    sg1014,
    sg1015,
    sg1017,
    sg2017,
    sg1018,
    sg2018,
    sg3018,
    sg1020,
    sg1021,
    sg1022,
    sg1023,
    sg1059,
    sg1094,
    sg1197,
]
