# Code of Conduct

## Our Pledge

We as members, contributors, and leaders pledge to make participation in our community a harassment-free experience for everyone, regardless of age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, caste, color, religion, or sexual identity and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming, diverse, inclusive, and healthy community.

## Our Standards

### Positive Behavior

Examples of behavior that contributes to a positive environment:

- **Being Respectful**: Value differing opinions, viewpoints, and experiences
- **Being Constructive**: Provide and gracefully accept constructive feedback
- **Being Collaborative**: Focus on what is best for the community and project
- **Being Professional**: Use welcoming and inclusive language
- **Being Empathetic**: Show empathy and kindness toward other people
- **Being Accountable**: Accept responsibility and apologize for mistakes

### Unacceptable Behavior

Examples of unacceptable behavior include:

- **Harassment**: The use of sexualized language or imagery, and sexual attention or advances of any kind
- **Trolling**: Insulting or derogatory comments, personal or political attacks
- **Discrimination**: Public or private harassment based on protected characteristics
- **Privacy Violations**: Publishing others' private information without explicit permission
- **Unprofessionalism**: Other conduct which could reasonably be considered inappropriate in a professional setting
- **Disruption**: Sustained disruption of discussions or community events

## Scope

This Code of Conduct applies within all community spaces, including:

- GitHub repositories and issue trackers
- Discord server and other communication channels
- Community events (virtual or in-person)
- Social media when representing the project

It also applies when representing the community in public spaces.

## Enforcement

### Reporting

If you experience or witness unacceptable behavior, please report it by contacting the project maintainers at:

- **Email**: conduct@namastex.ai
- **Discord**: Direct message to server moderators
- **Private Report**: [GitHub Report Form](https://github.com/namastexlabs/automagik-hive/issues/new?template=code_of_conduct.md)

All reports will be reviewed and investigated promptly and fairly.

**What to Include in a Report:**
- Your contact information
- Names (real, usernames, or pseudonyms) of individuals involved
- Description of the incident
- Additional context (screenshots, links, witnesses)
- Whether you want to remain anonymous

### Response Process

1. **Acknowledgment**: Reports are acknowledged within 24 hours
2. **Investigation**: Maintainers review the incident and gather additional information if needed
3. **Decision**: Appropriate action is determined based on severity and context
4. **Action**: Enforcement action is taken
5. **Follow-up**: Reporter is informed of the outcome (within privacy constraints)

### Enforcement Actions

Depending on the severity and context, actions may include:

#### 1. Correction (Minor Issues)
**Impact**: Use of inappropriate language or unprofessional behavior

**Consequence**: Private written warning with clarity around the violation and explanation of why the behavior was inappropriate. A public apology may be requested.

#### 2. Warning (Moderate Issues)
**Impact**: Single incident or series of actions violating community standards

**Consequence**: Warning with consequences for continued behavior. Temporary restriction from interacting in community spaces. Violating these terms may lead to a temporary or permanent ban.

#### 3. Temporary Ban (Serious Issues)
**Impact**: Serious violation of community standards, including sustained inappropriate behavior

**Consequence**: Temporary ban from any interaction or public communication with the community for a specified period. No interaction with involved parties during this period. Violating these terms may lead to a permanent ban.

#### 4. Permanent Ban (Severe Issues)
**Impact**: Demonstrating a pattern of violation, sustained inappropriate behavior, harassment, or aggression

**Consequence**: Permanent ban from any public interaction within the community.

## Maintainer Responsibilities

Project maintainers are responsible for:

- Clarifying and enforcing standards of acceptable behavior
- Taking appropriate and fair corrective action in response to unacceptable behavior
- Removing, editing, or rejecting comments, commits, code, issues, and other contributions not aligned with this Code of Conduct
- Communicating reasons for moderation decisions when appropriate

Maintainers who do not follow or enforce the Code of Conduct may face temporary or permanent repercussions as determined by other project leadership.

## Attribution

This Code of Conduct is adapted from:
- [Contributor Covenant](https://www.contributor-covenant.org/), version 2.1
- [Mozilla Community Participation Guidelines](https://www.mozilla.org/en-US/about/governance/policies/participation/)

## Updates

This Code of Conduct may be revised periodically. The latest version will always be available in this repository. Continued participation in the community implies acceptance of the current version.

## Questions?

If you have questions about this Code of Conduct, please contact:
- **Email**: conduct@namastex.ai
- **Discord**: [Automagik Community](https://discord.gg/xcW8c7fF3R)

---

<p align="center">
  <strong>Building a better community together 🤝</strong><br>
  We're committed to making Automagik Hive a welcoming space for everyone.
</p>

<p align="center">
  Made with ❤️ by <a href="https://namastex.ai">Namastex Labs</a>
</p>