<a id="mypy-boto3-elasticbeanstalk"></a>

# mypy-boto3-elasticbeanstalk

[![PyPI - mypy-boto3-elasticbeanstalk](https://img.shields.io/pypi/v/mypy-boto3-elasticbeanstalk.svg?color=blue)](https://pypi.org/project/mypy-boto3-elasticbeanstalk)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elasticbeanstalk.svg?color=blue)](https://pypi.org/project/mypy-boto3-elasticbeanstalk)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-elasticbeanstalk?color=blue)](https://pypistats.org/packages/mypy-boto3-elasticbeanstalk)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ElasticBeanstalk 1.18.10](https://boto3.amazonaws.com/v1/documentation/api/1.18.10/reference/services/elasticbeanstalk.html#ElasticBeanstalk)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-elasticbeanstalk docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elasticbeanstalk/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-elasticbeanstalk](#mypy-boto3-elasticbeanstalk)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `ElasticBeanstalk` service.

```bash
python -m pip install boto3-stubs[elasticbeanstalk]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[elasticbeanstalk]` in your environment:
  `python -m pip install 'boto3-stubs[elasticbeanstalk]'`

Both type checking and auto-complete should work for `ElasticBeanstalk`
service. No explicit type annotations required, write your `boto3` code as
usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[elasticbeanstalk]` in your environment:
  `python -m pip install 'boto3-stubs[elasticbeanstalk]'`

Both type checking and auto-complete should work for `ElasticBeanstalk`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[elasticbeanstalk]` in your environment:
  `python -m pip install 'boto3-stubs[elasticbeanstalk]'`
- Run `mypy` as usual

Type checking should work for `ElasticBeanstalk` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[elasticbeanstalk]` in your environment:
  `python -m pip install 'boto3-stubs[elasticbeanstalk]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ElasticBeanstalk` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`ElasticBeanstalkClient` provides annotations for
`boto3.client("elasticbeanstalk")`.

```python
import boto3

from mypy_boto3_elasticbeanstalk import ElasticBeanstalkClient

client: ElasticBeanstalkClient = boto3.client("elasticbeanstalk")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElasticBeanstalkClient = session.client("elasticbeanstalk")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_elasticbeanstalk.paginator` module contains type annotations for
all paginators.

```python
from mypy_boto3_elasticbeanstalk import ElasticBeanstalkClient
from mypy_boto3_elasticbeanstalk.paginator import (
    DescribeApplicationVersionsPaginator,
    DescribeEnvironmentManagedActionHistoryPaginator,
    DescribeEnvironmentsPaginator,
    DescribeEventsPaginator,
    ListPlatformVersionsPaginator,
)

client: ElasticBeanstalkClient = boto3.client("elasticbeanstalk")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_application_versions_paginator: DescribeApplicationVersionsPaginator = client.get_paginator("describe_application_versions")
describe_environment_managed_action_history_paginator: DescribeEnvironmentManagedActionHistoryPaginator = client.get_paginator("describe_environment_managed_action_history")
describe_environments_paginator: DescribeEnvironmentsPaginator = client.get_paginator("describe_environments")
describe_events_paginator: DescribeEventsPaginator = client.get_paginator("describe_events")
list_platform_versions_paginator: ListPlatformVersionsPaginator = client.get_paginator("list_platform_versions")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_elasticbeanstalk.waiter` module contains type annotations for all
waiters.

```python
from mypy_boto3_elasticbeanstalk import ElasticBeanstalkClient
from mypy_boto3_elasticbeanstalk.waiter import (
    EnvironmentExistsWaiter,
    EnvironmentTerminatedWaiter,
    EnvironmentUpdatedWaiter,
)

client: ElasticBeanstalkClient = boto3.client("elasticbeanstalk")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
environment_exists_waiter: EnvironmentExistsWaiter = client.get_waiter("environment_exists")
environment_terminated_waiter: EnvironmentTerminatedWaiter = client.get_waiter("environment_terminated")
environment_updated_waiter: EnvironmentUpdatedWaiter = client.get_waiter("environment_updated")
```

<a id="literals"></a>

### Literals

`mypy_boto3_elasticbeanstalk.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_elasticbeanstalk.literals import (
    ActionHistoryStatusType,
    ActionStatusType,
    ActionTypeType,
    ApplicationVersionStatusType,
    ComputeTypeType,
    ConfigurationDeploymentStatusType,
    ConfigurationOptionValueTypeType,
    DescribeApplicationVersionsPaginatorName,
    DescribeEnvironmentManagedActionHistoryPaginatorName,
    DescribeEnvironmentsPaginatorName,
    DescribeEventsPaginatorName,
    EnvironmentExistsWaiterName,
    EnvironmentHealthAttributeType,
    EnvironmentHealthStatusType,
    EnvironmentHealthType,
    EnvironmentInfoTypeType,
    EnvironmentStatusType,
    EnvironmentTerminatedWaiterName,
    EnvironmentUpdatedWaiterName,
    EventSeverityType,
    FailureTypeType,
    InstancesHealthAttributeType,
    ListPlatformVersionsPaginatorName,
    PlatformStatusType,
    SourceRepositoryType,
    SourceTypeType,
    ValidationSeverityType,
)

def check_value(value: ActionHistoryStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_elasticbeanstalk.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_elasticbeanstalk.type_defs import (
    AbortEnvironmentUpdateMessageRequestTypeDef,
    ApplicationDescriptionMessageTypeDef,
    ApplicationDescriptionTypeDef,
    ApplicationDescriptionsMessageTypeDef,
    ApplicationMetricsTypeDef,
    ApplicationResourceLifecycleConfigTypeDef,
    ApplicationResourceLifecycleDescriptionMessageTypeDef,
    ApplicationVersionDescriptionMessageTypeDef,
    ApplicationVersionDescriptionTypeDef,
    ApplicationVersionDescriptionsMessageTypeDef,
    ApplicationVersionLifecycleConfigTypeDef,
    ApplyEnvironmentManagedActionRequestRequestTypeDef,
    ApplyEnvironmentManagedActionResultTypeDef,
    AssociateEnvironmentOperationsRoleMessageRequestTypeDef,
    AutoScalingGroupTypeDef,
    BuildConfigurationTypeDef,
    BuilderTypeDef,
    CPUUtilizationTypeDef,
    CheckDNSAvailabilityMessageRequestTypeDef,
    CheckDNSAvailabilityResultMessageTypeDef,
    ComposeEnvironmentsMessageRequestTypeDef,
    ConfigurationOptionDescriptionTypeDef,
    ConfigurationOptionSettingTypeDef,
    ConfigurationOptionsDescriptionTypeDef,
    ConfigurationSettingsDescriptionResponseMetadataTypeDef,
    ConfigurationSettingsDescriptionTypeDef,
    ConfigurationSettingsDescriptionsTypeDef,
    ConfigurationSettingsValidationMessagesTypeDef,
    CreateApplicationMessageRequestTypeDef,
    CreateApplicationVersionMessageRequestTypeDef,
    CreateConfigurationTemplateMessageRequestTypeDef,
    CreateEnvironmentMessageRequestTypeDef,
    CreatePlatformVersionRequestRequestTypeDef,
    CreatePlatformVersionResultTypeDef,
    CreateStorageLocationResultMessageTypeDef,
    CustomAmiTypeDef,
    DeleteApplicationMessageRequestTypeDef,
    DeleteApplicationVersionMessageRequestTypeDef,
    DeleteConfigurationTemplateMessageRequestTypeDef,
    DeleteEnvironmentConfigurationMessageRequestTypeDef,
    DeletePlatformVersionRequestRequestTypeDef,
    DeletePlatformVersionResultTypeDef,
    DeploymentTypeDef,
    DescribeAccountAttributesResultTypeDef,
    DescribeApplicationVersionsMessageRequestTypeDef,
    DescribeApplicationsMessageRequestTypeDef,
    DescribeConfigurationOptionsMessageRequestTypeDef,
    DescribeConfigurationSettingsMessageRequestTypeDef,
    DescribeEnvironmentHealthRequestRequestTypeDef,
    DescribeEnvironmentHealthResultTypeDef,
    DescribeEnvironmentManagedActionHistoryRequestRequestTypeDef,
    DescribeEnvironmentManagedActionHistoryResultTypeDef,
    DescribeEnvironmentManagedActionsRequestRequestTypeDef,
    DescribeEnvironmentManagedActionsResultTypeDef,
    DescribeEnvironmentResourcesMessageRequestTypeDef,
    DescribeEnvironmentsMessageRequestTypeDef,
    DescribeEventsMessageRequestTypeDef,
    DescribeInstancesHealthRequestRequestTypeDef,
    DescribeInstancesHealthResultTypeDef,
    DescribePlatformVersionRequestRequestTypeDef,
    DescribePlatformVersionResultTypeDef,
    DisassociateEnvironmentOperationsRoleMessageRequestTypeDef,
    EnvironmentDescriptionResponseMetadataTypeDef,
    EnvironmentDescriptionTypeDef,
    EnvironmentDescriptionsMessageTypeDef,
    EnvironmentInfoDescriptionTypeDef,
    EnvironmentLinkTypeDef,
    EnvironmentResourceDescriptionTypeDef,
    EnvironmentResourceDescriptionsMessageTypeDef,
    EnvironmentResourcesDescriptionTypeDef,
    EnvironmentTierTypeDef,
    EventDescriptionTypeDef,
    EventDescriptionsMessageTypeDef,
    InstanceHealthSummaryTypeDef,
    InstanceTypeDef,
    LatencyTypeDef,
    LaunchConfigurationTypeDef,
    LaunchTemplateTypeDef,
    ListAvailableSolutionStacksResultMessageTypeDef,
    ListPlatformBranchesRequestRequestTypeDef,
    ListPlatformBranchesResultTypeDef,
    ListPlatformVersionsRequestRequestTypeDef,
    ListPlatformVersionsResultTypeDef,
    ListTagsForResourceMessageRequestTypeDef,
    ListenerTypeDef,
    LoadBalancerDescriptionTypeDef,
    LoadBalancerTypeDef,
    ManagedActionHistoryItemTypeDef,
    ManagedActionTypeDef,
    MaxAgeRuleTypeDef,
    MaxCountRuleTypeDef,
    OptionRestrictionRegexTypeDef,
    OptionSpecificationTypeDef,
    PaginatorConfigTypeDef,
    PlatformBranchSummaryTypeDef,
    PlatformDescriptionTypeDef,
    PlatformFilterTypeDef,
    PlatformFrameworkTypeDef,
    PlatformProgrammingLanguageTypeDef,
    PlatformSummaryTypeDef,
    QueueTypeDef,
    RebuildEnvironmentMessageRequestTypeDef,
    RequestEnvironmentInfoMessageRequestTypeDef,
    ResourceQuotaTypeDef,
    ResourceQuotasTypeDef,
    ResourceTagsDescriptionMessageTypeDef,
    ResponseMetadataTypeDef,
    RestartAppServerMessageRequestTypeDef,
    RetrieveEnvironmentInfoMessageRequestTypeDef,
    RetrieveEnvironmentInfoResultMessageTypeDef,
    S3LocationTypeDef,
    SearchFilterTypeDef,
    SingleInstanceHealthTypeDef,
    SolutionStackDescriptionTypeDef,
    SourceBuildInformationTypeDef,
    SourceConfigurationTypeDef,
    StatusCodesTypeDef,
    SwapEnvironmentCNAMEsMessageRequestTypeDef,
    SystemStatusTypeDef,
    TagTypeDef,
    TerminateEnvironmentMessageRequestTypeDef,
    TriggerTypeDef,
    UpdateApplicationMessageRequestTypeDef,
    UpdateApplicationResourceLifecycleMessageRequestTypeDef,
    UpdateApplicationVersionMessageRequestTypeDef,
    UpdateConfigurationTemplateMessageRequestTypeDef,
    UpdateEnvironmentMessageRequestTypeDef,
    UpdateTagsForResourceMessageRequestTypeDef,
    ValidateConfigurationSettingsMessageRequestTypeDef,
    ValidationMessageTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AbortEnvironmentUpdateMessageRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-elasticbeanstalk` version is the same as related `boto3` version
and follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-elasticbeanstalk docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elasticbeanstalk/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
