# boto3-stubs

[![PyPI - boto3-stubs](https://img.shields.io/pypi/v/boto3-stubs.svg?color=blue)](https://pypi.org/project/boto3-stubs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/boto3-stubs.svg?color=blue)](https://pypi.org/project/boto3-stubs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/boto3-stubs?color=blue)](https://pypistats.org/packages/boto3-stubs)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3 1.17.54](https://boto3.amazonaws.com/v1/documentation/api/1.17.54/index.html)
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.6.0](https://github.com/vemel/mypy_boto3_builder).

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [boto3-stubs](#boto3-stubs)
  - [How to install](#how-to-install)
    - [Basic](#basic)
    - [Dynamic type annotations](#dynamic-type-annotations)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [Basic](#basic-1)
    - [Setup your IDE](#setup-your-ide)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [Explicit type annotations](#explicit-type-annotations)
    - [Pylint compatibility](#pylint-compatibility)
  - [How it works](#how-it-works)
  - [What's new](#whats-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
    - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Submodules](#submodules)

## How to install

### Basic

Install `boto3-stubs`, to add type annotations for `boto3` package.

```bash
# install type annotations just for boto3
python -m pip install boto3-stubs

# install `boto3` type annotations
# for ec2, s3, rds, lambda, sqs, dynamo and cloudformation
# Consumes ~7 MB of space
python -m pip install 'boto3-stubs[essential]'

# or install annotations for services you use
python -m pip install 'boto3-stubs[acm,apigateway]'
```

## How to uninstall

```bash
# uninstall boto3-stubs
python -m pip uninstall -y boto3-stubs

# uninstall submodules
python -m pip freeze | grep mypy-boto3 | xargs python -m pip uninstall -y
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs` with services you use in your environment: `python -m pip install 'boto3-stubs[s3,ec2]'`

Both type checking and auto-complete should work for installed `boto3` services.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs` with services you use in your environment: `python -m pip install 'boto3-stubs[s3,ec2]'`
- Install `mypy_boto3_builder`: `pip install mypy_boto3_builder`
- Generate stubs in `<project_root>/typings` directory for services you use

```bash
python -m mypy_boto3_builder --installed --skip-services typings -d -s s3 ec2
```

- Add `<project_root>/typings` folder to your [Interpreter Paths](https://www.jetbrains.com/help/pycharm/stubs.html#reuse-stubs)

Since stubs are stored in your project root, you do not need to re-generate them after update.

### Emacs

- Install `boto-stubs` with services you use in your environment: `python -m pip install 'boto3-stubs[s3,ec2]'`
- Install
  [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed `boto3-stubs`

### Sublime Text

- Install `boto-stubs` with services you use in your environment: `python -m pip install 'boto3-stubs[s3,ec2]'`
- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package
- Make sure emacs uses the environment where you have installed `boto3-stubs`

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs` with services you use in your environment: `python -m pip install 'boto3-stubs[s3,ec2]'`
- Run `mypy` as usual

Type checking should work for installed `boto3` services.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs` with services you use in your environment: `python -m pip install 'boto3-stubs[s3,ec2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for installed `boto3` services.
No explicit type annotations required, write your `boto3` code as usual.

### Explicit type annotations

To speed up type checking and auto-complete, you can set types explicitly.

```python
import boto3
from boto3.session import Session

import mypy_boto3_ec2.client import EC2Client
import mypy_boto3_ec2.service_resource import EC2ServiceResource
import mypy_boto3_ec2.waiter import BundleTaskCompleteWaiter
import mypy_boto3_ec2.paginator import DescribeVolumesPaginator

session = Session(region_name="us-west-1")

ec2_client: EC2Client = boto3.client("ec2", region_name="us-west-1")
ec2_resource: EC2ServiceResource = session.resource("ec2")

bundle_task_complete_waiter: BundleTaskCompleteWaiter = ec2_client.get_waiter("bundle_task_complete")
describe_volumes_paginator: DescribeVolumesPaginator = ec2_client.get_paginator("describe_volumes")
```

### Pylint compatibility

It is totally safe to use `TYPE_CHECKING` flag in order to avoid `boto3-stubs`
dependency in production.
However, there is an issue in `pylint` that it complains about undefined
variables. To fix it, set all types to `object` in non-`TYPE_CHECKING` mode.

```python
import boto3
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from mypy_boto3_ec2 import EC2Client, EC2ServiceResource
    from mypy_boto3_ec2.waiters import BundleTaskCompleteWaiter
    from mypy_boto3_ec2.paginators import DescribeVolumesPaginator
else:
    EC2Client = object
    EC2ServiceResource = object
    BundleTaskCompleteWaiter = object
    DescribeVolumesPaginator = object

...
```

## How it works

Fully automated [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black)
  and [isort](https://github.com/PyCQA/isort) for readability.

## What's new

### Implemented features

- Fully type annotated `boto3` library
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs` compatibility
- `Client` type annotations for each service
- `ServiceResource` type annotations for each service
- `Resource` type annotations for each service
- `Waiter` type annotations for each service
- `Paginator` type annotations for each service
- Generated `TypeDefs` for each service
- Auto discovery of types for `boto3.client` and `boto3.session` calls
- Auto discovery of types for `session.client` and `session.session` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator` calls
- Auto discovery of types for `ServiceResource` and `Resource` collections

### Latest changes

Builder changelog can be found in [Releases](https://github.com/vemel/mypy_boto3_builder/releases).

## Versioning

`boto3-stubs` uses format `<boto3_version>.<build>`, e.g. for `boto3 1.10.40`,
`boto3-stubs` versions are is `1.10.40.0` and `1.10.40.1`.

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed Python

## Submodules
 developers
- `boto3-stubs[all]` - Type annotations for all 262 services.
- `boto3-stubs[essential]` - Type annotations for [CloudFormation](https://pypi.org/project/mypy-boto3-cloudformation/), [DynamoDB](https://pypi.org/project/mypy-boto3-dynamodb/), [EC2](https://pypi.org/project/mypy-boto3-ec2/), [Lambda](https://pypi.org/project/mypy-boto3-lambda/), [RDS](https://pypi.org/project/mypy-boto3-rds/), [S3](https://pypi.org/project/mypy-boto3-s3/) and [SQS](https://pypi.org/project/mypy-boto3-sqs/) services.
- `boto3-stubs[accessanalyzer]` - Type annotations for [AccessAnalyzer](https://pypi.org/project/mypy-boto3-accessanalyzer/) service.
- `boto3-stubs[acm]` - Type annotations for [ACM](https://pypi.org/project/mypy-boto3-acm/) service.
- `boto3-stubs[acm-pca]` - Type annotations for [ACMPCA](https://pypi.org/project/mypy-boto3-acm-pca/) service.
- `boto3-stubs[alexaforbusiness]` - Type annotations for [AlexaForBusiness](https://pypi.org/project/mypy-boto3-alexaforbusiness/) service.
- `boto3-stubs[amp]` - Type annotations for [PrometheusService](https://pypi.org/project/mypy-boto3-amp/) service.
- `boto3-stubs[amplify]` - Type annotations for [Amplify](https://pypi.org/project/mypy-boto3-amplify/) service.
- `boto3-stubs[amplifybackend]` - Type annotations for [AmplifyBackend](https://pypi.org/project/mypy-boto3-amplifybackend/) service.
- `boto3-stubs[apigateway]` - Type annotations for [APIGateway](https://pypi.org/project/mypy-boto3-apigateway/) service.
- `boto3-stubs[apigatewaymanagementapi]` - Type annotations for [ApiGatewayManagementApi](https://pypi.org/project/mypy-boto3-apigatewaymanagementapi/) service.
- `boto3-stubs[apigatewayv2]` - Type annotations for [ApiGatewayV2](https://pypi.org/project/mypy-boto3-apigatewayv2/) service.
- `boto3-stubs[appconfig]` - Type annotations for [AppConfig](https://pypi.org/project/mypy-boto3-appconfig/) service.
- `boto3-stubs[appflow]` - Type annotations for [Appflow](https://pypi.org/project/mypy-boto3-appflow/) service.
- `boto3-stubs[appintegrations]` - Type annotations for [AppIntegrationsService](https://pypi.org/project/mypy-boto3-appintegrations/) service.
- `boto3-stubs[application-autoscaling]` - Type annotations for [ApplicationAutoScaling](https://pypi.org/project/mypy-boto3-application-autoscaling/) service.
- `boto3-stubs[application-insights]` - Type annotations for [ApplicationInsights](https://pypi.org/project/mypy-boto3-application-insights/) service.
- `boto3-stubs[appmesh]` - Type annotations for [AppMesh](https://pypi.org/project/mypy-boto3-appmesh/) service.
- `boto3-stubs[appstream]` - Type annotations for [AppStream](https://pypi.org/project/mypy-boto3-appstream/) service.
- `boto3-stubs[appsync]` - Type annotations for [AppSync](https://pypi.org/project/mypy-boto3-appsync/) service.
- `boto3-stubs[athena]` - Type annotations for [Athena](https://pypi.org/project/mypy-boto3-athena/) service.
- `boto3-stubs[auditmanager]` - Type annotations for [AuditManager](https://pypi.org/project/mypy-boto3-auditmanager/) service.
- `boto3-stubs[autoscaling]` - Type annotations for [AutoScaling](https://pypi.org/project/mypy-boto3-autoscaling/) service.
- `boto3-stubs[autoscaling-plans]` - Type annotations for [AutoScalingPlans](https://pypi.org/project/mypy-boto3-autoscaling-plans/) service.
- `boto3-stubs[backup]` - Type annotations for [Backup](https://pypi.org/project/mypy-boto3-backup/) service.
- `boto3-stubs[batch]` - Type annotations for [Batch](https://pypi.org/project/mypy-boto3-batch/) service.
- `boto3-stubs[braket]` - Type annotations for [Braket](https://pypi.org/project/mypy-boto3-braket/) service.
- `boto3-stubs[budgets]` - Type annotations for [Budgets](https://pypi.org/project/mypy-boto3-budgets/) service.
- `boto3-stubs[ce]` - Type annotations for [CostExplorer](https://pypi.org/project/mypy-boto3-ce/) service.
- `boto3-stubs[chime]` - Type annotations for [Chime](https://pypi.org/project/mypy-boto3-chime/) service.
- `boto3-stubs[cloud9]` - Type annotations for [Cloud9](https://pypi.org/project/mypy-boto3-cloud9/) service.
- `boto3-stubs[clouddirectory]` - Type annotations for [CloudDirectory](https://pypi.org/project/mypy-boto3-clouddirectory/) service.
- `boto3-stubs[cloudformation]` - Type annotations for [CloudFormation](https://pypi.org/project/mypy-boto3-cloudformation/) service.
- `boto3-stubs[cloudfront]` - Type annotations for [CloudFront](https://pypi.org/project/mypy-boto3-cloudfront/) service.
- `boto3-stubs[cloudhsm]` - Type annotations for [CloudHSM](https://pypi.org/project/mypy-boto3-cloudhsm/) service.
- `boto3-stubs[cloudhsmv2]` - Type annotations for [CloudHSMV2](https://pypi.org/project/mypy-boto3-cloudhsmv2/) service.
- `boto3-stubs[cloudsearch]` - Type annotations for [CloudSearch](https://pypi.org/project/mypy-boto3-cloudsearch/) service.
- `boto3-stubs[cloudsearchdomain]` - Type annotations for [CloudSearchDomain](https://pypi.org/project/mypy-boto3-cloudsearchdomain/) service.
- `boto3-stubs[cloudtrail]` - Type annotations for [CloudTrail](https://pypi.org/project/mypy-boto3-cloudtrail/) service.
- `boto3-stubs[cloudwatch]` - Type annotations for [CloudWatch](https://pypi.org/project/mypy-boto3-cloudwatch/) service.
- `boto3-stubs[codeartifact]` - Type annotations for [CodeArtifact](https://pypi.org/project/mypy-boto3-codeartifact/) service.
- `boto3-stubs[codebuild]` - Type annotations for [CodeBuild](https://pypi.org/project/mypy-boto3-codebuild/) service.
- `boto3-stubs[codecommit]` - Type annotations for [CodeCommit](https://pypi.org/project/mypy-boto3-codecommit/) service.
- `boto3-stubs[codedeploy]` - Type annotations for [CodeDeploy](https://pypi.org/project/mypy-boto3-codedeploy/) service.
- `boto3-stubs[codeguru-reviewer]` - Type annotations for [CodeGuruReviewer](https://pypi.org/project/mypy-boto3-codeguru-reviewer/) service.
- `boto3-stubs[codeguruprofiler]` - Type annotations for [CodeGuruProfiler](https://pypi.org/project/mypy-boto3-codeguruprofiler/) service.
- `boto3-stubs[codepipeline]` - Type annotations for [CodePipeline](https://pypi.org/project/mypy-boto3-codepipeline/) service.
- `boto3-stubs[codestar]` - Type annotations for [CodeStar](https://pypi.org/project/mypy-boto3-codestar/) service.
- `boto3-stubs[codestar-connections]` - Type annotations for [CodeStarconnections](https://pypi.org/project/mypy-boto3-codestar-connections/) service.
- `boto3-stubs[codestar-notifications]` - Type annotations for [CodeStarNotifications](https://pypi.org/project/mypy-boto3-codestar-notifications/) service.
- `boto3-stubs[cognito-identity]` - Type annotations for [CognitoIdentity](https://pypi.org/project/mypy-boto3-cognito-identity/) service.
- `boto3-stubs[cognito-idp]` - Type annotations for [CognitoIdentityProvider](https://pypi.org/project/mypy-boto3-cognito-idp/) service.
- `boto3-stubs[cognito-sync]` - Type annotations for [CognitoSync](https://pypi.org/project/mypy-boto3-cognito-sync/) service.
- `boto3-stubs[comprehend]` - Type annotations for [Comprehend](https://pypi.org/project/mypy-boto3-comprehend/) service.
- `boto3-stubs[comprehendmedical]` - Type annotations for [ComprehendMedical](https://pypi.org/project/mypy-boto3-comprehendmedical/) service.
- `boto3-stubs[compute-optimizer]` - Type annotations for [ComputeOptimizer](https://pypi.org/project/mypy-boto3-compute-optimizer/) service.
- `boto3-stubs[config]` - Type annotations for [ConfigService](https://pypi.org/project/mypy-boto3-config/) service.
- `boto3-stubs[connect]` - Type annotations for [Connect](https://pypi.org/project/mypy-boto3-connect/) service.
- `boto3-stubs[connect-contact-lens]` - Type annotations for [ConnectContactLens](https://pypi.org/project/mypy-boto3-connect-contact-lens/) service.
- `boto3-stubs[connectparticipant]` - Type annotations for [ConnectParticipant](https://pypi.org/project/mypy-boto3-connectparticipant/) service.
- `boto3-stubs[cur]` - Type annotations for [CostandUsageReportService](https://pypi.org/project/mypy-boto3-cur/) service.
- `boto3-stubs[customer-profiles]` - Type annotations for [CustomerProfiles](https://pypi.org/project/mypy-boto3-customer-profiles/) service.
- `boto3-stubs[databrew]` - Type annotations for [GlueDataBrew](https://pypi.org/project/mypy-boto3-databrew/) service.
- `boto3-stubs[dataexchange]` - Type annotations for [DataExchange](https://pypi.org/project/mypy-boto3-dataexchange/) service.
- `boto3-stubs[datapipeline]` - Type annotations for [DataPipeline](https://pypi.org/project/mypy-boto3-datapipeline/) service.
- `boto3-stubs[datasync]` - Type annotations for [DataSync](https://pypi.org/project/mypy-boto3-datasync/) service.
- `boto3-stubs[dax]` - Type annotations for [DAX](https://pypi.org/project/mypy-boto3-dax/) service.
- `boto3-stubs[detective]` - Type annotations for [Detective](https://pypi.org/project/mypy-boto3-detective/) service.
- `boto3-stubs[devicefarm]` - Type annotations for [DeviceFarm](https://pypi.org/project/mypy-boto3-devicefarm/) service.
- `boto3-stubs[devops-guru]` - Type annotations for [DevopsGuru](https://pypi.org/project/mypy-boto3-devops-guru/) service.
- `boto3-stubs[directconnect]` - Type annotations for [DirectConnect](https://pypi.org/project/mypy-boto3-directconnect/) service.
- `boto3-stubs[discovery]` - Type annotations for [ApplicationDiscoveryService](https://pypi.org/project/mypy-boto3-discovery/) service.
- `boto3-stubs[dlm]` - Type annotations for [DLM](https://pypi.org/project/mypy-boto3-dlm/) service.
- `boto3-stubs[dms]` - Type annotations for [DatabaseMigrationService](https://pypi.org/project/mypy-boto3-dms/) service.
- `boto3-stubs[docdb]` - Type annotations for [DocDB](https://pypi.org/project/mypy-boto3-docdb/) service.
- `boto3-stubs[ds]` - Type annotations for [DirectoryService](https://pypi.org/project/mypy-boto3-ds/) service.
- `boto3-stubs[dynamodb]` - Type annotations for [DynamoDB](https://pypi.org/project/mypy-boto3-dynamodb/) service.
- `boto3-stubs[dynamodbstreams]` - Type annotations for [DynamoDBStreams](https://pypi.org/project/mypy-boto3-dynamodbstreams/) service.
- `boto3-stubs[ebs]` - Type annotations for [EBS](https://pypi.org/project/mypy-boto3-ebs/) service.
- `boto3-stubs[ec2]` - Type annotations for [EC2](https://pypi.org/project/mypy-boto3-ec2/) service.
- `boto3-stubs[ec2-instance-connect]` - Type annotations for [EC2InstanceConnect](https://pypi.org/project/mypy-boto3-ec2-instance-connect/) service.
- `boto3-stubs[ecr]` - Type annotations for [ECR](https://pypi.org/project/mypy-boto3-ecr/) service.
- `boto3-stubs[ecr-public]` - Type annotations for [ECRPublic](https://pypi.org/project/mypy-boto3-ecr-public/) service.
- `boto3-stubs[ecs]` - Type annotations for [ECS](https://pypi.org/project/mypy-boto3-ecs/) service.
- `boto3-stubs[efs]` - Type annotations for [EFS](https://pypi.org/project/mypy-boto3-efs/) service.
- `boto3-stubs[eks]` - Type annotations for [EKS](https://pypi.org/project/mypy-boto3-eks/) service.
- `boto3-stubs[elastic-inference]` - Type annotations for [ElasticInference](https://pypi.org/project/mypy-boto3-elastic-inference/) service.
- `boto3-stubs[elasticache]` - Type annotations for [ElastiCache](https://pypi.org/project/mypy-boto3-elasticache/) service.
- `boto3-stubs[elasticbeanstalk]` - Type annotations for [ElasticBeanstalk](https://pypi.org/project/mypy-boto3-elasticbeanstalk/) service.
- `boto3-stubs[elastictranscoder]` - Type annotations for [ElasticTranscoder](https://pypi.org/project/mypy-boto3-elastictranscoder/) service.
- `boto3-stubs[elb]` - Type annotations for [ElasticLoadBalancing](https://pypi.org/project/mypy-boto3-elb/) service.
- `boto3-stubs[elbv2]` - Type annotations for [ElasticLoadBalancingv2](https://pypi.org/project/mypy-boto3-elbv2/) service.
- `boto3-stubs[emr]` - Type annotations for [EMR](https://pypi.org/project/mypy-boto3-emr/) service.
- `boto3-stubs[emr-containers]` - Type annotations for [EMRContainers](https://pypi.org/project/mypy-boto3-emr-containers/) service.
- `boto3-stubs[es]` - Type annotations for [ElasticsearchService](https://pypi.org/project/mypy-boto3-es/) service.
- `boto3-stubs[events]` - Type annotations for [EventBridge](https://pypi.org/project/mypy-boto3-events/) service.
- `boto3-stubs[firehose]` - Type annotations for [Firehose](https://pypi.org/project/mypy-boto3-firehose/) service.
- `boto3-stubs[fis]` - Type annotations for [FIS](https://pypi.org/project/mypy-boto3-fis/) service.
- `boto3-stubs[fms]` - Type annotations for [FMS](https://pypi.org/project/mypy-boto3-fms/) service.
- `boto3-stubs[forecast]` - Type annotations for [ForecastService](https://pypi.org/project/mypy-boto3-forecast/) service.
- `boto3-stubs[forecastquery]` - Type annotations for [ForecastQueryService](https://pypi.org/project/mypy-boto3-forecastquery/) service.
- `boto3-stubs[frauddetector]` - Type annotations for [FraudDetector](https://pypi.org/project/mypy-boto3-frauddetector/) service.
- `boto3-stubs[fsx]` - Type annotations for [FSx](https://pypi.org/project/mypy-boto3-fsx/) service.
- `boto3-stubs[gamelift]` - Type annotations for [GameLift](https://pypi.org/project/mypy-boto3-gamelift/) service.
- `boto3-stubs[glacier]` - Type annotations for [Glacier](https://pypi.org/project/mypy-boto3-glacier/) service.
- `boto3-stubs[globalaccelerator]` - Type annotations for [GlobalAccelerator](https://pypi.org/project/mypy-boto3-globalaccelerator/) service.
- `boto3-stubs[glue]` - Type annotations for [Glue](https://pypi.org/project/mypy-boto3-glue/) service.
- `boto3-stubs[greengrass]` - Type annotations for [Greengrass](https://pypi.org/project/mypy-boto3-greengrass/) service.
- `boto3-stubs[greengrassv2]` - Type annotations for [GreengrassV2](https://pypi.org/project/mypy-boto3-greengrassv2/) service.
- `boto3-stubs[groundstation]` - Type annotations for [GroundStation](https://pypi.org/project/mypy-boto3-groundstation/) service.
- `boto3-stubs[guardduty]` - Type annotations for [GuardDuty](https://pypi.org/project/mypy-boto3-guardduty/) service.
- `boto3-stubs[health]` - Type annotations for [Health](https://pypi.org/project/mypy-boto3-health/) service.
- `boto3-stubs[healthlake]` - Type annotations for [HealthLake](https://pypi.org/project/mypy-boto3-healthlake/) service.
- `boto3-stubs[honeycode]` - Type annotations for [Honeycode](https://pypi.org/project/mypy-boto3-honeycode/) service.
- `boto3-stubs[iam]` - Type annotations for [IAM](https://pypi.org/project/mypy-boto3-iam/) service.
- `boto3-stubs[identitystore]` - Type annotations for [IdentityStore](https://pypi.org/project/mypy-boto3-identitystore/) service.
- `boto3-stubs[imagebuilder]` - Type annotations for [Imagebuilder](https://pypi.org/project/mypy-boto3-imagebuilder/) service.
- `boto3-stubs[importexport]` - Type annotations for [ImportExport](https://pypi.org/project/mypy-boto3-importexport/) service.
- `boto3-stubs[inspector]` - Type annotations for [Inspector](https://pypi.org/project/mypy-boto3-inspector/) service.
- `boto3-stubs[iot]` - Type annotations for [IoT](https://pypi.org/project/mypy-boto3-iot/) service.
- `boto3-stubs[iot-data]` - Type annotations for [IoTDataPlane](https://pypi.org/project/mypy-boto3-iot-data/) service.
- `boto3-stubs[iot-jobs-data]` - Type annotations for [IoTJobsDataPlane](https://pypi.org/project/mypy-boto3-iot-jobs-data/) service.
- `boto3-stubs[iot1click-devices]` - Type annotations for [IoT1ClickDevicesService](https://pypi.org/project/mypy-boto3-iot1click-devices/) service.
- `boto3-stubs[iot1click-projects]` - Type annotations for [IoT1ClickProjects](https://pypi.org/project/mypy-boto3-iot1click-projects/) service.
- `boto3-stubs[iotanalytics]` - Type annotations for [IoTAnalytics](https://pypi.org/project/mypy-boto3-iotanalytics/) service.
- `boto3-stubs[iotdeviceadvisor]` - Type annotations for [IoTDeviceAdvisor](https://pypi.org/project/mypy-boto3-iotdeviceadvisor/) service.
- `boto3-stubs[iotevents]` - Type annotations for [IoTEvents](https://pypi.org/project/mypy-boto3-iotevents/) service.
- `boto3-stubs[iotevents-data]` - Type annotations for [IoTEventsData](https://pypi.org/project/mypy-boto3-iotevents-data/) service.
- `boto3-stubs[iotfleethub]` - Type annotations for [IoTFleetHub](https://pypi.org/project/mypy-boto3-iotfleethub/) service.
- `boto3-stubs[iotsecuretunneling]` - Type annotations for [IoTSecureTunneling](https://pypi.org/project/mypy-boto3-iotsecuretunneling/) service.
- `boto3-stubs[iotsitewise]` - Type annotations for [IoTSiteWise](https://pypi.org/project/mypy-boto3-iotsitewise/) service.
- `boto3-stubs[iotthingsgraph]` - Type annotations for [IoTThingsGraph](https://pypi.org/project/mypy-boto3-iotthingsgraph/) service.
- `boto3-stubs[iotwireless]` - Type annotations for [IoTWireless](https://pypi.org/project/mypy-boto3-iotwireless/) service.
- `boto3-stubs[ivs]` - Type annotations for [IVS](https://pypi.org/project/mypy-boto3-ivs/) service.
- `boto3-stubs[kafka]` - Type annotations for [Kafka](https://pypi.org/project/mypy-boto3-kafka/) service.
- `boto3-stubs[kendra]` - Type annotations for [Kendra](https://pypi.org/project/mypy-boto3-kendra/) service.
- `boto3-stubs[kinesis]` - Type annotations for [Kinesis](https://pypi.org/project/mypy-boto3-kinesis/) service.
- `boto3-stubs[kinesis-video-archived-media]` - Type annotations for [KinesisVideoArchivedMedia](https://pypi.org/project/mypy-boto3-kinesis-video-archived-media/) service.
- `boto3-stubs[kinesis-video-media]` - Type annotations for [KinesisVideoMedia](https://pypi.org/project/mypy-boto3-kinesis-video-media/) service.
- `boto3-stubs[kinesis-video-signaling]` - Type annotations for [KinesisVideoSignalingChannels](https://pypi.org/project/mypy-boto3-kinesis-video-signaling/) service.
- `boto3-stubs[kinesisanalytics]` - Type annotations for [KinesisAnalytics](https://pypi.org/project/mypy-boto3-kinesisanalytics/) service.
- `boto3-stubs[kinesisanalyticsv2]` - Type annotations for [KinesisAnalyticsV2](https://pypi.org/project/mypy-boto3-kinesisanalyticsv2/) service.
- `boto3-stubs[kinesisvideo]` - Type annotations for [KinesisVideo](https://pypi.org/project/mypy-boto3-kinesisvideo/) service.
- `boto3-stubs[kms]` - Type annotations for [KMS](https://pypi.org/project/mypy-boto3-kms/) service.
- `boto3-stubs[lakeformation]` - Type annotations for [LakeFormation](https://pypi.org/project/mypy-boto3-lakeformation/) service.
- `boto3-stubs[lambda]` - Type annotations for [Lambda](https://pypi.org/project/mypy-boto3-lambda/) service.
- `boto3-stubs[lex-models]` - Type annotations for [LexModelBuildingService](https://pypi.org/project/mypy-boto3-lex-models/) service.
- `boto3-stubs[lex-runtime]` - Type annotations for [LexRuntimeService](https://pypi.org/project/mypy-boto3-lex-runtime/) service.
- `boto3-stubs[lexv2-models]` - Type annotations for [LexModelsV2](https://pypi.org/project/mypy-boto3-lexv2-models/) service.
- `boto3-stubs[lexv2-runtime]` - Type annotations for [LexRuntimeV2](https://pypi.org/project/mypy-boto3-lexv2-runtime/) service.
- `boto3-stubs[license-manager]` - Type annotations for [LicenseManager](https://pypi.org/project/mypy-boto3-license-manager/) service.
- `boto3-stubs[lightsail]` - Type annotations for [Lightsail](https://pypi.org/project/mypy-boto3-lightsail/) service.
- `boto3-stubs[location]` - Type annotations for [LocationService](https://pypi.org/project/mypy-boto3-location/) service.
- `boto3-stubs[logs]` - Type annotations for [CloudWatchLogs](https://pypi.org/project/mypy-boto3-logs/) service.
- `boto3-stubs[lookoutequipment]` - Type annotations for [LookoutEquipment](https://pypi.org/project/mypy-boto3-lookoutequipment/) service.
- `boto3-stubs[lookoutmetrics]` - Type annotations for [LookoutMetrics](https://pypi.org/project/mypy-boto3-lookoutmetrics/) service.
- `boto3-stubs[lookoutvision]` - Type annotations for [LookoutforVision](https://pypi.org/project/mypy-boto3-lookoutvision/) service.
- `boto3-stubs[machinelearning]` - Type annotations for [MachineLearning](https://pypi.org/project/mypy-boto3-machinelearning/) service.
- `boto3-stubs[macie]` - Type annotations for [Macie](https://pypi.org/project/mypy-boto3-macie/) service.
- `boto3-stubs[macie2]` - Type annotations for [Macie2](https://pypi.org/project/mypy-boto3-macie2/) service.
- `boto3-stubs[managedblockchain]` - Type annotations for [ManagedBlockchain](https://pypi.org/project/mypy-boto3-managedblockchain/) service.
- `boto3-stubs[marketplace-catalog]` - Type annotations for [MarketplaceCatalog](https://pypi.org/project/mypy-boto3-marketplace-catalog/) service.
- `boto3-stubs[marketplace-entitlement]` - Type annotations for [MarketplaceEntitlementService](https://pypi.org/project/mypy-boto3-marketplace-entitlement/) service.
- `boto3-stubs[marketplacecommerceanalytics]` - Type annotations for [MarketplaceCommerceAnalytics](https://pypi.org/project/mypy-boto3-marketplacecommerceanalytics/) service.
- `boto3-stubs[mediaconnect]` - Type annotations for [MediaConnect](https://pypi.org/project/mypy-boto3-mediaconnect/) service.
- `boto3-stubs[mediaconvert]` - Type annotations for [MediaConvert](https://pypi.org/project/mypy-boto3-mediaconvert/) service.
- `boto3-stubs[medialive]` - Type annotations for [MediaLive](https://pypi.org/project/mypy-boto3-medialive/) service.
- `boto3-stubs[mediapackage]` - Type annotations for [MediaPackage](https://pypi.org/project/mypy-boto3-mediapackage/) service.
- `boto3-stubs[mediapackage-vod]` - Type annotations for [MediaPackageVod](https://pypi.org/project/mypy-boto3-mediapackage-vod/) service.
- `boto3-stubs[mediastore]` - Type annotations for [MediaStore](https://pypi.org/project/mypy-boto3-mediastore/) service.
- `boto3-stubs[mediastore-data]` - Type annotations for [MediaStoreData](https://pypi.org/project/mypy-boto3-mediastore-data/) service.
- `boto3-stubs[mediatailor]` - Type annotations for [MediaTailor](https://pypi.org/project/mypy-boto3-mediatailor/) service.
- `boto3-stubs[meteringmarketplace]` - Type annotations for [MarketplaceMetering](https://pypi.org/project/mypy-boto3-meteringmarketplace/) service.
- `boto3-stubs[mgh]` - Type annotations for [MigrationHub](https://pypi.org/project/mypy-boto3-mgh/) service.
- `boto3-stubs[mgn]` - Type annotations for [mgn](https://pypi.org/project/mypy-boto3-mgn/) service.
- `boto3-stubs[migrationhub-config]` - Type annotations for [MigrationHubConfig](https://pypi.org/project/mypy-boto3-migrationhub-config/) service.
- `boto3-stubs[mobile]` - Type annotations for [Mobile](https://pypi.org/project/mypy-boto3-mobile/) service.
- `boto3-stubs[mq]` - Type annotations for [MQ](https://pypi.org/project/mypy-boto3-mq/) service.
- `boto3-stubs[mturk]` - Type annotations for [MTurk](https://pypi.org/project/mypy-boto3-mturk/) service.
- `boto3-stubs[mwaa]` - Type annotations for [MWAA](https://pypi.org/project/mypy-boto3-mwaa/) service.
- `boto3-stubs[neptune]` - Type annotations for [Neptune](https://pypi.org/project/mypy-boto3-neptune/) service.
- `boto3-stubs[network-firewall]` - Type annotations for [NetworkFirewall](https://pypi.org/project/mypy-boto3-network-firewall/) service.
- `boto3-stubs[networkmanager]` - Type annotations for [NetworkManager](https://pypi.org/project/mypy-boto3-networkmanager/) service.
- `boto3-stubs[opsworks]` - Type annotations for [OpsWorks](https://pypi.org/project/mypy-boto3-opsworks/) service.
- `boto3-stubs[opsworkscm]` - Type annotations for [OpsWorksCM](https://pypi.org/project/mypy-boto3-opsworkscm/) service.
- `boto3-stubs[organizations]` - Type annotations for [Organizations](https://pypi.org/project/mypy-boto3-organizations/) service.
- `boto3-stubs[outposts]` - Type annotations for [Outposts](https://pypi.org/project/mypy-boto3-outposts/) service.
- `boto3-stubs[personalize]` - Type annotations for [Personalize](https://pypi.org/project/mypy-boto3-personalize/) service.
- `boto3-stubs[personalize-events]` - Type annotations for [PersonalizeEvents](https://pypi.org/project/mypy-boto3-personalize-events/) service.
- `boto3-stubs[personalize-runtime]` - Type annotations for [PersonalizeRuntime](https://pypi.org/project/mypy-boto3-personalize-runtime/) service.
- `boto3-stubs[pi]` - Type annotations for [PI](https://pypi.org/project/mypy-boto3-pi/) service.
- `boto3-stubs[pinpoint]` - Type annotations for [Pinpoint](https://pypi.org/project/mypy-boto3-pinpoint/) service.
- `boto3-stubs[pinpoint-email]` - Type annotations for [PinpointEmail](https://pypi.org/project/mypy-boto3-pinpoint-email/) service.
- `boto3-stubs[pinpoint-sms-voice]` - Type annotations for [PinpointSMSVoice](https://pypi.org/project/mypy-boto3-pinpoint-sms-voice/) service.
- `boto3-stubs[polly]` - Type annotations for [Polly](https://pypi.org/project/mypy-boto3-polly/) service.
- `boto3-stubs[pricing]` - Type annotations for [Pricing](https://pypi.org/project/mypy-boto3-pricing/) service.
- `boto3-stubs[qldb]` - Type annotations for [QLDB](https://pypi.org/project/mypy-boto3-qldb/) service.
- `boto3-stubs[qldb-session]` - Type annotations for [QLDBSession](https://pypi.org/project/mypy-boto3-qldb-session/) service.
- `boto3-stubs[quicksight]` - Type annotations for [QuickSight](https://pypi.org/project/mypy-boto3-quicksight/) service.
- `boto3-stubs[ram]` - Type annotations for [RAM](https://pypi.org/project/mypy-boto3-ram/) service.
- `boto3-stubs[rds]` - Type annotations for [RDS](https://pypi.org/project/mypy-boto3-rds/) service.
- `boto3-stubs[rds-data]` - Type annotations for [RDSDataService](https://pypi.org/project/mypy-boto3-rds-data/) service.
- `boto3-stubs[redshift]` - Type annotations for [Redshift](https://pypi.org/project/mypy-boto3-redshift/) service.
- `boto3-stubs[redshift-data]` - Type annotations for [RedshiftDataAPIService](https://pypi.org/project/mypy-boto3-redshift-data/) service.
- `boto3-stubs[rekognition]` - Type annotations for [Rekognition](https://pypi.org/project/mypy-boto3-rekognition/) service.
- `boto3-stubs[resource-groups]` - Type annotations for [ResourceGroups](https://pypi.org/project/mypy-boto3-resource-groups/) service.
- `boto3-stubs[resourcegroupstaggingapi]` - Type annotations for [ResourceGroupsTaggingAPI](https://pypi.org/project/mypy-boto3-resourcegroupstaggingapi/) service.
- `boto3-stubs[robomaker]` - Type annotations for [RoboMaker](https://pypi.org/project/mypy-boto3-robomaker/) service.
- `boto3-stubs[route53]` - Type annotations for [Route53](https://pypi.org/project/mypy-boto3-route53/) service.
- `boto3-stubs[route53domains]` - Type annotations for [Route53Domains](https://pypi.org/project/mypy-boto3-route53domains/) service.
- `boto3-stubs[route53resolver]` - Type annotations for [Route53Resolver](https://pypi.org/project/mypy-boto3-route53resolver/) service.
- `boto3-stubs[s3]` - Type annotations for [S3](https://pypi.org/project/mypy-boto3-s3/) service.
- `boto3-stubs[s3control]` - Type annotations for [S3Control](https://pypi.org/project/mypy-boto3-s3control/) service.
- `boto3-stubs[s3outposts]` - Type annotations for [S3Outposts](https://pypi.org/project/mypy-boto3-s3outposts/) service.
- `boto3-stubs[sagemaker]` - Type annotations for [SageMaker](https://pypi.org/project/mypy-boto3-sagemaker/) service.
- `boto3-stubs[sagemaker-a2i-runtime]` - Type annotations for [AugmentedAIRuntime](https://pypi.org/project/mypy-boto3-sagemaker-a2i-runtime/) service.
- `boto3-stubs[sagemaker-edge]` - Type annotations for [SagemakerEdgeManager](https://pypi.org/project/mypy-boto3-sagemaker-edge/) service.
- `boto3-stubs[sagemaker-featurestore-runtime]` - Type annotations for [SagemakerFeatureStoreRuntime](https://pypi.org/project/mypy-boto3-sagemaker-featurestore-runtime/) service.
- `boto3-stubs[sagemaker-runtime]` - Type annotations for [SageMakerRuntime](https://pypi.org/project/mypy-boto3-sagemaker-runtime/) service.
- `boto3-stubs[savingsplans]` - Type annotations for [SavingsPlans](https://pypi.org/project/mypy-boto3-savingsplans/) service.
- `boto3-stubs[schemas]` - Type annotations for [Schemas](https://pypi.org/project/mypy-boto3-schemas/) service.
- `boto3-stubs[sdb]` - Type annotations for [SimpleDB](https://pypi.org/project/mypy-boto3-sdb/) service.
- `boto3-stubs[secretsmanager]` - Type annotations for [SecretsManager](https://pypi.org/project/mypy-boto3-secretsmanager/) service.
- `boto3-stubs[securityhub]` - Type annotations for [SecurityHub](https://pypi.org/project/mypy-boto3-securityhub/) service.
- `boto3-stubs[serverlessrepo]` - Type annotations for [ServerlessApplicationRepository](https://pypi.org/project/mypy-boto3-serverlessrepo/) service.
- `boto3-stubs[service-quotas]` - Type annotations for [ServiceQuotas](https://pypi.org/project/mypy-boto3-service-quotas/) service.
- `boto3-stubs[servicecatalog]` - Type annotations for [ServiceCatalog](https://pypi.org/project/mypy-boto3-servicecatalog/) service.
- `boto3-stubs[servicecatalog-appregistry]` - Type annotations for [AppRegistry](https://pypi.org/project/mypy-boto3-servicecatalog-appregistry/) service.
- `boto3-stubs[servicediscovery]` - Type annotations for [ServiceDiscovery](https://pypi.org/project/mypy-boto3-servicediscovery/) service.
- `boto3-stubs[ses]` - Type annotations for [SES](https://pypi.org/project/mypy-boto3-ses/) service.
- `boto3-stubs[sesv2]` - Type annotations for [SESV2](https://pypi.org/project/mypy-boto3-sesv2/) service.
- `boto3-stubs[shield]` - Type annotations for [Shield](https://pypi.org/project/mypy-boto3-shield/) service.
- `boto3-stubs[signer]` - Type annotations for [Signer](https://pypi.org/project/mypy-boto3-signer/) service.
- `boto3-stubs[sms]` - Type annotations for [SMS](https://pypi.org/project/mypy-boto3-sms/) service.
- `boto3-stubs[sms-voice]` - Type annotations for [SMSVoice](https://pypi.org/project/mypy-boto3-sms-voice/) service.
- `boto3-stubs[snowball]` - Type annotations for [Snowball](https://pypi.org/project/mypy-boto3-snowball/) service.
- `boto3-stubs[sns]` - Type annotations for [SNS](https://pypi.org/project/mypy-boto3-sns/) service.
- `boto3-stubs[sqs]` - Type annotations for [SQS](https://pypi.org/project/mypy-boto3-sqs/) service.
- `boto3-stubs[ssm]` - Type annotations for [SSM](https://pypi.org/project/mypy-boto3-ssm/) service.
- `boto3-stubs[sso]` - Type annotations for [SSO](https://pypi.org/project/mypy-boto3-sso/) service.
- `boto3-stubs[sso-admin]` - Type annotations for [SSOAdmin](https://pypi.org/project/mypy-boto3-sso-admin/) service.
- `boto3-stubs[sso-oidc]` - Type annotations for [SSOOIDC](https://pypi.org/project/mypy-boto3-sso-oidc/) service.
- `boto3-stubs[stepfunctions]` - Type annotations for [SFN](https://pypi.org/project/mypy-boto3-stepfunctions/) service.
- `boto3-stubs[storagegateway]` - Type annotations for [StorageGateway](https://pypi.org/project/mypy-boto3-storagegateway/) service.
- `boto3-stubs[sts]` - Type annotations for [STS](https://pypi.org/project/mypy-boto3-sts/) service.
- `boto3-stubs[support]` - Type annotations for [Support](https://pypi.org/project/mypy-boto3-support/) service.
- `boto3-stubs[swf]` - Type annotations for [SWF](https://pypi.org/project/mypy-boto3-swf/) service.
- `boto3-stubs[synthetics]` - Type annotations for [Synthetics](https://pypi.org/project/mypy-boto3-synthetics/) service.
- `boto3-stubs[textract]` - Type annotations for [Textract](https://pypi.org/project/mypy-boto3-textract/) service.
- `boto3-stubs[timestream-query]` - Type annotations for [TimestreamQuery](https://pypi.org/project/mypy-boto3-timestream-query/) service.
- `boto3-stubs[timestream-write]` - Type annotations for [TimestreamWrite](https://pypi.org/project/mypy-boto3-timestream-write/) service.
- `boto3-stubs[transcribe]` - Type annotations for [TranscribeService](https://pypi.org/project/mypy-boto3-transcribe/) service.
- `boto3-stubs[transfer]` - Type annotations for [Transfer](https://pypi.org/project/mypy-boto3-transfer/) service.
- `boto3-stubs[translate]` - Type annotations for [Translate](https://pypi.org/project/mypy-boto3-translate/) service.
- `boto3-stubs[waf]` - Type annotations for [WAF](https://pypi.org/project/mypy-boto3-waf/) service.
- `boto3-stubs[waf-regional]` - Type annotations for [WAFRegional](https://pypi.org/project/mypy-boto3-waf-regional/) service.
- `boto3-stubs[wafv2]` - Type annotations for [WAFV2](https://pypi.org/project/mypy-boto3-wafv2/) service.
- `boto3-stubs[wellarchitected]` - Type annotations for [WellArchitected](https://pypi.org/project/mypy-boto3-wellarchitected/) service.
- `boto3-stubs[workdocs]` - Type annotations for [WorkDocs](https://pypi.org/project/mypy-boto3-workdocs/) service.
- `boto3-stubs[worklink]` - Type annotations for [WorkLink](https://pypi.org/project/mypy-boto3-worklink/) service.
- `boto3-stubs[workmail]` - Type annotations for [WorkMail](https://pypi.org/project/mypy-boto3-workmail/) service.
- `boto3-stubs[workmailmessageflow]` - Type annotations for [WorkMailMessageFlow](https://pypi.org/project/mypy-boto3-workmailmessageflow/) service.
- `boto3-stubs[workspaces]` - Type annotations for [WorkSpaces](https://pypi.org/project/mypy-boto3-workspaces/) service.
- `boto3-stubs[xray]` - Type annotations for [XRay](https://pypi.org/project/mypy-boto3-xray/) service.
