# generated by datamodel-codegen:
#   filename:  schema.json
#   timestamp: 2025-09-28T03:33:00+00:00

from __future__ import annotations

from collections.abc import Sequence
from typing import Annotated, Any, Literal

from pydantic import Field, RootModel

from acp.base import Schema


class AuthenticateRequest(Schema):
    """
    Request parameters for the authenticate method.

    Specifies which authentication method to use.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    method_id: Annotated[
        str,
        Field(
            description="The ID of the authentication method to use.\nMust be one of the methods advertised in the initialize response."
        ),
    ]


class AuthenticateResponse(Schema):
    """
    Response to authenticate method
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None


class CommandInputHint(Schema):
    """
    All text that was typed after the command name is provided as input.
    """

    hint: Annotated[
        str,
        Field(description="A hint to display when the input hasn't been provided yet"),
    ]


class AvailableCommandInput(RootModel[CommandInputHint]):
    root: Annotated[
        CommandInputHint,
        Field(description="The input specification for a command."),
    ]


class BlobResourceContents(Schema):
    """
    Binary resource contents.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    blob: str
    mime_type: str | None = None
    uri: str


class CreateTerminalResponse(Schema):
    """
    Response containing the ID of the created terminal.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    terminal_id: Annotated[
        str, Field(description="The unique identifier for the created terminal.")
    ]


class EnvVariable(Schema):
    """
    An environment variable to set when launching an MCP server.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    name: Annotated[str, Field(description="The name of the environment variable.")]
    value: Annotated[
        str, Field(description="The value to set for the environment variable.")
    ]


class FileSystemCapability(Schema):
    """
    File system capabilities that a client may support.

    See protocol docs: [FileSystem](https://agentclientprotocol.com/protocol/initialization#filesystem)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    read_text_file: Annotated[
        bool | None,
        Field(description="Whether the Client supports `fs/read_text_file` requests."),
    ] = False
    write_text_file: Annotated[
        bool | None,
        Field(description="Whether the Client supports `fs/write_text_file` requests."),
    ] = False


class HttpHeader(Schema):
    """
    An HTTP header to set when making requests to the MCP server.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    name: Annotated[str, Field(description="The name of the HTTP header.")]
    value: Annotated[str, Field(description="The value to set for the HTTP header.")]


class KillTerminalCommandResponse(Schema):
    """
    Response to terminal/kill command method
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None


class McpCapabilities(Schema):
    """
    MCP capabilities supported by the agent
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    http: Annotated[
        bool | None, Field(description="Agent supports [`McpServer::Http`].")
    ] = False
    sse: Annotated[
        bool | None, Field(description="Agent supports [`McpServer::Sse`].")
    ] = False


class HttpMcpServer(Schema):
    """
    HTTP transport configuration

    Only available when the Agent capabilities indicate `mcp_capabilities.http` is `true`.
    """

    headers: Annotated[
        Sequence[HttpHeader],
        Field(description="HTTP headers to set when making requests to the MCP server."),
    ]
    name: Annotated[
        str, Field(description="Human-readable name identifying this MCP server.")
    ]
    type: Literal["http"] = "http"
    url: Annotated[str, Field(description="URL to the MCP server.")]


class SseMcpServer(Schema):
    """
    SSE transport configuration

    Only available when the Agent capabilities indicate `mcp_capabilities.sse` is `true`.
    """

    headers: Annotated[
        Sequence[HttpHeader],
        Field(description="HTTP headers to set when making requests to the MCP server."),
    ]
    name: Annotated[
        str, Field(description="Human-readable name identifying this MCP server.")
    ]
    type: Literal["sse"] = "sse"
    url: Annotated[str, Field(description="URL to the MCP server.")]


class StdioMcpServer(Schema):
    """
    Stdio transport configuration

    All Agents MUST support this transport.
    """

    args: Annotated[
        Sequence[str],
        Field(description="Command-line arguments to pass to the MCP server."),
    ]
    command: Annotated[str, Field(description="Path to the MCP server executable.")]
    env: Annotated[
        Sequence[EnvVariable],
        Field(description="Environment variables to set when launching the MCP server."),
    ]
    name: Annotated[
        str, Field(description="Human-readable name identifying this MCP server.")
    ]


class ModelInfo(Schema):
    """
    **UNSTABLE**

    This capability is not part of the spec yet, and may be removed or changed at any point.

    Information about a selectable model.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    description: Annotated[
        str | None, Field(description="Optional description of the model.")
    ] = None
    model_id: Annotated[str, Field(description="Unique identifier for the model.")]
    name: Annotated[str, Field(description="Human-readable name of the model.")]


class NewSessionRequest(Schema):
    """
    Request parameters for creating a new session.

    See protocol docs: [Creating a Session](https://agentclientprotocol.com/protocol/session-setup#creating-a-session)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    cwd: Annotated[
        str,
        Field(
            description="The working directory for this session. Must be an absolute path."
        ),
    ]
    mcp_servers: Annotated[
        Sequence[HttpMcpServer | SseMcpServer | StdioMcpServer],
        Field(
            description="List of MCP (Model Context Protocol) servers the agent should connect to."
        ),
    ]


class PromptCapabilities(Schema):
    """
    Prompt capabilities supported by the agent in `session/prompt` requests.

    Baseline agent functionality requires support for [`ContentBlock::Text`]
    and [`ContentBlock::ResourceLink`] in prompt requests.

    Other variants must be explicitly opted in to.
    Capabilities for different types of content in prompt requests.

    Indicates which content types beyond the baseline (text and resource links)
    the agent can process.

    See protocol docs: [Prompt Capabilities](https://agentclientprotocol.com/protocol/initialization#prompt-capabilities)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    audio: Annotated[
        bool | None, Field(description="Agent supports [`ContentBlock::Audio`].")
    ] = False
    embedded_context: Annotated[
        bool | None,
        Field(
            description="Agent supports embedded context in `session/prompt` requests.\n\nWhen enabled, the Client is allowed to include [`ContentBlock::Resource`]\nin prompt requests for pieces of context that are referenced in the message."
        ),
    ] = False
    image: Annotated[
        bool | None, Field(description="Agent supports [`ContentBlock::Image`].")
    ] = False


class ReadTextFileResponse(Schema):
    """
    Response containing the contents of a text file.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    content: str


class ReleaseTerminalResponse(Schema):
    """
    Response to terminal/release method
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None


class DeniedOutcome(Schema):
    """
    The prompt turn was cancelled before the user responded.

    When a client sends a `session/cancel` notification to cancel an ongoing
    prompt turn, it MUST respond to all pending `session/request_permission`
    requests with this `Cancelled` outcome.

    See protocol docs: [Cancellation](https://agentclientprotocol.com/protocol/prompt-turn#cancellation)
    """

    outcome: Literal["cancelled"] = "cancelled"


class AllowedOutcome(Schema):
    """
    The user selected one of the provided options.
    """

    option_id: Annotated[
        str, Field(description="The ID of the option the user selected.")
    ]
    outcome: Literal["selected"] = "selected"


class RequestPermissionResponse(Schema):
    """
    Response to a permission request.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    outcome: Annotated[
        DeniedOutcome | AllowedOutcome,
        Field(description="The user's decision on the permission request."),
    ]


class SessionModelState(Schema):
    """
    **UNSTABLE**

    This capability is not part of the spec yet, and may be removed or changed at any point.

    The set of models and the one currently active.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    available_models: Annotated[
        Sequence[ModelInfo],
        Field(description="The set of models that the Agent can use"),
    ]
    current_model_id: Annotated[
        str, Field(description="The current model the Agent is in.")
    ]


class CurrentModeUpdate(Schema):
    """
    The current mode of the session has changed

    See protocol docs: [Session Modes](https://agentclientprotocol.com/protocol/session-modes)
    """

    current_mode_id: Annotated[
        str, Field(description="Unique identifier for a Session Mode.")
    ]
    session_update: Literal["current_mode_update"] = "current_mode_update"


class SetSessionModeRequest(Schema):
    """
    Request parameters for setting a session mode.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    mode_id: Annotated[str, Field(description="The ID of the mode to set.")]
    session_id: Annotated[
        str, Field(description="The ID of the session to set the mode for.")
    ]


class SetSessionModeResponse(Schema):
    """
    Response to `session/set_mode` method.
    """

    meta: Any | None = None


class SetSessionModelRequest(Schema):
    """
    **UNSTABLE**

    This capability is not part of the spec yet, and may be removed or changed at any point.

    Request parameters for setting a session model.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    model_id: Annotated[str, Field(description="The ID of the model to set.")]
    session_id: Annotated[
        str, Field(description="The ID of the session to set the model for.")
    ]


class SetSessionModelResponse(Schema):
    """
    **UNSTABLE**

    This capability is not part of the spec yet, and may be removed or changed at any point.

    Response to `session/set_model` method.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None


class TerminalExitStatus(Schema):
    """
    Exit status of a terminal command.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    exit_code: Annotated[
        int | None,
        Field(
            description="The process exit code (may be null if terminated by signal).",
            ge=0,
        ),
    ] = None
    signal: Annotated[
        str | None,
        Field(
            description="The signal that terminated the process (may be null if exited normally)."
        ),
    ] = None


class TerminalOutputRequest(Schema):
    """
    Request to get the current output and status of a terminal.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    session_id: Annotated[str, Field(description="The session ID for this request.")]
    terminal_id: Annotated[
        str, Field(description="The ID of the terminal to get output from.")
    ]


class TerminalOutputResponse(Schema):
    """
    Response containing the terminal output and exit status.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    exit_status: Annotated[
        TerminalExitStatus | None,
        Field(description="Exit status if the command has completed."),
    ] = None
    output: Annotated[str, Field(description="The terminal output captured so far.")]
    truncated: Annotated[
        bool, Field(description="Whether the output was truncated due to byte limits.")
    ]


class TextResourceContents(Schema):
    """
    Text-based resource contents.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    mime_type: str | None = None
    text: str
    uri: str


class FileEditToolCallContent(Schema):
    """
    File modification shown as a diff.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    new_text: Annotated[str, Field(description="The new content after modification.")]
    old_text: Annotated[
        str | None, Field(description="The original content (None for new files).")
    ] = None
    path: Annotated[str, Field(description="The file path being modified.")]
    type: Literal["diff"] = "diff"


class TerminalToolCallContent(Schema):
    """
    Embed a terminal created with `terminal/create` by its id.

    The terminal must be added before calling `terminal/release`.

    See protocol docs: [Terminal](https://agentclientprotocol.com/protocol/terminal)
    """

    terminal_id: str
    type: Literal["terminal"] = "terminal"


class ToolCallLocation(Schema):
    """
    A file location being accessed or modified by a tool.

    Enables clients to implement "follow-along" features that track
    which files the agent is working with in real-time.

    See protocol docs: [Following the Agent](https://agentclientprotocol.com/protocol/tool-calls#following-the-agent)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    line: Annotated[
        int | None, Field(description="Optional line number within the file.", ge=0)
    ] = None
    path: Annotated[str, Field(description="The file path being accessed or modified.")]


class WaitForTerminalExitRequest(Schema):
    """
    Request to wait for a terminal command to exit.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    session_id: Annotated[str, Field(description="The session ID for this request.")]
    terminal_id: Annotated[str, Field(description="The ID of the terminal to wait for.")]


class WaitForTerminalExitResponse(Schema):
    """
    Response containing the exit status of a terminal command.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    exit_code: Annotated[
        int | None,
        Field(
            description="The process exit code (may be null if terminated by signal).",
            ge=0,
        ),
    ] = None
    signal: Annotated[
        str | None,
        Field(
            description="The signal that terminated the process (may be null if exited normally)."
        ),
    ] = None


class WriteTextFileRequest(Schema):
    """
    Request to write content to a text file.

    Only available if the client supports the `fs.writeTextFile` capability.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    content: Annotated[str, Field(description="The text content to write to the file.")]
    path: Annotated[str, Field(description="Absolute path to the file to write.")]
    session_id: Annotated[str, Field(description="The session ID for this request.")]


class WriteTextFileResponse(Schema):
    """
    Response to `fs/write_text_file`
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None


class AgentCapabilities(Schema):
    """
    Capabilities supported by the agent.

    Advertised during initialization to inform the client about
    available features and content types.

    See protocol docs: [Agent Capabilities](https://agentclientprotocol.com/protocol/initialization#agent-capabilities)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    load_session: Annotated[
        bool | None, Field(description="Whether the agent supports `session/load`.")
    ] = False
    mcp_capabilities: Annotated[
        McpCapabilities | None,
        Field(description="MCP capabilities supported by the agent."),
    ] = {"http": False, "sse": False}
    prompt_capabilities: Annotated[
        PromptCapabilities | None,
        Field(description="Prompt capabilities supported by the agent."),
    ] = {"audio": False, "embeddedContext": False, "image": False}


class Annotations(Schema):
    """
    Optional annotations for the client. The client can use annotations to inform how objects are used or displayed
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    audience: Sequence[Literal["assistant", "user"]] | None = None
    last_modified: str | None = None
    priority: float | None = None


class AudioContent(Schema):
    """
    Audio provided to or from an LLM.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    annotations: Annotations | None = None
    data: str
    mime_type: str


class AuthMethod(Schema):
    """
    Describes an available authentication method.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    description: Annotated[
        str | None,
        Field(
            description="Optional description providing more details about this authentication method."
        ),
    ] = None
    id: Annotated[
        str, Field(description="Unique identifier for this authentication method.")
    ]
    name: Annotated[
        str, Field(description="Human-readable name of the authentication method.")
    ]


class AvailableCommand(Schema):
    """
    Information about a command.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    description: Annotated[
        str, Field(description="Human-readable description of what the command does.")
    ]
    input: Annotated[
        AvailableCommandInput | None,
        Field(description="Input for the command if required"),
    ] = None
    name: Annotated[
        str,
        Field(description="Command name (e.g., `create_plan`, `research_codebase`)."),
    ]


class CancelNotification(Schema):
    """
    Notification to cancel ongoing operations for a session.

    See protocol docs: [Cancellation](https://agentclientprotocol.com/protocol/prompt-turn#cancellation)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    session_id: Annotated[
        str, Field(description="The ID of the session to cancel operations for.")
    ]


class ClientCapabilities(Schema):
    """
    Capabilities supported by the client.

    Advertised during initialization to inform the agent about
    available features and methods.

    See protocol docs: [Client Capabilities](https://agentclientprotocol.com/protocol/initialization#client-capabilities)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    fs: Annotated[
        FileSystemCapability | None,
        Field(
            description="File system capabilities supported by the client.\nDetermines which file operations the agent can request."
        ),
    ] = {"readTextFile": False, "writeTextFile": False}
    terminal: Annotated[
        bool | None,
        Field(description="Whether the Client support all `terminal/*` methods."),
    ] = False


class TextContentBlock(Schema):
    """
    Plain text content

    All agents MUST support text content blocks in prompts.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    annotations: Annotations | None = None
    text: str
    type: Literal["text"] = "text"


class ImageContentBlock(Schema):
    """
    Images for visual context or analysis.

    Requires the `image` prompt capability when included in prompts.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    annotations: Annotations | None = None
    data: str
    mime_type: str
    type: Literal["image"] = "image"
    uri: str | None = None


class AudioContentBlock(Schema):
    """
    Audio data for transcription or analysis.

    Requires the `audio` prompt capability when included in prompts.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    annotations: Annotations | None = None
    data: str
    mime_type: str
    type: Literal["audio"] = "audio"


class ResourceContentBlock(Schema):
    """
    References to resources that the agent can access.

    All agents MUST support resource links in prompts.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    annotations: Annotations | None = None
    description: str | None = None
    mime_type: str | None = None
    name: str
    size: int | None = None
    title: str | None = None
    type: Literal["resource_link"] = "resource_link"
    uri: str


class CreateTerminalRequest(Schema):
    """
    Request to create a new terminal and execute a command.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    args: Annotated[
        Sequence[str] | None, Field(description="Array of command arguments.")
    ] = None
    command: Annotated[str, Field(description="The command to execute.")]
    cwd: Annotated[
        str | None,
        Field(description="Working directory for the command (absolute path)."),
    ] = None
    env: Annotated[
        Sequence[EnvVariable] | None,
        Field(description="Environment variables for the command."),
    ] = None
    output_byte_limit: Annotated[
        int | None,
        Field(
            description="Maximum number of output bytes to retain.\n\nWhen the limit is exceeded, the Client truncates from the beginning of the output\nto stay within the limit.\n\nThe Client MUST ensure truncation happens at a character boundary to maintain valid\nstring output, even if this means the retained output is slightly less than the\nspecified limit.",
            ge=0,
        ),
    ] = None
    session_id: Annotated[str, Field(description="The session ID for this request.")]


class ImageContent(Schema):
    """
    An image provided to or from an LLM.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    annotations: Annotations | None = None
    data: str
    mime_type: str
    uri: str | None = None


class InitializeRequest(Schema):
    """
    Request parameters for the initialize method.

    Sent by the client to establish connection and negotiate capabilities.

    See protocol docs: [Initialization](https://agentclientprotocol.com/protocol/initialization)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    client_capabilities: Annotated[
        ClientCapabilities | None,
        Field(description="Capabilities supported by the client."),
    ] = {"fs": {"readTextFile": False, "writeTextFile": False}, "terminal": False}
    protocol_version: Annotated[
        int,
        Field(
            description="The latest protocol version supported by the client.",
            ge=0,
            le=65535,
        ),
    ]


class InitializeResponse(Schema):
    """
    Response from the initialize method.

    Contains the negotiated protocol version and agent capabilities.

    See protocol docs: [Initialization](https://agentclientprotocol.com/protocol/initialization)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    agent_capabilities: Annotated[
        AgentCapabilities | None,
        Field(description="Capabilities supported by the agent."),
    ] = {
        "loadSession": False,
        "mcpCapabilities": {"http": False, "sse": False},
        "promptCapabilities": {
            "audio": False,
            "embeddedContext": False,
            "image": False,
        },
    }
    auth_methods: Annotated[
        Sequence[AuthMethod] | None,
        Field(description="Authentication methods supported by the agent."),
    ] = []
    protocol_version: Annotated[
        int,
        Field(
            description="The protocol version the client specified if supported by the agent,\nor the latest protocol version supported by the agent.\n\nThe client should disconnect, if it doesn't support this version.",
            ge=0,
            le=65535,
        ),
    ]


class KillTerminalCommandRequest(Schema):
    """
    Request to kill a terminal command without releasing the terminal.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    session_id: Annotated[str, Field(description="The session ID for this request.")]
    terminal_id: Annotated[str, Field(description="The ID of the terminal to kill.")]


class LoadSessionRequest(Schema):
    """
    Request parameters for loading an existing session.

    Only available if the Agent supports the `loadSession` capability.

    See protocol docs: [Loading Sessions](https://agentclientprotocol.com/protocol/session-setup#loading-sessions)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    cwd: Annotated[str, Field(description="The working directory for this session.")]
    mcp_servers: Annotated[
        Sequence[HttpMcpServer | SseMcpServer | StdioMcpServer],
        Field(description="List of MCP servers to connect to for this session."),
    ]
    session_id: Annotated[str, Field(description="The ID of the session to load.")]


class PermissionOption(Schema):
    """
    An option presented to the user when requesting permission.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    kind: Annotated[
        Literal["allow_once", "allow_always", "reject_once", "reject_always"],
        Field(description="Hint about the nature of this permission option."),
    ]
    name: Annotated[
        str, Field(description="Human-readable label to display to the user.")
    ]
    option_id: Annotated[
        str, Field(description="Unique identifier for this permission option.")
    ]


class PlanEntry(Schema):
    """
    A single entry in the execution plan.

    Represents a task or goal that the assistant intends to accomplish
    as part of fulfilling the user's request.
    See protocol docs: [Plan Entries](https://agentclientprotocol.com/protocol/agent-plan#plan-entries)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    content: Annotated[
        str,
        Field(
            description="Human-readable description of what this task aims to accomplish."
        ),
    ]
    priority: Annotated[
        Literal["high", "medium", "low"],
        Field(
            description="The relative importance of this task.\nUsed to indicate which tasks are most critical to the overall goal."
        ),
    ]
    status: Annotated[
        Literal["pending", "in_progress", "completed"],
        Field(description="Current execution status of this task."),
    ]


class PromptResponse(Schema):
    """
    Response from processing a user prompt.

    See protocol docs: [Check for Completion](https://agentclientprotocol.com/protocol/prompt-turn#4-check-for-completion)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    stop_reason: Annotated[
        Literal["end_turn", "max_tokens", "max_turn_requests", "refusal", "cancelled"],
        Field(description="Indicates why the agent stopped processing the turn."),
    ]


class ReadTextFileRequest(Schema):
    """
    Request to read content from a text file.

    Only available if the client supports the `fs.readTextFile` capability.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    limit: Annotated[
        int | None, Field(description="Maximum number of lines to read.", ge=0)
    ] = None
    line: Annotated[
        int | None,
        Field(description="Line number to start reading from (1-based).", ge=0),
    ] = None
    path: Annotated[str, Field(description="Absolute path to the file to read.")]
    session_id: Annotated[str, Field(description="The session ID for this request.")]


class ReleaseTerminalRequest(Schema):
    """
    Request to release a terminal and free its resources.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    session_id: Annotated[str, Field(description="The session ID for this request.")]
    terminal_id: Annotated[str, Field(description="The ID of the terminal to release.")]


class ResourceLink(Schema):
    """
    A resource that the server is capable of reading, included in a prompt or tool call result.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    annotations: Annotations | None = None
    description: str | None = None
    mime_type: str | None = None
    name: str
    size: int | None = None
    title: str | None = None
    uri: str


class SessionMode(Schema):
    """
    A mode the agent can operate in.

    See protocol docs: [Session Modes](https://agentclientprotocol.com/protocol/session-modes)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    description: str | None = None
    id: Annotated[str, Field(description="Unique identifier for a Session Mode.")]
    name: str


class SessionModeState(Schema):
    """
    The set of modes and the one currently active.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    available_modes: Annotated[
        Sequence[SessionMode],
        Field(description="The set of modes that the Agent can operate in"),
    ]
    current_mode_id: Annotated[
        str, Field(description="The current mode the Agent is in.")
    ]


class AgentPlan(Schema):
    """
    The agent's execution plan for complex tasks.
    See protocol docs: [Agent Plan](https://agentclientprotocol.com/protocol/agent-plan)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    entries: Annotated[
        Sequence[PlanEntry],
        Field(
            description="The list of tasks to be accomplished.\n\nWhen updating a plan, the agent must send a complete list of all entries\nwith their current status. The client replaces the entire plan with each update."
        ),
    ]
    session_update: Literal["plan"] = "plan"


class AvailableCommandsUpdate(Schema):
    """
    Available commands are ready or have changed
    """

    available_commands: Sequence[AvailableCommand]
    session_update: Literal["available_commands_update"] = "available_commands_update"


class TextContent(Schema):
    """
    Text provided to or from an LLM.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    annotations: Annotations | None = None
    text: str


class EmbeddedResourceContentBlock(Schema):
    """
    Complete resource contents embedded directly in the message.

    Preferred for including context as it avoids extra round-trips.

    Requires the `embeddedContext` prompt capability when included in prompts.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    annotations: Annotations | None = None
    resource: Annotated[
        TextResourceContents | BlobResourceContents,
        Field(description="Resource content that can be embedded in a message."),
    ]
    type: Literal["resource"] = "resource"


class EmbeddedResource(Schema):
    """
    The contents of a resource, embedded into a prompt or tool call result.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    annotations: Annotations | None = None
    resource: Annotated[
        TextResourceContents | BlobResourceContents,
        Field(description="Resource content that can be embedded in a message."),
    ]


class LoadSessionResponse(Schema):
    """
    Response from loading an existing session.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    models: Annotated[
        SessionModelState | None,
        Field(
            description="**UNSTABLE**\n\nThis capability is not part of the spec yet, and may be removed or changed at any point.\n\nInitial model state if supported by the Agent"
        ),
    ] = None
    modes: Annotated[
        SessionModeState | None,
        Field(
            description="Initial mode state if supported by the Agent\n\nSee protocol docs: [Session Modes](https://agentclientprotocol.com/protocol/session-modes)"
        ),
    ] = None


class NewSessionResponse(Schema):
    """
    Response from creating a new session.

    See protocol docs: [Creating a Session](https://agentclientprotocol.com/protocol/session-setup#creating-a-session)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    models: Annotated[
        SessionModelState | None,
        Field(
            description="**UNSTABLE**\n\nThis capability is not part of the spec yet, and may be removed or changed at any point.\n\nInitial model state if supported by the Agent"
        ),
    ] = None
    modes: Annotated[
        SessionModeState | None,
        Field(
            description="Initial mode state if supported by the Agent\n\nSee protocol docs: [Session Modes](https://agentclientprotocol.com/protocol/session-modes)"
        ),
    ] = None
    session_id: Annotated[
        str,
        Field(
            description="Unique identifier for the created session.\n\nUsed in all subsequent requests for this conversation."
        ),
    ]


class Plan(Schema):
    """
    An execution plan for accomplishing complex tasks.

    Plans consist of multiple entries representing individual tasks or goals.
    Agents report plans to clients to provide visibility into their execution strategy.
    Plans can evolve during execution as the agent discovers new requirements or completes tasks.

    See protocol docs: [Agent Plan](https://agentclientprotocol.com/protocol/agent-plan)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    entries: Annotated[
        Sequence[PlanEntry],
        Field(
            description="The list of tasks to be accomplished.\n\nWhen updating a plan, the agent must send a complete list of all entries\nwith their current status. The client replaces the entire plan with each update."
        ),
    ]


class PromptRequest(Schema):
    """
    Request parameters for sending a user prompt to the agent.

    Contains the user's message and any additional context.

    See protocol docs: [User Message](https://agentclientprotocol.com/protocol/prompt-turn#1-user-message)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    prompt: Annotated[
        Sequence[
            TextContentBlock
            | ImageContentBlock
            | AudioContentBlock
            | ResourceContentBlock
            | EmbeddedResourceContentBlock
        ],
        Field(
            description="The blocks of content that compose the user's message.\n\nAs a baseline, the Agent MUST support [`ContentBlock::Text`] and [`ContentBlock::ResourceLink`],\nwhile other variants are optionally enabled via [`PromptCapabilities`].\n\nThe Client MUST adapt its interface according to [`PromptCapabilities`].\n\nThe client MAY include referenced pieces of context as either\n[`ContentBlock::Resource`] or [`ContentBlock::ResourceLink`].\n\nWhen available, [`ContentBlock::Resource`] is preferred\nas it avoids extra round-trips and allows the message to include\npieces of context from sources the agent may not have access to."
        ),
    ]
    session_id: Annotated[
        str, Field(description="The ID of the session to send this user message to")
    ]


class UserMessageChunk(Schema):
    """
    A chunk of the user's message being streamed.
    """

    content: Annotated[
        TextContentBlock
        | ImageContentBlock
        | AudioContentBlock
        | ResourceContentBlock
        | EmbeddedResourceContentBlock,
        Field(
            description="Content blocks represent displayable information in the Agent Client Protocol.\n\nThey provide a structured way to handle various types of user-facing content—whether\nit's text from language models, images for analysis, or embedded resources for context.\n\nContent blocks appear in:\n- User prompts sent via `session/prompt`\n- Language model output streamed through `session/update` notifications\n- Progress updates and results from tool calls\n\nThis structure is compatible with the Model Context Protocol (MCP), enabling\nagents to seamlessly forward content from MCP tool outputs without transformation.\n\nSee protocol docs: [Content](https://agentclientprotocol.com/protocol/content)"
        ),
    ]
    session_update: Literal["user_message_chunk"] = "user_message_chunk"


class AgentMessageChunk(Schema):
    """
    A chunk of the agent's response being streamed.
    """

    content: Annotated[
        TextContentBlock
        | ImageContentBlock
        | AudioContentBlock
        | ResourceContentBlock
        | EmbeddedResourceContentBlock,
        Field(
            description="Content blocks represent displayable information in the Agent Client Protocol.\n\nThey provide a structured way to handle various types of user-facing content—whether\nit's text from language models, images for analysis, or embedded resources for context.\n\nContent blocks appear in:\n- User prompts sent via `session/prompt`\n- Language model output streamed through `session/update` notifications\n- Progress updates and results from tool calls\n\nThis structure is compatible with the Model Context Protocol (MCP), enabling\nagents to seamlessly forward content from MCP tool outputs without transformation.\n\nSee protocol docs: [Content](https://agentclientprotocol.com/protocol/content)"
        ),
    ]
    session_update: Literal["agent_message_chunk"] = "agent_message_chunk"


class AgentThoughtChunk(Schema):
    """
    A chunk of the agent's internal reasoning being streamed.
    """

    content: Annotated[
        TextContentBlock
        | ImageContentBlock
        | AudioContentBlock
        | ResourceContentBlock
        | EmbeddedResourceContentBlock,
        Field(
            description="Content blocks represent displayable information in the Agent Client Protocol.\n\nThey provide a structured way to handle various types of user-facing content—whether\nit's text from language models, images for analysis, or embedded resources for context.\n\nContent blocks appear in:\n- User prompts sent via `session/prompt`\n- Language model output streamed through `session/update` notifications\n- Progress updates and results from tool calls\n\nThis structure is compatible with the Model Context Protocol (MCP), enabling\nagents to seamlessly forward content from MCP tool outputs without transformation.\n\nSee protocol docs: [Content](https://agentclientprotocol.com/protocol/content)"
        ),
    ]
    session_update: Literal["agent_thought_chunk"] = "agent_thought_chunk"


class ContentToolCallContent(Schema):
    """
    Standard content block (text, images, resources).
    """

    content: Annotated[
        TextContentBlock
        | ImageContentBlock
        | AudioContentBlock
        | ResourceContentBlock
        | EmbeddedResourceContentBlock,
        Field(description="The actual content block."),
    ]
    type: Literal["content"] = "content"


class ToolCallUpdate(Schema):
    """
    An update to an existing tool call.

    Used to report progress and results as tools execute. All fields except
    the tool call ID are optional - only changed fields need to be included.

    See protocol docs: [Updating](https://agentclientprotocol.com/protocol/tool-calls#updating)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    content: Annotated[
        Sequence[
            ContentToolCallContent | FileEditToolCallContent | TerminalToolCallContent
        ]
        | None,
        Field(description="Replace the content collection."),
    ] = None
    kind: Annotated[
        Literal[
            "read",
            "edit",
            "delete",
            "move",
            "search",
            "execute",
            "think",
            "fetch",
            "switch_mode",
            "other",
        ]
        | None,
        Field(description="Update the tool kind."),
    ] = None
    locations: Annotated[
        Sequence[ToolCallLocation] | None,
        Field(description="Replace the locations collection."),
    ] = None
    raw_input: Annotated[Any | None, Field(description="Update the raw input.")] = None
    raw_output: Annotated[Any | None, Field(description="Update the raw output.")] = None
    status: Annotated[
        Literal["pending", "in_progress", "completed", "failed"] | None,
        Field(description="Update the execution status."),
    ] = None
    title: Annotated[
        str | None, Field(description="Update the human-readable title.")
    ] = None
    tool_call_id: Annotated[
        str, Field(description="The ID of the tool call being updated.")
    ]


class RequestPermissionRequest(Schema):
    """
    Request for user permission to execute a tool call.

    Sent when the agent needs authorization before performing a sensitive operation.

    See protocol docs: [Requesting Permission](https://agentclientprotocol.com/protocol/tool-calls#requesting-permission)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    options: Annotated[
        Sequence[PermissionOption],
        Field(description="Available permission options for the user to choose from."),
    ]
    session_id: Annotated[str, Field(description="The session ID for this request.")]
    tool_call: Annotated[
        ToolCallUpdate,
        Field(description="Details about the tool call requiring permission."),
    ]


class ToolCallStart(Schema):
    """
    Notification that a new tool call has been initiated.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    content: Annotated[
        Sequence[
            ContentToolCallContent | FileEditToolCallContent | TerminalToolCallContent
        ]
        | None,
        Field(description="Content produced by the tool call."),
    ] = None
    kind: Annotated[
        Literal[
            "read",
            "edit",
            "delete",
            "move",
            "search",
            "execute",
            "think",
            "fetch",
            "switch_mode",
            "other",
        ]
        | None,
        Field(
            description="The category of tool being invoked.\nHelps clients choose appropriate icons and UI treatment."
        ),
    ] = None
    locations: Annotated[
        Sequence[ToolCallLocation] | None,
        Field(
            description='File locations affected by this tool call.\nEnables "follow-along" features in clients.'
        ),
    ] = None
    raw_input: Annotated[
        Any | None, Field(description="Raw input parameters sent to the tool.")
    ] = None
    raw_output: Annotated[
        Any | None, Field(description="Raw output returned by the tool.")
    ] = None
    session_update: Literal["tool_call"] = "tool_call"
    status: Annotated[
        Literal["pending", "in_progress", "completed", "failed"] | None,
        Field(description="Current execution status of the tool call."),
    ] = None
    title: Annotated[
        str,
        Field(description="Human-readable title describing what the tool is doing."),
    ]
    tool_call_id: Annotated[
        str,
        Field(description="Unique identifier for this tool call within the session."),
    ]


class ToolCallProgress(Schema):
    """
    Update on the status or results of a tool call.
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    content: Annotated[
        Sequence[
            ContentToolCallContent | FileEditToolCallContent | TerminalToolCallContent
        ]
        | None,
        Field(description="Replace the content collection."),
    ] = None
    kind: Annotated[
        Literal[
            "read",
            "edit",
            "delete",
            "move",
            "search",
            "execute",
            "think",
            "fetch",
            "switch_mode",
            "other",
        ]
        | None,
        Field(description="Update the tool kind."),
    ] = None
    locations: Annotated[
        Sequence[ToolCallLocation] | None,
        Field(description="Replace the locations collection."),
    ] = None
    raw_input: Annotated[Any | None, Field(description="Update the raw input.")] = None
    raw_output: Annotated[Any | None, Field(description="Update the raw output.")] = None
    session_update: Literal["tool_call_update"] = "tool_call_update"
    status: Annotated[
        Literal["pending", "in_progress", "completed", "failed"] | None,
        Field(description="Update the execution status."),
    ] = None
    title: Annotated[
        str | None, Field(description="Update the human-readable title.")
    ] = None
    tool_call_id: Annotated[
        str, Field(description="The ID of the tool call being updated.")
    ]


class ToolCall(Schema):
    """
    Represents a tool call that the language model has requested.

    Tool calls are actions that the agent executes on behalf of the language model,
    such as reading files, executing code, or fetching data from external sources.

    See protocol docs: [Tool Calls](https://agentclientprotocol.com/protocol/tool-calls)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    content: Annotated[
        Sequence[
            ContentToolCallContent | FileEditToolCallContent | TerminalToolCallContent
        ]
        | None,
        Field(description="Content produced by the tool call."),
    ] = None
    kind: Annotated[
        Literal[
            "read",
            "edit",
            "delete",
            "move",
            "search",
            "execute",
            "think",
            "fetch",
            "switch_mode",
            "other",
        ]
        | None,
        Field(
            description="The category of tool being invoked.\nHelps clients choose appropriate icons and UI treatment."
        ),
    ] = None
    locations: Annotated[
        Sequence[ToolCallLocation] | None,
        Field(
            description='File locations affected by this tool call.\nEnables "follow-along" features in clients.'
        ),
    ] = None
    raw_input: Annotated[
        Any | None, Field(description="Raw input parameters sent to the tool.")
    ] = None
    raw_output: Annotated[
        Any | None, Field(description="Raw output returned by the tool.")
    ] = None
    status: Annotated[
        Literal["pending", "in_progress", "completed", "failed"] | None,
        Field(description="Current execution status of the tool call."),
    ] = None
    title: Annotated[
        str,
        Field(description="Human-readable title describing what the tool is doing."),
    ]
    tool_call_id: Annotated[
        str,
        Field(description="Unique identifier for this tool call within the session."),
    ]


class SessionNotification(Schema):
    """
    Notification containing a session update from the agent.

    Used to stream real-time progress and results during prompt processing.

    See protocol docs: [Agent Reports Output](https://agentclientprotocol.com/protocol/prompt-turn#3-agent-reports-output)
    """

    field_meta: Annotated[
        Any | None, Field(description="Extension point for implementations")
    ] = None
    session_id: Annotated[
        str, Field(description="The ID of the session this update pertains to.")
    ]
    update: Annotated[
        UserMessageChunk
        | AgentMessageChunk
        | AgentThoughtChunk
        | ToolCallStart
        | ToolCallProgress
        | AgentPlan
        | AvailableCommandsUpdate
        | CurrentModeUpdate,
        Field(description="The actual update content."),
    ]


class Model(
    RootModel[
        WriteTextFileRequest
        | ReadTextFileRequest
        | RequestPermissionRequest
        | CreateTerminalRequest
        | TerminalOutputRequest
        | ReleaseTerminalRequest
        | WaitForTerminalExitRequest
        | KillTerminalCommandRequest
        | Any
        | WriteTextFileResponse
        | ReadTextFileResponse
        | RequestPermissionResponse
        | CreateTerminalResponse
        | TerminalOutputResponse
        | ReleaseTerminalResponse
        | WaitForTerminalExitResponse
        | KillTerminalCommandResponse
        | Any
        | CancelNotification
        | Any
        | InitializeRequest
        | AuthenticateRequest
        | NewSessionRequest
        | LoadSessionRequest
        | SetSessionModeRequest
        | PromptRequest
        | SetSessionModelRequest
        | Any
        | InitializeResponse
        | AuthenticateResponse
        | NewSessionResponse
        | LoadSessionResponse
        | SetSessionModeResponse
        | PromptResponse
        | SetSessionModelResponse
        | Any
        | SessionNotification
        | Any
    ]
):
    root: (
        WriteTextFileRequest
        | ReadTextFileRequest
        | RequestPermissionRequest
        | CreateTerminalRequest
        | TerminalOutputRequest
        | ReleaseTerminalRequest
        | WaitForTerminalExitRequest
        | KillTerminalCommandRequest
        | Any
        | WriteTextFileResponse
        | ReadTextFileResponse
        | RequestPermissionResponse
        | CreateTerminalResponse
        | TerminalOutputResponse
        | ReleaseTerminalResponse
        | WaitForTerminalExitResponse
        | KillTerminalCommandResponse
        | Any
        | CancelNotification
        | Any
        | InitializeRequest
        | AuthenticateRequest
        | NewSessionRequest
        | LoadSessionRequest
        | SetSessionModeRequest
        | PromptRequest
        | SetSessionModelRequest
        | Any
        | InitializeResponse
        | AuthenticateResponse
        | NewSessionResponse
        | LoadSessionResponse
        | SetSessionModeResponse
        | PromptResponse
        | SetSessionModelResponse
        | Any
        | SessionNotification
        | Any
    )
