# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGroupsResult',
    'AwaitableGetGroupsResult',
    'get_groups',
    'get_groups_output',
]

@pulumi.output_type
class GetGroupsResult:
    """
    A collection of values returned by getGroups.
    """
    def __init__(__self__, groups=None, id=None, order_by=None, search=None, sort=None, top_level_only=None):
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if search and not isinstance(search, str):
            raise TypeError("Expected argument 'search' to be a str")
        pulumi.set(__self__, "search", search)
        if sort and not isinstance(sort, str):
            raise TypeError("Expected argument 'sort' to be a str")
        pulumi.set(__self__, "sort", sort)
        if top_level_only and not isinstance(top_level_only, bool):
            raise TypeError("Expected argument 'top_level_only' to be a bool")
        pulumi.set(__self__, "top_level_only", top_level_only)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetGroupsGroupResult']:
        """
        The list of groups.
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        """
        Order the groups' list by `id`, `name`, `path`, or `similarity`. (Requires administrator privileges)
        """
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter
    def search(self) -> Optional[_builtins.str]:
        """
        Search groups by name or path.
        """
        return pulumi.get(self, "search")

    @_builtins.property
    @pulumi.getter
    def sort(self) -> Optional[_builtins.str]:
        """
        Sort groups' list in asc or desc order. (Requires administrator privileges)
        """
        return pulumi.get(self, "sort")

    @_builtins.property
    @pulumi.getter(name="topLevelOnly")
    def top_level_only(self) -> Optional[_builtins.bool]:
        """
        Limit to top level groups, excluding all subgroups.
        """
        return pulumi.get(self, "top_level_only")


class AwaitableGetGroupsResult(GetGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupsResult(
            groups=self.groups,
            id=self.id,
            order_by=self.order_by,
            search=self.search,
            sort=self.sort,
            top_level_only=self.top_level_only)


def get_groups(order_by: Optional[_builtins.str] = None,
               search: Optional[_builtins.str] = None,
               sort: Optional[_builtins.str] = None,
               top_level_only: Optional[_builtins.bool] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupsResult:
    """
    The `get_groups` data source allows details of multiple groups to be retrieved given some optional filter criteria.

    > Some attributes might not be returned depending on if you're an admin or not.

    > Some available options require administrator privileges.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/groups/#list-groups)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_groups(sort="desc",
        order_by="name")
    example_two = gitlab.get_groups(search="GitLab")
    ```


    :param _builtins.str order_by: Order the groups' list by `id`, `name`, `path`, or `similarity`. (Requires administrator privileges)
    :param _builtins.str search: Search groups by name or path.
    :param _builtins.str sort: Sort groups' list in asc or desc order. (Requires administrator privileges)
    :param _builtins.bool top_level_only: Limit to top level groups, excluding all subgroups.
    """
    __args__ = dict()
    __args__['orderBy'] = order_by
    __args__['search'] = search
    __args__['sort'] = sort
    __args__['topLevelOnly'] = top_level_only
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getGroups:getGroups', __args__, opts=opts, typ=GetGroupsResult).value

    return AwaitableGetGroupsResult(
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        order_by=pulumi.get(__ret__, 'order_by'),
        search=pulumi.get(__ret__, 'search'),
        sort=pulumi.get(__ret__, 'sort'),
        top_level_only=pulumi.get(__ret__, 'top_level_only'))
def get_groups_output(order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      search: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      sort: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      top_level_only: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupsResult]:
    """
    The `get_groups` data source allows details of multiple groups to be retrieved given some optional filter criteria.

    > Some attributes might not be returned depending on if you're an admin or not.

    > Some available options require administrator privileges.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/groups/#list-groups)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_groups(sort="desc",
        order_by="name")
    example_two = gitlab.get_groups(search="GitLab")
    ```


    :param _builtins.str order_by: Order the groups' list by `id`, `name`, `path`, or `similarity`. (Requires administrator privileges)
    :param _builtins.str search: Search groups by name or path.
    :param _builtins.str sort: Sort groups' list in asc or desc order. (Requires administrator privileges)
    :param _builtins.bool top_level_only: Limit to top level groups, excluding all subgroups.
    """
    __args__ = dict()
    __args__['orderBy'] = order_by
    __args__['search'] = search
    __args__['sort'] = sort
    __args__['topLevelOnly'] = top_level_only
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getGroups:getGroups', __args__, opts=opts, typ=GetGroupsResult)
    return __ret__.apply(lambda __response__: GetGroupsResult(
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        order_by=pulumi.get(__response__, 'order_by'),
        search=pulumi.get(__response__, 'search'),
        sort=pulumi.get(__response__, 'sort'),
        top_level_only=pulumi.get(__response__, 'top_level_only')))
