# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPipelineScheduleResult',
    'AwaitableGetPipelineScheduleResult',
    'get_pipeline_schedule',
    'get_pipeline_schedule_output',
]

@pulumi.output_type
class GetPipelineScheduleResult:
    """
    A collection of values returned by getPipelineSchedule.
    """
    def __init__(__self__, active=None, created_at=None, cron=None, cron_timezone=None, description=None, id=None, last_pipeline=None, next_run_at=None, owner=None, pipeline_schedule_id=None, project=None, ref=None, updated_at=None, variables=None):
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if cron and not isinstance(cron, str):
            raise TypeError("Expected argument 'cron' to be a str")
        pulumi.set(__self__, "cron", cron)
        if cron_timezone and not isinstance(cron_timezone, str):
            raise TypeError("Expected argument 'cron_timezone' to be a str")
        pulumi.set(__self__, "cron_timezone", cron_timezone)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_pipeline and not isinstance(last_pipeline, dict):
            raise TypeError("Expected argument 'last_pipeline' to be a dict")
        pulumi.set(__self__, "last_pipeline", last_pipeline)
        if next_run_at and not isinstance(next_run_at, str):
            raise TypeError("Expected argument 'next_run_at' to be a str")
        pulumi.set(__self__, "next_run_at", next_run_at)
        if owner and not isinstance(owner, dict):
            raise TypeError("Expected argument 'owner' to be a dict")
        pulumi.set(__self__, "owner", owner)
        if pipeline_schedule_id and not isinstance(pipeline_schedule_id, int):
            raise TypeError("Expected argument 'pipeline_schedule_id' to be a int")
        pulumi.set(__self__, "pipeline_schedule_id", pipeline_schedule_id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if ref and not isinstance(ref, str):
            raise TypeError("Expected argument 'ref' to be a str")
        pulumi.set(__self__, "ref", ref)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if variables and not isinstance(variables, list):
            raise TypeError("Expected argument 'variables' to be a list")
        pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter
    def active(self) -> _builtins.bool:
        """
        The activation status of pipeline schedule.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The datetime of when the schedule was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def cron(self) -> _builtins.str:
        """
        The cron (e.g. `0 1 * * *`).
        """
        return pulumi.get(self, "cron")

    @_builtins.property
    @pulumi.getter(name="cronTimezone")
    def cron_timezone(self) -> _builtins.str:
        """
        The timezone.
        """
        return pulumi.get(self, "cron_timezone")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the pipeline schedule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastPipeline")
    def last_pipeline(self) -> 'outputs.GetPipelineScheduleLastPipelineResult':
        """
        The details of the last pipeline run by the schedule.
        """
        return pulumi.get(self, "last_pipeline")

    @_builtins.property
    @pulumi.getter(name="nextRunAt")
    def next_run_at(self) -> _builtins.str:
        """
        The datetime of when the schedule will next run.
        """
        return pulumi.get(self, "next_run_at")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> 'outputs.GetPipelineScheduleOwnerResult':
        """
        The details of the pipeline schedule owner.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="pipelineScheduleId")
    def pipeline_schedule_id(self) -> _builtins.int:
        """
        The pipeline schedule id.
        """
        return pulumi.get(self, "pipeline_schedule_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name or id of the project to add the schedule to.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def ref(self) -> _builtins.str:
        """
        The branch/tag name to be triggered. This will be the full branch reference, for example: `refs/heads/main`, not `main`.
        """
        return pulumi.get(self, "ref")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The datetime of when the schedule was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.GetPipelineScheduleVariableResult']:
        """
        The list of the pipeline schedule variables.
        """
        return pulumi.get(self, "variables")


class AwaitableGetPipelineScheduleResult(GetPipelineScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineScheduleResult(
            active=self.active,
            created_at=self.created_at,
            cron=self.cron,
            cron_timezone=self.cron_timezone,
            description=self.description,
            id=self.id,
            last_pipeline=self.last_pipeline,
            next_run_at=self.next_run_at,
            owner=self.owner,
            pipeline_schedule_id=self.pipeline_schedule_id,
            project=self.project,
            ref=self.ref,
            updated_at=self.updated_at,
            variables=self.variables)


def get_pipeline_schedule(cron_timezone: Optional[_builtins.str] = None,
                          pipeline_schedule_id: Optional[_builtins.int] = None,
                          project: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineScheduleResult:
    """
    The `PipelineSchedule` data source retrieves information about a gitlab pipeline schedule for a project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/pipeline_schedules/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_pipeline_schedule(project="12345",
        pipeline_schedule_id=1)
    ```


    :param _builtins.str cron_timezone: The timezone.
    :param _builtins.int pipeline_schedule_id: The pipeline schedule id.
    :param _builtins.str project: The name or id of the project to add the schedule to.
    """
    __args__ = dict()
    __args__['cronTimezone'] = cron_timezone
    __args__['pipelineScheduleId'] = pipeline_schedule_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getPipelineSchedule:getPipelineSchedule', __args__, opts=opts, typ=GetPipelineScheduleResult).value

    return AwaitableGetPipelineScheduleResult(
        active=pulumi.get(__ret__, 'active'),
        created_at=pulumi.get(__ret__, 'created_at'),
        cron=pulumi.get(__ret__, 'cron'),
        cron_timezone=pulumi.get(__ret__, 'cron_timezone'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        last_pipeline=pulumi.get(__ret__, 'last_pipeline'),
        next_run_at=pulumi.get(__ret__, 'next_run_at'),
        owner=pulumi.get(__ret__, 'owner'),
        pipeline_schedule_id=pulumi.get(__ret__, 'pipeline_schedule_id'),
        project=pulumi.get(__ret__, 'project'),
        ref=pulumi.get(__ret__, 'ref'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        variables=pulumi.get(__ret__, 'variables'))
def get_pipeline_schedule_output(cron_timezone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 pipeline_schedule_id: Optional[pulumi.Input[_builtins.int]] = None,
                                 project: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPipelineScheduleResult]:
    """
    The `PipelineSchedule` data source retrieves information about a gitlab pipeline schedule for a project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/pipeline_schedules/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_pipeline_schedule(project="12345",
        pipeline_schedule_id=1)
    ```


    :param _builtins.str cron_timezone: The timezone.
    :param _builtins.int pipeline_schedule_id: The pipeline schedule id.
    :param _builtins.str project: The name or id of the project to add the schedule to.
    """
    __args__ = dict()
    __args__['cronTimezone'] = cron_timezone
    __args__['pipelineScheduleId'] = pipeline_schedule_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getPipelineSchedule:getPipelineSchedule', __args__, opts=opts, typ=GetPipelineScheduleResult)
    return __ret__.apply(lambda __response__: GetPipelineScheduleResult(
        active=pulumi.get(__response__, 'active'),
        created_at=pulumi.get(__response__, 'created_at'),
        cron=pulumi.get(__response__, 'cron'),
        cron_timezone=pulumi.get(__response__, 'cron_timezone'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        last_pipeline=pulumi.get(__response__, 'last_pipeline'),
        next_run_at=pulumi.get(__response__, 'next_run_at'),
        owner=pulumi.get(__response__, 'owner'),
        pipeline_schedule_id=pulumi.get(__response__, 'pipeline_schedule_id'),
        project=pulumi.get(__response__, 'project'),
        ref=pulumi.get(__response__, 'ref'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        variables=pulumi.get(__response__, 'variables')))
