# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectEnvironmentsResult',
    'AwaitableGetProjectEnvironmentsResult',
    'get_project_environments',
    'get_project_environments_output',
]

@pulumi.output_type
class GetProjectEnvironmentsResult:
    """
    A collection of values returned by getProjectEnvironments.
    """
    def __init__(__self__, environments=None, id=None, name=None, project=None, search=None, states=None):
        if environments and not isinstance(environments, list):
            raise TypeError("Expected argument 'environments' to be a list")
        pulumi.set(__self__, "environments", environments)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if search and not isinstance(search, str):
            raise TypeError("Expected argument 'search' to be a str")
        pulumi.set(__self__, "search", search)
        if states and not isinstance(states, str):
            raise TypeError("Expected argument 'states' to be a str")
        pulumi.set(__self__, "states", states)

    @_builtins.property
    @pulumi.getter
    def environments(self) -> Sequence['outputs.GetProjectEnvironmentsEnvironmentResult']:
        """
        The list of environments.
        """
        return pulumi.get(self, "environments")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Return the environment with this name. Mutually exclusive with search.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The ID or full path of the project.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def search(self) -> Optional[_builtins.str]:
        """
        Return list of environments matching the search criteria. Mutually exclusive with name. Must be at least 3 characters long.
        """
        return pulumi.get(self, "search")

    @_builtins.property
    @pulumi.getter
    def states(self) -> Optional[_builtins.str]:
        """
        List all environments that match the specified state. Valid values are `available`, `stopping`, `stopped`. Returns all environments if not set.
        """
        return pulumi.get(self, "states")


class AwaitableGetProjectEnvironmentsResult(GetProjectEnvironmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectEnvironmentsResult(
            environments=self.environments,
            id=self.id,
            name=self.name,
            project=self.project,
            search=self.search,
            states=self.states)


def get_project_environments(name: Optional[_builtins.str] = None,
                             project: Optional[_builtins.str] = None,
                             search: Optional[_builtins.str] = None,
                             states: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectEnvironmentsResult:
    """
    The `get_project_environments` data source retrieves information about all environments of the given project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/environments/#list-environments)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    this_project = gitlab.Project("this",
        name="example",
        initialize_with_readme=True)
    this = gitlab.get_project_environments_output(project=this_project.path_with_namespace)
    ```


    :param _builtins.str name: Return the environment with this name. Mutually exclusive with search.
    :param _builtins.str project: The ID or full path of the project.
    :param _builtins.str search: Return list of environments matching the search criteria. Mutually exclusive with name. Must be at least 3 characters long.
    :param _builtins.str states: List all environments that match the specified state. Valid values are `available`, `stopping`, `stopped`. Returns all environments if not set.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['search'] = search
    __args__['states'] = states
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProjectEnvironments:getProjectEnvironments', __args__, opts=opts, typ=GetProjectEnvironmentsResult).value

    return AwaitableGetProjectEnvironmentsResult(
        environments=pulumi.get(__ret__, 'environments'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        search=pulumi.get(__ret__, 'search'),
        states=pulumi.get(__ret__, 'states'))
def get_project_environments_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    project: Optional[pulumi.Input[_builtins.str]] = None,
                                    search: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    states: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectEnvironmentsResult]:
    """
    The `get_project_environments` data source retrieves information about all environments of the given project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/environments/#list-environments)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    this_project = gitlab.Project("this",
        name="example",
        initialize_with_readme=True)
    this = gitlab.get_project_environments_output(project=this_project.path_with_namespace)
    ```


    :param _builtins.str name: Return the environment with this name. Mutually exclusive with search.
    :param _builtins.str project: The ID or full path of the project.
    :param _builtins.str search: Return list of environments matching the search criteria. Mutually exclusive with name. Must be at least 3 characters long.
    :param _builtins.str states: List all environments that match the specified state. Valid values are `available`, `stopping`, `stopped`. Returns all environments if not set.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['search'] = search
    __args__['states'] = states
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getProjectEnvironments:getProjectEnvironments', __args__, opts=opts, typ=GetProjectEnvironmentsResult)
    return __ret__.apply(lambda __response__: GetProjectEnvironmentsResult(
        environments=pulumi.get(__response__, 'environments'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        search=pulumi.get(__response__, 'search'),
        states=pulumi.get(__response__, 'states')))
