# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRepositoryTreeResult',
    'AwaitableGetRepositoryTreeResult',
    'get_repository_tree',
    'get_repository_tree_output',
]

@pulumi.output_type
class GetRepositoryTreeResult:
    """
    A collection of values returned by getRepositoryTree.
    """
    def __init__(__self__, id=None, path=None, project=None, recursive=None, ref=None, trees=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if recursive and not isinstance(recursive, bool):
            raise TypeError("Expected argument 'recursive' to be a bool")
        pulumi.set(__self__, "recursive", recursive)
        if ref and not isinstance(ref, str):
            raise TypeError("Expected argument 'ref' to be a str")
        pulumi.set(__self__, "ref", ref)
        if trees and not isinstance(trees, list):
            raise TypeError("Expected argument 'trees' to be a list")
        pulumi.set(__self__, "trees", trees)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path inside repository. Used to get content of subdirectories.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The ID or full path of the project owned by the authenticated user.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def recursive(self) -> Optional[_builtins.bool]:
        """
        Boolean value used to get a recursive tree (false by default).
        """
        return pulumi.get(self, "recursive")

    @_builtins.property
    @pulumi.getter
    def ref(self) -> _builtins.str:
        """
        The name of a repository branch or tag.
        """
        return pulumi.get(self, "ref")

    @_builtins.property
    @pulumi.getter
    def trees(self) -> Sequence['outputs.GetRepositoryTreeTreeResult']:
        """
        The list of files/directories returned by the search
        """
        return pulumi.get(self, "trees")


class AwaitableGetRepositoryTreeResult(GetRepositoryTreeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryTreeResult(
            id=self.id,
            path=self.path,
            project=self.project,
            recursive=self.recursive,
            ref=self.ref,
            trees=self.trees)


def get_repository_tree(path: Optional[_builtins.str] = None,
                        project: Optional[_builtins.str] = None,
                        recursive: Optional[_builtins.bool] = None,
                        ref: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryTreeResult:
    """
    The `get_repository_tree` data source allows details of directories and files in a repository to be retrieved.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/repositories/#list-repository-tree)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    this = gitlab.get_repository_tree(project="example",
        ref="main",
        path="ExampleSubFolder",
        recursive=True)
    ```


    :param _builtins.str path: The path inside repository. Used to get content of subdirectories.
    :param _builtins.str project: The ID or full path of the project owned by the authenticated user.
    :param _builtins.bool recursive: Boolean value used to get a recursive tree (false by default).
    :param _builtins.str ref: The name of a repository branch or tag.
    """
    __args__ = dict()
    __args__['path'] = path
    __args__['project'] = project
    __args__['recursive'] = recursive
    __args__['ref'] = ref
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getRepositoryTree:getRepositoryTree', __args__, opts=opts, typ=GetRepositoryTreeResult).value

    return AwaitableGetRepositoryTreeResult(
        id=pulumi.get(__ret__, 'id'),
        path=pulumi.get(__ret__, 'path'),
        project=pulumi.get(__ret__, 'project'),
        recursive=pulumi.get(__ret__, 'recursive'),
        ref=pulumi.get(__ret__, 'ref'),
        trees=pulumi.get(__ret__, 'trees'))
def get_repository_tree_output(path: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               project: Optional[pulumi.Input[_builtins.str]] = None,
                               recursive: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               ref: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryTreeResult]:
    """
    The `get_repository_tree` data source allows details of directories and files in a repository to be retrieved.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/repositories/#list-repository-tree)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    this = gitlab.get_repository_tree(project="example",
        ref="main",
        path="ExampleSubFolder",
        recursive=True)
    ```


    :param _builtins.str path: The path inside repository. Used to get content of subdirectories.
    :param _builtins.str project: The ID or full path of the project owned by the authenticated user.
    :param _builtins.bool recursive: Boolean value used to get a recursive tree (false by default).
    :param _builtins.str ref: The name of a repository branch or tag.
    """
    __args__ = dict()
    __args__['path'] = path
    __args__['project'] = project
    __args__['recursive'] = recursive
    __args__['ref'] = ref
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getRepositoryTree:getRepositoryTree', __args__, opts=opts, typ=GetRepositoryTreeResult)
    return __ret__.apply(lambda __response__: GetRepositoryTreeResult(
        id=pulumi.get(__response__, 'id'),
        path=pulumi.get(__response__, 'path'),
        project=pulumi.get(__response__, 'project'),
        recursive=pulumi.get(__response__, 'recursive'),
        ref=pulumi.get(__response__, 'ref'),
        trees=pulumi.get(__response__, 'trees')))
