# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GroupLdapLinkArgs', 'GroupLdapLink']

@pulumi.input_type
class GroupLdapLinkArgs:
    def __init__(__self__, *,
                 group: pulumi.Input[_builtins.str],
                 group_access: pulumi.Input[_builtins.str],
                 ldap_provider: pulumi.Input[_builtins.str],
                 cn: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 member_role_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a GroupLdapLink resource.
        :param pulumi.Input[_builtins.str] group: The ID or URL-encoded path of the group
        :param pulumi.Input[_builtins.str] group_access: Minimum access level for members of the LDAP group. Valid values are: `no one`, `minimal`, `guest`, `planner`, `reporter`, `developer`, `maintainer`, `owner`
        :param pulumi.Input[_builtins.str] ldap_provider: The name of the LDAP provider as stored in the GitLab database. Note that this is NOT the value of the `label` attribute as shown in the web UI. In most cases this will be `ldapmain` but you may use the [LDAP check rake task](https://docs.gitlab.com/administration/raketasks/ldap/#check) for receiving the LDAP server name: `LDAP: ... Server: ldapmain`
        :param pulumi.Input[_builtins.str] cn: The CN of the LDAP group to link with. Required if `filter` is not provided.
        :param pulumi.Input[_builtins.str] filter: The LDAP filter for the group. Required if `cn` is not provided. Requires GitLab Premium or above.
        :param pulumi.Input[_builtins.bool] force: If true, then delete and replace an existing LDAP link if one exists. Will also remove an LDAP link if the parent group is not found.
        :param pulumi.Input[_builtins.int] member_role_id: The ID of a custom member role. Only available for Ultimate instances. When using a custom role, the `group_access` must match the base role used to create the custom role. To remove a custom role and revert to a base role, set this value to `0`.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "group_access", group_access)
        pulumi.set(__self__, "ldap_provider", ldap_provider)
        if cn is not None:
            pulumi.set(__self__, "cn", cn)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if member_role_id is not None:
            pulumi.set(__self__, "member_role_id", member_role_id)

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Input[_builtins.str]:
        """
        The ID or URL-encoded path of the group
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="groupAccess")
    def group_access(self) -> pulumi.Input[_builtins.str]:
        """
        Minimum access level for members of the LDAP group. Valid values are: `no one`, `minimal`, `guest`, `planner`, `reporter`, `developer`, `maintainer`, `owner`
        """
        return pulumi.get(self, "group_access")

    @group_access.setter
    def group_access(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_access", value)

    @_builtins.property
    @pulumi.getter(name="ldapProvider")
    def ldap_provider(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the LDAP provider as stored in the GitLab database. Note that this is NOT the value of the `label` attribute as shown in the web UI. In most cases this will be `ldapmain` but you may use the [LDAP check rake task](https://docs.gitlab.com/administration/raketasks/ldap/#check) for receiving the LDAP server name: `LDAP: ... Server: ldapmain`
        """
        return pulumi.get(self, "ldap_provider")

    @ldap_provider.setter
    def ldap_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ldap_provider", value)

    @_builtins.property
    @pulumi.getter
    def cn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CN of the LDAP group to link with. Required if `filter` is not provided.
        """
        return pulumi.get(self, "cn")

    @cn.setter
    def cn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cn", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LDAP filter for the group. Required if `cn` is not provided. Requires GitLab Premium or above.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, then delete and replace an existing LDAP link if one exists. Will also remove an LDAP link if the parent group is not found.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="memberRoleId")
    def member_role_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of a custom member role. Only available for Ultimate instances. When using a custom role, the `group_access` must match the base role used to create the custom role. To remove a custom role and revert to a base role, set this value to `0`.
        """
        return pulumi.get(self, "member_role_id")

    @member_role_id.setter
    def member_role_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "member_role_id", value)


@pulumi.input_type
class _GroupLdapLinkState:
    def __init__(__self__, *,
                 cn: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 group_access: Optional[pulumi.Input[_builtins.str]] = None,
                 ldap_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 member_role_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering GroupLdapLink resources.
        :param pulumi.Input[_builtins.str] cn: The CN of the LDAP group to link with. Required if `filter` is not provided.
        :param pulumi.Input[_builtins.str] filter: The LDAP filter for the group. Required if `cn` is not provided. Requires GitLab Premium or above.
        :param pulumi.Input[_builtins.bool] force: If true, then delete and replace an existing LDAP link if one exists. Will also remove an LDAP link if the parent group is not found.
        :param pulumi.Input[_builtins.str] group: The ID or URL-encoded path of the group
        :param pulumi.Input[_builtins.str] group_access: Minimum access level for members of the LDAP group. Valid values are: `no one`, `minimal`, `guest`, `planner`, `reporter`, `developer`, `maintainer`, `owner`
        :param pulumi.Input[_builtins.str] ldap_provider: The name of the LDAP provider as stored in the GitLab database. Note that this is NOT the value of the `label` attribute as shown in the web UI. In most cases this will be `ldapmain` but you may use the [LDAP check rake task](https://docs.gitlab.com/administration/raketasks/ldap/#check) for receiving the LDAP server name: `LDAP: ... Server: ldapmain`
        :param pulumi.Input[_builtins.int] member_role_id: The ID of a custom member role. Only available for Ultimate instances. When using a custom role, the `group_access` must match the base role used to create the custom role. To remove a custom role and revert to a base role, set this value to `0`.
        """
        if cn is not None:
            pulumi.set(__self__, "cn", cn)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if group_access is not None:
            pulumi.set(__self__, "group_access", group_access)
        if ldap_provider is not None:
            pulumi.set(__self__, "ldap_provider", ldap_provider)
        if member_role_id is not None:
            pulumi.set(__self__, "member_role_id", member_role_id)

    @_builtins.property
    @pulumi.getter
    def cn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CN of the LDAP group to link with. Required if `filter` is not provided.
        """
        return pulumi.get(self, "cn")

    @cn.setter
    def cn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cn", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LDAP filter for the group. Required if `cn` is not provided. Requires GitLab Premium or above.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, then delete and replace an existing LDAP link if one exists. Will also remove an LDAP link if the parent group is not found.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID or URL-encoded path of the group
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="groupAccess")
    def group_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum access level for members of the LDAP group. Valid values are: `no one`, `minimal`, `guest`, `planner`, `reporter`, `developer`, `maintainer`, `owner`
        """
        return pulumi.get(self, "group_access")

    @group_access.setter
    def group_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_access", value)

    @_builtins.property
    @pulumi.getter(name="ldapProvider")
    def ldap_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the LDAP provider as stored in the GitLab database. Note that this is NOT the value of the `label` attribute as shown in the web UI. In most cases this will be `ldapmain` but you may use the [LDAP check rake task](https://docs.gitlab.com/administration/raketasks/ldap/#check) for receiving the LDAP server name: `LDAP: ... Server: ldapmain`
        """
        return pulumi.get(self, "ldap_provider")

    @ldap_provider.setter
    def ldap_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ldap_provider", value)

    @_builtins.property
    @pulumi.getter(name="memberRoleId")
    def member_role_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of a custom member role. Only available for Ultimate instances. When using a custom role, the `group_access` must match the base role used to create the custom role. To remove a custom role and revert to a base role, set this value to `0`.
        """
        return pulumi.get(self, "member_role_id")

    @member_role_id.setter
    def member_role_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "member_role_id", value)


@pulumi.type_token("gitlab:index/groupLdapLink:GroupLdapLink")
class GroupLdapLink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cn: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 group_access: Optional[pulumi.Input[_builtins.str]] = None,
                 ldap_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 member_role_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        The `GroupLdapLink` resource allows to manage the lifecycle of an LDAP integration with a group.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/group_ldap_links/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        test = gitlab.GroupLdapLink("test",
            group="12345",
            cn="testuser",
            group_access="developer",
            ldap_provider="ldapmain")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_group_ldap_link`. For example:

        terraform

        import {

          to = gitlab_group_ldap_link.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab group ldap links can be imported using an id made up of `group_id:ldap_provider:cn:filter`. CN and Filter are mutually exclusive, so one will be missing.

        If using the CN for the group link, the ID will end with a blank filter (":"). e.g.,

        ```sh
        $ pulumi import gitlab:index/groupLdapLink:GroupLdapLink test "12345:ldapmain:testcn:"
        ```

        If using the Filter for the group link, the ID will have two "::" in the middle due to having a blank CN. e.g.,

        ```sh
        $ pulumi import gitlab:index/groupLdapLink:GroupLdapLink test "12345:ldapmain::testfilter"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cn: The CN of the LDAP group to link with. Required if `filter` is not provided.
        :param pulumi.Input[_builtins.str] filter: The LDAP filter for the group. Required if `cn` is not provided. Requires GitLab Premium or above.
        :param pulumi.Input[_builtins.bool] force: If true, then delete and replace an existing LDAP link if one exists. Will also remove an LDAP link if the parent group is not found.
        :param pulumi.Input[_builtins.str] group: The ID or URL-encoded path of the group
        :param pulumi.Input[_builtins.str] group_access: Minimum access level for members of the LDAP group. Valid values are: `no one`, `minimal`, `guest`, `planner`, `reporter`, `developer`, `maintainer`, `owner`
        :param pulumi.Input[_builtins.str] ldap_provider: The name of the LDAP provider as stored in the GitLab database. Note that this is NOT the value of the `label` attribute as shown in the web UI. In most cases this will be `ldapmain` but you may use the [LDAP check rake task](https://docs.gitlab.com/administration/raketasks/ldap/#check) for receiving the LDAP server name: `LDAP: ... Server: ldapmain`
        :param pulumi.Input[_builtins.int] member_role_id: The ID of a custom member role. Only available for Ultimate instances. When using a custom role, the `group_access` must match the base role used to create the custom role. To remove a custom role and revert to a base role, set this value to `0`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupLdapLinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `GroupLdapLink` resource allows to manage the lifecycle of an LDAP integration with a group.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/group_ldap_links/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        test = gitlab.GroupLdapLink("test",
            group="12345",
            cn="testuser",
            group_access="developer",
            ldap_provider="ldapmain")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_group_ldap_link`. For example:

        terraform

        import {

          to = gitlab_group_ldap_link.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab group ldap links can be imported using an id made up of `group_id:ldap_provider:cn:filter`. CN and Filter are mutually exclusive, so one will be missing.

        If using the CN for the group link, the ID will end with a blank filter (":"). e.g.,

        ```sh
        $ pulumi import gitlab:index/groupLdapLink:GroupLdapLink test "12345:ldapmain:testcn:"
        ```

        If using the Filter for the group link, the ID will have two "::" in the middle due to having a blank CN. e.g.,

        ```sh
        $ pulumi import gitlab:index/groupLdapLink:GroupLdapLink test "12345:ldapmain::testfilter"
        ```

        :param str resource_name: The name of the resource.
        :param GroupLdapLinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupLdapLinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cn: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 group_access: Optional[pulumi.Input[_builtins.str]] = None,
                 ldap_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 member_role_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupLdapLinkArgs.__new__(GroupLdapLinkArgs)

            __props__.__dict__["cn"] = cn
            __props__.__dict__["filter"] = filter
            __props__.__dict__["force"] = force
            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
            if group_access is None and not opts.urn:
                raise TypeError("Missing required property 'group_access'")
            __props__.__dict__["group_access"] = group_access
            if ldap_provider is None and not opts.urn:
                raise TypeError("Missing required property 'ldap_provider'")
            __props__.__dict__["ldap_provider"] = ldap_provider
            __props__.__dict__["member_role_id"] = member_role_id
        super(GroupLdapLink, __self__).__init__(
            'gitlab:index/groupLdapLink:GroupLdapLink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cn: Optional[pulumi.Input[_builtins.str]] = None,
            filter: Optional[pulumi.Input[_builtins.str]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            group: Optional[pulumi.Input[_builtins.str]] = None,
            group_access: Optional[pulumi.Input[_builtins.str]] = None,
            ldap_provider: Optional[pulumi.Input[_builtins.str]] = None,
            member_role_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'GroupLdapLink':
        """
        Get an existing GroupLdapLink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cn: The CN of the LDAP group to link with. Required if `filter` is not provided.
        :param pulumi.Input[_builtins.str] filter: The LDAP filter for the group. Required if `cn` is not provided. Requires GitLab Premium or above.
        :param pulumi.Input[_builtins.bool] force: If true, then delete and replace an existing LDAP link if one exists. Will also remove an LDAP link if the parent group is not found.
        :param pulumi.Input[_builtins.str] group: The ID or URL-encoded path of the group
        :param pulumi.Input[_builtins.str] group_access: Minimum access level for members of the LDAP group. Valid values are: `no one`, `minimal`, `guest`, `planner`, `reporter`, `developer`, `maintainer`, `owner`
        :param pulumi.Input[_builtins.str] ldap_provider: The name of the LDAP provider as stored in the GitLab database. Note that this is NOT the value of the `label` attribute as shown in the web UI. In most cases this will be `ldapmain` but you may use the [LDAP check rake task](https://docs.gitlab.com/administration/raketasks/ldap/#check) for receiving the LDAP server name: `LDAP: ... Server: ldapmain`
        :param pulumi.Input[_builtins.int] member_role_id: The ID of a custom member role. Only available for Ultimate instances. When using a custom role, the `group_access` must match the base role used to create the custom role. To remove a custom role and revert to a base role, set this value to `0`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupLdapLinkState.__new__(_GroupLdapLinkState)

        __props__.__dict__["cn"] = cn
        __props__.__dict__["filter"] = filter
        __props__.__dict__["force"] = force
        __props__.__dict__["group"] = group
        __props__.__dict__["group_access"] = group_access
        __props__.__dict__["ldap_provider"] = ldap_provider
        __props__.__dict__["member_role_id"] = member_role_id
        return GroupLdapLink(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cn(self) -> pulumi.Output[_builtins.str]:
        """
        The CN of the LDAP group to link with. Required if `filter` is not provided.
        """
        return pulumi.get(self, "cn")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[_builtins.str]:
        """
        The LDAP filter for the group. Required if `cn` is not provided. Requires GitLab Premium or above.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, then delete and replace an existing LDAP link if one exists. Will also remove an LDAP link if the parent group is not found.
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Output[_builtins.str]:
        """
        The ID or URL-encoded path of the group
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter(name="groupAccess")
    def group_access(self) -> pulumi.Output[_builtins.str]:
        """
        Minimum access level for members of the LDAP group. Valid values are: `no one`, `minimal`, `guest`, `planner`, `reporter`, `developer`, `maintainer`, `owner`
        """
        return pulumi.get(self, "group_access")

    @_builtins.property
    @pulumi.getter(name="ldapProvider")
    def ldap_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the LDAP provider as stored in the GitLab database. Note that this is NOT the value of the `label` attribute as shown in the web UI. In most cases this will be `ldapmain` but you may use the [LDAP check rake task](https://docs.gitlab.com/administration/raketasks/ldap/#check) for receiving the LDAP server name: `LDAP: ... Server: ldapmain`
        """
        return pulumi.get(self, "ldap_provider")

    @_builtins.property
    @pulumi.getter(name="memberRoleId")
    def member_role_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of a custom member role. Only available for Ultimate instances. When using a custom role, the `group_access` must match the base role used to create the custom role. To remove a custom role and revert to a base role, set this value to `0`.
        """
        return pulumi.get(self, "member_role_id")

