# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceServiceAccountArgs', 'InstanceServiceAccount']

@pulumi.input_type
class InstanceServiceAccountArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['InstanceServiceAccountTimeoutsArgs']] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceServiceAccount resource.
        :param pulumi.Input[_builtins.str] email: The email of the user account. If not set, generates a no-reply email address.
        :param pulumi.Input[_builtins.str] name: The name of the user. If not set, uses Service account user.
        :param pulumi.Input[_builtins.str] username: The username of the user account. If not set, generates a name prepended with service*account*.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the user account. If not set, generates a no-reply email address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user. If not set, uses Service account user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['InstanceServiceAccountTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['InstanceServiceAccountTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the user account. If not set, generates a name prepended with service*account*.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _InstanceServiceAccountState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['InstanceServiceAccountTimeoutsArgs']] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceServiceAccount resources.
        :param pulumi.Input[_builtins.str] email: The email of the user account. If not set, generates a no-reply email address.
        :param pulumi.Input[_builtins.str] name: The name of the user. If not set, uses Service account user.
        :param pulumi.Input[_builtins.str] service_account_id: The service account id.
        :param pulumi.Input[_builtins.str] username: The username of the user account. If not set, generates a name prepended with service*account*.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the user account. If not set, generates a no-reply email address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user. If not set, uses Service account user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account id.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['InstanceServiceAccountTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['InstanceServiceAccountTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the user account. If not set, generates a name prepended with service*account*.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("gitlab:index/instanceServiceAccount:InstanceServiceAccount")
class InstanceServiceAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['InstanceServiceAccountTimeoutsArgs', 'InstanceServiceAccountTimeoutsArgsDict']]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `InstanceServiceAccount` resource allows creating a GitLab instance service account.

        > In order for a user to create a user account, they must have admin privileges at the instance level. This makes this feature unavailable on `gitlab.com`

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/user_service_accounts/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        # create a service account
        example_sa = gitlab.InstanceServiceAccount("example_sa",
            name="example-name",
            username="example-username",
            email="custom_email@gitlab.example.com",
            timeouts={
                "delete": "3m",
            })
        example_token = gitlab.PersonalAccessToken("example_token",
            user_id=example_sa.service_account_id,
            name="Example personal access token for a service account",
            expires_at="2026-01-01",
            scopes=["api"])
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_instance_service_account`. For example:

        terraform

        import {

          to = gitlab_instance_service_account.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/instanceServiceAccount:InstanceServiceAccount You can import a group service account using `<resource> <id>`. The
        ```

        `id` is the id of the service account

        ```sh
        $ pulumi import gitlab:index/instanceServiceAccount:InstanceServiceAccount example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] email: The email of the user account. If not set, generates a no-reply email address.
        :param pulumi.Input[_builtins.str] name: The name of the user. If not set, uses Service account user.
        :param pulumi.Input[_builtins.str] username: The username of the user account. If not set, generates a name prepended with service*account*.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceServiceAccountArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `InstanceServiceAccount` resource allows creating a GitLab instance service account.

        > In order for a user to create a user account, they must have admin privileges at the instance level. This makes this feature unavailable on `gitlab.com`

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/user_service_accounts/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        # create a service account
        example_sa = gitlab.InstanceServiceAccount("example_sa",
            name="example-name",
            username="example-username",
            email="custom_email@gitlab.example.com",
            timeouts={
                "delete": "3m",
            })
        example_token = gitlab.PersonalAccessToken("example_token",
            user_id=example_sa.service_account_id,
            name="Example personal access token for a service account",
            expires_at="2026-01-01",
            scopes=["api"])
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_instance_service_account`. For example:

        terraform

        import {

          to = gitlab_instance_service_account.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/instanceServiceAccount:InstanceServiceAccount You can import a group service account using `<resource> <id>`. The
        ```

        `id` is the id of the service account

        ```sh
        $ pulumi import gitlab:index/instanceServiceAccount:InstanceServiceAccount example example
        ```

        :param str resource_name: The name of the resource.
        :param InstanceServiceAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceServiceAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['InstanceServiceAccountTimeoutsArgs', 'InstanceServiceAccountTimeoutsArgsDict']]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceServiceAccountArgs.__new__(InstanceServiceAccountArgs)

            __props__.__dict__["email"] = email
            __props__.__dict__["name"] = name
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["username"] = username
            __props__.__dict__["service_account_id"] = None
        super(InstanceServiceAccount, __self__).__init__(
            'gitlab:index/instanceServiceAccount:InstanceServiceAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['InstanceServiceAccountTimeoutsArgs', 'InstanceServiceAccountTimeoutsArgsDict']]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceServiceAccount':
        """
        Get an existing InstanceServiceAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] email: The email of the user account. If not set, generates a no-reply email address.
        :param pulumi.Input[_builtins.str] name: The name of the user. If not set, uses Service account user.
        :param pulumi.Input[_builtins.str] service_account_id: The service account id.
        :param pulumi.Input[_builtins.str] username: The username of the user account. If not set, generates a name prepended with service*account*.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceServiceAccountState.__new__(_InstanceServiceAccountState)

        __props__.__dict__["email"] = email
        __props__.__dict__["name"] = name
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["username"] = username
        return InstanceServiceAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        The email of the user account. If not set, generates a no-reply email address.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the user. If not set, uses Service account user.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The service account id.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.InstanceServiceAccountTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The username of the user account. If not set, generates a name prepended with service*account*.
        """
        return pulumi.get(self, "username")

