# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ReleaseLinkArgs', 'ReleaseLink']

@pulumi.input_type
class ReleaseLinkArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[_builtins.str],
                 tag_name: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 filepath: Optional[pulumi.Input[_builtins.str]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ReleaseLink resource.
        :param pulumi.Input[_builtins.str] project: The ID or [URL-encoded path of the project](https://docs.gitlab.com/api/index/#namespaced-path-encoding).
        :param pulumi.Input[_builtins.str] tag_name: The tag associated with the Release.
        :param pulumi.Input[_builtins.str] url: The URL of the link. Link URLs must be unique within the release.
        :param pulumi.Input[_builtins.str] filepath: Relative path for a [Direct Asset link](https://docs.gitlab.com/user/project/releases/index/#permanent-links-to-release-assets).
        :param pulumi.Input[_builtins.str] link_type: The type of the link. Valid values are `other`, `runbook`, `image`, `package`. Defaults to other.
        :param pulumi.Input[_builtins.str] name: The name of the link. Link names must be unique within the release.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "tag_name", tag_name)
        pulumi.set(__self__, "url", url)
        if filepath is not None:
            pulumi.set(__self__, "filepath", filepath)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The ID or [URL-encoded path of the project](https://docs.gitlab.com/api/index/#namespaced-path-encoding).
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> pulumi.Input[_builtins.str]:
        """
        The tag associated with the Release.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tag_name", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of the link. Link URLs must be unique within the release.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def filepath(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relative path for a [Direct Asset link](https://docs.gitlab.com/user/project/releases/index/#permanent-links-to-release-assets).
        """
        return pulumi.get(self, "filepath")

    @filepath.setter
    def filepath(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filepath", value)

    @_builtins.property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the link. Valid values are `other`, `runbook`, `image`, `package`. Defaults to other.
        """
        return pulumi.get(self, "link_type")

    @link_type.setter
    def link_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the link. Link names must be unique within the release.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ReleaseLinkState:
    def __init__(__self__, *,
                 direct_asset_url: Optional[pulumi.Input[_builtins.str]] = None,
                 external: Optional[pulumi.Input[_builtins.bool]] = None,
                 filepath: Optional[pulumi.Input[_builtins.str]] = None,
                 link_id: Optional[pulumi.Input[_builtins.int]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReleaseLink resources.
        :param pulumi.Input[_builtins.str] direct_asset_url: Full path for a [Direct Asset link](https://docs.gitlab.com/user/project/releases/index/#permanent-links-to-release-assets).
        :param pulumi.Input[_builtins.bool] external: External or internal link.
        :param pulumi.Input[_builtins.str] filepath: Relative path for a [Direct Asset link](https://docs.gitlab.com/user/project/releases/index/#permanent-links-to-release-assets).
        :param pulumi.Input[_builtins.int] link_id: The ID of the link.
        :param pulumi.Input[_builtins.str] link_type: The type of the link. Valid values are `other`, `runbook`, `image`, `package`. Defaults to other.
        :param pulumi.Input[_builtins.str] name: The name of the link. Link names must be unique within the release.
        :param pulumi.Input[_builtins.str] project: The ID or [URL-encoded path of the project](https://docs.gitlab.com/api/index/#namespaced-path-encoding).
        :param pulumi.Input[_builtins.str] tag_name: The tag associated with the Release.
        :param pulumi.Input[_builtins.str] url: The URL of the link. Link URLs must be unique within the release.
        """
        if direct_asset_url is not None:
            pulumi.set(__self__, "direct_asset_url", direct_asset_url)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if filepath is not None:
            pulumi.set(__self__, "filepath", filepath)
        if link_id is not None:
            pulumi.set(__self__, "link_id", link_id)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="directAssetUrl")
    def direct_asset_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full path for a [Direct Asset link](https://docs.gitlab.com/user/project/releases/index/#permanent-links-to-release-assets).
        """
        return pulumi.get(self, "direct_asset_url")

    @direct_asset_url.setter
    def direct_asset_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direct_asset_url", value)

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        External or internal link.
        """
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external", value)

    @_builtins.property
    @pulumi.getter
    def filepath(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relative path for a [Direct Asset link](https://docs.gitlab.com/user/project/releases/index/#permanent-links-to-release-assets).
        """
        return pulumi.get(self, "filepath")

    @filepath.setter
    def filepath(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filepath", value)

    @_builtins.property
    @pulumi.getter(name="linkId")
    def link_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the link.
        """
        return pulumi.get(self, "link_id")

    @link_id.setter
    def link_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "link_id", value)

    @_builtins.property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the link. Valid values are `other`, `runbook`, `image`, `package`. Defaults to other.
        """
        return pulumi.get(self, "link_type")

    @link_type.setter
    def link_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the link. Link names must be unique within the release.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID or [URL-encoded path of the project](https://docs.gitlab.com/api/index/#namespaced-path-encoding).
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag associated with the Release.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_name", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the link. Link URLs must be unique within the release.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("gitlab:index/releaseLink:ReleaseLink")
class ReleaseLink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filepath: Optional[pulumi.Input[_builtins.str]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `ReleaseLink` resource allows to manage the lifecycle of a release link.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/releases/links/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        # Create a project
        example = gitlab.Project("example",
            name="example",
            description="An example project")
        # Can create release link only to a tag associated with a release
        example_release_link = gitlab.ReleaseLink("example",
            project=example.id,
            tag_name="tag_name_associated_with_release",
            name="test",
            url="https://test/")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_release_link`. For example:

        terraform

        import {

          to = gitlab_release_link.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        Gitlab release link can be imported with a key composed of `<project>:<tag_name>:<link_id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/releaseLink:ReleaseLink example "12345:test:2"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] filepath: Relative path for a [Direct Asset link](https://docs.gitlab.com/user/project/releases/index/#permanent-links-to-release-assets).
        :param pulumi.Input[_builtins.str] link_type: The type of the link. Valid values are `other`, `runbook`, `image`, `package`. Defaults to other.
        :param pulumi.Input[_builtins.str] name: The name of the link. Link names must be unique within the release.
        :param pulumi.Input[_builtins.str] project: The ID or [URL-encoded path of the project](https://docs.gitlab.com/api/index/#namespaced-path-encoding).
        :param pulumi.Input[_builtins.str] tag_name: The tag associated with the Release.
        :param pulumi.Input[_builtins.str] url: The URL of the link. Link URLs must be unique within the release.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReleaseLinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ReleaseLink` resource allows to manage the lifecycle of a release link.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/releases/links/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        # Create a project
        example = gitlab.Project("example",
            name="example",
            description="An example project")
        # Can create release link only to a tag associated with a release
        example_release_link = gitlab.ReleaseLink("example",
            project=example.id,
            tag_name="tag_name_associated_with_release",
            name="test",
            url="https://test/")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_release_link`. For example:

        terraform

        import {

          to = gitlab_release_link.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        Gitlab release link can be imported with a key composed of `<project>:<tag_name>:<link_id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/releaseLink:ReleaseLink example "12345:test:2"
        ```

        :param str resource_name: The name of the resource.
        :param ReleaseLinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReleaseLinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filepath: Optional[pulumi.Input[_builtins.str]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReleaseLinkArgs.__new__(ReleaseLinkArgs)

            __props__.__dict__["filepath"] = filepath
            __props__.__dict__["link_type"] = link_type
            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if tag_name is None and not opts.urn:
                raise TypeError("Missing required property 'tag_name'")
            __props__.__dict__["tag_name"] = tag_name
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["direct_asset_url"] = None
            __props__.__dict__["external"] = None
            __props__.__dict__["link_id"] = None
        super(ReleaseLink, __self__).__init__(
            'gitlab:index/releaseLink:ReleaseLink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            direct_asset_url: Optional[pulumi.Input[_builtins.str]] = None,
            external: Optional[pulumi.Input[_builtins.bool]] = None,
            filepath: Optional[pulumi.Input[_builtins.str]] = None,
            link_id: Optional[pulumi.Input[_builtins.int]] = None,
            link_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            tag_name: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'ReleaseLink':
        """
        Get an existing ReleaseLink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] direct_asset_url: Full path for a [Direct Asset link](https://docs.gitlab.com/user/project/releases/index/#permanent-links-to-release-assets).
        :param pulumi.Input[_builtins.bool] external: External or internal link.
        :param pulumi.Input[_builtins.str] filepath: Relative path for a [Direct Asset link](https://docs.gitlab.com/user/project/releases/index/#permanent-links-to-release-assets).
        :param pulumi.Input[_builtins.int] link_id: The ID of the link.
        :param pulumi.Input[_builtins.str] link_type: The type of the link. Valid values are `other`, `runbook`, `image`, `package`. Defaults to other.
        :param pulumi.Input[_builtins.str] name: The name of the link. Link names must be unique within the release.
        :param pulumi.Input[_builtins.str] project: The ID or [URL-encoded path of the project](https://docs.gitlab.com/api/index/#namespaced-path-encoding).
        :param pulumi.Input[_builtins.str] tag_name: The tag associated with the Release.
        :param pulumi.Input[_builtins.str] url: The URL of the link. Link URLs must be unique within the release.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReleaseLinkState.__new__(_ReleaseLinkState)

        __props__.__dict__["direct_asset_url"] = direct_asset_url
        __props__.__dict__["external"] = external
        __props__.__dict__["filepath"] = filepath
        __props__.__dict__["link_id"] = link_id
        __props__.__dict__["link_type"] = link_type
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["tag_name"] = tag_name
        __props__.__dict__["url"] = url
        return ReleaseLink(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="directAssetUrl")
    def direct_asset_url(self) -> pulumi.Output[_builtins.str]:
        """
        Full path for a [Direct Asset link](https://docs.gitlab.com/user/project/releases/index/#permanent-links-to-release-assets).
        """
        return pulumi.get(self, "direct_asset_url")

    @_builtins.property
    @pulumi.getter
    def external(self) -> pulumi.Output[_builtins.bool]:
        """
        External or internal link.
        """
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter
    def filepath(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Relative path for a [Direct Asset link](https://docs.gitlab.com/user/project/releases/index/#permanent-links-to-release-assets).
        """
        return pulumi.get(self, "filepath")

    @_builtins.property
    @pulumi.getter(name="linkId")
    def link_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the link.
        """
        return pulumi.get(self, "link_id")

    @_builtins.property
    @pulumi.getter(name="linkType")
    def link_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the link. Valid values are `other`, `runbook`, `image`, `package`. Defaults to other.
        """
        return pulumi.get(self, "link_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the link. Link names must be unique within the release.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID or [URL-encoded path of the project](https://docs.gitlab.com/api/index/#namespaced-path-encoding).
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> pulumi.Output[_builtins.str]:
        """
        The tag associated with the Release.
        """
        return pulumi.get(self, "tag_name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the link. Link URLs must be unique within the release.
        """
        return pulumi.get(self, "url")

