# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserIdentityArgs', 'UserIdentity']

@pulumi.input_type
class UserIdentityArgs:
    def __init__(__self__, *,
                 external_provider: pulumi.Input[_builtins.str],
                 external_uid: pulumi.Input[_builtins.str],
                 user_id: pulumi.Input[_builtins.int]):
        """
        The set of arguments for constructing a UserIdentity resource.
        :param pulumi.Input[_builtins.str] external_provider: The external provider name.
        :param pulumi.Input[_builtins.str] external_uid: A specific external authentication provider UID.
        :param pulumi.Input[_builtins.int] user_id: The GitLab ID of the user.
        """
        pulumi.set(__self__, "external_provider", external_provider)
        pulumi.set(__self__, "external_uid", external_uid)
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="externalProvider")
    def external_provider(self) -> pulumi.Input[_builtins.str]:
        """
        The external provider name.
        """
        return pulumi.get(self, "external_provider")

    @external_provider.setter
    def external_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_provider", value)

    @_builtins.property
    @pulumi.getter(name="externalUid")
    def external_uid(self) -> pulumi.Input[_builtins.str]:
        """
        A specific external authentication provider UID.
        """
        return pulumi.get(self, "external_uid")

    @external_uid.setter
    def external_uid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_uid", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[_builtins.int]:
        """
        The GitLab ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _UserIdentityState:
    def __init__(__self__, *,
                 external_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 external_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering UserIdentity resources.
        :param pulumi.Input[_builtins.str] external_provider: The external provider name.
        :param pulumi.Input[_builtins.str] external_uid: A specific external authentication provider UID.
        :param pulumi.Input[_builtins.int] user_id: The GitLab ID of the user.
        """
        if external_provider is not None:
            pulumi.set(__self__, "external_provider", external_provider)
        if external_uid is not None:
            pulumi.set(__self__, "external_uid", external_uid)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="externalProvider")
    def external_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The external provider name.
        """
        return pulumi.get(self, "external_provider")

    @external_provider.setter
    def external_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_provider", value)

    @_builtins.property
    @pulumi.getter(name="externalUid")
    def external_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A specific external authentication provider UID.
        """
        return pulumi.get(self, "external_uid")

    @external_uid.setter
    def external_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_uid", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The GitLab ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("gitlab:index/userIdentity:UserIdentity")
class UserIdentity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 external_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        The `UserIdentity` resource is for managing the lifecycle of a user's external identity.

        > the provider needs to be configured with admin-level access for this resource to work.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/users/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.User("example",
            name="Example Foo",
            username="example",
            email="gitlab@user.create",
            is_admin=True,
            projects_limit=4,
            can_create_group=False,
            is_external=True)
        example_user_identity = gitlab.UserIdentity("example",
            user_id=example.id,
            external_provider="google",
            external_uid="1234567890")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_user_identity`. For example:

        terraform

        import {

          to = gitlab_user_identity.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/userIdentity:UserIdentity You can import a user identity to terraform state using `<resource> <id>`.
        ```

        The `id` must be a string for the id of the user and identity provider you want to import,

        for example:

        ```sh
        $ pulumi import gitlab:index/userIdentity:UserIdentity example "42:google"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_provider: The external provider name.
        :param pulumi.Input[_builtins.str] external_uid: A specific external authentication provider UID.
        :param pulumi.Input[_builtins.int] user_id: The GitLab ID of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserIdentityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `UserIdentity` resource is for managing the lifecycle of a user's external identity.

        > the provider needs to be configured with admin-level access for this resource to work.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/users/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.User("example",
            name="Example Foo",
            username="example",
            email="gitlab@user.create",
            is_admin=True,
            projects_limit=4,
            can_create_group=False,
            is_external=True)
        example_user_identity = gitlab.UserIdentity("example",
            user_id=example.id,
            external_provider="google",
            external_uid="1234567890")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_user_identity`. For example:

        terraform

        import {

          to = gitlab_user_identity.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/userIdentity:UserIdentity You can import a user identity to terraform state using `<resource> <id>`.
        ```

        The `id` must be a string for the id of the user and identity provider you want to import,

        for example:

        ```sh
        $ pulumi import gitlab:index/userIdentity:UserIdentity example "42:google"
        ```

        :param str resource_name: The name of the resource.
        :param UserIdentityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserIdentityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 external_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserIdentityArgs.__new__(UserIdentityArgs)

            if external_provider is None and not opts.urn:
                raise TypeError("Missing required property 'external_provider'")
            __props__.__dict__["external_provider"] = external_provider
            if external_uid is None and not opts.urn:
                raise TypeError("Missing required property 'external_uid'")
            __props__.__dict__["external_uid"] = external_uid
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        super(UserIdentity, __self__).__init__(
            'gitlab:index/userIdentity:UserIdentity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            external_provider: Optional[pulumi.Input[_builtins.str]] = None,
            external_uid: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'UserIdentity':
        """
        Get an existing UserIdentity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_provider: The external provider name.
        :param pulumi.Input[_builtins.str] external_uid: A specific external authentication provider UID.
        :param pulumi.Input[_builtins.int] user_id: The GitLab ID of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserIdentityState.__new__(_UserIdentityState)

        __props__.__dict__["external_provider"] = external_provider
        __props__.__dict__["external_uid"] = external_uid
        __props__.__dict__["user_id"] = user_id
        return UserIdentity(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="externalProvider")
    def external_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The external provider name.
        """
        return pulumi.get(self, "external_provider")

    @_builtins.property
    @pulumi.getter(name="externalUid")
    def external_uid(self) -> pulumi.Output[_builtins.str]:
        """
        A specific external authentication provider UID.
        """
        return pulumi.get(self, "external_uid")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.int]:
        """
        The GitLab ID of the user.
        """
        return pulumi.get(self, "user_id")

