# Contributing to Naturalis Bioinformatics Toolkit

First off, thank you for considering contributing to the Naturalis Bioinformatics Toolkit! 
It's people like you that make this toolkit a great resource for the bioinformatics 
community. We welcome contributions from everyone, regardless of their level of 
experience.

## Getting Started

Before you begin:
- Make sure you have a [GitLab account](https://gitlab.com/)
- Familiarize yourself with the [project structure](README.md)
- Check out our [code of conduct](CODE_OF_CONDUCT.md)

## How Can I Contribute?

### Reporting Bugs

If you've found a bug, please create an issue on our GitLab repository. Be sure to 
include:

- A clear title and description
- As much relevant information as possible
- A code sample or an executable test case demonstrating the bug

### Suggesting Enhancements

We're always looking for ways to make our toolkit better. If you have an idea for an 
enhancement:

- Use a clear and descriptive title
- Provide a step-by-step description of the suggested enhancement
- Explain why this enhancement would be useful to most users

### Pull Requests

We actively welcome your pull requests. Here's the process:

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. Ensure the test suite passes.
4. Make sure your code lints.
5. Issue that pull request!

### Code Contribution Guidelines

1. Write Python code that adheres to the [PEP 8 style guide](https://www.python.org/dev/peps/pep-0008/).
2. Include docstrings for all functions, classes, and modules.
3. Write unit tests for your code using pytest.
4. Ensure your code doesn't break existing functionality.
5. Update the documentation if you're changing or adding features.

## Adding Tests

We can't stress enough how important tests are. When contributing:

1. Write unit tests for all new functions and classes.
2. Aim for high test coverage (we recommend at least 80%).
3. Make sure all tests pass before submitting a pull request.
4. If you're fixing a bug, write a test that exposes the bug and fails before your fix.

## Pull Request Process

1. Ensure any install or build dependencies are removed before the end of the layer when doing a build.
2. Update the README.md with details of changes to the interface, this includes new environment variables, exposed ports, useful file locations and container parameters.
3. Increase the version numbers in any examples files and the README.md to the new version that this Pull Request would represent. The versioning scheme we use is [SemVer](http://semver.org/).
4. You may merge the Pull Request in once you have the sign-off of two other developers, or if you do not have permission to do that, you may request the second reviewer to merge it for you.

## Code Review Process

The core team looks at Pull Requests on a regular basis. After feedback has been given we 
expect responses within two weeks. After two weeks we may close the pull request if it 
isn't showing any activity.

## Community

Keep an eye on the GitLab issues for questions from other community members. If you know 
the answer, please don't hesitate to share your expertise!

Thank you for contributing to the Naturalis Bioinformatics Toolkit. Your efforts help 
make this a great resource for the entire bioinformatics community!
