# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.http_validation_error import HttpValidationError
from ...types.new_testset import NewTestset
from ...types.test_set_output_response import TestSetOutputResponse
from ...types.test_set_simple_response import TestSetSimpleResponse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TestsetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def upload_file(
        self,
        *,
        upload_type: typing.Optional[str] = None,
        file: typing.IO,
        testset_name: typing.Optional[str] = None,
        app_id: typing.Optional[str] = None,
    ) -> TestSetSimpleResponse:
        """
        Uploads a CSV or JSON file and saves its data to MongoDB.

        Args:
        upload_type : Either a json or csv file.
        file (UploadFile): The CSV or JSON file to upload.
        testset_name (Optional): the name of the testset if provided.

        Returns:
        dict: The result of the upload process.

        Parameters:
            - upload_type: typing.Optional[str].

            - file: typing.IO.

            - testset_name: typing.Optional[str].

            - app_id: typing.Optional[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.testsets.upload_file()
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "testsets/upload"
            ),
            data=jsonable_encoder(
                {
                    "upload_type": upload_type,
                    "testset_name": testset_name,
                    "app_id": app_id,
                }
            ),
            files={"file": file},
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(TestSetSimpleResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def import_testset(self) -> TestSetSimpleResponse:
        """
        Import JSON testset data from an endpoint and save it to MongoDB.

        Args:
        endpoint (str): An endpoint URL to import data from.
        testset_name (str): the name of the testset if provided.

        Returns:
        dict: The result of the import process.

        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.testsets.import_testset()
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "testsets/endpoint"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(TestSetSimpleResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_testset(
        self, app_id: str, *, request: NewTestset
    ) -> TestSetSimpleResponse:
        """
        Create a testset with given name and app_name, save the testset to MongoDB.

        Args:
        name (str): name of the test set.
        app_name (str): name of the application.
        testset (Dict[str, str]): test set data.

        Returns:
        str: The id of the test set created.

        Parameters:
            - app_id: str.

            - request: NewTestset.
        ---
        from agenta import NewTestset
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.testsets.create_testset(
            app_id="app_id",
            request=NewTestset(
                name="name",
                csvdata=[{"csvdata": "csvdata"}],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"testsets/{app_id}"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(TestSetSimpleResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_single_testset(self, testset_id: str) -> typing.Any:
        """
        Fetch a specific testset in a MongoDB collection using its \_id.

        Args:
        testset_id (str): The \_id of the testset to fetch.

        Returns:
        The requested testset if found, else an HTTPException.

        Parameters:
            - testset_id: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.testsets.get_single_testset(
            testset_id="testset_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"testsets/{testset_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_testset(self, testset_id: str, *, request: NewTestset) -> typing.Any:
        """
        Update a testset with given id, update the testset in MongoDB.

        Args:
        testset_id (str): id of the test set to be updated.
        csvdata (NewTestset): New data to replace the old testset.

        Returns:
        str: The id of the test set updated.

        Parameters:
            - testset_id: str.

            - request: NewTestset.
        ---
        from agenta import NewTestset
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.testsets.update_testset(
            testset_id="testset_id",
            request=NewTestset(
                name="name",
                csvdata=[{"csvdata": "csvdata"}],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"testsets/{testset_id}"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_testsets(self, *, app_id: str) -> typing.List[TestSetOutputResponse]:
        """
        Get all testsets.

        Returns:

        - A list of testset objects.

        Raises:

        - `HTTPException` with status code 404 if no testsets are found.

        Parameters:
            - app_id: str.
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.testsets.get_testsets(
            app_id="app_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "testsets"),
            params=remove_none_from_dict({"app_id": app_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[TestSetOutputResponse], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_testsets(self, *, testset_ids: typing.List[str]) -> typing.List[str]:
        """
        Delete specific testsets based on their unique IDs.

        Args:
        testset_ids (List[str]): The unique identifiers of the testsets to delete.

        Returns:
        A list of the deleted testsets' IDs.

        Parameters:
            - testset_ids: typing.List[str].
        ---
        from agenta.client import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.testsets.delete_testsets(
            testset_ids=["testset_ids"],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "testsets"),
            json=jsonable_encoder({"testset_ids": testset_ids}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[str], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncTestsetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def upload_file(
        self,
        *,
        upload_type: typing.Optional[str] = None,
        file: typing.IO,
        testset_name: typing.Optional[str] = None,
        app_id: typing.Optional[str] = None,
    ) -> TestSetSimpleResponse:
        """
        Uploads a CSV or JSON file and saves its data to MongoDB.

        Args:
        upload_type : Either a json or csv file.
        file (UploadFile): The CSV or JSON file to upload.
        testset_name (Optional): the name of the testset if provided.

        Returns:
        dict: The result of the upload process.

        Parameters:
            - upload_type: typing.Optional[str].

            - file: typing.IO.

            - testset_name: typing.Optional[str].

            - app_id: typing.Optional[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.testsets.upload_file()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "testsets/upload"
            ),
            data=jsonable_encoder(
                {
                    "upload_type": upload_type,
                    "testset_name": testset_name,
                    "app_id": app_id,
                }
            ),
            files={"file": file},
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(TestSetSimpleResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def import_testset(self) -> TestSetSimpleResponse:
        """
        Import JSON testset data from an endpoint and save it to MongoDB.

        Args:
        endpoint (str): An endpoint URL to import data from.
        testset_name (str): the name of the testset if provided.

        Returns:
        dict: The result of the import process.

        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.testsets.import_testset()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "testsets/endpoint"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(TestSetSimpleResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_testset(
        self, app_id: str, *, request: NewTestset
    ) -> TestSetSimpleResponse:
        """
        Create a testset with given name and app_name, save the testset to MongoDB.

        Args:
        name (str): name of the test set.
        app_name (str): name of the application.
        testset (Dict[str, str]): test set data.

        Returns:
        str: The id of the test set created.

        Parameters:
            - app_id: str.

            - request: NewTestset.
        ---
        from agenta import NewTestset
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.testsets.create_testset(
            app_id="app_id",
            request=NewTestset(
                name="name",
                csvdata=[{"csvdata": "csvdata"}],
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"testsets/{app_id}"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(TestSetSimpleResponse, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_single_testset(self, testset_id: str) -> typing.Any:
        """
        Fetch a specific testset in a MongoDB collection using its \_id.

        Args:
        testset_id (str): The \_id of the testset to fetch.

        Returns:
        The requested testset if found, else an HTTPException.

        Parameters:
            - testset_id: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.testsets.get_single_testset(
            testset_id="testset_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"testsets/{testset_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_testset(
        self, testset_id: str, *, request: NewTestset
    ) -> typing.Any:
        """
        Update a testset with given id, update the testset in MongoDB.

        Args:
        testset_id (str): id of the test set to be updated.
        csvdata (NewTestset): New data to replace the old testset.

        Returns:
        str: The id of the test set updated.

        Parameters:
            - testset_id: str.

            - request: NewTestset.
        ---
        from agenta import NewTestset
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.testsets.update_testset(
            testset_id="testset_id",
            request=NewTestset(
                name="name",
                csvdata=[{"csvdata": "csvdata"}],
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"testsets/{testset_id}"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Any, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_testsets(self, *, app_id: str) -> typing.List[TestSetOutputResponse]:
        """
        Get all testsets.

        Returns:

        - A list of testset objects.

        Raises:

        - `HTTPException` with status code 404 if no testsets are found.

        Parameters:
            - app_id: str.
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.testsets.get_testsets(
            app_id="app_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "testsets"),
            params=remove_none_from_dict({"app_id": app_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[TestSetOutputResponse], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_testsets(
        self, *, testset_ids: typing.List[str]
    ) -> typing.List[str]:
        """
        Delete specific testsets based on their unique IDs.

        Args:
        testset_ids (List[str]): The unique identifiers of the testsets to delete.

        Returns:
        A list of the deleted testsets' IDs.

        Parameters:
            - testset_ids: typing.List[str].
        ---
        from agenta.client import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        await client.testsets.delete_testsets(
            testset_ids=["testset_ids"],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "testsets"),
            json=jsonable_encoder({"testset_ids": testset_ids}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.List[str], _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
