from dvc.cli import main
from dvc.ui import ui
from tests.utils import console_width


def test_status(tmp_dir, scm, dvc, machine_config, machine_instance, capsys):
    assert main(["machine", "add", "bar", "aws"]) == 0
    with console_width(ui.rich_console, 255):
        assert main(["machine", "status"]) == 0
    cap = capsys.readouterr()
    assert (
        "name    instance    status    cloud    instance_ip      "
        "instance_type    instance_hdd_size    instance_gpu" in cap.out
    )
    assert (
        "bar     -           offline   -        -                "
        "-                -                    -" in cap.out
    )
    assert (
        "foo     num_1       running   aws      123.123.123.123  "
        "m                35                   None" in cap.out
    )
