from __future__ import annotations

SSL_TEST_PRIVATE_CA_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDKTCCAhGgAwIBAgIUX9kvHEjir5fniTg3GRQ8wO7zOvAwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMB4XDTIyMDczMTAyMDgxNVoXDTMyMDcy
ODAyMDgxNVowRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8G
A1UECwwYT3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEAykxn/RsW32xbKhz4CFSnngEwji+mbyOREJihRy/2ydPI
dQ1vgMJdgatf3GUr49imIYu4r1PfvvLTHCCXLjbW4zk8K+Tf+gGfnm/rjvGvwO7I
J7qZj2slknkZAqq0jhVKkt+xkM4A3fbk6cy2DC+2w2se20fKvPa8Nwgt1GzBGpN4
ditUWZwhVz3Q+4QMnZTEiKkfkKBYlJntheIiLPTReDiHUlMIfl1kBqYZqLmX3lsS
J29o73BMyjNhQBMKe5F6TIcYeIME5H/DAKCfS6JR3HGMj1aqeunqVZ+Wacs+HOtD
hHLrSsCwMa1XVzPPNV1on7JekgSpEXTd9DEtpHO5TQIDAQABoxMwETAPBgNVHRMB
Af8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQAk7pLuj7tqbztCXhLMD5TqIfml
HB3K1nOKwNEIJ29J8Xc6lKUMB/z3UFVmPPuuHW3FBXsrf1ZcZLaTNZuY2304yURV
uzpH5GAivGwSbXmccOee1HV8Rrvii/Gd8c2qdxBsypaiMaNAOCOUHqfGAQCWRefO
/8rn8TmXWikNFL2YygcR+XI5jWTAF6LoXCxV0y48X4Kg7G7s5QHDqnHYhakfAtyO
9KpUPODd3UIZoW5k8A0vn0xwrvyqwNhCTHOkt178jCiqCR1b3jnvmVHTw1rIOnXE
rhdGfc4ywMBp+Rv8hFZM0RPmt+aDy+O2XvdPqFCky6R4+l8RtlYP242urN8q
-----END CERTIFICATE-----
"""

SSL_TEST_PRIVATE_CA_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDKTGf9GxbfbFsq
HPgIVKeeATCOL6ZvI5EQmKFHL/bJ08h1DW+Awl2Bq1/cZSvj2KYhi7ivU9++8tMc
IJcuNtbjOTwr5N/6AZ+eb+uO8a/A7sgnupmPayWSeRkCqrSOFUqS37GQzgDd9uTp
zLYML7bDax7bR8q89rw3CC3UbMEak3h2K1RZnCFXPdD7hAydlMSIqR+QoFiUme2F
4iIs9NF4OIdSUwh+XWQGphmouZfeWxInb2jvcEzKM2FAEwp7kXpMhxh4gwTkf8MA
oJ9LolHccYyPVqp66epVn5Zpyz4c60OEcutKwLAxrVdXM881XWifsl6SBKkRdN30
MS2kc7lNAgMBAAECggEAXrPWGo8L7hvzsYtOMdgvf7Be4rE74Nttla9eEM1LYsBa
HzHi+QwEaieoAKz8FvXdD+cw1iMVo3ZZjdlT7LaPcl/g40uJ7qfD6Y/LXmeWN2OR
H8gjCxjFxgQayTzQuZMODiPaJEfL8B0cnLbQonPTwzfqggzhxARdqAWULtWasK1z
h9iS0lDDEPUjNLv72X5uCNh5l7oi1lLoASgIz+YNnGuNw8lEhEzoXmh4SrAY6nGc
NAkHQfpCwD12AXysjO4l/yZavamT1F9L8TrYpEPJbcemTg7UJ3m6soD/K5zlQF1b
KGGjOHTeycbvgzasys0/Carhr1wytY4EOHJ/OU4UoQKBgQDsKKlYYqOn+FoX2uzF
5Kmx8TyDp3rWB4n1JuyXcxu8g771aL16KCg7+RaaVQb+sUTmD+uOaBeV0aRWgx1V
v6h4tVu+nYlKe0gUkEpRYeAsaTuMlXH0QAjehxhbGp6UkvnE8ZTnZxFf/QRM7Cjn
3DxRaNR55DBJxPXSQ1/uw/nvdwKBgQDbS3iMuqmGxhbBQXDBK2Gymxuu7w51ZZAm
qf1nA2t+RYEHNDkIcwiGrpAs/lEKkbrdV58g3KUbrmTNMzmLREPmccBDMUB5ehR/
6DyWrpPnwbRDe6+w52NUu6xEFRCeWNuR4mXDDd9QwELUh7Hrzu6tJuWKvkTEnbq1
ZCDRkcu2WwKBgQC0gdv25+ZppEXQyBCErmQa0+ZKR0B3yelkDe13UY+Yxya10+pI
LdubA6iILIedM4gTRYXqIpwscsJnMe7BNS6jnRPUHfvrh1GwDh4QGHzN1V2j9jLU
3AErfh1avX0K2VC6fWEwgrJgKTgZR8V4e/lKzJLj3EwghsDSh5cTHI60vwKBgEYm
xYCXcgXYNo1KBuz0mMNPFTMH7GMnw05rENI0aN2zFEyeqyQF0JNtIlgSXxB3gASw
tAoKK5NIXZy7J0xi4SnF99BG4C48HHSycTduz4fTEnyIA7Mewkrn4nrBFljhahQo
DY+xT2AAsSBV7FfYEcg4ajPRHCSdpI3EYy9HaZiDAoGBALfdWaUb5p1Z8fnJo6Pm
3CesRNSqz56FzQ7yqg2af5R6in4AeAjuVjq2SR/5kqTJPicnPRVFm5Uv6NgWrVR5
pjab587uaDYA5aXbNYfZRpj6+WHaYBileILbqqTLFQjlVHJXJDuDs21tIkaXMxcN
XHMcjqOWJHxgq4s4SyJEQJAO
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUJxG4nRreZqpC8YFg4bfgBgnjp8gwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQD7zuyb/gcsWCWbuLrEJSjVJWSOAP3YYVEnUIR949nIE+xS
32Z01a2/y4lcUf1DoB2ADYv4LqSrHnBasgznXJHYWPNRQX5hOGeJzC0Gb8B4MEWF
7gPC+v6//GXytGl2fg5GyGHDbKT33f6c1TaJXY4P2iummoFNoOX13EzyYEWXeBC1
L9p8+fkpSC1C1eCwRQdzrghqagP06kt4gpO2OSJ0xtBX5fz8NY4pZ2CP33nyG8S+
yTJLZweWMFnueUL3b9JJgticr8RteyrKOGoVhcFnymw3GnsbGZURUxp/yXM67ovN
Ud487CNHHOJl3gDK69LcALOMZAHS5Q0ZQECpPWSxAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCOzjCPbMEDx1Q1XJyJDF8l
c2z0Tk3xhlGY1PnaARt4xNHh5gFodCeFTb+f9Ywoy0cYQ67PRZyLgDyuRKp8T4+z
wgWmG4NmvMKO+9h4F76+VGqYX7Oc5QADPF+hJrAWUNNEN+NbUpDp+W8E1aUzkIBE
HK2aNM7PAapereWXyR+U/mUXrOtiecBD72g0zS4hp++Uxn3uEaQobBc1EaT/GS/x
HWy2tmWaczUf5TydC44lF8NZCuMm89ldF+Qmz8b30ON2OsFzr/2WVVaj+k+j0MsQ
+Urzepx4+8NnlBGwgAyzlA1nEoDIsKMqUyBQlqv7cSFh2m05q7UrAUk/nFw+tNOP
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQD7zuyb/gcsWCWb
uLrEJSjVJWSOAP3YYVEnUIR949nIE+xS32Z01a2/y4lcUf1DoB2ADYv4LqSrHnBa
sgznXJHYWPNRQX5hOGeJzC0Gb8B4MEWF7gPC+v6//GXytGl2fg5GyGHDbKT33f6c
1TaJXY4P2iummoFNoOX13EzyYEWXeBC1L9p8+fkpSC1C1eCwRQdzrghqagP06kt4
gpO2OSJ0xtBX5fz8NY4pZ2CP33nyG8S+yTJLZweWMFnueUL3b9JJgticr8RteyrK
OGoVhcFnymw3GnsbGZURUxp/yXM67ovNUd487CNHHOJl3gDK69LcALOMZAHS5Q0Z
QECpPWSxAgMBAAECggEAGc3uuV2i5oxx7i9UFF2qfY1DbLn1SYNPibPan/wFiVdh
VGzIVxi+oXT+MpPEXHXAECtTOK+u+Eo6QVEVuW/nEkCrTpxjkxrwoVJnGs3A75Ai
z8LAZ+7IxGvdFq4eUKJCXEaUni44CZ6aRQAkgpcvw7gb2QrkTUw7xKI60GvFNexH
4HO2kxQTD+CW2NJ3+HwB+WeSYuMZUb8bj/NcwAsJ5mqFH0b2UKxMm0BK0sDnPwC2
GjpH9VKPZbB87GbzLUZ/JZhE/RBmABH1AObBtquOnhAKAYdLsoBoVtbbLKu8MXBm
BTMuKsjVCvckaoYx5poafBDVpZcQafq1jq0fxTegQQKBgQD+IB2CloJhIoC2/R8u
VIbHKOkUtt/UZFe3cxvvn/MvEwQcGm9T1vZwwH5MOUIk0VnC/SCVIk3hLqI8F/dV
Zvgox37YEwFGRzKcpJL0MPnwLjvyqvGzIZYG2kFWOD+t4nzndVbfQJ19EeTzu8Aw
N6JyctUAaz0aPbHFWQ73BVfPBQKBgQD9qm7uSI7XJs++fXfZIEev2PdtlcBOLeg3
qL032tE8XEFs96DVrl8Vzaj2Vnj30aBrw8dUcldUvxQKIpiChUXwtWu8oxdt0TSx
aVpYQkSQXNQm2RufMjq33lyNtm05ygNF5xsKCoZ14c81MgWOOELHZiWwI96Of+NA
EwjxHgy2vQKBgQCkY+wTHQAMjABN36J7Gwzw6wMUdlSHFb40mw8YTRVIf3mqIGOi
Da3wNGW/M08ZeCAj5hFcyAsvPzaNv0cthOXFo3/nkSvC5a3U7RVvR/t3JsF68qBW
K8Tce/XGK67t8lSwehSPaUI3tQqxrOPfjS3V8Xjew4CMaBqGulzW6SrrbQKBgAeW
GUs3EE6O8peX2QW9WWeA7aVxXRb5eIBxo3cQLEHJ4IsJvN2nIWDdjbgQTf3bXxjZ
+hQkd0gpjsfe0QDWS4kvY9F4bzLxlsnXhMQu9y36GL4wsArKzcbB97KlSg74Y7Cr
gLuEJRFRd4j3vgLK2/RqsaXa7MUGPh2kdBgB9g9hAoGBAOl5cixsR8EXmHQqMuZT
7iWTw4rUyyIH5RZRHrWD+GX3S0Ra+wY0wJBPzt/MeaJW4OtTgHQpQWAfWR9C2o+7
xUwA7aauwGg2MVF8iSRSOSCkpDfNM+AFZQ3HMg7CEVqPuypLGUkqGnvQQ2imTWO/
e4ZKdjD4H7urK494+juBwvCz
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUH+vOBpWm7GZBImUetpmvvngiuUQwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDSMjjzEEqoICoK7gBXrUhkhzVLmNnPxTpod32QWSpnSR9/
R81bPlxoaWixzYfNnAntIOr6txh82sd3lPqT45zT/Ji7iTkcbmh10Kw2YMPb1+cM
GAy3x/K+ASUMP911J/4E+4jFqodY7EccfxbnZir/U7IktqxchiPZoDC5Dvf5YtJZ
ZJLITRaAnoA66OC/cUWjxbzOGGPt9bJNbQXlgHGmJx6D9vaUE3hnIm03HpO+74S0
S54b4TI0R3H+fuU1jxgMuCHACcQTKpZRi5h4QT8QQJXoL/70dDG0DNFsI5RIEgf4
KS6wowbJLdqpZpeW4Sh513/xQYeEsIWgFnV6ZM3hAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAJKLQAkQBXoI8LJ0GRpLT+
wwdqXt1xdrLwyRI2Vf5hrxkRtYuvmXUjHrI/HxlIvapVUns2W9g9b2Eim/mb7FNJ
jztgEEP4V2OjbTOJOiqZakFA2te6FIlV4otaj6GOMwuCt8q2L+0m/KfHzLQYqn3X
YGUi9TQMMvJjVHmuZfEbVEKiNjjrT1DVE6YOQQBZKCCyTQccMXQSGwogtJOf3EH7
ruOiBExxyAFdntsE3VjSCD7U/jA2pnXD1KutI2o0g0bO1twuz7EzVLZFJNey0BUB
HtXDTP5TCJpf3lybcssjdiDnfARXUMTN2ka5WXgvebDwb1pqmuDlrVrA8UmqTYcy
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDSMjjzEEqoICoK
7gBXrUhkhzVLmNnPxTpod32QWSpnSR9/R81bPlxoaWixzYfNnAntIOr6txh82sd3
lPqT45zT/Ji7iTkcbmh10Kw2YMPb1+cMGAy3x/K+ASUMP911J/4E+4jFqodY7Ecc
fxbnZir/U7IktqxchiPZoDC5Dvf5YtJZZJLITRaAnoA66OC/cUWjxbzOGGPt9bJN
bQXlgHGmJx6D9vaUE3hnIm03HpO+74S0S54b4TI0R3H+fuU1jxgMuCHACcQTKpZR
i5h4QT8QQJXoL/70dDG0DNFsI5RIEgf4KS6wowbJLdqpZpeW4Sh513/xQYeEsIWg
FnV6ZM3hAgMBAAECggEAUfCaGsbjE59WRGR7ZbJ7YhUDRbEUV9Z+6nKKVFcuHI14
5dlLyKIKy/krgwSoSBLoG7SVZZ8ywJlY4NkGxdgZLtptf84CoX644hSyzY/zSiRk
QWauroYXrtIraxcKcb1hXPfhXY0YriWNoyI3/4TohhhOfdloX7k7CH9V/w5CxMh4
ZwWot36SmjNDPyW4z3rbcsSr9hmUeqxoE3KsXxHGdKNtg3NQ+qwAULE35qkQd+O4
mIgz51Qi7ZlYfgVq7BFn8Vs5rPYK57b+ACTMvReGylB8/r1wHtimk7p+7tjpZywz
qupcSgky3dch1bD2ICZpaeNGjQE40mdgggHmH634QQKBgQDtgYxppfzBE7k4Yopf
HbL5RnNc7wft0nzgp/zgz81W3emXshy7DdI1pVwhCBeTsCIgftsyTBncN7YeIP5p
MDhIZ8U6EthhuyPYp7dWmcIJSIeql/3/mVdK24sZcmDB9DaGsbY0oH0I9N9Ha2xo
jUWeColE1aeZYuyJFez/WbafpQKBgQDikEdE29uYeU1bioV3R1zzhyAgCLGF0RJs
Zuxwa5zYGkSjuswemxZiQQSJv/39mnGuKAtAU/d9ut8ay6/FZSFh6e/y231hPnm3
nqiPSZeAJx+TGg+eee2C4P5D2KfDnelswymD+rCfxJMyozwo2pYxu0sFHYcIluGo
Wtd+Xl1gjQKBgE2K72IK7IPJQb7UBWNamfVi+AVOkWMnRtg+YISxs9P5ret2HoU/
1PLo4zRxpOj2J54+bKh2SjcpBU++6/FB6g5RuwXj4zu9Us3IrEYc+0n2oTykVSxf
Ty3EkhyjyE1qw2aknN1/zHLhKAj0XLeh8CnSPND5hLfCoYF8ZB1WmBZ1AoGAMrGl
wLqRACTkMj9kbbQCEFuDzKclUZPeU3MUJHNvvMrj4N7DHXYGJCX4JfpXko8kMJu1
KMeg8PkHQq+gvMJMHeSCVAzYmRGpmnRdsvH8fChE4F1McWFGy6ocOoIXx6VlvXhN
qcJGEvmhFguAQoPmZ2pI9vQMateX1lu9LAFhU2ECgYBi5jsclGCd/CoCF0NqBs+U
nEvvh/hUYbUytZDcs1AArXy8Lup6bcxag01KFxt9Wh69wLrocF+q8pUuVGl/yfrv
Ozm4563EFG0DnbzzyzU/jnomxVqKFMqjsusNKY8iS21EAkBkCv9P5oudwD/HzRtR
oOyRRuENRW7evdvE+J5Trw==
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUHVa/b7E1IfWxhidTznNrmWBa8rEwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDLKM3aHoUk41DT3hOcg4HMYIdu+p6iIchg/LxlzQW2QLAD
ALcqP/u+c+a2ogqpWUC5Ub2o20UgboUJ67XdfqdiC3fBZ4hFpd9fuy0RYYtbPtYX
3DQkqY7U2eauRW78qTKP3AtTuGy25PmwtrEEMHpWTeeg2D3AdG6MGiiSzQHkPW/S
5t9y7UzNIKKsr5sCKNmEmxde1g9z0Aa7oJPXRLr93Y2YkQcsszX6DC6Q69VnhgC9
4CFfqp6kRk7DUxunJfNh0cUN2vHIP+0ICCr4o3FUslldpJrFvCpq9oyBxY1Gonpx
KaPhxkPJRmGNTxoubffDqwW0IjfxTMgGdjb2ZkytAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBXWejEkaLjR2YNUnUddqq4
Y49FDEmprs8tBY6bmpaJpKMCwLbBYBSnxRODlV2Q8MITeZUNSOwLhi96vsYFKRdD
yvYRXkk/aBl5soFCT8ihDFvx4mGKRNux0ouHEVveVJ5RJcMFyGAbI4J/L7XHgbXW
PSuY1Zdtnn/Tg0mkPvl9z+TPluxgLUBIvdzQIzcYNsCVL+iNZzjnbfz9qtvWGNXs
63AWYpgl9TdIOUsa3biOl1ou9QS9t35LdNrKg1SMUHOcHyW6gFJI1d4l7XC9vwVN
z8YBWFgUNLUjSaW2N0Cv54XUQS7pAxo74x3R6t7u5QeIIc4JcsxO229bzGfYVGKD
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDLKM3aHoUk41DT
3hOcg4HMYIdu+p6iIchg/LxlzQW2QLADALcqP/u+c+a2ogqpWUC5Ub2o20UgboUJ
67XdfqdiC3fBZ4hFpd9fuy0RYYtbPtYX3DQkqY7U2eauRW78qTKP3AtTuGy25Pmw
trEEMHpWTeeg2D3AdG6MGiiSzQHkPW/S5t9y7UzNIKKsr5sCKNmEmxde1g9z0Aa7
oJPXRLr93Y2YkQcsszX6DC6Q69VnhgC94CFfqp6kRk7DUxunJfNh0cUN2vHIP+0I
CCr4o3FUslldpJrFvCpq9oyBxY1GonpxKaPhxkPJRmGNTxoubffDqwW0IjfxTMgG
djb2ZkytAgMBAAECggEAaeCzH6jmROo/FpvXZqtWuxfXnWv5vo+SqZEt8nQeNPST
ho0Z6Gf+ICyxIZ9jpQyB4dMK3/Semx9eMGRqnKvEOiG14NK/P2UJ/A9Flphak0w1
MawudKj1alLBmTNQe1cGpdjNAm3MIqlEw+cCbCeDqnThcX8g96r2bge3+4HiKXs5
XEN6OrrEZSopKRpp4nx4pyKhbfsd7wXUaCDCQ5r078s2enFkysBY9p9h1wUq9Mtv
a5dE/uM5EuleeCvlXFFr5Nbb6FtlNUMTy8qoognK7Oro+KRNyebZl7mtF7UyCK3Q
+moya7652EARZlEN+ryUPcWfJvgzmoKwN/ywfjB7YQKBgQDuNJl3cOa3OB8+3ROm
PmofP5rveQVU40XOuD/Y33l2aLrEW0Sht5E8iesW8Co47+/Pjjph/XeQrQ2rrxYC
cE6zmBKuW6/QMEeJS7tTRHqaOw9/it023M59LYKNEim97G9u0oH0YgdwqAMcn4Sf
4Z5GdX7c6Sm1JnG5OVxF3CyYBQKBgQDaVf1O9Q8ZFD98S8N6hoVu1TblmQPW5y/L
ALF9F4y5ObNG/0ijsmuWV/gx3aPc3dV3IavQeLiTOP0Zdl0XeUXVF2JOlDFXLgAa
DQFqL3+AIKU6Sl0HkSOtHaYXAXD/w9p78v9nUfxg9IB4dK3tF1vJTXBhsTq8DPvp
V6bNxVHKiQKBgBn4QBcGhxDInJd08NR6D4XSoGilUBB+Krkr20IgsxRWvK31qVjc
M4hfHPNGQcQtXH7LadAPGz75rvjdwM+JQPtRhA/gTR2sddAhIo4kdB1mfP0RvaZi
klyRXp9UsJpVMZzqdGKZYWhF2PkA5yurJF9YJfmdrf9i7pkcCNRQ+celAoGALasG
zNkdS1Wc4dbHEH3KsyAN14Bl+TFqIcAHX+7pFGUpRpRnETZkopHL7EI74BrWZ5C3
a2eU09Z7ujOzzREktimp+l2s5FtO0iQeQ6Oju50YclTTmJ2XJMKq1u0KQbUpoft1
yJqxe2Yo6QkeyBS2sihsdUKo0mS03F3lGe1H6mECgYEApKv46FSIllTWf5OfV6uL
8JPD2D0e2aet1YB+MGGGKRmgP2oEMWV/yqfxljFU5iIWmJHuIOySlj1eflT+O9fx
NN304ov9IffZUowo20DgmZ6RUVq6EXg14zsLZm6NFIngo54YkV2ftWSwcwH8nZRj
YBaBH+vYV9RqHvapSKze534=
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUDQl9lGAFVCp4uzp2CyNIBevz9ZMwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC+u6XURlYwJh3spBKnYAgu2pApo1dPx2lT8MrjWRlrafrG
N+eSEryqlnUzuUBb9ps5RbIB3Ojux183ZzuMal5AJGBMUz20WvoG24bp756Pi+Vw
kbWxw6U8z6CIDNF1gzokIhgUxQOrgcTXM3beR47CuOw9TPsjyHXp8EuOP4hvcVEO
XK9TiqKE/655j5DoWzcR5iR956McJ+er8uUgEuHDGWUld+7PNw7xeKUn22G2rbXU
mdOTL6uqdaKFsLM1Rpc5RYDn99PiSmtOEMr7hApTZHbzMGyQQlrRe44TBO6bAv3L
2c/eGQ1c9vapj3242NS2T498uZCQmP5+XBKQ83v9AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAoAt81WNkFGQW5viqHVOy/
Yrgtm+FP0wWKI8bL+elljQoZv81Ya/sgfw9A5X5+5QcKGpciEg9J2OcE1Xijtah7
tMBS0oqupNw5EgPc1q0uelS+2///K+K3AwM40O3kd/S40Z93vSs/VstkljmgsWfL
0Umpq0Cn6TQLwCnZad7GBA7uUpCameM8Mz9Bqk/5Qtyq5cOepKcdCPFH3NoE+aZX
4tYMWPXMUy4NvFWMsCMWrRAvOs3uMZJwLLSGpV3Z9NElilPcQeFvsSiWCzMITvEy
MipcUFAug6Cz6oda1XkNmK3QOL4ZV9cxNXATvAb4XsE5CHcMiUq1GEFGEd1Nz/L/
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC+u6XURlYwJh3s
pBKnYAgu2pApo1dPx2lT8MrjWRlrafrGN+eSEryqlnUzuUBb9ps5RbIB3Ojux183
ZzuMal5AJGBMUz20WvoG24bp756Pi+VwkbWxw6U8z6CIDNF1gzokIhgUxQOrgcTX
M3beR47CuOw9TPsjyHXp8EuOP4hvcVEOXK9TiqKE/655j5DoWzcR5iR956McJ+er
8uUgEuHDGWUld+7PNw7xeKUn22G2rbXUmdOTL6uqdaKFsLM1Rpc5RYDn99PiSmtO
EMr7hApTZHbzMGyQQlrRe44TBO6bAv3L2c/eGQ1c9vapj3242NS2T498uZCQmP5+
XBKQ83v9AgMBAAECggEAV3Iy+lrxIwwmxhsHTmOx/MFKPTzdR/92I/0PGCL+i4fA
aOayrf8XLuLigz9Y6ZDr49s3XLFKvkb8OauD2sHdymyjFftIHAtl/ITjmxe4S7np
DK5RblnzxSiwQhAWbFko6+4RulwFbbmGZN/8jLakFlSwQv6rWeGLZiE8ktBAHk88
KDC6ZuY0X8YrxRrw4RTZv0VgY7OnV4BLtMj50HW+7ds52e/JOkUm/ymGUAif34JB
EAw/Mv88pGbxIiGYzBKnS/vpNiG7mNYRa4eSGd4Jb5JpFRWyMXqLrN8k6z4xBC+G
6rmh46htuRGf2OOfgXUIcq15HjKfO2LKXh4OSzjtIQKBgQDfDeH+xq2wOTo3vZl8
UGcQQYOcLwS8R5YxZN57SJYm3buljPmD18aXq5Lfd/WADNzOrJ8eLc1jofKwGlTQ
7K6EW1KZERVx4r0Q3rEF4tOtYitR9+LnGrloFVQYqLdVanULNpgdcCUrXnUqXaWZ
zfSbXbjhPEfptHX+QlgCsHUD+QKBgQDa56LOIoLuNOHL8LPSFhyHf21LzG2OOJ9Z
yuL5sq9Ebc/8o9ZGR24jPwsEfd6BBR+l95mnwxDib3zTNcVATe6mkGPATDsEvf5k
7TSyLafKE/6dd5GVylqHrYSx08EIkXb1tS0kPKuc73mNKLjau3kjGlNBV/PrMKv8
wlJBQ9FxJQKBgQCLLOJiUh11439L4GWwh4qHPhmcjknqINC6KTIYwoXN4nR/K6NU
fIJRiKCwBu2L5HqyCkuOTQ3mqNoAv61EXynVNBYpo9s5oDxQFmNmRM3HVYWqM33E
rYwaQZSjfkJGbZJyWLI5TAwlL17z/FKj0Tpa5vPAthg43nzxFPxNUUTyIQKBgDji
7z0QXOQYXAFKmQBkfJ99ruJ+yo2mC0sjXV60X7Wxr9YgoYN79pQ0QuG08AipUzMn
KAgfuhiODms40vzGA9nHNhT3+nJeCWki94nCMZNjJMy5EN1TS7lsj0pDFCvs2XQ6
0/NRzOsolHbpeThmdbF4muAlQh8BdABoY0XQoPH9AoGAZZDDxLNWY+UTH1ZKahHJ
ZBpoIPlkB/A6Do+HQU5J/QZlleMCmOejZGKDmVgC1NW/a+LHSMOUPQwPzo6760aZ
n/Hv9j9wc5guJkkqJS6B5f0Cx/6V//TeYSz+pcY0rQk6jzr30turxl+U3v1tGsQ4
XLGUYqC0VKtxCeINNbcQYpE=
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUNt5wFFEHInmQV+maGlazlOTq18YwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNloYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC9icCXt+50NDRtDYOA9SznDkajEonkL/tWDRgkWPfyrQjs
MgxK4thx8h2pzFFO0orpKhcBH9D/yJ+IyhOzrv9MqWIEXQ4I3BUWQvwUyJiAARbu
Udj51pFZiNcRJPGg29eIf8cJFfSTQ3LyU65BkYjxKScHi7psh3t6jCElxDnou5yY
brMytE9zUzV7xC6wTiN3BJk7A0W/d6fKpOziJ/487IlaBP6FIxUS/o5u8hG9VPXQ
ZCXBWpGB2xLahQS6xANGSCwYKtkFgUeIJLZwX+6+XAYppXthrffos2jKNmXj3GC7
XCKUEfp0rWBxcw6jlJZuOyqHPVOXzAmVlKVPnPQJAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAJV9THcfc7PMB8oJxoL3lu
gP29VWYHaSxblJ9OPsMVtFQEBwa72q1z1pCb9wKWQ0B1Hkz4YBtbYDHLqdsK3xfz
CXAo8zDEk+D5QPPzScWM3R/tK1wYUZ62Y2J40M7G7NP24aNzmlOKZOMOLbBqJ1ZU
vbuZ3XPDDv/CEWv+RkXUjc5ICzHCo+MtOJ/FlMvR5H8j3l7nj8sj4WjrhdqBh7AA
74eHvlVqpIZaZw0HVAtDASJAYO+PTh0G61alVDWfoRmNtCeS9f/CXsNeiOwwWLBZ
ZO0evHv/iAaNk2FTTGwglURsIjphpOnVScLQtc9lDc2dpKm5d9rqs7binU4dupwU
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC9icCXt+50NDRt
DYOA9SznDkajEonkL/tWDRgkWPfyrQjsMgxK4thx8h2pzFFO0orpKhcBH9D/yJ+I
yhOzrv9MqWIEXQ4I3BUWQvwUyJiAARbuUdj51pFZiNcRJPGg29eIf8cJFfSTQ3Ly
U65BkYjxKScHi7psh3t6jCElxDnou5yYbrMytE9zUzV7xC6wTiN3BJk7A0W/d6fK
pOziJ/487IlaBP6FIxUS/o5u8hG9VPXQZCXBWpGB2xLahQS6xANGSCwYKtkFgUeI
JLZwX+6+XAYppXthrffos2jKNmXj3GC7XCKUEfp0rWBxcw6jlJZuOyqHPVOXzAmV
lKVPnPQJAgMBAAECggEBAJlg4fNkqphqrooZR3OR8/Y+fTb1h5Sap38pNYIkZPGC
yReqIHxxOcprrUl8x8dLZZHtt5P3VT/H8CHXtT3QvVQiNelmDDdrMb1EE44WDiJ3
v0C4ByeWVSTpMXD0Pnx3quEQ1dYqaDLLgDdNNFRnGzRcovLeRcwRjwDKaQCQ3HPS
CRWYoomXChI+F4w80g4Ybft4WBfZgaue4hiZRQB9YjyakEIAPvi9+V4zhjxziNoo
xuqf07WzF0gaHqYYOVMVDJzTAK1PmtE1SdmXdZLdsoUZnvEVa2dHp5nABycxT5rF
xxfLkeW+GKrPxlPcOVQY2diah/NuqvnGb8a9ERf5+EkCgYEA7UjVR703+uUpJtmq
vWb1bVTcm+/5suItq7fKHMMOHzDFXsw0eqdPI5TZMxGcFIK6QAtTd3UrDr8UX3w4
XbTS/IobTb3wjGmEiPxAfKfvxTV8feMUCeBNRdwkkqZYJm0oJ3mnisMS97fUhiwA
d1Zoo5aCWETybSDTaVcEmOoQtS8CgYEAzHzXFJRwY8OeZB6RqiemraNistlIuVmm
yqz6KXtV1HT28H2wiSb5HIVGq972tyQaK0YUgJZa1YLApNP/wAB+p5f7zHslqurI
wtaby13SIshUVo2fBkNpfHig8YD7A3ZoXxL8UzoLGINdKtjL+S8FUo6PjAjbWpVH
TNEg4Z0rjEcCgYBZqEqGZ9XOJGavOlHMbSnRHN6awUstL08ocjKZOY6NdIUvM6Ok
sLEzdZu4MzAxg8/SQTVRjuEtGkAdcDdwGNIcACce8eUBeSFODVpkf6QWdQZMHtBE
hw9LlUnwa5AlPNuORuZqhRkWpsxTwi6O6QRyw30O00Zyu5OGWw3upYqYmwKBgQC+
LbD+w9sO/cTWipOgs4XR4a2OdoSrVVTJFD0IzVsS38E2Az9nHyb5vn3upMvBokLw
UhoJSUyrXBJ8eWpXEF660Z/uGe37WqZihqOYbOZdUQEXClmGwrVdfPb6BKHvI3WI
Tqj7YnUlVC8XBVAWrQN/N3ULoMUZJtKL/8db7QeuSwKBgGbbVwgHgBYEzIOcwBL+
kSqEG8dsY7svrAQuFDgVhyFEp1LgYdy1s5arUTrOEaYteqXrvnruX2UdMX7vwrHE
obOkDNevPsSNEFK8hlQVOJaPqhuFeo0/Kes4OJ+tnMnvFDENGpH5fi9Km9jVM4oz
tGS+N31shUJxtPSj+scvrvNN
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIURDIvwbpBQzGaYcY5NjIvLi2K2z4wDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNloYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDFaJpx21ia50KpGQRSKamxsjHUHVDHRccMQlHTD1urBNpE
3ulAJhSiJVx5TAlQCZeaP8xq9CG2I+hRqZDq32JCW2RuJKS0NgI6HU+L5OLkLXYf
MXbZe9rMAoexVHNLxHdcTPBeEJWJhd9H6XjVJ+o0UudooVzUrGbl+xzGUxv8dyzi
LOIisbo9QVPf+MNgKD9TaH0aHSuh7BBd0lEJiV3kDntcBwjqfoC8FWMp9ykjQOQj
OICPVGVwAPo0sox7/WgKoiGQlSyI8als8NmGuLvqXnIGv5M7dDVUZSRIonmiz3k9
xnnc/bSxDorWTzgZ725CzD/8Aev3bJYxbSySe6jfAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCppINk17Ykk89Jdi1blQnp
RYEHvrP9q4BIK9g0nasjPq+GQLoiiJXT8LbisEV+0V54PVHV+Y1wcIMDXVTqhHnA
OpNgvud31bb1XQOoRdbtsS88QIB2ab4/urWLvuHBmksG/C2n7VKcbdeU6+xkUbfm
rPNWiN4vPyqfzz3FKSWbLKy52+HOp6/fQsdoH1TUO7keC9qG5JDLHvsHP/qsJKWG
D8LczKzlqVgxvxUrMdYngQcBlrP8Z4Oz0NCe0AF5/LI0q3YRLpLPLdsdAKDm44Lb
BAe1y2G1jeOvkSQBPWCpW5iTFuW+CMtGAiiDXRhkxdORDvW3YfBCjiWO0tOliydz
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDFaJpx21ia50Kp
GQRSKamxsjHUHVDHRccMQlHTD1urBNpE3ulAJhSiJVx5TAlQCZeaP8xq9CG2I+hR
qZDq32JCW2RuJKS0NgI6HU+L5OLkLXYfMXbZe9rMAoexVHNLxHdcTPBeEJWJhd9H
6XjVJ+o0UudooVzUrGbl+xzGUxv8dyziLOIisbo9QVPf+MNgKD9TaH0aHSuh7BBd
0lEJiV3kDntcBwjqfoC8FWMp9ykjQOQjOICPVGVwAPo0sox7/WgKoiGQlSyI8als
8NmGuLvqXnIGv5M7dDVUZSRIonmiz3k9xnnc/bSxDorWTzgZ725CzD/8Aev3bJYx
bSySe6jfAgMBAAECggEAFHSlZFztTofeMXWFLBpjGiWz4h3zi+KgIJYSsoMp5YvI
LlDG7L3Fb5PdhDgr0t5blkE8Jm0LvTr1TNj8SkpBfUzJGFy1sHLUQj9dScq69Bf9
4HeYsCqUXoV4mBh/Jf/Cuo7CbYzcYfa8T1BTFAthynA4yG/IFcWTmAswTSC5iqyE
ER7bD/Z1hGhj12anKmX4ikMceEW+sXGz93/TC2TrSTRq+C92AFpHq+c/oUc8LqoZ
KWJjYhE4M2qiDgbZOS62FnQgp3/sW6uEelcXA7bv9SvwWM6D2lZdAdKPa8bv7qV6
keX1HEA4iP9wXVCsIsUyhk/H7gy5tjwiVOx9Mp5vGQKBgQDt5mPJDeWnjlqlGjYr
IiPfjZLBF3Q0ot+a9b5WsaCAEB41aXp9NvvY+P3jonzZA9SR2r7HP+Evaf/Yy/K5
yMr0/ZlwV5gUgOgcgy58YZa86DHKbCwV9LCAQlBbb/xyM8nBeLlCADzSare8pEa3
QccJThs6vW1/eGSw5w5WngwJYwKBgQDUbY7PxHultNKxpTWC52Jkg4oC52Wjrcv7
OR2R88m0BG2SQtPJMSTJ++dzv3Z8/GRfuQSSDPe0qUaziQ8qa2yuV41+nBJ5MRgO
5ceXIV1rO3pKdtg5RtTr/PMTBWtFPBQI13cvG9h9gKhBQXzRsAkh6VVLcUuQiTb+
2MvZy7y5VQKBgFK4fZH3ZxdwBEzMZHFzGY4uKA1EHn/+8klrkZeLhAeDkz13Q8Qu
TjwPuBhi845yKoPcz+FwcNiPvwqfP/MhwpCVbbkGfDcE67CeXJebR1LAWi/MlTe9
MXInnNFuixUatNi1JZWxh3SS7viFFqG6GX8+zXELVPux3TE15mJv6jeJAoGAKTra
bRkFprPh8PjP2ghu4HNnZgjjgVFKNghv5NQcYgQ6ABlYYcRYD5wE4EJZDQkvsiSG
7pH1werY/h+sAd+3yF7V560DKOKOeNXAV2TybM2ufqVycit9SBBgXWC/4UA34z9u
soYFDtbZ0VCUmV5BZ4OSOoJS2ErJkc0iQ7N3fcECgYASeSKYrluM9iwIGbu6GatF
vN9lDlx8EtQxIGUbZ3Ny9VzZ4WYdfiVVhmmsdBWCGYrb/iq6nwOaSbaBZXhZ6w4k
Y5zXL+W4i1NK2I6YV17HUXX7ww5jXXNYuq3nWEhdbXso1JkeJAFhRAC0fg4m8MCi
Kv2eTZG91HlI28B1X4ic1A==
-----END PRIVATE KEY-----
"""

SSL_TEST_HARVESTER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIULUbwce/xEqn+x6vr9oE80QQ3d8QwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNloYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQClktgQ/ipScugjip0UN0Ukgkro8RUsfMKWCrQTx2THJhBf
C0mCuci1Pu4+kiJAXUkIs1zzYTE2Cus5OQOoIzkB/dFbn3nf1WSNrNsPKfsSeyoL
EQpBX2xxiPxI6zDzEv6NpwhaKSnkfVuZPn5v1PeXb87KZMLHlXZbS1HB1VcJqb9K
vDwvdOk9D/RjaqwMjlmtShMf4VAprWxtYZoKEvqWTeiBLQt1UVSa2Q8wQGsWHthm
4bpQ/v1VqOBZvLbn1zkWBAvhzzd+yvMK2lzphjNnP5rFJ7Baem5UY9Dg5TP4Xz5l
/gDQZDm/bMrz8VN+IFfjb3Wm/33cGhTQX9YGzPUJAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQDHpjstiqVts7VnJ9fueQb+
0CDiYjSkvfEzNEkRnoBunNW8/1ztJa1RfZlcg5EyI2AdneFNoiKFbJU/GlEeo2M3
hyz2t26/IsMjLOpLMRdTn+lOxdRd7qtC7KrC8/raeRiD5w1puS5miCi+DqRLbUfZ
oY212iyiiPDJM87ubwxFfySMkdKBd6Ai0gIYfHQnorMVAfgbDY4vfuvfzYXWKJyo
eP1LnyTGjcuswo1+1lMCkjcwyQdnwvapi+TqzlS8Ay4lSnbDhyK67jUHDZDNOuWu
+oDWpIWt2PPpJZUnBQu7XbHNup91PaWG3lGokssosgybkvZoNKTKtpe+XJDZ7j8T
-----END CERTIFICATE-----
"""

SSL_TEST_HARVESTER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQClktgQ/ipScugj
ip0UN0Ukgkro8RUsfMKWCrQTx2THJhBfC0mCuci1Pu4+kiJAXUkIs1zzYTE2Cus5
OQOoIzkB/dFbn3nf1WSNrNsPKfsSeyoLEQpBX2xxiPxI6zDzEv6NpwhaKSnkfVuZ
Pn5v1PeXb87KZMLHlXZbS1HB1VcJqb9KvDwvdOk9D/RjaqwMjlmtShMf4VAprWxt
YZoKEvqWTeiBLQt1UVSa2Q8wQGsWHthm4bpQ/v1VqOBZvLbn1zkWBAvhzzd+yvMK
2lzphjNnP5rFJ7Baem5UY9Dg5TP4Xz5l/gDQZDm/bMrz8VN+IFfjb3Wm/33cGhTQ
X9YGzPUJAgMBAAECggEAVfN90Ixwoe5ejZy2YDk03nf4tSX5bOezB7q0spPOwAcF
dqFgXslc5KGvgbHQsAL9F9Qsi3dH2ZsfcswjFtR6EouVc++8j7KyCU3TRfLwEC75
q1cEMN19aQ7IkH3vIjAZDqXIEy3NPnzI4Sts7Vbr1KRJAA4AgyUWlNvrrCi4jx3G
enGpjvH5yxaYDAcREw8tS6l75hTsv9hS+1x0/6yZOanEpOuODHG/Qh0u6TzKN+8v
vXslqpCB4XMYiqWMQavyf2qU75Ui6yAHjw8mbdHjFPxequqDJJnsbEcNM5nY0MNV
9ezUD1M2c9RCj29BFU84yZRMoGNy4ddng3zMFKgJUQKBgQDVOUPWzt46XKWy70Tb
/I3uWr3WrP9BhPSguj3/GRI1xEASC1HmiYgLitla037NbPYlVjRpBk2O480aU79Q
3R73tB+72i2O0pCpV7+dz7vaXLQwHSl/J5dYpvGxrZS0nwiF5K1HR4KSjlBBU8JO
unEPZ9woN+jimBw6qLCtdlL3LQKBgQDGyl4kX7JYms7eR7h8E+HtHF0W2czxqOey
6HTNYQEu9n8c/ByDF+2WTDdZmG/9xtN5+ECi4oyOhe1d0ojqfboJmTxjKBH4QLER
lErySryUB12hjBb6cp8NmCtyGIp82J52wmIwmQ7CGZ8PKZhDeqO3gxl5mWB9eQ3Y
3n0N5pTezQKBgQDOZrCUr4vPUv/TRmqRyNhbcttxg+VTtzBWpfJ9jfditKaQ0QRm
9ZsMEUx172U/1cowOlJhmAhb2YghhBAeZu4jOem+HmUbbBk81ARY704ZAsQqDxCs
Vdbbqj8sj6rzbT8C3WofJcnvtHNbyYi+TRxEnXUwOW7mafhpkAH26CNHwQKBgEYa
x+h79yFYNuwczuqy+FHuVsXgOW5f6pYldEuZkhlFxL4sCsIQhjEi38IxCA2vOJUi
/2hyDK+We4dC4BYSELGh4LH3R58M8WUJrwSTZr2te0+lX9Ui5wScTXYHQY+VtQyc
sJQC5jl9X6KxQIlLjsEA8tL3TBfzwPZiQCfO0WFhAoGAZjPcJIEE5il2JzfJCAi0
7Hdi29v+DfgRpzfLu5C44yokAh7qycFIr8k2vzYB7LeHViek2f0nTHZQpXk6hW6m
C9gT4M4UGNNoMv1mWpUCsm8qUpLGA3uJ/xrQE2ZNdWwOI+sS5wrgBVGt8VMlvNGQ
uwOu5JxCkWfK0JQH3DJaOtw=
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUPASsrsYzDmz/DkwIqjt0/8jCYMswDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNloYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDTC7KkVFiP877ALH2osPDSkV0+ElIk6dTIJ4dnMo6Caxq+
iL48E9xXK229yKBayaUHny75umllbXpAv/WpHDR9PdK6sy27d9PFRxIgysDEwNIG
AdfnXtyDnjuL2AUMdXByBUEATl3t3L0fFe1CZOQRnTdpr753tgkUwgnycWhYKlDN
FwkBG6OBODhwwwZ338Nn9G9kVWwZe5kcDxLngrYjvm9oZoGtep5zO7GJi+ccppul
LCwzkstJIfi3U7IYEEeHHn+r7jZb6kgFv9EOySfzPqWukkokA7JcQvoggccf+1Dw
12pQ/wCLDjy++8bwsCh/BlbvUvaQUBbWFhw7egpHAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCnaO8umnXPXwTOJiWSt2C7
hP3ybwzmGrPo13RXia6QvaSH71QwYUi1NmwmNUVgRy7y/8uOEIVf8bXqa69I+b9+
qviIBgk45yPDfbCHGX5bbd2qV/XyYybT2X2FawTM7bN9gVU/EjMrvu/VAyiW5yYl
/O4WO+pvnThlXiEAJjgT1T8vXtf+YjxSfhuRfTRK1AW3SQCtYw09mREjeTCThlFN
zeAtI8H1VSgdUe+ATJ9wWDkqDSFP8Jof8Jv0aT8oLFfXrNCff+nTWPEpXkMqwoxO
wIn7lnNJMpehGLgCm/6vtoT8VvQUvcViKIkijwI4VcoK1tRWFURNm3YQZ1586wo7
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDTC7KkVFiP877A
LH2osPDSkV0+ElIk6dTIJ4dnMo6Caxq+iL48E9xXK229yKBayaUHny75umllbXpA
v/WpHDR9PdK6sy27d9PFRxIgysDEwNIGAdfnXtyDnjuL2AUMdXByBUEATl3t3L0f
Fe1CZOQRnTdpr753tgkUwgnycWhYKlDNFwkBG6OBODhwwwZ338Nn9G9kVWwZe5kc
DxLngrYjvm9oZoGtep5zO7GJi+ccppulLCwzkstJIfi3U7IYEEeHHn+r7jZb6kgF
v9EOySfzPqWukkokA7JcQvoggccf+1Dw12pQ/wCLDjy++8bwsCh/BlbvUvaQUBbW
Fhw7egpHAgMBAAECggEBAIJZcUbqCaEvrRtI33v3fWaw/eQ+sJm4CwJs18a3hSms
OWKBVu4IXklAu5FCfzhT3ygr+3mm1z4cNiwT5AlFMG5CZwuFa7OkORpZ4Sp70EA1
0AKB1PZEsvJgIusmy0d8qazi7djgjkdB1VWD13zwj6UJc5ZFQ+Dwf/9gMYCa5xW8
PR+Jx83n3hKUBfzeUQckWUH2Fj3u8CWIRJMvnFoSYxL9/m1IsyyLB/vySxowTsg3
iZoc1t3n/xsua5E+UUYjV6ykb9vtkRYopZM2yv4POhMqVZyXTJOIXNbY2qrUDX1F
CV6S+44DcBkbCI+UvJSMfZJsvp70NCzqQD832cEyNWECgYEA+usZ4qTgyr1X+g9r
yVdJqLB1d+Lw8r9HnXnfXToI4FqZ+6eUP7Spdbl1zpxRdpSCoUKR1E4k49IgArCR
o1axPRrhfq0EuXh4r8uXhtaorDk0NsXQz3naZaSj9sAEDFW0TE9Kap6uDpJhtSfU
Bn2PKXfcNTp5i1tKqx10e9sHelkCgYEA11Hf9eEVMPZ1RNAXlycNyQQTg3o5y9uZ
H1g9cwHws6ND1m5x5Vlm/nWuuEJSH+4WlYaF2JSy7Cms9MBBDH0DUzrLEpNJYo4n
fJpct9QpYyKHwMq/OGRiZOtlEmffnfe76ijT9UFEZZdPAZWuB+hWx0DhFzJ48Fq8
wiqysj4x1Z8CgYAPr5zZp1cKNZYHYulpF9TZ/9YIHZ7UfhK7DIBjMpqVc/SGX+6L
oP6rBmIP/YO2NwiHjkLRk+UIfP1VTbZ9EJFZ8ZFBOw29joN08fRSEJ9QzO6vseQg
5Ew76HP7m/tkzgLMdnR/f9X/wTTsf0Xo9fZ6MC0LAtHQXW+ojNnYWFP6WQKBgQCC
4hzuHCTCf32nF4rPcYjaoOSvrfNF7LV2LTAlIY/L0jlhNf97t0147dYH4SCEkjge
KghgL3tXPLoKiHbB/Zew1vMr1mXsR5bPEhG8GHYT8aBtW5DC2ZpJ2CC3AHcYUcdj
PfAhi8vkqQX4Y6DG478kHVb1v9Nt3uoQaN34pP+r5wKBgQC2rbz81o14rH/Ss8Ci
s0YphZ55R+2VVj9lv0Bd2ea6J4qRG9ToPa6emk922v+b86s7zCGCCkxgC3nAK8U3
lg8KyOb9f+25S3ISohpvc90L/xHxUZcKA2OtJNz8U3AIp9f5pLyK2LhcROALfbPf
pIqiH6TZyQYwl2/pDJtLpW/6rg==
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUfp7Qhve3TfaAj3jjcY/WUN1nozMwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNloYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDN93Shy0G+A51fMBzkH+j0LwpNhKMTMeNxsc7QpqwolyAm
/KBvbpFYO56c0o7zqNU0PdyO7D8x0qX19znVdXsYweEMhM11cTl3QV5QCjN+ldQ1
i0APjCmColWk9hfF5LX136jLurHhQrMaMTVZj7s6m9Zun7t1FOKqCliCGTP1mSPK
E1uxZi4Y9XCGwTjb6B8ffmgixPMxbb91YxC9FSa8m3iH+69cQ+edqvDCbmZrnJf2
5qVlKpy3fiavqmrKcuD9eYsfngyfgMGb13Rswpd+gfaQP/gWUwSNX7VaHU97wkCN
OwJ+VX+4hL7rxdpprYrkiBlWoA3hUxhjtzIDyhN5AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAz/00Fvtg1+h6addocNGW/
y4RyLP14YefUkyBDJs3kxcDq2HvbzACc4nOMvmJ7QkE/TOCfDGCv+3pFd+a4SHdk
ifCI8YXTY3dv14CK4oLnHCCffnM8bzSCd0s6aTjYvGkiDKVOC1K8bcGBPjCsqY/U
U15vlfHAOkN5wYbDEFcoN/izozHOFiY1z5X+CBdVSXmqQv69jqXzQyLr9ul6v0gO
EOoNyl/yqfvjND7ytWcksJOM00ogVc8mdbOfVddq5od5i98KRwcDni79GXrELs66
ebCJ6M4lmzuktRiOzOskQmaXiVgYXYtR6EsQl1bGFv4jnES6l1EyJxaae9lm4cvw
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDN93Shy0G+A51f
MBzkH+j0LwpNhKMTMeNxsc7QpqwolyAm/KBvbpFYO56c0o7zqNU0PdyO7D8x0qX1
9znVdXsYweEMhM11cTl3QV5QCjN+ldQ1i0APjCmColWk9hfF5LX136jLurHhQrMa
MTVZj7s6m9Zun7t1FOKqCliCGTP1mSPKE1uxZi4Y9XCGwTjb6B8ffmgixPMxbb91
YxC9FSa8m3iH+69cQ+edqvDCbmZrnJf25qVlKpy3fiavqmrKcuD9eYsfngyfgMGb
13Rswpd+gfaQP/gWUwSNX7VaHU97wkCNOwJ+VX+4hL7rxdpprYrkiBlWoA3hUxhj
tzIDyhN5AgMBAAECggEBAMRjM/Fllhzw42g0vweBqaTTCZbaZofR5NWuvc1TbwoQ
91ZVQUCfA7VGu7k6R5XrIMd8SMZ6WtNN0HLUNW/kYeg8TTKbmjBmMm4UhTH6WBlW
EY6wZPeuJJJr6Q+umwJVTm7PwOno7N0ltRK/Yugv1U1P9ElswtgjfvC1hqkeEN4W
W8LPHGoqavqP9DfPZXyzGuX6yJkC7Iq2nxEGy9IKIbFHcAYAI5OLjWUCAsDJQyiz
az/iQuuqsuwpBWZKC6aXG+jgw/hoT5IIXwjtEFnCWOkfUTlOXcBYa7NOEhlNJvT5
4RJThEkMBxy4zJ88OFvaBQcmmzruYersQ8pYC69J/FUCgYEA/oRtq7Vlbm/MkD4l
yuhJaAn2tk4mh4cp19V2L0Psc8NLBSVoneZGDMz1ACDwCC+Sv37oNyIy3Gfjzhpm
OngX7c3roFmuqDHwy1fm3HEadHXWUAwHZG3t8eAQIPzAd9da54oYoiATyzQDxa/2
KY4Wm7pKkXujMg/TGDVeYkDrNM8CgYEAzyqfJe2HpzH7c9tO5srPY9SHWBSWRRmd
C9ZKE+NhA4SQvDgHhOyXVrGYLaLM6BTF6wWDVEKPRjNYDgBBJ0DIBNz4SwytGFvQ
ytSrGp2rydNqkpdxypZ6qZjjv4ORUf6NfwVRzC3lzo2jzW95xq02kUvPdVtFGt6n
YSsdguv3VTcCgYEApXWYCnGxkBr0JK2SShe6aP1ZOukRWTgAdsTZwR5qIFPMeHr6
SPRDg9zWRZAkG146C23ILtd3sxuC2CEHZmlePQWKccL7rXJR9Q+fEJ4isaVNftpj
D+H7NywPsDJAOWhyO2XmX7d0xrx421JqOFeb0P9JrMxwqoHpHKrNQhisD7cCgYAD
XDaen96uaJIii/EYrztz7BOR6yuQzVyNv5kN/4coTnMmimYc0tWVk2Xbf6OBNC0N
pdY+fKHkSproBzsHTvavlYH1fawlFAAr+g0YbmxF5sb4v7oZxh0ROSigh5rI0K8s
20I7ZJcwpX19rIw2G8Mh0i/4QFW7nNbsLY3Z/MfTOwKBgQCi7pEysIDuE9FUm0H+
YMKLz2ZoYNhGiTB3/rnngFzb9BG0BeCa/0EmTBRx8oS0wrzWxnbvJKb79auSmQ0i
9M52BymW143fGdyO1p/rxI8GQMeSmzZq1AC5upAxWGGxC5GZ384A5ptJS/fcwbOq
8hJXghpBvRcSCfQsLOwHA1OFeQ==
-----END PRIVATE KEY-----
"""

SSL_TEST_CRAWLER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUY8wJZA8KJ65kDzfXRlw/GtLkNLAwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNloYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQD72WS1saIIDnLCq9rqmzXiyHJxMshwXlruH68D1kLKPpjD
L/E9u1KacaRr22g17yuJvwumRcGsDBEN0g3uDPQ8c1EVIuobm2pRd6nmTTrKWO/W
T2TpEQxrs6U1A5/xpkkCItn6z9V5ukSyFA68x+WDY8f7EEtwsJ2dJMx/7MgtXaab
ywapOA42YCX5V8vh1848hWw5qBLjz3JtmfqjMAEMLP592Wpqb4EjIw9EqUEAkjBo
JeJD4H05oFMfRFcA/30n+SRBCIAw8rvJV9zky9rbh7imLOf/EEGwvntnbZo3Mcil
Q4zvV90HGN7RZim+NopdhwnAyZ8ElXCDIL0CJXqdAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBca+x7FGg99wVVnCibFKCi
MvFM/csSYRbdIU2SEc8Odudy7o62rOnuBv3Pvt7hTNVcOFl8KjWAkDTheNqD3RdW
GAf+7XIuyHm6icXFNb4ODeLbIZwanWaa09hOSLfMkXUWe72zkGRw5Y7IK/vSF5F4
hFlPai5p+YJ+x94quL+mZM8sBgOLlY/YhWq8PUqEti+w8+iwHtgOHIks3XW5I2oK
0aCcCbx6gs5XNr7iYzKIi/QinICAaXjm9AAIU5D0u9GLFm7YlWajMG+p0s0QgZlJ
KLa2WhXRqWH0i1g2xTaQ2Gr8+PyM5Rb10+DVFoREO3wXWuQpsSBPKAEpjxbGKBRB
-----END CERTIFICATE-----
"""

SSL_TEST_CRAWLER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQD72WS1saIIDnLC
q9rqmzXiyHJxMshwXlruH68D1kLKPpjDL/E9u1KacaRr22g17yuJvwumRcGsDBEN
0g3uDPQ8c1EVIuobm2pRd6nmTTrKWO/WT2TpEQxrs6U1A5/xpkkCItn6z9V5ukSy
FA68x+WDY8f7EEtwsJ2dJMx/7MgtXaabywapOA42YCX5V8vh1848hWw5qBLjz3Jt
mfqjMAEMLP592Wpqb4EjIw9EqUEAkjBoJeJD4H05oFMfRFcA/30n+SRBCIAw8rvJ
V9zky9rbh7imLOf/EEGwvntnbZo3McilQ4zvV90HGN7RZim+NopdhwnAyZ8ElXCD
IL0CJXqdAgMBAAECggEBAKw5qQ47cFPUFZSc03MWOw5gByr0EHAPhl1LG3MjRb9q
eSsZkP6nKEDnsAn2G9iuOvbSx9On5l6STeNGnzIId8kTDwLGQpQoftdBXtVYQPj5
QuIqnxZnCzhnvHV5ihpFna2xSaGkGRdKUwn4f2+Hv6NPTAWbygtBLDe3X4Wn1eh2
xFwFCCWNcA1RMX56YI5MlLSU5dwiEZheC/6TFQnKUS0cRi6bIIVhj+BGeEyHD2Qy
GillQRAW78xuV5hZrkiiJqMYL8WMlMcLpUi/OD81STxjYvyTW/1I0v0akSwf6Nux
izpTnnrQu3EMOJAUqSU+5CRDyTMYnNreNInJiTxjNSECgYEA/1oHlXNZEObnfiNo
nnp1GoVe0PjetSFdCztv62nvy0JkVjBCwSD6eWsd327Qh2VmRfTt669F67G83Uvi
Ea3P8WTdy2RlMztdeAB6McoiwwwxwJzIAjDPsr2iAXRdhlQL5/Q0qKsAzyHyp3BI
rIL3w/fp11DA6wSqnxCFc4YReNUCgYEA/H0WV1wZUutahnelJHRuZoD5P+1z8W0/
OeapPHy4Z5nlhON9aENT28Dq8qQ0yxzA+6EYkRjW3cHGObl9QFBJherQEWBPxrK2
75MIMfQQ/+adZwpecgpLFwka/VjaLxc2LMFDqsK1Qc7fuyOZoR2QmU9vLun3SAyg
WkgRadyE3qkCgYBbZD2Sn9Yg1oPEAahQEEQZWeK1qF0NNwO2IW/NMf1BImIG9v7t
YIBFNLFcZqz7yK7yGteMow7DbLnL+nzPFwZ1v0Qip6wQyg6KBKG3cEFAzfyAk5yC
LDYqIvT40E0o5qvcOOsf8xQ3Dk9q3iUkmTtUSEbJaX2in+jxRVh+IF3ggQKBgFm8
K0CJHwb1VosL4sl+B+6uT+eEgPyBE0OE0wkIWpGXhJciMuPnadpkShxKd+joIz5L
Fuwao+LUh5rkbbt5zWem+KP0UuYPhizHWNZII/KPB8ojSUXGmsFpHwqDlae+3CYz
2dTKtpjY6XMdR/CXDVkvfhhyVsxokGUF0AqLsT1hAoGBAPjuyPvZNKkK37Ev9jyP
PBk3H9mCDAJGti0dxH7xHHBBdC4Ukndvk137u8DzTT+RL8U8JWaBNb8FqpnCHXWZ
rl6HTJfPkmazmNRvaGZGutLOcvDNdUTiYs1oq+XA53otbTq1UrQKdPH0vC9DjAC3
MICafGImbpn8Do7jagO6z6bD
-----END PRIVATE KEY-----
"""

SSL_TEST_DAEMON_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIULEE9q3QPcGx/aF56Kcjpmm1ioFgwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNloYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC3vG+t/eMT7XSPOqYmHBKFP7McTUIanto6rHDJPqU8A8Wl
7SexsxiHFxHDCRzy9Khcy4UR45LyfVKl3CkZJtV9CH6s08iXjmEeaFodkwOcPpFV
Bx48Id8Wcru9623+4zQJxrTRZXH7sKoTggSn0r2yAtCMzLiiMkko8EmRi20O79uz
5L/TWHKSdf0wm9re9H+TeYDdew/A8t8H5PCMNaNO+QNSWNDTCc+ChLdFQupbqWSl
3SpAvTkeGH1XjO/dxhUslzHrv7c92ZjvpHm8m2etcGP9VWW/6Lsa2/jDZaIGlc2P
z+2TGeC1E41wQNMXZbCnREjIvxlH18jknyxpuD/zAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBlmVB8gJE4++G5jc6nSW8v
sa0QsV3RRdPmBAAgY8A8L/7ACQZ179DmsXOkq760XMBftt4klfCznvD60MHxGnqv
PwIA1Y7TvhAK0WIiS1hgtNs3owkTx7jUfYmgaFmNMSdffod+mtu9VPzc7PsJgPpd
92uWyGDhoQcIWe1hqCWQqyNUI1BtX3LY/iIJRSKXpBlvGm9iPVzwyUNwn/W/Fpp/
nw0vwbvcgdvLzWi5gWxfLI9gTolr4ptKRlXB2IhmGBI/u1FCJiIr2qTuN/A0YUzj
7jhY0gEtutoz1XR9NXBhu4Y83ipJYcgHpRp8umv8HABdsSFSaOHahuYdUtnEPN8i
-----END CERTIFICATE-----
"""

SSL_TEST_DAEMON_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQC3vG+t/eMT7XSP
OqYmHBKFP7McTUIanto6rHDJPqU8A8Wl7SexsxiHFxHDCRzy9Khcy4UR45LyfVKl
3CkZJtV9CH6s08iXjmEeaFodkwOcPpFVBx48Id8Wcru9623+4zQJxrTRZXH7sKoT
ggSn0r2yAtCMzLiiMkko8EmRi20O79uz5L/TWHKSdf0wm9re9H+TeYDdew/A8t8H
5PCMNaNO+QNSWNDTCc+ChLdFQupbqWSl3SpAvTkeGH1XjO/dxhUslzHrv7c92Zjv
pHm8m2etcGP9VWW/6Lsa2/jDZaIGlc2Pz+2TGeC1E41wQNMXZbCnREjIvxlH18jk
nyxpuD/zAgMBAAECggEAT/t+nj5ESJt4vxTn2PUlds34+VwEZ7Q5CYuheWmE4nA9
7PIk8m0lQ0FeoQlpibXJSMPrxJLNmDPH8524YlOOYeR9yFxVGOyJCISinfcufiia
eWok1kZkZ9BAO/etpWRgddUDR5gim08XanCR+EB8BW7GPFSuFyVOxbx8Ohh4vCQe
4vnwxYVsYPLDRK50C3Pyfs13G9Jsy+RZtD4Sn65u694kR/BTIBGZtE5JBbfGhcTZ
MU3v4CpWAH8Q7uaZ49vF6dk3GKgDDZiDts2nXNeBqd27tKwjLoR/nmf5ZrovgI6Q
A/cwj3PMyNAtk9+JzwyMEuJZLcgp1a9pDxujQ8DN8QKBgQDlKDWQ9C/OLWEzLL8g
LjvIlMN9/S0O1U1R6Jrk9HT5MsxJD7NXxpVIXSNJZ6W5t4WisfyJ1EhEZdixQ5On
OqytQQRq39rvoRdlYrOMW7cRzorWVsSK8T5c8YRHI+tmyh0M28cbo0K2Q/NpKlV7
A9oU9EC+OSZ/Br+cM4xOki67mQKBgQDNQi0nJDvRrg0PpzAvAyskpGv20os2zW6j
XJ1tNz50xRjVFwDv9/ZrOMyIJgWHmMavx8EjPGKF8g4Erps1ktoAobQq8pjOIWf7
FByrtQ3OPEvl32wXoa9h94/sJARmjYJbqKwhPxAQQt5PU6Eny2ogq83xaXluww2L
IZxjbuzvawKBgCSSLTJL9hEmZtu+6WWeW0Ygj65cqEM0wVkwEQA3Dy/x7m4+hjWc
6Jga3RXK58Tix/31/8KTUVExG8r2aOsITyR7OtQ/k3YotE4m2VauEGJUHw4j3Mv7
wiMdHCoqTlgiK06xCG6duHjUEVWYPvoZ3ET50hdJkZ42GoA4Lc0gQTsJAoGAOtPP
mxtAZb0Lk0PohGDVGaBiLRB0w9Um830UxXuC0/a1QkVgiGY54ssZm5/CD/XSZAjN
KusglaElMWRVqYoYHvw5ZeG3t8RNR+GgwfmXJleTrSNWmINHf71zK0u7UyUVim2S
P8kSMobnrjaaxov/M7Ppx1niasNOe2S7rKfbElcCgYAJFNYj1Au/5KEiY2FCIHwt
jeXNZLsCr+SPrsKSCeSafHiFlhcAr0aEBtD/Ua0+pV6fqeF5chPic93kiyskOKoa
1GqSs9WdoxFj4sWVaqFKB+5G+m9Tg4sthPNiC5gGdpRZPf0DWUys9y2OehnwA4+b
481YNhEqynDR87Wq71qZXg==
-----END PRIVATE KEY-----
"""

SSL_TEST_INTRODUCER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUbQFwdJUJU+uQu6TnBtgwRJEi7wEwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgxNloYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDN3kuiEl8fBuuVoTMZzBz317N5YG3fo2nA72B0U9WnL/2+
sJKlNZaw470ySXMzhTnoqUDMIwQEQ5Rg1A8x6HXfbbji8QRLXuLzQjAQ4FyWut5J
7CYx77zmIIm6VFkiIYVe3HTbPCXT0B8NO1xZKTSL8paxZMhwP8ayi5HrA6AhDjOU
YV/wuT6J0LKhDmYzmYQ83psJRjByuVusXMME2zNqDVFWntaiYisOTCHLLHOwGpbu
Xl3bjANI1h8krrvlIuPwC6aPsKTFn46gSVt6knt7DHsx2hb+25yiTp+q6GZRdowI
nesrczxajB3JCgkMZ9PAwYLZy6+0j+W6O376K2lRAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQALkQ8XNZHvx78zevHQduhO
2XETc4jnJgckpNvlytugIO5z5RvoGk7AGK8JLoxJFW+kU4qzGCVdZkskv8wMQfvu
+MNfRaMRqNvopXaSXRToKjxYp4BJCyiwvf6vaN7TVy46LVANv+lC6OPcLjmhR7h6
ZrOTrIiPl0U/Z5/2Lj3rRsYXsP5zYwQvnlH6xRoV7Vvy1/1JvJpn8pDGXqP2MNNS
RQvE+pTglxjjy8iFJo0ZUrjF3McGsC6OfAzAjM/ZVlzglko63S7VLcMlwjofy4OH
KUTPkS2bMqOmWwEeikF+7KfBCTPBNPj0Z5jvlaUwBt47PD/bLeaHD/hfcZn7yL52
-----END CERTIFICATE-----
"""

SSL_TEST_INTRODUCER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDN3kuiEl8fBuuV
oTMZzBz317N5YG3fo2nA72B0U9WnL/2+sJKlNZaw470ySXMzhTnoqUDMIwQEQ5Rg
1A8x6HXfbbji8QRLXuLzQjAQ4FyWut5J7CYx77zmIIm6VFkiIYVe3HTbPCXT0B8N
O1xZKTSL8paxZMhwP8ayi5HrA6AhDjOUYV/wuT6J0LKhDmYzmYQ83psJRjByuVus
XMME2zNqDVFWntaiYisOTCHLLHOwGpbuXl3bjANI1h8krrvlIuPwC6aPsKTFn46g
SVt6knt7DHsx2hb+25yiTp+q6GZRdowInesrczxajB3JCgkMZ9PAwYLZy6+0j+W6
O376K2lRAgMBAAECggEBAIFQFtYRECrfH+/3N7AGpFOR7Cxbw+hsLyt/sWigmF3S
KWM0aojX5nXqN5d0x6YfE0bvucIAZK+A+5zu1zSUPiZAN5hlqDrnuUrv0l1ncQFF
FAf/C+bmHhO3cIvYG7zyrWHuvIBRgblQy5B2LwXaeiVGFh4LnlPT262fOeMTfewE
bR3L3ZjV80yw571TbojTNxIESu2HbCssRYjvzq4AJwxrQLh8brArlql2Z2FXOGT7
py/Mt7dqkEO4cVL0LxwUX5pHZgHW2o1f67PG8uNGXivVwRy647Cpeiwbk9OSJn2O
cPNtoII+p98MBHXMaRnWNwhg8mNRWEpsAIp9GooRY/kCgYEA7HPspUOV/vRgTlWx
fjbmQ5c0lT6dM2SQmL4nXCtdqEWIVc7znzwHViakCBh4ivL7M+ibPUJAfLtzyUSm
a26DrGHWqFtUifVqZHpnNMPeyCaJtiEJB/4AXkNu8A5VJQqHqzSZXITwEmUPZn6Q
1yaYayp/i3N5AjvlZkVIQ8HKqR8CgYEA3uMbvjd1FgBZnbqlWu6ye2gKYdFDIK9V
WGVwJW4GkqONvm0oThHNpiVgh7JJ4axLYIN31YNahvLRzkkrVngRYeBGhyuiwms/
/a+clZ30wHZ6Wy7EGJ7K1V0iU4SCRwmV+OIOW7t5gwAfM63RfsWjhhjpx7Z/FO1w
e89CuaCN748CgYBWh2mvZNdMUMO5hvSIOrDzRS8x+pLujru3mcavnRMOFDv7ItvW
htIsfcGDUOkz+A1jhpjgxxDwVGzf16aLJAs9lyRFwf5i6hOAJ6cDETbCyg+VPeuf
KB2cYVMEuEoCXyMczQfeaqusH52OJXz9rxsSBKBeOOisn5yoW2xBl3aBgwKBgQDU
UubX0n6gYd786ZOhxyeRdbAGNNHMrhoQJjmp/mEWieV6VQQDMuSD9LE7MzU8XORF
YZfjdsjjKyeAaqV1LtXoNj0ZgREAQijoYsU4pgtE2NiASlGV3pb8oEcV5nIwd8o9
GCNzcWk0yQXwNhIOwPmgwdTaYlg3OGViHDPFH1R2swKBgQCz6rWtfURb/HJjrp0Q
GkhOBZ5BNaKNyrX/8XgSjoEHgi/d4WLhdcBCSaHIQg71u/qbg7TrH5M8Q504CpRV
zT4ntk6U3sI4WF0c4lmli+JNw5JiIrq+FJLBqczO5VpujUOBLf++UnBQvxi8ThVy
P3vN0OIo1UZaNRW6CpZLa8sOyg==
-----END PRIVATE KEY-----
"""

SSL_TEST_PRIVATE_CA_CERT_AND_KEY_9: tuple[bytes, bytes] = (SSL_TEST_PRIVATE_CA_CRT, SSL_TEST_PRIVATE_CA_KEY)

SSL_TEST_NODE_CERTS_AND_KEYS_9: dict[str, dict[str, dict[str, bytes]]] = {
    "full_node": {
        "private": {"crt": SSL_TEST_FULLNODE_PRIVATE_CRT, "key": SSL_TEST_FULLNODE_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FULLNODE_PUBLIC_CRT, "key": SSL_TEST_FULLNODE_PUBLIC_KEY},
    },
    "wallet": {
        "private": {"crt": SSL_TEST_WALLET_PRIVATE_CRT, "key": SSL_TEST_WALLET_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_WALLET_PUBLIC_CRT, "key": SSL_TEST_WALLET_PUBLIC_KEY},
    },
    "farmer": {
        "private": {"crt": SSL_TEST_FARMER_PRIVATE_CRT, "key": SSL_TEST_FARMER_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FARMER_PUBLIC_CRT, "key": SSL_TEST_FARMER_PUBLIC_KEY},
    },
    "harvester": {
        "private": {"crt": SSL_TEST_HARVESTER_PRIVATE_CRT, "key": SSL_TEST_HARVESTER_PRIVATE_KEY},
    },
    "timelord": {
        "private": {"crt": SSL_TEST_TIMELORD_PRIVATE_CRT, "key": SSL_TEST_TIMELORD_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_TIMELORD_PUBLIC_CRT, "key": SSL_TEST_TIMELORD_PUBLIC_KEY},
    },
    "crawler": {
        "private": {"crt": SSL_TEST_CRAWLER_PRIVATE_CRT, "key": SSL_TEST_CRAWLER_PRIVATE_KEY},
    },
    "daemon": {
        "private": {"crt": SSL_TEST_DAEMON_PRIVATE_CRT, "key": SSL_TEST_DAEMON_PRIVATE_KEY},
    },
    "introducer": {
        "public": {"crt": SSL_TEST_INTRODUCER_PUBLIC_CRT, "key": SSL_TEST_INTRODUCER_PUBLIC_KEY},
    },
}
