from __future__ import annotations

from chia_puzzles_py.programs import (
    NFT_INTERMEDIATE_LAUNCHER,
    NFT_METADATA_UPDATER_DEFAULT,
    NFT_METADATA_UPDATER_DEFAULT_HASH,
    NFT_OWNERSHIP_TRANSFER_PROGRAM_ONE_WAY_CLAIM_WITH_ROYALTIES,
    NFT_STATE_LAYER,
    NFT_STATE_LAYER_HASH,
)
from chia_puzzles_py.programs import (
    NFT_OWNERSHIP_LAYER as NFT_OWNERSHIP_LAYER_BYTES,
)
from chia_puzzles_py.programs import (
    NFT_OWNERSHIP_LAYER_HASH as NFT_OWNERSHIP_LAYER_HASH_BYTES,
)
from chia_rs.sized_bytes import bytes32

from chia.types.blockchain_format.program import Program

NFT_STATE_LAYER_MOD = Program.from_bytes(NFT_STATE_LAYER)
NFT_STATE_LAYER_MOD_HASH = bytes32(NFT_STATE_LAYER_HASH)
NFT_METADATA_UPDATER = Program.from_bytes(NFT_METADATA_UPDATER_DEFAULT)
NFT_METADATA_UPDATER_HASH = bytes32(NFT_METADATA_UPDATER_DEFAULT_HASH)
NFT_OWNERSHIP_LAYER = Program.from_bytes(NFT_OWNERSHIP_LAYER_BYTES)
NFT_OWNERSHIP_LAYER_HASH = bytes32(NFT_OWNERSHIP_LAYER_HASH_BYTES)
NFT_TRANSFER_PROGRAM_DEFAULT = Program.from_bytes(NFT_OWNERSHIP_TRANSFER_PROGRAM_ONE_WAY_CLAIM_WITH_ROYALTIES)
INTERMEDIATE_LAUNCHER_MOD = Program.from_bytes(NFT_INTERMEDIATE_LAUNCHER)
