Must Have (Blockers):
✅ Core API functionality - DONE
✅ Authentication - DONE (JWT complete)
✅ Tests passing - DONE (142 passed)
✅ Better error messages - DONE (Enhanced exception system with structured errors)
✅ Health check endpoints - DONE (/health, /ready with custom checks)
✅ Request/Response logging - DONE (Integrates with Django's logging)
✅ PyPI package - Missing (pip install django-bolt)

Should Have (Important):
✅ Error handling with Django DEBUG integration - DONE
✅ Structured error responses (FastAPI-compatible) - DONE
✅ Response compression
✅ OpenAPI/Swagger docs - implemented (Some parts remaining like grouping and stuff)
✅ Django admin integration
✅ Static file serving

⚠️ API Key auth - Partial (only in-memory)
⚠️ Testing utilities - (Partially there)

✅ HEAD AND OPTIONS methods - DONE

- HEAD requests properly strip response body (RFC 7231 compliant)
- OPTIONS requests with automatic method discovery and Allow header
- Support for custom OPTIONS handlers via Response class
- CORS preflight compatible

✅ Class based views - Not implemented
guards should be funcional and should have a way to implement in python
Nice to Have (Can defer):
Pagination helpers

✅ Reloading is slow (fixed)

✅ OpenAPI error responses - DONE (422 validation errors documented)

- Automatically includes 422 validation error responses for endpoints with request bodies
- Includes detailed error schema with field-level validation messages
- Standard HTTP errors (400, 401, 403, 500) are NOT documented (well-understood)
- Configurable via `include_error_responses` in OpenAPIConfig (default: True)

⚠️ Request type maybe self.request
⚠️ Docs
✅ Openapi tags summary detail - DONE (Full implementation with tags, summary, description on all decorators)
⚠️ content negotiation
⚠️ log level setup from cli (easy to deploy)
⚠️ with broken settings it was not able to find api from root folder
✅ If api folder has error it does not discover the apis - FIXED (Now crashes with descriptive error instead of silently ignoring)
⚠️ Msgspec based serializer and stuff
✅ Fix streaming after 200 concurrent requests
⚠️ add support for actual streaming test
✅ Larger json has some GIL contention issue have done alot of investigation. Serialization hold gil when moved serialization to rust it improved but not that much .. Under large concurrency i think it happens . Have to investigate more. (Fixeed using batching gil, reuse event loop, copy memory outside of the gil)

## Known Limitations (BOTH Function & Class-Based)

These are NOT class-based view limitations - they affect both approaches:
We need to implement this. No now but someday
Query/Path Constraint Validation

Query(ge=1, le=100) and Path(min_length=3) constraints are NOT enforced at runtime

Constraints are only used for OpenAPI schema generation

Reason: Performance - avoids hot path overhead

Workaround: Manual validation or dependency injection validators

Header/Cookie Syntax
Must use Header(alias="X-API-Key") not Header("X-API-Key")
Same for Cookie(alias="session_id")
Reason: Parameter naming convention
Future: Could add FastAPI-style auto-conversion
