# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from ..._models import BaseModel
from ..stop_reason_type import StopReasonType
from .letta_message_union import LettaMessageUnion

__all__ = ["LettaResponse", "StopReason", "Usage"]


class StopReason(BaseModel):
    stop_reason: StopReasonType
    """The reason why execution stopped."""

    message_type: Optional[Literal["stop_reason"]] = None
    """The type of the message."""


class Usage(BaseModel):
    completion_tokens: Optional[int] = None
    """The number of tokens generated by the agent."""

    message_type: Optional[Literal["usage_statistics"]] = None

    prompt_tokens: Optional[int] = None
    """The number of tokens in the prompt."""

    run_ids: Optional[List[str]] = None
    """The background task run IDs associated with the agent interaction"""

    step_count: Optional[int] = None
    """The number of steps taken by the agent."""

    total_tokens: Optional[int] = None
    """The total number of tokens processed by the agent."""


class LettaResponse(BaseModel):
    messages: List[LettaMessageUnion]
    """The messages returned by the agent."""

    stop_reason: StopReason
    """The stop reason from Letta indicating why agent loop stopped execution."""

    usage: Usage
    """The usage statistics of the agent."""
