# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Dict, List, Optional
from typing_extensions import Literal

from pydantic import Field as FieldInfo

from .._models import BaseModel
from .agents.message import Message
from .stop_reason_type import StopReasonType

__all__ = ["Step"]


class Step(BaseModel):
    id: str
    """The id of the step. Assigned by the database."""

    agent_id: Optional[str] = None
    """The ID of the agent that performed the step."""

    completion_tokens: Optional[int] = None
    """The number of tokens generated by the agent during this step."""

    completion_tokens_details: Optional[Dict[str, object]] = None
    """Metadata for the agent."""

    context_window_limit: Optional[int] = None
    """The context window limit configured for this step."""

    error_data: Optional[Dict[str, object]] = None
    """Error details including message, traceback, and additional context"""

    error_type: Optional[str] = None
    """The type/class of the error that occurred"""

    feedback: Optional[Literal["positive", "negative"]] = None
    """The feedback for this step. Must be either 'positive' or 'negative'."""

    messages: Optional[List[Message]] = None
    """The messages generated during this step.

    Deprecated: use `GET /v1/steps/{step_id}/messages` endpoint instead
    """

    model: Optional[str] = None
    """The name of the model used for this step."""

    api_model_endpoint: Optional[str] = FieldInfo(alias="model_endpoint", default=None)
    """The model endpoint url used for this step."""

    origin: Optional[str] = None
    """The surface that this agent step was initiated from."""

    project_id: Optional[str] = None
    """The project that the agent that executed this step belongs to (cloud only)."""

    prompt_tokens: Optional[int] = None
    """The number of tokens in the prompt during this step."""

    provider_category: Optional[str] = None
    """The category of the provider used for this step."""

    provider_id: Optional[str] = None
    """The unique identifier of the provider that was configured for this step"""

    provider_name: Optional[str] = None
    """The name of the provider used for this step."""

    run_id: Optional[str] = None
    """The unique identifier of the run that this step belongs to.

    Only included for async calls.
    """

    status: Optional[Literal["pending", "success", "failed", "cancelled"]] = None
    """Status of a step execution"""

    stop_reason: Optional[StopReasonType] = None
    """The stop reason associated with the step."""

    tags: Optional[List[str]] = None
    """Metadata tags."""

    tid: Optional[str] = None
    """The unique identifier of the transaction that processed this step."""

    total_tokens: Optional[int] = None
    """The total number of tokens processed by the agent during this step."""

    trace_id: Optional[str] = None
    """The trace id of the agent step."""
