from typing import Optional

from sqlalchemy import String
from sqlalchemy.orm import DeclarativeBase

from cs_mcp.db.sqlalchemy import mc, M


class Jy(DeclarativeBase):
  """Base Jy model class that will be dynamically configured"""

  # 테이블 속성을 제거하여 추상 클래스로 만듦

  jy_auto: M[Optional[int]] = mc(
      default=None,
      primary_key=True,
      autoincrement=True
  )
  jy_jrauto: M[Optional[int]] = mc(default=None)
  jy_saup: M[str] = mc(String(2))
  jy_weibgu: M[str] = mc(String(1))
  jy_chart: M[str] = mc(String(8))
  jy_yuhyung: M[str] = mc(String(2))
  jy_jinchal: M[str] = mc(String(2))
  jy_dd: M[str] = mc(String(2))
  jy_ymd: M[str] = mc(String(8))
  jy_dup: M[int] = mc()
  jy_mcauto: M[Optional[int]] = mc(default=None)
  jy_yscode: M[Optional[str]] = mc(String(20), default=None)
  jy_myung: M[Optional[str]] = mc(String(255), default=None)
  jy_gu: M[Optional[str]] = mc(String(1), default=None)
  jy_wecode: M[Optional[str]] = mc(String(2), default=None)
  jy_hcode: M[Optional[str]] = mc(String(2), default=None)
  jy_mcode: M[Optional[str]] = mc(String(2), default=None)
  jy_danga: M[Optional[float]] = mc(default=None)
  jy_jumsu: M[Optional[float]] = mc(default=None)
  jy_ilto: M[Optional[float]] = mc(default=None)
  jy_haesu: M[Optional[int]] = mc(default=None)
  jy_chongto: M[Optional[int]] = mc(default=None)
  jy_htoyak: M[Optional[float]] = mc(default=None)
  jy_yongbup: M[Optional[str]] = mc(String(100), default=None)
  jy_simya: M[Optional[str]] = mc(String(1), default=None)
  jy_extendcode: M[Optional[str]] = mc(String(150), default=None)
  jy_gyobu: M[Optional[int]] = mc(default=None)
  jy_kumak: M[Optional[float]] = mc(default=None)
  jy_gumymd: M[Optional[str]] = mc(String(8), default=None)
  jy_changeymd: M[Optional[str]] = mc(String(8), default=None)
  jy_gschk: M[Optional[str]] = mc(String(1), default=None)
  jy_username: M[Optional[str]] = mc(String(20), default=None)
  jy_giwang: M[Optional[str]] = mc(String(1), default=None)
  jy_dpgubun: M[Optional[str]] = mc(String(2), default=None)
  jy_dpcode: M[Optional[str]] = mc(String(5), default=None)
  jy_sutakkiho: M[Optional[str]] = mc(String(8), default=None)
  jy_send: M[Optional[str]] = mc(String(1), default=None)
  jy_bcode: M[Optional[str]] = mc(String(2), default=None)
  jy_jcode: M[Optional[str]] = mc(String(2), default=None)
  jy_bubcode: M[str] = mc(String(2))
  jy_chamgo: M[Optional[str]] = mc(String(255), default=None)
  jy_bs: M[Optional[str]] = mc(String(1), default=None)
  jy_rilto: M[Optional[float]] = mc(default=None)
  jy_milto: M[Optional[float]] = mc(default=None)
  jy_lilto: M[Optional[float]] = mc(default=None)
  jy_dilto: M[Optional[float]] = mc(default=None)
  jy_bilto: M[Optional[float]] = mc(default=None)
  jy_ybchasu: M[Optional[str]] = mc(String(20), default=None)
  jy_etc1: M[Optional[str]] = mc(String(255), default=None)
  jy_etc2: M[Optional[str]] = mc( String(255),default=None)
  jy_etc3: M[Optional[str]] = mc( String(255),default=None)
  jy_etc4: M[Optional[str]] = mc( String(255),default=None)
  jy_etc5: M[Optional[str]] = mc( String(255),default=None)
  jy_dc: M[str] = mc(String(1))
  jy_orderday: M[Optional[str]] = mc(String(20), default=None)
  jy_orderchongto: M[Optional[int]] = mc(default=None)
  jy_ordercount: M[int] = mc()
  jy_tewonyak: M[Optional[str]] = mc(String(1), default=None)
  jy_ogu: M[Optional[str]] = mc(String(1), default=None)
  jy_owecode: M[Optional[str]] = mc(String(2), default=None)
  jy_oilto: M[Optional[float]] = mc(default=None)
  jy_ohaesu: M[Optional[int]] = mc(default=None)
  jy_ochongto: M[Optional[int]] = mc(default=None)
  jy_oyongbup: M[Optional[str]] = mc(String(100), default=None)
  jy_osimya: M[Optional[str]] = mc(String(1), default=None)
  jy_ogonghyu: M[Optional[str]] = mc(String(1), default=None)
  jy_ostat: M[Optional[str]] = mc(String(1), default=None)
  jy_ogschk: M[Optional[str]] = mc(String(1), default=None)
  jy_oextendcode: M[Optional[str]] = mc(String(150), default=None)
  jy_ochamgo: M[Optional[str]] = mc(String(255), default=None)
  jy_ogiwang: M[Optional[str]] = mc(String(1), default=None)
  jy_odpgubun: M[Optional[str]] = mc(String(2), default=None)
  jy_odpcode: M[Optional[str]] = mc(String(5), default=None)
  jy_osend: M[Optional[str]] = mc(String(1), default=None)
  jy_docdate: M[Optional[str]] = mc(String(20), default=None)
  jy_dcdate: M[Optional[str]] = mc(String(20), default=None)
  jy_pudate: M[Optional[str]] = mc(String(255), default=None)
  jy_actdate: M[Optional[str]] = mc(String(255), default=None)
  jy_docuser: M[Optional[str]] = mc(String(20), default=None)
  jy_upuser: M[Optional[str]] = mc(String(20), default=None)
  jy_dcuser: M[Optional[str]] = mc(String(20), default=None)
  jy_puuser: M[Optional[str]] = mc(String(255), default=None)
  jy_actuser: M[Optional[str]] = mc(String(255), default=None)
  jy_etc6: M[Optional[str]] = mc(String(255), default=None)
  jy_etc7: M[Optional[str]] = mc(String(255), default=None)
  jy_etc8: M[Optional[str]] = mc(String(255), default=None)
  jy_etc9: M[Optional[str]] = mc(String(255), default=None)
  jy_etc10: M[Optional[str]] = mc(String(255), default=None)
  jy_etc11: M[Optional[str]] = mc(String(255), default=None)
  jy_etc12: M[Optional[str]] = mc(String(255), default=None)
  jy_etc13: M[Optional[str]] = mc(String(255), default=None)
  jy_etc14: M[Optional[str]] = mc(String(255), default=None)
  jy_etc15: M[Optional[str]] = mc(String(255), default=None)
  jy_ordernumber: M[Optional[str]] = mc(String(30), default=None)
  jy_durnumber: M[Optional[str]] = mc(String(20), default=None)
  jy_etc16: M[Optional[str]] = mc(String(255), default=None)
  jy_etc17: M[Optional[str]] = mc(String(255), default=None)
  jy_etc18: M[Optional[str]] = mc(String(255), default=None)
  jy_etc19: M[Optional[str]] = mc(String(255), default=None)
  jy_etc20: M[Optional[str]] = mc(String(255), default=None)
  jy_daycnt: M[int] = mc()
  jy_changeorder: M[Optional[str]] = mc(String(1), default=None)
  jy_notpulv: M[Optional[str]] = mc(String(1), default=None)
  jy_onotpulv: M[Optional[str]] = mc(String(1), default=None)
  jy_etc21: M[Optional[str]] = mc(String(255), default=None)
  jy_etc22: M[Optional[str]] = mc(String(255), default=None)
  jy_etc23: M[Optional[str]] = mc(String(255), default=None)
  jy_etc24: M[Optional[str]] = mc(String(255), default=None)
  jy_etc25: M[Optional[str]] = mc(String(255), default=None)
  jy_etc26: M[str] = mc(String(50))
  jy_etc27: M[str] = mc(String(50))
  jy_etc28: M[str] = mc(String(50))
  jy_etc29: M[str] = mc(String(50))
  jy_etc30: M[str] = mc(String(50))
  jy_jgubun: M[str] = mc(String(10))
  jy_kind: M[str] = mc(String(1))
  jy_time1: M[str] = mc(String(4))
  jy_chk1: M[str] = mc(String(1))
  jy_user1: M[str] = mc(String(10))
  jy_time2: M[str] = mc(String(4))
  jy_chk2: M[str] = mc(String(1))
  jy_user2: M[str] = mc(String(10))
  jy_time3: M[str] = mc(String(4))
  jy_chk3: M[str] = mc(String(1))
  jy_user3: M[str] = mc(String(10))
  jy_time4: M[str] = mc(String(4))
  jy_chk4: M[str] = mc(String(1))
  jy_user4: M[str] = mc(String(10))
  jy_time5: M[str] = mc(String(4))
  jy_chk5: M[str] = mc(String(1))
  jy_user5: M[str] = mc(String(10))
  jy_time6: M[str] = mc(String(4))
  jy_chk6: M[str] = mc(String(1))
  jy_user6: M[str] = mc(String(10))
  jy_time7: M[str] = mc(String(4))
  jy_chk7: M[str] = mc(String(1))
  jy_user7: M[str] = mc(String(10))
  jy_time8: M[str] = mc(String(4))
  jy_chk8: M[str] = mc(String(1))
  jy_user8: M[str] = mc(String(10))
  jy_time9: M[str] = mc(String(4))
  jy_chk9: M[str] = mc(String(1))
  jy_user9: M[str] = mc(String(10))
  jy_time10: M[str] = mc(String(4))
  jy_chk10: M[str] = mc(String(1))
  jy_user10: M[str] = mc(String(10))
