from sqlalchemy import String
from cs_mcp.db.models.base import Base
from typing import Optional
from cs_mcp.db.sqlalchemy import mc, M


class Vs(Base):
  __tablename__ = "vs"  # type: ignore
  vs_auto: M[Optional[int]] = mc(default=None, primary_key=True)
  vs_saup: M[str] = mc(String(2))
  vs_chart: M[str] = mc(String(8))
  vs_ibymd: M[str] = mc(String(8))
  vs_ymd: M[str] = mc(String(8))
  vs_time: M[str] = mc(String(6))
  vs_teymd: M[Optional[str]] = mc(String(8), default=None)
  vs_yuhyung: M[Optional[str]] = mc(String(2), default=None)
  vs_bscode: M[Optional[str]] = mc(String(9), default=None)
  vs_jinchal: M[Optional[str]] = mc(String(2), default=None)
  vs_suname: M[Optional[str]] = mc(String(50), default=None)
  vs_jumin: M[Optional[str]] = mc(String(48), default=None)
  vs_nurse: M[Optional[str]] = mc(String(10), default=None)
  vs_weymd: M[Optional[str]] = mc(String(8), default=None)
  vs_hulap1: M[Optional[str]] = mc(String(10), default=None)
  vs_hulap2: M[Optional[str]] = mc(String(10), default=None)
  vs_maekbak: M[Optional[str]] = mc(String(10), default=None)
  vs_cheon: M[Optional[str]] = mc(String(10), default=None)
  vs_hohup: M[Optional[str]] = mc(String(10), default=None)
  vs_weight: M[Optional[str]] = mc(String(10), default=None)
  vs_height: M[Optional[str]] = mc(String(10), default=None)
  vs_bmi: M[Optional[str]] = mc(String(10), default=None)
  vs_intake: M[Optional[str]] = mc(String(10), default=None)
  vs_urine: M[Optional[str]] = mc(String(16), default=None)
  vs_stools: M[Optional[str]] = mc(String(16), default=None)
  vs_fluids: M[Optional[str]] = mc(String(16), default=None)
  vs_blood: M[Optional[str]] = mc(String(16), default=None)
  vs_aspiration: M[Optional[str]] = mc(String(16), default=None)
  vs_drainage: M[Optional[str]] = mc(String(16), default=None)
  vs_vomitus: M[Optional[str]] = mc(String(16), default=None)
  vs_username: M[Optional[str]] = mc(String(20), default=None)
  vs_glucose: M[Optional[str]] = mc(String(20), default=None)
  vs_spo2: M[Optional[str]] = mc(String(20), default=None)
  vs_etc1: M[Optional[str]] = mc(String(255), default=None)
  vs_etc2: M[Optional[str]] = mc(String(255), default=None)
  vs_etc3: M[Optional[str]] = mc(String(255), default=None)
  vs_etc4: M[Optional[str]] = mc(String(255), default=None)
  vs_etc5: M[Optional[str]] = mc(String(255), default=None)
  vs_dc: M[str] = mc(String(1), default="0")
  vs_indate: M[Optional[str]] = mc(String(20), default=None)
  vs_update: M[Optional[str]] = mc(String(20), default=None)
  vs_dcdate: M[Optional[str]] = mc(String(20), default=None)
  vs_upuser: M[Optional[str]] = mc(String(20), default=None)
  vs_dcuser: M[Optional[str]] = mc(String(20), default=None)
  vs_insign: M[Optional[bytes]] = mc(default=None)
  vs_upsign: M[Optional[bytes]] = mc(default=None)
  vs_dcsign: M[Optional[bytes]] = mc(default=None)
  vs_incert: M[Optional[str]] = mc(default=None)
  vs_upcert: M[Optional[str]] = mc(default=None)
  vs_dccert: M[Optional[str]] = mc(default=None)
  vs_etc6: M[Optional[str]] = mc(String(255), default=None)
  vs_etc7: M[Optional[str]] = mc(String(255), default=None)
  vs_etc8: M[Optional[str]] = mc(String(255), default=None)
  vs_etc9: M[Optional[str]] = mc(String(255), default=None)
  vs_etc10: M[Optional[str]] = mc(String(255), default=None)
  vs_shift: M[Optional[str]] = mc(String(1), default="D")
