/*
 * Decompiled with CFR 0.152.
 */
package neqsim.blackoil;

import neqsim.blackoil.BlackOilFlashResult;
import neqsim.blackoil.BlackOilPVTTable;

public final class BlackOilFlash {
    private final BlackOilPVTTable pvt;
    private final double rho_o_sc;
    private final double rho_g_sc;
    private final double rho_w_sc;

    public BlackOilFlash(BlackOilPVTTable pvt, double rho_o_sc, double rho_g_sc, double rho_w_sc) {
        this.pvt = pvt;
        this.rho_o_sc = rho_o_sc;
        this.rho_g_sc = rho_g_sc;
        this.rho_w_sc = rho_w_sc;
    }

    public BlackOilFlashResult flash(double P, double T, double Otot_std, double Gtot_std, double W_std) {
        double Ostd_liq;
        double Gf_std;
        BlackOilFlashResult r = new BlackOilFlashResult();
        double Rs = this.pvt.RsEffective(P);
        double Rv = this.pvt.Rv(P);
        if (Gtot_std <= Rs * Otot_std) {
            Gf_std = 0.0;
            Ostd_liq = Otot_std;
        } else {
            double denom = 1.0 - Rs * Rv;
            if (Math.abs(denom) < 1.0E-12) {
                denom = 1.0E-12;
            }
            if ((Gf_std = (Gtot_std - Rs * Otot_std) / denom) < 0.0) {
                Gf_std = 0.0;
            }
            if ((Ostd_liq = Otot_std - Rv * Gf_std) < 0.0) {
                Ostd_liq = 0.0;
            }
        }
        double Bo = this.pvt.Bo(P);
        double Bg = this.pvt.Bg(P);
        double Bw = this.pvt.Bw(P);
        r.O_std = Ostd_liq;
        r.Gf_std = Gf_std;
        r.W_std = W_std;
        r.V_o = Bo * Ostd_liq;
        r.V_g = Bg * Gf_std;
        r.V_w = Bw * W_std;
        r.mu_o = this.pvt.mu_o(P);
        r.mu_g = this.pvt.mu_g(P);
        r.mu_w = this.pvt.mu_w(P);
        r.rho_o = (this.rho_o_sc + Rs * this.rho_g_sc) / Math.max(Bo, 1.0E-12);
        r.rho_g = this.rho_g_sc / Math.max(Bg, 1.0E-12);
        r.rho_w = this.rho_w_sc / Math.max(Bw, 1.0E-12);
        r.Rs = Rs;
        r.Rv = Rv;
        r.Bo = Bo;
        r.Bg = Bg;
        r.Bw = Bw;
        return r;
    }
}

