/*
 * Decompiled with CFR 0.152.
 */
package neqsim.blackoil;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToDoubleFunction;

public class BlackOilPVTTable {
    private final List<Record> recs = new ArrayList<Record>();
    private final double bubblePointP;

    public BlackOilPVTTable(List<Record> records, double bubblePointP) {
        this.recs.addAll(records);
        this.recs.sort(Comparator.comparingDouble(r -> r.p));
        if (this.recs.isEmpty()) {
            throw new IllegalArgumentException("Empty PVT table");
        }
        this.bubblePointP = bubblePointP;
    }

    public double getBubblePointP() {
        return this.bubblePointP;
    }

    private double lin(double p, ToDoubleFunction<Record> f) {
        if (p <= this.recs.get((int)0).p) {
            return f.applyAsDouble(this.recs.get(0));
        }
        if (p >= this.recs.get((int)(this.recs.size() - 1)).p) {
            return f.applyAsDouble(this.recs.get(this.recs.size() - 1));
        }
        for (int i = 0; i < this.recs.size() - 1; ++i) {
            Record a = this.recs.get(i);
            Record b = this.recs.get(i + 1);
            if (!(p >= a.p) || !(p <= b.p)) continue;
            double t = (p - a.p) / (b.p - a.p);
            return f.applyAsDouble(a) * (1.0 - t) + f.applyAsDouble(b) * t;
        }
        return f.applyAsDouble(this.recs.get(this.recs.size() - 1));
    }

    public double Rs(double p) {
        return this.lin(p, r -> r.Rs);
    }

    public double Bo(double p) {
        return this.lin(p, r -> r.Bo);
    }

    public double mu_o(double p) {
        return this.lin(p, r -> r.mu_o);
    }

    public double Bg(double p) {
        return this.lin(p, r -> r.Bg);
    }

    public double mu_g(double p) {
        return this.lin(p, r -> r.mu_g);
    }

    public double Rv(double p) {
        return this.lin(p, r -> r.Rv);
    }

    public double Bw(double p) {
        return this.lin(p, r -> r.Bw);
    }

    public double mu_w(double p) {
        return this.lin(p, r -> r.mu_w);
    }

    public double RsEffective(double p) {
        return p > this.bubblePointP ? this.Rs(this.bubblePointP) : this.Rs(p);
    }

    public static final class Record {
        public final double p;
        public final double Rs;
        public final double Bo;
        public final double mu_o;
        public final double Bg;
        public final double mu_g;
        public final double Rv;
        public final double Bw;
        public final double mu_w;

        public Record(double p, double Rs, double Bo, double mu_o, double Bg, double mu_g, double Rv, double Bw, double mu_w) {
            this.p = p;
            this.Rs = Rs;
            this.Bo = Bo;
            this.mu_o = mu_o;
            this.Bg = Bg;
            this.mu_g = mu_g;
            this.Rv = Rv;
            this.Bw = Bw;
            this.mu_w = mu_w;
        }
    }
}

